//<?
			// (c) Copyright Mark McIlroy 2022

			
#define VAR_EMPTY			0
#define VAR_STRING			1		// string, date, time, datetime data types
#define VAR_INT				2		// int and bool data types
#define VAR_DECIMAL			3
#define VAR_DOUBLE			4
#define VAR_BINARY			5
#define VAR_RESIZABLE_ARRAY 6
#define VAR_POINTER			7

#define true			1
#define false			0

#define VAR_DECIMAL_SCALE 	100
#define VAR_DECIMAL_ROUNDING_OFFSET		0.5

#define MAX_NESTED_FUNCTION_CALLS 		 100000

#define MAX_FUNCTION_TABLE_ITEMS 		 10000

#define STRING_BUFFER_SIZE				1000000


//#define PUSH_FLAGS_PRE_INC 	1
//#define PUSH_FLAGS_PRE_DEC 	2
//#define PUSH_FLAGS_POST_INC 	4
//#define PUSH_FLAGS_POST_DEC 	8

//#define MAX_INDIRECTION_LEVELS  1000

#define MAX_ARGC				100

#define MAX_INPUT_FILES  		1000

#define MAX_RARRAY_DIMENSIONS 	15

#define MAX_QUERIES 			10000

#define MAX_OPS					300

#define MAX_USER_FUNCTIONS		100000

#define MAX_STR_CONCAT			1000


// Size of the VAR structure. If updating this also update it in config.php and library_calc.calch

//#define SIZEOF_VAR 			16
//#define SIZEOF_VAR_x_2		32



// Data types for the generated code. int_64 is intended to be a 64 bit integer however this is not actually required,
//     it can be defined as a type that results in a 32 bit integer for smaller systems.


typedef long int 	int_64;
typedef int 		int_32;
typedef short int 	int_16;
typedef char 		int_8;


#define VAR_SHORT_STRING_MAX_SIZE	128

#define VAR_CONSTANT_STRING		1
#define VAR_DYNAMIC_STORAGE		2
#define VAR_SHORT_STRING		3

#include "calc_structures.h"



typedef struct
{
	char *datap;
	int number_of_dimensions;
	int sizeof_array_element;
	int_64 total_size;					// number of bytes
	int_64 index_size[15];				// number of elements
} rarray;


typedef struct
{
	char *data_ptr;
	char status;						// 1 = active, 2 = has been freed
	char *type_map;
	int_64 block_size;
} dyn_block;


void *_malloc( int_64 size );
void *_malloc_initialised( int_64 size );
void _free( void *ptr );

void str_u8_to_u32( unsigned char *dest, char *src );
void str_u32_to_u8( char *dest, unsigned char *src, int dest_size );

char *rarray_deref( char **result, char *sp, char *source_file_id_txt, int number_dimensions, ... );
char *rarray_deref_no_debug( char **result, char *sp, int number_dimensions, ... );

char *str_concat( char *ptr, char *source_file_id_txt, int count, ... );
char *str_concat_no_debug( char *vptr3, int num_items, ... );

void setsize( char *vptr2, long int element_size, long int number_dimensions, char *source_file_id_txt, ... );

char *		_calcsys_check_link( char *ptr, char *required_type_map, char *source_file_id_txt );
char *		_calcsys_check_link_no_checks( char *ptr );

long int *		_calcsys_set_register_i( long int *iptr, long int x );
long double *	_calcsys_set_register_ld( long double *iptr, long double x );
char *			_calcsys_set_register_b( char *iptr, char x );
long int *		_calcsys_set_register_d( long int *dptr, long int x );
double *		_calcsys_set_register_n( double *nptr, double x );
char *			_calcsys_set_register_s( char *sstr, char *str, char *source_file_id_txt );
char *			_calcsys_set_register_s_no_debug( char *sstr, char *str );
char **			_calcsys_set_register_p( char **sstr, char *str );

long int 	_calcsys_xor( long int x1, long int x2 );

double 		_calcsys_conv_decimal_to_double( long int x );
long double _calcsys_conv_decimal_to_long_double( long int x );
long int 	_calcsys_conv_decimal_to_int( long int x );
long int 	_calcsys_conv_int_to_decimal( long int x );
long int 	_calcsys_conv_double_to_decimal( double x );
long int 	_calcsys_conv_long_double_to_decimal( long double x );

void 		_calcsys_check_link_type( char *function_name, char *required_type_map, char *actual_type_map );
long int 	_calcsys_array_bounds_check( int index_number, long int max_size, long int curr_size, char *source_file_id_txt );
void 		_calcsys_str_append( char *str1, char *str2, char *source_file_id_txt );

long int 	_calcsys_decimal_div( long int x1, long int x2, char *source_file_id_txt );
long int 	_calcsys_decimal_mult( long int x1, long int x2 );
double 		_calcsys_double_pow( double x1, double x2, char *source_file_id_txt );
long double _calcsys_long_double_pow( long double x1, long double x2, char *source_file_id_txt );
 
char	 	_calcsys_div_check_0_byte( char x1, char x2, char *source_file_id_txt );
short int 	_calcsys_div_check_0_short_int( short int x1, short int x2, char *source_file_id_txt );
int 		_calcsys_div_check_0_medium_int( int x1, int x2, char *source_file_id_txt );
long int 	_calcsys_div_check_0_int( long int x1, long int x2, char *source_file_id_txt );
float 		_calcsys_div_check_0_float( float x1, float x2, char *source_file_id_txt );
double 		_calcsys_div_check_0_double( double x1, double x2, char *source_file_id_txt );
long double _calcsys_div_check_0_long_double( long double x1, long double x2, char *source_file_id_txt );

long int 	_calcsys_decimal_pow( long int x1, long int x2, char *source_file_id_txt );
long int 	_calcsys_int_pow( long int x1, long int x2, char *source_file_id_txt );

char *		_calcsys_conv_link_to_string( char *str, char *x );
char *		_calcsys_conv_int_to_string( char *str, long int x );
char *		_calcsys_conv_decimal_to_string( char *str, long int x );
char *		_calcsys_conv_double_to_string( char *str, double x );
char *		_calcsys_conv_bool_to_string( char *str, long int x );
char *		_calcsys_conv_binary_to_string( char *str, char *vptr );
char *		_calcsys_conv_long_double_to_string( char *str, long double x );

void dec_to_hex( char *dest, unsigned char *src, int_64 num_bytes, int asc, int pad_with_leading_zeros );

void var_clear( var *vptr );
void var_clear_b( var *vptr, char *source_file_id_txt );
void copy_var( var *vptr_dest, var *vptr_src, char *source_file_id_txt );
void copy_var_no_debug( var *vptr_dest, var *vptr_src );
int get_var_type( char *vptr );
void set_var_type( char *vptr, int var_type );
char *rarray_calc_pos( rarray *rarray_ptr, int_64 *curr_item );


void runtime_error( char const *source_file_id_txt, int error_number, char const *text, char const *extra_text );

int isset( var *vptr );
void trim_trailing_zeros( char *s );

void calc_stdlib_exit( char *filename );

void calc_stdlib_init( char *get_and_post_filename );
void _calcsys_var_set_s( var *vptr, char *s, char *source_file_id_txt );
void _calcsys_var_set_s_u32( var *vptr, unsigned char *s, int is_constant_string, char const *source_file_id_txt );
void _calcsys_var_set_s_as_constant( var *vptr, char *source_file_id_txt );
void var_set_b( var *vptr, var *vptr_src, char *source_file_id_txt );
void var_set_b_2( var *vptr, char *bits, int num_bytes, char *source_file_id_txt );
void var_set_p( var *vptr, void *ptr, char *source_file_id_txt );
void var_copy_rarray_p( var *vptr_dest, var *vptr_src, int sizeof_var, int line_number, char *input_filename, char *source_file_id_txt );
void var_clear_b( var *vptr, char *source_file_id_txt );
void var_check_s( var *vptr, char *source_file_id_txt );
int str_u32_eq( unsigned char *str1, unsigned char *str2, char *source_file_id_txt );
int str_u32_cmp( unsigned char *str1, unsigned char *str2, char *source_file_id_txt );
void free_curr_mem( char *vptr, int sizeof_var, int_64 len );
void free_curr_mem_1( var *vptr, const char *source_file_id_txt );

char *op_setsize_1( int sizeof_var, int_64 element_size, rarray **rarray_ptr2, char *source_file_id_txt );
void op_setsize_2( char *vptr, rarray *rarray_ptr, int sizeof_var, int_64 element_size, char *source_file_id_txt );
