//<? Turn on PHP editor syntax highlighting

#include "mysql.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "calc.h"


#define MEDIUM_STRING_BUFFER_SIZE 	100000

#define MAX_QUERIES 			10000


#define INIT_CHECK_VALUE	123456


MYSQL *cxn2;
MYSQL_RES *result1[MAX_QUERIES];
MYSQL_ROW current_row[MAX_QUERIES];
char *str_query[MAX_QUERIES];
int db_item_in_use[MAX_QUERIES];
int num_query_items;
int init_check;


//--------------------------------------------------------------------------
// Calc-MySQL interface
//--------------------------------------------------------------------------
				
		void _calc_calc_mysql_init( var *result )
		{
		    int i;
			
		    num_query_items = 0;
		    
		    for (i=0; i < MAX_QUERIES; i++)
		    {
		    	db_item_in_use[i] = false;
				str_query[i] = NULL;
			}
			
			cxn2 = NULL;
			
			init_check = INIT_CHECK_VALUE;
		}
		
		
		char *_calc_db_login( var *result, var *var_arg1, var *var_arg2, var *var_arg3, char *source_file_id_txt )
		{
			char s1[MEDIUM_STRING_BUFFER_SIZE];
			char s2[MEDIUM_STRING_BUFFER_SIZE];
			char s3[MEDIUM_STRING_BUFFER_SIZE];
			
			if (init_check != INIT_CHECK_VALUE)		{ printf( "Please call calc_mysql_init() at the start of main() to use the Calc MySQL library." );	exit(1);	}
			
			var_check_s( var_arg1, source_file_id_txt );
			var_check_s( var_arg2, source_file_id_txt );
			var_check_s( var_arg3, source_file_id_txt );

			if (cxn2 == NULL)
			{
				cxn2 = mysql_init(NULL);
			
				if (cxn2 == NULL)
					runtime_error( source_file_id_txt, 1035, "NULL on db_login()", "" );
			
					// refer to command line utility mysql_config for socket address
				
				str_u32_to_u8( s1, var_arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
				str_u32_to_u8( s2, var_arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
				str_u32_to_u8( s3, var_arg3->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
				
				if (mysql_real_connect( cxn2, "localhost", s2, s3, s1, 0, "/var/lib/mysql/mysql.sock", 0 ) == NULL)
					runtime_error( source_file_id_txt, 1036, "fail on db_connect()", "" );
			}
			
			var_set_p( result, cxn2, 0 );

			return ((char *) result);
		}
			
			
		void _calc_db_close_connection( var *var_arg1 )
		{
			mysql_close( cxn2 );
			
			cxn2 = NULL;
		}
			
				
		char *_calc_db_prep_string_for_sql( var *result, var *var_arg1, char *source_file_id_txt )
		{
			char *ptr, *ptr2;
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			char s1[MEDIUM_STRING_BUFFER_SIZE];
			
			if (init_check != INIT_CHECK_VALUE)		{ printf( "Please call calc_mysql_init() at the start of main() to use the Calc MySQL library." );	exit(1);	}
						
			var_check_s( var_arg1, source_file_id_txt );
			
			ptr2 = str4;
					
			str_u32_to_u8( s1, var_arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			ptr = s1;
			
			while (*ptr != '\0')
			{
				if (*ptr == '\'')
				{
					*ptr2++ = '\'';
					*ptr2++ = '\'';
					ptr++;
				}
				else
					*ptr2++ = *ptr++;
			}

			*ptr2 = '\0';
			
			_calcsys_var_set_s( result, str4, source_file_id_txt );

			return ((char *) result);
		}
			
				
		char *_calc_db_run_query( var *result, var *var_arg1, var *var_arg2, char *source_file_id_txt )
		{
			int i, item;
			char s1[MEDIUM_STRING_BUFFER_SIZE];
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			if (init_check != INIT_CHECK_VALUE)		{ printf( "Please call calc_mysql_init() at the start of main() to use the Calc MySQL library." );	exit(1);	}
			
			item = -1;
			
			for (i=0; (item == -1) && (i < num_query_items); i++)
			{
				if (! db_item_in_use[i])
					item = i;
			}
			
			if (item == -1)
			{
				if (num_query_items >= MAX_QUERIES)
				{
						// uncomment this code to view which queries aren't being freed
			
//					for (i=0; i < MAX_QUERIES; i++)
//						printf( "%s<br>", str_query[i] );
				
					runtime_error( source_file_id_txt, 1075, "Too many active queries, call db_free_result() on finished queries.", "" );
				}
						
				item = num_query_items;
				num_query_items++;
			}
					
			db_item_in_use[item] = true;
			
			var_check_s( var_arg1, source_file_id_txt );

			str_u32_to_u8( s1, var_arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		
		
			if (mysql_query( cxn2, s1 ))
			{
				strncpy( str, s1, 5000 );
				str[5000] = '\0';

				strcat( str, " : " );
				
				strcat( str, mysql_error( cxn2 ) );
			
				runtime_error( source_file_id_txt, 1037, "MySQL query returned fail:", str );
			}
			
			if (item >= MAX_QUERIES)
			{
					// uncomment this code to view which queries aren't being freed
			
//				for (i=0; i < MAX_QUERIES; i++)
//					printf( "%s<br>", str_query[i] );

				runtime_error( source_file_id_txt, 1076, "Too many queries in db_run_query(), call db_free_result() on finished queries.", "" );
			}
			
			result1[item] = mysql_store_result( cxn2 );

			if (str_query[item] == NULL)
				str_query[item] = _malloc( strlen( s1 ) + 1 );
			else
			{
				if (strlen( s1 ) > strlen( str_query[item] ))
				{ 
					_free( str_query[item] );
				
					str_query[item] = _malloc( strlen( s1 ) + 1 );
				}
			}
			
			strcpy( str_query[item], s1 );

			*((long int *) result) = item;
			
			num_query_items++;

			return ((char *) result);
		}
		
		
		void _calc_db_free_result( var *var_arg1, var *var_arg2, char *source_file_id_txt )
		{
			int qry_num;

			if (init_check != INIT_CHECK_VALUE)		{ printf( "Please call calc_mysql_init() at the start of main() to use the Calc MySQL library." );	exit(1);	}

			qry_num = *((long int *) var_arg1);

			if (str_query[qry_num] == NULL)
			{
				printf( "Attempted double free %s\n.", source_file_id_txt );	
				exit(1);	
			}				
			
			mysql_free_result( result1[qry_num] );
		
			db_item_in_use[qry_num] = false;
			
			if (str_query[qry_num] != NULL)
				_free( str_query[qry_num] );
			
			str_query[qry_num] = NULL;			
		}
		

		char _calc_db_query_has_rows( var *var_arg1, var *var_arg2, char *source_file_id_txt )
		{
			MYSQL_RES *result2;
			char s1[MEDIUM_STRING_BUFFER_SIZE];
			char str[MEDIUM_STRING_BUFFER_SIZE];
			int stat;
			
			var_check_s( var_arg1, source_file_id_txt );

			str_u32_to_u8( s1, var_arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		
			if (strstr( s1, "limit" ) == NULL && strstr( s1, "LIMIT" ) == NULL)
				strcat( s1, " LIMIT 1" );
				  
			if (mysql_query( cxn2, s1 ))
			{
				strncpy( str, s1, 5000 );
				str[5000] = '\0';

				strcat( str, " : " );
				
				strcat( str, mysql_error( cxn2 ) );
			
				runtime_error( source_file_id_txt, 1037, "MySQL query returned fail:", str );
			}
			
			result2 = mysql_store_result( cxn2 );
			
			if (mysql_num_rows( result2 ) > 0)
				stat = 1;
			else
				stat = 0;
			
			mysql_free_result( result2 );
			
			return (stat);
		}

		
		long int _calc_db_query_num_rows( var *var_arg1, var *var_arg2, char *source_file_id_txt )
		{
			int num_rows;
			int qry_num;

			if (init_check != INIT_CHECK_VALUE)		{ printf( "Please call calc_mysql_init() at the start of main() to use the Calc MySQL library." );	exit(1);	}
			
			qry_num = *((long int *) var_arg1);
			
			if (qry_num < 0 || qry_num >= num_query_items)
				runtime_error( source_file_id_txt, 1050, "Invalid query number in db_query_num_rows()", "" );
			
			if (result1[qry_num] == NULL)
				runtime_error( source_file_id_txt, 1051, "NULL result in db_query_num_rows()", "" );
			
			num_rows = mysql_num_rows( result1[qry_num] );
			
			return ( num_rows );
		}
		

		char *_calc_db_get_row( var *result, var *var_arg1, var *var_arg2, char *source_file_id_txt )
		{
			int qry_num;

			if (init_check != INIT_CHECK_VALUE)		{ printf( "Please call calc_mysql_init() at the start of main() to use the Calc MySQL library." );	exit(1);	}

			qry_num = *((long int *) var_arg1);
			
			current_row[qry_num] = mysql_fetch_row( result1[qry_num] );

			if (current_row[qry_num] == NULL)
				runtime_error( source_file_id_txt, 1051, "NULL value in db_get_row(), no rows returned or db_get_row() called beyond the number of returned rows", str_query[qry_num] );
			
			*((long int *) result) = qry_num;

			return ((char *) result);
		}

		char _calc_db_field_is_null( var *var_arg1, var *var_arg2, char *source_file_id_txt )
		{
			char s1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			int found;
			int qry_num;
			int i;
			int result;
			int num_fields;
			MYSQL_FIELD *field_defn;

			if (init_check != INIT_CHECK_VALUE)		{ printf( "Please call calc_mysql_init() at the start of main() to use the Calc MySQL library." );	exit(1);	}

			qry_num = *((long int *) var_arg2);

			if (qry_num < 0 || qry_num >= num_query_items)
				runtime_error( source_file_id_txt, 1058, "Invalid query number", "" );

			var_check_s( var_arg1, source_file_id_txt );

			found = false;
			
			num_fields = mysql_num_fields( result1[qry_num] );

				// qry field names
			
			str_u32_to_u8( s1, var_arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			for (i=0; (! found) && i < num_fields; i++)
			{
				field_defn = mysql_fetch_field_direct( result1[qry_num], i );
				
				if (strcmp( field_defn->name, s1 ) == 0)
				{
					found = true;

					if (current_row[qry_num][i] == NULL)
						result = 1;
					else						
						result = 0;
				}
			}
			
			if (! found)
			{
				strcpy( str4, s1 );
				strcat( str4, ": " );
				strcat( str4, str_query[qry_num] );
			
				runtime_error( source_file_id_txt, 1039, "Field not found", str4 );
			}
			
			return (result); 
		}


		char _calc_db_field_is_in_query( var *var_arg1, var *var_arg2, char *source_file_id_txt )
		{
			char s1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			int found;
			int qry_num;
			int i;
			int result;
			int num_fields;
			MYSQL_FIELD *field_defn;

			if (init_check != INIT_CHECK_VALUE)		{ printf( "Please call calc_mysql_init() at the start of main() to use the Calc MySQL library." );	exit(1);	}

			qry_num = *((long int *) var_arg2);

			if (qry_num < 0 || qry_num >= num_query_items)
				runtime_error( source_file_id_txt, 1058, "Invalid query number", "" );

			var_check_s( var_arg1, source_file_id_txt );

			found = false;
			
			num_fields = mysql_num_fields( result1[qry_num] );

				// qry field names
			
			str_u32_to_u8( s1, var_arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			for (i=0; (! found) && i < num_fields; i++)
			{
				field_defn = mysql_fetch_field_direct( result1[qry_num], i );
				
				if (strcmp( field_defn->name, s1 ) == 0)
					found = true;
			}
			
			return (found); 
		}
				
		char *_calc_db_get_field_string( var *result, var *var_arg1, var *var_arg2, char *source_file_id_txt )
		{
			char s1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			int found;
			int qry_num;
			int i;
			int num_fields;
			MYSQL_FIELD *field_defn;

			if (init_check != INIT_CHECK_VALUE)		{ printf( "Please call calc_mysql_init() at the start of main() to use the Calc MySQL library." );	exit(1);	}

			qry_num = *((long int *) var_arg2);

			if (qry_num < 0 || qry_num >= num_query_items)
				runtime_error( source_file_id_txt, 1058, "Invalid query number", "" );

			var_check_s( var_arg1, source_file_id_txt );

			found = false;
			
			num_fields = mysql_num_fields( result1[qry_num] );

				// qry field names
			
			str_u32_to_u8( s1, var_arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			for (i=0; (! found) && i < num_fields; i++)
			{
				field_defn = mysql_fetch_field_direct( result1[qry_num], i );
				
				if (strcmp( field_defn->name, s1 ) == 0)
				{
					found = true;

					if (current_row[qry_num][i] == NULL)
						_calcsys_var_set_s( result, "", source_file_id_txt );
					else						
						_calcsys_var_set_s( result, current_row[qry_num][i], source_file_id_txt );
				}
			}
			
			if (! found)
			{
				strcpy( str4, s1 );
				strcat( str4, ": " );
				strcat( str4, str_query[qry_num] );
			
				runtime_error( source_file_id_txt, 1039, "Field not found", str4 );
			}

			return ((char *) result);
		}

				
		char _calc_db_get_field_bool( var *var_arg1, var *var_arg2, char *source_file_id_txt )
		{
			char s1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			int found;
			int qry_num;
			int result;
			int i;
			int num_fields;
			MYSQL_FIELD *field_defn;

			if (init_check != INIT_CHECK_VALUE)		{ printf( "Please call calc_mysql_init() at the start of main() to use the Calc MySQL library." );	exit(1);	}

			qry_num = *((long int *) var_arg2);

			if (qry_num < 0 || qry_num >= num_query_items)
				runtime_error( source_file_id_txt, 1059, "Invalid query number", "" );

			var_check_s( var_arg1, source_file_id_txt );

			found = false;
			
			num_fields = mysql_num_fields( result1[qry_num] );

				// qry field names
				
			str_u32_to_u8( s1, var_arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
								
			for (i=0; (! found) && i < num_fields; i++)
			{
				field_defn = mysql_fetch_field_direct( result1[qry_num], i );
				
				if (strcmp( field_defn->name, s1 ) == 0)
				{
					found = true;
				
					if (current_row[qry_num][i] == NULL)
						result = 0;
					else
					{					
						if (strcmp( current_row[qry_num][i] , "1" ) == 0)
							result = 1;
						else
							result = 0;
					}
				}					
			}
			
			if (! found)
			{
				strcpy( str4, s1 );
				strcat( str4, ": " );
				strcat( str4, str_query[qry_num] );
			
				runtime_error( source_file_id_txt, 1040, "Field not found", str4 );
			}
			
			return (result);
		}

		long int _calc_db_get_field_int( var *var_arg1, var *var_arg2, char *source_file_id_txt )
		{
			char s1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			int found;
			int qry_num;
			long int result;
			int i;
			int num_fields;
			MYSQL_FIELD *field_defn;

			if (init_check != INIT_CHECK_VALUE)		{ printf( "Please call calc_mysql_init() at the start of main() to use the Calc MySQL library." );	exit(1);	}

			qry_num = *((long int *) var_arg2);

			if (qry_num < 0 || qry_num >= num_query_items)
				runtime_error( source_file_id_txt, 1060, "Invalid query number", "" );

			var_check_s( var_arg1, source_file_id_txt );

			found = false;
			
			num_fields = mysql_num_fields( result1[qry_num] );

				// qry field names
				
			str_u32_to_u8( s1, var_arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
								
			for (i=0; (! found) && i < num_fields; i++)
			{
				field_defn = mysql_fetch_field_direct( result1[qry_num], i );
				
				if (strcmp( field_defn->name, s1 ) == 0)
				{
					found = true;
				
					if (current_row[qry_num][i] == NULL)
						result = 0;
					else
						result = atol( current_row[qry_num][i] );
				}
			}
			
			if (! found)
			{
				strcpy( str4, s1 );
				strcat( str4, ": " );
				strcat( str4, str_query[qry_num] );
			
				runtime_error( source_file_id_txt, 1041, "Field not found", str4 );
			}
			
			return (result);
		}

		long int _calc_db_get_field_decimal( var *var_arg1, var *var_arg2, char *source_file_id_txt )
		{
			char s1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			int found;
			int qry_num;
			long int result;
			int i;
			int num_fields;
			MYSQL_FIELD *field_defn;

			if (init_check != INIT_CHECK_VALUE)		{ printf( "Please call calc_mysql_init() at the start of main() to use the Calc MySQL library." );	exit(1);	}

			qry_num = *((long int *) var_arg2);

			if (qry_num < 0 || qry_num >= num_query_items)
				runtime_error( source_file_id_txt, 1061, "Invalid query number", "" );

			var_check_s( var_arg1, source_file_id_txt );
			
			found = false;
			
			num_fields = mysql_num_fields( result1[qry_num] );

				// qry field names
				
			str_u32_to_u8( s1, var_arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
								
			for (i=0; (! found) && i < num_fields; i++)
			{
				field_defn = mysql_fetch_field_direct( result1[qry_num], i );
				
				if (strcmp( field_defn->name, s1 ) == 0)
				{
					found = true;
					
					if (current_row[qry_num][i] == NULL)
						result = 0;
					else
						result = (long int) round( atof( current_row[qry_num][i] ) * (double) VAR_DECIMAL_SCALE );
				}
			}
			
			if (! found)
			{
				strcpy( str4, s1 );
				strcat( str4, ": " );
				strcat( str4, str_query[qry_num] );
				
				runtime_error( source_file_id_txt, 1042, "Field not found", str4 );
			}
			
			return (result);
		}

		double _calc_db_get_field_double( var *var_arg1, var *var_arg2, char *source_file_id_txt )
		{
			char s1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			int found;
			int qry_num;
			double result;
			int i;
			int num_fields;
			MYSQL_FIELD *field_defn;

			if (init_check != INIT_CHECK_VALUE)		{ printf( "Please call calc_mysql_init() at the start of main() to use the Calc MySQL library." );	exit(1);	}

			qry_num = *((long int *) var_arg2);

			if (qry_num < 0 || qry_num >= num_query_items)
				runtime_error( source_file_id_txt, 1062, "Invalid query number", "" );

			var_check_s( var_arg1, source_file_id_txt );

			found = false;
			
			num_fields = mysql_num_fields( result1[qry_num] );

				// qry field names
				
			str_u32_to_u8( s1, var_arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
								
			for (i=0; (! found) && i < num_fields; i++)
			{
				field_defn = mysql_fetch_field_direct( result1[qry_num], i );
				
				if (strcmp( field_defn->name, s1 ) == 0)
				{
					found = true;
				
					if (current_row[qry_num][i] == NULL)
						result = 0;
					else
						result = atof( current_row[qry_num][i] );
				}
			}
			
			if (! found)
			{
				strcpy( str4, s1 );
				strcat( str4, ": " );
				strcat( str4, str_query[qry_num] );
			
				runtime_error( source_file_id_txt, 1043, "Field not found", str4 );
			}
			
			return (result);
		}

		char *_calc_db_get_field_date( var *result, var *var_arg1, var *var_arg2, char *source_file_id_txt )
		{
			char s1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			int found;
			int qry_num;
			int i;
			int num_fields;
			MYSQL_FIELD *field_defn;

			if (init_check != INIT_CHECK_VALUE)		{ printf( "Please call calc_mysql_init() at the start of main() to use the Calc MySQL library." );	exit(1);	}

			qry_num = *((long int *) var_arg2);

			if (qry_num < 0 || qry_num >= num_query_items)
				runtime_error( source_file_id_txt, 1063, "Invalid query number", "" );

			var_check_s( var_arg1, source_file_id_txt );

			found = false;
			
			num_fields = mysql_num_fields( result1[qry_num] );

				// qry field names
				
			str_u32_to_u8( s1, var_arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
								
			for (i=0; (! found) && i < num_fields; i++)
			{
				field_defn = mysql_fetch_field_direct( result1[qry_num], i );
				
				if (strcmp( field_defn->name, s1 ) == 0)
				{
					found = true;
				
					if (current_row[qry_num][i] == NULL)
						_calcsys_var_set_s( result, "0000-00-00", source_file_id_txt );
					else
					{
						if (current_row[qry_num][i] == "")
							_calcsys_var_set_s( result, "0000-00-00", source_file_id_txt );
						else
							_calcsys_var_set_s( result, current_row[qry_num][i], source_file_id_txt );
					}
				}
			}
			
			if (! found)
			{
				strcpy( str4, s1 );
				strcat( str4, ": " );
				strcat( str4, str_query[qry_num] );
			
				runtime_error( source_file_id_txt, 1044, "Field not found", str4 );
			}

			return ((char *) result);
		}

		char *_calc_db_get_field_time( var *result, var *var_arg1, var *var_arg2, char *source_file_id_txt )
		{
			char s1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			int found;
			int qry_num;
			int i;
			int num_fields;
			MYSQL_FIELD *field_defn;

			if (init_check != INIT_CHECK_VALUE)		{ printf( "Please call calc_mysql_init() at the start of main() to use the Calc MySQL library." );	exit(1);	}

			qry_num = *((long int *) var_arg2);

			if (qry_num < 0 || qry_num >= num_query_items)
				runtime_error( source_file_id_txt, 1064, "Invalid query number", "" );
				
			var_check_s( var_arg1, source_file_id_txt );

			found = false;
			
			num_fields = mysql_num_fields( result1[qry_num] );

				// qry field names
				
			str_u32_to_u8( s1, var_arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
								
			for (i=0; (! found) && i < num_fields; i++)
			{
				field_defn = mysql_fetch_field_direct( result1[qry_num], i );
				
				if (strcmp( field_defn->name, s1 ) == 0)
				{
					found = true;

					if (current_row[qry_num][i] == NULL)
						_calcsys_var_set_s( result, "99:99:99", source_file_id_txt );
					else
					{
						if (current_row[qry_num][i] == "")
							_calcsys_var_set_s( result, "99:99:99", source_file_id_txt );
						else
							_calcsys_var_set_s( result, current_row[qry_num][i], source_file_id_txt );
					}
				}
			}
			
			if (! found)
			{
				strcpy( str4, s1 );
				strcat( str4, ": " );
				strcat( str4, str_query[qry_num] );
			
				runtime_error( source_file_id_txt, 1045, "Field not found", str4 );
			}

			return ((char *) result);
		}

		char *_calc_db_get_field_datetime( var *result, var *var_arg1, var *var_arg2, char *source_file_id_txt )
		{
			char s1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			int found;
			int qry_num;
			int i;
			int num_fields;
			MYSQL_FIELD *field_defn;

			if (init_check != INIT_CHECK_VALUE)		{ printf( "Please call calc_mysql_init() at the start of main() to use the Calc MySQL library." );	exit(1);	}

			qry_num = *((long int *) var_arg2);

			if (qry_num < 0 || qry_num >= num_query_items)
				runtime_error( source_file_id_txt, 1065, "Invalid query number", "" );

			var_check_s( var_arg1, source_file_id_txt );

			found = false;
			
			num_fields = mysql_num_fields( result1[qry_num] );

				// qry field names

			str_u32_to_u8( s1, var_arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
								
			for (i=0; (! found) && i < num_fields; i++)
			{
				field_defn = mysql_fetch_field_direct( result1[qry_num], i );
				
				if (strcmp( field_defn->name, s1 ) == 0)
				{
					found = true;
				
					if (current_row[qry_num][i] == NULL)
						_calcsys_var_set_s( result, "0000-00-00 99:99:99", source_file_id_txt );
					else
					{
						if (current_row[qry_num][i] == "")
							_calcsys_var_set_s( result, "0000-00-00 99:99:99", source_file_id_txt );
						else
							_calcsys_var_set_s( result, current_row[qry_num][i], source_file_id_txt );
					}
				}
			}
			
			if (! found)
			{
				strcpy( str4, s1 );
				strcat( str4, ": " );
				strcat( str4, str_query[qry_num] );
				
				runtime_error( source_file_id_txt, 1046, "Field not found", str4 );
			}

			return ((char *) result);
		}
		
	