//<?		// Turn on editor syntax highlighting

                              // (c) Copyright Mark McIlroy 2023

		// interface functions to call the interpreter from compiled code
		
    using namespace std;
                              
    #include <string>
    #include <iostream>
    #include <cstdlib>
    #include <cmath>
    
    #include "ci_calc.h"

    #include "../calc_structures.h"
                
    #include "library.cpph"

	
	
	//	source_code_language_file = "english.calclanguage";

extern int is_web_page;
	
char *ci_error_messages[MAX_CI_ERROR_MESSAGES];
int num_ci_error_messages;


void save_and_set_runtime_data_ptr( char *runtime_data_ptr );
void restore_runtime_data_ptr();

	
	extern "C" char _calc_calc_interpreter_run_program( char *runtime_data_ptr,
														ci_var *c_program, 
													   ci_var *c_input_filename, 
													   ci_var *c_include_path1,
													   ci_var *c_include_path2,
													   ci_var *c_include_path3,
													   ci_var *c_include_path4,
													   ci_var *c_include_path5,
													   char c_show_scan_trace, 
													   char c_show_icode,
													   char c_run_code, 
													   char c_show_execution_trace,
													   char c_array_bounds_checks, 
													   char c_runtime_checks, 
													   char c_show_warnings, 
													   char c_command_line_mode,
													   char c_show_additional_warnings, 
													   char c_show_large_strings_warnings,
													   char c_init_globals,
													   char c_is_web_page,
													   char *source_file_id )
	{
		string program; 
		string input_filename; 
		string include_paths[MAX_INCLUDE_PATHS]; 
		char *txt_program; 
		int program_size;
		char txt_input_filename[MEDIUM_STRING_BUFFER_SIZE]; 
		char txt_include_path1[MEDIUM_STRING_BUFFER_SIZE]; 
		char txt_include_path2[MEDIUM_STRING_BUFFER_SIZE]; 
		char txt_include_path3[MEDIUM_STRING_BUFFER_SIZE]; 
		char txt_include_path4[MEDIUM_STRING_BUFFER_SIZE]; 
		char txt_include_path5[MEDIUM_STRING_BUFFER_SIZE]; 
		int i;
		int stat;
		bool show_scan_trace; 
		bool run_code; 
		bool array_bounds_checks; 
		bool runtime_checks; 
		bool show_warnings; 
		bool command_line_mode; 
		bool show_additional_warnings; 
		bool show_large_strings_warnings;
		bool init_globals;

		save_and_set_runtime_data_ptr( runtime_data_ptr );

		program_size = *((int_64 *) (c_program->data.svalue)); 

		txt_program = (char *) _ci_malloc( program_size + 1 );
		
		ci_str_u32_to_u8( txt_program, c_program->data.svalue, program_size + 1 );
		ci_str_u32_to_u8( txt_input_filename, c_input_filename->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		ci_str_u32_to_u8( txt_include_path1, c_include_path1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		ci_str_u32_to_u8( txt_include_path2, c_include_path2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		ci_str_u32_to_u8( txt_include_path3, c_include_path3->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		ci_str_u32_to_u8( txt_include_path4, c_include_path4->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		ci_str_u32_to_u8( txt_include_path5, c_include_path5->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		
		program = txt_program;
		input_filename = txt_input_filename; 
		 
		include_paths[0] = txt_include_path1; 
		include_paths[1] = txt_include_path2; 
		include_paths[2] = txt_include_path3; 
		include_paths[3] = txt_include_path4; 
		include_paths[4] = txt_include_path5; 
		include_paths[5] = ""; 
		
		_ci_free( txt_program );
	
		if (c_show_scan_trace)				show_scan_trace = true; 				else show_scan_trace = false;
		if (c_show_icode)					gshow_icode = true; 					else gshow_icode = false;
		if (c_run_code)						run_code = true; 						else run_code = false;
		if (c_show_execution_trace)			gshow_execution_trace = true; 			else gshow_execution_trace = false;
		if (c_array_bounds_checks) 			array_bounds_checks = true; 			else array_bounds_checks = false;
		if (c_runtime_checks) 				runtime_checks = true; 					else runtime_checks = false;
		if (c_show_warnings)	 			show_warnings = true; 					else show_warnings = false;
		if (c_command_line_mode) 			command_line_mode = true; 				else command_line_mode = false;
		if (c_show_additional_warnings) 	show_additional_warnings = true; 		else show_additional_warnings = false;
		if (c_show_large_strings_warnings)	show_large_strings_warnings = true; 	else show_large_strings_warnings = false;
		if (c_is_web_page)					is_web_page = true; 					else is_web_page = false;
		if (c_init_globals)					init_globals = true; 					else init_globals = false;
		

	
		ci_get_and_post_filename = NULL;
		ci_redirect_filename = NULL;
	
		ci_calcsys_exit_code = 0;
	
//		command_line_mode = true;
	
//		show_additional_warnings = false;
		
		ginitialise_variables = true;
//		show_large_strings_warnings = false;
		gdefault_to_by_reference = false;
				
//		array_bounds_checks = true;
///		runtime_checks = true;
//		show_warnings = true;
		
		dest_argv[0] = "";
		dest_argc = 1;

		stat = calc_run_program( program, input_filename, show_scan_trace, run_code, array_bounds_checks, runtime_checks, show_warnings, command_line_mode, include_paths, show_additional_warnings, show_large_strings_warnings, init_globals );

		restore_runtime_data_ptr();
		
		return (stat);
	}


	extern "C" void _calc_calc_interpreter_embedded_overall_init( char *source_file_id )
	{
		runtime_data_ptr_level = 0;
		
		num_programs_in_list = 0;
	}


	extern "C" char *_calc_calc_interpreter_embedded_init( ci_var *program_name, ci_var *c_source_code_language_file, char *source_file_id )
	{
		char txt_source_code_language_file[MEDIUM_STRING_BUFFER_SIZE];
		char txt_program_name[MEDIUM_STRING_BUFFER_SIZE];
		string source_code_language_file;
		char *runtime_data_ptr;
		
		runtime_data_ptr = (char *) new t_runtime_data;

		save_and_set_runtime_data_ptr( runtime_data_ptr );

		num_cc_constants = 0;
		
		gis_embedded_environment = true;
		
		ci_str_u32_to_u8( txt_source_code_language_file, c_source_code_language_file->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		ci_str_u32_to_u8( txt_program_name, program_name->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		
		source_code_language_file = txt_source_code_language_file;
		
		get_token_details( source_code_language_file );
		
		create_global_variables_segment();

		restore_runtime_data_ptr();
		
		program_list[num_programs_in_list].program_name = txt_program_name;
		program_list[num_programs_in_list].runtime_data_ptr = runtime_data_ptr;

		num_programs_in_list++;
		
		return ((char *) runtime_data_ptr);
	}


	extern "C" int _calc_calc_interpreter_add_global_variable( char *runtime_data_ptr,
																ci_var *c_var_name, 
																 ci_var *c_type1, 
																 char c_has_been_accessed, 
																 char c_initialise_variable, 
																 long int init_ivalue, 
																 long int init_dvalue, 
																 double init_nvalue, 
																 ci_var *c_init_svalue,
																 char *source_file_id )
	{
		char txt_var_name[MEDIUM_STRING_BUFFER_SIZE];
		char txt_type1[MEDIUM_STRING_BUFFER_SIZE];
		char txt_init_svalue[MEDIUM_STRING_BUFFER_SIZE];
		string var_name;
		string type1; 
		string init_svalue; 
		int var_address; 
		bool has_been_accessed; 
		bool initialise_variable; 

		save_and_set_runtime_data_ptr( runtime_data_ptr );

		ci_str_u32_to_u8( txt_var_name, c_var_name->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		ci_str_u32_to_u8( txt_type1, c_type1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		ci_str_u32_to_u8( txt_init_svalue, c_init_svalue->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		 
		var_name = txt_var_name; 
		type1 = txt_type1; 
		init_svalue = txt_init_svalue;

		if (c_has_been_accessed)				has_been_accessed = true; 				else has_been_accessed = false;	 
		if (c_initialise_variable)				initialise_variable = true; 			else initialise_variable = false;	 
		  
		if (! is_simple_data_type( type1 ))
			initialise_variable = false;
		
		var_address = add_global_variable( var_name, type1, has_been_accessed, initialise_variable, init_ivalue, init_dvalue, init_nvalue, init_svalue );
		
		restore_runtime_data_ptr();
		
		return (var_address);		  
	}


	extern "C" void _calc_calc_interpreter_retrieve_global_variable_string( char *gruntime_data, var *vptr, long int var_address, char *source_file_id )
	{
		ci_var *vptr2;
		t_runtime_data *gruntime_data2;
		
		gruntime_data2 = (t_runtime_data *) gruntime_data;

		string s1 = "";
		
		if (gruntime_data2->global_variable_segment == NULL)
		{
			cout << "NULL global segment.";
			cout << source_file_id;
			exit( 1 );
		}
		
		vptr2 = gruntime_data2->global_variable_segment + var_address;

		if (vptr2->var_type == VAR_EMPTY)
		{
			cout << "Attempt to retrieve the value of a string variable set to empty.";
			cout << source_file_id;
			exit( 1 );
		}
		else
			_calcsys_var_set_s_u32( vptr, (unsigned char *) vptr2->data.svalue, false, s1.c_str() );
	}


	extern "C" long int _calc_calc_interpreter_retrieve_global_variable_int( char *gruntime_data, long int var_address,
																			char *source_file_id )
	{
		ci_var *vptr2;
		t_runtime_data *gruntime_data2;
		
		gruntime_data2 = (t_runtime_data *) gruntime_data;

		if (gruntime_data2->global_variable_segment == NULL)
		{
			cout << "NULL global segment.";
			cout << source_file_id;
			exit( 1 );
		}
		
		vptr2 = gruntime_data2->global_variable_segment + var_address;
		
		return (vptr2->data.ivalue);
	}


	extern "C" char _calc_calc_interpreter_retrieve_global_variable_bool( char *gruntime_data, long int var_address,
																		char *source_file_id )
	{
		ci_var *vptr2;
		t_runtime_data *gruntime_data2;
		
		gruntime_data2 = (t_runtime_data *) gruntime_data;

		if (gruntime_data2->global_variable_segment == NULL)
		{
			cout << "NULL global segment.";
			cout << source_file_id;
			exit( 1 );
		}
		
		vptr2 = gruntime_data2->global_variable_segment + var_address;
		
		return (vptr2->data.ivalue);
	}


	extern "C" long int _calc_calc_interpreter_retrieve_global_variable_decimal( char *gruntime_data, long int var_address,
																				char *source_file_id )
	{
		ci_var *vptr2;
		t_runtime_data *gruntime_data2;
		
		gruntime_data2 = (t_runtime_data *) gruntime_data;
		
		if (gruntime_data2->global_variable_segment == NULL)
		{
			cout << "NULL global segment.";
			cout << source_file_id;
			exit( 1 );
		}
		
		vptr2 = gruntime_data2->global_variable_segment + var_address;
		
		return (vptr2->data.dvalue / VAR_DECIMAL_SCALE);
	}


	extern "C" double _calc_calc_interpreter_retrieve_global_variable_double( char *gruntime_data, long int var_address,
																			char *source_file_id )
	{
		ci_var *vptr2;
		t_runtime_data *gruntime_data2;
		
		gruntime_data2 = (t_runtime_data *) gruntime_data;
		
		if (gruntime_data2->global_variable_segment == NULL)
		{
			cout << "NULL global segment.";
			cout << source_file_id;
			exit( 1 );
		}
		
		vptr2 = gruntime_data2->global_variable_segment + var_address;
		
		return (vptr2->data.nvalue);
	}


	extern "C" void _calc_calc_set_conditional_compilation_constant( ci_var *cc_name )
	{
		char str[MEDIUM_STRING_BUFFER_SIZE];
		string s1;
		
		ci_str_u32_to_u8( str, cc_name->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		
		s1 = str;
		
		cc_constants[num_cc_constants++] = s1;
	}


	extern "C" void _calc_calc_set_str_constant( char *gruntime_data, ci_var *old_value, ci_var *new_value, char *source_file_id ) 
	{
		int ic_ptr;
		t_runtime_data *gruntime_data2;
		
		gruntime_data2 = (t_runtime_data *) gruntime_data;
		
		for (ic_ptr=0; ic_ptr < gruntime_data2->ic_end - 1; ic_ptr++)
		{
			if (gruntime_data2->ic[ic_ptr].u32_string_constant_value != NULL)
			{
				if (ci_str_u32_eq( old_value->data.svalue, gruntime_data2->ic[ic_ptr].u32_string_constant_value))
				{
					gruntime_data2->ic[ic_ptr].saved_u32_string_constant_value = gruntime_data2->ic[ic_ptr].u32_string_constant_value;
					 
					gruntime_data2->ic[ic_ptr].u32_string_constant_value = duplicate_u32( new_value->data.svalue );
				}
			}				
		}		
	}


	extern "C" void _calc_calc_clear_string_constant_saves( char *gruntime_data, char *source_file_id ) 
	{
		int ic_ptr;
		t_runtime_data *gruntime_data2;
		
		gruntime_data2 = (t_runtime_data *) gruntime_data;
		
		for (ic_ptr=0; ic_ptr < gruntime_data2->ic_end - 1; ic_ptr++)
			gruntime_data2->ic[ic_ptr].saved_u32_string_constant_value = NULL;
	}
				

	extern "C" void _calc_calc_restore_string_constants( char *gruntime_data, char *source_file_id ) 
	{
		int ic_ptr;
		t_runtime_data *gruntime_data2;
		
		gruntime_data2 = (t_runtime_data *) gruntime_data;
		
		for (ic_ptr=0; ic_ptr < gruntime_data2->ic_end - 1; ic_ptr++)
		{
			if (gruntime_data2->ic[ic_ptr].saved_u32_string_constant_value != NULL)
			{
				_ci_free( gruntime_data2->ic[ic_ptr].u32_string_constant_value );
					
				gruntime_data2->ic[ic_ptr].u32_string_constant_value = gruntime_data2->ic[ic_ptr].saved_u32_string_constant_value;

				gruntime_data2->ic[ic_ptr].saved_u32_string_constant_value = NULL;
			}				
		}		
	}


//	extern "C" void _calc_calc_start_new_icode_segment( char *source_file_id ) 
//	{
//		gruntime_data = NULL;
//	}


	extern "C" void _calc_calc_interpreter_run_icode( char *runtime_data_ptr,
														char initialise_variables, 
														char runtime_checks, 
														char is_web_page, 
														char show_large_strings_warnings,
														char *source_file_id ) 
	{
		save_and_set_runtime_data_ptr( runtime_data_ptr );
		
//		gshow_execution_trace = true;
		
		run_icode( initialise_variables, runtime_checks, is_web_page, show_large_strings_warnings );

		restore_runtime_data_ptr();
	}
	
	
	extern "C" void _calc_calc_interpreter_free_all_system_memory_allocations( char *source_file_id )
	{
		ci_free_all_system_memory_allocations();
	}
	
	
	extern "C" char *_calc_calc_interpreter_retrieve_runtime_data_ptr( ci_var *program_name, char *source_file_id )
	{
		char txt_program_name[MEDIUM_STRING_BUFFER_SIZE];
		string sprogram_name;
		char *ptr;
		int i;
		
		ci_str_u32_to_u8( txt_program_name, program_name->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

		sprogram_name = txt_program_name;
		
		ptr = NULL;
			
		for (i=0; i < num_programs_in_list; i++)
		{
			if (program_list[i].program_name == sprogram_name)
				ptr = program_list[i].runtime_data_ptr;
		}
		
		return (ptr);
	}
	