//<?		// Turn on editor syntax highlighting

                              // (c) Copyright Mark McIlroy 2023-25

                              
// Calc interpreter, language version 5.7
//
// Last update 24.11.2025
//
                              
                              
                              
                              
    using namespace std;
                              
    #include <string>
    #include <iostream>
    #include <cstdlib>
    #include <cmath>

    #include "ci_calc.h"
            
    #include "library.cpph"
	
	extern int is_web_page;
	
	string str_get_and_post_filename;
	string str_redirect_filename;

	

 	int main( int argc, char const *argv[] )
	{
		string include_paths[MAX_INCLUDE_PATHS];
		string filename;
		string str2;
		int i;
		int j;
		string source_code_language_file; 
		bool command_line_mode;
		bool run_program;
		bool show_large_strings_warnings;
		bool show_scan_trace;
		bool array_bounds_checks;
		bool show_additional_warnings;
		bool runtime_checks;
		bool show_warnings;
		string program;
		bool error_occured;
		
		if (argc <= 1)
		{
			ci_print( "Calc interpreter Version 5.5\n\n" );
			ci_print( "Usage: 	calc_interpreter.exe   input_filename   :Idirectory1 :Idirectory2 etc   [directories to search for include files]\n" );
			exit( 1 );					
		}
		
		gruntime_data = new t_runtime_data;

		runtime_data_ptr_level = 0;
		
		save_and_set_runtime_data_ptr( (char *) gruntime_data );
		
		gis_embedded_environment = false;
		
		num_cc_constants = 0;
		
		j = 0;
		
		filename = argv[1];

		include_paths[0] = "";
	
		ci_get_and_post_filename = NULL;
		ci_redirect_filename = NULL;
	 
	 	ci_calcsys_exit_code = 0;
	 
		command_line_mode = true;

		run_program = true;
	
		show_additional_warnings = false;
	
			// e.g. calc_compile options
			
			// :Idirectory1 :Idirectory2 etc	directories to search for include files (at least 1 required)
			 
						
		source_code_language_file = "english.calclanguage";
		
		show_scan_trace = false;
		gshow_icode= false;
		gshow_execution_trace = false;
		ginitialise_variables = true;
		show_large_strings_warnings = false;
		gdefault_to_by_reference = false;
				
		array_bounds_checks = true;
		runtime_checks = true;
		show_warnings = true;

		is_web_page = false;
		
		dest_argv[0] = "";
		dest_argc = 1;

		for (i=2; i <= argc - 1; i++)
		{
			str2 = argv[i];
			
	 		if (ci_sleft( str2, 2 ) == ":I")
				include_paths[j++] = ci_sright( str2, str2.length() - 2 );
			else
/*			
			if (sleft( str2, 4 ) == ":st=")
				stack_size = cstring_to_int( sright( str2, str2.length() - 4 ) );

			if (sleft( str2, 5 ) == ":st2=")
				stack_size2 = cstring_to_int( sright( str2, str2.length() - 5 ) );
*/

			if (ci_sleft( str2, 7 ) == ":argv1=")
			{
				dest_argv[1] = ci_sright( str2, str2.length() - 7 );
				dest_argc = 2;
			}
			else

			if (ci_sleft( str2, 7 ) == ":argv2=")
			{
				dest_argv[2] = ci_sright( str2, str2.length() - 7 );
				dest_argc = 3;
			}
			else

			if (ci_sleft( str2, 7 ) == ":argv3=")
			{
				dest_argv[3] = ci_sright( str2, str2.length() - 7 );
				dest_argc = 4;
			}
			else

			if (ci_sleft( str2, 7 ) == ":argv4=")
			{
				dest_argv[4] = ci_sright( str2, str2.length() - 7 );
				dest_argc = 5;
			}
			else

			if (ci_sleft( str2, 7 ) == ":argv5=")
			{
				dest_argv[5] = ci_sright( str2, str2.length() - 7 );
				dest_argc = 6;
			}
			else

			if (ci_sleft( str2, 7 ) == ":argv6=")
			{
				dest_argv[6] = ci_sright( str2, str2.length() - 7 );
				dest_argc = 7;
			}
			else

			if (ci_sleft( str2, 7 ) == ":argv7=")
			{
				dest_argv[7] = ci_sright( str2, str2.length() - 7 );
				dest_argc = 8;
			}
			else

			if (ci_sleft( str2, 7 ) == ":argv8=")
			{
				dest_argv[8] = ci_sright( str2, str2.length() - 7 );
				dest_argc = 9;
			}
			else

			if (ci_sleft( str2, 7 ) == ":argv9=")
			{
				dest_argv[9] = ci_sright( str2, str2.length() - 7 );
				dest_argc = 10;
			}
			else

			if (ci_sleft( str2, 7 ) == ":argv10=")
			{
				dest_argv[10] = ci_sright( str2, str2.length() - 7 );
				dest_argc = 11;
			}
			else

			if (ci_sleft( str2, 7 ) == ":argv10=")
			{
				dest_argv[10] = ci_sright( str2, str2.length() - 7 );
				dest_argc = 2;
			}
			else

			if (ci_sleft( str2, 23 ) == ":get_and_post_filename=")
			{
				str_get_and_post_filename = ci_sright( str2, str2.length() - 23 );
				ci_get_and_post_filename = str_get_and_post_filename.c_str();
			}
			else
			
			if (ci_sleft( str2, 19 ) == ":redirect_filename=")
			{
				str_redirect_filename = ci_sright( str2, str2.length() - 19 );
				ci_redirect_filename = str_redirect_filename.c_str();
			}
			else
		
			if (str2 == ":show_scan_trace")
				show_scan_trace = true;
			else
			
			if (str2 == ":show_icode")
				gshow_icode= true;
			else
			
			if (str2 == ":show_execution_trace")
				gshow_execution_trace = true;
			else
			
			if (str2 == ":dont_initialise_variables")
				ginitialise_variables = false;
			else
						
			if (str2 == ":show_additional_warnings")
				show_additional_warnings = true;
			else
			
			if (str2 == ":no_array_bounds_checks")
				array_bounds_checks = false;
			else
			
			if (str2 == ":no_runtime_checks")
				runtime_checks = false;
			else
							
			if (str2 == ":no_show_warnings")
				show_warnings = false;
			else

			if (str2 == ":dont_run_program")
				run_program = false;
			else

			if (str2 == ":show_large_strings_warnings")
				show_large_strings_warnings = true;
			else

			if (str2 == ":default_to_byreference")
				gdefault_to_by_reference = true;
			else
			
			if (str2 == ":is_web_page")
				is_web_page = true;
			else

			if (ci_ssearch( str2, ":set_true=" ) != -1)
			{
				cc_constants[num_cc_constants] = ci_sright_from_pos( str2, ci_ssearch( str2, "=" ) + 1 );
				cc_constants_value[num_cc_constants] = "true";
				num_cc_constants++;
			}
			else
			
			if (ci_ssearch( str2, ":set_false=" ) != -1)
			{
				cc_constants[num_cc_constants] = ci_sright_from_pos( str2, ci_ssearch( str2, "=" ) + 1 );
				cc_constants_value[num_cc_constants] = "false";
				num_cc_constants++;
			}
			else
																	
			if (ci_ssearch( str2, ":source_code_language_file=" ) != -1)
				source_code_language_file = ci_sright_from_pos( str2, ci_ssearch( str2, "=" ) + 1 );
			else
			{
				cout << "Unrecognised command line option: " + str2;
				exit(1);
			}
		}
		
		include_paths[j] = "";
		
		if (include_paths[0] == "")
		{
			include_paths[0] = ".";
			include_paths[1] = "";
			
			ci_print( "Defaulting to searching the current directory for include files. Use the I:directory1 I:directory2 option to specify include directories." );
		}
	
		program = ci_ffile_get_contents_text( filename );

		get_token_details( source_code_language_file );

		create_global_variables_segment();

		error_occured = calc_run_program( program, filename, show_scan_trace, run_program, array_bounds_checks, runtime_checks, show_warnings, command_line_mode, include_paths, show_additional_warnings, show_large_strings_warnings, true );
		
		if (error_occured)
			exit( 1 );
		else
			exit( ci_calcsys_exit_code );
	}

