
using namespace std;

#include <iostream>
#include <cctype>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <time.h>
#include <unistd.h>
#include <sys/stat.h>
#include <dirent.h>
#include "mysql.h"
#include "../libraries/pdf_gen/pdfgen.h"

#include "ci_calc.h"
#include "library.cpph"

#include "calc_stdlib_c.cpp"
#include "calc_mysql.cpp"
#include "calc_pdf_c.cpp"
#include "bst_tree_c_version_calc_interface.cpp"
#include "calc_interpreter_embedded_interface_interpreter.cpp"


#define MAX_KEY_LEN 10000

char *source_file_id_txt;



void run_builtin_function( ci_var *sp_result, int builtin_function_number ) 
{
	ci_var **sp2;
	
	sp2 = gruntime_data->sp2;
	
	switch (builtin_function_number)
	{
		case 1:
					if ((*(sp2-1))->var_type != VAR_INT)
						ci_var_set_i( *(sp2-1), 0 );
							 				
					_ci_calc_fopen( sp_result, *(sp2-3), (*(sp2-2))->data.ivalue, (char *) &((*(sp2-1))->data.ivalue) );	break;
		case 2:								_ci_calc_fgets( sp_result, *(sp2-1) );																	break;
		case 3:								_ci_calc_fputs( *(sp2-2), *(sp2-1) );																	break;
		case 4:		ci_var_set_i( sp_result, 	_ci_calc_feof( *(sp2-1) ) );																			break;
		case 5:								_ci_calc_fclose( *(sp2-1) );																			break;
		case 6:		ci_var_set_i( sp_result, 	_ci_calc_fexists( *(sp2-1) ) );																		break;
		case 7:		ci_var_set_i( sp_result, 	_ci_calc_fis_a_directory( *(sp2-1) ) );																break;
		case 8:								_ci_calc_flast_modified_datetime( sp_result, *(sp2-1) );												break;
		case 9:		ci_var_set_i( sp_result, 	_ci_calc_ffiles_in_folder( *(sp2-2), *(sp2-1) ) );														break;
		case 10:							_ci_calc_fdelete( *(sp2-1) );																			break;
		case 11:	ci_var_set_i( sp_result, 	_ci_calc_fsize( *(sp2-1) ) );																			break;
		case 12:	ci_var_set_i( sp_result, 	_ci_calc_fread( *(sp2-3), (*(sp2-2))->data.ivalue, *(sp2-1) ) );										break;
		case 13:							_ci_calc_fwrite( *(sp2-3), (*(sp2-2))->data.ivalue, *(sp2-1) );										break;
		case 14:							_ci_calc_fseek( *(sp2-2), (*(sp2-1))->data.ivalue );													break;
		case 15:	ci_var_set_i( sp_result, 	_ci_calc_fcurrent_position( *(sp2-1) ) );																break;
		case 16:							_ci_calc_ffile_get_contents_text( sp_result, *(sp2-1) );												break;
		case 17:							_ci_calc_ffile_get_contents_binary( *(sp2-2), *(sp2-1) );												break;
		case 18:							_ci_calc_mkdir( *(sp2-2), (*(sp2-1))->data.ivalue );													break;
		case 19:							_ci_calc_print( *(sp2-1) );																			break;
		case 20:							_ci_calc_output( *(sp2-1) );																			break;

		case 330:							_ci_calc_input_string( sp_result );																	break;
		
		
		//--------------------------------------------------------------------------
		// Strings
		//--------------------------------------------------------------------------
		
		case 21:	ci_var_set_i( sp_result, 	_ci_calc_slength( *(sp2-1) ) );																		break;
		case 22:							_ci_calc_sleft( sp_result, *(sp2-2), (*(sp2-1))->data.ivalue );										break;
		case 23:							_ci_calc_sright( sp_result, *(sp2-2), (*(sp2-1))->data.ivalue );										break;
		case 24:							_ci_calc_sright_from_pos( sp_result, *(sp2-2), (*(sp2-1))->data.ivalue );								break;
		case 25:							_ci_calc_smid( sp_result, *(sp2-3), (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue );				break;
		case 26:							_ci_calc_schar( sp_result, *(sp2-2), (*(sp2-1))->data.ivalue );										break;
		case 27:							_ci_calc_stoupper( sp_result, *(sp2-1) );																break;
		case 28:							_ci_calc_stolower( sp_result, *(sp2-1) );																break;
		case 29:	ci_var_set_i( sp_result, 	_ci_calc_scaseieq( *(sp2-2), *(sp2-1) ) );																break;
		case 30:	ci_var_set_i( sp_result, 	_ci_calc_ssearch( *(sp2-2), *(sp2-1) ) );																break;
		case 31:	ci_var_set_i( sp_result, 	_ci_calc_srsearch( *(sp2-2), *(sp2-1) ) );																break;
		case 32:							_ci_calc_strim( sp_result, *(sp2-1) );																	break;
		case 33:							_ci_calc_sreplace( sp_result, *(sp2-3), *(sp2-2), *(sp2-1) );											break;
		case 34:	ci_var_set_i( sp_result, 	_ci_calc_sexplode( *(sp2-3), *(sp2-2), *(sp2-1) ) );													break;
		case 35:	ci_var_set_i( sp_result, 	_ci_calc_sexplode_whitespace( *(sp2-2), *(sp2-1) ) );													break;
		case 36:	ci_var_set_i( sp_result, 	_ci_calc_sexplode_csv( *(sp2-3), *(sp2-2), *(sp2-1) ) );												break;
		case 37:	ci_var_set_i( sp_result, 	_ci_calc_schar_to_int( *(sp2-1) ) );																	break;
		case 38:							_ci_calc_sint_to_char( sp_result, (*(sp2-1))->data.ivalue );											break;
		
		
		//--------------------------------------------------------------------------
		// Mathematics
		//--------------------------------------------------------------------------
		
		case 39:	ci_var_set_n( sp_result, 	_ci_calc_mrand() );																					break;
		case 303:							_ci_calc_mseed_rand( (*(sp2-1))->data.ivalue );														break;
		case 40:	ci_var_set_i( sp_result, 	_ci_calc_mtrunc( (*(sp2-1))->data.nvalue ) );															break;
		case 41:	ci_var_set_n( sp_result, 	_ci_calc_msqrt( (*(sp2-1))->data.nvalue ) );															break;
		case 42:	ci_var_set_n( sp_result, 	_ci_calc_mfabs( (*(sp2-1))->data.nvalue ) );															break;
		case 43:	ci_var_set_n( sp_result, 	_ci_calc_mfmin( (*(sp2-2))->data.nvalue, (*(sp2-1))->data.nvalue ) );									break;
		case 44:	ci_var_set_n( sp_result, 	_ci_calc_mfmax( (*(sp2-2))->data.nvalue, (*(sp2-1))->data.nvalue ) );									break;
		case 45:	ci_var_set_i( sp_result, 	_ci_calc_miabs( (*(sp2-1))->data.ivalue ) );															break;
		case 46:	ci_var_set_i( sp_result, 	_ci_calc_mimin( (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue ) );									break;
		case 47:	ci_var_set_i( sp_result, 	_ci_calc_mimax( (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue ) );									break;
		case 48:	ci_var_set_n( sp_result, 	_ci_calc_mlog( (*(sp2-1))->data.nvalue ) );															break;
		case 49:	ci_var_set_n( sp_result, 	_ci_calc_mlog10( (*(sp2-1))->data.nvalue ) );															break;
		case 50:	ci_var_set_n( sp_result, 	_ci_calc_mexp( (*(sp2-1))->data.nvalue ) );															break;
		case 51:	ci_var_set_n( sp_result, 	_ci_calc_mround( (*(sp2-2))->data.nvalue, (*(sp2-1))->data.ivalue ) );									break;
		case 52:							_ci_calc_mformat( sp_result, (*(sp2-3))->data.nvalue, (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue );	break;
		case 53:							_ci_calc_miformat( sp_result, (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue );						break;
		case 54:	ci_var_set_n( sp_result, 	_ci_calc_msin( (*(sp2-1))->data.nvalue ) );															break;
		case 55:	ci_var_set_n( sp_result, 	_ci_calc_mcos( (*(sp2-1))->data.nvalue ) );															break;
		case 56:	ci_var_set_n( sp_result, 	_ci_calc_mtan( (*(sp2-1))->data.nvalue ) );															break;
		case 57:	ci_var_set_n( sp_result, 	_ci_calc_marcsin( (*(sp2-1))->data.nvalue ) );															break;
		case 58:	ci_var_set_n( sp_result, 	_ci_calc_marccos( (*(sp2-1))->data.nvalue ) );															break;
		case 59:	ci_var_set_n( sp_result, 	_ci_calc_marctan( (*(sp2-1))->data.nvalue ) );															break;
		
		case 60:	ci_var_set_n( sp_result, 	_ci_calc_mrandf() );																					break;
		case 61:	ci_var_set_i( sp_result, 	_ci_calc_mtruncf( (*(sp2-1))->data.nvalue ) );															break;
		case 62:	ci_var_set_n( sp_result, 	_ci_calc_msqrtf( (*(sp2-1))->data.nvalue ) );															break;
		case 63:	ci_var_set_n( sp_result, 	_ci_calc_mfabsf( (*(sp2-1))->data.nvalue ) );															break;
		case 64:	ci_var_set_n( sp_result, 	_ci_calc_mfminf( (*(sp2-2))->data.nvalue, (*(sp2-1))->data.nvalue ) );									break;
		case 65:	ci_var_set_n( sp_result, 	_ci_calc_mfmaxf( (*(sp2-2))->data.nvalue, (*(sp2-1))->data.nvalue ) );									break;
		case 66:	ci_var_set_n( sp_result, 	_ci_calc_mlogf( (*(sp2-1))->data.nvalue ) );															break;
		case 67:	ci_var_set_n( sp_result, 	_ci_calc_mlog10f( (*(sp2-1))->data.nvalue ) );															break;
		case 68:	ci_var_set_n( sp_result, 	_ci_calc_mexpf( (*(sp2-1))->data.nvalue ) );															break;
		case 69:	ci_var_set_n( sp_result, 	_ci_calc_mroundf( (*(sp2-2))->data.nvalue, (*(sp2-1))->data.ivalue ) );								break;
		case 70:							_ci_calc_mformatf( sp_result, (*(sp2-3))->data.ivalue, (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue );	break;
		case 71:	ci_var_set_n( sp_result, 	_ci_calc_msinf( (*(sp2-1))->data.nvalue ) );															break;
		case 72:	ci_var_set_n( sp_result, 	_ci_calc_mcosf( (*(sp2-1))->data.nvalue ) );															break;
		case 73:	ci_var_set_n( sp_result, 	_ci_calc_mtanf( (*(sp2-1))->data.nvalue ) );															break;
		case 74:	ci_var_set_n( sp_result, 	_ci_calc_marcsinf( (*(sp2-1))->data.nvalue ) );														break;
		case 75:	ci_var_set_n( sp_result, 	_ci_calc_marccosf( (*(sp2-1))->data.nvalue ) );														break;
		case 76:	ci_var_set_n( sp_result, 	_ci_calc_marctanf( (*(sp2-1))->data.nvalue ) );														break;
		
		case 77:	ci_var_set_n( sp_result, 	_ci_calc_mrandl() );																					break;
		case 78:	ci_var_set_i( sp_result, 	_ci_calc_mtruncl( (*(sp2-1))->data.nvalue ) );															break;
		case 79:	ci_var_set_n( sp_result, 	_ci_calc_msqrtl( (*(sp2-1))->data.nvalue ) );															break;
		case 80:	ci_var_set_n( sp_result, 	_ci_calc_mfabsl( (*(sp2-1))->data.nvalue ) );															break;
		case 81:	ci_var_set_n( sp_result, 	_ci_calc_mfminl( (*(sp2-2))->data.nvalue, (*(sp2-1))->data.nvalue ) );									break;
		case 82:	ci_var_set_n( sp_result, 	_ci_calc_mfmaxl( (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue ) );									break;
		case 83:	ci_var_set_n( sp_result, 	_ci_calc_mlogl( (*(sp2-1))->data.nvalue ) );															break;
		case 84:	ci_var_set_n( sp_result, 	_ci_calc_mlog10l( (*(sp2-1))->data.nvalue ) );															break;
		case 85:	ci_var_set_n( sp_result, 	_ci_calc_mexpl( (*(sp2-1))->data.nvalue ) );															break;
		case 86:	ci_var_set_n( sp_result, 	_ci_calc_mroundl( (*(sp2-2))->data.nvalue, (*(sp2-1))->data.ivalue ) );								break;
		case 87:							_ci_calc_mformatl( sp_result, (*(sp2-3))->data.nvalue, (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue );	break;
		case 88:	ci_var_set_n( sp_result, 	_ci_calc_msinl( (*(sp2-1))->data.nvalue ) );															break;
		case 89:	ci_var_set_n( sp_result, 	_ci_calc_mcosl( (*(sp2-1))->data.nvalue ) );															break;
		case 90:	ci_var_set_n( sp_result, 	_ci_calc_mtanl( (*(sp2-1))->data.nvalue ) );															break;
		case 91:	ci_var_set_n( sp_result, 	_ci_calc_marcsinl( (*(sp2-1))->data.nvalue ) );														break;
		case 92:	ci_var_set_n( sp_result, 	_ci_calc_marccosl( (*(sp2-1))->data.nvalue ) );														break;
		case 93:	ci_var_set_n( sp_result, 	_ci_calc_marctanl( (*(sp2-1))->data.nvalue ) );														break;
		
		
		
		//--------------------------------------------------------------------------
		// Dates & times
		//--------------------------------------------------------------------------
		
		case 94:							_ci_calc_dtoday( sp_result );																			break;
		case 95:							_ci_calc_tnow( sp_result );																			break;
		case 96:							_ci_calc_dtnow( sp_result );																			break;
		case 97:							_ci_calc_dformat( sp_result, *(sp2-2), *(sp2-1) );														break;
		case 98:							_ci_calc_tformat( sp_result, *(sp2-2), *(sp2-1) );														break;
		case 99:							_ci_calc_dtformat( sp_result, *(sp2-2), *(sp2-1) );													break;
		case 100:	ci_var_set_i( sp_result, 	_ci_calc_dlast_day_of_the_month( (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue ) );					break;
		case 101:	ci_var_set_i( sp_result, 	_ci_calc_dis_last_day_of_the_month( *(sp2-1) ) );														break;
		case 102:							_ci_calc_dadd( sp_result, *(sp2-3), *(sp2-2), (*(sp2-1))->data.ivalue );								break;
		case 103:							_ci_calc_dtadd( sp_result, *(sp2-3), *(sp2-2), (*(sp2-1))->data.ivalue );								break;
		case 104:							_ci_calc_dsub( sp_result, *(sp2-3), *(sp2-2), (*(sp2-1))->data.ivalue );								break;
		case 105:							_ci_calc_dtsub( sp_result, *(sp2-3), *(sp2-2), (*(sp2-1))->data.ivalue );								break;
		case 310:							_ci_calc_ddtadd( sp_result, *(sp2-3), *(sp2-2), (*(sp2-1))->data.ivalue );								break;
		case 311:							_ci_calc_ddtsub( sp_result, *(sp2-3), *(sp2-2), (*(sp2-1))->data.ivalue );								break;
		case 106:	ci_var_set_i( sp_result, 	_ci_calc_ddiff( *(sp2-2), *(sp2-1) ) );																break;
		case 107:	ci_var_set_i( sp_result, 	_ci_calc_ddatestr_is_valid( *(sp2-2), *(sp2-1) ) );													break;
		case 108:	ci_var_set_i( sp_result, 	_ci_calc_dtimestr_is_valid( *(sp2-1) ) );																break;
		case 109:	ci_var_set_i( sp_result, 	_ci_calc_ddatetimestr_is_valid( *(sp2-1) ) );															break;
		case 110:	ci_var_set_i( sp_result, 	_ci_calc_dleap_year( (*(sp2-1))->data.ivalue ) );														break;
		case 111:	ci_var_set_i( sp_result, 	_ci_calc_dweekday( *(sp2-1) ) );																		break;
		case 112:	ci_var_set_i( sp_result, 	_ci_calc_dday( *(sp2-1) ) );																			break;
		case 113:	ci_var_set_i( sp_result, 	_ci_calc_dmonth( *(sp2-1) ) );																			break;
		case 114:	ci_var_set_i( sp_result, 	_ci_calc_dyear( *(sp2-1) ) );																			break;
		case 115:	ci_var_set_i( sp_result, 	_ci_calc_dhour( *(sp2-1) ) );																			break;
		case 116:	ci_var_set_i( sp_result, 	_ci_calc_dminute( *(sp2-1) ) );																		break;
		case 117:	ci_var_set_i( sp_result, 	_ci_calc_dsecond( *(sp2-1) ) );																		break;
		case 118:	ci_var_set_i( sp_result, 	_ci_calc_ddate_to_julian( *(sp2-1) ) );																break;
		case 119:							_ci_calc_djulian_to_date( sp_result, (*(sp2-1))->data.ivalue );										break;
		case 120:							_ci_calc_ddate_part( sp_result, *(sp2-1) );															break;
		case 121:							_ci_calc_dtime_part( sp_result, *(sp2-1) );															break;
		case 122:							_ci_calc_ddate_from_parts( sp_result, (*(sp2-3))->data.ivalue, (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue );		break;
		case 123:							_ci_calc_dtime_from_parts( sp_result, (*(sp2-3))->data.ivalue, (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue );		break;
		case 124:							_ci_calc_ddatetime_from_parts( sp_result, (*(sp2-6))->data.ivalue, (*(sp2-5))->data.ivalue, (*(sp2-4))->data.ivalue, (*(sp2-3))->data.ivalue, (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue );	break;
		case 125:							_ci_calc_ddatetime_from_vars( sp_result, *(sp2-2), *(sp2-1) );											break;
		
		
		//--------------------------------------------------------------------------
		// Binary
		//--------------------------------------------------------------------------
		
			// binit must be called before operations on a binary variable
			
//		case 126:							_ci_calc_binit( *(sp2-1) );																			break;
		case 127:							_ci_calc_bset_size( *(sp2-2), (*(sp2-1))->data.ivalue );												break;
		case 128:							_ci_calc_bclear( *(sp2-2), (*(sp2-1))->data.ivalue );													break;
		case 129:	ci_var_set_i( sp_result, 	_ci_calc_bsize( *(sp2-1) ) );																			break;
		case 130:							_ci_calc_bset_byte( *(sp2-3), (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue );						break;
		case 131:	ci_var_set_i( sp_result, 	_ci_calc_bget_byte( *(sp2-2), (*(sp2-1))->data.ivalue ) );												break;
//		case 132:							_ci_calc_bset_bit( *(sp2-3), (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue );						break;
//		case 133:	ci_var_set_i( sp_result, 	_ci_calc_bget_bit( *(sp2-2), (*(sp2-1))->data.ivalue ) );												break;
		case 134:							_ci_calc_bint_to_hex( sp_result, (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue );					break;
		case 135:	ci_var_set_i( sp_result, 	_ci_calc_bhex_to_int( *(sp2-1) ) );																	break;
		
		
		//--------------------------------------------------------------------------
		// Database
		//--------------------------------------------------------------------------
		
		case 136:							_ci_calc_mysql_init( sp_result );																		break;
		case 137:							_ci_calc_db_login( sp_result, *(sp2-3), *(sp2-2), *(sp2-1) );											break;
		case 312:							_ci_calc_db_close_connection( *(sp2-1) );															break;
		case 138:							_ci_calc_db_prep_string_for_sql( sp_result, *(sp2-1) );												break;
		case 139:							_ci_calc_db_run_query( sp_result, *(sp2-2), *(sp2-1) );												break;
		case 140:	ci_var_set_i( sp_result, 	_ci_calc_db_query_num_rows( *(sp2-2), *(sp2-1) ) );													break;
		case 141:	ci_var_set_i( sp_result, 	_ci_calc_db_query_has_rows( *(sp2-2), *(sp2-1) ) );													break;
		case 142:							_ci_calc_db_get_row( sp_result, *(sp2-2), *(sp2-1) );													break;
		case 143:							_ci_calc_db_free_result( *(sp2-2), *(sp2-1) );															break;
		case 144:	ci_var_set_i( sp_result, 	_ci_calc_db_field_is_null( *(sp2-2), *(sp2-1) ) );														break;
		case 145:	ci_var_set_i( sp_result, 	_ci_calc_db_field_is_in_query( *(sp2-2), *(sp2-1) ) );													break;
		case 146:							_ci_calc_db_get_field_string( sp_result, *(sp2-2), *(sp2-1) );											break;
		case 147:	ci_var_set_i( sp_result, 	_ci_calc_db_get_field_int( *(sp2-2), *(sp2-1) ) );														break;
		case 148:	ci_var_set_d( sp_result, 	_ci_calc_db_get_field_decimal( *(sp2-2), *(sp2-1) ) );													break;
		case 149:	ci_var_set_n( sp_result, 	_ci_calc_db_get_field_double( *(sp2-2), *(sp2-1) ) );													break;
		case 150:	ci_var_set_i( sp_result, 	_ci_calc_db_get_field_bool( *(sp2-2), *(sp2-1) ) );													break;
		case 151:							_ci_calc_db_get_field_date( sp_result, *(sp2-2), *(sp2-1) );											break;
		case 152:							_ci_calc_db_get_field_time( sp_result, *(sp2-2), *(sp2-1) );											break;
		case 153:							_ci_calc_db_get_field_datetime( sp_result, *(sp2-2), *(sp2-1) );										break;
		
		
		//--------------------------------------------------------------------------
		// internet
		//--------------------------------------------------------------------------
		
		case 154:							_ci_calc_iconvert_to_html( sp_result, *(sp2-1) );														break;
		case 155:							_ci_calc_iurlencode( sp_result, *(sp2-1) );															break;
		case 156:							_ci_calc_iurldecode( sp_result, *(sp2-1) );															break;
		case 157:							_ci_calc_ijump_to_page( *(sp2-1) );																	break;
		case 158:							_ci_calc_iexit_if_search_bot( *(sp2-1) );																break;
		
		
		//--------------------------------------------------------------------------
		// Data type conversions
		//--------------------------------------------------------------------------
		
		// Numeric conversions
		
		case 159:	ci_var_set_i( sp_result, 	_ci_calc_cint_to_short_int( (*(sp2-1))->data.ivalue ) );												break;
		case 160:	ci_var_set_i( sp_result, 	_ci_calc_cint_to_medium_int( (*(sp2-1))->data.ivalue ) );												break;
		case 161:	ci_var_set_i( sp_result, 	_ci_calc_cint_to_byte( (*(sp2-1))->data.ivalue ) );													break;
		case 162:	ci_var_set_d( sp_result, 	_ci_calc_cint_to_decimal( (*(sp2-1))->data.ivalue ) );													break;
		case 163:	ci_var_set_n( sp_result, 	_ci_calc_cint_to_float( (*(sp2-1))->data.ivalue ) );													break;
		case 164:	ci_var_set_n( sp_result, 	_ci_calc_cint_to_double( (*(sp2-1))->data.ivalue ) );													break;
		case 165:	ci_var_set_n( sp_result, 	_ci_calc_cint_to_long_double( (*(sp2-1))->data.ivalue ) );												break;
		
		case 166:	ci_var_set_i( sp_result, 	_ci_calc_cshort_int_to_int( (*(sp2-1))->data.ivalue ) );												break;
		case 167:	ci_var_set_i( sp_result, 	_ci_calc_cshort_int_to_medium_int( (*(sp2-1))->data.ivalue ) );										break;
		case 168:	ci_var_set_i( sp_result, 	_ci_calc_cshort_int_to_byte( (*(sp2-1))->data.ivalue ) );												break;
		case 169:	ci_var_set_d( sp_result, 	_ci_calc_cshort_int_to_decimal( (*(sp2-1))->data.ivalue ) );											break;
		case 170:	ci_var_set_n( sp_result, 	_ci_calc_cshort_int_to_float( (*(sp2-1))->data.ivalue ) );												break;
		case 171:	ci_var_set_n( sp_result, 	_ci_calc_cshort_int_to_double( (*(sp2-1))->data.ivalue ) );											break;
		case 172:	ci_var_set_n( sp_result, 	_ci_calc_cshort_int_to_long_double( (*(sp2-1))->data.ivalue ) );										break;
		
		case 173:	ci_var_set_i( sp_result, 	_ci_calc_cmedium_int_to_int( (*(sp2-1))->data.ivalue ) );												break;
		case 174:	ci_var_set_i( sp_result, 	_ci_calc_cmedium_int_to_short_int( (*(sp2-1))->data.ivalue ) );										break;
		case 175:	ci_var_set_i( sp_result, 	_ci_calc_cmedium_int_to_byte( (*(sp2-1))->data.ivalue ) );												break;
		case 176:	ci_var_set_d( sp_result, 	_ci_calc_cmedium_int_to_decimal( (*(sp2-1))->data.ivalue ) );											break;
		case 177:	ci_var_set_n( sp_result, 	_ci_calc_cmedium_int_to_float( (*(sp2-1))->data.ivalue ) );											break;
		case 178:	ci_var_set_n( sp_result, 	_ci_calc_cmedium_int_to_double( (*(sp2-1))->data.ivalue ) );											break;
		case 179:	ci_var_set_n( sp_result, 	_ci_calc_cmedium_int_to_long_double( (*(sp2-1))->data.ivalue ) );										break;
		
		case 180:	ci_var_set_i( sp_result, 	_ci_calc_cbyte_to_int( (*(sp2-1))->data.ivalue ) );													break;
		case 181:	ci_var_set_i( sp_result, 	_ci_calc_cbyte_to_short_int( (*(sp2-1))->data.ivalue ) );												break;
		case 182:	ci_var_set_i( sp_result, 	_ci_calc_cbyte_to_medium_int( (*(sp2-1))->data.ivalue ) );												break;
		case 183:	ci_var_set_d( sp_result, 	_ci_calc_cbyte_to_decimal( (*(sp2-1))->data.ivalue ) );												break;
		case 184:	ci_var_set_n( sp_result, 	_ci_calc_cbyte_to_float( (*(sp2-1))->data.ivalue ) );													break;
		case 185:	ci_var_set_n( sp_result, 	_ci_calc_cbyte_to_double( (*(sp2-1))->data.ivalue ) );													break;
		case 186:	ci_var_set_n( sp_result, 	_ci_calc_cbyte_to_long_double( (*(sp2-1))->data.ivalue ) );											break;
		
		case 187:	ci_var_set_i( sp_result, 	_ci_calc_cdecimal_to_int( (*(sp2-1))->data.ivalue ) );													break;
		case 188:	ci_var_set_i( sp_result, 	_ci_calc_cdecimal_to_short_int( (*(sp2-1))->data.ivalue ) );											break;
		case 189:	ci_var_set_i( sp_result, 	_ci_calc_cdecimal_to_medium_int( (*(sp2-1))->data.ivalue ) );											break;
		case 190:	ci_var_set_i( sp_result, 	_ci_calc_cdecimal_to_byte( (*(sp2-1))->data.ivalue ) );												break;
		case 191:	ci_var_set_n( sp_result, 	_ci_calc_cdecimal_to_float( (*(sp2-1))->data.ivalue ) );												break;
		case 192:	ci_var_set_n( sp_result, 	_ci_calc_cdecimal_to_double( (*(sp2-1))->data.ivalue ) );												break;
		case 193:	ci_var_set_n( sp_result, 	_ci_calc_cdecimal_to_long_double( (*(sp2-1))->data.ivalue ) );											break;
		
		case 194:	ci_var_set_i( sp_result, 	_ci_calc_cfloat_to_int( (*(sp2-1))->data.nvalue ) );													break;
		case 195:	ci_var_set_i( sp_result, 	_ci_calc_cfloat_to_short_int( (*(sp2-1))->data.nvalue ) );												break;
		case 196:	ci_var_set_i( sp_result, 	_ci_calc_cfloat_to_medium_int( (*(sp2-1))->data.nvalue ) );											break;
		case 197:	ci_var_set_i( sp_result, 	_ci_calc_cfloat_to_byte( (*(sp2-1))->data.nvalue ) );													break;
		case 198:	ci_var_set_d( sp_result, 	_ci_calc_cfloat_to_decimal( (*(sp2-1))->data.nvalue ) );												break;
		case 199:	ci_var_set_n( sp_result, 	_ci_calc_cfloat_to_double( (*(sp2-1))->data.nvalue ) );												break;
		case 200:	ci_var_set_n( sp_result, 	_ci_calc_cfloat_to_long_double( (*(sp2-1))->data.nvalue ) );											break;
		
		case 201:	ci_var_set_i( sp_result, 	_ci_calc_cdouble_to_int( (*(sp2-1))->data.nvalue ) );													break;
		case 202:	ci_var_set_i( sp_result, 	_ci_calc_cdouble_to_short_int( (*(sp2-1))->data.nvalue ) );											break;
		case 203:	ci_var_set_i( sp_result, 	_ci_calc_cdouble_to_medium_int( (*(sp2-1))->data.nvalue ) );											break;
		case 204:	ci_var_set_i( sp_result, 	_ci_calc_cdouble_to_byte( (*(sp2-1))->data.nvalue ) );													break;
		case 205:	ci_var_set_d( sp_result, 	_ci_calc_cdouble_to_decimal( (*(sp2-1))->data.nvalue ) );												break;
		case 206:	ci_var_set_n( sp_result, 	_ci_calc_cdouble_to_float( (*(sp2-1))->data.nvalue ) );												break;
		case 207:	ci_var_set_n( sp_result, 	_ci_calc_cdouble_to_long_double( (*(sp2-1))->data.nvalue ) );											break;
		
		case 208:	ci_var_set_i( sp_result, 	_ci_calc_clong_double_to_int( (*(sp2-1))->data.nvalue ) );												break;
		case 209:	ci_var_set_i( sp_result, 	_ci_calc_clong_double_to_short_int( (*(sp2-1))->data.nvalue ) );										break;
		case 210:	ci_var_set_i( sp_result, 	_ci_calc_clong_double_to_medium_int( (*(sp2-1))->data.nvalue ) );										break;
		case 211:	ci_var_set_i( sp_result, 	_ci_calc_clong_double_to_byte( (*(sp2-1))->data.nvalue ) );											break;
		case 212:	ci_var_set_d( sp_result, 	_ci_calc_clong_double_to_decimal( (*(sp2-1))->data.nvalue ) );											break;
		case 213:	ci_var_set_n( sp_result, 	_ci_calc_clong_double_to_float( (*(sp2-1))->data.nvalue ) );											break;
		case 214:	ci_var_set_n( sp_result, 	_ci_calc_clong_double_to_double( (*(sp2-1))->data.nvalue ) );											break;
		
		
		
		// Conversions to string
		
		case 215:							_ci_calc_cint_to_string( sp_result, (*(sp2-1))->data.ivalue );											break;
		case 216:							_ci_calc_cshort_int_to_string( sp_result, (*(sp2-1))->data.ivalue );									break;
		case 217:							_ci_calc_cmedium_int_to_string( sp_result, (*(sp2-1))->data.ivalue );									break;
		case 218:							_ci_calc_cbyte_to_string( sp_result, (*(sp2-1))->data.ivalue );										break;
		case 219:							_ci_calc_cdecimal_to_string( sp_result, (*(sp2-1))->data.ivalue );										break;
		case 220:							_ci_calc_cfloat_to_string( sp_result, (*(sp2-1))->data.nvalue );										break;
		case 221:							_ci_calc_cdouble_to_string( sp_result, (*(sp2-1))->data.nvalue );										break;
		case 222:							_ci_calc_clong_double_to_string( sp_result, (*(sp2-1))->data.nvalue );									break;
		case 223:							_ci_calc_cbool_to_string( sp_result, (*(sp2-1))->data.ivalue );										break;
		case 224:							_ci_calc_cdate_to_string( sp_result, *(sp2-2), *(sp2-1) );												break;
		case 225:							_ci_calc_ctime_to_string( sp_result, *(sp2-2), *(sp2-1) );												break;
		case 226:							_ci_calc_cdatetime_to_string( sp_result, *(sp2-2), *(sp2-1) );											break;
		
		
		// Conversions from string
		
		case 227:	ci_var_set_i( sp_result, 	_ci_calc_cstring_to_int( *(sp2-1) ) );																	break;
		case 228:	ci_var_set_i( sp_result, 	_ci_calc_cstring_to_short_int( *(sp2-1) ) );															break;
		case 229:	ci_var_set_i( sp_result, 	_ci_calc_cstring_to_medium_int( *(sp2-1) ) );															break;
		case 230:	ci_var_set_i( sp_result, 	_ci_calc_cstring_to_byte( *(sp2-1) ) );																break;
		case 231:	ci_var_set_d( sp_result, 	_ci_calc_cstring_to_decimal( *(sp2-1) ) );																break;
		case 232:	ci_var_set_n( sp_result, 	_ci_calc_cstring_to_float( *(sp2-1) ) );																break;
		case 233:	ci_var_set_n( sp_result, 	_ci_calc_cstring_to_double( *(sp2-1) ) );																break;
		case 234:	ci_var_set_n( sp_result, 	_ci_calc_cstring_to_long_double( *(sp2-1) ) );															break;
		case 235:	ci_var_set_i( sp_result, 	_ci_calc_cstring_to_bool( *(sp2-1) ) );																break;
		case 236:							_ci_calc_cstring_to_date( sp_result, *(sp2-2), *(sp2-1) );												break;
		case 237:							_ci_calc_cstring_to_time( sp_result, *(sp2-1) );														break;
		case 238:							_ci_calc_cstring_to_datetime( sp_result, *(sp2-1) );													break;
		
		
		// Conversions to/from binary
		
		case 239:							_ci_calc_cbinary_to_string( sp_result, *(sp2-2), (*(sp2-1))->data.ivalue );							break;
		case 240:	ci_var_set_i( sp_result, 	_ci_calc_cbinary_to_int( *(sp2-1) ) );																	break;
		case 241:	ci_var_set_d( sp_result, 	_ci_calc_cbinary_to_decimal( *(sp2-1) ) );																break;
		case 242:	ci_var_set_n( sp_result, 	_ci_calc_cbinary_to_double( *(sp2-1) ) );																break;
		case 243:							_ci_calc_cbinary_to_date( sp_result, *(sp2-1) );														break;
		case 244:							_ci_calc_cbinary_to_time( sp_result, *(sp2-1) );														break;
		case 245:							_ci_calc_cbinary_to_datetime( sp_result, *(sp2-1) );													break;
		
		case 246:							_ci_calc_cstring_to_binary( sp_result, *(sp2-2), (*(sp2-1))->data.ivalue );							break;
		case 247:							_ci_calc_cint_to_binary( sp_result, (*(sp2-1))->data.ivalue );											break;
		case 248:							_ci_calc_cdecimal_to_binary( sp_result, (*(sp2-1))->data.ivalue );										break;
		case 249:							_ci_calc_cdouble_to_binary( sp_result, (*(sp2-1))->data.nvalue );										break;
		case 250:							_ci_calc_cdate_to_binary( sp_result, *(sp2-1) );														break;
		case 251:							_ci_calc_ctime_to_binary( sp_result, *(sp2-1) );														break;
		case 252:							_ci_calc_cdatetime_to_binary( sp_result, *(sp2-1) );													break;
		
		
		
		// Other type conversions
		
		case 253:							_ci_calc_cdate_to_datetime( sp_result, *(sp2-1) );														break;
		
		
		
		//--------------------------------------------------------------------------
		// Bit functions
		//--------------------------------------------------------------------------
		
		case 254:	ci_var_set_i( sp_result, 	_ci_calc_bit_and( (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue ) );								break;
		case 255:	ci_var_set_i( sp_result, 	_ci_calc_bit_or( (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue ) );									break;
		case 256:	ci_var_set_i( sp_result, 	_ci_calc_bit_xor( (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue ) );								break;
		case 257:	ci_var_set_i( sp_result, 	_ci_calc_bit_not( (*(sp2-1))->data.ivalue ) );															break;
		case 258:	ci_var_set_i( sp_result, 	_ci_calc_bit_shift_left( (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue ) );							break;
		case 259:	ci_var_set_i( sp_result, 	_ci_calc_bit_shift_right( (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue ) );						break;
		case 260:	ci_var_set_i( sp_result, 	_ci_calc_bit_is_set( (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue ) );								break;
		
		
		//--------------------------------------------------------------------------
		// Misc
		//--------------------------------------------------------------------------
		
		// The sort functions sort an array. The values in this array of are indexes into the
		// original array.
		
		
		case 261:							_ci_calc_msort_v_3_3( *(sp2-4), *(sp2-3), (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue );			break;
		case 262:							_ci_calc_ssort_v_3_3( *(sp2-4), *(sp2-3), (*(sp2-2))->data.ivalue, (*(sp2-1))->data.ivalue );			break;
//		case 263:							_ci_calc_gsort( *(sp2-5), *(sp2-4), (*(sp2-3))->data.ivalue, *(sp2-2), (*(sp2-1))->data.ivalue );		break;
		
		
		// Return the size of a resizable array index. Index_numbers start at 1
		
		case 264:	ci_var_set_i( sp_result, 	_ci_calc_array_index_size( *(sp2-2), (*(sp2-1))->data.ivalue ) );										break;
		case 265:	ci_var_set_i( sp_result, 	_ci_calc_array_number_of_dimensions( *(sp2-1) ) );														break;
		
		
		//--------------------------------------------------------------------------
		// System
		//--------------------------------------------------------------------------
		
		case 266:							_ci_calc_syget_get_parameter( sp_result, *(sp2-1) );													break;
		case 267:							_ci_calc_syget_post_parameter( sp_result, *(sp2-1) );													break;
		case 268:							_ci_calc_syget_session_variable( sp_result, *(sp2-2), *(sp2-1) );										break;
		case 269:							_ci_calc_syset_session_variable( *(sp2-3), *(sp2-2), *(sp2-1) );										break;
		case 270:							_ci_calc_syexit( (*(sp2-1))->data.ivalue );															break;
		case 271:							_ci_calc_syget_ip_address( sp_result );																break;
		case 272:	ci_var_set_i( sp_result, 	_ci_calc_sylow_res_screen() );																			break;
		case 273:							_ci_calc_syset_process_background_priority();															break;

		case 331: 							_ci_calc_syget_get_parameter_key( sp_result, (*(sp2-1))->data.ivalue );				break;
		case 332: 							_ci_calc_syget_get_parameter_value( sp_result, (*(sp2-1))->data.ivalue );			break;
		case 333: ci_var_set_i( sp_result, 	_ci_calc_syget_get_parameter_count() );												break;
		case 334: 							_ci_calc_syget_post_parameter_key( sp_result, (*(sp2-1))->data.ivalue );			break;
		case 335: 							_ci_calc_syget_post_parameter_value( sp_result, (*(sp2-1))->data.ivalue );			break;
		case 336: ci_var_set_i( sp_result, 	_ci_calc_syget_post_parameter_count() );											break;
		
		
		// DEBUGGING
		//
		// Call this before syexit() when an error occures to prlong int the 
		// call stack for debugging purposes
		
//		case 274:							_ci_calc_sydump_call_stack();																			break;
		
		
		
		//--------------------------------------------------------------------------
		// PDF Functions
		//--------------------------------------------------------------------------
		
		
		case 274: 							_ci_calc_pdf_create( sp_result, (*(sp2-8))->data.nvalue, (*(sp2-7))->data.nvalue, *(sp2-6), *(sp2-5), *(sp2-4), *(sp2-3), *(sp2-2), *(sp2-1) );	break;
		case 275:							_ci_calc_pdf_set_font( *(sp2-2), *(sp2-1) );																										break;
		case 276:							_ci_calc_pdf_add_text( *(sp2-5), *(sp2-4), (*(sp2-3))->data.nvalue, (*(sp2-2))->data.nvalue, (*(sp2-1))->data.nvalue ); 							break;
		case 277:							_ci_calc_pdf_add_text_right_align( *(sp2-5), *(sp2-4), (*(sp2-3))->data.nvalue, (*(sp2-2))->data.nvalue, (*(sp2-1))->data.nvalue ); 				break;
		case 278:							_ci_calc_pdf_add_text_center_within_field( *(sp2-6), *(sp2-5), (*(sp2-4))->data.nvalue, (*(sp2-3))->data.nvalue, (*(sp2-2))->data.nvalue, (*(sp2-1))->data.nvalue ); 			break;
		case 279:							_ci_calc_pdf_add_text2( *(sp2-8), *(sp2-7), (*(sp2-6))->data.nvalue, (*(sp2-5))->data.nvalue, (*(sp2-4))->data.nvalue, (*(sp2-3))->data.ivalue, (*(sp2-2))->data.ivalue, (*(sp2-1))->data.nvalue );	break;
		case 280:							_ci_calc_pdf_add_text_wrap( *(sp2-10), *(sp2-9), (*(sp2-8))->data.nvalue, (*(sp2-7))->data.nvalue, (*(sp2-6))->data.nvalue, (*(sp2-5))->data.ivalue, (*(sp2-4))->data.nvalue, (*(sp2-3))->data.nvalue, (*(sp2-2))->data.nvalue, (*(sp2-1))->data.nvalue );		break;
		case 281:							_ci_calc_pdf_new_page( *(sp2-1) );																													break;
		case 282:							_ci_calc_pdf_save_to_file( *(sp2-2), *(sp2-1) );																									break;
		case 283:							_ci_calc_pdf_set_as_portrait( *(sp2-1) );																											break;
		case 284:							_ci_calc_pdf_set_as_landscape( *(sp2-1) );																											break;
		case 285:	ci_var_set_n( sp_result, 	_ci_calc_pdf_get_text_width( *(sp2-4), *(sp2-3), *(sp2-2), (*(sp2-1))->data.nvalue ) );															break;
		case 286:							_ci_calc_pdf_free( *(sp2-1) );																														break;
		case 287:							_ci_calc_pdf_get_error( sp_result, *(sp2-1) );																										break;
		case 288:							_ci_calc_pdf_clear_error( *(sp2-1) );																												break;
		


		//--------------------------------------------------------------------------
		// BST tree
		//--------------------------------------------------------------------------
		
		case 289: ci_var_set_p( sp_result, 	_ci_calc_c_bst_init( (*(sp2-1))->data.ivalue, source_file_id_txt ) );														break;
		case 290: 							_ci_calc_bst_get_key( sp_result, (ci_var *) (*(sp2-1))->data.pvalue, source_file_id_txt );									break;
		case 291: ci_var_set_p( sp_result, 	_ci_calc_bst_get_data_ptr( (*(sp2-1))->data.pvalue, source_file_id_txt ) );													break;
		
		case 292: ci_var_set_i( sp_result, 	_ci_calc_bst_insert_b( (*(sp2-3))->data.pvalue, *(sp2-2), (*(sp2-1))->data.pvalue, source_file_id_txt ) );					break;
		case 293: ci_var_set_i( sp_result, 	_ci_calc_bst_insert_s( (*(sp2-3))->data.pvalue, *(sp2-2), (*(sp2-1))->data.pvalue, source_file_id_txt ) );					break;
		case 304: ci_var_set_i( sp_result, 	_ci_calc_bst_insert_i( (*(sp2-3))->data.pvalue, (*(sp2-2))->data.ivalue, (*(sp2-1))->data.pvalue, source_file_id_txt ) );	break;
		
		case 294: 
				if ((*(sp2-1))->var_type != VAR_INT)
					ci_var_set_i( *(sp2-1), 0 );

				ci_var_set_p( sp_result, 	_ci_calc_bst_search_b( (*(sp2-3))->data.pvalue, (ci_var *) *(sp2-2), &((*(sp2-1))->data.ivalue), source_file_id_txt ) );	break;
		
		case 295: 
				if ((*(sp2-1))->var_type != VAR_INT)
					ci_var_set_i( *(sp2-1), 0 );

				ci_var_set_p( sp_result, 	_ci_calc_bst_search_s( (*(sp2-3))->data.pvalue, (ci_var *) *(sp2-2), &((*(sp2-1))->data.ivalue), source_file_id_txt ) );	break;

		case 305: 
				if ((*(sp2-1))->var_type != VAR_INT)
					ci_var_set_i( *(sp2-1), 0 );

				ci_var_set_p( sp_result, 	_ci_calc_bst_search_i( (*(sp2-3))->data.pvalue, ((ci_var *) (*(sp2-2)))->data.ivalue, &((*(sp2-1))->data.ivalue), source_file_id_txt ) );	break;
		
		case 296: ci_var_set_i( sp_result, 	_ci_calc_bst_key_is_in_tree_b( (*(sp2-2))->data.pvalue, *(sp2-1), source_file_id_txt ) );								break;
		case 297: ci_var_set_i( sp_result, 	_ci_calc_bst_key_is_in_tree_s( (*(sp2-2))->data.pvalue, *(sp2-1), source_file_id_txt ) );								break;
		case 306: ci_var_set_i( sp_result, 	_ci_calc_bst_key_is_in_tree_i( (*(sp2-2))->data.pvalue, (*(sp2-1))->data.ivalue, source_file_id_txt ) );				break;
		
		case 298: ci_var_set_i( sp_result, 	_ci_calc_bst_delete_item_b( (*(sp2-2))->data.pvalue, (*(sp2-1)), source_file_id_txt ) );								break;
		case 307: ci_var_set_i( sp_result, 	_ci_calc_bst_delete_item_s( (*(sp2-2))->data.pvalue, (*(sp2-1)), source_file_id_txt ) );								break;
		case 308: ci_var_set_i( sp_result, 	_ci_calc_bst_delete_item_i( (*(sp2-2))->data.pvalue, (*(sp2-1))->data.ivalue, source_file_id_txt ) );					break;
		
		case 299: ci_var_set_p( sp_result, 	_ci_calc_bst_tree_first_item2( (*(sp2-2))->data.pvalue, (*(sp2-1))->data.ivalue, source_file_id_txt ) );				break;
		case 300: ci_var_set_p( sp_result, 	_ci_calc_bst_tree_next_item2( (*(sp2-2))->data.pvalue, (*(sp2-1))->data.ivalue, source_file_id_txt ) );					break;
		case 301: ci_var_set_i( sp_result, 	_ci_calc_bst_total_items_in_list( (*(sp2-1))->data.pvalue, source_file_id_txt ) );										break;
		case 302: ci_var_set_i( sp_result, 	_ci_calc_bst_unique_items_in_list( (*(sp2-1))->data.pvalue, source_file_id_txt ) );										break;

		case 309: 							_ci_calc_bst_free( (*(sp2-1))->data.pvalue, source_file_id_txt );														break;
				


		//--------------------------------------------------------------------------
		// Embedded macro interface
		//--------------------------------------------------------------------------

		case 329: 						_ci_calc_interpreter_embedded_overall_init( source_file_id_txt );																				break;

		case 313: ci_var_set_p( sp_result, _ci_calc_interpreter_embedded_init( (*(sp2-2)), (*(sp2-1)), source_file_id_txt ) );																		break;
	
		case 314: 						_ci_calc_interpreter_retrieve_global_variable_string( (*(sp2-3))->data.pvalue, (*(sp2-2)), (*(sp2-1))->data.ivalue, source_file_id_txt );		break;
	
		case 315: ci_var_set_i( sp_result, _ci_calc_interpreter_retrieve_global_variable_int( (*(sp2-2))->data.pvalue, (*(sp2-1))->data.ivalue, source_file_id_txt ) );					break;
																				
		case 316: ci_var_set_i( sp_result, _ci_calc_interpreter_retrieve_global_variable_bool( (*(sp2-2))->data.pvalue, (*(sp2-1))->data.ivalue, source_file_id_txt ) );				break;
		
		case 317: ci_var_set_i( sp_result, _ci_calc_interpreter_retrieve_global_variable_decimal( (*(sp2-2))->data.pvalue, (*(sp2-1))->data.ivalue, source_file_id_txt ) );				break;
		
		case 318: ci_var_set_n( sp_result, _ci_calc_interpreter_retrieve_global_variable_double( (*(sp2-2))->data.pvalue, (*(sp2-1))->data.ivalue, source_file_id_txt ) );				break;
		
		case 319: ci_var_set_i( sp_result, _ci_calc_interpreter_add_global_variable( (*(sp2-9))->data.pvalue,
																	(*(sp2-8)), 
																	 (*(sp2-7)), 
																	 (*(sp2-6))->data.ivalue, 
																	 (*(sp2-5))->data.ivalue, 
																	 (*(sp2-4))->data.ivalue, 
																	 (*(sp2-3))->data.ivalue, 
																	 (*(sp2-2))->data.nvalue, 
																	 (*(sp2-1)),
																	 source_file_id_txt ) );																							break;
	
		case 320: ci_var_set_i( sp_result, _ci_calc_interpreter_run_program( (*(sp2-20))->data.pvalue,
															(*(sp2-19)), 
														   (*(sp2-18)), 
														   (*(sp2-17)),
														   (*(sp2-16)),
														   (*(sp2-15)),
														   (*(sp2-14)),
														   (*(sp2-13)),
														   (*(sp2-12))->data.ivalue, 
														   (*(sp2-11))->data.ivalue,
														   (*(sp2-10))->data.ivalue, 
														   (*(sp2-9))->data.ivalue,
														   (*(sp2-8))->data.ivalue, 
														   (*(sp2-7))->data.ivalue, 
														   (*(sp2-6))->data.ivalue, 
														   (*(sp2-5))->data.ivalue,
														   (*(sp2-4))->data.ivalue, 
														   (*(sp2-3))->data.ivalue,
														   (*(sp2-2))->data.ivalue,
														   (*(sp2-1))->data.ivalue,
														   source_file_id_txt ) );																		break;
	
	
	
		case 321: 						_ci_calc_set_conditional_compilation_constant( (*(sp2-1)) );													break;
	
		case 322: 						_ci_calc_set_str_constant( (*(sp2-3))->data.pvalue, (*(sp2-2)), (*(sp2-1)), source_file_id_txt );				break; 
	
		case 323: 						_ci_calc_clear_string_constant_saves( (*(sp2-1))->data.pvalue, source_file_id_txt );							break;
	
		case 324: 						_ci_calc_restore_string_constants( (*(sp2-1))->data.pvalue, source_file_id_txt );								break; 
	
		case 325: ci_var_set_p( sp_result, _ci_calc_interpreter_retrieve_runtime_data_ptr( (*(sp2-1)), source_file_id_txt ) );							break;
	
//		case 326: 						_ci_calc_start_new_icode_segment( source_file_id_txt );															break;
	
		case 327: 						_ci_calc_interpreter_run_icode( (*(sp2-5))->data.pvalue,
															(*(sp2-4))->data.ivalue, 
															(*(sp2-3))->data.ivalue, 
															(*(sp2-2))->data.ivalue, 
															(*(sp2-1))->data.ivalue,
															source_file_id_txt );																		break;
	
		case 328: 						_ci_calc_interpreter_free_all_system_memory_allocations( source_file_id_txt );									break;
	




// Next available builtin function number:	337


				
		default: 
				cout << "Unrecognised builtin function number.";
				exit( 1 );
				
	}
}
