//<?		// Turn on editor syntax highlighting

                              // (c) Copyright Mark McIlroy 2023

    using namespace std;
                              
    #include <string>
    #include <iostream>
    #include <cmath>
    #include "ci_calc.h"
        
    #include "library.cpph"

    
    // stackframe:
    //
    //
    //    local variables
    //    result variable	
    //
 	
 	// Stack 2
 	//
 	//     	Function argument pointers
 	//     	Member variable pointer
 	//		Saved SP
 	//		Saved BP
 	
	
	const int STACK_CHECK_VALUE = 896589;
 	
	void init_data_type( ci_var *vptr, string type1 );
	ci_var *call_function_code( bool runtime_checks, int function_number, int stackframe_size );
	void end_function_code( bool runtime_checks, bool builtin_function );
	
	char u32_empty_string[200];
	char u32_null_date[200];
	char u32_null_time[200];
	char u32_null_datetime[200];



	
	void run_icode( bool initialise_variables, bool runtime_checks, bool is_web_page, bool show_large_strings_warnings )
	{
		bst_tree_node_cpp bst_ptr;
		t_local_variable *nptr_local_variable;
		t_bst_string_constant *nptr_string_constant;
		t_global_variable *nptr_global_variable;
		int function_number;
		int function_table_number;
	 	int item;
		bool found;
		ci_var *vptr, *vptr_from, *vptr_to, *vptr_end;
//		ci_var *bp_new, *sp_base;
		ci_var *sp_base;
		char *ptr2;
		rarray *rarray_ptr;
		char *ptr;
		int_64 len1, len2;
		int stat;
		int_64 array_lookup_value;
		int previous_line_number;
		bool found_main;
		char small_str_buffer[SMALL_STRING_BUFFER_SIZE];
		char small_str_buffer2[SMALL_STRING_BUFFER_SIZE];
		char medium_str_buffer[MEDIUM_STRING_BUFFER_SIZE];
		bool not_finished;
		long int count;
		bool has_main_function;
		int i;
		string result_text;
		int op;
		int offset;
		string s;
		string input_filename;
		int line_number;
		int push_flags;	
		string type1;
		int size;
		string function_name;
		int argument_count;
		string text;

//		ic = gruntime_data->ic;
			
		ci_str_u8_to_u32( u32_empty_string, "" );
		ci_str_u8_to_u32( u32_null_date, "0000-00-00" );
		ci_str_u8_to_u32( u32_null_time, "99:99:99" );
		ci_str_u8_to_u32( u32_null_datetime, "0000-00-00 99:99:99" );


		item = 0;

	
		memset( gruntime_data->stack, 0, STACK_SIZE );
		memset( gruntime_data->stack2, 0, STACK2_SIZE );
		memset( gruntime_data->stack3, 0, STACK3_SIZE );
		
		gruntime_data->sp = gruntime_data->stack+2;
		
		gruntime_data->bp = gruntime_data->stack+2;
		
		gruntime_data->sp2 = gruntime_data->stack2;

		gruntime_data->sp3 = gruntime_data->stack3;
	
		ci_var_set_i( gruntime_data->stack, dest_argc );
		
		gruntime_data->stack2[1] = gruntime_data->stack;
		gruntime_data->stack2[2] = gruntime_data->stack+1;
		 
		gruntime_data->sp2 = gruntime_data->stack2 + 3;
		gruntime_data->bp_stack2 = gruntime_data->stack2 + 3;
	 	
		
	
		rarray_ptr = (rarray *) _ci_malloc( sizeof( rarray ) );
		
		rarray_ptr->number_of_dimensions = 1;
		
		rarray_ptr->sizeof_array_element = sizeof( ci_var );
		
	 	rarray_ptr->index_size[0] = dest_argc;
	
		rarray_ptr->total_size = dest_argc * sizeof( ci_var );
	
		ptr2 = (char *) _ci_malloc( rarray_ptr->total_size );
		
		memset( ptr2, 0, rarray_ptr->total_size );
	
		rarray_ptr->datap = ptr2;
		
					
		for (i=0; i < dest_argc; i++)
			ci_var_set_s( (ci_var *) (ptr2 + i * sizeof( ci_var )), dest_argv[i].c_str() );
		
		
		(gruntime_data->stack+1)->var_type = VAR_RESIZABLE_ARRAY;
		(gruntime_data->stack+1)->data.pvalue = (char *) rarray_ptr;
		
		
		count = 0;
	
		ascii_only = false;
		
		bytes_per_char = 4;
		
		gruntime_data->ic_ptr = gruntime_data->ic_pos_of_main_function;
					
		gruntime_data->sp = gruntime_data->stack + gruntime_data->initial_stack_offset;

		previous_line_number = 0;

		for (; gruntime_data->ic_ptr < gruntime_data->ic_end; gruntime_data->ic_ptr++)
		{
//			count++;

//			if (count > 50000000)
//				ci_runtime_error( 181, "Possible infinite loop." );
					
			op = gruntime_data->ic[gruntime_data->ic_ptr].op;
			
			if (gshow_execution_trace)
			{
				if (gruntime_data->ic[gruntime_data->ic_ptr].line_number != previous_line_number)
				{
					previous_line_number = gruntime_data->ic[gruntime_data->ic_ptr].line_number;
					
					if (is_web_page)	
						ci_output( "    <br><br>\n\n" );
					else
						ci_output( "\n\n" );
				
					ci_output( "Line: " + to_string( gruntime_data->ic[gruntime_data->ic_ptr].line_number ) + ": " + ci_iconvert_to_html( ginput_text[gruntime_data->ic[gruntime_data->ic_ptr].input_filenumber][gruntime_data->ic[gruntime_data->ic_ptr].line_number] ) );
					
					if (is_web_page)	
						ci_output( "    <br>" );
				}
									
				if (is_web_page)	
					ci_output( "    <br>\n" );
				else
					ci_output( "\n" );

				cout << "Ic_ptr: ";

				cout << gruntime_data->ic_ptr;
					
				cout << ": SP: ";

				cout << (gruntime_data->sp - gruntime_data->stack);

				cout << ": gruntime_data->bp_stack2: ";

				cout << gruntime_data->bp_stack2;
				
				cout << ": ";

				cout << op_descriptions[op];
					
				if (is_jump_op( op ))
				{
					cout << " to address ";
					cout << gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
				}
				
				cout << std::flush;
			}

					
			switch (op)
			{
					
					// 12. Boolean operators, and or xor not
					
				case OP_AND:		gruntime_data->sp--;	(gruntime_data->sp-1)->data.ivalue = gruntime_data->sp->data.ivalue && (gruntime_data->sp-1)->data.ivalue;		break;
				case OP_OR:			gruntime_data->sp--;	(gruntime_data->sp-1)->data.ivalue = gruntime_data->sp->data.ivalue || (gruntime_data->sp-1)->data.ivalue;		break;
				case OP_NOT:				(gruntime_data->sp-1)->data.ivalue = ! (gruntime_data->sp-1)->data.ivalue;						break;

				case OP_XOR:	
									gruntime_data->sp--;	
				
									if ((gruntime_data->sp->data.ivalue == 0 && (gruntime_data->sp-1)->data.ivalue != 0) ||
										(gruntime_data->sp->data.ivalue != 0 && (gruntime_data->sp-1)->data.ivalue == 0))
											(gruntime_data->sp-1)->data.ivalue = 1;
									else
											(gruntime_data->sp-1)->data.ivalue = 0;
										
									break;
								
			
					// 1. Relational operations: ==, !=, >, <, >=, <=
					
				case OP_EQ_INT:			gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.ivalue == gruntime_data->sp->data.ivalue );		break;
				case OP_NE_INT:			gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.ivalue != gruntime_data->sp->data.ivalue );		break;
				case OP_LT_INT:			gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.ivalue < gruntime_data->sp->data.ivalue );		break;
				case OP_GT_INT:			gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.ivalue > gruntime_data->sp->data.ivalue );		break;
				case OP_LE_INT:			gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.ivalue <= gruntime_data->sp->data.ivalue );		break;
				case OP_GE_INT:			gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.ivalue >= gruntime_data->sp->data.ivalue );		break;
			
				case OP_EQ_DOUBLE:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.nvalue == gruntime_data->sp->data.nvalue );		break;
				case OP_NE_DOUBLE:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.nvalue != gruntime_data->sp->data.nvalue );		break;
				case OP_LT_DOUBLE:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.nvalue < gruntime_data->sp->data.nvalue );		break;
				case OP_GT_DOUBLE:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.nvalue > gruntime_data->sp->data.nvalue );		break;
				case OP_LE_DOUBLE:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.nvalue <= gruntime_data->sp->data.nvalue );		break;
				case OP_GE_DOUBLE:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.nvalue >= gruntime_data->sp->data.nvalue );		break;
			
				case OP_EQ_DECIMAL:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.dvalue == gruntime_data->sp->data.dvalue );		break;
				case OP_NE_DECIMAL:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.dvalue != gruntime_data->sp->data.dvalue );		break;
				case OP_LT_DECIMAL:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.dvalue < gruntime_data->sp->data.dvalue );		break;
				case OP_GT_DECIMAL:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.dvalue > gruntime_data->sp->data.dvalue );		break;
				case OP_LE_DECIMAL:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.dvalue <= gruntime_data->sp->data.dvalue );		break;
				case OP_GE_DECIMAL:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.dvalue >= gruntime_data->sp->data.dvalue );		break;
			
				case OP_EQ_STRING:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, ci_str_u32_eq( (gruntime_data->sp-1)->data.svalue, gruntime_data->sp->data.svalue ) );			break;
				case OP_NE_STRING:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, ! ci_str_u32_eq( (gruntime_data->sp-1)->data.svalue, gruntime_data->sp->data.svalue ) );		break;
				case OP_LT_STRING:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, ci_str_u32_cmp( (gruntime_data->sp-1)->data.svalue, gruntime_data->sp->data.svalue ) < 0 );		break;
				case OP_GT_STRING:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, ci_str_u32_cmp( (gruntime_data->sp-1)->data.svalue, gruntime_data->sp->data.svalue ) > 0 );		break;
				case OP_LE_STRING:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, ci_str_u32_cmp( (gruntime_data->sp-1)->data.svalue, gruntime_data->sp->data.svalue ) <= 0 );	break;
				case OP_GE_STRING:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, ci_str_u32_cmp( (gruntime_data->sp-1)->data.svalue, gruntime_data->sp->data.svalue ) >= 0 );	break;
			
				case OP_EQ_BOOL:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.ivalue == gruntime_data->sp->data.ivalue );		break;
				case OP_NE_BOOL:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.ivalue != gruntime_data->sp->data.ivalue );		break;
				
				case OP_EQ_BINARY:		

					gruntime_data->sp--;
										
					len1 = *((int_64 *) ((gruntime_data->sp - 1)->data.bvalue));
					len2 = *((int_64 *) ((gruntime_data->sp)->data.bvalue));
					
					stat = 0;
								 
					if (len1 == len2)
					{
						if (memcmp( (gruntime_data->sp-1)->data.bvalue, gruntime_data->sp->data.bvalue, len1 + sizeof( int_64 ) ) == 0)
							stat = 1;
					}
				
					ci_var_set_i( gruntime_data->sp-1, stat  );		
					
					break;

				case OP_NE_BINARY:

					gruntime_data->sp--;
										
					len1 = *((int_64 *) ((gruntime_data->sp - 1)->data.bvalue));
					len2 = *((int_64 *) ((gruntime_data->sp)->data.bvalue));
					
					stat = 0;
								 
					if (len1 == len2)
					{
						if (memcmp( (gruntime_data->sp-1)->data.bvalue, gruntime_data->sp->data.bvalue, len1 + sizeof( int_64 ) ) == 0)
							stat = 1;
					}
				
					ci_var_set_i( gruntime_data->sp-1, ! stat  );		
					
					break;
					
				case OP_EQ_LINK:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.pvalue == gruntime_data->sp->data.pvalue );		break;
				case OP_NE_LINK:		gruntime_data->sp--;	ci_var_set_i( gruntime_data->sp-1, (gruntime_data->sp-1)->data.pvalue != gruntime_data->sp->data.pvalue );		break;
					
							
							
					// 2. Arithmetic operations +, -, *, /, ^, mod
									
				case OP_ADD_INT:			gruntime_data->sp--;	(gruntime_data->sp-1)->data.ivalue = (gruntime_data->sp-1)->data.ivalue + gruntime_data->sp->data.ivalue;	break;
				case OP_SUBTRACT_INT:		gruntime_data->sp--;	(gruntime_data->sp-1)->data.ivalue = (gruntime_data->sp-1)->data.ivalue - gruntime_data->sp->data.ivalue;	break;
				case OP_MULT_INT:			gruntime_data->sp--;	(gruntime_data->sp-1)->data.ivalue = (gruntime_data->sp-1)->data.ivalue * gruntime_data->sp->data.ivalue;	break;
				case OP_MOD_INT:			gruntime_data->sp--;	(gruntime_data->sp-1)->data.ivalue = (gruntime_data->sp-1)->data.ivalue % gruntime_data->sp->data.ivalue;	break;
				case OP_NEGATE_INT:			(gruntime_data->sp-1)->data.ivalue = - (gruntime_data->sp-1)->data.ivalue;							break;
				
				case OP_ADD_DOUBLE:			gruntime_data->sp--;	(gruntime_data->sp-1)->data.nvalue = (gruntime_data->sp-1)->data.nvalue + gruntime_data->sp->data.nvalue;	break;
				case OP_SUBTRACT_DOUBLE:	gruntime_data->sp--;	(gruntime_data->sp-1)->data.nvalue = (gruntime_data->sp-1)->data.nvalue - gruntime_data->sp->data.nvalue;	break;
				case OP_MULT_DOUBLE:		gruntime_data->sp--;	(gruntime_data->sp-1)->data.nvalue = (gruntime_data->sp-1)->data.nvalue * gruntime_data->sp->data.nvalue;	break;
				case OP_NEGATE_DOUBLE:		(gruntime_data->sp-1)->data.nvalue = - (gruntime_data->sp-1)->data.nvalue;							break;
				
				case OP_ADD_DECIMAL:		gruntime_data->sp--;	(gruntime_data->sp-1)->data.dvalue = (gruntime_data->sp-1)->data.dvalue + gruntime_data->sp->data.dvalue;	break;
				case OP_SUBTRACT_DECIMAL:	gruntime_data->sp--;	(gruntime_data->sp-1)->data.dvalue = (gruntime_data->sp-1)->data.dvalue - gruntime_data->sp->data.dvalue;	break;
				case OP_NEGATE_DECIMAL:		(gruntime_data->sp-1)->data.dvalue = - (gruntime_data->sp-1)->data.dvalue;							break;
									
				case OP_MULT_DECIMAL:		gruntime_data->sp--;	
				
											(gruntime_data->sp-1)->data.dvalue = (long int) (((long double) (gruntime_data->sp-1)->data.dvalue * (long double) gruntime_data->sp->data.dvalue) / VAR_DECIMAL_SCALE + (long double) VAR_DECIMAL_ROUNDING_OFFSET);	
				
											break;
									
				case OP_DIVIDE_INT:

						gruntime_data->sp--;
						
						if (gruntime_data->sp->data.ivalue == 0)
							ci_runtime_error( 182, "Divide by zero." ); 

						(gruntime_data->sp-1)->data.ivalue = ;

//						(gruntime_data->sp-1)->data.ivalue = (gruntime_data->sp-1)->data.ivalue / gruntime_data->sp->data.ivalue;
						
						ci_var_set_n( gruntime_data->sp-1, (long double) (gruntime_data->sp-1)->data.ivalue / (long double) gruntime_data->sp->data.ivalue );
							
						
						break;
																
					
				case OP_DIVIDE_DOUBLE:

						gruntime_data->sp--;
						
						if (gruntime_data->sp->data.nvalue == 0)
							ci_runtime_error( 183, "Divide by zero." ); 

						(gruntime_data->sp-1)->data.nvalue = (gruntime_data->sp-1)->data.nvalue / gruntime_data->sp->data.nvalue;	
						
						break;
																

				case OP_DIVIDE_DECIMAL:

						gruntime_data->sp--;
						
						if (gruntime_data->sp->data.dvalue == 0)
							ci_runtime_error( 184, "Divide by zero." ); 

						(gruntime_data->sp-1)->data.dvalue = (long int) (((long double) (gruntime_data->sp-1)->data.dvalue / (long double) gruntime_data->sp->data.dvalue) * VAR_DECIMAL_SCALE + (long double) VAR_DECIMAL_ROUNDING_OFFSET);	
						
						break;

				case OP_EXP_INT:			gruntime_data->sp--;	(gruntime_data->sp-1)->data.ivalue = (long int) pow( (double) (gruntime_data->sp-1)->data.ivalue, (double) gruntime_data->sp->data.ivalue );		break;
				case OP_EXP_DOUBLE:			gruntime_data->sp--;	(gruntime_data->sp-1)->data.nvalue = (double) pow( (gruntime_data->sp-1)->data.nvalue, gruntime_data->sp->data.nvalue );							break;
				case OP_EXP_DECIMAL:		gruntime_data->sp--;	(gruntime_data->sp-1)->data.dvalue = (long int) pow( (double) (gruntime_data->sp-1)->data.dvalue / (double) VAR_DECIMAL_SCALE, (double) gruntime_data->sp->data.dvalue / (double) VAR_DECIMAL_SCALE ) * VAR_DECIMAL_SCALE;	break;


		// 3. Push

				case OP_PUSH_VAR:
				{
					size = gruntime_data->ic[gruntime_data->ic_ptr].size;
	
					gruntime_data->sp--;
					
					vptr = (ci_var *) (gruntime_data->sp->data.pvalue);

					if (gshow_execution_trace)
					{
						cout << ": address: ";
						cout << to_string( (long int) vptr ); 
						cout << ": value: ";

						var_type = vptr->var_type;

						if (var_type == VAR_INT)
						{
							cout << vptr->data.ivalue;
							cout << ": type: int";
						}
						else
						if (var_type == VAR_DECIMAL)
						{
							cout << vptr->data.dvalue;
							cout << ": type: decimal";
						}
						else
						if (var_type == VAR_DOUBLE)
						{
							cout << vptr->data.nvalue;
							cout << ": type: double";
						}
						else
						if (var_type == VAR_STRING)
						{
							if (*((int_64 *) (vptr->data.svalue)) < 100)
							{
								ci_str_u32_to_u8( small_str_buffer, vptr->data.svalue, SMALL_STRING_BUFFER_SIZE );
				
								cout << "'"; 
								cout << small_str_buffer;
								cout << "'";
							} 
						}
					}
					
					if (runtime_checks)
					{
						if ((gruntime_data->sp - gruntime_data->stack) + size >= STACK_SIZE)
							ci_runtime_error( 185, "Stack 1 overflow." );
					}
					
					if (size == 1)
					{
						push_flags = gruntime_data->ic[gruntime_data->ic_ptr].push_flags;
									
						if (((push_flags & PUSH_FLAGS_PRE_INC) != 0) || ((push_flags & PUSH_FLAGS_PRE_DEC) != 0))
						{
							var_type = vptr->var_type;
							
							if (var_type == VAR_INT)
							{
								if ((push_flags & PUSH_FLAGS_PRE_INC) != 0)								vptr->data.ivalue++;		else
								if ((push_flags & PUSH_FLAGS_PRE_DEC) != 0)								vptr->data.ivalue--;
							}
							else
							if (var_type == VAR_DECIMAL)
							{
								if ((push_flags & PUSH_FLAGS_PRE_INC) != 0)								vptr->data.dvalue += VAR_DECIMAL_SCALE;		else
								if ((push_flags & PUSH_FLAGS_PRE_DEC) != 0)								vptr->data.dvalue -= VAR_DECIMAL_SCALE;
							}
							else
							if (var_type == VAR_DOUBLE)
							{
								if ((push_flags & PUSH_FLAGS_PRE_INC) != 0)								vptr->data.nvalue++;		else
								if ((push_flags & PUSH_FLAGS_PRE_DEC) != 0)								vptr->data.nvalue--;
							}
						}
		
						if (runtime_checks)
							ci_copy_var( gruntime_data->sp, vptr );
						else
							ci_copy_var_no_debug( gruntime_data->sp, vptr );
				
						if (((push_flags & PUSH_FLAGS_POST_INC) != 0) || ((push_flags & PUSH_FLAGS_POST_DEC) != 0))
						{
							var_type = vptr->var_type;
							
							if (var_type == VAR_INT)
							{
								if ((push_flags & PUSH_FLAGS_POST_INC) != 0)								vptr->data.ivalue++;		else
								if ((push_flags & PUSH_FLAGS_POST_DEC) != 0)								vptr->data.ivalue--;
							}
							else
							if (var_type == VAR_DECIMAL)
							{
								if ((push_flags & PUSH_FLAGS_POST_INC) != 0)								vptr->data.dvalue += VAR_DECIMAL_SCALE;	else
								if ((push_flags & PUSH_FLAGS_POST_DEC) != 0)								vptr->data.dvalue -= VAR_DECIMAL_SCALE;
							}
							else
							if (var_type == VAR_DOUBLE)
							{
								if ((push_flags & PUSH_FLAGS_POST_INC) != 0)								vptr->data.nvalue++;		else
								if ((push_flags & PUSH_FLAGS_POST_DEC) != 0)								vptr->data.nvalue--;
							}
						}
						
						gruntime_data->sp++;
					}
					else
					{
						vptr_end = vptr + size;
					
						if (runtime_checks)
						{
							while (vptr < vptr_end)
								ci_copy_var( gruntime_data->sp++, vptr++ );
						}
						else
						{
							while (vptr < vptr_end)
								ci_copy_var_no_debug( gruntime_data->sp++, vptr++ );
						}
					}							
				}
				break;
			
				case OP_PUSH_NEW_ALLOC:
				{
					if (runtime_checks)
					{
						if ((gruntime_data->sp - gruntime_data->stack) + 1 >= STACK_SIZE)
							ci_runtime_error( 186, "Stack 1 overflow." );
					}
					
					size = gruntime_data->ic[gruntime_data->ic_ptr].size * sizeof( ci_var );
					
					ptr = (char *) new dyn_block;
					
					((dyn_block *) ptr)->status = 1;
					((dyn_block *) ptr)->block_size = size;
					((dyn_block *) ptr)->type_map = gruntime_data->ic[gruntime_data->ic_ptr].type_map;
					
					((dyn_block *) ptr)->data_ptr = (char *) _ci_malloc( size );

					memset( ((dyn_block *) ptr)->data_ptr, 0, size );
  				
					ci_var_set_p( gruntime_data->sp++, ptr );
				}
				break;
			
				case OP_PUSH_DEREFERENCE_0:
				{
					ci_var *base;
					
					base = (ci_var *) ((gruntime_data->sp-1)->data.pvalue);

					if (base->data.pvalue == NULL)
						ci_runtime_error( 187, "Attempt to access a link destination on a null link " ); 
			
					if (((dyn_block *) base->data.pvalue)->status == 2)
						ci_runtime_error( 1140, "Attempt to access a data item that has been freed." );	

					if (((dyn_block *) base->data.pvalue)->status != 1)
						ci_runtime_error( 1141, "Corrupt memory." );	
			
					if (gruntime_data->ic[gruntime_data->ic_ptr].type_map != "")
					{
						if (((dyn_block *) base->data.pvalue)->type_map != "")
						{
							if (((dyn_block *) base->data.pvalue)->type_map != gruntime_data->ic[gruntime_data->ic_ptr].type_map)
								ci_runtime_error( 205, "Link type does not match the required type." );
						}
					}
			
					ci_var_set_p( gruntime_data->sp-1, ((dyn_block *) base->data.pvalue)->data_ptr );
			
//					ci_var_set_p( gruntime_data->sp-1, base->data.pvalue );
				}
				break;
			
				case OP_PUSH_ADDR_GLOBAL_VAR:
				{
					if (runtime_checks)
					{
						if ((gruntime_data->sp - gruntime_data->stack) + 1 >= STACK_SIZE)
							ci_runtime_error( 188, "Stack 1 overflow." );
					}
					
					if (gshow_execution_trace)
					{
						cout << " " + to_string( gruntime_data->ic[gruntime_data->ic_ptr].offset ) + " " + gruntime_data->ic[gruntime_data->ic_ptr].variable_name;
						cout << ": address: ";
						cout << (long int) (gruntime_data->global_variable_segment + gruntime_data->ic[gruntime_data->ic_ptr].offset); 
					}
					
					ci_var_set_p( gruntime_data->sp, gruntime_data->global_variable_segment + gruntime_data->ic[gruntime_data->ic_ptr].offset );
					
					gruntime_data->sp++;
				}
				break;
			
				case OP_PUSH_ADDR_LOC_VAR:
				{
					if (runtime_checks)
					{
						if ((gruntime_data->sp - gruntime_data->stack) + 1 >= STACK_SIZE)
							ci_runtime_error( 189, "Stack 1 overflow." );
					}
					
					if (gshow_execution_trace)
					{
						cout << " " + to_string( gruntime_data->ic[gruntime_data->ic_ptr].offset ) + " " + gruntime_data->ic[gruntime_data->ic_ptr].variable_name;
						cout << ": address: ";
						cout << (long int) (gruntime_data->bp + gruntime_data->ic[gruntime_data->ic_ptr].offset); 
					}
						
					ci_var_set_p( gruntime_data->sp, (char *) (gruntime_data->bp + gruntime_data->ic[gruntime_data->ic_ptr].offset) );
					
					gruntime_data->sp++;
				}
				break;
			
				case OP_PUSH_ADDR_FUNCTION_PARAMETER:
				{
					if (runtime_checks)
					{
						if ((gruntime_data->sp - gruntime_data->stack) + 1 >= STACK_SIZE)
							ci_runtime_error( 190, "Stack 1 overflow." );
					}
					
					if (gshow_execution_trace)
					{
						cout << " " + to_string( gruntime_data->ic[gruntime_data->ic_ptr].offset ) + " " + gruntime_data->ic[gruntime_data->ic_ptr].variable_name;
						cout << ": address: ";
						cout << (long int) *(gruntime_data->bp_stack2 - gruntime_data->ic[gruntime_data->ic_ptr].offset); 
					}
					
					ci_var_set_p( gruntime_data->sp, (char *) *(gruntime_data->bp_stack2 - gruntime_data->ic[gruntime_data->ic_ptr].offset) );
					
					gruntime_data->sp++;
				}
				break;

				case OP_PUSH_VAR_1_GLOBAL:
				{
					if (runtime_checks)
					{
						if ((gruntime_data->sp - gruntime_data->stack) + 1 >= STACK_SIZE)
							ci_runtime_error( 191, "Stack 1 overflow." );
					}
					
					if (gshow_execution_trace)
					{
						cout << " " + to_string( gruntime_data->ic[gruntime_data->ic_ptr].offset ) + " " + gruntime_data->ic[gruntime_data->ic_ptr].variable_name;
						cout << ": address: ";
						cout << (long int) (gruntime_data->global_variable_segment + gruntime_data->ic[gruntime_data->ic_ptr].offset); 
					}
					
					if (runtime_checks)
						ci_copy_var( gruntime_data->sp++, gruntime_data->global_variable_segment + gruntime_data->ic[gruntime_data->ic_ptr].offset );
					else
						ci_copy_var_no_debug( gruntime_data->sp++, gruntime_data->global_variable_segment + gruntime_data->ic[gruntime_data->ic_ptr].offset );
				}
				break;
			
				case OP_PUSH_VAR_1_LOC:
				{
					if (runtime_checks)
					{
						if ((gruntime_data->sp - gruntime_data->stack) + 1 >= STACK_SIZE)
							ci_runtime_error( 192, "Stack 1 overflow." );
					}
					
					if (gshow_execution_trace)
					{
						cout << " " + to_string( gruntime_data->ic[gruntime_data->ic_ptr].offset ) + " " + gruntime_data->ic[gruntime_data->ic_ptr].variable_name;
						cout << ": address: ";
						cout << (long int) (gruntime_data->bp + gruntime_data->ic[gruntime_data->ic_ptr].offset); 
					}
					
					if (runtime_checks)
						ci_copy_var( gruntime_data->sp++, gruntime_data->bp + gruntime_data->ic[gruntime_data->ic_ptr].offset );
					else
						ci_copy_var_no_debug( gruntime_data->sp++, gruntime_data->bp + gruntime_data->ic[gruntime_data->ic_ptr].offset );
				}
				break;
			
				case OP_PUSH_VAR_1_FUNCTION_PARAMETER:
				{
					if (runtime_checks)
					{
						if ((gruntime_data->sp - gruntime_data->stack) + 1 >= STACK_SIZE)
							ci_runtime_error( 193, "Stack 1 overflow." );
					}
					
					if (gshow_execution_trace)
					{
						cout << " " + to_string( gruntime_data->ic[gruntime_data->ic_ptr].offset ) + " " + gruntime_data->ic[gruntime_data->ic_ptr].variable_name;
						cout << ": address: ";
						cout << (long int) *(gruntime_data->bp_stack2 - gruntime_data->ic[gruntime_data->ic_ptr].offset); 
					}
					
					if (runtime_checks)
						ci_copy_var( gruntime_data->sp++, *(gruntime_data->bp_stack2 - gruntime_data->ic[gruntime_data->ic_ptr].offset) );
					else
						ci_copy_var_no_debug( gruntime_data->sp++, *(gruntime_data->bp_stack2 - gruntime_data->ic[gruntime_data->ic_ptr].offset) );
				}
				break;

				case OP_PUSH_ADDR_SP_REL:
				{
					if (runtime_checks)
					{
						if ((gruntime_data->sp - gruntime_data->stack) + 1 >= STACK_SIZE)
							ci_runtime_error( 194, "Stack 1 overflow." );
					}
					
					ci_var_set_p( gruntime_data->sp, gruntime_data->sp + gruntime_data->ic[gruntime_data->ic_ptr].offset );
					
					gruntime_data->sp++;
				}
				break;

			
				case OP_PUSH_CONST_LINK:		
				
					if (runtime_checks)
					{
						if ((gruntime_data->sp - gruntime_data->stack) + 1 >= STACK_SIZE)
							ci_runtime_error( 195, "Stack 1 overflow." );
					}
				
					ci_var_set_p( gruntime_data->sp++, NULL );						
					
				break;
					
				case OP_PUSH_CONST_INT:

					if (runtime_checks)
					{
						if ((gruntime_data->sp - gruntime_data->stack) + 1 >= STACK_SIZE)
							ci_runtime_error( 196, "Stack 1 overflow." );
					}
					
					if (gshow_execution_trace)
						cout << ": " + to_string( gruntime_data->ic[gruntime_data->ic_ptr].ivalue );
					
					ci_var_set_i( gruntime_data->sp++, gruntime_data->ic[gruntime_data->ic_ptr].ivalue );			
					
				break;
					
				case OP_PUSH_CONST_DECIMAL:		

					if (runtime_checks)
					{
						if ((gruntime_data->sp - gruntime_data->stack) + 1 >= STACK_SIZE)
							ci_runtime_error( 197, "Stack 1 overflow." );
					}
				
					if (gshow_execution_trace)
						cout << ": " + to_string( gruntime_data->ic[gruntime_data->ic_ptr].dvalue );
					
					ci_var_set_d( gruntime_data->sp++, gruntime_data->ic[gruntime_data->ic_ptr].dvalue );
								
				break;
					
				case OP_PUSH_CONST_DOUBLE:		

					if (runtime_checks)
					{
						if ((gruntime_data->sp - gruntime_data->stack) + 1 >= STACK_SIZE)
							ci_runtime_error( 198, "Stack 1 overflow." );
					}
				
					if (gshow_execution_trace)
						cout << ": " + to_string( gruntime_data->ic[gruntime_data->ic_ptr].nvalue );
					
					ci_var_set_n( gruntime_data->sp++, gruntime_data->ic[gruntime_data->ic_ptr].nvalue );
								
				break;
					
				case OP_PUSH_CONST_BOOL:		

					if (runtime_checks)
					{
						if ((gruntime_data->sp - gruntime_data->stack) + 1 >= STACK_SIZE)
							ci_runtime_error( 199, "Stack 1 overflow." );
					}
				
					if (gshow_execution_trace)
						cout << ": " + to_string( gruntime_data->ic[gruntime_data->ic_ptr].ivalue );
					
					ci_var_set_i( gruntime_data->sp++, gruntime_data->ic[gruntime_data->ic_ptr].ivalue );			
				
				break;
				
				case OP_PUSH_CONST_STRING:		

					if (runtime_checks)
					{
						if ((gruntime_data->sp - gruntime_data->stack) + 1 >= STACK_SIZE)
							ci_runtime_error( 200, "Stack 1 overflow." );
					}
					
					if (gshow_execution_trace)
					{
						if (*((int_64 *) (gruntime_data->ic[gruntime_data->ic_ptr].u32_string_constant_value)) < 100)
						{
							cout << ": ";
							
							ci_str_u32_to_u8( small_str_buffer, gruntime_data->ic[gruntime_data->ic_ptr].u32_string_constant_value, SMALL_STRING_BUFFER_SIZE );
				
							cout << "'"; 
							cout << small_str_buffer;
							cout << "'";
						} 
					}

					ci_var_set_s_u32( gruntime_data->sp++, gruntime_data->ic[gruntime_data->ic_ptr].u32_string_constant_value, true );
						
				break;
				
			
					// 4. Pop
								
				case OP_POP_VAR:
				{
					size = gruntime_data->ic[gruntime_data->ic_ptr].size;
			
					if (size == 1) 
					{
						if (gshow_execution_trace)
						{
							cout << ": address: ";
							cout << (long int) ((gruntime_data->sp-2)->data.pvalue);
							cout << ": value: ";
							
							vptr = gruntime_data->sp-1;
							
							var_type = vptr->var_type;
	
							if (var_type == VAR_INT)
							{
								cout << vptr->data.ivalue;
								cout << ": type: int";
							}
							else
							if (var_type == VAR_DECIMAL)
							{
								cout << vptr->data.dvalue;
								cout << ": type: decimal";
							}
							else
							if (var_type == VAR_DOUBLE)
							{
								cout << vptr->data.nvalue;
								cout << ": type: double";
							}
							else
							if (var_type == VAR_STRING)
							{
								if (*((int_64 *) (vptr->data.svalue)) < 100)
								{
									ci_str_u32_to_u8( small_str_buffer, vptr->data.svalue, SMALL_STRING_BUFFER_SIZE );
						
									cout << "'"; 
									cout << small_str_buffer;
									cout << "'";
								} 
							}
						}
						
						if (runtime_checks)
						{
							if (gruntime_data->ic[gruntime_data->ic_ptr].type_map != "")
							{
								if ((gruntime_data->sp-1)->data.pvalue != NULL)
								{
									if (((dyn_block *) ((gruntime_data->sp-1)->data.pvalue))->type_map != "")
									{
										if (((dyn_block *) ((gruntime_data->sp-1)->data.pvalue))->type_map != gruntime_data->ic[gruntime_data->ic_ptr].type_map)
											ci_runtime_error( 205, "Link type on the left of the '=' operator does not match the type on the right side." );
									}
								}
							}
							
							ci_copy_var( (ci_var *) ((gruntime_data->sp-2)->data.pvalue), gruntime_data->sp-1 );
						} 
						else
							ci_copy_var_no_debug( (ci_var *) ((gruntime_data->sp-2)->data.pvalue), gruntime_data->sp-1 ); 
									
						gruntime_data->sp -= 2;
					}
					else
					{
						vptr_from = gruntime_data->sp - size;
						
						vptr_to = (ci_var *) ((gruntime_data->sp - size - 1)->data.pvalue);
						
						vptr_end = vptr_from + size;
					
						if (runtime_checks)
						{
							while (vptr_from < vptr_end)
								ci_copy_var( vptr_to++, vptr_from++ );
						}
						else
						{
							while (vptr_from < vptr_end)
								ci_copy_var_no_debug( vptr_to++, vptr_from++ );
						}
						
						gruntime_data->sp -= size + 1;
					}
				}
				break;
			
				case OP_POP_DISCARD:
				{
					gruntime_data->sp -= gruntime_data->ic[gruntime_data->ic_ptr].discard_count; 
				}
				break;

			
					// 5. Stack 2 operations
					
				case OP_PREP_FOR_MEMBER_FUNC_CALL:
				{
			 		if (runtime_checks)
					{
						if ((gruntime_data->sp2 - gruntime_data->stack2) + 3 >= STACK2_SIZE)
							ci_runtime_error( 201, "Stack 2 overflow." );
					}
					
					gruntime_data->sp--;

					*gruntime_data->sp2++ = (ci_var *) gruntime_data->bp_stack2;
					*gruntime_data->sp2++ = gruntime_data->sp;
					*gruntime_data->sp2++ = (ci_var *) (gruntime_data->sp->data.pvalue);
				}
				break;
			
				case OP_PUSH_SP_ONTO_ST2:
				{
			 		if (runtime_checks)
					{
						if ((gruntime_data->sp2 - gruntime_data->stack2) + 2 >= STACK2_SIZE)
							ci_runtime_error( 202, "Stack 2 overflow." );
					}
					
					*gruntime_data->sp2++ = (ci_var *) gruntime_data->bp_stack2;
					*gruntime_data->sp2++ = gruntime_data->sp;
				}
				break;
			
				case OP_MOVE_SP_VALUE_TO_ST2:
				{
			 		if (runtime_checks)
					{
						if ((gruntime_data->sp2 - gruntime_data->stack2) + 1 >= STACK2_SIZE)
							ci_runtime_error( 203, "Stack 2 overflow." );
					}
					
					gruntime_data->sp--;
					
					*gruntime_data->sp2++ = (ci_var *) (gruntime_data->sp->data.pvalue);
				}
				break;
			
				case OP_SET_ST2_PTR_TO_SP:
				{
			 		if (runtime_checks)
					{
						if ((gruntime_data->sp2 - gruntime_data->stack2) + 1 >= STACK2_SIZE)
							ci_runtime_error( 204, "Stack 2 overflow." );
					}
					
					size = gruntime_data->ic[gruntime_data->ic_ptr].size;
					
					*gruntime_data->sp2++ = (gruntime_data->sp - size);
				}
				break;

				case OP_SET_ST2_PTR_TO_SP_OFFSET:
				{
			 		if (runtime_checks)
					{
						if ((gruntime_data->sp2 - gruntime_data->stack2) + 1 >= STACK2_SIZE)
							ci_runtime_error( 204, "Stack 2 overflow." );
					}
					
					*gruntime_data->sp2++ = (gruntime_data->sp + gruntime_data->ic[gruntime_data->ic_ptr].offset);
				}
				break;
			
					
					// 6. Type conversions
							
				case OP_CONV_INT_TO_STRING:
				{
					sprintf( small_str_buffer, "%ld", (gruntime_data->sp-1)->data.ivalue );
			
					ci_var_set_s( gruntime_data->sp-1, small_str_buffer );
				}
				break;
			
				case OP_CONV_DOUBLE_TO_STRING:
				{
					sprintf( small_str_buffer, "%.13lf", (gruntime_data->sp-1)->data.nvalue );

					ci_trim_trailing_zeros( small_str_buffer );
			
					ci_var_set_s( gruntime_data->sp-1, small_str_buffer );
				}
				break;
			
				case OP_CONV_DECIMAL_TO_STRING:
				{
					sprintf( small_str_buffer, "%.2lf", (double) (gruntime_data->sp-1)->data.dvalue / (double) VAR_DECIMAL_SCALE );
			
					ci_var_set_s( gruntime_data->sp-1, small_str_buffer );
				}
				break;
			
				case OP_CONV_BOOL_TO_STRING:
				{
					if ((gruntime_data->sp-1)->data.ivalue)
						ci_var_set_s( gruntime_data->sp-1, "true" );
					else
						ci_var_set_s( gruntime_data->sp-1, "false" );
				}
				break;
			
				case OP_CONV_BINARY_TO_STRING:
				{
					long int len1;
					char *bptr;
					
					vptr = gruntime_data->sp-1;
		
					if (vptr->data.bvalue == NULL)
						ci_var_set_s( vptr, "" );
					else
					{
						len1 = *((int_64 *) (vptr->data.bvalue));
						
						bptr = (char *) _ci_malloc( len1 * 2 + 1 );
						
						ci_dec_to_hex( bptr, (unsigned char *) (vptr->data.svalue + sizeof( int_64 )), len1, true, false );
			
						ci_var_set_s( vptr, bptr );
							
						_ci_free( bptr );
					}
				}
				break;
			
				case OP_CONV_LINK_TO_STRING:
				{
					if ((gruntime_data->sp-1)->data.pvalue == NULL)
						strcpy( small_str_buffer, "{NULL_LINK}" );
					else
					{
						strcpy( small_str_buffer, "{link to " );
		
						sprintf( small_str_buffer2, "%p", (gruntime_data->sp-1)->data.pvalue );
			
						strcat( small_str_buffer, small_str_buffer2 );
			
						strcat( small_str_buffer, "}" );
					}
								
					ci_var_set_s( gruntime_data->sp-1, small_str_buffer );
				}
				break;
			
				 
				case OP_CONV_INT_TO_DECIMAL:
				{
					if (gshow_execution_trace)
					{
						cout << ": value: ";
						cout << ((gruntime_data->sp-gruntime_data->ic[gruntime_data->ic_ptr].conv_level)->data.ivalue * VAR_DECIMAL_SCALE);
					}
					
					ci_var_set_d( gruntime_data->sp-gruntime_data->ic[gruntime_data->ic_ptr].conv_level, (gruntime_data->sp-gruntime_data->ic[gruntime_data->ic_ptr].conv_level)->data.ivalue * VAR_DECIMAL_SCALE );
				}
				break;
			
				case OP_CONV_INT_TO_DOUBLE:
				{
					if (gshow_execution_trace)
					{
						cout << ": value: ";
						cout << (gruntime_data->sp-gruntime_data->ic[gruntime_data->ic_ptr].conv_level)->data.ivalue;
					}
					
					ci_var_set_n( gruntime_data->sp-gruntime_data->ic[gruntime_data->ic_ptr].conv_level, (gruntime_data->sp-gruntime_data->ic[gruntime_data->ic_ptr].conv_level)->data.ivalue );
				}
				break;
			
			
				case OP_CONV_DOUBLE_TO_INT:
				{
					if (gshow_execution_trace)
					{
						cout << ": value: ";
						cout << (gruntime_data->sp-gruntime_data->ic[gruntime_data->ic_ptr].conv_level)->data.nvalue;
					}
					
					ci_var_set_i( gruntime_data->sp-gruntime_data->ic[gruntime_data->ic_ptr].conv_level, (long int) ((gruntime_data->sp-gruntime_data->ic[gruntime_data->ic_ptr].conv_level)->data.nvalue) );
				}
				break;
			
				case OP_CONV_DOUBLE_TO_DECIMAL:
				{
					if (gshow_execution_trace)
					{
						cout << ": value: ";
						cout << ((gruntime_data->sp-gruntime_data->ic[gruntime_data->ic_ptr].conv_level)->data.nvalue * VAR_DECIMAL_SCALE);
					}
					
					ci_var_set_d( gruntime_data->sp-gruntime_data->ic[gruntime_data->ic_ptr].conv_level, (gruntime_data->sp-gruntime_data->ic[gruntime_data->ic_ptr].conv_level)->data.nvalue * VAR_DECIMAL_SCALE );
				}
				break;
			
			
				case OP_CONV_DECIMAL_TO_DOUBLE:
				{
					if (gshow_execution_trace)
					{
						cout << ": value: ";
						cout << ((double) (gruntime_data->sp-gruntime_data->ic[gruntime_data->ic_ptr].conv_level)->data.dvalue / (double) VAR_DECIMAL_SCALE);
					}
					
					ci_var_set_n( gruntime_data->sp-gruntime_data->ic[gruntime_data->ic_ptr].conv_level, (double) (gruntime_data->sp-gruntime_data->ic[gruntime_data->ic_ptr].conv_level)->data.dvalue / (double) VAR_DECIMAL_SCALE );
				}
				break;
			
				case OP_CONV_DECIMAL_TO_INT:
				{
					if (gshow_execution_trace)
					{
						cout << ": value: ";
						cout << ((double) (gruntime_data->sp-gruntime_data->ic[gruntime_data->ic_ptr].conv_level)->data.dvalue / (double) VAR_DECIMAL_SCALE);
					}
					
					ci_var_set_i( gruntime_data->sp-gruntime_data->ic[gruntime_data->ic_ptr].conv_level, (long int) round( (gruntime_data->sp-gruntime_data->ic[gruntime_data->ic_ptr].conv_level)->data.dvalue / (double) VAR_DECIMAL_SCALE ) );
				}
				break;
			
			
			
					// 7. +=, -= etc
			
				case OP_PLUS_EQ_ADD_INT:
				{
					gruntime_data->sp--;
				
					((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.ivalue += gruntime_data->sp->data.ivalue;
					
					gruntime_data->sp--; 
				}
				break;
			
				case OP_PLUS_EQ_SUBTRACT_INT:
				{
					gruntime_data->sp--;

					((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.ivalue -= gruntime_data->sp->data.ivalue; 
					
					gruntime_data->sp--; 
				}
				break;
			
				case OP_PLUS_EQ_MULT_INT:
				{
					gruntime_data->sp--;

					((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.ivalue *= gruntime_data->sp->data.ivalue; 
					
					gruntime_data->sp--; 
				}
				break;
			
				case OP_PLUS_EQ_DIV_INT:
				{
					gruntime_data->sp--;

					if (gruntime_data->sp->data.ivalue == 0)
						ci_runtime_error( 105, "Divide by zero." ); 

					((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.ivalue /= gruntime_data->sp->data.ivalue; 
					
					gruntime_data->sp--; 
				}
				break;
			
			
				case OP_PLUS_EQ_ADD_DOUBLE:
				{
					gruntime_data->sp--;
				
					((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.nvalue += gruntime_data->sp->data.nvalue; 
					
					gruntime_data->sp--; 
				}
				break;
			
				case OP_PLUS_EQ_SUBTRACT_DOUBLE:
				{
					gruntime_data->sp--;
				
					((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.nvalue -= gruntime_data->sp->data.nvalue; 
					
					gruntime_data->sp--; 
				}
				break;
			
				case OP_PLUS_EQ_MULT_DOUBLE:
				{
					gruntime_data->sp--;
				
					((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.nvalue *= gruntime_data->sp->data.nvalue; 
					
					gruntime_data->sp--; 
				}
				break;
			
				case OP_PLUS_EQ_DIV_DOUBLE:
				{
					gruntime_data->sp--;

					if (gruntime_data->sp->data.nvalue == 0)
						ci_runtime_error( 105, "Divide by zero." ); 

					((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.nvalue /= gruntime_data->sp->data.nvalue; 
					
					gruntime_data->sp--; 
				}
				break;
			
			
				case OP_PLUS_EQ_ADD_DECIMAL:
				{
					gruntime_data->sp--;
				
					((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.dvalue += gruntime_data->sp->data.dvalue; 
					
					gruntime_data->sp--; 
				}
				break;
			
				case OP_PLUS_EQ_SUBTRACT_DECIMAL:
				{
					gruntime_data->sp--;
				
					((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.dvalue -= gruntime_data->sp->data.dvalue; 
					
					gruntime_data->sp--; 
				}
				break;
			
				case OP_PLUS_EQ_MULT_DECIMAL:
				{
					gruntime_data->sp--;
				
					((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.dvalue = (long int) (((long double)((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.dvalue * (long double) gruntime_data->sp->data.dvalue) / VAR_DECIMAL_SCALE + (long double) VAR_DECIMAL_ROUNDING_OFFSET); 
					
					gruntime_data->sp--; 
				}
				break;
			
				case OP_PLUS_EQ_DIV_DECIMAL:
				{
					gruntime_data->sp--;

					if (gruntime_data->sp->data.dvalue == 0)
						ci_runtime_error( 105, "Divide by zero." ); 

					((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.dvalue = (long int) (((long double)((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.dvalue / (long double) gruntime_data->sp->data.dvalue) * VAR_DECIMAL_SCALE + (long double) VAR_DECIMAL_ROUNDING_OFFSET); 
					
					gruntime_data->sp--; 
				}
				break;
			
			
				case OP_PLUS_EQ_CONCAT_STR:
				{
					gruntime_data->sp --;
					
					_ci_op_strconcat();
				}
				break;
			
				
				
					// 8. Other operations
					
				case OP_STRCONCAT:
				{
					gruntime_data->sp --;
					
					_ci_op_strconcat();
				}
				break;

				case OP_STRCONCAT_N_ITEMS:
				{
					if (runtime_checks)
					{
						gruntime_data->sp --;
						
						_ci_op_strconcat_n_items( gruntime_data->ic[gruntime_data->ic_ptr].str_concat_num_items );
					}
					else
					{
						gruntime_data->sp --;
						
						_ci_op_strconcat_n_items_no_debug( gruntime_data->ic[gruntime_data->ic_ptr].str_concat_num_items );
					}
				}
				break;

			
				case OP_ADD_CONST_TO_SP_ITEM:
				{
					(gruntime_data->sp-1)->data.ivalue += gruntime_data->ic[gruntime_data->ic_ptr].add_sp_item;
				}
				break;
			
				case OP_DUPLICATE:
				{
					if (runtime_checks)
					{
						if ((gruntime_data->sp - gruntime_data->stack) + 1 >= STACK_SIZE)
							ci_runtime_error( 1, "Stack 1 overflow." );
					}
					
					if (runtime_checks)
						ci_copy_var( gruntime_data->sp, gruntime_data->sp-1 );
					else
						ci_copy_var_no_debug( gruntime_data->sp, gruntime_data->sp-1 );
					
					gruntime_data->sp++;						
				}
				break;
			
				case OP_ARRAY_BOUNDS_CHECK:
				{
					array_lookup_value = (gruntime_data->sp-1)->data.ivalue;
				
					if (array_lookup_value < 0)
						ci_runtime_error( 167, "Array negative index value, index number " + gruntime_data->ic[gruntime_data->ic_ptr].error_text + ", value " + to_string( array_lookup_value ) );
					
					if (array_lookup_value >= gruntime_data->ic[gruntime_data->ic_ptr].array_index_size)
						ci_runtime_error( 167, "Array bounds overflow, index number " + gruntime_data->ic[gruntime_data->ic_ptr].error_text + ", maximum size " + to_string( gruntime_data->ic[gruntime_data->ic_ptr].array_index_size - 1 ) + ", value " + to_string( array_lookup_value ) );
				}
				break;
			
				case OP_BULK_COPY:
				{
					gruntime_data->sp--;
					
					vptr_from = (ci_var *) ((ci_var *) gruntime_data->sp)->data.pvalue;
					
					gruntime_data->sp--;
				
					vptr_to = (ci_var *) ((ci_var *) gruntime_data->sp)->data.pvalue;
						
					vptr_end = vptr_from + gruntime_data->ic[gruntime_data->ic_ptr].size;
				
					if (runtime_checks)
					{
						while (vptr_from < vptr_end)
							ci_copy_var( vptr_to++, vptr_from++ );
					}
					else
					{
						while (vptr_from < vptr_end)
							ci_copy_var_no_debug( vptr_to++, vptr_from++ );
					}
				}
				break;

				case OP_BULK_COPY_REVS:
				{
					gruntime_data->sp--;
					
					vptr_to = (ci_var *) ((ci_var *) gruntime_data->sp)->data.pvalue;
					
					gruntime_data->sp--;
				
					vptr_from = (ci_var *) ((ci_var *) gruntime_data->sp)->data.pvalue;
						
					vptr_end = vptr_from + gruntime_data->ic[gruntime_data->ic_ptr].size;
				
					if (runtime_checks)
					{
						while (vptr_from < vptr_end)
							ci_copy_var( vptr_to++, vptr_from++ );
					}
					else
					{
						while (vptr_from < vptr_end)
							ci_copy_var_no_debug( vptr_to++, vptr_from++ );
					}
				}
				break;
			
				case OP_ADD_TO_POINTER:
				{
					gruntime_data->sp--;
					
					(gruntime_data->sp-1)->data.pvalue = (char *) (((ci_var *) ((gruntime_data->sp-1)->data.pvalue)) + gruntime_data->sp->data.ivalue);
				}
				break;
			
				case OP_INC_SP:
				{
					gruntime_data->sp += gruntime_data->ic[gruntime_data->ic_ptr].inc_sp_amount;
				}
				break;
			
				case OP_VAR_INC:
				{
					gruntime_data->sp--;
					
					vptr = (ci_var *) gruntime_data->sp->data.pvalue;
					
					var_type = vptr->var_type;
					
					if (var_type == VAR_INT)
					{
						vptr->data.ivalue++;
					}
					else
					if (var_type == VAR_DECIMAL)
					{
						vptr->data.dvalue += VAR_DECIMAL_SCALE;
					}
					else
					if (var_type == VAR_DOUBLE)
					{
						vptr->data.nvalue++;
					}
				}
				break;
			
				case OP_VAR_DEC:
				{
					gruntime_data->sp--;
					
					vptr = (ci_var *) gruntime_data->sp->data.pvalue;
					
					var_type = vptr->var_type;
					
					if (var_type == VAR_INT)
					{
						vptr->data.ivalue--;
					}
					else
					if (var_type == VAR_DECIMAL)
					{
						vptr->data.dvalue -= VAR_DECIMAL_SCALE;
					}
					else
					if (var_type == VAR_DOUBLE)
					{
						vptr->data.nvalue--;
					}
				}
				break;
			
				case OP_DEALLOC:
				{
					gruntime_data->sp--;
					
					if (((ci_var *) gruntime_data->sp->data.pvalue)->data.pvalue == NULL)
						ci_runtime_error( 1, "Attempt to deallocate a NULL_LINK link." );
					
					ptr = ((ci_var *) gruntime_data->sp->data.pvalue)->data.pvalue;
					
					if (((dyn_block *) ptr)->status == 2)
						ci_runtime_error( 1140, "Attempt to free a data item that has already been freed." );	

					if (((dyn_block *) ptr)->status != 1)
						ci_runtime_error( 1141, "Corrupt memory." );	
					
					((dyn_block *) ptr)->status = 2;
					
					for (i=0; i < ((dyn_block *) ptr)->block_size / sizeof( ci_var ); i++)
						ci_free_curr_mem_1( ((ci_var *) ((dyn_block *) ptr)->data_ptr) + i );
					
				 	_ci_free( ((dyn_block *) ptr)->data_ptr );
					
					((ci_var *) gruntime_data->sp->data.pvalue)->data.pvalue = NULL;
				}
				break;
			
				case OP_RARRAY_SETSIZE:
				{
					size = gruntime_data->ic[gruntime_data->ic_ptr].size;

					gruntime_data->sp--;
											
					ci_op_setsize( size, gruntime_data->ic[gruntime_data->ic_ptr].type1 ); 
				}
				break;
			
				case OP_RARRAY_DEREFERENCE:
				{
					gruntime_data->sp--;
					
					if (runtime_checks)
					{
						ci_op_array_dereference_rtc();
					}
					else
					{
						ci_op_array_dereference();
					}
					
					gruntime_data->sp++;
				}
				break;
			
				case OP_FOR_LOOP_1:
				{
					if ((gruntime_data->sp-2)->data.ivalue == 0)
						ci_runtime_error( 105, "For loop cannot have a zero step size." ); 
					
					if (gruntime_data->ic[gruntime_data->ic_ptr].itype == FOR_LOOP_TYPE_INT)
					{
						if ((gruntime_data->sp-2)->data.ivalue > 0)
						{
							if (((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.ivalue > (gruntime_data->sp-3)->data.ivalue)
						 		gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
						}
						else
						{
							if (((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.ivalue < (gruntime_data->sp-3)->data.ivalue)
						 		gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
						}
					}
					else
					if (gruntime_data->ic[gruntime_data->ic_ptr].itype == FOR_LOOP_TYPE_DOUBLE)
					{
						if ((gruntime_data->sp-2)->data.nvalue > 0)
						{
							if (((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.nvalue > (gruntime_data->sp-3)->data.nvalue)
						 		gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
						}
						else
						{
							if (((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.nvalue < (gruntime_data->sp-3)->data.nvalue)
						 		gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
						}
						
					}
					else
					if (gruntime_data->ic[gruntime_data->ic_ptr].itype == FOR_LOOP_TYPE_DECIMAL)
					{
						if ((gruntime_data->sp-2)->data.dvalue > 0)
						{
							if (((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.dvalue > (gruntime_data->sp-3)->data.dvalue)
						 		gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
						}
						else
						{
							if (((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.dvalue < (gruntime_data->sp-3)->data.dvalue)
						 		gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
						}
						
					}
				}
				break;
			
				case OP_FOR_LOOP_2:
				{
					if (gruntime_data->ic[gruntime_data->ic_ptr].itype == FOR_LOOP_TYPE_INT)
						((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.ivalue += (gruntime_data->sp-2)->data.ivalue;
					else
					if (gruntime_data->ic[gruntime_data->ic_ptr].itype == FOR_LOOP_TYPE_DOUBLE)
						((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.nvalue += (gruntime_data->sp-2)->data.nvalue;
					else
					if (gruntime_data->ic[gruntime_data->ic_ptr].itype == FOR_LOOP_TYPE_DECIMAL)
						((ci_var *) ((gruntime_data->sp-1)->data.pvalue))->data.dvalue += (gruntime_data->sp-2)->data.dvalue;
					
			 		gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
				}
				break;
			
			
			
					// 9. System functions
					
/*					
				case OP_LINK_MODULE:
				{
				}
				break;
*/
			
				case OP_NULL_ENTRY:
				{
				}
				break;
			
				case OP_LABEL:
				{
				}
				break;
			
				case OP_ERROR:
				{
					ci_runtime_error( 0, gruntime_data->ic[gruntime_data->ic_ptr].error_text );
				}
				break;
			
					
			
					// 10. Functions
			
				case OP_CALL_SYSTEM_FUNCTION:
				{
					function_number = gruntime_data->ic[gruntime_data->ic_ptr].function_being_called_number;
					
					sp_base = call_function_code( runtime_checks,
										gruntime_data->ic[gruntime_data->ic_ptr].function_being_called_number, 
										gruntime_data->gfunction_details[function_number].return_variable_size );

					run_builtin_function( sp_base, gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address ); 
					
					if (gruntime_data->ic_ptr < gruntime_data->ic_end)		// if not exit()	
						end_function_code( runtime_checks, true );
				}
				break;
				
				case OP_CALL_USER_FUNCTION:
				{
					function_number = gruntime_data->ic[gruntime_data->ic_ptr].function_being_called_number;
				
					call_function_code( runtime_checks,
										gruntime_data->ic[gruntime_data->ic_ptr].function_being_called_number, 
										gruntime_data->gfunction_details[function_number].local_variables_stackframe_size );
							
					gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address - 1;
						
				}
				break;
				
				case OP_START_FUNCTION:
				{
					if (gshow_execution_trace)
					{
						cout << ": "; 
						
						cout << gruntime_data->gfunction_details[gruntime_data->ic[gruntime_data->ic_ptr].this_function_number].function_name;
					}
				}

				break;
			
				case OP_END_MAIN_FUNCTION:
				{
					ci_calc_stdlib_exit( ci_get_and_post_filename );
					
					gruntime_data->ic_ptr = gruntime_data->ic_end;
				}
				break;

				case OP_END_FUNCTION:
				{
					end_function_code( runtime_checks, false );
				}
				break;
			
				case OP_CALL_TABLE_FUNCTION:
				{
					gruntime_data->sp--;
					
					ci_str_u32_to_u8( medium_str_buffer, gruntime_data->sp->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
					
					text = medium_str_buffer;
					
					found = false;
					
					for (i=0; i < gruntime_data->gnum_function_table_items && ! found; i++)
					{
						if (gruntime_data->gfunction_table[i].function_name == text)
						{
							found = true;

							call_function_code( runtime_checks,
									gruntime_data->gfunction_table[i].function_number, 
									gruntime_data->gfunction_details[gruntime_data->gfunction_table[i].function_number].local_variables_stackframe_size );

							
							gruntime_data->ic_ptr = gruntime_data->gfunction_table[i].function_icode_address;
						}
					}
					
					if (! found)
						ci_runtime_error( 1, "Function name '" + text + "' not found in function table." );										
				}
				break;
			
				case OP_CALL_TABLE_FUNCTION_BY_NUMBER:
				{
					gruntime_data->sp--;
					
					function_table_number = gruntime_data->sp->data.ivalue;
					
					if (function_table_number < 0 || function_table_number >= gruntime_data->gnum_function_table_items)
						ci_runtime_error( 1, "Function table entry " + to_string( function_table_number ) + " not found in function table." );										

					call_function_code( runtime_checks,
								gruntime_data->gfunction_table[function_table_number].function_number, 
								gruntime_data->gfunction_details[gruntime_data->gfunction_table[function_table_number].function_number].local_variables_stackframe_size );

							
					gruntime_data->ic_ptr = gruntime_data->gfunction_table[function_table_number].function_icode_address;
					
				}
				break;
			
					
					
					// 11. Jumps
					
				case OP_JMP:
				{
					gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
				}
				break;
			
				case OP_JMP_TRUE:
				{
					gruntime_data->sp--;
					
					if (gruntime_data->sp->data.ivalue)
						gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
				}
				break;
			
				case OP_JMP_FALSE:
				{
					gruntime_data->sp--;
					
					if (! gruntime_data->sp->data.ivalue)
						gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
				}
				break;
			
				case OP_JMP_TRUE_DONT_POP:
				{
					if ((gruntime_data->sp-1)->data.ivalue)
						gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
				}
				break;
			
				case OP_JMP_FALSE_DONT_POP:
				{
					if (! (gruntime_data->sp-1)->data.ivalue)
						gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
				}
				break;
			
				case OP_JMP_NULL:
				{
					gruntime_data->sp--;
					
					if (gruntime_data->sp->data.pvalue == NULL)
						gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
				}
				break;
			
				case OP_JMP_LE_0_DONT_POP:
				{
					if ((gruntime_data->sp-1)->data.ivalue <= 0)
						gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
				}
				break;
			
				case OP_POP_JMP_LE:
				{
					gruntime_data->sp--;
					
					if ((gruntime_data->sp-1)->data.ivalue <= gruntime_data->sp->data.ivalue)  
						gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
				}
				break;
			
				case OP_EQ_INT_JMP:
				case OP_EQ_BOOL_JMP:
				{
					gruntime_data->sp--;

					if ((gruntime_data->sp-1)->data.ivalue == gruntime_data->sp->data.ivalue)  
						gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
				}
				break;
			
				case OP_EQ_DOUBLE_JMP:
				{
					gruntime_data->sp--;
					
					if ((gruntime_data->sp-1)->data.nvalue == gruntime_data->sp->data.nvalue)  
						gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
				}
				break;
			
				case OP_EQ_DECIMAL_JMP:
				{
					gruntime_data->sp--;
					
					if ((gruntime_data->sp-1)->data.dvalue == gruntime_data->sp->data.dvalue)  
						gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
				}
				break;
			
				case OP_EQ_STRING_JMP:
				{
					gruntime_data->sp--;
					
					if (ci_str_u32_eq( (gruntime_data->sp-1)->data.svalue, gruntime_data->sp->data.svalue ))
						gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
				}
				break;
			
			
				case OP_NEQ_INT_JMP:
				case OP_NEQ_BOOL_JMP:
				{
					gruntime_data->sp--;
					
					if ((gruntime_data->sp-1)->data.ivalue != gruntime_data->sp->data.ivalue)  
						gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
				}
				break;
			
				case OP_NEQ_DOUBLE_JMP:
				{
					gruntime_data->sp--;
					
					if ((gruntime_data->sp-1)->data.nvalue != gruntime_data->sp->data.nvalue)  
						gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
				}
				break;
			
				case OP_NEQ_DECIMAL_JMP:
				{
					gruntime_data->sp--;
					
					if ((gruntime_data->sp-1)->data.dvalue != gruntime_data->sp->data.dvalue)  
						gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
				}
				break;
			
				case OP_NEQ_STRING_JMP:
				{
					gruntime_data->sp--;
					
					if (! ci_str_u32_eq( (gruntime_data->sp-1)->data.svalue, gruntime_data->sp->data.svalue ))
						gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
				}
				break;


					// 13. Variable initialisation

				case OP_VPTR_SET_LOC:					vptr = gruntime_data->bp;											break;

				case OP_VPTR_SET_GLOBAL:				vptr = gruntime_data->global_variable_segment;						break;

				case OP_VPTR_REPEAT_1:					ci_var_set_i( gruntime_data->sp++, gruntime_data->ic[gruntime_data->ic_ptr].ivalue );				break;
					
				case OP_VPTR_REPEAT_2:
														(gruntime_data->sp-1)->data.ivalue--;
					
														if ((gruntime_data->sp-1)->data.ivalue < 0)
															gruntime_data->ic_ptr = gruntime_data->ic[gruntime_data->ic_ptr].jump_call_address;
						
														break;
				
				case OP_VPTR_SET_INT_TO_0:				ci_var_set_i( vptr++, 0 );								break;
				case OP_VPTR_SET_DECIMAL_TO_0:			ci_var_set_d( vptr++, 0 );								break;
				case OP_VPTR_SET_DOUBLE_TO_0:			ci_var_set_n( vptr++, 0 );								break;
				case OP_VPTR_SET_STRING_TO_NULL:		ci_var_set_s_u32( vptr++, u32_empty_string, true );		break;
				case OP_VPTR_SET_DATE_TO_NULL:			ci_var_set_s_u32( vptr++, u32_null_date, true );		break;
				case OP_VPTR_SET_TIME_TO_NULL:			ci_var_set_s_u32( vptr++, u32_null_time, true );		break;
				case OP_VPTR_SET_DATETIME_TO_NULL:		ci_var_set_s_u32( vptr++, u32_null_datetime, true );	break;
				case OP_VPTR_SET_BINARY_TO_NULL:		ci_var_set_as_empty( vptr++ );							break;
				case OP_VPTR_SET_PTR_TO_NULL:			ci_var_set_p( vptr++, NULL );							break;
				case OP_VPTR_SET_AS_EMPTY:				ci_var_set_as_empty( vptr++ );							break;
			
				case OP_VPTR_SET_INT:					ci_var_set_i( vptr++, gruntime_data->ic[gruntime_data->ic_ptr].ivalue );									break;
				case OP_VPTR_SET_DECIMAL:				ci_var_set_d( vptr++, gruntime_data->ic[gruntime_data->ic_ptr].dvalue );									break;
				case OP_VPTR_SET_DOUBLE:				ci_var_set_n( vptr++, gruntime_data->ic[gruntime_data->ic_ptr].nvalue );									break;
				case OP_VPTR_SET_STRING:				ci_var_set_s_u32( vptr++, gruntime_data->ic[gruntime_data->ic_ptr].u32_string_constant_value, true );		break;
				case OP_VPTR_SET_DATE:					ci_var_set_s_u32( vptr++, gruntime_data->ic[gruntime_data->ic_ptr].u32_string_constant_value, true );		break;
				case OP_VPTR_SET_TIME:					ci_var_set_s_u32( vptr++, gruntime_data->ic[gruntime_data->ic_ptr].u32_string_constant_value, true );		break;
				case OP_VPTR_SET_DATETIME:				ci_var_set_s_u32( vptr++, gruntime_data->ic[gruntime_data->ic_ptr].u32_string_constant_value, true );		break;
			

					// 14. Stack 3 instructions
			
				case OP_COPY_TO_ST3:
				
					size = gruntime_data->ic[gruntime_data->ic_ptr].size;
					
					gruntime_data->sp -= size;
					
					for (i=0; i < size; i++)
						ci_copy_var( gruntime_data->sp3++, (gruntime_data->sp+i) ); 

					ci_var_set_p( gruntime_data->sp++, gruntime_data->sp3 - size );
				
					break;

				
				case OP_RESET_ST3_POINTER:
			
					gruntime_data->sp3 = gruntime_data->stack3;

					break;
					
					
				default:
				{
					ci_output( "Unrecognised opcode: " + op );
					exit(1);
				}
			}
		}
	}

		//---------------------------------------------------------------------------------------------------------------------
		//---------------------------------------------------------------------------------------------------------------------
		
	void init_data_type( ci_var *vptr, string type1 )
	{
		int i;
		int object_number;			
		int number_of_indexes; 
		int num_elements; 
		int start_of_indexes;
		string element_type;
		int element_size;
		int index_details[MAX_NUM_ARRAY_INDEXES];
		
		if (type1 == token_text_void)
			;
		else
		if (type1 == token_text_int)
			ci_var_set_i( vptr, 0 );
		else
		if (type1 == token_text_double)
			ci_var_set_n( vptr, 0 );
		else
		if (type1 == token_text_decimal)
			ci_var_set_d( vptr, 0 );
		else
		if (type1 == token_text_bool)
			ci_var_set_i( vptr, 0 );
		else
		if (type1 == token_text_string) 
		{
			ci_var_set_s_u32( vptr, u32_empty_string, true );					
		}
		else
		if (type1 == token_text_date) 
		{
			ci_var_set_s_u32( vptr, u32_null_date, true );					
		}
		else
		if (type1 == token_text_time) 
		{
			ci_var_set_s_u32( vptr, u32_null_time, true );					
		}
		else
		if (type1 == token_text_datetime) 
		{
			ci_var_set_s_u32( vptr, u32_null_datetime, true );					
		}
		else
		if (is_link_type( type1 ))
			ci_var_set_p( vptr, NULL );
		else
		if (is_resizable_array_type( type1 ) or type1 == token_text_binary)
			ci_var_set_as_empty( vptr );
		else
		if (is_array_type( type1 ))
		{
			get_array_details( type1, number_of_indexes, num_elements, start_of_indexes, index_details );
			
			element_type = array_element_type( type1 );
			
			element_size = get_type_total_size( element_type );

			for (i=0; i < num_elements; i++)
			{
				init_data_type( vptr, element_type );
				vptr += element_size;
			}
		}
		else
		{
			object_number = -1;
			
			if (ci_sleft( type1, 7 ) == "object_")
				object_number = ci_cstring_to_int( ci_sright_from_pos( type1, 7 ) );
			else
			{
				for (i=0; i < gruntime_data->gnum_user_defined_types; i++)
				{
					if (gruntime_data->guser_defined_types[i].type_name == type1)
					{
						if (gruntime_data->guser_defined_types[i].is_object)
							object_number = gruntime_data->guser_defined_types[i].object_number;
					}
				}
			}
						
			if (object_number == -1)
			{
				cout << "Type '" + type1 + "' not found in 'init_data()'.";
				exit(1);
			}
			
			for (i=0; i < gruntime_data->gobject_types[object_number].num_items; i++)
			{
				init_data_type( vptr, gruntime_data->gobject_types[object_number].item_type[i] );
					
				vptr += gruntime_data->gobject_types[object_number].item_size[i];
			}
		}
	}	
	
	
	
	ci_var *call_function_code( bool runtime_checks, int function_number, int stackframe_size )
	{
		ci_var *sp_base;
		ci_var *bp_new;
		
		if (runtime_checks)
			gruntime_data->call_level++;
		
		if (runtime_checks)
		{
			gruntime_data->err_filenumber[gruntime_data->call_level] = gruntime_data->ic[gruntime_data->ic_ptr].input_filenumber;
		
			gruntime_data->err_linenumber[gruntime_data->call_level] = gruntime_data->ic[gruntime_data->ic_ptr].line_number;
			
			gruntime_data->err_function_number[gruntime_data->call_level] = gruntime_data->ic[gruntime_data->ic_ptr].function_being_called_number;							
		}

		if (gshow_execution_trace)
		{
			cout << ": "; 
			cout << function_number;
			cout << ": "; 
			cout << gruntime_data->gfunction_details[function_number].function_name;
		}
							
		bp_new = gruntime_data->sp;
  
		sp_base = gruntime_data->sp;
 
		gruntime_data->sp += gruntime_data->gfunction_details[function_number].local_variables_stackframe_size;
   
		if (runtime_checks)
		{
			if ((gruntime_data->sp - gruntime_data->stack) >= STACK_SIZE)
				ci_runtime_error( 1, "Stack 1 overflow." );
		}
   
		ci_var_set_i( gruntime_data->sp++, gruntime_data->ic_ptr );			// return address
  
		ci_var_set_p( gruntime_data->sp++, gruntime_data->bp );
 
		if (runtime_checks)
			ci_var_set_i( gruntime_data->sp++, STACK_CHECK_VALUE );
 
		gruntime_data->bp = bp_new;
   			   
		gruntime_data->bp_stack2 = gruntime_data->sp2;
		
		return (sp_base);
	}
							
	
	
	void end_function_code( bool runtime_checks, bool builtin_function )
	{
		ci_var *return_variable_ptr, *vptr_end;
		int_64 return_variable_size;
		int function_number;
		int return_address;
		string type1;
		
		if (builtin_function)
			function_number = gruntime_data->ic[gruntime_data->ic_ptr].function_being_called_number;
		else
			function_number = gruntime_data->ic[gruntime_data->ic_ptr].this_function_number;
			
		
		return_variable_size = gruntime_data->gfunction_details[function_number].return_variable_size;
			

		if (runtime_checks)
		{
			gruntime_data->sp--;
			
			if (gruntime_data->sp->data.ivalue != STACK_CHECK_VALUE)
				ci_runtime_error( 1, "Stack not empty on return from function." );
		}

		gruntime_data->sp--;
		
		gruntime_data->bp = (ci_var *) gruntime_data->sp->data.pvalue;
		
		gruntime_data->sp--;
		
		return_address = gruntime_data->sp->data.ivalue;

		if (builtin_function)
			return_variable_ptr = gruntime_data->sp - return_variable_size;
		else
			return_variable_ptr = gruntime_data->sp - gruntime_data->gfunction_details[function_number].local_variables_stackframe_size;


		if (gruntime_data->gfunction_details[function_number].is_member_function)
		{
			gruntime_data->sp2 -= gruntime_data->gfunction_details[function_number].number_of_function_arguments+2;
		}
		else
		{
			gruntime_data->sp2 -= gruntime_data->gfunction_details[function_number].number_of_function_arguments+1;
		}
		
		gruntime_data->sp = (ci_var *) (*gruntime_data->sp2);
		
		gruntime_data->sp2--;

		gruntime_data->bp_stack2 = (ci_var **) (*gruntime_data->sp2);
		
		if (return_variable_size == 1)
		{
//			str_u32_to_u8( x2, return_variable_ptr->data.svalue );
			
//			cout << x2;
			
			if (runtime_checks)
			{
				if (gruntime_data->sp != return_variable_ptr)
					ci_copy_var( (ci_var *) gruntime_data->sp, (ci_var *) return_variable_ptr ); 
			}
			else
			{
				if (gruntime_data->sp != return_variable_ptr)
					ci_copy_var_no_debug( (ci_var *) gruntime_data->sp, (ci_var *) return_variable_ptr );
			}
			
			gruntime_data->sp++;
		}
		else
		if (return_variable_size > 0)
		{				
			vptr_end = return_variable_ptr + return_variable_size;
		
			if (runtime_checks)
			{
				while (return_variable_ptr < vptr_end)
					ci_copy_var( gruntime_data->sp++, return_variable_ptr++ );
			}
			else
			{
				while (return_variable_ptr < vptr_end)
					ci_copy_var_no_debug( gruntime_data->sp++, return_variable_ptr++ );
			}
		}


		if (runtime_checks)
			gruntime_data->call_level--;

		gruntime_data->ic_ptr = return_address;
	}
