//<?		// Turn on editor syntax highlighting

                              // (c) Copyright Mark McIlroy 2023-25

// Calc compiler, language version 5.8
//
// Last update 29.11.2025
//
                              
                              
    using namespace std;
                              
    #include <string>
    #include <iostream>
    #include <cstdlib>
    #include <cmath>

    #include "ci_calc.h"
            
    #include "library.cpph"
	

	// Linking C libraries		-l XXX		where the filename is libXXX.so

							
	// Strings and 'binary' type values have a leading 8 byte value specifying the number of bytes in the string 
	//		(excluding the leading 8 byte value).
	

	extern int is_web_page;
	extern char const *redirect_filename;
	
	
	int ic_pos;
	int ic_pos_minus_1;
	bool has_link_modules;
	int sys_var_number;
	bool gstack3_in_use;

	int glabel_main_start;		
	int glabel_globals_init_start;
		
	string explode_result[1000];
	string explode_result2[1000];
	string array_indexes2[1000];
	int array_indexes[MAX_NUM_ARRAY_INDEXES];
	t_function_argument gfunction_arguments2[200];
	
	string parse_const_string_expr();
	string parse_const_string_expr_item();
	
	double parse_const_numerical_expr( string& type1 );
	double parse_const_numerical_expr_mult( string& type1 );
	double parse_const_numerical_expr_exp( string& type1 );
	double parse_const_numerical_expr_item( string& type1 );

	long int parse_const_numerical_expr_i( string& type1 );
	long int parse_const_numerical_expr_mult_i( string& type1 );
	long int parse_const_numerical_expr_exp_i( string& type1 );
	long int parse_const_numerical_expr_item_i( string& type1 );
		
	bool make_map_obj_has_been_processed[1000];
	

//---------------------------------------
// NEXT AVAILABLE ERROR NUMBER:   412
//
// NEXT AVAILABLE WARNING NUMBER:   12
//---------------------------------------

	bool calc_run_program( string& program, string input_filename, bool show_scan_trace, bool run_code, bool array_bounds_checks, bool runtime_checks, bool show_warnings, bool command_line_mode, string include_paths[MAX_INCLUDE_PATHS], bool show_additional_warnings, bool show_large_strings_warnings ); 
	void parse_file();
	void parse_type_definition( int current_function_number );
	int parse_function_definition( int current_function_number, bool builtin_function, int builtin_function_number, bool is_member_function, string object_type );
	void parse_stat( int current_function_number, bool in_void_function );
	string parse_aggregate_expression( bool allow_void, string& expression_type, int current_function_number, string& name, bool& stack_value_is_address, bool &has_function_call );
	string parse_dereference( bool allow_void, string& expression_type, int current_function_number, string& name, bool& stack_value_is_address, bool &has_function_call );
	void parse_assignment_right_side( bool allow_void, int current_function_number, string& name, string& left_side_type );
	void parse_const_declaration( bool allow_void );
	void parse_free_statement( bool allow_void, int current_function_number );
	void parse_function_table_statement();
	void parse_call_table_function( int current_function_number );
	void parse_call_table_function_by_number( int current_function_number );
	void parse_variable_declaration( bool allow_void, int current_function_number );
	void parse_while_statment( bool allow_void, int current_function_number, bool in_void_function );
	void parse_do_statment( bool allow_void, int current_function_number, bool in_void_function );
	void parse_repeat_statment( bool allow_void, int current_function_number, bool in_void_function );
	void parse_for_statement( bool allow_void, int current_function_number, bool in_void_function );
	void parse_scan_statement( bool allow_void, int current_function_number, bool in_void_function );
	void parse_scan_list_data_statement( bool allow_void, int current_function_number, bool in_void_function );
	void parse_scan_list_keys_statement( bool allow_void, int current_function_number, bool in_void_function );
	void parse_scan_db_statement( bool allow_void, int current_function_number, bool in_void_function );
	void parse_switch_statment( bool allow_void, int current_function_number, bool in_void_function );
	void parse_if_statment( bool allow_void, int current_function_number, bool in_void_function );
	int check_or_add_new_function( string& function_name, string& function_return_type, bool& already_defined );
	void check_var_declaration( int current_function_number, string& type1, string& name, bool& is_global );
	bool is_data_type( int tok, string& type1, int& size );
	string parse_data_type( bool allow_void, bool in_function_declaration, int& size, bool allow_variable_arrays, string& type_name, bool is_var_declaration );
	string parse_expr( int current_function_number );
	string parse_comp_expr( int current_function_number );
	void gen_relational_op( int op, string& type1 );
	string parse_num_expr( int current_function_number );
	string parse_add_expr( int current_function_number );
	string parse_mult_expr( int current_function_number );
	string parse_exp_expr( int current_function_number );
	string parse_item_expr( int current_function_number );
	string parse_function_call( int current_function_number, string& function_name, bool& stack_value_is_address );
	void init_main();
	void init_global_variables( bool init_globals );
	void init_data_type2( string& type1 );
	void post_parse_processing();
	void optimise_icode();
	string push_var_if_necessary( string& type1 );
	bool is_member_function_call( int current_function_number, string& function_name );
	string trim_addr_if_necessary( string& type1 );
	void check_scan_functions( string object_type, string type_curr, string type2 );
	bool is_compatible_link_types( string& type_required, string& type_supplied );
	void generate_conversion_to_string_if_necessary( string& type_from );
	void add_local_variable( int current_function_number, string& var_name, string& type1, int size, bool has_been_accessed, bool initialise_variable, long int init_ivalue, long int init_dvalue, double init_nvalue, string init_svalue );
	bool is_user_defined_type( string& type1, string& underlying_type );
	void array_bounds_check( int array_indexes[MAX_NUM_ARRAY_INDEXES], int start_of_indexes, int index_number, int current_function_number, string& name, int number_of_indexes );
	void set_op_descriptions( string op_descriptions[MAX_NUMBER_OF_OPS] );
	int get_object_number( string& type1 );
	bool is_member_variable( int current_function_number, string& var_name );
	bool is_type_name( string& name );
	bool is_const_name( string& name );
	bool is_function_name( string name );

	const int max_function_parameters_per_function = 100;


	
	bool calc_run_program( string& program, string input_filename, bool show_scan_trace, bool run_code, bool array_bounds_checks, bool runtime_checks, bool show_warnings, bool command_line_mode, string include_paths[MAX_INCLUDE_PATHS], bool show_additional_warnings, bool show_large_strings_warnings, bool init_globals ) 
	{
		int i, j, k, l;
		int line_number;
		bst_tree_node_cpp bst_ptr;
		bool not_finished;
		t_global_variable *nptr_global_variable;
		t_local_variable *nptr_local_variable;
		t_local_variable *nptr_local;
		bool found_main;
		string text;
		bool found;
		int object_number;

		set_op_descriptions( op_descriptions );

		ci_calc_stdlib_init( ci_get_and_post_filename );
		
		i = 0;

		gruntime_data->ic_array_size = IC_ARRAY_STEP_SIZE;

		gruntime_data->ic = new t_ic[MAX_ICODE_ITEMS];


		garray_bounds_checks = array_bounds_checks;

		gshow_parse_trace = false;
		
		gshow_scan_trace = show_scan_trace; 
						
		gshow_warnings = show_warnings;
		
		gcommand_line_mode = command_line_mode;	
						
		gmain_input_filename = input_filename;
					
		gruntime_data->gnum_function_table_items = 0;
		
		has_link_modules = false;
		
		glast_error_line = 0;
		
		ic_pos = 0;
		ic_pos_minus_1 = -1;

		sys_var_number = 0;
	
		glabel_num = 1;

		gruntime_data->gnum_object_types = 0;
		gruntime_data->gnum_user_defined_types = 0;
		
		for (i=0; i < MAX_INPUT_FILES_PER_COMPILE; i++)
			gruntime_data->ginput_filenames_inclusion_count[i] = 1;

		i = 0;		
		
		gnumber_of_user_functions = 0;
		gnum_string_constants = 0;
		
		gerror_occured = false;
	
		gfor_control_variables = ":";
		
		scan_file( input_filename, program, include_paths );
		
		goutput_file_type = token_text_main;
		
		gsmodule_name = token_text_main;

		
		init_main();


		parse_file();

		if (show_additional_warnings)
		{
			not_finished = gbst_global_variables.first_item( bst_ptr, true );
			
			while (not_finished)
			{
				nptr_global_variable = (t_global_variable *) bst_ptr.get_data_ptr();

				if (! nptr_global_variable->has_been_accessed)
					syntax_warning( 11, "Global variable '" + nptr_global_variable->name + " has been declared but not used." );
				
				not_finished = gbst_global_variables.next_item( bst_ptr, true );
			}

			for (i=0; i <= gnumber_of_user_functions - 1; i++)
			{
				if (gruntime_data->gfunction_details[i].function_has_been_defined)
				{
					for (j=0; j <= gruntime_data->gfunction_details[i].number_of_function_arguments - 1; j++)
					{
						if (! gfunction_arguments[i][j].has_been_accessed)
						{
							syntax_warning( 11, "Function parameter '" + gfunction_arguments[i][j].name + "' in function '" + gruntime_data->gfunction_details[i].function_name + "' has been declared but not used." );
						}
					}
				}
			}
		}

	 	for (i=0; i <= gnumber_of_user_functions - 1; i++)
		{
			if (gruntime_data->gfunction_details[i].is_member_function)
			{
				for (l=0; l <= gruntime_data->gnum_user_defined_types - 1; l++)
				{
					if (gruntime_data->guser_defined_types[l].type_name == gruntime_data->gfunction_details[i].member_of)
					{
						object_number = gruntime_data->guser_defined_types[l].object_number;
						
						for (j=0; j <= gruntime_data->gfunction_details[i].number_of_function_arguments - 1; j++)
						{
							for (k=0; k <= gruntime_data->gobject_types[object_number].num_items-1; k++)
							{
								ci_sexplode( gruntime_data->gfunction_details[i].function_name, ":", explode_result2, 100 );
								
								if (gruntime_data->gobject_types[object_number].item_name[k] == gfunction_arguments[i][j].name)
									semantic_error( 380, "Cannot declare a function parameter with the name '" + gfunction_arguments[i][j].name + "' in function '" + explode_result2[2] + "' as there is a member variable in the type with that name." );
								
								text = to_string( i ) + "&" + gruntime_data->gobject_types[object_number].item_name[k];
								
								gbst_local_variables.search_s( text, found );
								 
								if (found)
									semantic_error( 381, "Cannot declare a local variable with the name '" + gruntime_data->gobject_types[object_number].item_name[k] + "' in function '" + explode_result2[2] + "' as there is a member variable in the type with that name." );
							}
						}
					}
				}
			}
		}	
		 
		
		if (show_warnings)
		{
			not_finished = gbst_local_variables.first_item( bst_ptr, true );
			
			while (not_finished)
			{
				nptr_local_variable = (t_local_variable *) bst_ptr.get_data_ptr();

				if (! nptr_local_variable->has_been_accessed)
					syntax_warning( 11, "Local variable '" + nptr_local_variable->name + "' in function '" + nptr_local_variable->function_name + "' has been declared but not used." );
				
				not_finished = gbst_local_variables.next_item( bst_ptr, true );
			}
		}

						
		if (! gerror_occured)
		{
			init_global_variables( init_globals );
			
			post_parse_processing();
		}
				
		if (gshow_icode)
		{
			line_number = 0;
			
			ci_output( "<table width='100%'>" );

			j = 1;
			
			for (i=0; i <= ic_pos - 1; i++)
			{
				if (line_number != gruntime_data->ic[i].line_number)
				{
					if (is_web_page)	
						ci_output( "<br>\n" );
					else
						ci_output( "\n" );
				
					ci_output( "Line: " + to_string( gruntime_data->ic[i].line_number ) + ": " + ci_iconvert_to_html( ginput_text[gruntime_data->ic[i].input_filenumber][gruntime_data->ic[i].line_number] ) );
					
					if (is_web_page)	
						ci_output( "<br><br>\n\n" );
					else
						ci_output( "\n\n" );
				
//						ci_output( "<tr><td colspan=10>Line: " + to_string( gruntime_data->ic[i].line_number ) + ": " + iconvert_to_html( ginput_text[gruntime_data->ic[i].input_filenumber][gruntime_data->ic[i].line_number] ) + "</td></tr>\n" );
					
					line_number = gruntime_data->ic[i].line_number;
				}
			
//				if (gruntime_data->ic[i].op != OP_NULL_ENTRY)
				{
//					ci_output( "<tr><td>" + j++ + "</td><td>" + op_descriptions[gruntime_data->ic[i].op] + "</td><td>" + iconvert_to_html( gruntime_data->ic[i].value ) + "</td>" );

//					ci_output( "<tr><td>" + j++ );

					ci_output( to_string( i ) + ": " );

					ci_output( op_descriptions[gruntime_data->ic[i].op] );

//					if (gruntime_data->ic[i].value != "" && gruntime_data->ic[i].op != OP_LABEL && !is_jump_op( gruntime_data->ic[i].op ))
//						ci_output( ": " + gruntime_data->ic[i].value );

					if (gruntime_data->ic[i].variable_name != "")
						ci_output( ": " + gruntime_data->ic[i].variable_name );

					if (is_jump_op( gruntime_data->ic[i].op ))
					{
						ci_output( ": jump to address " );
						ci_output( to_string( gruntime_data->ic[i].jump_call_address ) );
					}

					if (gruntime_data->ic[i].op == OP_LABEL)
					{
						ci_output( ": label " );
						ci_output( to_string( gruntime_data->ic[i].jump_call_address ) );
					}
					

					if (gruntime_data->ic[i].op == OP_START_FUNCTION) 
							ci_output( ": " + gruntime_data->gfunction_details[gruntime_data->ic[i].this_function_number].function_name );

					if (gruntime_data->ic[i].op == OP_CALL_USER_FUNCTION ||
						gruntime_data->ic[i].op == OP_CALL_SYSTEM_FUNCTION)
							ci_output( ": " + gruntime_data->gfunction_details[gruntime_data->ic[i].function_being_called_number].function_name );
										
//					ci_output( "</td><td>" + iconvert_to_html( gruntime_data->ic[i].value ) + "</td>" );
						
//					ci_output( "<td>" + iconvert_to_html( gruntime_data->ic[i].text ) + "</td>" );
						
//					ci_output( "<td>" + gruntime_data->ic[i].value + "</td>" );
						
//					ci_output( "<td>" + gruntime_data->ic[i].type1 + "</td>" );
					
					if (is_web_page)	
						ci_output( "<br>\n" );
					else
						ci_output( "\n" );
				}
			}
			
//			ci_output( "</table>" );
		}

//		gruntime_data->ic = ic;
		gruntime_data->ic_end = ic_pos;

		t_ic *ic_tmp;

		ic_tmp = new t_ic[ic_pos];

		for (i=0; i < ic_pos; i++)
			ic_tmp[i] = gruntime_data->ic[i];  
			
		delete [] gruntime_data->ic;
		
		gruntime_data->ic = ic_tmp;

		if (! gerror_occured)
		{
			optimise_icode();
		
			gruntime_data->global_variable_segment = (ci_var *) _ci_malloc( gruntime_data->gglobal_variables_section_size * sizeof( ci_var ) );

			memset( gruntime_data->global_variable_segment, 0, gruntime_data->gglobal_variables_section_size * sizeof( ci_var ) );

			found_main = false;
			
			ic_pos = gruntime_data->ic_end - 1;
			
			while (ic_pos >= 0 && !found_main)
			{
				if (gruntime_data->ic[ic_pos].op == OP_START_FUNCTION && gruntime_data->ic[ic_pos].function_name == token_text_main)			
				{
					gruntime_data->ic_pos_of_main_function = ic_pos;
					
					gruntime_data->initial_stack_offset = gruntime_data->gfunction_details[gruntime_data->ic[ic_pos].this_function_number].local_variables_stackframe_size + 2;
					
					found_main = true;
				}
				else
					ic_pos--;
			}
	
			if (! found_main)
				ci_runtime_error( 180, "main() function not found." );

						
			if (run_code)
			{
				run_icode( ginitialise_variables, runtime_checks, is_web_page, show_large_strings_warnings );
			}
		}
		
		return (gerror_occured);
	}



	void parse_file()
	{
		bool waiting_on_next_statement;
		int current_line_number;
		int current_function_number;
		int builtin_function_number;
		string link_module_name;
		bool builtin_function;
		
		current_line_number = 1;
		current_function_number = 0;
		
		gin_function = false;

		gstack3_in_use = false;

	waiting_on_next_statement = false;

		goutput_file_type = token_text_main;
	
//		next_token();
		
        while (gcurr_tok != TOK_EOF)
		{
			builtin_function = false;

			if (gcurr_tok == TOK_OPEN_HASH)
			{
				next_token();
				
				if (gcurr_tok == TOK_NAME && gcurr_token_text == "builtin")
				{
					builtin_function = true;

					next_token();
					
					if (gcurr_tok != TOK_NUMBER)
					{
						semantic_error( 396, "Expected a number after 'builtin'." );
						
						builtin_function_number = 0;
					}
					else
						builtin_function_number = ci_cstring_to_int( gcurr_token_text );

					next_token();
				}
				
				while (gcurr_tok != TOK_CLOSE_HASH && gcurr_tok != TOK_EOF)					
					next_token();
						
				if (gcurr_tok == TOK_CLOSE_HASH)
					next_token();
			}

			switch (gcurr_tok)
			{
/*				
				case TOK_BUILTIN:
				{
					builtin_function = true;
	
					next_token();
					
					gin_function = true;
	
					parse_function_definition( current_function_number, builtin_function, false, "" );
	
					gin_function = false;
				}
*/				
				case TOK_VAR:
				{
					waiting_on_next_statement = false;
					
					parse_variable_declaration( false, current_function_number );			
				}
				break;
				
				case TOK_FUNCTION:
				{
					waiting_on_next_statement = false;

					gin_function = true;
	
					parse_function_definition( current_function_number, builtin_function, builtin_function_number, false, "" );
					
					gin_function = false;
				}
				break;
								
				case TOK_TYPE:
				{
					waiting_on_next_statement = false;

					parse_type_definition( current_function_number );
				}
				break;
				
				case TOK_CONST:
				{
					waiting_on_next_statement = false;

					parse_const_declaration( false );
				}
				break;
				
				case TOK_MODULE_NAME:
				{
					waiting_on_next_statement = false;

					next_token();
					
					if (gcurr_tok != TOK_NAME && gcurr_tok != TOK_MAIN)
						syntax_error( 221, "Expected a name after 'module_name'." );
					
					gsmodule_name = gcurr_token_text;

					next_token();
					
					check_for_expected_token( TOK_SEMICOLON, 222, "Expected a ';'." );
						
					next_token();
				}
				break;
			
				case TOK_MODULE_TYPE:
				{
					waiting_on_next_statement = false;

					next_token();
					
					if (gcurr_tok != TOK_MAIN && gcurr_tok != TOK_SECONDARY)
						syntax_error( 228, "Expected keyword '" + token_text_main + "' or '" + token_text_secondary + "'." );
					
					if (gcurr_tok == TOK_MAIN)
						goutput_file_type = token_text_main;
					else
						goutput_file_type = token_text_secondary;
					
					next_token();
		
					check_for_expected_token( TOK_SEMICOLON, 227, "Expected a ';'." );
						
					next_token();
				}
				break;
				
				case TOK_LINK_MODULE:
				{
					waiting_on_next_statement = false;

					has_link_modules = true;
				
					next_token();
					
					check_for_expected_token( TOK_NAME, 223, "Expected a name after 'link_module'." );
					
					link_module_name = gcurr_token_text;
					 
//					gen_code( OP_LINK_MODULE, link_module_name, "" );
					
					next_token();
		
					check_for_expected_token( TOK_SEMICOLON, 224, "Expected a ';'." );
						
					next_token();
				}
				break;
				
				case TOK_RBRACE:
				{
					syntax_error( 407, "Too many closing '}' tokens." );
					
					next_token();
				}
				
				default:
				{
					if (! waiting_on_next_statement)
						syntax_error( 225, "Expected the start of a global Calc statement, possibly too many closing '}': " + gcurr_token_text );
					
					waiting_on_next_statement = true;
				}
			}
		}
			
//		if (goutput_file_type != token_text_main && has_link_modules)
//			semantic_error( 309, "The 'link_module' statement can only be included in files with a 'module_type' of \"" + token_text_main + "\"." );
	}


	void parse_type_definition( int current_function_number )
	{
		string type_name;
		int num_items;
		int total_size;
		bool is_object;
		int type_size;
		int object_number;
//		string object_type;
		string item_type;
		int size;
		
		next_token();
		
		check_for_expected_token( TOK_NAME, 125, "Expected a name after 'type': " + gcurr_token_text );
	
		if (is_reserved_word( gcurr_token_text ))
			semantic_error( 182, "Cannot use a reserved word as a type name" );
	
		type_name = gcurr_token_text;

		if (glookahead_token_text == token_text_object)
			is_object = true;
		else
			is_object = false;

		if (is_global_variable( 0, type_name ))
			semantic_error( 318, "Cannot define a type with the name '" + type_name + "' because there is a global variable with this name." );

		if (is_type_name( type_name ))
			semantic_error( 319, "Cannot define a type with the name '" + type_name + "' because there is already a type with this name." );

		if (is_const_name( type_name ))
			semantic_error( 320, "Cannot define a type with the name '" + type_name + "' because there is a constant defined with that name." );
	
		if (is_function_name( type_name ))
			semantic_error( 322, "Cannot define a type with the name '" + type_name + "' because there is a function defined with that name." );
		
		
		gruntime_data->guser_defined_types[gruntime_data->gnum_user_defined_types].type_name = type_name;
		gruntime_data->guser_defined_types[gruntime_data->gnum_user_defined_types].is_object = is_object;

		if (is_object)
			gruntime_data->guser_defined_types[gruntime_data->gnum_user_defined_types].object_number = gruntime_data->gnum_object_types;
		else
			gruntime_data->guser_defined_types[gruntime_data->gnum_user_defined_types].object_number = -1;
			
		gruntime_data->guser_defined_types[gruntime_data->gnum_user_defined_types].underlying_type = "";
				
		gruntime_data->gnum_user_defined_types++;

		if (is_object)
		{
			gruntime_data->gobject_types[gruntime_data->gnum_object_types].type_size = 0;
			gruntime_data->gobject_types[gruntime_data->gnum_object_types].num_items = 0;
		}
		
		next_token();
		
		item_type = parse_data_type( false, false, size, false, type_name, true );

		type_size = get_type_total_size( item_type );
		
		gruntime_data->guser_defined_types[gruntime_data->gnum_user_defined_types-1].underlying_type = item_type;

		gruntime_data->guser_defined_types[gruntime_data->gnum_user_defined_types-1].type_size = type_size;
				
		if (is_simple_data_type( item_type )) 
		{
			gruntime_data->gobject_types[gruntime_data->gnum_object_types].type_size = 0;
			gruntime_data->gobject_types[gruntime_data->gnum_object_types].num_items = 0;

			object_number = gruntime_data->gnum_object_types;
			
			next_token();
					
			gruntime_data->guser_defined_types[gruntime_data->gnum_user_defined_types-1].underlying_type = token_text_object + "_" + to_string( object_number );
			
			size = get_type_total_size( item_type );
		
			gruntime_data->gobject_types[object_number].item_type[0] = item_type;
						
			gruntime_data->gobject_types[object_number].item_name[0] = "data";

			gruntime_data->gobject_types[object_number].item_size[0] = size;

//			gruntime_data->gobject_types[object_number].item_object_number[0] = -1;
			
			gruntime_data->gobject_types[object_number].offset[0] = 0;
		
			num_items = 1;
		
			total_size = size;

			gruntime_data->gobject_types[object_number].num_items = num_items;
				
			gruntime_data->gobject_types[object_number].type_size = total_size;

			gruntime_data->gnum_object_types++;
		}
		else
		{
			check_for_expected_token( TOK_SEMICOLON, 304, "Expected ';' after a type definition: " + gcurr_token_text );
			
			next_token();

			if (is_object)
				gruntime_data->gnum_object_types++;
		}
						
	}
	
	
	int parse_function_definition( int current_function_number, bool builtin_function, int builtin_function_number, bool is_member_function, string type_name )
	{
		bool in_void_function;
		string type1;
		string type_name2;
		string function_name;
		string function_name2;
		int i, j;
		bool is_ref;
		int label_num_start_function;
		int label_num_start_init_code;
		int func_arg_number;
		int number_of_arguments;
		string result_type;
		int size;
		bool already_defined;
		string argument_names[100];
		string member_of;
		int label_num2;

		member_of = type_name;
		
		next_token();
		
		type1 = parse_data_type( true, true, size, false, type_name2, true );

		if (type1 == token_text_void)
			in_void_function = true;
		else
			in_void_function = false;
					
		result_type = type1;

		gin_function = true;

		if (is_member_function)
			function_name = "object:" + type_name + ":" + gcurr_token_text; 
		else
			function_name = gcurr_token_text;

		function_name2 = gcurr_token_text;
		
		if (is_type_name( gcurr_token_text ))
//		if (! is_member_function && is_type_name( gcurr_token_text ))
		{
			is_member_function = true;

			member_of = gcurr_token_text;

			next_token();
			
			check_for_expected_token( TOK_COLON, 378, "Expected ':' after member type name." );
			
			next_token();

			function_name2 = gcurr_token_text;
			
			function_name = "object:" + member_of + ":" + gcurr_token_text;
		}

		func_arg_number = 0;					

		if (ci_sleft( function_name2, token_text_object.length() + 1 ) == token_text_object + "_")
			semantic_error( 382, "Cannot define a function with a name starting with 'object_' as this is reserved." );
		
		if (is_reserved_word( function_name2 ) && function_name2 != token_text_main)
			semantic_error( 10, "'" + function_name + "' cannot be defined as a function name as it is a reserved word." );
				
		if (is_global_variable( -1, function_name2 ))
			semantic_error( 324, "Cannot define a function with the name '" + function_name2 + "' because there is a global variable with this name." );

		if (is_type_name( function_name2 ))
			semantic_error( 325, "Cannot define a function with the name '" + function_name2 + "' because there is a type with this name." );

		if (is_const_name( function_name2 ))
			semantic_error( 326, "Cannot define a function with the name '" + function_name2 + "' because there is a constant defined with that name." );
		
		current_function_number = check_or_add_new_function( function_name, type1, already_defined );
				
		gruntime_data->gfunction_details[current_function_number].builtin_function = builtin_function;
		gruntime_data->gfunction_details[current_function_number].builtin_function_number = builtin_function_number;
				
		if (already_defined)
		{
			if (result_type != gruntime_data->gfunction_details[current_function_number].return_variable_type)
				semantic_error( 329, "Mismatch in the result type in function declarations of function '" + function_name + "': '" + result_type + "' and '" + gruntime_data->gfunction_details[current_function_number].return_variable_type + "'." );
		}
		else
		{
			gruntime_data->gfunction_details[current_function_number].is_member_function = is_member_function;

			gruntime_data->gfunction_details[current_function_number].member_of = member_of;
		}

		next_token();
		
		check_for_expected_token( TOK_LPARENTHESIS, 11, "Expected '(' after a function name." );
	
		next_token();
	
	    number_of_arguments = 0;
		
		while (gcurr_tok != TOK_RPARENTHESIS && gcurr_tok != TOK_EOF)
		{
			if (gcurr_tok == TOK_REF)
			{
				if (! builtin_function)
					semantic_error( 390, "The 'ref' keyword can only be used in a function declaration for builtin functions." );
				
				is_ref = true;
				next_token();
			}
			else
				is_ref = false;
			
			type1 = parse_data_type( false, true, size, true, type_name2, true );

			if (is_reserved_word( gcurr_token_text ) )
				semantic_error( 307, "The name '" + gcurr_token_text + "' cannot be used as a function parameter name because it is a reserved word." );
					
			if (is_function_name( gcurr_token_text ))
				semantic_error( 330, "Cannot define a function parameter name '" + gcurr_token_text + "' because there is a function with this name." );
	
			if (is_type_name( gcurr_token_text ))
				semantic_error( 331, "Cannot define a function parameter name '" + gcurr_token_text + "' because there is a type with this name." );
	
			if (is_const_name( gcurr_token_text ))
				semantic_error( 332, "Cannot define a function parameter name '" + gcurr_token_text + "' because there is a constant defined with that name." );
						
			for (i=0; i <= gruntime_data->gnum_user_defined_types - 1; i++)
			{
				if (gruntime_data->guser_defined_types[i].type_name == gcurr_token_text)
					semantic_error( 261, "'" + gcurr_token_text + "' cannot be defined as a function parameter name because there is a type with the same name." );
			}			
			
			
			argument_names[number_of_arguments] = gcurr_token_text;

			if (number_of_arguments > max_function_parameters_per_function-2)
				semantic_error( 388, "Too many function arguments." );
			else
				number_of_arguments++;
				
				 
	 		if (number_of_arguments >= 2)
			{
				for (j=0; j <= number_of_arguments - 2; j++)
				{
					if (argument_names[j] == gcurr_token_text)
						syntax_error( 150, "Cannot declare a function argument with the name '" + gcurr_token_text + "' as there is already a function argument with this name." );
				}
			}
				 
			if (already_defined)
			{
				if (number_of_arguments > gruntime_data->gfunction_details[current_function_number].number_of_function_arguments)
					semantic_error( 328, "Mismatch in the number of arguments in function declarations of function '" + function_name + "'." );
				else
				{
					if (gfunction_arguments[current_function_number][number_of_arguments-1].type1 != type1)
						semantic_error( 165, "Type mismatch in function declaration: the type of argument " + to_string( number_of_arguments ) + " in the function declaration of function '" + function_name + "' does not match the type in the previous declaration of this function." );
				}
			}			 
	
			gfunction_arguments2[func_arg_number].name = gcurr_token_text; 
			gfunction_arguments2[func_arg_number].type1 = type1; 
			gfunction_arguments2[func_arg_number].is_ref = is_ref; 
			gfunction_arguments2[func_arg_number].has_been_accessed = false;

			if (func_arg_number > max_function_parameters_per_function-2)
				semantic_error( 388, "Too many function arguments." );
			else
				func_arg_number++;

			next_token();
	
			if (gcurr_tok != TOK_COMMA && gcurr_tok != TOK_RPARENTHESIS)
				syntax_error( 12, "Expected a ',' or ')' after function arguments." );
			
			if (gcurr_tok == TOK_COMMA)
				next_token();
		}

		if (! already_defined)
		{
			for (i=0; i <= func_arg_number-1; i++)
			{
				gfunction_arguments[current_function_number][i].name = gfunction_arguments2[i].name;
				gfunction_arguments[current_function_number][i].type1 = gfunction_arguments2[i].type1;
				gfunction_arguments[current_function_number][i].is_ref = gfunction_arguments2[i].is_ref;
				gfunction_arguments[current_function_number][i].has_been_accessed = gfunction_arguments2[i].has_been_accessed;
			}
		}

		if (! already_defined)
			gruntime_data->gfunction_details[current_function_number].number_of_function_arguments = func_arg_number;
				
		if (already_defined)
		{
			if (number_of_arguments != gruntime_data->gfunction_details[current_function_number].number_of_function_arguments)
				semantic_error( 328, "Mismatch in the number of arguments in function declarations of function '" + function_name + "'." );
		}
						
		calc_function_parameter_offsets( current_function_number );
		
		check_for_expected_token( TOK_RPARENTHESIS, 13, "Expected a ')' after function parameters." );
	
		next_token();
	
		if (gcurr_tok == TOK_SEMICOLON)
		{
			next_token();
		}
		else
		{
				// function declaration names may not match the function definition names
				
			for (j=0; j <= number_of_arguments-1; j++)
				gfunction_arguments[current_function_number][j].name = argument_names[j];
			
			
			label_num2 = glabel_num;
		
			glabel_num++;
	
			if (gruntime_data->gfunction_details[current_function_number].function_has_been_defined)
				semantic_error( 327, "Function '" + function_name + "' can only be defined with one function body." );

			gruntime_data->gfunction_details[current_function_number].function_has_been_defined = true;
	
			gen_code( OP_START_FUNCTION, ci_cint_to_string( current_function_number ), "" );

									
			gruntime_data->ic[ic_pos_minus_1].function_name = ci_sreplace( function_name, ":", "_" );
			
			gruntime_data->ic[ic_pos_minus_1].this_function_number = current_function_number;

			
			if (function_name == token_text_main)
			{	
				glabel_globals_init_start = glabel_num;
		
				glabel_num++;


				glabel_main_start = glabel_num;
		
				glabel_num++;


				gen_code( OP_JMP, ci_cint_to_string( glabel_globals_init_start ), "" );
					
				gen_code( OP_LABEL, ci_cint_to_string( glabel_main_start ), "" );
				
				
			}
			
			
			label_num_start_function = glabel_num;
		
			glabel_num++;
	

			label_num_start_init_code = glabel_num;
		
			glabel_num++;


			gen_code( OP_JMP, ci_cint_to_string( label_num_start_init_code ), "" );
			
			gen_code( OP_LABEL, ci_cint_to_string( label_num_start_function ), "" );
			
			
//			gruntime_data->ic[ic_pos_minus_1].text = function_name;
			
			check_for_expected_token( TOK_LBRACE, 14, "Expected '{' after a function name." );
			
			parse_stat( current_function_number, in_void_function );
		
		
			if (function_name == token_text_main)
			{	
				gen_code( OP_END_MAIN_FUNCTION, "0", "" );
				
				gruntime_data->ic[ic_pos_minus_1].function_name = token_text_main;
	
				gruntime_data->ic[ic_pos_minus_1].this_function_number = current_function_number;
			}
			else
			{
				gen_code( OP_END_FUNCTION, ci_cint_to_string( current_function_number ), result_type );
	
				gruntime_data->ic[ic_pos_minus_1].function_name = ci_sreplace( function_name, ":", "_" );
	
				gruntime_data->ic[ic_pos_minus_1].this_function_number = current_function_number;
			}
	
			gruntime_data->ic[ic_pos_minus_1].return_variable_size = gruntime_data->gfunction_details[current_function_number].return_variable_size;

			
			gen_code( OP_LABEL, ci_cint_to_string( label_num_start_init_code ), "" );

			gen_code( OP_VPTR_SET_LOC, "", "" );

			
			for (i=0; i < gruntime_data->gfunction_details[current_function_number].number_of_local_variables; i++)
			{
				type1 = glocal_variables_array[current_function_number][i].type1;
				
				if (glocal_variables_array[current_function_number][i].initialise_variable)
				{
					if (type1 == token_text_int || type1 == token_text_bool)
					{
						gen_code( OP_VPTR_SET_INT, "", "" );
						gruntime_data->ic[ic_pos_minus_1].ivalue = glocal_variables_array[current_function_number][i].init_ivalue;
					}
					else
					if (type1 == token_text_double)
					{
						gen_code( OP_VPTR_SET_DOUBLE, "", "" );
						gruntime_data->ic[ic_pos_minus_1].nvalue = glocal_variables_array[current_function_number][i].init_nvalue;
					}
					else
					if (type1 == token_text_decimal)
					{
						gen_code( OP_VPTR_SET_DECIMAL, "", "" );
						gruntime_data->ic[ic_pos_minus_1].dvalue = glocal_variables_array[current_function_number][i].init_dvalue;
					}
					else
					if (type1 == token_text_string)
					{
						gen_code( OP_VPTR_SET_STRING, "", "" );

						gruntime_data->ic[ic_pos_minus_1].u32_string_constant_value = duplicate_u32( glocal_variables_array[current_function_number][i].init_str_u32 );
					}
					else
					if (type1 == token_text_date)
					{
						gen_code( OP_VPTR_SET_DATE, "", "" );

						gruntime_data->ic[ic_pos_minus_1].u32_string_constant_value = duplicate_u32( glocal_variables_array[current_function_number][i].init_str_u32 );
					}
					else
					if (type1 == token_text_time)
					{
						gen_code( OP_VPTR_SET_TIME, "", "" );

						gruntime_data->ic[ic_pos_minus_1].u32_string_constant_value = duplicate_u32( glocal_variables_array[current_function_number][i].init_str_u32 );
					}
					else
					if (type1 == token_text_datetime)
					{
						gen_code( OP_VPTR_SET_DATETIME, "", "" );

						gruntime_data->ic[ic_pos_minus_1].u32_string_constant_value = duplicate_u32( glocal_variables_array[current_function_number][i].init_str_u32 );
					}
					else
					{
						cout << "No initialisation available for type '" + type1 + "'.";
						exit(1);
					}
				}
				else
				if (ginitialise_variables)
					init_data_type2( glocal_variables_array[current_function_number][i].type1 );	
			}

			gen_code( OP_JMP, ci_cint_to_string( label_num_start_function ), "" );
		}
		
		return (current_function_number);
	}




	void init_global_variables( bool init_globals )
	{
		int i;
		int label_globals_init_start;
		string type1;
	
	
		gen_code( OP_LABEL, ci_cint_to_string( glabel_globals_init_start ), "" );
	
		gen_code( OP_VPTR_SET_GLOBAL, "", "" );
	
		if (init_globals)
		{
			for (i=0; i < gnumber_of_global_variables; i++)
			{
				type1 = gglobal_variables_array[i].type1;
				
				if (gglobal_variables_array[i].initialise_variable)
				{
					if (type1 == token_text_int || type1 == token_text_bool)
					{
						gen_code( OP_VPTR_SET_INT, "", "" );
						gruntime_data->ic[ic_pos_minus_1].ivalue = gglobal_variables_array[i].init_ivalue;
					}
					else
					if (type1 == token_text_double)
					{
						gen_code( OP_VPTR_SET_DOUBLE, "", "" );
						gruntime_data->ic[ic_pos_minus_1].nvalue = gglobal_variables_array[i].init_nvalue;
					}
					else
					if (type1 == token_text_decimal)
					{
						gen_code( OP_VPTR_SET_DECIMAL, "", "" );
						gruntime_data->ic[ic_pos_minus_1].dvalue = gglobal_variables_array[i].init_dvalue;
					}
					else
					if (type1 == token_text_string)
					{
						gen_code( OP_VPTR_SET_STRING, "", "" );
		
						gruntime_data->ic[ic_pos_minus_1].u32_string_constant_value = duplicate_u32( gglobal_variables_array[i].init_str_u32 );
					}
					else
					if (type1 == token_text_date)
					{
						gen_code( OP_VPTR_SET_DATE, "", "" );
		
						gruntime_data->ic[ic_pos_minus_1].u32_string_constant_value = duplicate_u32( gglobal_variables_array[i].init_str_u32 );
					}
					else
					if (type1 == token_text_time)
					{
						gen_code( OP_VPTR_SET_TIME, "", "" );
		
						gruntime_data->ic[ic_pos_minus_1].u32_string_constant_value = duplicate_u32( gglobal_variables_array[i].init_str_u32 );
					}
					else
					if (type1 == token_text_datetime)
					{
						gen_code( OP_VPTR_SET_DATETIME, "", "" );
		
						gruntime_data->ic[ic_pos_minus_1].u32_string_constant_value = duplicate_u32( gglobal_variables_array[i].init_str_u32 );
					}
					else
					{
						cout << "No initialisation available for type '" + type1 + "'.";
						exit(1);
					}
				}
				else
				if (ginitialise_variables)
					init_data_type2( gglobal_variables_array[i].type1 );	
			}
		}
	
		gen_code( OP_JMP, ci_cint_to_string( glabel_main_start ), "" );
	}



	void init_data_type2( string& type1 )
	{
		int i;
		int label_1, label_2;
		int object_number;			
		int number_of_indexes; 
		int num_elements; 
		int start_of_indexes;
		string element_type;
		int index_details[MAX_NUM_ARRAY_INDEXES];
		
		
		if (type1 == token_text_void)
			;
		else
		if (type1 == token_text_int || type1 == token_text_bool)
			gen_code( OP_VPTR_SET_INT_TO_0, "", "" );
		else
		if (type1 == token_text_double)
			gen_code( OP_VPTR_SET_DOUBLE_TO_0, "", "" );
		else
		if (type1 == token_text_decimal)
			gen_code( OP_VPTR_SET_DECIMAL_TO_0, "", "" );
		else
		if (type1 == token_text_string)
			gen_code( OP_VPTR_SET_STRING_TO_NULL, "", "" );
		else
		if (type1 == token_text_date)
			gen_code( OP_VPTR_SET_DATE_TO_NULL, "", "" );
		else
		if (type1 == token_text_time)
			gen_code( OP_VPTR_SET_TIME_TO_NULL, "", "" );
		else
		if (type1 == token_text_datetime)
			gen_code( OP_VPTR_SET_DATETIME_TO_NULL, "", "" );
		else
		if (type1 == token_text_binary)
			gen_code( OP_VPTR_SET_BINARY_TO_NULL, "", "" );
		else
		if (is_link_type( type1 ))
			gen_code( OP_VPTR_SET_PTR_TO_NULL, "", "" );
		else
		if (is_resizable_array_type( type1 ))
			gen_code( OP_VPTR_SET_AS_EMPTY, "", "" );
		else
		if (is_array_type( type1 ))
		{
			get_array_details( type1, number_of_indexes, num_elements, start_of_indexes, index_details );
			
			element_type = array_element_type( type1 );
			
			
			gen_code( OP_VPTR_REPEAT_1, "", "" );
			
			gruntime_data->ic[ic_pos_minus_1].ivalue = num_elements;
		

			label_1 = glabel_num;
		
			glabel_num++;

			
			label_2 = glabel_num;
		
			glabel_num++;


			gen_code( OP_LABEL, ci_cint_to_string( label_1 ), "" );

			gen_code( OP_VPTR_REPEAT_2, "", "" );

			gruntime_data->ic[ic_pos_minus_1].jump_call_address = label_2;			
			
		
			init_data_type2( element_type );
			

			gen_code( OP_JMP, ci_cint_to_string( label_1 ), "" );

			gen_code( OP_LABEL, ci_cint_to_string( label_2 ), "" );
			
			gen_code( OP_POP_DISCARD, "", "" );
			
			gruntime_data->ic[ic_pos_minus_1].discard_count = 1; 
		}
		else
		{
			object_number = -1;
			
			if (ci_sleft( type1, 7 ) == "object_")
				object_number = ci_cstring_to_int( ci_sright_from_pos( type1, 7 ) );
			else
			{
				for (i=0; i < gruntime_data->gnum_user_defined_types; i++)
				{
					if (gruntime_data->guser_defined_types[i].type_name == type1)
					{
						if (gruntime_data->guser_defined_types[i].is_object)
							object_number = gruntime_data->guser_defined_types[i].object_number;
					}
				}
			}
						
			if (object_number == -1)
			{
				cout << "Type '" + type1 + "' not found in 'init_data()'.";
				exit(1);
			}
			
			for (i=0; i < gruntime_data->gobject_types[object_number].num_items; i++)
				init_data_type2( gruntime_data->gobject_types[object_number].item_type[i] );
		}
	}	




	void init_main()
	{
		bool in_void_function;
		int current_function_number;
		string type1;
		string function_name;
		int func_arg_number;
		int number_of_arguments;
		string result_type;
//		int size;
		bool already_defined;
		string argument_names[100];
		
		type1 = token_text_int;
		
		result_type = type1;

		in_void_function = false;

		gin_function = true;

		func_arg_number = 0;					
	}
	
		// exit function with next token after ";" as current token
		
	void parse_stat( int current_function_number, bool in_void_function )
	{
		int push_flags;
		bool allow_void;
		string name;
		string type1;
		bool stack_value_is_address;
		bool has_function_call;
		bool is_global;
		string array_type;
		string underlying_type;
		int num_indexes;
		string array_element_type2;
		int size;
		string left_side_type;
		string function_name;
		string array_name;
		
		allow_void = false;			

		push_flags = 0;
		
		if (gstack3_in_use)
		{
			gen_code( OP_RESET_ST3_POINTER, "", "" );
		
			gstack3_in_use = false;
		}
		
		switch (gcurr_tok)
		{	
			case TOK_LBRACE:
			{
				next_token();
	
				while (gcurr_tok != TOK_RBRACE && gcurr_tok != TOK_EOF)
					parse_stat( current_function_number, in_void_function );
			
				check_for_expected_token( TOK_RBRACE, 172, "Expected '}' after a statement list." );
	
				next_token();
			}
			break;

			case TOK_NAME:
			{
				if (glookahead_tok == TOK_LPARENTHESIS)
				{					
					name = gcurr_token_text;
					
					function_name = gcurr_token_text;

					next_token();
		
					if (is_member_function_call( current_function_number, name ))
					{
						gen_code( OP_PUSH_ADDR_FUNCTION_PARAMETER, "", "" );
						
						gruntime_data->ic[ic_pos_minus_1].offset = gruntime_data->gfunction_details[current_function_number].number_of_function_arguments + 1;
						
						gen_code( OP_PREP_FOR_MEMBER_FUNC_CALL, "", "" );
					}
		
					stack_value_is_address = false;
		
					type1 = parse_function_call( current_function_number, function_name, stack_value_is_address );				
		
					if (stack_value_is_address)
						semantic_error( 403, "Cannot dereference a stand-alone function call." );
					
					size = get_type_total_size( type1 );
		
					if (size > 0)		// void
					{
						gen_code( OP_POP_DISCARD, "", "" );
						
						gruntime_data->ic[ic_pos_minus_1].discard_count = size;
					}
									
					next_token();
				}
				else
				{
					name = gcurr_token_text;
					
					array_name = name;
					
					check_var_declaration( current_function_number, type1, name, is_global );

					set_var_as_accessed( current_function_number, is_global, name );
						
					left_side_type = type1;
					
					next_token();
					
					if (ci_ssearch( gfor_control_variables, ":" + name + ":" ) != -1)
						semantic_error( 174, "Loop control variable '" + name + "' cannot have a value assigned to it by an assignment statement within its loop." );


					left_side_type = parse_aggregate_expression( allow_void, type1, current_function_number, array_name, stack_value_is_address, has_function_call );
							
					if (gcurr_tok == TOK_SEMICOLON)
					{ 	
						if (stack_value_is_address)
							size = 1;
						else 
							size = get_type_total_size( left_side_type );
			
						if (size > 0)		// void
						{
							gen_code( OP_POP_DISCARD, "", "" );
							
							gruntime_data->ic[ic_pos_minus_1].discard_count = size;
						}
					}
					
					if (gcurr_tok == TOK_SEMICOLON)
						next_token();
														
					if (gcurr_tok == TOK_INC || gcurr_tok == TOK_DEC)
					{
						if (gcurr_tok == TOK_INC)
						{
							if (! is_numeric_type( left_side_type ))
								semantic_error( 151, "Data type of a variable that has ++ applied to it must be numeric." );
							
							push_flags = PUSH_FLAGS_POST_INC;
							next_token();
						}						
						else
						if (gcurr_tok == TOK_DEC)
						{
							if (! is_numeric_type( left_side_type ))
								semantic_error( 152, "Data type of a variable that has -- applied to it must be numeric." );
							
							push_flags = PUSH_FLAGS_POST_DEC;
							next_token();
						}
		
						next_token();
		
						if (push_flags == PUSH_FLAGS_POST_INC)
							gen_code( OP_VAR_INC, "", "" );
						else				
							gen_code( OP_VAR_DEC, "", "" );
					}							
					else
					if (gcurr_tok == TOK_ASSIGN_INC ||
						gcurr_tok == TOK_ASSIGN_DEC ||
						gcurr_tok == TOK_ASSIGN_MULT ||
						gcurr_tok == TOK_ASSIGN_DIV ||
						gcurr_tok == TOK_ASSIGN_STRCONCAT ||
						gcurr_tok == TOK_ASSIGN)
					{
						if (gcurr_tok == TOK_ASSIGN_INC ||
							gcurr_tok == TOK_ASSIGN_DEC ||
							gcurr_tok == TOK_ASSIGN_MULT ||
							gcurr_tok == TOK_ASSIGN_DIV)
						{
							if (! is_numeric_type( left_side_type ))
								semantic_error( 153, "Data type on the left side of a '" + gcurr_token_text + "' operation must be numeric." );
						}
			
						if (gcurr_tok == TOK_ASSIGN_STRCONCAT)
						{
							if (left_side_type != token_text_string)
								semantic_error( 157, "Data type on the left side of an '&=' operation must be a string." );
						}
		
						parse_assignment_right_side( false, current_function_number, name, left_side_type );
						
						check_for_expected_token( TOK_SEMICOLON, 47, "Expected ';' after a statement." );
					
						next_token();
					}
					else
					if (! has_function_call)
						syntax_error( 301, "Value without a statement." );
				}
			}
			break;

	        case TOK_IF:
			{
				parse_if_statment( allow_void, current_function_number, in_void_function );			
			}
			break;

	        case TOK_FOR:
			{
				parse_for_statement( allow_void, current_function_number, in_void_function );			
			}
			break;
			
	        case TOK_SCAN_LIST:
			{
				parse_scan_statement( allow_void, current_function_number, in_void_function );			
			}
			break;

			case TOK_SCAN_LIST_DATA:
			{
				parse_scan_list_data_statement( allow_void, current_function_number, in_void_function );			
			}
			break;
			
			case TOK_SCAN_LIST_KEYS:
			{
				parse_scan_list_keys_statement( allow_void, current_function_number, in_void_function );			
			}
			break;
			
			case TOK_SCAN_DB:
			{
				parse_scan_db_statement( allow_void, current_function_number, in_void_function );			
			}
			break;
			
	        case TOK_WHILE:
			{
				parse_while_statment( allow_void, current_function_number, in_void_function );			
			}
			break;

	        case TOK_DO:
			{
				parse_do_statment( allow_void, current_function_number, in_void_function );			
			}
			break;

	        case TOK_REPEAT:
			{
				parse_repeat_statment( allow_void, current_function_number, in_void_function );			
			}
			break;

	        case TOK_SWITCH:
			{
				parse_switch_statment( allow_void, current_function_number, in_void_function );			
			}
			break;

			case TOK_FREE:
			{
				parse_free_statement( allow_void, current_function_number );
			}
			break;

			case TOK_FUNCTION_TABLE:
			{
				parse_function_table_statement();
			}
			break;

			case TOK_CALL_FUNCTION:
			{
				parse_call_table_function( current_function_number );
			}
			break;

			case TOK_CALL_FUNCTION_BY_NUMBER:
			{
				parse_call_table_function_by_number( current_function_number );
			}
			break;

			case TOK_SETSIZE:
			{
				next_token();
				
				check_for_expected_token( TOK_NAME, 276, "Expected a 'resizable array' variable name." );
	
				name = gcurr_token_text;
	
				check_var_declaration( current_function_number, type1, name, is_global );
	
				if (gshow_warnings)
					set_var_as_accessed( current_function_number, is_global, name );
	
				next_token();
	
				array_type = parse_aggregate_expression( allow_void, type1, current_function_number, name, stack_value_is_address, has_function_call );

				if (! stack_value_is_address)
					semantic_error( 404, "Cannot apply 'setsize' to a function return value." );
				
				if (is_user_defined_type( array_type, underlying_type ))
					array_type = underlying_type;
				
//				if (is_link_type( array_type ))
//				{
//					array_type = get_link_destination_type( array_type );
//				
//					gen_code( OP_PUSH_DEREFERENCE_0, "0", "" );
//				}

				if (! is_resizable_array_type( array_type ))
					semantic_error( 338, "Expected a resizable array variable." );
					
				check_for_expected_token( TOK_LT, 277, "Expected '<'" );
	
				next_token();
	
				num_indexes = 0;
							
				do
				{
					if (num_indexes > 0 && gcurr_tok == TOK_COMMA)
						next_token();
					
					type1 = parse_num_expr( current_function_number );

					type1 = push_var_if_necessary( type1 );
						
					if (type1 != token_text_int)
						semantic_error( 280, "Expected an 'int' expression for the index size of a resizable array." );
						
					num_indexes++;
							
				} while (gcurr_tok == TOK_COMMA);
				
				check_for_expected_token( TOK_GT, 278, "Expected '>'" );
				
				gen_code( OP_PUSH_CONST_INT, ci_cint_to_string( num_indexes ), token_text_int );
	
	
				array_element_type2 = array_element_type( array_type );
	
				gen_code( OP_RARRAY_SETSIZE, "0", array_element_type2 );
				
				next_token();
				
				check_for_expected_token( TOK_SEMICOLON, 279, "Expected ';'" );
				
				next_token();
			}
			break;
						
			case TOK_INC:
			case TOK_DEC:
			{
				if (gcurr_tok == TOK_INC)
				{
					push_flags = PUSH_FLAGS_PRE_INC;
					next_token();
				}						
				else
				if (gcurr_tok == TOK_DEC)
				{
					push_flags = PUSH_FLAGS_PRE_DEC;
					next_token();
				}			
				
				name = gcurr_token_text;
				
				array_name = name;
				
				check_var_declaration( current_function_number, type1, name, is_global );
								
				set_var_as_accessed( current_function_number, is_global, name );
								
				left_side_type = type1;
				
				next_token();
			
				if (ci_ssearch( gfor_control_variables, ":" + name + ":" ) != -1)
					semantic_error( 174, "Loop control variable '" + name + "' cannot have a value assigned to it by an assignment statement within its loop." );
					
				left_side_type = parse_aggregate_expression( allow_void, type1, current_function_number, array_name, stack_value_is_address, has_function_call );
								
				if (! stack_value_is_address)
					semantic_error( 405, "Cannot apply '++' or '--' to a function return value." );
								
				if (push_flags != 0)
				{
					if (push_flags == PUSH_FLAGS_PRE_INC)
					{
						if (! is_numeric_type( left_side_type ))
							semantic_error( 151, "Data type of a variable that has ++ applied to it must be numeric." );
					}						
					else
					if (push_flags == PUSH_FLAGS_PRE_DEC)
					{
						if (! is_numeric_type( left_side_type ))
							semantic_error( 152, "Data type of a variable that has -- applied to it must be numeric." );
					}			
	
					if (push_flags == PUSH_FLAGS_PRE_INC)
						gen_code( OP_VAR_INC, "", "" );
					else				
						gen_code( OP_VAR_DEC, "", "" );
				}
				
				check_for_expected_token( TOK_SEMICOLON, 47, "Expected ';' after a statement." );
			
				next_token();
			}
			break;
	
			case TOK_VAR:
			{
				parse_variable_declaration( false, current_function_number );			
			}
			break;
	
	        case TOK_SEMICOLON:
			{
				next_token();
			}
			break;
			
			case TOK_RBRACE:
			{
				syntax_error( 408, "Too many closing '}' tokens." );
				
				next_token();
			}
			
			default:		
				syntax_error( 64, "Expected the start of a Calc statement." );
		}
	}


		//------------------------------------------------------------------------------------------------
		// Parse a variable name with possibly an array and/or object and/or link dereferences after it. 
		//
		// When this function is called the token after the variable name should be the current token.
		//
		// Exits with the current token as the next token after the variable expression. 
		//
		// leave this function with a single pointer address on the stack. 
		//------------------------------------------------------------------------------------------------
	
	string parse_aggregate_expression( bool allow_void, string& expression_type, int current_function_number, string& name, bool& stack_value_is_address, bool &has_function_call )
	{
		has_function_call = false;
		
			// push an absolute or relative address

		gen_code_push_var_address( current_function_number, name );

		stack_value_is_address = true;

		if (gcurr_tok == TOK_LBRACKET || gcurr_tok == TOK_DOT || gcurr_tok == TOK_LBRACE)
			expression_type = parse_dereference( allow_void, expression_type, current_function_number, name, stack_value_is_address, has_function_call );

//		if (has_function_call)
//			expression_type = "addr " + expression_type;
		
		return (expression_type);
	}


		//------------------------------------------------------------------------------------------------
		// Parse an array and/or object dereference
		//
		// leave this function with a single pointer address on the stack
		//------------------------------------------------------------------------------------------------

	string parse_dereference( bool allow_void, string& expression_type, int current_function_number, string& name, bool& stack_value_is_address, bool &has_function_call )
	{
		int array_indexes[MAX_NUM_ARRAY_INDEXES];
		int num_indexes;
		int number_of_elements;				
		string type1;
		string type_name2;
		string array_type;
		int start_of_indexes;
		int number_of_indexes;
		int index_number;
		string array_name;
		int this_number_of_indexes;
		int subarray_size;
		int number_of_dimensions;
		int size;
		int i, k;
		int element_size;
		string function_name;
		string underlying_type;
		int push_flags;
		int object_number;
		int num_items;
		string function_name2;
		bool finished;
		bool stat;
		bool found;
		bool is_global;
		string item_name;
		int offset;
		string item_type;

		finished = false;

		has_function_call = false;

		while ((gcurr_tok == TOK_LBRACKET || 
				gcurr_tok == TOK_DOT ||
				gcurr_tok == TOK_LBRACE) &&
				! finished)
		{
			if (is_user_defined_type( expression_type, underlying_type ))
				expression_type = underlying_type;
			
			if (is_link_type( expression_type ))
			{
				if (gcurr_tok == TOK_LBRACKET)
					syntax_error( 371, "A link variable cannot be immediately followed by a '['" );
				
				if (gcurr_tok == TOK_LBRACE)
				{
					next_token();
					
					if (expression_type != (token_text_link_plus_one_space + token_text_to + " " + token_text_general))
						semantic_error( 351, "Expected a 'link to general' variable for the '{' operator: '" + expression_type + "'" );

					expression_type = parse_data_type( false, false, size, false, type_name2, false );
	
					if (! is_link_type( expression_type ))
						semantic_error( 372, "Expected a link type for the '{' operator: '" + expression_type + "'" );

					check_for_expected_token( TOK_RBRACE, 373, "Expected '}'" );

					next_token();
				}
					
				expression_type = get_link_destination_type( expression_type );
				
				push_flags = 0;
		
				stat = true;

				found = false;
			
				gen_code( OP_PUSH_DEREFERENCE_0, "0", "" );
				
				gruntime_data->ic[ic_pos_minus_1].type_map = ci_make_type_map( token_text_link + " " + token_text_to + " " + expression_type );
				
				is_global = true;
				
				next_token();
			}
			else
			if (gcurr_tok == TOK_LBRACKET && is_resizable_array_type( expression_type ))
			{
				check_for_expected_token( TOK_LBRACKET, 277, "Expected '['." );
	
				next_token();
	
				num_indexes = 0;
							
				do
				{
					if (num_indexes > 0 && gcurr_tok == TOK_COMMA)
						next_token();
					
					type1 = parse_num_expr( current_function_number );

					type1 = push_var_if_necessary( type1 );
						
					if (type1 != token_text_int)
						semantic_error( 280, "Expected an 'int' expression for the index size of a resizable array." );
						
					num_indexes++;
							
				} while (gcurr_tok == TOK_COMMA);
				
				check_for_expected_token( TOK_RBRACKET, 278, "Expected ']'" );
	
				next_token();
	
				expression_type = array_element_type( expression_type ); 
				
				gen_code( OP_PUSH_CONST_INT, ci_cint_to_string( num_indexes ), token_text_int );

				gen_code( OP_RARRAY_DEREFERENCE, "0", expression_type );
			}
			else
			if (gcurr_tok == TOK_LBRACKET)
			{
				if (! is_array_type( expression_type ))
				{
					semantic_error( 370, "Expected an array expression for '[' '" + expression_type + "'" );
					
					next_token();
				}
				
				array_type = expression_type;
				
				get_array_details( expression_type, number_of_indexes, number_of_elements, start_of_indexes, array_indexes );
				
				start_of_indexes = 0;
				
				array_name = name;
												
				this_number_of_indexes = number_of_indexes;
				
				next_token();
				
				type1 = parse_num_expr( current_function_number );

				type1 = push_var_if_necessary( type1 );

				index_number = 0;

				if (type1 != token_text_int)
					semantic_error( 246, "Expected an 'int' expression as an array index, index number " + (index_number+1) );
		
					// Array bounds check 
	  
	  			if (garray_bounds_checks)
				{
					array_bounds_check( array_indexes, start_of_indexes, index_number, current_function_number, array_name, number_of_indexes );
				}
					
				while (gcurr_tok == TOK_COMMA)
				{
					index_number++;
					
					next_token();
		
					type1 = parse_num_expr( current_function_number );
					
					type1 = push_var_if_necessary( type1 );

					if (type1 != token_text_int)
						semantic_error( 246, "Expected an 'int' expression as an array index, index number " + (index_number+1) );
					
					subarray_size = 1;
					
					if (index_number <= number_of_indexes)
					{
						for (k=0; k <= index_number - 1; k++)
							subarray_size *= array_indexes[k];
					}
					
	 					// Array bounds check 
	  
	  				if (garray_bounds_checks)
						array_bounds_check( array_indexes, start_of_indexes, index_number, current_function_number, array_name, number_of_indexes );
									
					if (subarray_size > 1)
					{
						gen_code( OP_PUSH_CONST_INT, ci_cint_to_string( subarray_size ), token_text_int );
	
						gen_code( OP_MULT_INT, "", "" );
						
						gen_code( OP_ADD_INT, "", "" );
					}
				}				
			
				element_size = get_array_element_size( array_type );
				
				gen_code( OP_PUSH_CONST_INT, ci_cint_to_string( element_size ), token_text_int );
	
				gen_code( OP_MULT_INT, "0", "" );
	
				index_number++;
				
				if (index_number != number_of_indexes)
				{
					if (index_number == 1)
						semantic_error( 41, "Expected " + to_string( this_number_of_indexes ) + " indexes for variable '" + array_name + "' but received 1 index (array type = " + array_type + ")." );
					else
					if (number_of_indexes == 1)
						semantic_error( 41, "Expected 1 index for variable '" + array_name + "' but received " + to_string( index_number ) + " indexes (array type = " + array_type + ")." );
					else 
						semantic_error( 41, "Expected " + to_string( this_number_of_indexes ) + " indexes for variable '" + array_name + "' but received " + to_string( index_number ) + " indexes (array type = " + array_type + ")." );
				}
				
				if (gcurr_tok != TOK_RBRACKET)
					syntax_error( 42, "Expected ']' + " );
		
				next_token();
	
				expression_type = array_element_type( expression_type );

				gen_code( OP_ADD_TO_POINTER, "0", "" );
			}
			else
			if (gcurr_tok == TOK_DOT)
			{
				next_token();

				check_for_expected_token( TOK_NAME, 130, "Expected a name after '.': " + gcurr_token_text + ", type: " + expression_type );

				item_name = gcurr_token_text;

				if (glookahead_tok == TOK_LPARENTHESIS)
				{
					has_function_call = true;
					
					function_name = gcurr_token_text;

					next_token();

					gen_code( OP_PREP_FOR_MEMBER_FUNC_CALL, "", "" );
		
					num_items = ci_sexplode( expression_type, "_", explode_result, 100 );
					
					stack_value_is_address = false;
					
					if (num_items < 2)
						ci_print( "Internal error in object expression" );
					else
					{
						object_number = ci_cstring_to_int( explode_result[1] );
						
						for (i=0; i <= gruntime_data->gnum_user_defined_types - 1; i++)
						{
							if (gruntime_data->guser_defined_types[i].object_number == object_number)
							{
								function_name2 = "object:" + gruntime_data->guser_defined_types[i].type_name + ":" + function_name; 
											
								stack_value_is_address = false;
											
								expression_type = parse_function_call( current_function_number, function_name2, stack_value_is_address );
							}
						}				
					}		
					
/*		
					size = get_type_total_size( type1 );
		
					if (size > 0)		// void
					{
						gen_code( OP_PUSH_CONST_INT, ci_cint_to_string( size ), token_text_int );
		
						gen_code( OP_POP_DISCARD, "", "" );
					}
*/
									
				}
				else 
				{
					get_object_item_details( expression_type, item_name, item_type, offset, found, true );
		
					expression_type = item_type;
					
					next_token();

					if (offset != 0)
					{
						gen_code( OP_PUSH_CONST_INT, ci_cint_to_string( offset ), token_text_int );
	
						gen_code( OP_ADD_TO_POINTER, "0", "" );
					}
				}
			}
			else
				finished = true;
		}
	
		return (expression_type);
	}
	
	
	string trim_addr_if_necessary( string& type1 )
	{
		if (ci_sleft( type1, 5 ) == "addr ")
			return (ci_sright_from_pos( type1, 5 ));
		else
			return (type1);
	}
		

	void array_bounds_check( int array_indexes[MAX_NUM_ARRAY_INDEXES], int start_of_indexes, int index_number, int current_function_number, string& name, int number_of_indexes )
	{
		gen_code( OP_ARRAY_BOUNDS_CHECK, "", token_text_int );

		gruntime_data->ic[ic_pos_minus_1].array_index_size = array_indexes[index_number];

		gruntime_data->ic[ic_pos_minus_1].error_text = ci_cint_to_string( index_number+1 );
	}	


	void parse_assignment_right_side( bool allow_void, int current_function_number, string& name, string& left_side_type )
	{
		string type1, type2;
		string type_name2;
		bool is_global;
		string array_type;
		string right_side_name;
		string right_side_type;
		bool is_global_left_side;
		int destination_size;
		int size;
		int op;
		string operator_text;
		
		if (gcurr_tok == TOK_ASSIGN)
		{
			check_var_declaration( current_function_number, type1, name, is_global );
			
			if (gshow_warnings)
				set_var_as_accessed( current_function_number, is_global, name );
			
			array_type = type1;
			
			next_token();
			
			if (gcurr_tok == TOK_NEW)
			{
				if (! is_link_type( left_side_type ))
					syntax_error( 185, "'new' can only be applied to a link." );
				
				destination_size = get_link_destination_size( left_side_type );
	
				type1 = get_link_destination_type( left_side_type );
					
				next_token();
					
				type2 = parse_data_type( false, false, size, false, type_name2, true );
					
				if (type1 != type2)
					semantic_error( 374, "Type mismatch in 'new' operation: '" + type1 + "' and '" + type2 + "'." );
				
				gen_code( OP_PUSH_NEW_ALLOC, "0", get_link_destination_type( left_side_type ) );

				gruntime_data->ic[ic_pos_minus_1].type_map = ci_make_type_map( left_side_type );

				gen_code( OP_POP_VAR, name, token_text_int );
	
				check_for_expected_token( TOK_SEMICOLON, 180, "Expected a ';' after 'new'." );
			}
			else
			{
				right_side_name = gcurr_token_text;
				
				right_side_type = parse_expr( current_function_number );
			
				right_side_type = push_var_if_necessary( right_side_type );
			
				if (is_link_type( right_side_type ) && (! is_link_type( left_side_type )))
				{
					semantic_error( 235, "Link contents cannot be applied to an object type." );
				}
				else
				if ((! is_link_type( right_side_type )) && is_link_type( left_side_type ))
					semantic_error( 264, "A data object cannot be applied to a link." );
				else
				{
					if (left_side_type == token_text_void)
						semantic_error( 339, "Cannot assign a result value to a 'void' function." );
					
					if (! check_types( left_side_type, right_side_type, true, 0 ))
						semantic_error( 35, "Data types in an assignment expression must match or both be numeric: '" + left_side_type + "' and '" + right_side_type + "'." );

					generate_type_conversion_if_necessary( right_side_type, left_side_type, 1 );
				}
					
				check_var_declaration( current_function_number, type1, name, is_global_left_side );
			
				size = get_type_total_size( left_side_type );

				gen_code( OP_POP_VAR, name, left_side_type );
				
				if (is_link_type( left_side_type ) and left_side_type != token_text_link + " " + token_text_to + " " + token_text_general)
					gruntime_data->ic[ic_pos_minus_1].type_map = ci_make_type_map( left_side_type );
			}
		}
		else
		if (gcurr_tok == TOK_ASSIGN_INC ||
			  gcurr_tok == TOK_ASSIGN_DEC ||
			  gcurr_tok == TOK_ASSIGN_MULT ||
			  gcurr_tok == TOK_ASSIGN_DIV ||
			  gcurr_tok == TOK_ASSIGN_STRCONCAT)
		{
			op = gcurr_tok;
			operator_text = gcurr_token_text;

			check_var_declaration( current_function_number, type1, name, is_global );
			
			next_token();
	
			if (op == TOK_ASSIGN_STRCONCAT)
			{
				gen_code( OP_DUPLICATE, "0", "" );
				
				gen_code( OP_PUSH_VAR, name, left_side_type );
		
				gruntime_data->ic[ic_pos_minus_1].push_flags = 0;
			}
				
			right_side_type = parse_num_expr( current_function_number );
	
			right_side_type = push_var_if_necessary( right_side_type );
	
			if (op != TOK_ASSIGN_STRCONCAT && (! is_numeric_type( right_side_type ) ))
				semantic_error( 155, "Data type of the expression on the right side of an " + operator_text + " must be numeric." );

			generate_type_conversion_if_necessary( right_side_type, left_side_type, 1 );

			if (op == TOK_ASSIGN_STRCONCAT)
				gen_code( OP_PLUS_EQ_CONCAT_STR, name, "" );
			else
			{
				if (left_side_type == token_text_int)
				{
					switch (op)
					{
						case TOK_ASSIGN_INC:				gen_code( OP_PLUS_EQ_ADD_INT, name, "" );			break;
						case TOK_ASSIGN_DEC:				gen_code( OP_PLUS_EQ_SUBTRACT_INT, name, "" );		break;
						case TOK_ASSIGN_MULT:				gen_code( OP_PLUS_EQ_MULT_INT, name, "" );			break;
						case TOK_ASSIGN_DIV:				gen_code( OP_PLUS_EQ_DIV_INT, name, "" );			break;
					}

					if (op == TOK_ASSIGN_DIV)
					{
						if (gshow_warnings)
							syntax_warning( 0, "Integer division, fractional component truncated" );
					}					
				}
				else
				if (left_side_type == token_text_double)
				{
					switch (op)
					{
						case TOK_ASSIGN_INC:				gen_code( OP_PLUS_EQ_ADD_DOUBLE, name, "" );		break;
						case TOK_ASSIGN_DEC:				gen_code( OP_PLUS_EQ_SUBTRACT_DOUBLE, name, "" );	break;
						case TOK_ASSIGN_MULT:				gen_code( OP_PLUS_EQ_MULT_DOUBLE, name, "" );		break;
						case TOK_ASSIGN_DIV:				gen_code( OP_PLUS_EQ_DIV_DOUBLE, name, "" );		break;
					}
				}
				else
				if (left_side_type == token_text_decimal)
				{
					switch (op)
					{
						case TOK_ASSIGN_INC:				gen_code( OP_PLUS_EQ_ADD_DECIMAL, name, "" );		break;
						case TOK_ASSIGN_DEC:				gen_code( OP_PLUS_EQ_SUBTRACT_DECIMAL, name, "" );	break;
						case TOK_ASSIGN_MULT:				gen_code( OP_PLUS_EQ_MULT_DECIMAL, name, "" );		break;
						case TOK_ASSIGN_DIV:				gen_code( OP_PLUS_EQ_DIV_DECIMAL, name, "" );		break;
					}
				}
	
			}

			check_var_declaration( current_function_number, type1, name, is_global );
	
			if (op == TOK_ASSIGN_STRCONCAT)
				gen_code( OP_POP_VAR, name, left_side_type );
		}
	}
	
	void parse_const_declaration( bool allow_void )
	{
		t_bst_string_constant *nptr_string_constant;
		t_constants *nptr;
		string type1;
		string minus;
		bool found;
		int size;
		string const_name;
		string const_value;
		
		next_token();
		
		type1 = gcurr_token_text;
		
		if (! is_data_type( gcurr_tok, gcurr_token_text, size ))
			syntax_error( 59, "Expected a data type: " + gcurr_token_text );
	
		next_token();
		
		check_for_expected_token( TOK_NAME, 60, "Expected a name after a 'const'" );
		
		if (is_reserved_word( gcurr_token_text ) )
			syntax_error( 61, "'" + gcurr_token_text + "' cannot be defined as a variable name it is a reserved word." );
		
		const_name = gcurr_token_text;

		if (is_global_variable( 0, const_name ))
			semantic_error( 316, "Cannot define a constant with the name '" + const_name + "' because there is a global variable with this name." );

		if (is_type_name( const_name ))
			semantic_error( 317, "Cannot define a constant with the name '" + const_name + "' because there is a type with this name." );

		if (is_const_name( const_name ))
			semantic_error( 149, "Cannot define a constant with the name '" + const_name + "' because there is already a constant defined with that name." );
	
		if (is_function_name( const_name ))
			semantic_error( 323, "Cannot define a constant with the name '" + const_name + "' because there is a function defined with that name." );
	
	
		next_token();

		check_for_expected_token( TOK_ASSIGN, 62, "Expected a '=' after a 'const' name" );
		
		next_token();
	
		minus = "";
	
		if (gcurr_tok == TOK_SUBTRACT_MINUS)
		{
			minus = "-";
			next_token();
			
			check_for_expected_token( TOK_NUMBER, 169, "Expected a number after 'const' '-'" );
		}
		
		if (type1 == token_text_bool)
		{
			nptr = lookup_constant( gcurr_token_text, found );
			
			if (found)
				const_value = nptr->value;
			else
			{
				if (ci_scaseieq( gcurr_token_text, "true" ))
					const_value = "1";
				else
					const_value = "0";
			}
			
			next_token();
		}
		else
		if (type1 == token_text_int || type1 == token_text_decimal || type1 == token_text_double)
			const_value = to_string( parse_const_numerical_expr( type1 ) );
		else			
		if (type1 == token_text_string)
		{
			const_value = parse_const_string_expr();
				
/*				
			if (const_value == "")
				const_value = "0";
			else
			{
				nptr_string_constant = (t_bst_string_constant *) gbst_string_constants.search_s( const_value, found );
					
				if (! found)
				{
					gstring_constants[gnum_string_constants].string_number = gnum_string_constants;
					gstring_constants[gnum_string_constants].str_value = const_value;
					
					nptr_string_constant = new t_bst_string_constant;
						
					nptr_string_constant->string_number = gnum_string_constants;
					nptr_string_constant->str_value = const_value;
						
					gnum_string_constants++;
	 
					gbst_string_constants.insert_s( const_value, nptr_string_constant );
				}
				
				const_value = cint_to_string( nptr_string_constant->string_number );
			}
*/ 
		}
		else
		{
			nptr = lookup_constant( gcurr_token_text, found );
			
			if (found)
				const_value = nptr->value;
			else
				const_value = minus + gcurr_token_text;
		
			next_token();
		}

		check_for_expected_token( TOK_SEMICOLON, 63, "Expected a ';' after a 'const'" );
			
		add_constant( const_name, const_value, type1 );
					
		gnum_constants++;
		
	
		next_token();
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Parse a deallocation of memory
		//---------------------------------------------------------------------------------------------------------------------
			
	void parse_free_statement( bool allow_void, int current_function_number )
	{
		string name;
		string type1;
		string type12;
		bool is_global;
		bool stack_value_is_address;
		bool has_function_call;
		string element_type;
		
		next_token();

		check_for_expected_token( TOK_NAME, 300, "Expected a name after 'free'" );

		name = gcurr_token_text;  
		
		check_var_declaration( current_function_number, type1, name, is_global );

		if (gshow_warnings)
			set_var_as_accessed( current_function_number, is_global, name );

		next_token();
				
		type12 = parse_aggregate_expression( allow_void, type1, current_function_number, name, stack_value_is_address, has_function_call );
		
		if (! stack_value_is_address)
			semantic_error( 406, "Cannot apply 'free' to a function return value." );
		
		if (! is_link_type( type12 ))
			semantic_error( 256, "Expected a 'link' type as an argument." );
		
		element_type = get_link_destination_type( type12 );

//		gen_code( OP_PUSH_VAR, "", "link to general" );
		
		gen_code( OP_DEALLOC, name, element_type );

//		gen_code( OP_PUSH_CONST_INT, "0", token_text_int );

//		gen_code( OP_POP_VAR, "0", "link to general" );

		check_for_expected_token( TOK_SEMICOLON, 257, "Expected a ';'." );
	
		next_token();
	}

		//---------------------------------------------------------------------------------------------------------------------
		// Parse a function table definition
		//---------------------------------------------------------------------------------------------------------------------
		
	void parse_function_table_statement()
	{
		int num_items;
		t_bst_function_number *nptr; 
		bool found;
		string name;
		
		next_token();
		
		num_items = 0;
		
		do
		{
			if (num_items > 0 && gcurr_tok == TOK_COMMA)
				next_token();
			
			check_for_expected_token( TOK_NAME, 265, "Expected a function name in a function table definition." );
			
			name = gcurr_token_text;

			if (! is_function_name( name ))
				semantic_error( 333, "Function table entry '" + name + "' is not recognised as a function name." );
			else
			{
				nptr = (t_bst_function_number *) gbst_function_numbers.search_s( name, found );
				
				if (gruntime_data->gfunction_details[nptr->function_number].return_variable_type != token_text_void)
					semantic_error( 409, "Function table entry '" + name + "' must have a return type of 'void'." );
				
				gruntime_data->gfunction_table[gruntime_data->gnum_function_table_items].function_name = name;
				gruntime_data->gfunction_table[gruntime_data->gnum_function_table_items].function_number = nptr->function_number;
				gruntime_data->gfunction_table[gruntime_data->gnum_function_table_items].function_icode_address = 0;
			  
				gruntime_data->gnum_function_table_items++;
			}

			next_token();

			num_items++;

		} while (gcurr_tok == TOK_COMMA);

		check_for_expected_token( TOK_SEMICOLON, 266, "Expected a ';' after a function table definition." );

		next_token();
	}
	
	
	void parse_call_table_function( int current_function_number )
	{
		string name;
		string type1;
		bool is_global;
		bool stack_value_is_address;
		bool has_function_call;
		
		next_token();

		check_for_expected_token( TOK_LPARENTHESIS, 265, "Expected '(' after call_function." );

		next_token();

		name = gcurr_token_text;
		
		check_var_declaration( current_function_number, type1, name, is_global );
				
		if (gshow_warnings)
			set_var_as_accessed( current_function_number, is_global, name );
		
		gen_code( OP_PUSH_SP_ONTO_ST2, "", "" );
				
		type1 = parse_aggregate_expression( false, type1, current_function_number, name, stack_value_is_address, has_function_call );
		
		if (! is_link_type( type1 ))
			semantic_error( 267, "The argument passed to a 'call_function' must be a link type." );
				
//		gen_code( OP_PUSH_DEREFERENCE_0, "", "" );
		gen_code( OP_PUSH_VAR, "", type1 );

		gen_code( OP_SET_ST2_PTR_TO_SP, "", type1 );

		next_token();

		check_for_expected_token( TOK_COMMA, 268, "Expected ',' after call_function argument." );
		
		next_token();
				
		type1 = parse_num_expr( current_function_number );
		
		type1 = push_var_if_necessary( type1 );
		
		if (type1 != token_text_string)
			semantic_error( 269, "The function name of a 'call_function' function must be a string type." );

		check_for_expected_token( TOK_RPARENTHESIS, 270, "Expected ')' after call_function." );

		next_token();

		check_for_expected_token( TOK_SEMICOLON, 271, "Expected ';' after call_function." );

		next_token();
						
		gen_code( OP_CALL_TABLE_FUNCTION, "", "" );
	}
	

	void parse_call_table_function_by_number( int current_function_number )
	{
		string name;
		string type1;
		bool is_global;
		bool stack_value_is_address;
		bool has_function_call;
		
		next_token();

		check_for_expected_token( TOK_LPARENTHESIS, 265, "Expected '(' after call_function." );

		next_token();

		name = gcurr_token_text;
		
		check_var_declaration( current_function_number, type1, name, is_global );
		
		if (gshow_warnings)
			set_var_as_accessed( current_function_number, is_global, name );
		
		gen_code( OP_PUSH_SP_ONTO_ST2, "", "" );
		
		type1 = parse_aggregate_expression( false, type1, current_function_number, name, stack_value_is_address, has_function_call );
		
		if (! is_link_type( type1 ))
			semantic_error( 267, "The argument passed to a 'call_function' must be a link type." );
				
//		gen_code( OP_PUSH_DEREFERENCE_0, "0", "" );
		gen_code( OP_PUSH_VAR, "", type1 );
		
		gen_code( OP_SET_ST2_PTR_TO_SP, "", type1 );

		next_token();

		check_for_expected_token( TOK_COMMA, 268, "Expected ',' after call_function argument." );
		
		next_token();
				
		type1 = parse_num_expr( current_function_number );
		
		type1 = push_var_if_necessary( type1 );
		
		if (type1 != token_text_int)
			semantic_error( 269, "The function number of a 'call_function_by_number' function must be a int type." );

		check_for_expected_token( TOK_RPARENTHESIS, 270, "Expected ')' after call_function." );

		next_token();

		check_for_expected_token( TOK_SEMICOLON, 271, "Expected ';' after call_function." );

		next_token();
						
		gen_code( OP_CALL_TABLE_FUNCTION_BY_NUMBER, "0", "" );
	}
	
	
	void parse_variable_declaration( bool allow_void, int current_function_number )
	{
		t_global_variable *nptr_global_var;
		string type1, type_name2;
		string var_name;
		char *ptr;
		bool initialise_variable;
		long int init_ivalue;
		long int init_dvalue;
		double init_nvalue;
		string init_svalue;
		int size;
		
		next_token();
	
		type1 = parse_data_type( false, false, size, false, type_name2, true );
		
		while (gcurr_tok != TOK_SEMICOLON && gcurr_tok != TOK_EOF)
		{
			check_for_expected_token( TOK_NAME, 54, "Expected the word 'array' or a name after a 'var'." );
	
			var_name = gcurr_token_text;

			initialise_variable = false;
			
			next_token();
	
			if (gcurr_tok == TOK_ASSIGN)
			{
				initialise_variable = true;

				next_token();
				
				if (type1 == token_text_int)
				{
					init_ivalue = parse_const_numerical_expr_i( type1 );
				}
				else
				if (type1 == token_text_decimal)
				{
					init_dvalue = parse_const_numerical_expr( type1 );
				}
				else
				if (type1 == token_text_double)
				{
					init_nvalue = parse_const_numerical_expr( type1 );
				}
				else
				if (type1 == token_text_string)
					init_svalue = parse_const_string_expr();
				else							 
				if (type1 == token_text_date)
				{
					if (gcurr_tok != TOK_DATE_CONSTANT)
						semantic_error( 403, "Expected a date constant." );
					
					init_svalue = gcurr_token_text;

					next_token();
				}
				else							 
				if (type1 == token_text_time)
				{
					if (gcurr_tok != TOK_TIME_CONSTANT)
						semantic_error( 404, "Expected a time constant." );
					
					init_svalue = gcurr_token_text;

					next_token();
				}
				else							 
				if (type1 == token_text_datetime)
				{
					if (gcurr_tok != TOK_DATETIME_CONSTANT)
						semantic_error( 405, "Expected a datetime constant." );
					
					init_svalue = gcurr_token_text;

					next_token();
				}
				else
				if (type1 == token_text_bool)
				{
					if (gcurr_tok != TOK_BOOLEAN_CONSTANT)
						semantic_error( 406, "Expected a boolean constant." );
					
					if (ci_scaseieq( gcurr_token_text, "true" ))
						init_ivalue = 1;
					else
						init_ivalue = 0;
					
					next_token();
				}
				else
					semantic_error( 398, "Initialisation not available for type '" + type1 + "'." );
			}
			
			if (is_reserved_word( var_name ) )
				syntax_error( 55, "'" + var_name + "' cannot be defined as a variable name as it is a reserved word." );
			else
			if (is_type_name( var_name ))
				semantic_error( 260, "'" + var_name + "' cannot be defined as a variable name because there is a type with the same name." );
			else
			if (is_const_name( var_name ))
				semantic_error( 321, "Cannot define a variable with the name '" + var_name + "' because there is a constant defined with that name." );
			else
			if (is_function_name( var_name ))
				semantic_error( 323, "Cannot define a variable with the name '" + var_name + "' because there is a function defined with that name." );
			else
			{			
				if (gin_function)
				{
					if (is_function_parameter( current_function_number, var_name ))
						semantic_error( 56, "Cannot declare a local variable with the name '" + var_name + "' in this function because there is a function parameter with the same name." );
					else
					if (is_local_variable( current_function_number, var_name ))
						semantic_error( 135, "Cannot declare a local variable with the name '" + var_name + "' there is already a local variable with this name." );
					else
						add_local_variable( current_function_number, var_name, type1, size, false, initialise_variable, init_ivalue, init_dvalue, init_nvalue, init_svalue );
				}
				else
				{
					if (gbst_global_variables.key_is_in_tree_s( var_name ))
						semantic_error( 135, "Cannot declare a global variable with the name '" + var_name + "' there is already a global variable with this name." );
					else	
						add_global_variable( var_name, type1, false, initialise_variable, init_ivalue, init_dvalue, init_nvalue, init_svalue );
				}
			}
		
			if (gcurr_tok != TOK_COMMA && gcurr_tok != TOK_SEMICOLON)
				syntax_error( 57, "Expected a ',' or ';' after a 'var' name: " + gcurr_token_text );
			
			if (gcurr_tok == TOK_COMMA)
				next_token();
		}
		
		check_for_expected_token( TOK_SEMICOLON, 58, "Expected ';' after a statement." );
	
		next_token();
	}	
	

	
	void parse_while_statment( bool allow_void, int current_function_number, bool in_void_function )
	{
		int label_num4;
		int label_num5;
		string type1;
		
		next_token();
		
		check_for_expected_token( TOK_LPARENTHESIS, 31, "Expected '(' after 'while'." );
	
		next_token();
		
		label_num4 = glabel_num;
			
		gen_code( OP_LABEL, ci_cint_to_string( label_num4 ), "" );
			
		glabel_num++;
		
		type1 = parse_expr( current_function_number );
	
		type1 = push_var_if_necessary( type1 );
	
		if (type1 != token_text_bool)
			semantic_error( 32, "Expected a boolean expression as the control condition of a 'while'." );
	
		label_num5 = glabel_num;
	
		glabel_num++;
	
		gen_code( OP_JMP_FALSE, ci_cint_to_string( label_num5 ), "" );
	
		check_for_expected_token( TOK_RPARENTHESIS, 33, "Expected ')' after boolean expression." );
	
		next_token();
	
		parse_stat( current_function_number, in_void_function );
	
		gen_code( OP_JMP, ci_cint_to_string( label_num4 ), "" );
		
		gen_code( OP_LABEL, ci_cint_to_string( label_num5 ), "" );
	}


	void parse_do_statment( bool allow_void, int current_function_number, bool in_void_function )
	{
		int label_num4;
		string type1;
		
		label_num4 = glabel_num;

		glabel_num++;
			
		gen_code( OP_LABEL, ci_cint_to_string( label_num4 ), "" );

		next_token();

		parse_stat( current_function_number, in_void_function );
		
		check_for_expected_token( TOK_WHILE, 238, "Expected 'while'." );
	
		next_token();

		check_for_expected_token( TOK_LPARENTHESIS, 239, "Expected '(' after 'while'." );

		next_token();
		
		type1 = parse_expr( current_function_number );
	
		type1 = push_var_if_necessary( type1 );
	
		if (type1 != token_text_bool)
			semantic_error( 32, "Expected a boolean expression as the control condition of a 'do' loop." );
	
		check_for_expected_token( TOK_RPARENTHESIS, 240, "Expected ')' after boolean expression." );
	
		next_token();
	
		gen_code( OP_JMP_TRUE, ci_cint_to_string( label_num4 ), "" );

		check_for_expected_token( TOK_SEMICOLON, 241, "Expected ';' after a 'do' loop." );
		
		next_token();
	}


	void parse_repeat_statment( bool allow_void, int current_function_number, bool in_void_function )
	{
		int label_num1;
		int label_num2;
		string type1;
		
		next_token();
				
		label_num1 = glabel_num;
		
		glabel_num++;
		
		label_num2 = glabel_num;
		
		glabel_num++;
		
		type1 = parse_expr( current_function_number );

		type1 = push_var_if_necessary( type1 );
	
		if (type1 != token_text_int)
			semantic_error( 302, "Expected an int expression as the control condition of a 'repeat'." );
	
		gen_code( OP_JMP_LE_0_DONT_POP, ci_cint_to_string( label_num2 ), "" );
	
		gen_code( OP_LABEL, ci_cint_to_string( label_num1 ), "" );
	
		check_for_expected_token( TOK_TIMES, 303, "Expected 'times' after repeat expression." );
	
		next_token();
	
		parse_stat( current_function_number, in_void_function );
	
		gen_code( OP_ADD_CONST_TO_SP_ITEM, "", token_text_int );
	
		gruntime_data->ic[ic_pos_minus_1].add_sp_item = -1;
	
		gen_code( OP_JMP_LE_0_DONT_POP, ci_cint_to_string( label_num2 ), "" );
	
		gen_code( OP_JMP, ci_cint_to_string( label_num1 ), "" );
		
		gen_code( OP_LABEL, ci_cint_to_string( label_num2 ), "" );

		gen_code( OP_POP_DISCARD, "", "" );
		
		gruntime_data->ic[ic_pos_minus_1].discard_count = 1;
	}


	void parse_for_statement( bool allow_void, int current_function_number, bool in_void_function )
	{
		string ctrl_variable_name;
		string ctrl_variable_type;
		string type1;
		string type2;
		bool is_global;
//		bool fast_loop;
		bool control_variable_is_global;
		int label_num7; 
		int label_num8; 
		int step_size;
		
		step_size = 1;
		
//		fast_loop = false;
		
		next_token();
		
		check_for_expected_token( TOK_LPARENTHESIS, 23, "Expected '(' after 'for'." );
	
		next_token();
		
		check_for_expected_token( TOK_NAME, 24, "Expected a variable name after 'for'." );
			
		ctrl_variable_name = gcurr_token_text;
		
		if (ci_ssearch( gfor_control_variables, ":" + ctrl_variable_name + ":" ) != -1)
			semantic_error( 173, "Loop control variable '" + ctrl_variable_name + "' cannot be reused as a loop variable in an inner loop of the main loop." );
			
		gfor_control_variables = gfor_control_variables + ctrl_variable_name + ":";
		 
		check_var_declaration( current_function_number, ctrl_variable_type, ctrl_variable_name, is_global );
		
		type1 = ctrl_variable_type;
		
		if (gshow_warnings)
			set_var_as_accessed( current_function_number, is_global, ctrl_variable_name );
		
		if (! is_numeric_type( ctrl_variable_type ))
			semantic_error( 175, "Loop control variable must be a numeric type: '" + ctrl_variable_type + "'." );
		
		next_token();
		
		check_for_expected_token( TOK_ASSIGN, 25, "Expected a '=' after the 'for' variable name." );
	
		next_token();

			// pop the initial control variable value from the stack

		control_variable_is_global = is_global_variable( current_function_number, ctrl_variable_name );
							
		gen_code_push_var_address( current_function_number, ctrl_variable_name );
	
		type1 = parse_num_expr( current_function_number );		// initial control variable value

		type1 = push_var_if_necessary( type1 );

		if (! is_numeric_type( type1 ))
			syntax_error( 26, "Expected a numeric expression for 'from'." );
	
		gen_code( OP_POP_VAR, ctrl_variable_name, token_text_int );
		
		check_for_expected_token( TOK_TO, 27, "Expected a 'to' after the 'for' variable name: " + gcurr_token_text + "." );
		
		next_token();
	
		type1 = parse_num_expr( current_function_number );		// final control variable value

		type1 = push_var_if_necessary( type1 );
	
		if (! is_numeric_type( type1 ))
			syntax_error( 28, "Expected a numeric expression for 'to'." );
	
		label_num7 = glabel_num;
	
		if (gcurr_tok == TOK_STEP)
		{
			next_token();

			type2 = parse_num_expr( current_function_number );

			type2 = push_var_if_necessary( type2 );

			generate_type_conversion_if_necessary( type2, ctrl_variable_type, 1 );
			
//			next_token();
		}
		else
		{
			if (ctrl_variable_type == token_text_int)
				gen_code( OP_PUSH_CONST_INT, "1", token_text_int );
			else
			if (ctrl_variable_type == token_text_double)
				gen_code( OP_PUSH_CONST_DOUBLE, "1", token_text_double );
			else
			if (ctrl_variable_type == token_text_decimal)
				gen_code( OP_PUSH_CONST_DECIMAL, "1", token_text_decimal );
		}
	
		glabel_num++;
	
		label_num8 = glabel_num;
	
		glabel_num++;
	
		gen_code_push_var_address( current_function_number, ctrl_variable_name );

		gen_code( OP_LABEL, ci_cint_to_string( label_num7 ), "" );
	
			// jump to the end if loop finished
			
		gen_code( OP_FOR_LOOP_1, "", "" );
		
		if (ctrl_variable_type == token_text_int)
			gruntime_data->ic[ic_pos_minus_1].itype = FOR_LOOP_TYPE_INT;
		else
		if (ctrl_variable_type == token_text_double)
			gruntime_data->ic[ic_pos_minus_1].itype = FOR_LOOP_TYPE_DOUBLE;
		else
		if (ctrl_variable_type == token_text_decimal)
			gruntime_data->ic[ic_pos_minus_1].itype = FOR_LOOP_TYPE_DECIMAL;
		

		gruntime_data->ic[ic_pos_minus_1].jump_call_address = label_num8;
				
		check_for_expected_token( TOK_RPARENTHESIS, 29, "Expected a ')' after the 'for' statement." );
	
		next_token();
	
		parse_stat( current_function_number, in_void_function );
	
		if (gfor_control_variables == "")
			gfor_control_variables = ":" + ctrl_variable_name + ":";
		else
			gfor_control_variables = ci_sreplace( gfor_control_variables, ":" + ctrl_variable_name + ":", ":" );

			// increment variable and jump to the top
			
		gen_code( OP_FOR_LOOP_2, "", "" );

		if (ctrl_variable_type == token_text_int)
			gruntime_data->ic[ic_pos_minus_1].itype = FOR_LOOP_TYPE_INT;
		else
		if (ctrl_variable_type == token_text_double)
			gruntime_data->ic[ic_pos_minus_1].itype = FOR_LOOP_TYPE_DOUBLE;
		else
		if (ctrl_variable_type == token_text_decimal)
			gruntime_data->ic[ic_pos_minus_1].itype = FOR_LOOP_TYPE_DECIMAL;

		gruntime_data->ic[ic_pos_minus_1].jump_call_address = label_num7;

			
		gen_code( OP_LABEL, ci_cint_to_string( label_num8 ), "" );

		
		gen_code( OP_POP_DISCARD, "", "" );
		
		gruntime_data->ic[ic_pos_minus_1].discard_count = 3;
	}
	
	
	void parse_scan_statement( bool allow_void, int current_function_number, bool in_void_function )
	{
		int label_num1, label_num2;
		string function_name2;
		bool stack_value_is_address;
		bool has_function_call;
		string variable_name1, variable_name2;
		string object_type, type2;
		int function_being_called_function_number;
		bool is_global;
		string value;
		string type_curr;
		string object_type2;
		t_bst_function_number *nptr2;
		string function_name;
		bool found;
		
		next_token();

		check_for_expected_token( TOK_LPARENTHESIS, 24, "Expected a '(' after 'scan_list'." );

		next_token();

		check_for_expected_token( TOK_NAME, 24, "Expected a variable name after 'scan_list'." );
		
		variable_name2 = gcurr_token_text;

		check_var_declaration( current_function_number, type_curr, variable_name2, is_global );

		next_token();
		
		check_for_expected_token( TOK_IN, 23, "Expected 'in' after 'scan_list'." );
	
		next_token();

		check_for_expected_token( TOK_NAME, 24, "Expected a variable name after 'scan_list'." );
		
		variable_name1 = gcurr_token_text;

		check_var_declaration( current_function_number, type2, variable_name1, is_global );
		
		next_token();

		gen_code( OP_PUSH_SP_ONTO_ST2, "", "" );
		
		object_type2 = parse_aggregate_expression( allow_void, type2, current_function_number, variable_name1, stack_value_is_address, has_function_call );

		value = "1";

		if (gcurr_tok == TOK_COMMA)
		{
			next_token();
			
			if (gcurr_tok == TOK_BOOLEAN_CONSTANT)
			{
				if (ci_scaseieq( gcurr_token_text, token_text_true ))
					value = "1";
				else
					value = "0";
			}			
			else
				semantic_error( 387, "Expected a boolean constant at the end of a 'scan_list'." );
			
			next_token();
		}
		
		object_type = object_type2;
				
		check_scan_functions( object_type, type_curr, type2 );
				
		gen_code( OP_MOVE_SP_VALUE_TO_ST2, "", token_text_link + " " + token_text_to + " " + token_text_general );
				
		gen_code_push_var_address( current_function_number, variable_name2 );

		gen_code( OP_MOVE_SP_VALUE_TO_ST2, "", token_text_link + " " + token_text_to + " " + token_text_general );

		gen_code( OP_PUSH_CONST_BOOL, value, token_text_bool );

		gen_code( OP_SET_ST2_PTR_TO_SP, "", token_text_bool );
		
		function_name = object_type + "_first_item";
		
		nptr2 = (t_bst_function_number *) gbst_function_numbers.search_s( function_name, found );				 
		function_being_called_function_number = nptr2->function_number;

		if (function_being_called_function_number != -1)
		{
			function_name2 = ci_sreplace( function_name, ":", "_" );
			
			if (gruntime_data->gfunction_details[function_being_called_function_number].builtin_function)
			{
				gen_code( OP_CALL_SYSTEM_FUNCTION, function_name2, "" );
				
				gruntime_data->ic[ic_pos_minus_1].jump_call_address = gruntime_data->gfunction_details[function_being_called_function_number].builtin_function_number;
			}
			else
				gen_code( OP_CALL_USER_FUNCTION, function_name2, "" );
			
			gruntime_data->ic[ic_pos_minus_1].function_name = function_name2; 
			gruntime_data->ic[ic_pos_minus_1].function_being_called_number = function_being_called_function_number;
			gruntime_data->ic[ic_pos_minus_1].return_variable_size = gruntime_data->gfunction_details[function_being_called_function_number].return_variable_size;
	
			gruntime_data->ic[ic_pos_minus_1].push_flags = 0;
	
			label_num1 = glabel_num;
			
			glabel_num++;
			
			label_num2 = glabel_num;
			
			glabel_num++;
				
			gen_code( OP_JMP_NULL, ci_cint_to_string( label_num1 ), "" );
		}
				
		check_for_expected_token( TOK_RPARENTHESIS, 24, "Expected a ')' after 'scan_list'." );

		next_token();

		gen_code( OP_LABEL, ci_cint_to_string( label_num2 ), "" );
				
		parse_stat( current_function_number, in_void_function );
		
		gen_code( OP_PUSH_SP_ONTO_ST2, "", "" );

		gen_code_push_var_address( current_function_number, variable_name2 );

		gen_code( OP_MOVE_SP_VALUE_TO_ST2, "", token_text_link + " " + token_text_to + " " + token_text_general );

		gen_code( OP_PUSH_CONST_BOOL, value, token_text_bool );

		gen_code( OP_SET_ST2_PTR_TO_SP, "", token_text_bool );

		function_name = object_type + "_next_item";
		
		nptr2 = (t_bst_function_number *) gbst_function_numbers.search_s( function_name, found );				 
		function_being_called_function_number = nptr2->function_number;

		if (function_being_called_function_number != -1)
		{
			function_name2 = ci_sreplace( function_name, ":", "_" );
			
			if (gruntime_data->gfunction_details[function_being_called_function_number].builtin_function)
			{
				gen_code( OP_CALL_SYSTEM_FUNCTION, function_name2, "" );
				
				gruntime_data->ic[ic_pos_minus_1].jump_call_address = gruntime_data->gfunction_details[function_being_called_function_number].builtin_function_number;				
//				gruntime_data->ic[ic_pos_minus_1].result_var_type = "result"; 
//				gruntime_data->ic[ic_pos_minus_1].argument_count = 1;
			}				
			else
				gen_code( OP_CALL_USER_FUNCTION, function_name2, "" );
	
			gruntime_data->ic[ic_pos_minus_1].function_name = function_name2; 
			gruntime_data->ic[ic_pos_minus_1].function_being_called_number = function_being_called_function_number;
			gruntime_data->ic[ic_pos_minus_1].return_variable_size = gruntime_data->gfunction_details[function_being_called_function_number].return_variable_size;
	
//			gen_code( OP_POP_VAR, variable_name2, type2 );
			
//			gen_code_push_var_address( current_function_number, variable_name2 );
	
//			gen_code( OP_PUSH_VAR, variable_name2, link_type );
			
			gruntime_data->ic[ic_pos_minus_1].push_flags = 0;
					
			gen_code( OP_JMP_NULL, ci_cint_to_string( label_num1 ), "" );
	
			gen_code( OP_JMP, ci_cint_to_string( label_num2 ), "" );
					
			gen_code( OP_LABEL, ci_cint_to_string( label_num1 ), "" );
		}
	}


	void parse_scan_list_data_statement( bool allow_void, int current_function_number, bool in_void_function )
	{
		int label_num1, label_num2;
		string function_name2;
		bool stack_value_is_address;
		bool has_function_call;
		string variable_name1, variable_name2;
		string object_type, type2;
		int function_being_called_function_number;
		bool is_global;
		string value;
		string type_curr;
		string object_type2;
		t_bst_function_number *nptr2;
		string function_name;
		bool found;
		
		next_token();

		check_for_expected_token( TOK_LPARENTHESIS, 24, "Expected a '(' after 'scan_list_data'." );

		next_token();

		check_for_expected_token( TOK_NAME, 24, "Expected a variable name after 'scan_list_data'." );
		
		variable_name2 = gcurr_token_text;

		check_var_declaration( current_function_number, type_curr, variable_name2, is_global );

		next_token();
		
		check_for_expected_token( TOK_IN, 23, "Expected 'in' after 'scan_list_data'." );
	
		next_token();

		check_for_expected_token( TOK_NAME, 24, "Expected a variable name after 'scan_list_data'." );
		
		variable_name1 = gcurr_token_text;

		check_var_declaration( current_function_number, type2, variable_name1, is_global );
		
		next_token();


		gen_code( OP_PUSH_CONST_LINK, "", "" );

		gen_code( OP_PUSH_SP_ONTO_ST2, "", "" );

		
		object_type2 = parse_aggregate_expression( allow_void, type2, current_function_number, variable_name1, stack_value_is_address, has_function_call );

		value = "1";

		if (gcurr_tok == TOK_COMMA)
		{
			next_token();
			
			if (gcurr_tok == TOK_BOOLEAN_CONSTANT)
			{
				if (ci_scaseieq( gcurr_token_text, token_text_true ))
					value = "1";
				else
					value = "0";
			}			
			else
				semantic_error( 387, "Expected a boolean constant at the end of a 'scan_list_data'." );
			
			next_token();
		}
		
		object_type = object_type2;
				
		if (! is_link_type( type_curr ))
			semantic_error( 410, "Expected a link type for the first parameter to scan_list_data()." );
				
		check_scan_functions( object_type, type2 + "_item", type2 );
				
		gen_code( OP_MOVE_SP_VALUE_TO_ST2, "", token_text_link + " " + token_text_to + " " + token_text_general );
		
		gen_code( OP_SET_ST2_PTR_TO_SP_OFFSET, "", "" );

		gruntime_data->ic[ic_pos_minus_1].offset = -1;

		gen_code( OP_PUSH_CONST_BOOL, value, token_text_bool );

		gen_code( OP_SET_ST2_PTR_TO_SP, "", token_text_bool );
		
		function_name = object_type + "_first_item";
		
		nptr2 = (t_bst_function_number *) gbst_function_numbers.search_s( function_name, found );				 
		function_being_called_function_number = nptr2->function_number;

		if (function_being_called_function_number != -1)
		{
			function_name2 = ci_sreplace( function_name, ":", "_" );
			
			if (gruntime_data->gfunction_details[function_being_called_function_number].builtin_function)
			{
				gen_code( OP_CALL_SYSTEM_FUNCTION, function_name2, "" );
				
				gruntime_data->ic[ic_pos_minus_1].jump_call_address = gruntime_data->gfunction_details[function_being_called_function_number].builtin_function_number;
			}
			else
				gen_code( OP_CALL_USER_FUNCTION, function_name2, "" );
			
			gruntime_data->ic[ic_pos_minus_1].function_name = function_name2; 
			gruntime_data->ic[ic_pos_minus_1].function_being_called_number = function_being_called_function_number;
			gruntime_data->ic[ic_pos_minus_1].return_variable_size = gruntime_data->gfunction_details[function_being_called_function_number].return_variable_size;
	
			gruntime_data->ic[ic_pos_minus_1].push_flags = 0;
	
			label_num1 = glabel_num;
			
			glabel_num++;
			
			label_num2 = glabel_num;
			
			glabel_num++;
				
			gen_code( OP_JMP_NULL, ci_cint_to_string( label_num1 ), "" );
		}
				
		check_for_expected_token( TOK_RPARENTHESIS, 24, "Expected a ')' after 'scan_list_data'." );

		next_token();


		gen_code( OP_LABEL, ci_cint_to_string( label_num2 ), "" );

		gen_code_push_var_address( current_function_number, variable_name2 );


		gen_code( OP_PUSH_ADDR_SP_REL, "", "" );

		gruntime_data->ic[ic_pos_minus_1].offset = -2;


		gen_code( OP_PREP_FOR_MEMBER_FUNC_CALL, "", "" );

		function_name = "object:" + object_type + "_item:get_data_ptr";
		
		nptr2 = (t_bst_function_number *) gbst_function_numbers.search_s( function_name, found );
			
		if (! found)
		{
			cout << "Function " + function_name + " not found.";
			exit(1);
		}			
		 
		function_being_called_function_number = nptr2->function_number;

		if (function_being_called_function_number != -1)
		{
			function_name2 = ci_sreplace( function_name, ":", "_" );
			
			if (gruntime_data->gfunction_details[function_being_called_function_number].builtin_function)
			{
				gen_code( OP_CALL_SYSTEM_FUNCTION, function_name2, "" );
				
				gruntime_data->ic[ic_pos_minus_1].jump_call_address = gruntime_data->gfunction_details[function_being_called_function_number].builtin_function_number;
			}
			else
				gen_code( OP_CALL_USER_FUNCTION, function_name2, "" );
			
			gruntime_data->ic[ic_pos_minus_1].function_name = function_name2; 
			gruntime_data->ic[ic_pos_minus_1].function_being_called_number = function_being_called_function_number;
			gruntime_data->ic[ic_pos_minus_1].return_variable_size = gruntime_data->gfunction_details[function_being_called_function_number].return_variable_size;
		}

		gen_code( OP_POP_VAR, "", "" );

		gruntime_data->ic[ic_pos_minus_1].size = 1;

				
		parse_stat( current_function_number, in_void_function );
		
		gen_code( OP_PUSH_SP_ONTO_ST2, "", "" );


		gen_code( OP_SET_ST2_PTR_TO_SP_OFFSET, "", "" );

		gruntime_data->ic[ic_pos_minus_1].offset = -1;


		gen_code( OP_PUSH_CONST_BOOL, value, token_text_bool );

		gen_code( OP_SET_ST2_PTR_TO_SP, "", token_text_bool );

		function_name = object_type + "_next_item";
		
		nptr2 = (t_bst_function_number *) gbst_function_numbers.search_s( function_name, found );				 
		function_being_called_function_number = nptr2->function_number;


		if (function_being_called_function_number != -1)
		{
			function_name2 = ci_sreplace( function_name, ":", "_" );
			
			if (gruntime_data->gfunction_details[function_being_called_function_number].builtin_function)
			{
				gen_code( OP_CALL_SYSTEM_FUNCTION, function_name2, "" );
				
				gruntime_data->ic[ic_pos_minus_1].jump_call_address = gruntime_data->gfunction_details[function_being_called_function_number].builtin_function_number;				
//				gruntime_data->ic[ic_pos_minus_1].result_var_type = "result"; 
//				gruntime_data->ic[ic_pos_minus_1].argument_count = 1;
			}				
			else
				gen_code( OP_CALL_USER_FUNCTION, function_name2, "" );
	
			gruntime_data->ic[ic_pos_minus_1].function_name = function_name2; 
			gruntime_data->ic[ic_pos_minus_1].function_being_called_number = function_being_called_function_number;
			gruntime_data->ic[ic_pos_minus_1].return_variable_size = gruntime_data->gfunction_details[function_being_called_function_number].return_variable_size;
			
			gruntime_data->ic[ic_pos_minus_1].push_flags = 0;
					
			gen_code( OP_JMP_NULL, ci_cint_to_string( label_num1 ), "" );
	
			gen_code( OP_JMP, ci_cint_to_string( label_num2 ), "" );
					
			gen_code( OP_LABEL, ci_cint_to_string( label_num1 ), "" );
		}

		gen_code( OP_POP_DISCARD, "", "" );
	
		gruntime_data->ic[ic_pos_minus_1].discard_count = 1;
	}


	void parse_scan_list_keys_statement( bool allow_void, int current_function_number, bool in_void_function )
	{
		int label_num1, label_num2;
		string function_name2;
		bool stack_value_is_address;
		bool has_function_call;
		string variable_name1, variable_name2;
		string object_type, type2;
		int function_being_called_function_number;
		bool is_global;
		string value;
		string type_curr;
		string object_type2;
		t_bst_function_number *nptr2;
		string function_name;
		bool found;
		
		next_token();

		check_for_expected_token( TOK_LPARENTHESIS, 24, "Expected a '(' after 'scan_list_keys'." );

		next_token();

		check_for_expected_token( TOK_NAME, 24, "Expected a variable name after 'scan_list_keys'." );
		
		variable_name2 = gcurr_token_text;

		check_var_declaration( current_function_number, type_curr, variable_name2, is_global );

		next_token();
		
		check_for_expected_token( TOK_IN, 23, "Expected 'in' after 'scan_list_keys'." );
	
		next_token();

		check_for_expected_token( TOK_NAME, 24, "Expected a variable name after 'scan_list_keys'." );
		
		variable_name1 = gcurr_token_text;

		check_var_declaration( current_function_number, type2, variable_name1, is_global );
		
		next_token();


		gen_code( OP_PUSH_CONST_LINK, "", "" );

		gen_code( OP_PUSH_SP_ONTO_ST2, "", "" );

		
		object_type2 = parse_aggregate_expression( allow_void, type2, current_function_number, variable_name1, stack_value_is_address, has_function_call );

		value = "1";

		if (gcurr_tok == TOK_COMMA)
		{
			next_token();
			
			if (gcurr_tok == TOK_BOOLEAN_CONSTANT)
			{
				if (ci_scaseieq( gcurr_token_text, token_text_true ))
					value = "1";
				else
					value = "0";
			}			
			else
				semantic_error( 387, "Expected a boolean constant at the end of a 'scan_list_keys'." );
			
			next_token();
		}
		
		object_type = object_type2;
				
		if (type_curr != token_text_string && type_curr != token_text_int)
			semantic_error( 410, "Expected a '" + token_text_string + "' or '" + token_text_int + "' type for the first parameter to scan_list_keys()." );
				
		check_scan_functions( object_type, type2 + "_item", type2 );
				
		gen_code( OP_MOVE_SP_VALUE_TO_ST2, "", token_text_link + " " + token_text_to + " " + token_text_general );
		
		gen_code( OP_SET_ST2_PTR_TO_SP_OFFSET, "", "" );

		gruntime_data->ic[ic_pos_minus_1].offset = -1;

		gen_code( OP_PUSH_CONST_BOOL, value, token_text_bool );

		gen_code( OP_SET_ST2_PTR_TO_SP, "", token_text_bool );
		
		function_name = object_type + "_first_item";
		
		nptr2 = (t_bst_function_number *) gbst_function_numbers.search_s( function_name, found );				 
		function_being_called_function_number = nptr2->function_number;

		if (function_being_called_function_number != -1)
		{
			function_name2 = ci_sreplace( function_name, ":", "_" );
			
			if (gruntime_data->gfunction_details[function_being_called_function_number].builtin_function)
			{
				gen_code( OP_CALL_SYSTEM_FUNCTION, function_name2, "" );
				
				gruntime_data->ic[ic_pos_minus_1].jump_call_address = gruntime_data->gfunction_details[function_being_called_function_number].builtin_function_number;
			}
			else
				gen_code( OP_CALL_USER_FUNCTION, function_name2, "" );
			
			gruntime_data->ic[ic_pos_minus_1].function_name = function_name2; 
			gruntime_data->ic[ic_pos_minus_1].function_being_called_number = function_being_called_function_number;
			gruntime_data->ic[ic_pos_minus_1].return_variable_size = gruntime_data->gfunction_details[function_being_called_function_number].return_variable_size;
	
			gruntime_data->ic[ic_pos_minus_1].push_flags = 0;
	
			label_num1 = glabel_num;
			
			glabel_num++;
			
			label_num2 = glabel_num;
			
			glabel_num++;
				
			gen_code( OP_JMP_NULL, ci_cint_to_string( label_num1 ), "" );
		}
				
		check_for_expected_token( TOK_RPARENTHESIS, 24, "Expected a ')' after 'scan_list_keys'." );

		next_token();


		gen_code( OP_LABEL, ci_cint_to_string( label_num2 ), "" );

		gen_code_push_var_address( current_function_number, variable_name2 );


		gen_code( OP_PUSH_ADDR_SP_REL, "", "" );

		gruntime_data->ic[ic_pos_minus_1].offset = -2;


		gen_code( OP_PREP_FOR_MEMBER_FUNC_CALL, "", "" );

		
		if (type_curr == token_text_string)
			function_name = "object:" + object_type + "_item:get_key_s";
		else
			function_name = "object:" + object_type + "_item:get_key_i";
		
		nptr2 = (t_bst_function_number *) gbst_function_numbers.search_s( function_name, found );
			
		if (! found)
		{
			cout << "Function " + function_name + " not found.";
			exit(1);
		}			
		 
		function_being_called_function_number = nptr2->function_number;

		if (function_being_called_function_number != -1)
		{
			function_name2 = ci_sreplace( function_name, ":", "_" );
			
			if (gruntime_data->gfunction_details[function_being_called_function_number].builtin_function)
			{
				gen_code( OP_CALL_SYSTEM_FUNCTION, function_name2, "" );
				
				gruntime_data->ic[ic_pos_minus_1].jump_call_address = gruntime_data->gfunction_details[function_being_called_function_number].builtin_function_number;
			}
			else
				gen_code( OP_CALL_USER_FUNCTION, function_name2, "" );
			
			gruntime_data->ic[ic_pos_minus_1].function_name = function_name2; 
			gruntime_data->ic[ic_pos_minus_1].function_being_called_number = function_being_called_function_number;
			gruntime_data->ic[ic_pos_minus_1].return_variable_size = gruntime_data->gfunction_details[function_being_called_function_number].return_variable_size;
		}

		gen_code( OP_POP_VAR, "", "" );

		gruntime_data->ic[ic_pos_minus_1].size = 1;

				
		parse_stat( current_function_number, in_void_function );
		
		gen_code( OP_PUSH_SP_ONTO_ST2, "", "" );


		gen_code( OP_SET_ST2_PTR_TO_SP_OFFSET, "", "" );

		gruntime_data->ic[ic_pos_minus_1].offset = -1;


		gen_code( OP_PUSH_CONST_BOOL, value, token_text_bool );

		gen_code( OP_SET_ST2_PTR_TO_SP, "", token_text_bool );

		function_name = object_type + "_next_item";
		
		nptr2 = (t_bst_function_number *) gbst_function_numbers.search_s( function_name, found );				 
		function_being_called_function_number = nptr2->function_number;


		if (function_being_called_function_number != -1)
		{
			function_name2 = ci_sreplace( function_name, ":", "_" );
			
			if (gruntime_data->gfunction_details[function_being_called_function_number].builtin_function)
			{
				gen_code( OP_CALL_SYSTEM_FUNCTION, function_name2, "" );
				
				gruntime_data->ic[ic_pos_minus_1].jump_call_address = gruntime_data->gfunction_details[function_being_called_function_number].builtin_function_number;				
//				gruntime_data->ic[ic_pos_minus_1].result_var_type = "result"; 
//				gruntime_data->ic[ic_pos_minus_1].argument_count = 1;
			}				
			else
				gen_code( OP_CALL_USER_FUNCTION, function_name2, "" );
	
			gruntime_data->ic[ic_pos_minus_1].function_name = function_name2; 
			gruntime_data->ic[ic_pos_minus_1].function_being_called_number = function_being_called_function_number;
			gruntime_data->ic[ic_pos_minus_1].return_variable_size = gruntime_data->gfunction_details[function_being_called_function_number].return_variable_size;
			
			gruntime_data->ic[ic_pos_minus_1].push_flags = 0;
					
			gen_code( OP_JMP_NULL, ci_cint_to_string( label_num1 ), "" );
	
			gen_code( OP_JMP, ci_cint_to_string( label_num2 ), "" );
					
			gen_code( OP_LABEL, ci_cint_to_string( label_num1 ), "" );
		}

		gen_code( OP_POP_DISCARD, "", "" );
	
		gruntime_data->ic[ic_pos_minus_1].discard_count = 1;
	}

/*
 * variable_name2 		result1
 * variable_name3		data
 * variable_name5		cxn
 * variable_name4		i
 */
 
 
	void parse_scan_db_statement( bool allow_void, int current_function_number, bool in_void_function )
	{
		int label_num1, label_num2;
		string variable_name2;
		string variable_name3;
		string variable_name4;
		string variable_name5;
		string function_name;
		string function_name2;
		int function_being_called_function_number;
		bool is_global;
		string type1;
		t_bst_function_number *nptr2;
		bool found;
		
		next_token();

		check_for_expected_token( TOK_LPARENTHESIS, 354, "Expected a '(' after 'scan_db'." );

		next_token();

		check_for_expected_token( TOK_NAME, 355, "Expected a variable name after 'scan_db'." );
			
		variable_name2 = gcurr_token_text;

		check_var_declaration( current_function_number, type1, variable_name2, is_global );

		set_var_as_accessed( current_function_number, is_global, variable_name2 );

		if (type1 != "db_query_result")
			semantic_error( 359, "Invalid type in parameter 1 to scan_db(): " + type1 );

		gen_code_push_var_address( current_function_number, variable_name2 );

		next_token();

		check_for_expected_token( TOK_COMMA, 357, "Expected a ',' after 'scan_db'." );
		
		next_token();

		gen_code( OP_PUSH_SP_ONTO_ST2, "", "" );
		
		type1 = parse_expr( current_function_number );

		type1 = push_var_if_necessary( type1 );

		gen_code( OP_SET_ST2_PTR_TO_SP, "", type1 );
		
		if (type1 != "string")
			semantic_error( 359, "Invalid type in parameter 2 to scan_db(): " + type1 );

		check_for_expected_token( TOK_COMMA, 360, "Expected a ',' after 'scan_db'." );

		next_token();

		check_for_expected_token( TOK_NAME, 361, "Expected a variable name after 'scan_db'." );
			
		variable_name3 = gcurr_token_text;
		
		check_var_declaration( current_function_number, type1, variable_name3, is_global );

		set_var_as_accessed( current_function_number, is_global, variable_name3 );

		if (type1 != "db_row")
			semantic_error( 362, "Invalid type in parameter 3 to scan_db(): " + type1 );

		next_token();

		check_for_expected_token( TOK_COMMA, 363, "Expected a ',' after 'scan_db'." );
			
		next_token();

		check_for_expected_token( TOK_NAME, 364, "Expected a variable name after 'scan_db'." );
			
		variable_name5 = gcurr_token_text;
		
		check_var_declaration( current_function_number, type1, variable_name5, is_global );

		set_var_as_accessed( current_function_number, is_global, variable_name5 );

		if (type1 != "db_connection")
			semantic_error( 365, "Invalid type in parameter 4 to scan_db(): " + type1 );
			
		next_token();

		if (gcurr_tok == TOK_RPARENTHESIS)
		{
			variable_name4 = "+sys_var" + sys_var_number;
			
			sys_var_number++;
 
			add_local_variable( current_function_number, variable_name4, token_text_int, 1, true, false, 0, 0, 0, "" );
			
			set_var_as_accessed( current_function_number, false, variable_name4 );
		}	
		else
		{	
			check_for_expected_token( TOK_COMMA, 366, "Expected a ',' after 'scan_db'." );

			next_token();

			check_for_expected_token( TOK_NAME, 367, "Expected a variable name after 'scan_db'." );
				
			variable_name4 = gcurr_token_text;
	
			check_var_declaration( current_function_number, type1, variable_name4, is_global );
			
			set_var_as_accessed( current_function_number, is_global, variable_name4 );
			
			if (type1 != token_text_int)
				semantic_error( 368, "Invalid type in parameter 5 to scan_db(): " + type1 );
	
			if (ci_ssearch( gfor_control_variables, ":" + variable_name4 + ":" ) != -1)
				semantic_error( 173, "scan_db control variable '" + variable_name4 + "' cannot be reused as a loop variable in an inner loop of the main loop." );
			
			gfor_control_variables = gfor_control_variables + variable_name4 + ":";
			
			next_token();
		}
		
		gen_code_push_var_address( current_function_number, variable_name4 );

		gen_code( OP_PUSH_CONST_INT, "0", token_text_int );
						
		gen_code( OP_POP_VAR, variable_name4, token_text_int );


		gen_code_push_var_address( current_function_number, variable_name5 );
		
		gen_code( OP_MOVE_SP_VALUE_TO_ST2, "", "" );
		
		function_name = "db_run_query";
		
		nptr2 = (t_bst_function_number *) gbst_function_numbers.search_s( function_name, found );				 
		function_being_called_function_number = nptr2->function_number;

		if (function_being_called_function_number != -1)
		{
			function_name2 = ci_sreplace( function_name, ":", "_" );
			
			gen_code( OP_CALL_SYSTEM_FUNCTION, function_name2, "" );
			
			gruntime_data->ic[ic_pos_minus_1].jump_call_address = gruntime_data->gfunction_details[function_being_called_function_number].builtin_function_number;
			gruntime_data->ic[ic_pos_minus_1].this_function_number = current_function_number;
			gruntime_data->ic[ic_pos_minus_1].function_name = function_name2; 
			gruntime_data->ic[ic_pos_minus_1].return_variable_size = gruntime_data->gfunction_details[function_being_called_function_number].return_variable_size;
//			gruntime_data->ic[ic_pos_minus_1].result_var_type = "result"; 
			gruntime_data->ic[ic_pos_minus_1].function_being_called_number = function_being_called_function_number;
//			gruntime_data->ic[ic_pos_minus_1].argument_count = 2;
			
			gen_code( OP_POP_VAR, variable_name2, "db_query_result" );

			gen_code( OP_PUSH_SP_ONTO_ST2, "", "" );
			
			gen_code_push_var_address( current_function_number, variable_name2 );

			gen_code( OP_MOVE_SP_VALUE_TO_ST2, "", "" );
	
			gen_code_push_var_address( current_function_number, variable_name5 );

			gen_code( OP_MOVE_SP_VALUE_TO_ST2, "", "" );
			
			function_name = "db_query_num_rows";
			
			nptr2 = (t_bst_function_number *) gbst_function_numbers.search_s( function_name, found );				 
			function_being_called_function_number = nptr2->function_number;
	
			if (function_being_called_function_number != -1)
			{
				function_name2 = ci_sreplace( function_name, ":", "_" );
				
				gen_code( OP_CALL_SYSTEM_FUNCTION, function_name2, "" );
				
				gruntime_data->ic[ic_pos_minus_1].jump_call_address = gruntime_data->gfunction_details[function_being_called_function_number].builtin_function_number;
				gruntime_data->ic[ic_pos_minus_1].this_function_number = current_function_number;
				gruntime_data->ic[ic_pos_minus_1].function_name = function_name2; 
				gruntime_data->ic[ic_pos_minus_1].return_variable_size = gruntime_data->gfunction_details[function_being_called_function_number].return_variable_size;
//				gruntime_data->ic[ic_pos_minus_1].result_var_type = "result"; 
				gruntime_data->ic[ic_pos_minus_1].function_being_called_number = function_being_called_function_number;
//				gruntime_data->ic[ic_pos_minus_1].argument_count = 2;
		
		
				label_num2 = glabel_num;

				gen_code( OP_LABEL, ci_cint_to_string( label_num2 ), "" );
			
				glabel_num++;
					
					
				gen_code_push_var_address( current_function_number, variable_name4 );
		
				gen_code( OP_PUSH_VAR, variable_name4, token_text_int );

				gruntime_data->ic[ic_pos_minus_1].push_flags = 0;
		
		
				label_num1 = glabel_num;
			
				glabel_num++;
				
				gen_code( OP_POP_JMP_LE, ci_cint_to_string( label_num1 ), "" );
		
				
				gen_code_push_var_address( current_function_number, variable_name3 );

				gen_code( OP_PUSH_SP_ONTO_ST2, "", "" );
					
				gen_code_push_var_address( current_function_number, variable_name2 );

				gen_code( OP_MOVE_SP_VALUE_TO_ST2, "", "" );
		
				gruntime_data->ic[ic_pos_minus_1].push_flags = 0;
		
		
				gen_code_push_var_address( current_function_number, variable_name5 );
	
				gen_code( OP_MOVE_SP_VALUE_TO_ST2, "", "" );
		
				gruntime_data->ic[ic_pos_minus_1].push_flags = 0;
	
				
				function_name = "db_get_row";
				
				nptr2 = (t_bst_function_number *) gbst_function_numbers.search_s( function_name, found );				 
				function_being_called_function_number = nptr2->function_number;
		
				if (function_being_called_function_number != -1)
				{
					gen_code( OP_CALL_SYSTEM_FUNCTION, ci_sreplace( function_name, ":", "_" ), "" );
					
					gruntime_data->ic[ic_pos_minus_1].jump_call_address = gruntime_data->gfunction_details[function_being_called_function_number].builtin_function_number;
					gruntime_data->ic[ic_pos_minus_1].this_function_number = current_function_number;
					gruntime_data->ic[ic_pos_minus_1].function_name = ci_sreplace( function_name, ":", "_" ); 
					gruntime_data->ic[ic_pos_minus_1].return_variable_size = gruntime_data->gfunction_details[function_being_called_function_number].return_variable_size;
//					gruntime_data->ic[ic_pos_minus_1].result_var_type = "result"; 
					gruntime_data->ic[ic_pos_minus_1].function_being_called_number = function_being_called_function_number;
//					gruntime_data->ic[ic_pos_minus_1].argument_count = 2;
		
					gen_code( OP_POP_VAR, variable_name3, "db_row" );
				
					check_for_expected_token( TOK_RPARENTHESIS, 24, "Expected a ')' after 'scan_db'." );
			
					next_token();
							
					parse_stat( current_function_number, in_void_function );

					if (gfor_control_variables == "")
						gfor_control_variables = ":" + variable_name4 + ":";
					else
						gfor_control_variables = ci_sreplace( gfor_control_variables, ":" + variable_name4 + ":", ":" );


					gen_code_push_var_address( current_function_number, variable_name4 );

					gen_code( OP_VAR_INC, variable_name4, "" );


					gen_code( OP_JMP, ci_cint_to_string( label_num2 ), "" );
					
					gen_code( OP_LABEL, ci_cint_to_string( label_num1 ), "" );
					
					gen_code( OP_POP_DISCARD, "", "" );
		
					gruntime_data->ic[ic_pos_minus_1].discard_count = 1;
				}
			}
		}
	}

	void parse_switch_statment( bool allow_void, int current_function_number, bool in_void_function )
	{
		string switch_expr_type;
		int label_end_of_switch;
		int label_this_case_starts;
		bool is_single_condition;
		string type1;
		int next_case;
		
		next_token();

		check_for_expected_token( TOK_LPARENTHESIS, 18, "Expected '(' after a switch." );

		next_token();

		switch_expr_type = parse_expr( current_function_number );
		
		switch_expr_type = push_var_if_necessary( switch_expr_type );
		
		if (! is_simple_data_type( switch_expr_type ))
			semantic_error( 234, "Switch expression must be a simple data type." );
		
		check_for_expected_token( TOK_RPARENTHESIS, 18, "Expected ')' after a switch condition." );

		next_token();
		
		check_for_expected_token( TOK_LBRACE, 18, "Expected '{' after a switch condition." );
		
		next_token();
		
		label_end_of_switch = glabel_num;
	
		glabel_num++;
		
		while (gcurr_tok == TOK_CASE)
		{
			next_token();
		
			label_this_case_starts = glabel_num;
	
			glabel_num++;
			
			next_case = glabel_num;
	
			glabel_num++;
			
			is_single_condition = true;
			
			do
			{
				if (gcurr_tok == TOK_COMMA)
					next_token();
				
				type1 = parse_expr( current_function_number );
	
				type1 = push_var_if_necessary( type1 );
	
				if (! ((switch_expr_type == type1) || (is_numeric_type( switch_expr_type ) && is_numeric_type( type1 ))))
					semantic_error( 235, "Switch expression and case expression must be the same type or both be numeric." );
				
				generate_type_conversion_if_necessary( type1, switch_expr_type, 1 );

				if (gcurr_tok == TOK_COMMA)
					is_single_condition = false;
	
				if (is_single_condition)
				{
					if (type1 == token_text_int)		gen_code( OP_NEQ_INT_JMP, 		"", "" );
					else
					if (type1 == token_text_double)		gen_code( OP_NEQ_DOUBLE_JMP, 	"", "" );
					else
					if (type1 == token_text_decimal)	gen_code( OP_NEQ_DECIMAL_JMP, 	"", "" );
					else
					if (type1 == token_text_bool)		gen_code( OP_NEQ_BOOL_JMP, 		"", "" );
					else
					if (type1 == token_text_binary)		gen_code( OP_NEQ_STRING_JMP, 	"", "" );
					else
					if (type1 == token_text_string ||
						type1 == token_text_date ||
						type1 == token_text_time ||
						type1 == token_text_datetime)
														gen_code( OP_NEQ_STRING_JMP, 	"", "" );
														
					gruntime_data->ic[ic_pos_minus_1].jump_call_address = next_case;
				}
				else
				{
					if (type1 == token_text_int)		gen_code( OP_EQ_INT_JMP, 		"", "" );
					else
					if (type1 == token_text_double)		gen_code( OP_EQ_DOUBLE_JMP, 	"", "" );
					else
					if (type1 == token_text_decimal)	gen_code( OP_EQ_DECIMAL_JMP, 	"", "" );
					else
					if (type1 == token_text_bool)		gen_code( OP_EQ_BOOL_JMP, 		"", "" );
					else
					if (type1 == token_text_binary)		gen_code( OP_EQ_STRING_JMP,		"", "" );
					else
					if (type1 == token_text_string ||
						type1 == token_text_date ||
						type1 == token_text_time ||
						type1 == token_text_datetime)
						 								gen_code( OP_EQ_STRING_JMP, 	"", "" );
														
					gruntime_data->ic[ic_pos_minus_1].jump_call_address = label_this_case_starts;
				}
			}
			while (gcurr_tok == TOK_COMMA);
			
			check_for_expected_token( TOK_COLON, 18, "Expected ':' after 'case' conditions." );

			next_token();
	
			if (! is_single_condition)
			{
				gen_code( OP_JMP, ci_cint_to_string( next_case ), "" );
	
				gen_code( OP_LABEL, ci_cint_to_string( label_this_case_starts ), "" );
			}
			
			parse_stat( current_function_number, in_void_function );
			
			gen_code( OP_JMP, ci_cint_to_string( label_end_of_switch ), "" );

			gen_code( OP_LABEL, ci_cint_to_string( next_case ), "" );
		}
		
		if (gcurr_tok == TOK_DEFAULT)
		{
			next_token();

			check_for_expected_token( TOK_COLON, 18, "Expected ':' after 'default'." );
			
			next_token();
			
			parse_stat( current_function_number, in_void_function );
		}
		
		gen_code( OP_LABEL, ci_cint_to_string( label_end_of_switch ), "" );
								
		gen_code( OP_POP_DISCARD, "", "" );
		
		gruntime_data->ic[ic_pos_minus_1].discard_count = 1;
		
		check_for_expected_token( TOK_RBRACE, 236, "Expected '}' after a switch statement." );
		
		next_token();
	}
		


	void parse_if_statment( bool allow_void, int current_function_number, bool in_void_function )
	{
		string type1;
		int label_num1;
		int label_num2;
		
		next_token();
	
		check_for_expected_token( TOK_LPARENTHESIS, 18, "Expected '(' after an if." );
	
		next_token();
		
		type1 = parse_expr( current_function_number );

		type1 = push_var_if_necessary( type1 );
	
		if (type1 != token_text_bool)
			semantic_error( 19, "Expected a boolean expression as the control condition of an 'if'." );
	
		label_num1 = glabel_num;
		
		gen_code( OP_JMP_FALSE, ci_cint_to_string( label_num1 ), "" );
	
		glabel_num++;
	
		check_for_expected_token( TOK_RPARENTHESIS, 20, "Expected ')' after an if expression." );
	
		next_token();
	
		parse_stat( current_function_number, in_void_function );
	
		if (gcurr_tok == TOK_ELSE)
		{
			label_num2 = glabel_num;
						
			gen_code( OP_JMP, ci_cint_to_string( label_num2 ), "" );
			
			gen_code( OP_LABEL, ci_cint_to_string( label_num1 ), "" );
			
			glabel_num++;
						
			next_token();
	
			parse_stat( current_function_number, in_void_function );

			gen_code( OP_LABEL, ci_cint_to_string( label_num2 ), "" );
		}
		else	
			gen_code( OP_LABEL, ci_cint_to_string( label_num1 ), "" );
	}


	string parse_data_type( bool allow_void, bool in_function_declaration, int& size, bool allow_variable_arrays, string& type_name, bool is_var_declaration )
	{
		string type1, type_name2;
		int total_elements;
		string underlying_type;
		int num_items;
		int num_dimensions;
		int new_function_number;
		int current_function_number;
		string type2;
		int value;
		int object_number;
		int offset;
		int total_size;
		string item_type;
		int i;
				
		size = 1;
				
		if (gcurr_tok == TOK_VOID)
		{
			type1 = token_text_void;
			
			if (! allow_void)
				semantic_error( 247, "Keyword 'void' not allowed in this context." );

			next_token();
		}
		else
		{
			type1 = "";
			
			if (gcurr_tok == TOK_LINK)
			{
				type1 = token_text_link;

				next_token();

				check_for_expected_token( TOK_TO, 288, "Expected 'to'." );

				type1 = type1 + " " + token_text_to + " ";

				next_token();
				
				if (gcurr_token_text == token_text_general)
				{
					type1 = type1 + token_text_general;
					
					next_token();
				}
				else
				{
					type2 = parse_data_type( allow_void, in_function_declaration, size, allow_variable_arrays, type_name2, is_var_declaration );
				
					type1 = type1 + type2;
				}		
			}
			else
			if (gcurr_tok == TOK_RESIZABLE)
			{
				next_token();
				
				check_for_expected_token( TOK_ARRAY, 281, "Expected 'array'." );
				
				
				next_token();
				
				check_for_expected_token( TOK_OF, 282, "Expected 'of'." );


				next_token();

				type2 = parse_data_type( allow_void, in_function_declaration, size, allow_variable_arrays, type_name2, is_var_declaration );
				
				type1 = token_text_resizable + " " + token_text_array + " " + token_text_of + " " + type2;		
			}
			else				
			if (gcurr_tok == TOK_ARRAY)
			{
				next_token();
										
				type1 = token_text_array + " ";
				
				total_elements = 0;
					
				check_for_expected_token( TOK_LBRACKET, 66, "Expected a '['" );
	
				type1 = type1 + "[";
	
				num_dimensions = 0;
	
				do
				{								
					next_token();

					value = (long int) parse_const_numerical_expr( token_text_int );

					if (value == 0)
						semantic_error( 399, "Array index size cannot be zero." );

					if (value < 0)
						semantic_error( 401, "Array index size cannot be negative." );

					if (total_elements == 0)
						total_elements = value;
					else
						total_elements = total_elements * value;

					type1 = type1 + " " + to_string( value );

					num_dimensions++;
					
					if (num_dimensions >= MAX_NUM_ARRAY_INDEXES)
						semantic_error( 340, "Too many array indicies." );
	
				}
				while (gcurr_tok == TOK_COMMA);
				
				if (gcurr_tok != TOK_RBRACKET)
					syntax_error( 69, "Expected ']'" );
	
				type1 = type1 + " ]";
				
				next_token();
	
				check_for_expected_token( TOK_OF, 275, "Expected 'of'." );

				next_token();

				type1 = type1 + " " + token_text_of + " ";

				type2 = parse_data_type( allow_void, in_function_declaration, size, allow_variable_arrays, type_name2, is_var_declaration );
				
				type1 = type1 + type2;		
	
				size = get_type_total_size( type2 ) * total_elements;
			}
			else
			if (gcurr_tok == TOK_OBJECT)
			{
				object_number = gruntime_data->gnum_object_types;
								
				gruntime_data->gnum_object_types++;
				
				gruntime_data->gobject_types[object_number].num_items = 0;
						
				next_token();
	
				check_for_expected_token( TOK_LBRACE, 127, "Expected '{' after 'object': " + gcurr_token_text );
			
				next_token();
				
					
				num_items = 0;
				
				offset = 0;
				
				total_size = 0;
				
				while (gcurr_tok != TOK_RBRACE && gcurr_tok != TOK_EOF)
				{
					if (gcurr_tok == TOK_FUNCTION)
					{
						gin_function = true;
		
						new_function_number = parse_function_definition( current_function_number, false, 0, true, type_name );
						
						if (gruntime_data->gfunction_details[new_function_number].return_variable_type == type_name)
							semantic_error( 402, "An member function cannot return the same type object as it resides in.: '" + type_name + "'" );
						
						gin_function = false;
					}
					else
					{
						item_type = parse_data_type( false, false, size, false, type_name2, is_var_declaration );
						
						size = get_type_total_size( item_type );
						
						if (item_type == type_name)
						{
							semantic_error( 401, "An object can contain a link to itself but not an actual instance of itself: '" + type_name + "'" );
						
							while (gcurr_tok != TOK_SEMICOLON and gcurr_tok != TOK_EOF)
								next_token();
						}
						else
						{						
							while (gcurr_tok != TOK_SEMICOLON && gcurr_tok != TOK_EOF)
							{
								if (is_reserved_word( gcurr_token_text ))
									semantic_error( 337, "Cannot use a reserved word as a type member name." );
								
								for (i=0; i <= num_items - 1; i++)
								{
									if (gruntime_data->gobject_types[object_number].item_name[i] == gcurr_token_text)
										semantic_error( 305, "Variable '" + gcurr_token_text + "' has been added to type twice." );
								}
			
								if (is_type_name( gcurr_token_text ))
									semantic_error( 334, "Cannot define a type member with the name '" + gcurr_token_text + "' because there is a type with this name." );
			
								if (is_const_name( gcurr_token_text ))
									semantic_error( 335, "Cannot define a type member with the name '" + gcurr_token_text + "' because there is a constant defined with that name." );
			
								if (is_function_name( gcurr_token_text ))
									semantic_error( 336, "Cannot define a type member with the name '" + gcurr_token_text + "' because there is a function defined with that name." );
			
								gruntime_data->gobject_types[object_number].item_type[num_items] = item_type;
											
								gruntime_data->gobject_types[object_number].item_name[num_items] = gcurr_token_text;
					
								gruntime_data->gobject_types[object_number].item_size[num_items] = size;
								
	//							gruntime_data->gobject_types[object_number].item_number_of_indexes[num_items] = number_of_dimensions;
	
	//							gruntime_data->gobject_types[object_number].item_object_number[num_items] = get_object_number( item_type );
					
								gruntime_data->gobject_types[object_number].offset[num_items] = offset;
							
								gruntime_data->gobject_types[object_number].num_items++;
							
								offset += size;
								
								total_size += size;
								
								num_items++;
							
								next_token();
					
								if (gcurr_tok != TOK_COMMA && gcurr_tok != TOK_SEMICOLON)
									syntax_error( 128, "Expected ',' or ';' after an object item declaration: " + gcurr_token_text );
					
								if (gcurr_tok == TOK_COMMA)
									next_token();
							}
						}
						

						
						if (gcurr_tok == TOK_SEMICOLON)
							next_token();
					}
				}
	
				if (num_items == 0)
					semantic_error( 386, "An object must have at least one member variable." );
				
				next_token();

				type1 = token_text_object + "_" + to_string( object_number );
				
				gruntime_data->gobject_types[object_number].num_items = num_items;
					
				gruntime_data->gobject_types[object_number].type_size = total_size;

//				gruntime_data->gnum_object_types++;
			}
			else
			{	
				type1 = type1 + gcurr_token_text;
				
				if ((! is_link_type( type1 )) &&
					(! is_data_type( gcurr_tok, gcurr_token_text, size )) &&
					(! is_user_defined_type( type1, underlying_type )))
						syntax_error( 70, "Expected a data type or user-defined type: " + gcurr_token_text );
				
				next_token();
				
				if (is_var_declaration && gcurr_tok == TOK_OPEN_HASH)
				{
					next_token();

					if (gcurr_token_text != "size")
						syntax_error( 384, "Expected the word 'size' after a '#' in this location." );
					
					while (gcurr_tok != TOK_CLOSE_HASH && gcurr_tok != TOK_EOF)					
						next_token();
							
					if (gcurr_tok == TOK_CLOSE_HASH)					
						next_token();
				}
			}
		}
		
		return (type1);
	}

//------------------------------------------------------------
// Parse a constant string expression.
//------------------------------------------------------------

	string parse_const_string_expr()
	{
		string value1, value2;
		string result;
		int op;
		
		value1 = parse_const_string_expr_item();

		result = value1;
		
		op = gcurr_tok;
		
		while (op == TOK_ADDR_STRCONCAT)
		{
			next_token();
	
			if (gcurr_tok == TOK_LPARENTHESIS)
			{
				next_token();
				
				value2 = parse_const_string_expr();

				next_token();
			}
			else
			{
				value2 = parse_const_string_expr_item();
			}
			
			result = result + value2;
			
			op = gcurr_tok;
		}
		
		return (result);
	}


	string parse_const_string_expr_item()
	{
		t_constants *constant_ptr;
		string result;
		bool found;
		
		result = "";

		if (gcurr_tok == TOK_LPARENTHESIS)
		{
			next_token();
			
			result = parse_const_string_expr();
		}
		else		
		if (gcurr_tok == TOK_NAME)
		{
			constant_ptr = lookup_constant( gcurr_token_text, found );

			if (found)
			{
				if (constant_ptr->type1 != token_text_string)
					syntax_error( 211, "Expected a string constant" );

				result = constant_ptr->value;
//				result = gstring_constants[cstring_to_int(constant_ptr->value)].str_value;
			}
			else
				syntax_error( 189, "Expected a string: " + gcurr_token_text );
		}
		else										
		if (gcurr_tok == TOK_STRING_CONSTANT)
		{
			result = gcurr_token_text;
		}
		else
			syntax_error( 377, "Expected a string: " + gcurr_token_text );

		next_token();
		
		return (result); 
	}



//------------------------------------------------------------
// Parse a constant numerical expression.
//------------------------------------------------------------

	double parse_const_numerical_expr( string& type1 )
	{
		double value1, value2;
		double result;
		int op;
		
		value1 = parse_const_numerical_expr_mult( type1 );

		result = value1;
		
		op = gcurr_tok;
		
		while (op == TOK_PLUS || op == TOK_SUBTRACT_MINUS)
		{
			next_token();
	
			if (gcurr_tok == TOK_LPARENTHESIS)
			{
				next_token();
				
				value2 = parse_const_numerical_expr( type1 );

				next_token();
			}
			else
			{
				value2 = parse_const_numerical_expr_mult( type1 );
			}
			
			if (op == TOK_PLUS)
				result = result + value2;
			else
				result = result - value2;
			
			op = gcurr_tok;
		}
		
		return (result);
	}

	double parse_const_numerical_expr_mult( string& type1 )
	{
		double value1, value2;
		double result;
		int op;
		
		value1 = parse_const_numerical_expr_exp( type1 );

		result = value1;
		
		op = gcurr_tok;
		
		while (op == TOK_MULT || op == TOK_DIV)
		{
			next_token();
	
			if (gcurr_tok == TOK_LPARENTHESIS)
			{
				next_token();
				
				value2 = parse_const_numerical_expr( type1 );

				next_token();
			}
			else
			{
				value2 = parse_const_numerical_expr_exp( type1 );
			}
			
			if (op == TOK_MULT)
				result = result * value2;
			else
			{
				if (value2 == 0)
					syntax_error( 372, "Divide by zero in parse_const_numerical_expr_mult()." );
					
				result = result / value2;
				
				if (type1 == token_text_int)
					result = ci_mtrunc( result );
			}
			
			op = gcurr_tok;
		}
		
		return (result);
	}

	double parse_const_numerical_expr_exp( string& type1 )
	{
		double value1, value2;
		double result;
		int op;
		
		value1 = parse_const_numerical_expr_item( type1 );

		result = value1;
		
		op = gcurr_tok;
		
		while (op == TOK_POW)
		{
			next_token();
	
			if (gcurr_tok == TOK_LPARENTHESIS)
			{
				next_token();
				
				value2 = parse_const_numerical_expr( type1 );
				
				next_token();
			}
			else
			{
				value2 = parse_const_numerical_expr_item( type1 );
			}

			if (value1 == 0 || value2 == 0)
				syntax_error( 373, "Zero value in '^' expression." );
			
			if (value1 <= 0 || value2 <= 0)
				syntax_error( 374, "Negative value in '^' expression." );
			
			result = pow( result, value2 );
			
			op = gcurr_tok;
		}
		
		return (result);
	}


	double parse_const_numerical_expr_item( string& type1 )
	{
		t_constants *constant_ptr;
		double result;
		bool found;
		
		result = 0;

		switch (gcurr_tok)
		{
			case TOK_NUMBER:
			{
//				if (type1 == token_text_int)							
//					result = cstring_to_int( gcurr_token_text );
//				else

				result = ci_cstring_to_double( gcurr_token_text );
			}
			break;
						
			case TOK_NAME:
			{
				constant_ptr = lookup_constant( gcurr_token_text, found );
	
				if (found)
				{
					if (constant_ptr->type1 != type1)
					{
						if (type1 == token_text_int)
							syntax_error( 211, "Expected an '" + type1 + "' constant" );
						else
							syntax_error( 211, "Expected a '" + type1 + "' constant" );
					}
					
					if (type1 == token_text_int)
						result = ci_cstring_to_int( constant_ptr->value );
					else
						result = ci_cstring_to_double( constant_ptr->value );
				}
				else
					syntax_error( 189, "Expected a number: " + gcurr_token_text );
			}
			break;
			
			case TOK_LPARENTHESIS:
			{
				next_token();
				
				result = parse_const_numerical_expr( type1 );
			}
			break;
			
			default:
				syntax_error( 377, "Expected a number: " + gcurr_token_text );
		}
		
		next_token();
		
		return (result);
	}




//------------------------------------------------------------
// Parse a constant numerical int expression.
//------------------------------------------------------------

	long int parse_const_numerical_expr_i( string& type1 )
	{
		long int value1, value2;
		long int result;
		int op;
		
		value1 = parse_const_numerical_expr_mult_i( type1 );

		result = value1;
		
		op = gcurr_tok;
		
		while (op == TOK_PLUS || op == TOK_SUBTRACT_MINUS)
		{
			next_token();
	
			if (gcurr_tok == TOK_LPARENTHESIS)
			{
				next_token();
				
				value2 = parse_const_numerical_expr_i( type1 );

				next_token();
			}
			else
			{
				value2 = parse_const_numerical_expr_mult_i( type1 );
			}
			
			if (op == TOK_PLUS)
				result = result + value2;
			else
				result = result - value2;
			
			op = gcurr_tok;
		}
		
		return (result);
	}

	long int parse_const_numerical_expr_mult_i( string& type1 )
	{
		long int value1, value2;
		long int result;
		int op;
		
		value1 = parse_const_numerical_expr_exp_i( type1 );

		result = value1;
		
		op = gcurr_tok;
		
		while (op == TOK_MULT || op == TOK_DIV)
		{
			next_token();
	
			if (gcurr_tok == TOK_LPARENTHESIS)
			{
				next_token();
				
				value2 = parse_const_numerical_expr_i( type1 );

				next_token();
			}
			else
			{
				value2 = parse_const_numerical_expr_exp_i( type1 );
			}
			
			if (op == TOK_MULT)
				result = result * value2;
			else
			{
				if (value2 == 0)
					syntax_error( 372, "Divide by zero in parse_const_numerical_expr_mult()." );
					
				result = result / value2;
				
				if (type1 == token_text_int)
					result = ci_mtrunc( result );
			}
			
			op = gcurr_tok;
		}
		
		return (result);
	}

	long int parse_const_numerical_expr_exp_i( string& type1 )
	{
		long int value1, value2;
		long int result;
		int op;
		
		value1 = parse_const_numerical_expr_item_i( type1 );

		result = value1;
		
		op = gcurr_tok;
		
		while (op == TOK_POW)
		{
			next_token();
	
			if (gcurr_tok == TOK_LPARENTHESIS)
			{
				next_token();
				
				value2 = parse_const_numerical_expr_i( type1 );
				
				next_token();
			}
			else
			{
				value2 = parse_const_numerical_expr_item_i( type1 );
			}

			if (value1 == 0 || value2 == 0)
				syntax_error( 373, "Zero value in '^' expression." );
			
			if (value1 <= 0 || value2 <= 0)
				syntax_error( 374, "Negative value in '^' expression." );
			
			result = pow( result, value2 );
			
			op = gcurr_tok;
		}
		
		return (result);
	}


	long int parse_const_numerical_expr_item_i( string& type1 )
	{
		t_constants *constant_ptr;
		long int result;
		bool found;
		
		result = 0;

		switch (gcurr_tok)
		{
			case TOK_NUMBER:
			{
//				if (type1 == token_text_int)							
//					result = ci_cstring_to_int( gcurr_token_text );
//				else

				result = ci_cstring_to_int( gcurr_token_text );
			}
			break;
						
			case TOK_NAME:
			{
				constant_ptr = lookup_constant( gcurr_token_text, found );
	
				if (found)
				{
					if (constant_ptr->type1 != type1)
					{
						if (type1 == token_text_int)
							syntax_error( 211, "Expected an '" + type1 + "' constant" );
						else
							syntax_error( 211, "Expected a '" + type1 + "' constant" );
					}
					
					if (type1 == token_text_int)
						result = ci_cstring_to_int( constant_ptr->value );
					else
						result = ci_cstring_to_double( constant_ptr->value );
				}
				else
					syntax_error( 189, "Expected a number: " + gcurr_token_text );
			}
			break;
			
			case TOK_LPARENTHESIS:
			{
				next_token();
				
				result = parse_const_numerical_expr_i( type1 );
			}
			break;
			
			default:
				syntax_error( 377, "Expected a number: " + gcurr_token_text );
		}
		
		next_token();
		
		return (result);
	}



	string parse_expr( int current_function_number )
	{
		string type1;
		int op;
		int prev_op;
		int label_num1;
		
		type1 = parse_comp_expr( current_function_number );
			
		op = gcurr_tok;
		
		prev_op = op;

		if (op == TOK_AND || op == TOK_OR || op == TOK_XOR)
			type1 = push_var_if_necessary( type1 );

		while (op == TOK_AND || op == TOK_OR || op == TOK_XOR)
		{
			next_token();			

			label_num1 = glabel_num;
	
			glabel_num++;
			
			if (op == TOK_AND)			gen_code( OP_JMP_FALSE_DONT_POP, ci_cint_to_string( label_num1 ), "" );		else
			if (op == TOK_OR)			gen_code( OP_JMP_TRUE_DONT_POP, ci_cint_to_string( label_num1 ), "" );

			type1 = parse_comp_expr( current_function_number );

			type1 = push_var_if_necessary( type1 );
								
			if (type1 != token_text_bool)
				semantic_error( 74, "Expected a boolean expression as an argument to an 'and' or 'or'." );

	        if (op == TOK_AND)
			{
				gen_code( OP_AND, "", "" );
			}			
	        else
	        if (op == TOK_OR)
			{		
				gen_code( OP_OR, "", "" );
			}			
	        else
	        if (op == TOK_XOR)
				gen_code( OP_XOR, "", "" );

			gen_code( OP_LABEL, ci_cint_to_string( label_num1 ), "" );

			op = gcurr_tok;
			
			if ((op == TOK_AND || op == TOK_OR || op == TOK_XOR) && 
				(prev_op == TOK_AND || prev_op == TOK_OR || prev_op == TOK_XOR) &&
				(op != prev_op))
					syntax_warning( 10, "Mixed 'and' / 'or' / 'xor' without brackets, use brackets to specify the correct condition." );
			
			prev_op = op;
		}
		
		return (type1);
	}


	string parse_comp_expr( int current_function_number )
	{
		string type1;
		string type11;
		string type12;
		string in_expr_type;
		string in_item_type;
		int this_label;
		bool is_not_in;
		int label_in_cond_true;
		int label_in_cond_false;
		int label_after_in;
		int op;
		string operator_text;
				
        if (gcurr_tok == TOK_NOT)
		{
			next_token();
			
	        if (gcurr_tok == TOK_LPARENTHESIS)
			{
				next_token();
				
				type1 = parse_expr( current_function_number );

				type1 = push_var_if_necessary( type1 );
								
				if (type1 != token_text_bool)
					semantic_error( 75, "Expected a boolean expression as an argument to a 'not'." );
								
				check_for_expected_token( TOK_RPARENTHESIS, 76, "Expected ')' after boolean expression" );
													
				next_token();
			}
			else
			{
				type1 = parse_item_expr( current_function_number );
				
				type1 = push_var_if_necessary( type1 );
			}
				
			if (type1 != token_text_bool)
				semantic_error( 75, "Expected a boolean expression as an argument to a 'not'." );
											
			gen_code( OP_NOT, "", "" );
		}
		else
		{
			type11 = parse_num_expr( current_function_number );

			type1 = type11;

			if (gcurr_tok == TOK_IN || (gcurr_tok == TOK_NOT && glookahead_tok == TOK_IN))
			{
				if (gcurr_tok == TOK_NOT)
				{
					is_not_in = true;
					next_token();
				}
				else
					is_not_in = false;	
				
				type11 = push_var_if_necessary( type11 );

				type1 = type11;

				in_expr_type = type1;
				
				next_token();
				
				check_for_expected_token( TOK_LBRACE, 242, "Expected '{' after 'in'." );

				next_token();

				
				label_in_cond_true = glabel_num;
		
				glabel_num++;


				label_in_cond_false = glabel_num;
		
				glabel_num++;
	
	
				label_after_in = glabel_num;
		
				glabel_num++;
	
				if (is_not_in)
					this_label = label_in_cond_false;
				else
					this_label = label_in_cond_true;
				 	
				do
				{
					if (gcurr_tok == TOK_COMMA)
						next_token();
					
					in_item_type = parse_expr( current_function_number );
	
					in_item_type = push_var_if_necessary( in_item_type );
	
					if (! ((in_expr_type == in_item_type) || (is_numeric_type( in_expr_type ) && is_numeric_type( in_item_type ))))
						semantic_error( 243, "Switch expression and case expression must be the same type or both be numeric." );
				
					generate_type_conversion_if_necessary( in_item_type, in_expr_type, 1 );

					
					if (in_expr_type == token_text_int)			gen_code( OP_EQ_INT_JMP, 		"", "" );
					else
					if (in_expr_type == token_text_double)		gen_code( OP_EQ_DOUBLE_JMP, 	"", "" );
					else
					if (in_expr_type == token_text_decimal)		gen_code( OP_EQ_DECIMAL_JMP, 	"", "" );
					else
					if (in_expr_type == token_text_bool)		gen_code( OP_EQ_BOOL_JMP, 		"", "" );
					else
					if (in_expr_type == token_text_string ||
						in_expr_type == token_text_date ||
						in_expr_type == token_text_time ||
						in_expr_type == token_text_datetime)
														 		gen_code( OP_EQ_STRING_JMP, 	"", "" );
																
					gruntime_data->ic[ic_pos_minus_1].jump_call_address = this_label;
					 																
				} while (gcurr_tok == TOK_COMMA);
				
				check_for_expected_token( TOK_RBRACE, 244, "Expected '}' after 'in'." );

				next_token();

				if (is_not_in)
					gen_code( OP_JMP, ci_cint_to_string( label_in_cond_true ), "" );


				gen_code( OP_LABEL, ci_cint_to_string( label_in_cond_false ), "" );
				
				gen_code( OP_POP_DISCARD, "", "" );
	
				gruntime_data->ic[ic_pos_minus_1].discard_count = 1;
	
				gen_code( OP_PUSH_CONST_INT, "0", "" );
	
				gen_code( OP_JMP, ci_cint_to_string( label_after_in ), "" );
	
		
				gen_code( OP_LABEL, ci_cint_to_string( label_in_cond_true ), "" );
				
				gen_code( OP_POP_DISCARD, "", "" );
		
				gruntime_data->ic[ic_pos_minus_1].discard_count = 1;
		
				gen_code( OP_PUSH_CONST_INT, "1", "" );
					
				gen_code( OP_LABEL, ci_cint_to_string( label_after_in ), "" );
				
				type1 = token_text_bool;
			} 
			else
			{
				if (gcurr_tok == TOK_EQ || 
					gcurr_tok == TOK_NE || 
					gcurr_tok == TOK_GT || 
					gcurr_tok == TOK_GE || 
					gcurr_tok == TOK_LT || 
					gcurr_tok == TOK_LE)
				{
					type11 = push_var_if_necessary( type11 );

					type1 = type11;
					
					op = gcurr_tok;
					operator_text = gcurr_token_text;
									
					next_token();
			
					type12 = parse_num_expr( current_function_number );
		
					type12 = push_var_if_necessary( type12 );
		
					if (! (type11 == type12 || is_link_type( type11 ) || (is_numeric_type( type11 ) && is_numeric_type( type12 ))))
						semantic_error( 77, "Data types must match or both be numeric: '" + type11 + "' and '" + type12 + "'" );
					
					if (is_numeric_type( type11 ))
						type11 = promote_numeric_type( type11, type12, op );
	
					if (op == TOK_GT || 
						op == TOK_GE ||
						op == TOK_LT || 
						op == TOK_LE)
					{
						if (type11 != token_text_int &&
							type11 != token_text_decimal &&
							type11 != token_text_double &&
							type11 != token_text_date &&
							type11 != token_text_time &&
							type11 != token_text_datetime &&
							type11 != token_text_string)
																
								semantic_error( 198, "Data type '" + type11 + "' does not have a '" + operator_text + "' operator." );
					}
					
					gen_relational_op( op, type11 );
				
					type1 = token_text_bool;
				}
			}
		}
		
		return (type1); 				
	}
	
	
	void gen_relational_op( int op, string& type1 )
	{
		if (is_link_type( type1 ))
		{
			if (op == TOK_EQ)		gen_code( OP_EQ_LINK, "", "" );		else
			if (op == TOK_NE)		gen_code( OP_NE_LINK, "", "" );
		}
		else
		{
			if (type1 == token_text_int)
			{
				switch (op)
				{
					case TOK_EQ:	gen_code( OP_EQ_INT, "", "" );		break;
					case TOK_NE:	gen_code( OP_NE_INT, "", "" );		break;
					case TOK_LT:	gen_code( OP_LT_INT, "", "" );		break;
					case TOK_GT:	gen_code( OP_GT_INT, "", "" );		break;
					case TOK_LE:	gen_code( OP_LE_INT, "", "" );		break;
					case TOK_GE:	gen_code( OP_GE_INT, "", "" );		break;
				}
			}
					
			if (type1 == token_text_string ||
				type1 == token_text_date ||
				type1 == token_text_time ||
				type1 == token_text_datetime)
			{
				switch (op)
				{
					case TOK_EQ:	gen_code( OP_EQ_STRING, "", "" );		break;
					case TOK_NE:	gen_code( OP_NE_STRING, "", "" );		break;
					case TOK_LT:	gen_code( OP_LT_STRING, "", "" );		break;
					case TOK_GT:	gen_code( OP_GT_STRING, "", "" );		break;
					case TOK_LE:	gen_code( OP_LE_STRING, "", "" );		break;
					case TOK_GE:	gen_code( OP_GE_STRING, "", "" );		break;
				}
			}
	
			if (type1 == token_text_decimal)
			{
				switch (op)
				{
					case TOK_EQ:	gen_code( OP_EQ_DECIMAL, "", "" );		break;
					case TOK_NE:	gen_code( OP_NE_DECIMAL, "", "" );		break;
					case TOK_LT:	gen_code( OP_LT_DECIMAL, "", "" );		break;
					case TOK_GT:	gen_code( OP_GT_DECIMAL, "", "" );		break;
					case TOK_LE:	gen_code( OP_LE_DECIMAL, "", "" );		break;
					case TOK_GE:	gen_code( OP_GE_DECIMAL, "", "" );		break;
				}
			}
	
			if (type1 == token_text_double)
			{
				switch (op)
				{
					case TOK_EQ:	gen_code( OP_EQ_DOUBLE, "", "" );		break;
					case TOK_NE:	gen_code( OP_NE_DOUBLE, "", "" );		break;
					case TOK_LT:	gen_code( OP_LT_DOUBLE, "", "" );		break;
					case TOK_GT:	gen_code( OP_GT_DOUBLE, "", "" );		break;
					case TOK_LE:	gen_code( OP_LE_DOUBLE, "", "" );		break;
					case TOK_GE:	gen_code( OP_GE_DOUBLE, "", "" );		break;
				}
			}
	
			if (type1 == token_text_bool)
			{
				if (op == TOK_EQ)		gen_code( OP_EQ_BOOL, "", "" );		else
				if (op == TOK_NE)		gen_code( OP_NE_BOOL, "", "" );
			}					
	
			if (type1 == token_text_binary)
			{
				if (op == TOK_EQ)		gen_code( OP_EQ_BINARY, "", "" );	else
				if (op == TOK_NE)		gen_code( OP_NE_BINARY, "", "" );
			}
		}					
	}


	string parse_num_expr( int current_function_number )
	{
		int num_items;
		int op;
		string type1;
		string type2;
		
		num_items = 1;
		
		type1 = parse_add_expr( current_function_number );
		
		op = gcurr_tok;

		if (op == TOK_ADDR_STRCONCAT)
		{
			type1 = push_var_if_necessary( type1 );
			
			generate_conversion_to_string_if_necessary( type1 );
			
			if (! is_simple_data_type( type1 ) && ! is_link_type( type1 ))
				semantic_error( 159, "The data type of an '&' operand must be convertable to string: " + type1 );
		}
				
		while (op == TOK_ADDR_STRCONCAT)
		{
			next_token();
			
			type2 = parse_add_expr( current_function_number );

			type2 = push_var_if_necessary( type2 );

			generate_conversion_to_string_if_necessary( type2 );
			
			if (! is_simple_data_type( type2 ) && ! is_link_type( type2 ))
				semantic_error( 160, "The data type of an '&' operand must be convertable to string: " + type2 );

			type1 = token_text_string;
			
			op = gcurr_tok;
			
			num_items++;
		}

		if (num_items == 2)
			gen_code( OP_STRCONCAT, "", "" );
		else
		if (num_items > 2)
		{
			gen_code( OP_STRCONCAT_N_ITEMS, "", "" );
			
			gruntime_data->ic[ic_pos_minus_1].str_concat_num_items = num_items;			
		}
		
		return (type1); 				
	}

	
	string parse_add_expr( int current_function_number )
	{
		string type1;
		string type2;
		int op;
		string op_text;
		
		type1 = parse_mult_expr( current_function_number );
		
		op = gcurr_tok;

		op_text = gcurr_token_text;

		if (op == TOK_PLUS || op == TOK_SUBTRACT_MINUS)
			type1 = push_var_if_necessary( type1 );
				
		while (op == TOK_PLUS || op == TOK_SUBTRACT_MINUS)
		{
			next_token();
	
			type2 = parse_mult_expr( current_function_number );

			type2 = push_var_if_necessary( type2 );

	        if (op == TOK_PLUS || op == TOK_SUBTRACT_MINUS)
			{
				if (! (is_numeric_type( type1 ) && is_numeric_type( type2 )))
					semantic_error( 78, "Data types to a '" + op_text + "' operator must be numeric." );
			}
			
			type2 = promote_numeric_type( type1, type2, op );
			
			if (type2 == token_text_int)
			{
		        if (op == TOK_PLUS)				gen_code( OP_ADD_INT, "", "" ); 
		        if (op == TOK_SUBTRACT_MINUS)	gen_code( OP_SUBTRACT_INT, "", "" );
			}
			else
			if (type2 == token_text_double)
			{
		        if (op == TOK_PLUS)				gen_code( OP_ADD_DOUBLE, "", "" );
		        if (op == TOK_SUBTRACT_MINUS)	gen_code( OP_SUBTRACT_DOUBLE, "", "" );
			}
			else							
			if (type2 == token_text_decimal)
			{
		        if (op == TOK_PLUS)				gen_code( OP_ADD_DECIMAL, "", "" );
		        if (op == TOK_SUBTRACT_MINUS)	gen_code( OP_SUBTRACT_DECIMAL, "", "" );
			}
							
			op = gcurr_tok;
			
			type1 = type2;
		}
		
		return (type1); 				
	}


	string parse_mult_expr( int current_function_number )
	{
		string type1;
		string type2;
		int op;
		string op_text;
		
		type1 = parse_exp_expr( current_function_number );
		
		op = gcurr_tok;

		op_text = gcurr_token_text;

		if (op == TOK_MULT || op == TOK_DIV || op == TOK_MOD)
			type1 = push_var_if_necessary( type1 );

		while (op == TOK_MULT || op == TOK_DIV || op == TOK_MOD)
		{
			next_token();

			type2 = parse_exp_expr( current_function_number );
			
			type2 = push_var_if_necessary( type2 );
			
			if (! (is_numeric_type( type1 ) && is_numeric_type( type2 )))
				semantic_error( 79, "Data types to a '" + op_text + "' operator must be numeric." );
			
			if (op == TOK_MOD && (type1 != token_text_int || type2 != token_text_int))  
				semantic_error( 343, "Operands to a 'mod' operator must be of type 'int'." );
			
			type2 = promote_numeric_type( type1, type2, op );

			if (type2 == token_text_int)
			{			
		        if (op == TOK_MULT)			gen_code( OP_MULT_INT, "", "" );
		        if (op == TOK_DIV)				
		        {
//					if (gshow_warnings)
//						syntax_warning( 0, "Integer division, fractional component truncated" );

		        	gen_code( OP_DIVIDE_INT, "", "" );
					
					type2 = token_text_double;
		        }
		       	else
		        if (op == TOK_MOD)			gen_code( OP_MOD_INT, "", "" );
			}
			else
			if (type2 == token_text_double)
			{			
		        if (op == TOK_MULT)			gen_code( OP_MULT_DOUBLE, "", "" );
		        if (op == TOK_DIV)			gen_code( OP_DIVIDE_DOUBLE, "", "" );
			}
			else
			if (type2 == token_text_decimal)
			{			
		        if (op == TOK_MULT)			gen_code( OP_MULT_DECIMAL, "", "" );
		        if (op == TOK_DIV)			gen_code( OP_DIVIDE_DECIMAL, "", "" );
			}
							
			op = gcurr_tok;
			
			type1 = type2;
		}
		
		return (type1); 				
	}


	string parse_exp_expr( int current_function_number )
	{
		string type1;
		string type2;
		int op;
		string op_text;
		
		type1 = parse_item_expr( current_function_number );
		
		op = gcurr_tok;

		op_text = gcurr_token_text;

		if (op == TOK_POW)
			type1 = push_var_if_necessary( type1 );
		
		while (op == TOK_POW)
		{
			next_token();
	
			type2 = parse_item_expr( current_function_number );
	
			type2 = push_var_if_necessary( type2 );
	
			if (! (is_numeric_type( type1 ) && is_numeric_type( type2 )))
				semantic_error( 80, "Data types to a '" + op_text + "' operator must be numeric." );
			
			type2 = promote_numeric_type( type1, type2, op );
			
			if (type2 == token_text_int)		
				gen_code( OP_EXP_INT, "", "" );
			else
			if (type2 == token_text_decimal)	
				gen_code( OP_EXP_DECIMAL, "", "" );
			else
			if (type2 == token_text_double)		
				gen_code( OP_EXP_DOUBLE, "", "" );
						
			op = gcurr_tok;
			
			type1 = type2;
		}
		
		return (type1);
	}


	string parse_item_expr( int current_function_number )
	{
		t_constants *constant_ptr;
		int push_flags;
		bool is_num_constant;
		bool allow_void;
		string s2;
		string varname;
		string type1;
		string array_name;
		bool stack_value_is_address;
		bool has_function_call;
		string str_numerical_value;
		bool is_global;
		string type11;
		string name;
		string array_type;
		int size;
		string text;
		bool found;
		string value;
		
		push_flags = 0;
		
		is_num_constant = false;

		allow_void = false;
		
		s2 = "";

		type1 = "";

		if (gcurr_tok == TOK_SUBTRACT_MINUS)
		{
			s2 = "-";
			next_token();
		}
			
					// first item in sequence
						
		if (gcurr_tok == TOK_LPARENTHESIS)
		{
			next_token();

			type1 = parse_expr( current_function_number );

			next_token();
		}

		else
		if (gcurr_tok == TOK_NAME || gcurr_tok == TOK_INC || gcurr_tok == TOK_DEC)
		{
			push_flags = 0;
			
			if (gcurr_tok == TOK_INC)	{push_flags = PUSH_FLAGS_PRE_INC;	next_token(); }						
			if (gcurr_tok == TOK_DEC)	{push_flags = PUSH_FLAGS_PRE_DEC;	next_token(); }			
			
			name = gcurr_token_text;
			
			varname = gcurr_token_text;
			
			constant_ptr = lookup_constant( varname, found );

			if (found)
			{
				type1 = constant_ptr->type1;
				value = constant_ptr->value;
			}

			if (found)
			{
					// OP_PUSH_CONST
					
				gen_code( get_const_push_op( type1 ), value, type1 );
			
				next_token();			
			}
			else
			{
				array_name = name;

				next_token();

				if (gcurr_tok == TOK_LPARENTHESIS)
				{
					if (is_member_function_call( current_function_number, name ))
					{
						gen_code( OP_PUSH_ADDR_FUNCTION_PARAMETER, "", "" );
						
						gruntime_data->ic[ic_pos_minus_1].offset = gruntime_data->gfunction_details[current_function_number].number_of_function_arguments + 1;
						
						gen_code( OP_PREP_FOR_MEMBER_FUNC_CALL, "", "" );
					}
					
					stack_value_is_address = false;
					
					type1 = parse_function_call( current_function_number, name, stack_value_is_address );
					
					if (stack_value_is_address)
						type1 = "addr " + type1;
				}
				else
				{
					check_var_declaration( current_function_number, type1, array_name, is_global );

					if (gshow_warnings)
						set_var_as_accessed( current_function_number, is_global, array_name );
					
					array_type = type1;

					type1 = parse_aggregate_expression( allow_void, type1, current_function_number, array_name, stack_value_is_address, has_function_call );

					if (gcurr_tok == TOK_INC)	{push_flags = PUSH_FLAGS_POST_INC;	next_token();	}						
					if (gcurr_tok == TOK_DEC)	{push_flags = PUSH_FLAGS_POST_DEC;	next_token();	}			

					check_var_declaration( current_function_number, type11, name, is_global );
					
					if (push_flags == PUSH_FLAGS_POST_INC)
					{
						if (! is_numeric_type( type1 ))
							semantic_error( 151, "Data type1 of a variable that has ++ applied to it must be numeric." );
					}						
					else
					if (push_flags == PUSH_FLAGS_POST_DEC)
					{
						if (! is_numeric_type( type1 ))
							semantic_error( 152, "Data type1 of a variable that has -- applied to it must be numeric." );
					}			

					size = get_type_total_size( type1 );

					if (stack_value_is_address)
					{
						if (push_flags == 0)
							type1 = "addr " + type1;
						else
 						{
							gen_code( OP_PUSH_VAR, name, type1 );

							gruntime_data->ic[ic_pos_minus_1].push_flags = push_flags;
						}
					}
				}
			}
		}
		else
		if (gcurr_tok == TOK_NUMBER)
		{
			str_numerical_value = gcurr_token_text;
			
			if (glookahead_tok == TOK_NAME)
			{
				if (glookahead_token_text == "b")	
					type1 = token_text_int;
				else
				if (glookahead_token_text == "si")	
					type1 = token_text_int;
				else
				if (glookahead_token_text == "mi")	
					type1 = token_text_int;
				else
				if (glookahead_token_text == "i")	
					type1 = token_text_int;
				else
				if (glookahead_token_text == "f")	
					type1 = token_text_double;
				else
				if (glookahead_token_text == "db")	
					type1 = token_text_double;
				else
				if (glookahead_token_text == "ld")	
					type1 = token_text_double;
				else
				if (glookahead_token_text == "dc")
				{	
					type1 = token_text_decimal;
				}
				else
					semantic_error( 408, "Invalid numeric type specifier: '" +  glookahead_token_text + "'" );
										
				next_token();			
			}
			else
			{
				if (ci_ssearch( gcurr_token_text, "." ) == -1)
					type1 = token_text_int;
				else
					type1 = token_text_double;
			}				
			
			is_num_constant = true;
/*				
				if (ssearch( gcurr_token_text, "." ) == -1)
					type1 = token_text_int;
				else
				if (ssearch( gcurr_token_text, "." ) >= gcurr_token_text.length() - 3)
					type1 = token_text_decimal;
				else
					type1 = token_text_double;
*/
			
				// OP_PUSH_CONST
				
			if (s2 == "-")
				gen_code( get_const_push_op( type1 ), "-" + str_numerical_value, type1 );
			else
				gen_code( get_const_push_op( type1 ), str_numerical_value, type1 );
								
			next_token();			
		}
		else
		if (gcurr_tok == TOK_STRING_CONSTANT || 
			gcurr_tok == TOK_DATE_CONSTANT ||
			gcurr_tok == TOK_TIME_CONSTANT ||
			gcurr_tok == TOK_DATETIME_CONSTANT ||
			gcurr_tok == TOK_BOOLEAN_CONSTANT)
		{
			text = gcurr_token_text;
			
			switch (gcurr_tok)
			{
				case TOK_STRING_CONSTANT: 		type1 = token_text_string;		break;
				case TOK_DATE_CONSTANT: 		type1 = token_text_date;		break;
				case TOK_TIME_CONSTANT: 		type1 = token_text_time;		break;
				case TOK_DATETIME_CONSTANT: 	type1 = token_text_datetime;	break;
				case TOK_BOOLEAN_CONSTANT: 		type1 = token_text_bool;		break;
			}
			
			if (gcurr_tok == TOK_BOOLEAN_CONSTANT)
			{
				if (gcurr_token_text == token_text_true || 
					gcurr_token_text == token_text_true_uppercase)
					text = "1";
				else
					text = "0";
			
				gen_code( OP_PUSH_CONST_INT, text, token_text_int );
			}
			else						
				gen_code( OP_PUSH_CONST_STRING, text, token_text_string );
							
			next_token();			
		}
		else
		{
			syntax_error( 90, "Expected ')', a variable name or a number" );
			
			next_token();			
		}
							
		if (s2 == "-" && (! is_num_constant))
		{
			type1 = push_var_if_necessary( type1 );
			
			if (type1 == token_text_int) 			gen_code( OP_NEGATE_INT, "", "" );		else
			if (type1 == token_text_decimal)		gen_code( OP_NEGATE_DECIMAL, "", "" );	else
			if (type1 == token_text_double)			gen_code( OP_NEGATE_DOUBLE, "", "" );
			else
				semantic_error( 215, "Expected a numeric type as the operand to a '-'." );
		}
	
		return (type1); 				
	}

	
	string push_var_if_necessary( string& type1 )
	{
		if (ci_sleft( type1, 5 ) == "addr ")
		{
			type1 = ci_sright_from_pos( type1, 5 );
			
			gen_code( OP_PUSH_VAR, "", type1 );

			gruntime_data->ic[ic_pos_minus_1].push_flags = 0;
			
			gruntime_data->ic[ic_pos_minus_1].type_map = ci_make_type_map( type1 );
		}
		
		return (type1);
	}


	string parse_function_call( int current_function_number, string& function_name, bool& stack_value_is_address )
	{
		int argument_count;
		string function_name2;
		string text;
		bool has_function_call;
		bool pass_by_reference;
		int function_being_called_function_number;
		string argument_type;
		string var_type;
		string var_name;
		bool push_expr;
		int indent_level;
		string name;
		string type1;
//		bool is_global;
//		int number_of_indexes;
		string return_type;
		bool allow_void;
		int size_from_function_call;
		int size_to_pop;
		t_bst_function_number *nptr2;
		bool found;
		
		next_token();
		
		argument_count = 0;

		text = "";
		
		found = false;
		
		if (gruntime_data->gfunction_details[current_function_number].is_member_function)
		{
			function_being_called_function_number = -1;
			
			function_name2 = "object:" + gruntime_data->gfunction_details[current_function_number].member_of + ":" + function_name; 
			
			nptr2 = (t_bst_function_number *) gbst_function_numbers.search_s( function_name2, found );				 
	
			if (found)
			{
				function_name = function_name2;
				
				function_being_called_function_number = nptr2->function_number;
			}
		}		
		
		if (! found)
		{
			function_being_called_function_number = -1;
			
			nptr2 = (t_bst_function_number *) gbst_function_numbers.search_s( function_name, found );				 
	
			if (found)
				function_being_called_function_number = nptr2->function_number;
		}
				
		if (function_being_called_function_number == -1)
		{
			semantic_error( 258, "Function " + function_name + " has not been declared." );
			
			indent_level = 1;
						
			next_token();
			
			while (indent_level > 0 and gcurr_tok != TOK_EOF)
			{
				if (gcurr_tok == TOK_LPARENTHESIS)
					indent_level++;
				
				if (gcurr_tok == TOK_RPARENTHESIS)
					indent_level--;
				
				next_token();
			}

			return_type = token_text_void;
		}
		else
		{
			if (! gruntime_data->gfunction_details[function_being_called_function_number].is_member_function)
				gen_code( OP_PUSH_SP_ONTO_ST2, "", "" );
		
			gruntime_data->gfunction_details[function_being_called_function_number].has_been_called = true;
			
			while (gcurr_tok != TOK_RPARENTHESIS && gcurr_tok != TOK_EOF)
			{
				if (argument_count >= gruntime_data->gfunction_details[function_being_called_function_number].number_of_function_arguments)
					next_token();
				else		
				{
					if (gcurr_tok == TOK_NAME && glookahead_tok == TOK_ASSIGN)
					{
						if (gcurr_token_text != gfunction_arguments[function_being_called_function_number][argument_count].name)
							semantic_error( 411, "Function parameter variable name is not correct: '" + gcurr_token_text + "' (expected '" + gfunction_arguments[function_being_called_function_number][argument_count].name + "')." );

						next_token();
						next_token();
					}					
					
					argument_type = gfunction_arguments[function_being_called_function_number][argument_count].type1;

					if (gcurr_tok == TOK_VAL)
					{
						pass_by_reference = false;
						next_token();
					}
					else
					if (gcurr_tok == TOK_REF)
					{
						pass_by_reference = true;
						next_token();
					}
					else
					if ((is_simple_data_type( argument_type ) ||
						is_link_type( argument_type )) &&
						argument_type != token_text_binary)
							pass_by_reference = false;
					else					
						pass_by_reference = true;
					
					push_expr = true;

					var_name = gcurr_token_text;

					type1 = parse_expr( current_function_number );

					if (gdefault_to_by_reference)
					{
						if (ci_sleft( type1, 5 ) == "addr ")
							pass_by_reference = true;
					}

					if (ci_sleft( type1, 5 ) != "addr " && gcurr_tok == TOK_REF)
						semantic_error( 385, "Expected a variable name for a 'ref' function parameter." );
					 
					if (ci_sleft( type1, 5 ) == "addr ")
					{
						var_type = ci_sright_from_pos( type1, 5 );

						if (pass_by_reference)
						{
							if (! (argument_type == var_type || 
									is_compatible_link_types( argument_type, var_type ) ||
									function_name == "array_index_size" || 
							    	function_name == "array_number_of_dimensions"))
							{
								semantic_error( 389, "Type of variable passed as a 'ref' parameter does not match the function definiton: expected a '" + argument_type + "' type but received a '" + var_type + "' variable." );
							}
							else
							{
								type1 = ci_sright_from_pos( type1, 5 );
	
								check_function_parameter_type( type1, function_name, function_being_called_function_number, argument_count, true, false );
								
								gen_code( OP_MOVE_SP_VALUE_TO_ST2, var_name, type1 );
							}
						}
						else
						{
							type1 = push_var_if_necessary( type1 );
						
							if (gshow_warnings)
							{
								if (get_type_total_size( type1 ) > 1000)
									syntax_warning( 5, "Push of a large size variable onto the function call stack, will slow program execution." );
							}
												
							check_function_parameter_type( type1, function_name, function_being_called_function_number, argument_count, true, false );
						
							gen_code( OP_SET_ST2_PTR_TO_SP, var_name, type1 );
						}
					}
					else
					{
						check_function_parameter_type( type1, function_name, function_being_called_function_number, argument_count, true, false );
					
						if (gshow_warnings)
						{
							if (get_type_total_size( type1 ) > 1000)
								syntax_warning( 5, "Push of a large size variable onto the function call stack, will slow program execution." );
						}
									
						gen_code( OP_SET_ST2_PTR_TO_SP, "", type1 );
					}														

					if (gcurr_tok != TOK_COMMA && gcurr_tok != TOK_RPARENTHESIS)
						syntax_error( 93, "Expected a ',' or ')' after function arguments." );

					if (gcurr_tok == TOK_COMMA)
						next_token();
				}
				
				argument_count++;
			}
	
			if (gruntime_data->gfunction_details[function_being_called_function_number].number_of_function_arguments != argument_count)
				semantic_error( 170, "Mismatch in function '" + function_name + "' argument count: declaration has " + to_string( gruntime_data->gfunction_details[function_being_called_function_number].number_of_function_arguments ) + " parameters but function call has " + to_string( argument_count ) + " parameters." );
			
//			gruntime_data->ic[ic_pos].argument_count = argument_count;
			
			return_type = check_function_usage( function_name, function_being_called_function_number, argument_count );
			
			if (gruntime_data->gfunction_details[function_being_called_function_number].builtin_function)
			{
				gen_code( OP_CALL_SYSTEM_FUNCTION, ci_cint_to_string( function_being_called_function_number ), "" );
	
				gruntime_data->ic[ic_pos_minus_1].jump_call_address = gruntime_data->gfunction_details[function_being_called_function_number].builtin_function_number;
				gruntime_data->ic[ic_pos_minus_1].this_function_number = current_function_number;
				gruntime_data->ic[ic_pos_minus_1].function_name = ci_sreplace( function_name, ":", "_" );
				gruntime_data->ic[ic_pos_minus_1].return_variable_size = gruntime_data->gfunction_details[function_being_called_function_number].return_variable_size;
//				gruntime_data->ic[ic_pos_minus_1].result_var_type = "result"; 
				gruntime_data->ic[ic_pos_minus_1].function_being_called_number = function_being_called_function_number;
				
				next_token();
			}
			else
			{
				if (! function_has_been_defined( function_name ))
					semantic_error( 94, "Function " + function_name + " must be declared or defined before being called." );
				
				gen_code( OP_CALL_USER_FUNCTION, ci_cint_to_string( function_being_called_function_number ), "" );
	
				gruntime_data->ic[ic_pos_minus_1].function_name = ci_sreplace( function_name, ":", "_" ); 
				gruntime_data->ic[ic_pos_minus_1].function_being_called_number = function_being_called_function_number;
				gruntime_data->ic[ic_pos_minus_1].return_variable_size = gruntime_data->gfunction_details[function_being_called_function_number].return_variable_size;
	
				next_token();

				if (gcurr_tok == TOK_LBRACKET ||
					gcurr_tok == TOK_DOT ||
					gcurr_tok == TOK_LBRACE)
				{
					allow_void = false;
					
					name = "";

					stack_value_is_address = true;

					size_from_function_call = get_type_total_size( return_type );

					gen_code( OP_COPY_TO_ST3, "0", return_type );

					gruntime_data->ic[ic_pos_minus_1].size = size_from_function_call;

					gstack3_in_use = true;


					return_type = parse_dereference( allow_void, return_type, current_function_number, name, stack_value_is_address, has_function_call );

	
/*	
					if (is_link_type( return_type ))
					{
						return_type = get_link_destination_type( return_type );
						
						gen_code( OP_PUSH_VAR, "0", return_type );
						
						gruntime_data->ic[ic_pos_minus_1].push_flags = 0;
					}
					
					size_from_function_call = get_type_total_size( return_type );
	
					gen_code( OP_PUSH_ADDR_SP_REL, "", "" );
	
					gruntime_data->ic[ic_pos_minus_1].offset = -size_from_function_call;
	
	
					return_type = parse_dereference( allow_void, return_type, current_function_number, name, stack_value_is_address, has_function_call );
	
					size_to_pop = get_type_total_size( return_type );
	
					gen_code( OP_PUSH_ADDR_SP_REL, "", "" );
	
					gruntime_data->ic[ic_pos_minus_1].offset = -(size_from_function_call + 1);			// + pointer on the stack
	
	
					gen_code( OP_BULK_COPY_REVS, "0", return_type );
					
					gruntime_data->ic[ic_pos_minus_1].type1 = return_type;
					
	
					gen_code( OP_INC_SP, "", "" );
					
					gruntime_data->ic[ic_pos_minus_1].inc_sp_amount = -(size_from_function_call-size_to_pop);
*/
					
				}
			}	
		}
		
		return (return_type);
	}


	bool is_member_function_call( int current_function_number, string& function_name )
	{
		bool found;
		string function_name2;
		
		found = false;
		
		if (gruntime_data->gfunction_details[current_function_number].is_member_function)
		{
			function_name2 = "object:" + gruntime_data->gfunction_details[current_function_number].member_of + ":" + function_name; 
			
			gbst_function_numbers.search_s( function_name2, found );				 
		}
		
		return (found);
	}		


			//---------------------------------------------------------------------------------------------------------------------
			// Check that a function is being called with the correct data types for each parameter
			//---------------------------------------------------------------------------------------------------------------------


	string check_function_parameter_type( string& type1, string& function_name, int function_being_called_function_number, int argument_count, bool add_conversion, bool is_reference_call )
	{
		string argument_type;
		string underlying_type;
		string type2;
		
		argument_type = "";

		if (argument_count <= gruntime_data->gfunction_details[function_being_called_function_number].number_of_function_arguments)
		{
			argument_type = gfunction_arguments[function_being_called_function_number][argument_count].type1;
			
			if (! check_types( argument_type, type1, add_conversion, 0 ))
			{
					
					/* Exceptions to function parameter checks:
					 *
					 * 		array_index_size() arg 1
					 * 		array_number_of_dimensions() arg 1
					 */
					 
		
				type2 = type1;
				
				if (is_user_defined_type( type1, underlying_type ))
					type2 = underlying_type;
					 					 
				if (! (
						(function_name == "print") ||
						(function_name == "array_index_size" && argument_count == 0 && is_resizable_array_type( type2 )) ||
					    (function_name == "array_number_of_dimensions" && argument_count == 0 && is_resizable_array_type( type2 ))
						)
					)
						semantic_error( 295, "Type error in function " + function_name + " function call argument number " + to_string( argument_count+1 ) + ", expected '" + argument_type + "' but variable is of type '" + type1 + "'" );
			}

			if (function_name == "print")
				generate_conversion_to_string_if_necessary( type1 );
			else
			if (argument_type != type1 && add_conversion)
			{
				if (! (
						(function_name == "array_index_size" && argument_count == 0 && is_resizable_array_type( type2 )) ||
					    (function_name == "array_number_of_dimensions" && argument_count == 0 && is_resizable_array_type( type2 ))
						)
					)
					{
						generate_type_conversion_if_necessary( type1, argument_type, 1 );
					}					
			}
		}
		else
			semantic_error( 96, "Error in function " + function_name + " function call argument number " + to_string( argument_count+1 ) + " is not defined." );
		
		return (argument_type);
	}
	
	
	
		//---------------------------------------------------------------------------------------------------------------------
		// Check that a conversion is available between a data type supplied and a data type required.
		//---------------------------------------------------------------------------------------------------------------------
		
	bool check_types( string& type_required, string& type_supplied, bool add_conversion, int level )
	{
		bool ok;
				
		ok = false;

		if (type_required == type_supplied)
			ok = true;
		else
		{			
			if (is_numeric_type( type_required ) && is_numeric_type( type_supplied ))
				ok = true;
			else
				ok = is_compatible_link_types( type_required, type_supplied );
		}
	
		return (ok);
	}

		//---------------------------------------------------------------------------------------------------------------------
		// Accepts a match for 'array [100] of link to general' and 'array [100] of link to int'
		//
		// Match if: last three words of one type is 'link to general' and the items up to 
		// the 'link to general' position match.
		//
		// e.g. 	'array [100] of link to general'
		//			'array [100] of link to link to int'
		//---------------------------------------------------------------------------------------------------------------------
		
	bool is_compatible_link_types( string& type_required, string& type_supplied )
	{
		bool ok;
		int num_items1, num_items2;
		string type1, type2;
		int i;
		int start_pos;
		
		ok = false;

		explode_result[1] = "";
		
		num_items1 = ci_sexplode( type_supplied, " ", explode_result, 100 );
		
		
		explode_result2[1] = "";
		
		num_items2 = ci_sexplode( type_required, " ", explode_result2, 100 );

		if (num_items1 >= 3 && num_items2 >= 3)
		{
			ok = false;
			
			type1 = explode_result[num_items1-3] + " " + explode_result[num_items1-2] + " " + explode_result[num_items1-1]; 

			type2 = explode_result2[num_items2-3] + " " + explode_result2[num_items2-2] + " " + explode_result2[num_items2-1]; 

			start_pos = 0; 
				
			if (type1 == (token_text_link + " " + token_text_to + " " + token_text_general))
			{
				ok = true;
				
				start_pos = num_items1 - 2;
				
				if (num_items2 <= start_pos)
					ok = false;
				else
				{
					for (i=0; i <= start_pos; i++)
					{
						if (explode_result[i] != explode_result2[i])
							ok = false;
					}
				}
			}
			else
			if (type2 == (token_text_link + " " + token_text_to + " " + token_text_general))
			{
				ok = true;
				
				start_pos = num_items2 - 2;
				
				if (num_items1 <= start_pos)
					ok = false;
				else
				{
					for (i=0; i <= start_pos; i++)
					{
						if (explode_result[i] != explode_result2[i])
							ok = false;
					}
				}
			}				
		}
		
		return ok;
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Generate type conversions.
		//---------------------------------------------------------------------------------------------------------------------
	
	void generate_type_conversion_if_necessary( string& type_from, string& type_to, int level )
	{
		int op;
		
		op = 0;
		
		if (type_from == token_text_void)
			semantic_error( 304, "Cannot use this function in this context because it doesn't return a value (void)." );
		
		if (type_from != type_to)
		{
			if (! is_compatible_link_types( type_from, type_to ))
			{
				if (type_to == token_text_double)
				{
					if (type_from == token_text_int)			op = OP_CONV_INT_TO_DOUBLE; 			else
					if (type_from == token_text_decimal)		op = OP_CONV_DECIMAL_TO_DOUBLE;
					else			
						semantic_error( 214, "No type conversion from " + type_from + " to " + type_to + " available, use a type conversion function." );
				}
				else
				if (type_to == token_text_int)
				{
					if (type_from == token_text_double)
					{
						op = OP_CONV_DOUBLE_TO_INT; 
						
//						if (gshow_warnings)
//							syntax_warning( 6, "Conversion of a double to an int, fractional part truncated. Use cdouble_to_int() if this is intentional." );
					}					
					else
					if (type_from == token_text_decimal)
					{
						op = OP_CONV_DECIMAL_TO_INT;
						
//						if (gshow_warnings)
//							syntax_warning( 5, "Conversion of a decimal to an int, fractional part truncated. Use cdecimal_to_int() if this is intentional." );
					}
					else			
						semantic_error( 210, "No type conversion from " + type_from + " to " + type_to + " available, use a type conversion function." );
				}
				else					
				if (type_to == token_text_decimal)
				{
					if (type_from == token_text_int)			op = OP_CONV_INT_TO_DECIMAL; 			else
					if (type_from == token_text_double)			op = OP_CONV_DOUBLE_TO_DECIMAL;
					else			
						semantic_error( 214, "No type conversion from " + type_from + " to " + type_to + " available, use a type conversion function." );
				}
				else
					semantic_error( 214, "No type conversion from " + type_from + " to " + type_to + " available, use a type conversion function." );
				
				if (op != 0)
				{
					gen_code( op, "", "" );
					gruntime_data->ic[ic_pos_minus_1].conv_level = level;
				}
			}
		}
	}	

			//---------------------------------------------------------------------------------------------------------------------
			// convert a type to a string for the '&' operator
			//---------------------------------------------------------------------------------------------------------------------
			
	void generate_conversion_to_string_if_necessary( string& type_from )
	{
		int op;
		
		op = 0;
		
		if (type_from == token_text_void)
			semantic_error( 304, "Cannot use this function in this context because it doesn't return a value (void)." );
		
		if (type_from != token_text_string &&
			type_from != token_text_date &&
			type_from != token_text_time &&
			type_from != token_text_datetime)
		{
			if (is_link_type( type_from ))					op = OP_CONV_LINK_TO_STRING;
			else
			if (type_from == token_text_int)				op = OP_CONV_INT_TO_STRING;
			else
			if (type_from == token_text_double)				op = OP_CONV_DOUBLE_TO_STRING;
			else
			if (type_from == token_text_decimal)			op = OP_CONV_DECIMAL_TO_STRING;
			else
			if (type_from == token_text_bool)				op = OP_CONV_BOOL_TO_STRING;
			else
			if (type_from == token_text_binary)				op = OP_CONV_BINARY_TO_STRING;
			else
				semantic_error( 214, "type for conversion to string not recognised: " + type_from );
				
			if (op != 0)
				gen_code( op, "1", "" );
		}
	}	

			//---------------------------------------------------------------------------------------------------------------------
			// Retrieve information about a variable
			//---------------------------------------------------------------------------------------------------------------------

	void check_var_declaration( int current_function_number, string& type1, string& name, bool& is_global )
	{
		bool found;
		int i, j, object_number;
		string text;
		t_global_variable *nptr_global_var;
		t_local_variable *nptr_local_variable;
		found = false;
		
		is_global = false;

		if (gin_function)
		{
			text = to_string( current_function_number ) + "&" + name;
			
			nptr_local_variable = (t_local_variable *) gbst_local_variables.search_s( text, found );
			 
			if (found)
			{
				type1 = nptr_local_variable->type1;
				
//				number_of_indexes = nptr_local_variable->number_of_indexes;
			}

			if (! found)
			{
				for (j=0; j <= gruntime_data->gfunction_details[current_function_number].number_of_function_arguments - 1; j++)
				{
					if (gfunction_arguments[current_function_number][j].name == name)
					{
						found = true;
						type1 = gfunction_arguments[current_function_number][j].type1;
						
//						number_of_indexes = gfunction_arguments[current_function_number][j].number_of_indexes;
					}
				}
			}

			if (! found)
			{
				if (is_member_variable( current_function_number, name ))
				{
					for (i=0; i <= gruntime_data->gnum_user_defined_types - 1; i++)
					{
						if (gruntime_data->gfunction_details[current_function_number].member_of == gruntime_data->guser_defined_types[i].type_name)
						{
							object_number = gruntime_data->guser_defined_types[i].object_number;
							
							for (j=0; j <= gruntime_data->gobject_types[object_number].num_items - 1; j++)
							{
								if (gruntime_data->gobject_types[object_number].item_name[j] == name)
								{
									type1 = gruntime_data->gobject_types[object_number].item_type[j];

//									number_of_indexes = gruntime_data->gobject_types[object_number].item_number_of_indexes[j];
																		
									found = true;
								}
							}
						}
					}
				}	
			}			
		}

		
		if (! found)
		{
			nptr_global_var = (t_global_variable *) gbst_global_variables.search_s( name, found );
			 
			if (found)
			{
				is_global = true;
				 
				type1 = nptr_global_var->type1;
				
//				number_of_indexes = nptr_global_var->number_of_indexes;
			}
		}
		
		if (! found)
		{
			gerror_occured = true;
			semantic_error( 97, "Variable '" + name + "' in function '" + gruntime_data->gfunction_details[current_function_number].function_name + "' has not been declared." );
			
			type1 = ""; 
		}
	}
					
		//---------------------------------------------------------------------------------------------------------------------
		// Returns true if variable "name" is a global variable
		//---------------------------------------------------------------------------------------------------------------------
	
	bool is_global_variable( int current_function_number, string& name )
	{
		int i, j;
		bool loc_version;
		int object_number;
		bool found;
		string text;
		bool is_global;
		
		found = false;
		
		is_global = false;
		
		loc_version = false;
		
		if (is_member_variable( current_function_number, name ))
		{
			for (i=0; i <= gruntime_data->gnum_user_defined_types - 1; i++)
			{
				if (gruntime_data->gfunction_details[current_function_number].member_of == gruntime_data->guser_defined_types[i].type_name)
//				if (ci_sleft( gruntime_data->gfunction_details[current_function_number].member_of, token_text_object.length() + 1 ) == token_text_object + "_")
				{
					object_number = gruntime_data->guser_defined_types[i].object_number;
					
					for (j=0; j <= gruntime_data->gobject_types[object_number].num_items - 1; j++)
					{
						if (gruntime_data->gobject_types[object_number].item_name[j] == name)
							loc_version = true;
					}
				}
			}
		}	
		
		if (! loc_version && gin_function && current_function_number != -1)
		{
			text = to_string( current_function_number ) + "&" + name;
			
			gbst_local_variables.search_s( text, found );
			 
			if (found)
				loc_version = true;
			
			if (! loc_version)
			{
				for (j=0; j <= gruntime_data->gfunction_details[current_function_number].number_of_function_arguments - 1; j++)
				{
					if (gfunction_arguments[current_function_number][j].name == name)
					{
						loc_version = true;
					}
				}
			}
		}

		if (! loc_version)
		{
			gbst_global_variables.search_s( name, found );
			
			if (found)
				is_global = true;
		}

		return (is_global);
	}

	
	
		//---------------------------------------------------------------------------------------------------------------------
		//---------------------------------------------------------------------------------------------------------------------
			
	void create_global_variables_segment()
	{
		gruntime_data->gglobal_variables_section_size = 0;
		
		gnumber_of_global_variables = 0;
		
		gbst_global_variables.create( 0 );
		
		gbst_type_cache.create( 0 );
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Returns the object number of type 'type1' if there is one.
		//---------------------------------------------------------------------------------------------------------------------
		
	int get_object_number( string& type1 )
	{
		int object_number, i;
		
		object_number = -1;

		for (i=0; i < gruntime_data->gnum_user_defined_types; i++)
		{
			if (gruntime_data->guser_defined_types[i].type_name == type1)
			{
				if (gruntime_data->guser_defined_types[i].is_object)
				{
					object_number = gruntime_data->guser_defined_types[i].object_number;
				}
			}
		}

		return (object_number);
	}
	

		//---------------------------------------------------------------------------------------------------------------------
		// Returns true if variable "name" is a local variable
		//---------------------------------------------------------------------------------------------------------------------
	
	bool is_local_variable( int current_function_number, string& name )
	{
		bool found;
		
		found = false;
		
		if (gin_function)
			gbst_local_variables.search_s( to_string( current_function_number ) + "&" + name, found );
		
		return (found);
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Returns true if variable "name" is a function parameter
		//---------------------------------------------------------------------------------------------------------------------

	bool is_function_parameter( int current_function_number, string& name )
	{
		bool found;
		int j;
		
		found = false;
		
		if (gin_function)
		{
			for (j=0; j <= gruntime_data->gfunction_details[current_function_number].number_of_function_arguments - 1; j++)
			{
				if (gfunction_arguments[current_function_number][j].name == name)
					found = true;
			}
		}			

		return (found);
	}
	
	
		//---------------------------------------------------------------------------------------------------------------------
		// Returns true if name "name" is a type name
		//---------------------------------------------------------------------------------------------------------------------

	bool is_type_name( string& name )
	{
		int i;
		bool found;
		
		found = false;
		
		for (i=0; i <= gruntime_data->gnum_user_defined_types - 1; i++)
		{
			if (gruntime_data->guser_defined_types[i].type_name == name)
				found = true;
		}
	
		return (found);
	}
	
	
		//---------------------------------------------------------------------------------------------------------------------
		// Returns true if name "name" is a constant name
		//---------------------------------------------------------------------------------------------------------------------

	bool is_const_name( string& name )
	{
		bool found;

		lookup_constant( name, found );
	
		return (found);
	}

	
		//---------------------------------------------------------------------------------------------------------------------
		// Returns true if name "name" is a function name
		//---------------------------------------------------------------------------------------------------------------------

	bool is_function_name( string name )
	{
		bool found;
		
		gbst_function_numbers.search_s( name, found );
		
		return (found);
	}



			//---------------------------------------------------------------------------------------------------------------------
			// Check that functions that are called have been defined and are being called with the correct number of arguments
			//---------------------------------------------------------------------------------------------------------------------
	
	string check_function_usage( string& function_name, int function_being_called_function_number, int number_of_arguments )
	{
		string return_type;

		return_type = gruntime_data->gfunction_details[function_being_called_function_number].return_variable_type;
		
		if (gruntime_data->gfunction_details[function_being_called_function_number].number_of_function_arguments != number_of_arguments)
			semantic_error( 98, "Incorrect function usage, " + function_name + ", " + to_string( gruntime_data->gfunction_details[function_being_called_function_number].number_of_function_arguments ) + " arguments expected but " + to_string( number_of_arguments ) + " supplied." );

		return (return_type);
	}


			//---------------------------------------------------------------------------------------------------------------------
			// Processing of the icode after parsing has finished 
			//---------------------------------------------------------------------------------------------------------------------
	
	void post_parse_processing()
	{
		int i;
		int op;
		int *jump_addresses;
		int *function_addresses;
		bool *function_found;
		
		if (! gerror_occured)
		{
				// Set jump addresses to icode entries instead of label numbers
				
			jump_addresses = new int[ic_pos];
			function_addresses = new int[ic_pos];
			function_found = new bool[ic_pos];

			for (i=0; i < ic_pos; i++)
				function_found[i] = false;
			
			for (i=0; i < ic_pos; i++)
			{
				op = gruntime_data->ic[i].op;
				
				if (op == OP_LABEL)
					jump_addresses[gruntime_data->ic[i].jump_call_address] = i;
					
				if (op == OP_START_FUNCTION)
				{
					function_found[gruntime_data->ic[i].this_function_number] = true;
					function_addresses[gruntime_data->ic[i].this_function_number] = i;
				}
			}
			
			for (i=0; i < gnumber_of_user_functions; i++)
			{
				if (gruntime_data->gfunction_details[i].has_been_called &&
						(! gruntime_data->gfunction_details[i].builtin_function) && 
						(!function_found[i]))
					semantic_error( 397, "Function '" + gruntime_data->gfunction_details[i].function_name + "' has been called but not defined." );
			}				 
			
			for (i=0; i < ic_pos; i++)
			{
				op = gruntime_data->ic[i].op;

				if (op == OP_LABEL || is_jump_op( op ))
					gruntime_data->ic[i].jump_call_address = jump_addresses[gruntime_data->ic[i].jump_call_address];
					
				if (op == OP_CALL_USER_FUNCTION) 
					gruntime_data->ic[i].jump_call_address = function_addresses[gruntime_data->ic[i].function_being_called_number];
			}

			for (i=0; i < gruntime_data->gnum_function_table_items; i++)
				gruntime_data->gfunction_table[i].function_icode_address = function_addresses[gruntime_data->gfunction_table[i].function_number];

			delete [] jump_addresses;
			delete [] function_addresses;
						
			
				// BULK_COPY
/*				
			for (i=0; i <= ic_pos - 1; i++)
			{
				if (gruntime_data->ic[i].op == OP_PUSH_VAR &&
					gruntime_data->ic[i+1].op == OP_POP_VAR)
				{
					if (gruntime_data->ic[i].push_flags == 0)
					{
						if (gruntime_data->ic[i+1].type1 != gruntime_data->ic[i].type1)
						{
							if (! is_compatible_link_types( gruntime_data->ic[i].type1, gruntime_data->ic[i+1].type1 ))
								output( "Push/pop type mismatch: push: " + gruntime_data->ic[i].type1 + " pop: " + gruntime_data->ic[i+1].type1 + "\n" );
						}
					
						gruntime_data->ic[i].op = OP_BULK_COPY;
						gruntime_data->ic[i+1].op = OP_NULL_ENTRY;
					}
				}
			}
*/ 
 
		}
	}



		//---------------------------------------------------------------------------------------------------------------------
		//---------------------------------------------------------------------------------------------------------------------
		
	bool is_jump_op( int op )
	{
		if (op == OP_JMP ||
			op == OP_JMP_TRUE ||
			op == OP_JMP_FALSE ||
			op == OP_JMP_TRUE_DONT_POP ||
			op == OP_JMP_FALSE_DONT_POP ||
			op == OP_FOR_LOOP_1 ||
			op == OP_FOR_LOOP_2 ||
			op == OP_JMP_NULL ||
			op == OP_JMP_LE_0_DONT_POP ||
			op == OP_POP_JMP_LE ||
			op == OP_EQ_INT_JMP ||
			op == OP_EQ_DOUBLE_JMP ||
			op == OP_EQ_DECIMAL_JMP ||
			op == OP_EQ_BOOL_JMP ||
			op == OP_EQ_STRING_JMP ||
			op == OP_NEQ_INT_JMP ||
			op == OP_NEQ_DOUBLE_JMP ||
			op == OP_NEQ_DECIMAL_JMP ||
			op == OP_NEQ_BOOL_JMP ||
			op == OP_NEQ_STRING_JMP ||
			op == OP_VPTR_REPEAT_2)
				return (true);
		else
			return (false);
	}
	
	
		//---------------------------------------------------------------------------------------------------------------------
		// Calculate the offsets of function parameters. Called immediately after the x( ->. ) list so that the offsets are
		// available within the function code
		//---------------------------------------------------------------------------------------------------------------------

	void calc_function_parameter_offsets( int current_function_number )
	{
		int offset;
		int k;
			
		offset = 0; 
		
		for (k=gruntime_data->gfunction_details[current_function_number].number_of_function_arguments-1; k >= 0; k--)
		{
			offset++;
			
			gfunction_arguments[current_function_number][k].offset = offset;
		}
	}

	
		//---------------------------------------------------------------------------------------------------------------------
		// Check whether a function has been defined and if not add it to the list
		//---------------------------------------------------------------------------------------------------------------------
						
	int check_or_add_new_function( string& function_name, string& function_return_type, bool& already_defined )
	{
		t_bst_function_number *nptr2;
		t_local_variable *nptr_local_var;
		int current_function_number;
		string text;
		bool found;
		int size;
		
		found = false;
		
		nptr2 = (t_bst_function_number *) gbst_function_numbers.search_s( function_name, found );
		
		if (found)
			current_function_number = nptr2->function_number;
		else
		{
			current_function_number = gnumber_of_user_functions;

			nptr2 = new t_bst_function_number;
			
			nptr2->function_number = current_function_number;
			
			gbst_function_numbers.insert_s( function_name, nptr2 );

			if (gnumber_of_user_functions >= MAX_FUNCTIONS_PER_COMPILE)
			{
				cout << "Too many functions defined.";
				exit( 1 );
			}

			gnumber_of_user_functions++;

			size = get_type_total_size( function_return_type );
			
			text = to_string( current_function_number ) + "&result";

			nptr_local_var = new t_local_variable;

			nptr_local_var->name = "result";
			nptr_local_var->function_name = function_name;
			nptr_local_var->type1 = function_return_type;
//			nptr_local_var->number_of_indexes = number_of_dimensions;
			nptr_local_var->size = size;
			nptr_local_var->offset = 0;
			nptr_local_var->has_been_accessed = true;

			gbst_local_variables.insert_s( text, nptr_local_var );

			glocal_variables_array[current_function_number][0].type1 = function_return_type;
			glocal_variables_array[current_function_number][0].offset = 0;
			
			gruntime_data->gfunction_details[current_function_number].function_name = function_name;
			gruntime_data->gfunction_details[current_function_number].builtin_function = false;
			gruntime_data->gfunction_details[current_function_number].is_member_function = false;
			gruntime_data->gfunction_details[current_function_number].function_has_been_defined = false;
			gruntime_data->gfunction_details[current_function_number].has_been_called = false;
			gruntime_data->gfunction_details[current_function_number].return_variable_type = function_return_type;
			gruntime_data->gfunction_details[current_function_number].return_variable_size = size;
			gruntime_data->gfunction_details[current_function_number].number_of_local_variables = 1;
			gruntime_data->gfunction_details[current_function_number].local_variables_stackframe_size = size;
			gruntime_data->gfunction_details[current_function_number].number_of_function_arguments = 0;
		}
	
		if (found)
			already_defined = true;
		else
			already_defined = false;
		
		return (current_function_number);
	}
	
	
		//---------------------------------------------------------------------------------------------------------------------
		// Returns true if a function has already been defined	
		//---------------------------------------------------------------------------------------------------------------------

	bool function_has_been_defined( string& function_name )
	{
		bool found;
		
		gbst_function_numbers.search_s( function_name, found );				 

		return (found);
	}

		//---------------------------------------------------------------------------------------------------------------------
		// Push a variable's address onto the stack
		//---------------------------------------------------------------------------------------------------------------------

	void gen_code_push_var_address( int current_function_number, string& var_name )
	{
		string var_type;
		bool is_global;
		string item_type;
		int offset;
		bool found;
				
		found = false;
		
		if (gruntime_data->gfunction_details[current_function_number].is_member_function)
		{	
			get_object_item_details( gruntime_data->gfunction_details[current_function_number].member_of, var_name, item_type, offset, found, false );
			
			if (found)
			{
				gen_code( OP_PUSH_ADDR_FUNCTION_PARAMETER, "", "" );

				gruntime_data->ic[ic_pos_minus_1].offset = gruntime_data->gfunction_details[current_function_number].number_of_function_arguments + 1;

				if (offset != 0)
				{
					gen_code( OP_PUSH_CONST_INT, ci_cint_to_string( offset ), token_text_int );
	
					gen_code( OP_ADD_TO_POINTER, "0", "" );
				}
				
				if (gshow_icode || gshow_execution_trace)			
					gruntime_data->ic[ic_pos_minus_1].variable_name = var_name; 
			}	
		}
		
		if (! found)
		{
			check_var_declaration( current_function_number, var_type, var_name, is_global );
			
			if (is_global)
				gen_code( OP_PUSH_ADDR_GLOBAL_VAR, "", var_type );
			else
			if (is_local_variable( current_function_number, var_name ))			
				gen_code( OP_PUSH_ADDR_LOC_VAR, "", var_type );
			else
				gen_code( OP_PUSH_ADDR_FUNCTION_PARAMETER, "", var_type );

			gruntime_data->ic[ic_pos_minus_1].offset = get_variable_offset( current_function_number, var_name );

			if (gshow_icode || gshow_execution_trace)			
				gruntime_data->ic[ic_pos_minus_1].variable_name = var_name; 
		}
	}
	
	
	bool is_member_variable( int current_function_number, string& var_name )
	{
		bool found;
		int offset;
		string item_type;
		
		found = false;
		
		if (current_function_number != -1)
		{
			if (gruntime_data->gfunction_details[current_function_number].is_member_function)
			{
				get_object_item_details( gruntime_data->gfunction_details[current_function_number].member_of, var_name, item_type, offset, found, false );
			}
		}
		
		return (found);
	}
	
		//---------------------------------------------------------------------------------------------------------------------
		// Generate an icode entry
		//---------------------------------------------------------------------------------------------------------------------
			
	void gen_code( int op, string value, string type1 )
	{
		if (ic_pos >= MAX_ICODE_ITEMS)
		{
			cout << "Too many Icode items.";
			exit( 1 );
		}
		
		if (gshow_parse_trace)
			ci_output( "gen code: " + to_string( op ) + ": " + value + "<br>" ); 
		
		gruntime_data->ic[ic_pos].op = op;
	
//		gruntime_data->ic[ic_pos].value = value;
		
		gruntime_data->ic[ic_pos].type1 = type1;

		gruntime_data->ic[ic_pos].type_map = "";

		if (type1 != "")
			gruntime_data->ic[ic_pos].size = get_type_total_size( type1 ); 

		gruntime_data->ic[ic_pos].variable_name = "";
		
		if ((op == OP_LABEL || is_jump_op( op )) && value != "")
			gruntime_data->ic[ic_pos].jump_call_address = ci_cstring_to_int( value );
		
		if (op == OP_PUSH_CONST_STRING)
		{
			gruntime_data->ic[ic_pos].u32_string_constant_value = (char *) _ci_malloc( value.length() * 4 + sizeof( int_64 ) );
			
			ci_str_u8_to_u32( gruntime_data->ic[ic_pos].u32_string_constant_value, value.c_str() );
		}
		else
			gruntime_data->ic[ic_pos].u32_string_constant_value = NULL;

		if (op == OP_PUSH_CONST_INT)
			gruntime_data->ic[ic_pos].ivalue = ci_cstring_to_int( value );
		else
		if (op == OP_PUSH_CONST_DECIMAL)
			gruntime_data->ic[ic_pos].dvalue = ci_cstring_to_decimal( value );
		else
		if (op == OP_PUSH_CONST_DOUBLE)
			gruntime_data->ic[ic_pos].nvalue = ci_cstring_to_double( value );
		else
		if (op == OP_PUSH_CONST_BOOL)
			gruntime_data->ic[ic_pos].ivalue = ci_cstring_to_int( value );


		gruntime_data->ic[ic_pos].push_flags = 0;

//		gruntime_data->ic[ic_pos].text = value;

		gruntime_data->ic[ic_pos].input_filenumber = gcurrent_filenumber[gcurr_token_number];

		gruntime_data->ic[ic_pos].line_number = gcurrent_line_number[gcurr_token_number];
		
		ic_pos++;
		ic_pos_minus_1++;
	}

		//---------------------------------------------------------------------------------------------------------------------
		// Print a semantic error
		//---------------------------------------------------------------------------------------------------------------------
		
	void semantic_error( int error_number, string text )
	{
		gerror_occured = true;
		
		if (gcurrent_line_number[gcurr_token_number] != glast_error_line)
		{
			ci_output( "Error number: " + to_string( error_number ) + ": Line " + to_string( gcurrent_line_number[gcurr_token_number] ) + ": " + gruntime_data->ginput_filenames[gcurrent_filenumber[gcurr_token_number]] + ": " + text );

			if (gcommand_line_mode)
				ci_output( "\n" );
			else
				ci_output( "<br>" );
		
			glast_error_line = gcurrent_line_number[gcurr_token_number];
		}
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Print a syntax error
		//---------------------------------------------------------------------------------------------------------------------
		
	void syntax_error( int error_number, string text )
	{
		gerror_occured = true;
		
//		if (gcurrent_line_number[gcurr_token_number] != glast_error_line)
		{
			ci_output( "Error number: " + to_string( error_number ) + ": Line " + to_string( gcurrent_line_number[gcurr_token_number] ) + ": " + gruntime_data->ginput_filenames[gcurrent_filenumber[gcurr_token_number]] + ": " + text );

			if (gcommand_line_mode)
				ci_output( "\n" );
			else
				ci_output( "<br>" );
			
			glast_error_line = gcurrent_line_number[gcurr_token_number];
		}
		
		next_token();		
	}


	void syntax_warning( int error_number, string text )
	{
		ci_output( "Warning number: " + to_string( error_number ) + ": Line " + to_string( gcurrent_line_number[gcurr_token_number] ) + ": " + gruntime_data->ginput_filenames[gcurrent_filenumber[gcurr_token_number]] + ": " + text );

		if (gcommand_line_mode)
			ci_output( "\n" );
		else
			ci_output( "<br>" );
		
		glast_error_line = gcurrent_line_number[gcurr_token_number];
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Returns true if "text" is a reserved word
		//--------------------------------------------------------------------------------------------------------------------
		
	bool is_reserved_word( string& text )
	{
		t_keywords *keywords_ptr;
		bool stat;
		bool found;

		keywords_ptr = (t_keywords *) gbst_keywords.search_s( text, found );

		if (keywords_ptr != NULL)
			stat = true;
		else
			stat = false;
					
		return (stat);
	}

	
		//---------------------------------------------------------------------------------------------------------------------
		// Functions for returning variable's sizes 
		//---------------------------------------------------------------------------------------------------------------------

	int get_type_total_size( string type1 )
	{
		int size;
		int num_elements;
		int index_details[MAX_NUM_ARRAY_INDEXES];
		t_type_cache *nptr;
		bool found;
		int number_of_indexes; 
		int start_of_indexes;
		
		if (type1 == "")
			semantic_error( 254, "Internal error, get_type_total_size() called with empty string." );
		
		if (is_link_type( type1 ))
		{
			size = 1;
		}
		else
		if (is_resizable_array_type( type1 ))
		{
			size = 1;
		}
		else
		if (is_array_type( type1 ))
		{
			nptr = (t_type_cache *) gbst_type_cache.search_s( type1, found );

			if (found)
				size = nptr->size;
			else
			{
				size =  get_type_total_size( array_element_type( type1 ) );
		
				get_array_details( type1, number_of_indexes, num_elements, start_of_indexes, index_details );
	
				size *= num_elements;
				
				nptr = new t_type_cache;
				
				nptr->size = size;
				
				gbst_type_cache.insert_s( type1, nptr );
			}
		}
		else
			size = get_simple_type_size( type1 );
		
		return (size);
	}
	
	
		//---------------------------------------------------------------------------------------------------------------------
		// Returns the size of an array element
		//---------------------------------------------------------------------------------------------------------------------
		
	int get_array_element_size( string& type1 )
	{
		int size;
		bool stat;
		string element_type;
		t_type_cache *nptr;
		bool found;

		stat = false;

		nptr = (t_type_cache *) gbst_type_cache.search_s( "element_size&" + type1, found );

		if (found)
			size = nptr->size;
		else
		{
			if (! is_array_type( type1 ))
				semantic_error( 255, "Type '" + type1 + "' is not an array." );
	
			element_type = array_element_type( type1 );
			
			size = get_type_total_size( element_type );				

			nptr = new t_type_cache;
			
			nptr->size = size;
			
			gbst_type_cache.insert_s( "element_size&" + type1, nptr );
		}
								
		return (size);
	}

	
		//---------------------------------------------------------------------------------------------------------------------
		// Returns the type that a link points to
		//---------------------------------------------------------------------------------------------------------------------
		
	string get_link_destination_type( string& type1 )
	{
		string element_type;
		int num_items;
		int i;
		
		if (! is_link_type( type1 ))
			ci_output( "Internal error, type " + type1 + " is not a link type.<br>" );
		
		num_items = ci_sexplode( type1, " ", explode_result, 100 );
		
		element_type = "";

		for (i=2; i <= num_items-1; i++)
		{
			if (element_type != "")
				element_type = element_type + " ";
			
			 element_type = element_type + explode_result[i];
		}
		
		return (element_type);
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Add a new constant to the list
		//---------------------------------------------------------------------------------------------------------------------
		
	void add_constant( string name, string value, string type1 )
	{
		t_constants *constant_ptr;
		
		constant_ptr = new t_constants;
	
		constant_ptr->name = name;
		constant_ptr->value = value;
		constant_ptr->type1 = type1;

		gbst_constants.insert_s( name, constant_ptr );
	}


	t_constants *lookup_constant( string str, bool& found )
	{
		t_constants *ptr;
		
		ptr = (t_constants *) gbst_constants.search_s( str, found );
								 
		return (ptr);		
	}

		//---------------------------------------------------------------------------------------------------------------------
		// Lookup a constant in the list
		//---------------------------------------------------------------------------------------------------------------------
	
	t_constants *lookup_constant( string& name, bool found )
	{
		t_constants *constant_ptr;
		
		constant_ptr = (t_constants *) gbst_constants.search_s( name, found );				 

		if (found)
			return (constant_ptr);
		else
			return (NULL);
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Define a new global variable
		//---------------------------------------------------------------------------------------------------------------------
		
	int add_global_variable( string& var_name, string& type1, bool has_been_accessed, bool initialise_variable, long int init_ivalue, long int init_dvalue, double init_nvalue, string init_svalue )
	{
		t_global_variable *nptr_global_var;
		char *ptr;
		int offset;
		int size;

		size = get_type_total_size( type1 );

		offset = gruntime_data->gglobal_variables_section_size;

		nptr_global_var = new t_global_variable;


		nptr_global_var->name = var_name;
		nptr_global_var->type1 = type1;
		nptr_global_var->size = size;
		nptr_global_var->offset = offset;
		nptr_global_var->initialise_variable = initialise_variable;
		
		
		gglobal_variables_array[gnumber_of_global_variables].type1 = type1;
		gglobal_variables_array[gnumber_of_global_variables].offset = offset;
		gglobal_variables_array[gnumber_of_global_variables].initialise_variable = initialise_variable;
		
		if (initialise_variable)
		{
			gglobal_variables_array[gnumber_of_global_variables].init_ivalue = init_ivalue; 
			
			gglobal_variables_array[gnumber_of_global_variables].init_dvalue = init_dvalue * VAR_DECIMAL_SCALE;

			gglobal_variables_array[gnumber_of_global_variables].init_nvalue = init_nvalue;
			
			if (init_svalue.length() == 0)
				ptr = NULL;
			else
			{
				ptr = (char *) _ci_malloc( init_svalue.length() * 4 + sizeof( int_64 ) );
			
				ci_str_u8_to_u32( ptr, init_svalue.c_str() );
			}
						
			gglobal_variables_array[gnumber_of_global_variables].init_str_u32 = ptr;
		}
		
		
		nptr_global_var->has_been_accessed = has_been_accessed;

		gbst_global_variables.insert_s( var_name, nptr_global_var );
		 
		gruntime_data->gglobal_variables_section_size += size;

		gnumber_of_global_variables++;
 		
		return (offset);
	}
	
		
	
		//---------------------------------------------------------------------------------------------------------------------
		// Define a new local variable
		//---------------------------------------------------------------------------------------------------------------------
			
	void add_local_variable( int current_function_number, string& var_name, string& type1, int size, bool has_been_accessed, bool initialise_variable, long int init_ivalue, long int init_dvalue, double init_nvalue, string init_svalue )
	{
		int i;
		char *ptr;
		t_local_variable *nptr_local_var;
		int number_of_local_variables;
		int offset;
		string text;
			
		offset = gruntime_data->gfunction_details[current_function_number].local_variables_stackframe_size;
			
		text = to_string( current_function_number ) + "&" + var_name;
		
		nptr_local_var = new t_local_variable;

		nptr_local_var->name = var_name;
		nptr_local_var->function_name = gruntime_data->gfunction_details[current_function_number].function_name;
		nptr_local_var->type1 = type1;
//		nptr_local_var->number_of_indexes = number_of_dimensions;
		nptr_local_var->size = size;
		nptr_local_var->offset = offset;
		nptr_local_var->has_been_accessed = has_been_accessed;

		gbst_local_variables.insert_s( text, nptr_local_var );

		number_of_local_variables = gruntime_data->gfunction_details[current_function_number].number_of_local_variables;
		
		if (number_of_local_variables >= MAX_LOCAL_VARIABLES_PER_FUNCTION)
		{
			cout << "Too many local variables in function " + gruntime_data->gfunction_details[current_function_number].function_name;
			exit(1); 
		}
		
		glocal_variables_array[current_function_number][number_of_local_variables].type1 = type1;
		glocal_variables_array[current_function_number][number_of_local_variables].offset = offset;
		glocal_variables_array[current_function_number][number_of_local_variables].initialise_variable = initialise_variable;
		
		if (initialise_variable)
		{
			glocal_variables_array[current_function_number][number_of_local_variables].init_ivalue = init_ivalue; 
			
			glocal_variables_array[current_function_number][number_of_local_variables].init_dvalue = init_dvalue * VAR_DECIMAL_SCALE;

			glocal_variables_array[current_function_number][number_of_local_variables].init_nvalue = init_nvalue;
			
			if (init_svalue.length() == 0)
				ptr = NULL;
			else
			{
				ptr = (char *) _ci_malloc( init_svalue.length() * 4 + sizeof( int_64 ) );
			
				ci_str_u8_to_u32( ptr, init_svalue.c_str() );
			}
						
			glocal_variables_array[current_function_number][number_of_local_variables].init_str_u32 = ptr;
		}

		
//		glocal_variables_array[current_function_number][number_of_local_variables].is_object = false;
//		glocal_variables_array[current_function_number][number_of_local_variables].object_number = -1;
		
		
		if (not (is_simple_data_type( type1 ) or 
				is_link_type( type1 ) or
				is_array_type( type1 ) or
				is_resizable_array_type( type1 ))) 
		{
			for (i=0; i < gruntime_data->gnum_user_defined_types; i++)
			{
				if (gruntime_data->guser_defined_types[i].type_name == type1)
				{
					if (gruntime_data->guser_defined_types[i].is_object)
					{
//						glocal_variables_array[current_function_number][number_of_local_variables].is_object = true;
						
//						glocal_variables_array[current_function_number][number_of_local_variables].object_number = gruntime_data->guser_defined_types[i].object_number; 
					}
					else
					{
						glocal_variables_array[current_function_number][number_of_local_variables].type1 = gruntime_data->guser_defined_types[i].underlying_type;
					}
				}
			}
		}
		
		gruntime_data->gfunction_details[current_function_number].number_of_local_variables++;
		
		gruntime_data->gfunction_details[current_function_number].local_variables_stackframe_size += size;
	}
	
	
	
		//---------------------------------------------------------------------------------------------------------------------
		// set the array_indexes array and determine the number of indicies
		//---------------------------------------------------------------------------------------------------------------------
	
	void get_array_details( string& expression_type, int& number_of_indexes, int& number_of_elements, int& start_of_indexes, int index_details[MAX_NUM_ARRAY_INDEXES] )
	{
		int i;
		int j;
		int num;
  
		num = ci_sexplode( expression_type, " ", array_indexes2, 100 );
			
		i = 0;
		j = 0;
		
		number_of_indexes = 0;
		number_of_elements = 1;
  
		while (i < num && array_indexes2[i] != "[") 
			i++;

		i++;
		
		if (i < num)
		{
			while (i < num && array_indexes2[i] != "]")
			{
				index_details[j] = ci_cstring_to_int( array_indexes2[i] );
				number_of_elements *= ci_cstring_to_int( array_indexes2[i] );
				
				i++;
				j++;
				 
				number_of_indexes++;
			}
		}			 
	}				
	

		//---------------------------------------------------------------------------------------------------------------------
		// Returns the size of the object type that a link points to
		//---------------------------------------------------------------------------------------------------------------------
		
	int get_link_destination_size( string& type1 )
	{
		int size;
		
		size = get_type_total_size( get_link_destination_type( type1 ) );
				
		return (size);
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Returns true if "type1" is a simple type1 
		//---------------------------------------------------------------------------------------------------------------------
		
	bool is_simple_data_type( string& type1 )
	{
		bool stat;

		if (type1 == "")
			semantic_error( 254, "Internal error, is_simple_data_type() called with empty string." );
		
		if (type1 == token_text_int ||
			type1 == token_text_decimal ||
			type1 == token_text_double ||
			type1 == token_text_string ||
			type1 == token_text_bool ||
			type1 == token_text_binary ||
			type1 == token_text_date ||
			type1 == token_text_time ||
			type1 == token_text_datetime)
				stat = true;
		else
				stat  = false;
			
		return (stat);
	}
	
			
		//---------------------------------------------------------------------------------------------------------------------
		// Returns the size of a data type or object type
		//---------------------------------------------------------------------------------------------------------------------
						
	int get_simple_type_size( string& type1 )
	{
		int size;
		int object_number;
		bool found;
		int j;

		if (type1 == "")
			semantic_error( 254, "Internal error, get_simple_type_size() called with empty string." );
		
		size = 0;
		
		if (type1 == token_text_void)
			size = 0;
		else
		if (type1 == token_text_int ||
			type1 == token_text_decimal ||
			type1 == token_text_double ||
			type1 == token_text_string ||
			type1 == token_text_bool ||
			type1 == token_text_binary ||
			type1 == token_text_date ||
			type1 == token_text_time ||
			type1 == token_text_datetime)
		{
			size = 1;
		}
		else
		{
			found = false;
		
			if (ci_sleft( type1, token_text_object.length() + 1 ) == token_text_object + "_")
			{
				ci_sexplode( type1, "_", explode_result, 100 );
				
				object_number = ci_cstring_to_int( explode_result[1] );
				
				size =  gruntime_data->gobject_types[object_number].type_size;
						
				found = true;
			}
			else
			{
				for (j=0; j <= gruntime_data->gnum_user_defined_types - 1; j++)
				{
					if (gruntime_data->guser_defined_types[j].type_name == type1)
					{
						if (gruntime_data->guser_defined_types[j].is_object)
							size = gruntime_data->gobject_types[gruntime_data->guser_defined_types[j].object_number].type_size;
						else
							size = gruntime_data->guser_defined_types[j].type_size;
					
						found = true;
					}
				}
			}
			
			if (! found)
				semantic_error( 254, "Type '" + type1 + "' has not been declared." );
		}
				
		return (size);
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Returns true if the type is a user-defined type
		//---------------------------------------------------------------------------------------------------------------------
					
	bool is_user_defined_type( string& type1, string& underlying_type )
	{
		bool found;
		int i;
		
		found = false;

		for (i=0; i <= gruntime_data->gnum_user_defined_types - 1; i++)
		{
			if (gruntime_data->guser_defined_types[i].type_name == type1)
			{
				underlying_type = gruntime_data->guser_defined_types[i].underlying_type;
					 
				found = true;
			}
		}
		
		return (found);
	}
	
		
		//---------------------------------------------------------------------------------------------------------------------
		// Returns details of an object item
		//---------------------------------------------------------------------------------------------------------------------
			
	void get_object_item_details( string& type1, string& item_name, string& item_type, int& offset, bool& found, bool show_errors )
	{
		bool type_found;
		string type_name;
		int i;
		int j;
		int object_number;
		
		found = false;

		type_found = false;

		offset = 0;
	
		item_type = "";
		
		type_name = "";
		
		if (is_simple_data_type( type1 ))
			semantic_error( 352, "Attempting to access an object member on a simple data type: '" + type1 + "' , item '" + item_name + "'" );
		
		if (ci_sleft( type1, token_text_object.length() + 1 ) == token_text_object + "_")
		{
			ci_sexplode( type1, "_", explode_result, 100 );
			
			object_number = ci_cstring_to_int( explode_result[1] );

			for (i=0; i <= gruntime_data->gnum_user_defined_types - 1; i++)
			{
				if (gruntime_data->guser_defined_types[i].object_number == object_number)
					type_name = gruntime_data->guser_defined_types[i].type_name;
			}
						
			type_found = true;
		}
		else
		{
			type_name = type1;
			
			for (i=0; i <= gruntime_data->gnum_user_defined_types - 1; i++)
			{
				if (gruntime_data->guser_defined_types[i].type_name == type1)
				{
					object_number = gruntime_data->guser_defined_types[i].object_number;
					 
					type_found = true;
				}
			}
		}				
		
		if (type_found)
		{
			if (gruntime_data->gobject_types[object_number].num_items > 0)
			{
				for (j=0; j <= gruntime_data->gobject_types[object_number].num_items - 1; j++)
				{
					if (gruntime_data->gobject_types[object_number].item_name[j] == item_name)
					{
						offset = gruntime_data->gobject_types[object_number].offset[j];

						item_type = gruntime_data->gobject_types[object_number].item_type[j];
						
						found = true;
					}
				}
			}
		}

		if (! type_found)
			semantic_error( 284, "Type '" + type_name + "' has not been declared, item '" + item_name + "'" );
		else		
		if (! found && show_errors)
			semantic_error( 232, "Type '" + type_name + "' does not contain an item '" + item_name + "'" );
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Returns true if the token is a data type, including the type size 
		//---------------------------------------------------------------------------------------------------------------------
	
	bool is_data_type( int tok, string& type1, int& size )
	{
		bool stat;
		int i;
		
		stat = false;
		
		size = 0;
		
		if (tok == TOK_INT ||
			tok == TOK_DOUBLE ||
			tok == TOK_STRING ||
			tok == TOK_BOOL ||
			tok == TOK_DECIMAL ||
			tok == TOK_BINARY ||
			tok == TOK_DATE ||
			tok == TOK_TIME ||
			tok == TOK_DATETIME)
		{
			stat = true;
		}
		else
		{
			for (i=0; i <= gruntime_data->gnum_user_defined_types - 1; i++)
			{
				if (gruntime_data->guser_defined_types[i].type_name == type1)
					stat = true;
			}
		}
		
		size = get_simple_type_size( type1 );
		
		return (stat);
	}


	bool is_array_type( string& type1 )
	{
		bool stat;
			
		if (ci_sleft( type1, length_token_text_array_plus_1 ) == token_text_array_plus_one_space)
			stat = true;
		else
			stat = false;
		
		return (stat);
	}

	bool is_link_type( string& type1 )
	{
		bool stat;
			
		if (ci_sleft( type1, length_token_text_link_plus_1 ) == token_text_link_plus_one_space)
			stat = true;
		else
			stat = false;
		
		return (stat);
	}

	bool is_resizable_array_type( string& type1 )
	{
		bool stat;
			
		if (ci_sleft( type1, length_token_text_resizable_plus_1 ) == token_text_resizable_plus_one_space)
			stat = true;
		else
			stat = false;
		
		return (stat);
	}
	
	
		//---------------------------------------------------------------------------------------------------------------------
		// Returns the offset of a function parameter or local variable
		//---------------------------------------------------------------------------------------------------------------------
 	
	int get_variable_offset( int current_function_number, string& var_name )
	{
		t_global_variable *nptr_global_variable;
		t_local_variable *nptr_local_variable;
		string text;
		int offset;
		bool found;
		int i;
		
		offset = 0;
		
		found = false;
		
		if (gin_function)
		{
			text = to_string( current_function_number ) + "&" + var_name;
				
			nptr_local_variable = (t_local_variable *) gbst_local_variables.search_s( text, found );
			
			if (found)
				offset = nptr_local_variable->offset;
			
			if (! found)
			{
				for (i=0; i <= gruntime_data->gfunction_details[current_function_number].number_of_function_arguments - 1; i++)
				{
		    		if (gfunction_arguments[current_function_number][i].name == var_name)
					{
						offset = gfunction_arguments[current_function_number][i].offset;
					
						found = true;
					}
				}
			}
			
			if (! found)
			{
				nptr_global_variable = (t_global_variable *) gbst_global_variables.search_s( var_name, found );

				if (found)
					offset = nptr_global_variable->offset;
			}
		}
		
		return (offset);
	}

	int get_const_push_op( string& type1 )
	{
		string type12;
		int op;
	
		op = 0;
		
		type12 = type1;
		
		if (is_link_type( type1 ))
			type12 = token_text_link;
		
		if (type12 == token_text_int)		op = OP_PUSH_CONST_INT;
		else			
		if (type12 == token_text_decimal)	op = OP_PUSH_CONST_DECIMAL;
		else			
		if (type12 == token_text_double)	op = OP_PUSH_CONST_DOUBLE;
		else			
		if (type12 == token_text_string ||	
			type12 == token_text_date ||
			type12 == token_text_time ||
			type12 == token_text_datetime)	op = OP_PUSH_CONST_STRING;
		else			
		if (type12 == token_text_bool)		op = OP_PUSH_CONST_BOOL;
		else			
		if (type12 == token_text_link)		op = OP_PUSH_CONST_LINK;
		else			
			ci_output( "Internal error, type '" + type1 + "' not found." );
		
		return (op);
	}	

	
	void check_for_expected_token( int exp_tok, int error_number, string text )
	{
		if (gcurr_tok != exp_tok)
		{
			syntax_error( error_number, text + ": " + to_string( gcurr_tok ) + ": " + gcurr_token_text );
			
			prev_token();
		}
	}

		//---------------------------------------------------------------------------------------------------------------------
		// Generate code to promote numeric values to equal levels
		//---------------------------------------------------------------------------------------------------------------------
			
	string promote_numeric_type( string& type11, string& type12, int op )
	{
		string type1;
		
		type1 = "";
		
		if (type11 == token_text_double && type12 == token_text_double)
			type1 = token_text_double;
		else
		if (type11 == token_text_decimal && type12 == token_text_decimal)
			type1 = token_text_decimal;
		else
		if (type11 == token_text_int && type12 == token_text_int)
			type1 = token_text_int;
		else
			
		if (type11 == token_text_double && type12 != token_text_double)
		{
			if (type12 == token_text_decimal)
				gen_code( OP_CONV_DECIMAL_TO_DOUBLE, "", "" );
			else
				gen_code( OP_CONV_INT_TO_DOUBLE, "", "" );
				
			gruntime_data->ic[ic_pos_minus_1].conv_level = 1;
				
			type1 = token_text_double;
		}
		else
		if (type12 == token_text_double && type11 != token_text_double)
		{
			if (type11 == token_text_decimal)
				gen_code( OP_CONV_DECIMAL_TO_DOUBLE, "", "" );
			else
				gen_code( OP_CONV_INT_TO_DOUBLE, "", "" );
			
			gruntime_data->ic[ic_pos_minus_1].conv_level = 2;
			
			type1 = token_text_double;
		}

		else		
		if (type11 == token_text_decimal && type12 != token_text_decimal)
		{
			gen_code( OP_CONV_INT_TO_DECIMAL, "", "" );
				
			gruntime_data->ic[ic_pos_minus_1].conv_level = 1;
				
			type1 = token_text_decimal;
		}
		else
		if (type12 == token_text_decimal && type11 != token_text_decimal)
		{
			gen_code( OP_CONV_INT_TO_DECIMAL, "", "" );
			
			gruntime_data->ic[ic_pos_minus_1].conv_level = 2;
			
			type1 = token_text_decimal;
		}
		
		return (type1);
	}

		//--------------------------------------------------------------------------------------
		// Make a type map for a dynamic block
		//--------------------------------------------------------------------------------------

	string ci_make_type_map( string type1 )
	{
		string type_map;
		int i;
		
		type_map = "";
	
		for (i=0; i < gruntime_data->gnum_object_types; i++)
			make_map_obj_has_been_processed[i] = false;
	
		ci_make_type_map_1( type1, type_map );
		
		return (type_map);
	}
	
	
	void ci_make_type_map_1( string type1, string& type_map )
	{
		bool is_object;
		int i, j, k;
		bool finished;
		int object_number;
		string str1;
		int num_items;
		string explode_result[100];
		char str[100];
		long int num;
		
		num_items = ci_sexplode( type1, " ", explode_result, 100 );
		
		i = 0;

		while (i <= num_items-1)
		{
			is_object = false;
			
			str1 = explode_result[i];
			
			if (i == num_items-1)
			{
				if (ci_sleft( str1, 7 ) == "object_")
				{
					object_number = ci_cstring_to_int( ci_sright_from_pos( str1, 7 ) );
					
					is_object = true;
				}

				for (k=0; k < gruntime_data->gnum_user_defined_types; k++)
				{
					if (gruntime_data->guser_defined_types[k].type_name == str1)
					{
						if (gruntime_data->guser_defined_types[k].is_object)
						{
							object_number = gruntime_data->guser_defined_types[k].object_number;
							
							is_object = true;
						}
						else
						{ 
							type1 = gruntime_data->guser_defined_types[k].underlying_type;

							num_items = ci_sexplode( type1, " ", explode_result, 100 );
		
							i = 0;
							
							str1 = explode_result[i];
						}				
					}
				}
				
				if (is_object)
				{
					type_map += "<";
														// avoid infinite loops
														
					if (! make_map_obj_has_been_processed[object_number])
					{
						make_map_obj_has_been_processed[object_number] = true;

						for (j=0; j < gruntime_data->gobject_types[object_number].num_items; j++)
						{
							if (gruntime_data->gobject_types[object_number].item_type[j] != "padding")
								ci_make_type_map_1( gruntime_data->gobject_types[object_number].item_type[j], type_map );
						}
					}
						
					type_map += ">";
										
					i++;
				}
			}

			if (! is_object)
			{			
				if (str1 == token_text_int)				{ type_map += "A"; i++; }
				if (str1 == token_text_decimal)			{ type_map += "E"; i++; }
				if (str1 == token_text_double)			{ type_map += "G"; i++; }
				if (str1 == token_text_string)			{ type_map += "I"; i++; }
				if (str1 == token_text_bool)			{ type_map += "J"; i++; }
				if (str1 == token_text_binary)			{ type_map += "K"; i++; }
				if (str1 == token_text_date)			{ type_map += "L"; i++; }
				if (str1 == token_text_time)			{ type_map += "M"; i++; }
				if (str1 == token_text_datetime)		{ type_map += "N"; i++; }
				if (str1 == token_text_link)			{ type_map += "O"; i += 2; }
				if (str1 == token_text_resizable)		{ type_map += "P"; i += 3; }
				if (str1 == token_text_general)			{ type_map += "Q"; i++; }
				
				if (str1 == token_text_array)			
				{
					type_map += "-"; 
					
					finished = false;
					
					while (! finished)
					{
						i++;	
					
						str1 = explode_result[i];
						
						if (str1 == token_text_of)
							finished = true;
						else	
						if (str1 != "[" and str1 != "]" and str1 != ",")
						{
							num = ci_cstring_to_int( str1 );

							ci_dec_to_hex( str, (unsigned char *) &num, sizeof( long int ), 1, 0 );
							
							type_map += str;
							
							type_map += "-";
						} 
					}
					 
					i++;
				}
			}
		}
	}

		//---------------------------------------------------------------------------------------------------------------------
		// Returns the type of an array's elements.
		//
		// is stored as type "array link x 100 200"
		//---------------------------------------------------------------------------------------------------------------------
			
	string array_element_type( string& type1 )
	{
		string element_type;
		string underlying_type;
		int i;
		int num_items;
		
		if (is_user_defined_type( type1, underlying_type ))
			type1 = underlying_type;
		
		element_type = "";

		if (is_array_type( type1 ) || is_resizable_array_type( type1 ))
		{
  			num_items = ci_sexplode( type1, " ", explode_result, 100 );
  
  			i = 0;
			
 			element_type = "";
  
			while (i < num_items - 2 && explode_result[i] != "of")
  				i++;
			
			if (explode_result[i] == "of")
			{
 				i++;
   
				element_type = explode_result[i++];
				
				while (i < num_items)
					element_type = element_type + " " + explode_result[i++];
			}			 
		}
		else
			semantic_error( 217, "Not an array type: " + type1 );
			
		return (element_type);
	}


	void set_var_as_accessed( int current_function_number, bool is_global, string& var_name )
	{
		bool found;
		int i;
		t_global_variable *nptr_global_variable;
		t_local_variable *nptr_local_variable;

		if (is_global)
		{
			nptr_global_variable = (t_global_variable *) gbst_global_variables.search_s( var_name, found );

			if (nptr_global_variable != NULL)
				nptr_global_variable->has_been_accessed = true;
		}
		else
		{
			found = false;
			
			for (i=0; i <= gruntime_data->gfunction_details[current_function_number].number_of_function_arguments - 1; i++)
			{
	    		if (gfunction_arguments[current_function_number][i].name == var_name)
	    		{
					gfunction_arguments[current_function_number][i].has_been_accessed = true;
					
					found = true;
				}
			}
		
			if (! found)
			{
				nptr_local_variable = (t_local_variable *) gbst_local_variables.search_s( to_string( current_function_number ) + "&" + var_name, found );
	
				if (nptr_local_variable != NULL)
					nptr_local_variable->has_been_accessed = true;
			}
		}
	}
	


	void check_scan_functions( string object_type, string type_curr, string type2 )
	{
		string function_name;
		t_bst_function_number *nptr2; 
		int function_being_called_function_number;
		bool found;
		
		if (! is_function_name( object_type + "_first_item" ))
			semantic_error( 340, "Function  '" + object_type + "_first_item()' has not been declared." );
				
		if (! is_function_name( object_type + "_next_item" ))
			semantic_error( 340, "Function  '" + object_type + "_next_item()' has not been declared." );
		
		function_name = object_type + "_first_item";
		
		nptr2 = (t_bst_function_number *) gbst_function_numbers.search_s( function_name, found );
						 
		function_being_called_function_number = nptr2->function_number;

		if (function_being_called_function_number != -1)
		{
			if (gruntime_data->gfunction_details[function_being_called_function_number].return_variable_type != token_text_bool)
				semantic_error( 347, "Function must return a bool: '" + function_name + "'." );
					
			if (gfunction_arguments[function_being_called_function_number][0].type1 != type2)
				semantic_error( 348, "Mismatch in function parameter 1 type: '" + function_name + "', '" + gfunction_arguments[function_being_called_function_number][0].type1 + "' and '" + type2 + "'." );

			if (gfunction_arguments[function_being_called_function_number][1].type1 != type_curr)
				semantic_error( 391, "Mismatch in function parameter 2 type: '" + function_name + "', '" + gfunction_arguments[function_being_called_function_number][1].type1 + "' and '" + type_curr + "'." );

			if (gfunction_arguments[function_being_called_function_number][2].type1 != token_text_bool)
				semantic_error( 392, "Mismatch in function parameter 3 type: '" + function_name + "', '" + gfunction_arguments[function_being_called_function_number][2].type1 + "' and '" + token_text_bool + "'." );
		}					

		function_name = object_type + "_next_item";
		
		nptr2 = (t_bst_function_number *) gbst_function_numbers.search_s( function_name, found );				 
		function_being_called_function_number = nptr2->function_number;

		if (function_being_called_function_number != -1)
		{
			if (gruntime_data->gfunction_details[function_being_called_function_number].return_variable_type != token_text_bool)
				semantic_error( 393, "Function must return a bool: '" + function_name + "'." );
					
			if (gfunction_arguments[function_being_called_function_number][0].type1 != type_curr)
				semantic_error( 394, "Mismatch in function parameter 1 type: '" + function_name + "', '" + gfunction_arguments[function_being_called_function_number][0].type1 + "' and '" + type_curr + "'." );

			if (gfunction_arguments[function_being_called_function_number][1].type1 != token_text_bool)
				semantic_error( 395, "Mismatch in function parameter 2 type: '" + function_name + "', '" + gfunction_arguments[function_being_called_function_number][1].type1 + "' and '" + token_text_bool + "'." );
		}
	}
	
	 	
	bool is_numeric_type( string& type1 )
	{
		if (type1 == token_text_int || 
			type1 == token_text_double || 
			type1 == token_text_decimal)
			return (true);
		else
			return (false);
	}



		//---------------------------------------------------------------------------------------------------------------------
		// Icode optimisations
		//---------------------------------------------------------------------------------------------------------------------
		
	void optimise_icode()
	{
		int ic_ptr;
			
		for (ic_ptr=0; ic_ptr < gruntime_data->ic_end - 1; ic_ptr++)
		{
			if (gruntime_data->ic[ic_ptr].op == OP_PUSH_ADDR_GLOBAL_VAR &&
				gruntime_data->ic[ic_ptr+1].op == OP_PUSH_VAR &&
				gruntime_data->ic[ic_ptr+1].size == 1 &&
				gruntime_data->ic[ic_ptr+1].push_flags == 0)
			{
				gruntime_data->ic[ic_ptr].op = OP_PUSH_VAR_1_GLOBAL;
				gruntime_data->ic[ic_ptr+1].op = OP_NULL_ENTRY;
			}

			if (gruntime_data->ic[ic_ptr].op == OP_PUSH_ADDR_LOC_VAR &&
				gruntime_data->ic[ic_ptr+1].op == OP_PUSH_VAR &&
				gruntime_data->ic[ic_ptr+1].size == 1 &&
				gruntime_data->ic[ic_ptr+1].push_flags == 0)
			{
				gruntime_data->ic[ic_ptr].op = OP_PUSH_VAR_1_LOC;
				gruntime_data->ic[ic_ptr+1].op = OP_NULL_ENTRY;
			}

			if (gruntime_data->ic[ic_ptr].op == OP_PUSH_ADDR_FUNCTION_PARAMETER &&
				gruntime_data->ic[ic_ptr+1].op == OP_PUSH_VAR &&
				gruntime_data->ic[ic_ptr+1].size == 1 &&
				gruntime_data->ic[ic_ptr+1].push_flags == 0)
			{
				gruntime_data->ic[ic_ptr].op = OP_PUSH_VAR_1_FUNCTION_PARAMETER;
				gruntime_data->ic[ic_ptr+1].op = OP_NULL_ENTRY;
			}
		}
	}
	
	
	
	
	void set_op_descriptions( string op_descriptions[MAX_NUMBER_OF_OPS] )  						
	{
		int i;
		
		for (i=0; i <= NUM_OPS - 1; i++)
			op_descriptions[i] = "";
	
	
			// 1. Relational operations ==, !=, <, >, <=, >=
	
		op_descriptions[1] = "OP_EQ_INT";
		op_descriptions[2] = "OP_NE_INT";
		op_descriptions[3] = "OP_LT_INT";
		op_descriptions[4] = "OP_GT_INT";
		op_descriptions[5] = "OP_LE_INT";
		op_descriptions[6] = "OP_GE_INT";
	
		op_descriptions[7] = "OP_EQ_DOUBLE";
		op_descriptions[8] = "OP_NE_DOUBLE";
		op_descriptions[9] = "OP_LT_DOUBLE";
		op_descriptions[10] = "OP_GT_DOUBLE";
		op_descriptions[11] = "OP_LE_DOUBLE";
		op_descriptions[12] = "OP_GE_DOUBLE";
	
		op_descriptions[13] = "OP_EQ_DECIMAL";
		op_descriptions[14] = "OP_NE_DECIMAL";
		op_descriptions[15] = "OP_LT_DECIMAL";
		op_descriptions[16] = "OP_GT_DECIMAL";
		op_descriptions[17] = "OP_LE_DECIMAL";
		op_descriptions[18] = "OP_GE_DECIMAL";
	
		op_descriptions[19] = "OP_EQ_STRING";
		op_descriptions[20] = "OP_NE_STRING";
		op_descriptions[21] = "OP_LT_STRING";
		op_descriptions[22] = "OP_GT_STRING";
		op_descriptions[23] = "OP_LE_STRING";
		op_descriptions[24] = "OP_GE_STRING";
	
		op_descriptions[25] = "OP_EQ_BOOL";
		op_descriptions[26] = "OP_NE_BOOL";
		
		op_descriptions[27] = "OP_EQ_BINARY";
		op_descriptions[28] = "OP_NE_BINARY";
		
		op_descriptions[29] = "OP_EQ_LINK";
		op_descriptions[30] = "OP_NE_LINK";
			
					
			// 2. Arithmetic operations +, -, *, /, ^, mod
							
		op_descriptions[31] = "OP_ADD_INT";
		op_descriptions[32] = "OP_SUBTRACT_INT";
		op_descriptions[33] = "OP_MULT_INT";
		op_descriptions[34] = "OP_DIVIDE_INT";
		op_descriptions[35] = "OP_EXP_INT";
		op_descriptions[36] = "OP_MOD_INT";
		op_descriptions[37] = "OP_NEGATE_INT";
		
		op_descriptions[38] = "OP_ADD_DOUBLE";
		op_descriptions[39] = "OP_SUBTRACT_DOUBLE";
		op_descriptions[40] = "OP_MULT_DOUBLE";
		op_descriptions[41] = "OP_DIVIDE_DOUBLE";
		op_descriptions[42] = "OP_EXP_DOUBLE";
		op_descriptions[43] = "OP_NEGATE_DOUBLE";
		
		op_descriptions[44] = "OP_ADD_DECIMAL";
		op_descriptions[45] = "OP_SUBTRACT_DECIMAL";
		op_descriptions[46] = "OP_MULT_DECIMAL";
		op_descriptions[47] = "OP_DIVIDE_DECIMAL";
		op_descriptions[48] = "OP_EXP_DECIMAL";
		op_descriptions[49] = "OP_NEGATE_DECIMAL";
	
	
			// 3. Push
	
		op_descriptions[50] = "OP_PUSH_VAR";
		op_descriptions[51] = "OP_PUSH_NEW_ALLOC";
		op_descriptions[52] = "OP_PUSH_VAR_1_GLOBAL";
		op_descriptions[53] = "OP_PUSH_DEREFERENCE_0";
		op_descriptions[54] = "OP_PUSH_ADDR_GLOBAL_VAR";
		op_descriptions[55] = "OP_PUSH_ADDR_LOC_VAR";
		op_descriptions[57] = "OP_PUSH_ADDR_FUNCTION_PARAMETER";
		op_descriptions[56] = "OP_PUSH_ADDR_SP_REL";
	
		op_descriptions[58] = "OP_PUSH_CONST_LINK";
		op_descriptions[59] = "OP_PUSH_CONST_INT";
		op_descriptions[60] = "OP_PUSH_CONST_DECIMAL";
		op_descriptions[61] = "OP_PUSH_CONST_DOUBLE";
		op_descriptions[62] = "OP_PUSH_CONST_STRING";
		op_descriptions[63] = "OP_PUSH_CONST_BOOL";
		op_descriptions[64] = "OP_PUSH_VAR_1_LOC";
		op_descriptions[65] = "OP_PUSH_VAR_1_FUNCTION_PARAMETER";
	
	
			// 4. Pop
						
		op_descriptions[66] = "OP_POP_VAR";
		op_descriptions[67] = "OP_POP_DISCARD";
		op_descriptions[68] = "..";
		op_descriptions[69] = "..";
		op_descriptions[70] = "..";
		op_descriptions[71] = "..";
	
	
			// 5. Stack 2 operations
			
		op_descriptions[72] = "OP_PREP_FOR_MEMBER_FUNC_CALL";
		op_descriptions[73] = "OP_PUSH_SP_ONTO_ST2";
		op_descriptions[74] = "..";
		op_descriptions[75] = "..";
		op_descriptions[76] = "OP_MOVE_SP_VALUE_TO_ST2";
		op_descriptions[77] = "OP_SET_ST2_PTR_TO_SP";
			
			
			// 6. Type conversions
					
		op_descriptions[78] = "OP_CONV_INT_TO_STRING";
		op_descriptions[79] = "OP_CONV_DOUBLE_TO_STRING";
		op_descriptions[80] = "OP_CONV_DECIMAL_TO_STRING";
		op_descriptions[81] = "OP_CONV_BOOL_TO_STRING";
		op_descriptions[82] = "OP_CONV_BINARY_TO_STRING";
		op_descriptions[83] = "OP_CONV_LINK_TO_STRING";
		
		op_descriptions[84] = "OP_CONV_INT_TO_DECIMAL";
		op_descriptions[85] = "OP_CONV_INT_TO_DOUBLE";
		op_descriptions[86] = "OP_CONV_DOUBLE_TO_INT";
		op_descriptions[87] = "OP_CONV_DOUBLE_TO_DECIMAL";
		op_descriptions[88] = "OP_CONV_DECIMAL_TO_DOUBLE";
		op_descriptions[89] = "OP_CONV_DECIMAL_TO_INT";
	
	
			// 7. +=, -= etc
	
		op_descriptions[90] = "OP_PLUS_EQ_ADD_INT";
		op_descriptions[91] = "OP_PLUS_EQ_SUBTRACT_INT";
		op_descriptions[92] = "OP_PLUS_EQ_MULT_INT";
		op_descriptions[93] = "OP_PLUS_EQ_DIV_INT";
	
		op_descriptions[94] = "OP_PLUS_EQ_ADD_DOUBLE";
		op_descriptions[95] = "OP_PLUS_EQ_SUBTRACT_DOUBLE";
		op_descriptions[96] = "OP_PLUS_EQ_MULT_DOUBLE";
		op_descriptions[97] = "OP_PLUS_EQ_DIV_DOUBLE";
	
		op_descriptions[98] = "OP_PLUS_EQ_ADD_DECIMAL";
		op_descriptions[99] = "OP_PLUS_EQ_SUBTRACT_DECIMAL";
		op_descriptions[100] = "OP_PLUS_EQ_MULT_DECIMAL";
		op_descriptions[101] = "OP_PLUS_EQ_DIV_DECIMAL";
	
		op_descriptions[102] = "OP_PLUS_EQ_CONCAT_STR";
		
		
			// 8. Other operations
			
		op_descriptions[103] = "OP_STRCONCAT";
		op_descriptions[104] = "OP_ADD_CONST_TO_SP_ITEM";
		op_descriptions[105] = "OP_DUPLICATE";
		op_descriptions[106] = "OP_ARRAY_BOUNDS_CHECK";
		op_descriptions[107] = "OP_BULK_COPY";
		op_descriptions[108] = "OP_BULK_COPY_REVS";
		op_descriptions[109] = "OP_ADD_TO_POINTER";
		op_descriptions[110] = "OP_INC_SP";
		op_descriptions[111] = "OP_VAR_INC";
		op_descriptions[112] = "OP_VAR_DEC";
		op_descriptions[113] = "OP_DEALLOC";
		op_descriptions[114] = "OP_RARRAY_SETSIZE";
		op_descriptions[115] = "OP_RARRAY_DEREFERENCE";
		op_descriptions[116] = "OP_STRCONCAT_N_ITEMS";
		op_descriptions[154] = "OP_FOR_LOOP_1";
		op_descriptions[155] = "OP_FOR_LOOP_2";
	
	
			// 9. System functions
			
//		op_descriptions[117] = "OP_LINK_MODULE";
		op_descriptions[118] = "OP_NULL_ENTRY";
		op_descriptions[119] = "OP_LABEL";
		op_descriptions[120] = "OP_ERROR";
			
	
			// 10. Functions
	
		op_descriptions[121] = "OP_CALL_SYSTEM_FUNCTION";
		op_descriptions[122] = "OP_CALL_USER_FUNCTION";
		op_descriptions[123] = "OP_START_FUNCTION";
		op_descriptions[124] = "OP_END_FUNCTION";
//		op_descriptions[125] = "OP_END_MAIN_FUNCTION";
		op_descriptions[126] = "OP_CALL_TABLE_FUNCTION";
		op_descriptions[127] = "OP_CALL_TABLE_FUNCTION_BY_NUMBER";
			
			
			// 11. Jumps
			
		op_descriptions[128] = "OP_JMP";
		op_descriptions[129] = "OP_JMP_TRUE";
		op_descriptions[130] = "OP_JMP_FALSE";
		op_descriptions[131] = "OP_JMP_TRUE_DONT_POP";
		op_descriptions[132] = "OP_JMP_FALSE_DONT_POP";
		op_descriptions[133] = "..";
		op_descriptions[134] = "OP_JMP_NULL";
		op_descriptions[135] = "..";
		op_descriptions[136] = "OP_JMP_LE_0_DONT_POP";
		op_descriptions[137] = "OP_POP_JMP_LE";
		op_descriptions[138] = "..";
		op_descriptions[139] = "..";
	
		op_descriptions[140] = "OP_EQ_INT_JMP";
		op_descriptions[141] = "OP_EQ_DOUBLE_JMP";
		op_descriptions[142] = "OP_EQ_DECIMAL_JMP";
		op_descriptions[143] = "OP_EQ_BOOL_JMP";
		op_descriptions[144] = "OP_EQ_STRING_JMP";
	
		op_descriptions[145] = "OP_NEQ_INT_JMP";
		op_descriptions[146] = "OP_NEQ_DOUBLE_JMP";
		op_descriptions[147] = "OP_NEQ_DECIMAL_JMP";
		op_descriptions[148] = "OP_NEQ_BOOL_JMP";
		op_descriptions[149] = "OP_NEQ_STRING_JMP";
		
	
			// 12. Boolean operators, and or xor not
			
		op_descriptions[150] = "OP_AND";
		op_descriptions[151] = "OP_OR";
		op_descriptions[152] = "OP_XOR";
		op_descriptions[153] = "OP_NOT";

		
			// 13. Variable initialisation
		
		op_descriptions[171] = "OP_VPTR_SET_LOC";
		op_descriptions[176] = "OP_VPTR_SET_GLOBAL";
		op_descriptions[172] = "OP_VPTR_REPEAT_1";
		op_descriptions[173] = "OP_VPTR_REPEAT_2";
		
		op_descriptions[156] = "OP_VPTR_SET_INT_TO_0";
		op_descriptions[157] = "OP_VPTR_SET_DECIMAL_TO_0";
		op_descriptions[158] = "OP_VPTR_SET_DOUBLE_TO_0";
		op_descriptions[159] = "OP_VPTR_SET_STRING_TO_NULL";
		op_descriptions[160] = "OP_VPTR_SET_DATE_TO_NULL";
		op_descriptions[161] = "OP_VPTR_SET_TIME_TO_NULL";
		op_descriptions[162] = "OP_VPTR_SET_DATETIME_TO_NULL";
		op_descriptions[163] = "OP_VPTR_SET_BINARY_TO_NULL";
		op_descriptions[174] = "OP_VPTR_SET_PTR_TO_NULL";
		op_descriptions[175] = "OP_VPTR_SET_AS_EMPTY";
	
		op_descriptions[164] = "OP_VPTR_SET_INT";
		op_descriptions[165] = "OP_VPTR_SET_DECIMAL";
		op_descriptions[166] = "OP_VPTR_SET_DOUBLE";
		op_descriptions[167] = "OP_VPTR_SET_STRING";
		op_descriptions[168] = "OP_VPTR_SET_DATE";
		op_descriptions[169] = "OP_VPTR_SET_TIME";
		op_descriptions[170] = "OP_VPTR_SET_DATETIME";


			// 14. Stack 3 instructions

		op_descriptions[177] = "OP_COPY_TO_ST3";
		op_descriptions[178] = "OP_RESET_ST3_POINTER";

	}

