

float page_height;
float page_width;

const int MAX_FONT_NAME_SIZE	= 200;


char pdf_font_name[MAX_FONT_NAME_SIZE];

	char *_ci_calc_pdf_create( ci_var *result, double arg1, double arg2, ci_var *arg3, ci_var *arg4, ci_var *arg5, ci_var *arg6, ci_var *arg7, ci_var *arg8 )
	{
		double width;
		double height;
		struct pdf_doc *pdf;
		struct pdf_info info;
		char creator[MEDIUM_STRING_BUFFER_SIZE];
        char producer[MEDIUM_STRING_BUFFER_SIZE];
        char title[MEDIUM_STRING_BUFFER_SIZE];
        char author[MEDIUM_STRING_BUFFER_SIZE];
        char subject[MEDIUM_STRING_BUFFER_SIZE];
        char date[MEDIUM_STRING_BUFFER_SIZE];

		ci_var_check_s( arg3 );
		ci_var_check_s( arg4 );
		ci_var_check_s( arg5 );
		ci_var_check_s( arg6 );
		ci_var_check_s( arg7 );
		ci_var_check_s( arg8 );

		ci_str_u32_to_u8( creator, arg3->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		ci_str_u32_to_u8( producer, arg4->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		ci_str_u32_to_u8( title, arg5->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		ci_str_u32_to_u8( author, arg6->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		ci_str_u32_to_u8( subject, arg7->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		ci_str_u32_to_u8( date, arg8->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		
		strcpy( info.creator, creator );
        strcpy( info.producer, producer );
        strcpy( info.title, title );
        strcpy( info.author, author );
        strcpy( info.subject, subject );
        strcpy( info.date, date );
		
		height = arg1;
		width = arg2;
		
		page_height = height;
		page_width = width;
		
		pdf = pdf_create( width, height, &info );
		
		pdf_append_page( pdf );
		
		pdf_set_font( pdf, "Helvetica" );

		strncpy( pdf_font_name, "Helvetica", MAX_FONT_NAME_SIZE );
		
		pdf_font_name[MAX_FONT_NAME_SIZE] = '\0';

		ci_var_set_p( result, (char *) pdf );
		
		return ((char *) result);
	} 

                           
	void _ci_calc_pdf_free( ci_var *arg1 )
	{
		pdf_destroy( (struct pdf_doc *) arg1->data.pvalue );
	}


	char *_ci_calc_pdf_get_error( ci_var *result, ci_var *arg1 )
	{
		int err_val;
		char *str;
				
		str = (char *) pdf_get_err( (struct pdf_doc *) arg1->data.pvalue, &err_val );

		ci_var_set_s( result, str );

		return ((char *) result);
	} 
	

	void _ci_calc_pdf_clear_error( ci_var *arg1 )
	{
		pdf_clear_err( (struct pdf_doc *) arg1->data.pvalue );
	}


	void _ci_calc_pdf_set_font( ci_var *arg1, ci_var *arg2 )
	{
		char str[MEDIUM_STRING_BUFFER_SIZE];
		
		ci_var_check_s( arg2 );
		
		ci_str_u32_to_u8( str, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

		pdf_set_font( (struct pdf_doc *) arg1->data.pvalue, str );

		strncpy( pdf_font_name, str, MAX_FONT_NAME_SIZE );
		
		pdf_font_name[MAX_FONT_NAME_SIZE] = '\0';
	}


	double _ci_calc_pdf_get_text_width( ci_var *arg1, ci_var *arg2, ci_var *arg3, double arg4 )
	{
		char font_name[MAX_FONT_NAME_SIZE];
		char text[MEDIUM_STRING_BUFFER_SIZE];
		float text_width;
		
		ci_var_check_s( arg2 );
		ci_var_check_s( arg3 );

		ci_str_u32_to_u8( font_name, arg2->data.svalue, MAX_FONT_NAME_SIZE );
		ci_str_u32_to_u8( text, arg3->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

		pdf_get_font_text_width( (struct pdf_doc *) arg1->data.pvalue, font_name, text, arg4, &text_width );

		return (text_width); 
	}


	void _ci_calc_pdf_new_page( ci_var *arg1 )
	{
		pdf_append_page( (struct pdf_doc *) arg1->data.pvalue );
	}


	void _ci_calc_pdf_save_to_file( ci_var *arg1, ci_var *arg2 )
	{
		char filename[MEDIUM_STRING_BUFFER_SIZE];
		
		ci_var_check_s( arg2 );
		
		ci_str_u32_to_u8( filename, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
	
		pdf_save( (struct pdf_doc *) arg1->data.pvalue, (const char *) filename );
	}


	void _ci_calc_pdf_add_text( ci_var *arg1, ci_var *arg2, double arg3, double arg4, double arg5 )
	{
		char text[MEDIUM_STRING_BUFFER_SIZE];
		
		ci_var_check_s( arg2 );
		
		ci_str_u32_to_u8( text, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
					
		pdf_add_text( (struct pdf_doc *) arg1->data.pvalue, NULL, (const char *) text, arg3, arg5, page_height - arg4, 0 );
	}


	void _ci_calc_pdf_add_text_right_align( ci_var *arg1, ci_var *arg2, double arg3, double arg4, double arg5 )
	{
		float text_width;
		char text[MEDIUM_STRING_BUFFER_SIZE];
		
		ci_var_check_s( arg2 );
		
		ci_str_u32_to_u8( text, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
					
		pdf_get_font_text_width( (struct pdf_doc *) arg1->data.pvalue, pdf_font_name, (const char *) text, arg3, &text_width );
					
		pdf_add_text( (struct pdf_doc *) arg1->data.pvalue, NULL, (const char *) text, arg3, arg5 - text_width, page_height - arg4, 0 );
	}

	void _ci_calc_pdf_add_text_center_within_field( ci_var *arg1, ci_var *arg2, double arg3, double arg4, double arg5, double arg6 )
	{
		float text_width;
		char text[MEDIUM_STRING_BUFFER_SIZE];
		float start_pos;
		
		ci_var_check_s( arg2 );
		
		ci_str_u32_to_u8( text, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
					
		
		pdf_get_font_text_width( (struct pdf_doc *) arg1->data.pvalue, pdf_font_name, (const char *) text, arg3, &text_width );

		start_pos = arg5 + (arg6 - text_width) / 2;
		 					
		pdf_add_text( (struct pdf_doc *) arg1->data.pvalue, NULL, (const char *) text, arg3, start_pos, page_height - arg4, 0 );
	}

	void _ci_calc_pdf_add_text2( ci_var *arg1, ci_var *arg2, double arg3, double arg4, double arg5, long int arg6, long int arg7, double arg8 )
	{
		char text[MEDIUM_STRING_BUFFER_SIZE];
		char *ptr;
		float max_width;
		float text_width;
		int truncation_type;
		
		ci_var_check_s( arg2 );
		
		ci_str_u32_to_u8( text, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
	
		truncation_type = arg7;
	
		max_width = arg8;
		
		if (truncation_type != 0)
		{
			text_width = 1000000;
		
			while (text_width > max_width && strlen( text ) > 1)
			{
				pdf_get_font_text_width( (struct pdf_doc *) arg1->data.pvalue, pdf_font_name, (const char *) text, arg3, &text_width );

				if (text_width > max_width)
				{
					text[strlen(text)-1] = '\0';
				
					if (truncation_type == 2 && strlen( text ) > 1)
					{
						ptr = text + strlen( text ) - 1;
						
						while (ptr > text + 1 && *ptr != ' ')
							--ptr;
	
						while (ptr > text + 1 && *ptr == ' ')
							--ptr;
							
						*(ptr+1) = '\0';
					}
				}
			}
		}
					
		pdf_add_text( (struct pdf_doc *) arg1->data.pvalue, NULL, (const char *) text, arg3, arg5, page_height - arg4, arg6 );
	}

	double _ci_calc_pdf_add_text_wrap( ci_var *arg1, ci_var *arg2, double arg3, double arg4, double arg5, long int arg6, double arg7, double arg8, double arg9, double arg10 )
	{
		char text[MEDIUM_STRING_BUFFER_SIZE];
		char text2[MEDIUM_STRING_BUFFER_SIZE];
		double field_width;
		double y_pos;
		double page_top_margin; 
		double page_bottom_margin;
		double line_spacing; 
		float text_width;
		int i, j;
		int err_val;
		float height;
				
		ci_var_check_s( arg2 );
				
		ci_str_u32_to_u8( text, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

		y_pos = arg5;
	
		field_width = arg7;
	
		line_spacing = arg8;
		
		page_top_margin = arg9;
		 
		page_bottom_margin = arg10;
		
		pdf_get_font_text_width( (struct pdf_doc *) arg1->data.pvalue, pdf_font_name, (const char *) text, arg3, &text_width );
	
		while (text_width > field_width)
		{
			i = 0;
			
			text_width = 0;
			
			while (text_width < field_width)
			{
				strcpy( text2, text );
				
				text2[i] = '\0';
	
				pdf_get_font_text_width( (struct pdf_doc *) arg1->data.pvalue, pdf_font_name, (const char *) text2, arg3, &text_width );
				
				i++;			
			}			

			i--;
			
			j = i;
			
			while (i > 0 && text[i] != ' ')
				i--;

			if (i == 0)
				i = j;
				
			strcpy( text2, text );
				
			text2[i] = '\0';
				
			pdf_add_text( (struct pdf_doc *) arg1->data.pvalue, NULL, (const char *) text2, arg3, arg4, page_height - y_pos, arg6 );
			
			y_pos += line_spacing;
			
			if (y_pos + line_spacing > page_height - page_bottom_margin)
			{
				pdf_append_page( (struct pdf_doc *) arg1->data.pvalue );
				
				y_pos = page_top_margin;
			}
			
			if (text[i] == ' ')
				strcpy( text2, &text[i+1] );
			else
				strcpy( text2, &text[i] );

			strcpy( text, text2 );
			
			pdf_get_font_text_width( (struct pdf_doc *) arg1->data.pvalue, pdf_font_name, (const char *) text, arg3, &text_width );
		}			
	
		pdf_add_text( (struct pdf_doc *) arg1->data.pvalue, NULL, (const char *) text, arg3, arg4, page_height - y_pos, arg6 );
	
		return (y_pos + line_spacing); 
	}


	void _ci_calc_pdf_set_as_portrait( ci_var *arg1 )
	{
		float tmp;
		
		if (page_width > page_height)
		{ 
			tmp = page_height;
			page_height = page_width;
			page_width = tmp;
	
			pdf_page_set_size( (struct pdf_doc *) arg1->data.pvalue, NULL, page_width, page_height );
		}
	}


	void _ci_calc_pdf_set_as_landscape( ci_var *arg1 )
	{
		float tmp;
		
		if (page_height > page_width)
		{ 
			tmp = page_height;
			page_height = page_width;
			page_width = tmp;
	
			pdf_page_set_size( (struct pdf_doc *) arg1->data.pvalue, NULL, page_width, page_height );
		}
	}



/*
int pdf_add_line(struct pdf_doc *pdf, struct pdf_object *page, float x1,
                 float y1, float x2, float y2, float width, uint32_t colour);


int pdf_add_link(struct pdf_doc *pdf, struct pdf_object *page, float x,
                 float y, float width, float height,
                 struct pdf_object *target_page, float target_x,
                 float target_y);

int pdf_add_barcode(struct pdf_doc *pdf, struct pdf_object *page, int code,
                    float x, float y, float width, float height,
                    const char *string, uint32_t colour);


int pdf_add_image_data(struct pdf_doc *pdf, struct pdf_object *page, float x,
                       float y, float display_width, float display_height,
                       const uint8_t *data, size_t len);


int pdf_parse_image_header(struct pdf_img_info *info, const uint8_t *data,
                           size_t length, char *err_msg,
                           size_t err_msg_length);
*/