



//****************************************
// Next available runtime error code: 217
//****************************************




#define NUM_FORMAT_FIXED 		1
#define NUM_FORMAT_FLOATING		2
#define NUM_FORMAT_NEEDED		4
#define NUM_FORMAT_CURRENCY		8
#define NUM_FMT_SCI_NOTATION	16
#define NUM_FORMAT_NO_COMMAS	32

#define NUM_IFORMAT_CURRENCY	1
#define NUM_IFORMAT_NO_COMMAS	2

#define FILE_MODE_READ 			0
#define FILE_MODE_WRITE 		1
#define FILE_MODE_APPEND 		2


#define MAX_OPEN_FILES 			1000
#define MAX_FGETS_INPUT 		100000

#define MAX_POST_ITEMS			2000
#define MAX_POST_KEY_SIZE		100
#define MAX_POST_ITEM_SIZE		50000

#define MAX_SESSION_ITEMS		3000
#define MAX_SESSION_KEY_SIZE	100
#define MAX_SESSION_ITEM_SIZE	50000

#define MAX_GET_ITEMS			100
#define MAX_GET_KEY_SIZE		100
#define MAX_GET_ITEM_SIZE		1000


FILE *ci_open_files[MAX_OPEN_FILES];
int ci_fd_in_use[MAX_OPEN_FILES];

char ci_post_item_key[MAX_POST_ITEMS][MAX_POST_KEY_SIZE + 1];
char *ci_post_item_value[MAX_POST_ITEMS];
char ci_get_item_key[MAX_GET_ITEMS][MAX_GET_KEY_SIZE + 1];
char ci_get_item_value[MAX_GET_ITEMS][MAX_GET_ITEM_SIZE + 1];
char *ci_session_item_key[MAX_SESSION_ITEMS];
char *ci_session_item_value[MAX_SESSION_ITEMS];
int ci_num_get_items;
int ci_num_post_items;
int ci_num_session_items;
int low_res_screen;
char ip_address[200];
int sort_function_number;


int is_web_page;
int memory_report;
int_64 peak_stack_usage;
int_64 stack_size;

int _calcsys_num_function_table_items;
char *_calcsys_function_table_name[10000];
long int (*_calcsys_function_table_ptr[10000])();


#define MAX_STR_SORT_SIGNIFICANT_CHARS	100


typedef struct
{
    int_64 input_array_key;
    char svalue[MAX_STR_SORT_SIGNIFICANT_CHARS];
} sort_item_s;


typedef struct
{
    int_64 input_array_key;
    double nvalue;
} sort_item_n;


typedef struct
{
    int_64 input_array_key;
    void *pvalue;
} sort_item_p;


sort_item_s *sort_items_s;
sort_item_n *sort_items_n;
sort_item_p *sort_items_p;

int sort_compare_n_asc( const void *item1, const void *item2 );
int sort_compare_n_desc( const void *item1, const void *item2 );
int sort_compare_s_asc( const void *item1, const void *item2 );
int sort_compare_s_desc( const void *item1, const void *item2 );

char *sleft( char *dest, char const *src, int_64 len );
char *sright( char *dest, char const *src, int_64 len );
char *smid( char *dest, char const *src, int_64 start, int_64 len );
void str_replace( char *dest, char *src, string str_search, string str_replace );
int_64 str_search( char *src, char *search );
int_64 str_rsearch( char *src, char *search );
void date_from_parts( char *text, int day, int month, int year );
void time_from_parts( char *text, int hour, int minute, int second );
int last_day_of_the_month( int year, int month );


void ci_dec_to_hex( char *dest, unsigned char *src, int_64 num_bytes, int asc, int pad_with_leading_zeros );
void hex_to_binary( unsigned char *dest, char *src );
int_64 hex_to_int( char *src );
unsigned char dec_to_hex_1_nibble( unsigned char i );
unsigned char ci_hex_to_dec_1_char( char ch );
void convert_date_to_yyyymmdd( char *dt, char *this_date, char *date_format );
int ci_check_date_valid( char const *date_text, char const *format );
int ci_check_time_valid( char const *time_text );
int ci_check_datetime_valid( char const *datetime_text );
int is_digit( char ch );
int is_leap_year( int year );
double max( double num1, double num2 );
long convert_date_to_julian( char *this_date );
void convert_julian_to_date( char *str, long J );
int jweekday( long julian_date );
double jtrunc( double num );
void ci_setup_get_and_post_arrays( char const *get_and_post_filename );
void commarise( char *str2, char *str1 );

		void ci_calc_stdlib_init( char const *get_and_post_filename )
		{
		    int i;
			
			srand( time( NULL ) );
					    
		    for (i=0; i < MAX_OPEN_FILES; i++)
		    {
		    	ci_fd_in_use[i] = -1;
		    	ci_open_files[i] = NULL;
		    }
		    
			if (is_web_page && get_and_post_filename != NULL)
		    	ci_setup_get_and_post_arrays( get_and_post_filename );
		}


		void ci_calc_stdlib_exit( char const *get_and_post_filename )
		{
			FILE *fp;
			int i;
			char str[MAX_SESSION_ITEM_SIZE];
			char filename[MEDIUM_STRING_BUFFER_SIZE];
			
			if (is_web_page && ci_num_session_items > 0 && get_and_post_filename != NULL)
			{
				strncpy( filename, get_and_post_filename, 200 );
				
				filename[200] = '\0';
				
				strcat( filename, ".output" );
				
			    fp = fopen( filename, "w" );
			    
				if (fp == NULL)
				{
					printf( "Can't open output file: %s\n", filename );
					exit(1);
				}
				
				for (i=0; i < ci_num_session_items; i++)
				{
					fputs( "SESSION\n", fp );
					fputs( ci_session_item_key[i], fp );
					fputs( "\n", fp );

					str_replace( str, ci_session_item_value[i], "\n", "\\n" );
					
					fputs( str, fp );
					fputs( "\n", fp );
				}
							
				fclose( fp );
			}
		}
		
		
		char *_ci_calc_fopen( ci_var *result, ci_var *arg1, long int arg2, char *open_successful )
		{
			int fd;
			int i;
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			
			ci_var_check_s( arg1 );
			
		    for (i=0; ci_fd_in_use[i] != -1 && i < MAX_OPEN_FILES; i++) ;
		    
		    if (i >= MAX_OPEN_FILES)
				ci_runtime_error( 29, "Too many open files" );
		
			fd = i;
			
			ci_fd_in_use[fd] = 1;

			ci_str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (arg2 == FILE_MODE_READ)
				ci_open_files[fd] = fopen( str1, "r" );
			else
			if (arg2 == FILE_MODE_WRITE)
				ci_open_files[fd] = fopen( str1, "w" );
			else
			if (arg2 == FILE_MODE_APPEND)
				ci_open_files[fd] = fopen( str1, "a" );
			else
				ci_runtime_error( 30, "Invalid file open type parameter." );

			if (ci_open_files[fd] == NULL)
			{
				*open_successful = false;
				fd = -1;
			}
			else
				*open_successful = true;
			
//				/* ci_runtime_error */ ci_runtime_error( 31, "fopen() returned NULL" );
				
			*((long int *) result) = fd;
			
			return ((char *) result);
		}

		char *_ci_calc_fgets( ci_var *result, ci_var *arg )
		{
			char str[MAX_FGETS_INPUT];
			int arg1;

			arg1 = *((long int *) arg);

			str[0] = '\0';
			
			if (arg1 < 0 || arg1 >= MAX_OPEN_FILES) 
				ci_runtime_error( 32, "Invalid fd in fgets()" );

			if (ci_open_files[arg1] == NULL)
				ci_runtime_error( 33, "NULL fd" );
		
			fgets( str, MAX_FGETS_INPUT, ci_open_files[arg1]  );

			ci_var_set_s( result, str );
			
			return ((char *) result);
		}
		
		void _ci_calc_fputs( ci_var *arg1, ci_var *arg )
		{
			char *ptr;
			long int arg2;
			long int len;

			arg2 = *((long int *) arg);
			
			if (arg2 < 0 || arg2 >= MAX_OPEN_FILES) 
				ci_runtime_error( 34, "Invalid fd in fputs()" );

			if (ci_open_files[arg2] == NULL)
				ci_runtime_error( 35, "NULL fd" );
		
			ci_var_check_s( arg1 );
		
			len = *((int_64 *) arg1->data.svalue) + 1;
		
			ptr = (char *) _ci_malloc( len );
			
			ci_str_u32_to_u8( ptr, arg1->data.svalue, len );
		
			fputs( ptr, ci_open_files[arg2] );
			
			_ci_free( ptr );
		}

		char _ci_calc_feof( ci_var *arg )
		{
			int stat;
			int arg1;

			arg1 = *((long int *) arg);

			if (arg1 < 0 || arg1 >= MAX_OPEN_FILES) 
				ci_runtime_error( 36, "Invalid fd in feof()" );

			if (ci_open_files[arg1] == NULL)
				ci_runtime_error( 37, "NULL fd" );
			
			stat = feof( ci_open_files[arg1] );
		
			if (stat != 0)
				return ( true );
			else
				return ( false );
		}
		
		char _ci_calc_fexists( ci_var *arg1 )
		{
			FILE *fp;
			int stat;
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			fp = fopen( str, "r" );
			
			if (fp == NULL)
				stat = false;
			else
			{
				stat = true;
			
				fclose( fp );
			}

			return ( stat );
		}


		char _ci_calc_fis_a_directory( ci_var *arg1 )
		{
			int st;
			struct stat file_info;
			char filename[MEDIUM_STRING_BUFFER_SIZE];
			
			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( filename, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			st = lstat( filename, &file_info );
			
			if (st == -1)
				return ( 0 );
			else			
			if (S_ISDIR( file_info.st_mode ))
				return ( 1 );
			else
				return ( 0 );
		}


		char *_ci_calc_flast_modified_datetime( ci_var *result, ci_var *arg1 )
		{
			int st;
			struct stat file_info;
			char str[MEDIUM_STRING_BUFFER_SIZE];
			char filename[MEDIUM_STRING_BUFFER_SIZE];
			
			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( filename, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			st = lstat( filename, &file_info );
			
			if (st == -1)
				ci_var_set_s( result, "0000-00-00 99:99:99" );
			else
			{
				strftime( str, MEDIUM_STRING_BUFFER_SIZE, "%Y-%m-%d %H:%M:%S", localtime(&(file_info.st_mtime)) );
				
				ci_var_set_s( result, str );
			}
			
			return ((char *) result);
		}


		long int _ci_calc_ffiles_in_folder( ci_var *arg1, ci_var *arg2 )
		{
			DIR *fd;
			struct dirent *in_file;
			int_64 num_items; 
			int_64 len1;
			int_64 array_len_out;
			char out_str[MEDIUM_STRING_BUFFER_SIZE];
			char pathname[MEDIUM_STRING_BUFFER_SIZE];
			rarray *ra_ptr_dest;

			ci_var_check_s( arg1 );

			if (arg2->var_type != VAR_RESIZABLE_ARRAY)
				ci_runtime_error( 38, "Variable type is not a resizable array in ffiles_in_folder(). Call setsize." );
			 
			ra_ptr_dest = (rarray *) arg2->data.pvalue;
			
			array_len_out = ra_ptr_dest->index_size[0];


			ci_str_u32_to_u8( pathname, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			num_items = 0;
			
			len1 = *((int_64 *) arg1->data.svalue);

			if (len1 == 0)
				ci_var_set_s( (ci_var *) ra_ptr_dest->datap, "" );
			else
			{
				fd = opendir( pathname );
				
				if (fd != NULL)
				{
					in_file = readdir( fd );
				
					while (in_file)
					{
						if (strcmp( in_file->d_name, "." ) != 0 && strcmp( in_file->d_name, ".." ) != 0)
						{
							if (num_items >= array_len_out)
								ci_runtime_error( 39, "The number of items exceeds the number of items in the output array" );
							
							ci_str_u8_to_u32( out_str, in_file->d_name );

							ci_var_set_s_u32( (ci_var *) (ra_ptr_dest->datap + num_items * sizeof( ci_var )), out_str, false );
							
							num_items++;
						}
						
						in_file = readdir( fd );
					}
					
					closedir( fd );
				}
			}
						
			return ( num_items );
		}
		
		long int _ci_calc_fsize( ci_var *arg1 )
		{
			int_64 fsize;
			FILE *fp;
			char str[MEDIUM_STRING_BUFFER_SIZE];

			ci_var_check_s( arg1 );

			ci_str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			fp = fopen( str, "r" );
			
			if (fp == NULL)
			{
				printf( "Can't open file for fsize(): %s\n", str );
				exit(1);
			}
			
			fseek( fp, (long) 0, SEEK_END );
			
			fsize = ftell( fp );

			rewind( fp );
			
			fclose( fp );
			
			return ( fsize );
		}


		void _ci_calc_fseek( ci_var *arg, long int arg2 )
		{
			int fd;

			fd = *((long int *) arg);
			
			if (fd < 0 || fd >= MAX_OPEN_FILES) 
				ci_runtime_error( 40, "Invalid fd in fseek()" );

			if (ci_open_files[fd] == NULL)
				ci_runtime_error( 41, "NULL fd" );

			fseek( ci_open_files[fd], (long) arg2, SEEK_SET );
		}


		long int _ci_calc_fcurrent_position( ci_var *arg1 )
		{
			int fd;

			fd = *((long int *) arg1);

			if (fd < 0 || fd >= MAX_OPEN_FILES) 
				ci_runtime_error( 42, "Invalid fd in fcurrent_position()" );

			if (ci_open_files[fd] == NULL)
				ci_runtime_error( 43, "NULL fd" );
			
			return ( ftell( ci_open_files[fd] ) );
		}

		
		char *_ci_calc_ffile_get_contents_text( ci_var *result, ci_var *arg1 )
		{
			int_64 fsize;
			FILE *fp;
			char *ptr;
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			ci_var_check_s( arg1 );

			ci_str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			fp = fopen( str, "r" );
			
			if (fp == NULL)
			{
				printf( "File '%s' not found\n", str );
				exit(1);
			}
			
			fseek( fp, (long) 0, SEEK_END );
			
			fsize = ftell( fp );

			ptr = (char *) _ci_malloc( fsize + 1 );

			fseek( fp, (long) 0, SEEK_SET );
			
			fread( ptr, fsize, 1, fp );
			
			fclose( fp );
			
			ptr[fsize] = '\0';
			
			ci_var_set_s( result, ptr );
			
			_ci_free( ptr );
			
			return ((char *) result);
		}


		void _ci_calc_ffile_get_contents_binary( ci_var *arg1, ci_var *arg2 )
		{
			int_64 fsize;
			FILE *fp;
			char *ptr;
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			ci_var_check_s( arg1 );

			if (arg2->var_type != VAR_BINARY)
				ci_runtime_error( 44, "Variable is not a binary variable" );

			ci_str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			fp = fopen( str, "r" );
			
			if (fp == NULL)
			{
				printf( "File '%s' not found\n", str );
				exit(1);
			}
			
			fseek( fp, (long) 0, SEEK_END );
			
			fsize = ftell( fp );

			ptr = (char *) _ci_malloc( fsize + sizeof( int_64 ) );

			fseek( fp, (long) 0, SEEK_SET );
			
			fread( ptr + sizeof( int_64 ), fsize, 1, fp );
			
			fclose( fp );
			
			if (arg2->data.bvalue != NULL)
				_ci_free( arg2->data.bvalue );

			*((int_64 *) ptr) = fsize;
			
			arg2->data.bvalue = (unsigned char *) ptr;
		}

		
		void _ci_calc_fdelete( ci_var *arg1 )
		{
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			ci_var_check_s( arg1 );

			ci_str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		
			remove( str );
		}
		
		void _ci_calc_fclose( ci_var *arg )
		{
			int arg1;

			arg1 = *((long int *) arg);
		
			if (arg1 < 0 || arg1 >= MAX_OPEN_FILES) 
				ci_runtime_error( 45, "Invalid fd in fclose()" );

			if (ci_open_files[arg1] == NULL)
				ci_runtime_error( 46, "NULL fd" );
			 	
			fclose( ci_open_files[arg1] );

			ci_fd_in_use[arg1] = -1;

	    	ci_open_files[arg1] = NULL;
		}

		
		long int _ci_calc_fread( ci_var *arg1, long int arg2, ci_var *arg )
		{
			int_64 len;
			int_64 len2;
			int_64 num;
			unsigned char *ptr;
			int arg3;

			arg3 = *((long int *) arg);
			
			if (arg3 < 0 || arg3 >= MAX_OPEN_FILES) 
				ci_runtime_error( 47, "Invalid fd in fread()" );

			if (ci_open_files[arg3] == NULL)
				ci_runtime_error( 48, "NULL fd" );

			len = arg2;

			if (arg1->var_type == VAR_BINARY)
			{			
				len2 = *((int_64 *) (arg1->data.bvalue));
			
				if (len > len2)
				{
					ptr = (unsigned char *) _ci_malloc( len + sizeof( int_64 ) );
				
					_ci_free( arg1->data.bvalue );
	
					arg1->data.bvalue = (unsigned char *) ptr;
				}
			}
			else
			{
				ci_free_curr_mem_1( arg1 );
						
				arg1->data.bvalue = (unsigned char *) _ci_malloc( len + sizeof( int_64 ) );
				
				arg1->var_type = VAR_BINARY;
			}
			
			num = fread( arg1->data.bvalue + sizeof( int_64 ), len, 1, ci_open_files[arg3] );
			
			return ( num );
		}
		
		
		void _ci_calc_fwrite( ci_var *arg1, long int arg2, ci_var *arg )
		{
			int_64 len;
			int arg3;

			arg3 = *((long int *) arg);
			
			if (arg1->var_type != VAR_BINARY)
				ci_runtime_error( 49, "Variable is not a binary variable" );
			
			if (arg3 < 0 || arg3 >= MAX_OPEN_FILES) 
				ci_runtime_error( 50, "Invalid fd in fwrite()" );

			if (ci_open_files[arg3] == NULL)
				ci_runtime_error( 51, "NULL fd" );
			
			if (((ci_var *) arg1)->data.bvalue == NULL)
				ci_runtime_error( 52, "NULL bvalue in fwrite" );
			
			len = *((int_64 *) (((ci_var *) arg1)->data.bvalue));
			
			if (arg2 > len)
				ci_runtime_error( 53, "Bytes to write exceeds data length" );

			fwrite( arg1->data.bvalue + sizeof( int_64 ), arg2, 1, ci_open_files[arg3] );
		}
		
		
		void _ci_calc_mkdir( ci_var *arg1, long int arg2 )
		{
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			ci_var_check_s( arg1 );
		
			ci_str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		
			mkdir( str, arg2 );
		}

		void _ci_calc_print( ci_var *arg1 )
		{
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			ci_var_check_s( arg1 );

			ci_str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		
//			if (is_web_page)
//				printf( "%s<br>", str );
//			else
				printf( "%s\n", str );
		}

		
		void _ci_calc_output( ci_var *arg1 )
		{
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			ci_var_check_s( arg1 );

			ci_str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		
//			fputs( str, stdout );
			
			printf( "%s", str );
		}


		char *_ci_calc_input_string( ci_var *result )
		{
			char str[MAX_FGETS_INPUT];
		
			fgets( str, MAX_FGETS_INPUT, stdin );

			ci_var_set_s( result, str );
			
			return ((char *) result);
		}
	
	//--------------------------------------------------------------------------
	// Strings
	//--------------------------------------------------------------------------

				
		long int _ci_calc_slength( ci_var *arg1 )
		{
			ci_var_check_s( arg1 );
		
			if (arg1->data.svalue == NULL)
				return ( 0 );
			else
			if (ascii_only)
				return ( *((int_64 *) (arg1->data.svalue)) );
			else
				return ( *((int_64 *) (arg1->data.svalue)) / 4 );
		}
		
				
		char *_ci_calc_sleft( ci_var *result, ci_var *arg1, long int arg2 )
		{
			char *str;
			char str4[MEDIUM_STRING_BUFFER_SIZE + sizeof( int_64 )];
			int_64 len;
			int_64 src_len;
			
			ci_var_check_s( arg1 );
			
			src_len = *((int_64 *) arg1->data.svalue);
			
			if (ascii_only)
				len = arg2;
			else
				len = arg2 * 4;

			if (len < 0)
				ci_runtime_error( 54, "Negative length in sleft()." );
			
			if (len >= src_len)
			{			
				ci_var_set_s_u32( result, arg1->data.svalue, false );
			}			
			else
			{
				if (len >= MEDIUM_STRING_BUFFER_SIZE)
					str = (char *) _ci_malloc( len + sizeof( int_64 ) );
				else
					str = str4;
				
				memcpy( str + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ), len );
				
				*((int_64 *) str) = len;
	
				ci_var_set_s_u32( result, str, false );
				
				if (len >= MEDIUM_STRING_BUFFER_SIZE)
					_ci_free( str );
			}
			
			return ((char *) result);			
		}

				
		char *_ci_calc_sright( ci_var *result, ci_var *arg1, long int arg2 )
		{
			char *str;
			char str4[MEDIUM_STRING_BUFFER_SIZE + sizeof( int_64 )];
			int_64 len;
			int_64 src_len;
			
			ci_var_check_s( arg1 );
			
			src_len = *((int_64 *) arg1->data.svalue);
			
			if (ascii_only)
				len = arg2;
			else
				len = arg2 * 4;
			
			if (len < 0)
				ci_runtime_error( 55, "Negative length in sright()." );
			
			if (len >= src_len)
			{
				ci_var_set_s_u32( result, arg1->data.svalue, false );
			}			
			else
			{
				if (len >= MEDIUM_STRING_BUFFER_SIZE)
					str = (char *) _ci_malloc( len + sizeof( int_64 ) );
				else
					str = str4;
				
				memcpy( str + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ) + src_len - len, len );
				
				*((int_64 *) str) = len;
	
				ci_var_set_s_u32( result, str, false );
				
				if (len >= MEDIUM_STRING_BUFFER_SIZE)
					_ci_free( str );
			}
			
			return ((char *) result);			
		}

		char *_ci_calc_sright_from_pos( ci_var *result, ci_var *arg1, long int arg2 )
		{
			char *str;
			char str4[MEDIUM_STRING_BUFFER_SIZE + sizeof( int_64 )];
			int_64 pos, len;
			int_64 src_len;
			
			ci_var_check_s( arg1 );
			
			src_len = *((int_64 *) arg1->data.svalue);
			
			if (ascii_only)
				pos = arg2;
			else
				pos = arg2 * 4;
			
			if (pos < 0)
				ci_runtime_error( 56, "Negative start pos in sright_from_pos()." );
			
			if (pos >= src_len)
				ci_var_set_s( result, "" );
			else
			{
				len = src_len - pos;
				
				if (len >= MEDIUM_STRING_BUFFER_SIZE)
					str = (char *) _ci_malloc( len + sizeof( int_64 ) );
				else
					str = str4;
				
				memcpy( str + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ) + pos, len );
				
				*((int_64 *) str) = len;
	
				ci_var_set_s_u32( result, str, false );
				
				if (len >= MEDIUM_STRING_BUFFER_SIZE)
					_ci_free( str );
			}
			
			return ((char *) result);			
		}

		char *_ci_calc_smid( ci_var *result, ci_var *arg1, long int arg2, long int arg3 )
		{
			char *str;
			char str4[MEDIUM_STRING_BUFFER_SIZE + sizeof( int_64 )];
			int_64 len;
			int_64 src_len;
			int_64 start;
			
			ci_var_check_s( arg1 );
			
			src_len = *((int_64 *) arg1->data.svalue);

			if (ascii_only)
				start = arg2;
			else
				start = arg2 * 4;

			if (start < 0)
				ci_runtime_error( 57, "Negative start in smid()." );

			if (ascii_only)
				len = arg3;
			else
				len = arg3 * 4;

			if (len < 0)
				ci_runtime_error( 58, "Negative length in smid()." );

			if (start >= src_len)
				ci_runtime_error( 59, "Start position exceeds string length in smid()." );

			if (start + len > src_len)
				len = src_len - start;
				
			if (len >= MEDIUM_STRING_BUFFER_SIZE)
				str = (char *) _ci_malloc( len + sizeof( int_64 ) );
			else
				str = str4;
			
			memcpy( str + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ) + start, len );
			
			*((int_64 *) str) = len;

			ci_var_set_s_u32( result, str, false );
			
			if (len >= MEDIUM_STRING_BUFFER_SIZE)
				_ci_free( str );
				
			return ((char *) result);			
		}

		char *_ci_calc_schar( ci_var *result, ci_var *arg1, long int arg2 )
		{
			char str[SMALL_STRING_BUFFER_SIZE], *ptr, *ptr2;
			int_64 src_len;
			int_64 pos;

			ci_var_check_s( arg1 );

			src_len = *((int_64 *) (arg1->data.svalue));
			
			if (ascii_only)
				pos = arg2;
			else
				pos = arg2 * 4;
				
			if (pos < 0)
				ci_runtime_error( 59, "Negative position in schar()." );
				
			if (pos >= src_len)
				ci_var_set_s( result, "" );
			else
			{
				if (ascii_only)
					*((int_64 *) str) = 1;
				else
					*((int_64 *) str) = 4;
				
				ptr = str + sizeof( int_64 );
				ptr2 = arg1->data.svalue + sizeof( int_64 ) + pos;
				
				*ptr++ = *ptr2++;
				
				if (! ascii_only)
				{
					*ptr++ = *ptr2++;
					*ptr++ = *ptr2++;
					*ptr++ = *ptr2++;
				}
								
				ci_var_set_s_u32( result, str, false );
			}
			
			return ((char *) result);			
		}

		char *_ci_calc_stoupper( ci_var *result, ci_var *arg1 )
		{
			char *str, *ptr, *ptr2;
			char str4[MEDIUM_STRING_BUFFER_SIZE + sizeof( int_64 )];
			int_64 i, src_len;

			ci_var_check_s( arg1 );

			src_len = *((int_64 *) arg1->data.svalue);
		
			if (src_len >= MEDIUM_STRING_BUFFER_SIZE)
				str = (char *) _ci_malloc( src_len + sizeof( int_64 ) );
			else
				str = str4;

			*((int_64 *) str) = src_len;
			
			ptr = str + sizeof( int_64 );
			
			ptr2 = arg1->data.svalue + sizeof( int_64 ); 
			
			
			if (ascii_only)
			{
				for (i=0; i < src_len; i++)
					*ptr++ = toupper( *ptr2++ ); 
			}
			else
			{
				for (i=0; i < src_len; i+=4)
				{
					*ptr++ = toupper( *ptr2++ ); 
					*ptr++ = *ptr2++; 
					*ptr++ = *ptr2++; 
					*ptr++ = *ptr2++; 
				}
			}
						
			ci_var_set_s_u32( result, str, false );
				
			if (src_len >= MEDIUM_STRING_BUFFER_SIZE)
				_ci_free( str );
				
			return ((char *) result);			
		}

		char *_ci_calc_stolower( ci_var *result, ci_var *arg1 )
		{
			char *str, *ptr, *ptr2;
			char str4[MEDIUM_STRING_BUFFER_SIZE + sizeof( int_64 )];
			int_64 i, src_len;

			ci_var_check_s( arg1 );

			src_len = *((int_64 *) arg1->data.svalue);
		
			if (src_len >= MEDIUM_STRING_BUFFER_SIZE)
				str = (char *) _ci_malloc(src_len + sizeof( int_64 ) );
			else
				str = str4;

			*((int_64 *) str) = src_len;

			ptr = str + sizeof( int_64 );
			
			ptr2 = arg1->data.svalue + sizeof( int_64 ); 
				
			if (ascii_only)
			{
				for (i=0; i < src_len; i++)
					*ptr++ = tolower( *ptr2++ ); 
			}
			else
			{				
				for (i=0; i < src_len; i+=4)
				{
					*ptr++ = tolower( *ptr2++ ); 
					*ptr++ = *ptr2++; 
					*ptr++ = *ptr2++; 
					*ptr++ = *ptr2++; 
				}
			}
			
			ci_var_set_s_u32( result, str, false );
				
			if (src_len >= MEDIUM_STRING_BUFFER_SIZE)
				_ci_free( str );
				
			return ((char *) result);			
		}
			

		char _ci_calc_scaseieq( ci_var *arg1, ci_var *arg2 )
		{
			int stat;
			int_64 i;
			int_64 len1, len2;
			char *ptr1, *ptr2;
			
			ci_var_check_s( arg1 );
			ci_var_check_s( arg2 );

			stat = true;
		
			len1 = *((int_64 *) arg1->data.svalue);
			len2 = *((int_64 *) arg2->data.svalue);
		
			if (len1 != len2)
				stat = false;
			else
			{
				ptr1 = arg1->data.svalue + sizeof( int_64 );
				ptr2 = arg2->data.svalue + sizeof( int_64 );
			 
				if (ascii_only)
				{
					for (i=0; stat && (i < len1); i++)
					{
						if (toupper( *ptr1++ ) != toupper( *ptr2++ ))
							stat = false;
					}			
				}
				else				
			 	{
					for (i=0; stat && (i < len1); i+=4)
					{
						if (toupper( *ptr1++ ) != toupper( *ptr2++ ))
							stat = false;
	
						if (*ptr1++ != *ptr2++)
							stat = false;
							
						if (*ptr1++ != *ptr2++)
							stat = false;
							
						if (*ptr1++ != *ptr2++)
							stat = false;
					}
				}			
			}			

			return ( stat );
		}
			

		long int _ci_calc_ssearch( ci_var *arg1, ci_var *arg2 )
		{
			int_64 pos, lst;
			int_64 i, len1, len2;
			char *ptr1, *ptr2;

			pos = -1;
						
			len1 = *((int_64 *) arg1->data.svalue);
			len2 = *((int_64 *) arg2->data.svalue);
			
			ptr1 = arg1->data.svalue + sizeof( int_64 );
			ptr2 = arg2->data.svalue + sizeof( int_64 );
			
			lst = len1 - len2;
			
			if (len2 <= len1)
			{
				if (ascii_only)
				{
					for (i=0; pos == -1 && (i <= lst); i++)
					{
						if (memcmp( ptr1, ptr2, len2 ) == 0)
							pos = i;
						else
							ptr1++;
					}
				}
				else
				{			
					for (i=0; pos == -1 && (i <= lst); i+=4)
					{
						if (memcmp( ptr1, ptr2, len2 ) == 0)
							pos = i / 4;
						else
							ptr1 += 4;
					}
				}
			}
				
			return ( pos );
		}
			

		long int _ci_calc_srsearch( ci_var *arg1, ci_var *arg2 )
		{
			int_64 pos, lst;
			int_64 i, len1, len2;
			char *ptr1, *ptr2;

			pos = -1;
						
			len1 = *((int_64 *) arg1->data.svalue);
			len2 = *((int_64 *) arg2->data.svalue);
			
			ptr1 = arg1->data.svalue + sizeof( int_64 ) + len1 - len2;
			ptr2 = arg2->data.svalue + sizeof( int_64 );
			
			lst = len1 - len2;
			
			if (len2 <= len1)
			{
				if (ascii_only)
				{
					for (i=lst; pos == -1 && (i >= 0); i--)
					{
						if (memcmp( ptr1, ptr2, len2 ) == 0)
							pos = i;
						else
							ptr1--;
					}
				}
				else
				{
					for (i=lst; pos == -1 && (i >= 0); i-=4)
					{
						if (memcmp( ptr1, ptr2, len2 ) == 0)
							pos = i / 4;
						else
							ptr1 -= 4;
					}
				}
			}
				
			return ( pos );
		}

		char *_ci_calc_strim( ci_var *result, ci_var *arg1 )
		{
			char *str;
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			char *start, *end;
			int_64 len, len2;
			
			ci_var_check_s( arg1 );
			
			len = *((int_64 *) arg1->data.svalue);
			
			start = arg1->data.svalue + sizeof( int_64 );

			end = start + len - bytes_per_char;
			 
			while (start < end && (*start == ' ' || *start == '\t' || *start == '\n'|| *start == '\r'))
				start += bytes_per_char;
			
			while (end >= start && (*end == ' ' || *end == '\t' || *end == '\n'|| *end == '\r')) 
				end -= bytes_per_char;
			
			if (end < start)
			{
				ci_var_set_s( result, "" );
			}
			else
			{
				len2 = end - start + bytes_per_char;
					
				str = (char *) _ci_malloc( sizeof( int_64 ) + len2 );

				memcpy( str + sizeof( int_64 ), start, len2 );

				*((int_64 *) str) = len2;

				ci_var_set_s_u32( result, str, false );
				
				_ci_free( str );
			}

			return ((char *) result);			
		}


		char *_ci_calc_sreplace( ci_var *result, ci_var *arg1, ci_var *arg2, ci_var *arg3 )
		{
			char *str, *str2, *ptr1, *ptr4;
			int_64 len1, len2, len3, len4;
			int_64 result_len;
			
			ci_var_check_s( arg1 );
			ci_var_check_s( arg2 );
			ci_var_check_s( arg3 );

			len1 = *((int_64 *) arg1->data.svalue);
			len2 = *((int_64 *) arg2->data.svalue);
			len3 = *((int_64 *) arg3->data.svalue);
			
			result_len = bytes_per_char * len1 + 1;
			
			if (result_len < 1000)
				result_len = 1000;
			
			str = (char *) _ci_malloc( result_len );

			ptr1 = arg1->data.svalue + sizeof( int_64 );
			ptr4 = str + sizeof( int_64 );

			while (ptr1 < arg1->data.svalue + sizeof( int_64 ) + len1)			
			{
				if (memcmp( ptr1, arg2->data.svalue + sizeof( int_64 ), len2 ) == 0)
				{
					if ((ptr4 - str) + len3 >= result_len)
					{
						str2 = (char *) _ci_malloc( result_len * 2 );
						memcpy( str2, str, result_len );
						ptr4 = str2 + (ptr4 - str);
						_ci_free( str );
						str = str2;
						result_len *= 2;
					}
					
					memcpy( ptr4, arg3->data.svalue + sizeof( int_64 ), len3 );
					ptr1 += len2;
					ptr4 += len3;
				}
				else
				{
					if ((ptr4 - str) + bytes_per_char >= result_len)
					{
						str2 = (char *) _ci_malloc( result_len * 2 );
						memcpy( str2, str, result_len );
						ptr4 = str2 + (ptr4 - str);
						_ci_free( str );
						str = str2;
						result_len *= 2;
					}
					
					memcpy( ptr4, ptr1, bytes_per_char );
					ptr1 += bytes_per_char;
					ptr4 += bytes_per_char;
				}
			}
			
			len4 = ptr4 - str - sizeof( int_64 );
			
			*((int_64 *) str) = len4;
	
			ci_var_set_s_u32( result, str, false );
			
			_ci_free( str );
			
			return ((char *) result);			
		}
			
			// sexplode( string s, string delimiter, array string [int variable] receiving_array );

		long int _ci_calc_sexplode( ci_var *arg1, ci_var *arg2, ci_var *arg3 )
		{
			int_64 num_items; 
			int_64 len1, len2;
			char *delimiter;
			char *startp;
			char *endp;
			int_64 array_len_out;
			char *ptr;
			char out_str[MEDIUM_STRING_BUFFER_SIZE];
			rarray *ra_ptr_dest;

			ci_var_check_s( arg1 );
			ci_var_check_s( arg2 );

			if (arg3->var_type != VAR_RESIZABLE_ARRAY)
				ci_runtime_error( 60, "Variable type is not a resizable array in sexplode(). Call setsize." );
			 
			ra_ptr_dest = (rarray *) arg3->data.pvalue;
			
			array_len_out = ra_ptr_dest->index_size[0];
			
			delimiter = arg2->data.svalue + sizeof( int_64 );
			
			ptr = arg1->data.svalue + sizeof( int_64 );

			num_items = 0;
			
			len1 = *((int_64 *) arg1->data.svalue);
			len2 = *((int_64 *) arg2->data.svalue);

			if (len1 == 0 || len2 > len1)
				ci_var_set_s( (ci_var *) ra_ptr_dest->datap, "" );
			else
			{
				startp = ptr;
				endp = ptr + len1;
				
				for (; ptr < endp; ptr += bytes_per_char)
				{
					if (memcmp( ptr, delimiter, len2 ) == 0)
					{
						if (num_items >= array_len_out)
							ci_runtime_error( 61, "The number of items exceeds the number of items in the output array" );

						memcpy( out_str + sizeof( int_64 ), startp, ptr - startp );

						*((int_64 *) out_str) = ptr - startp; 
						
						ci_var_set_s_u32( (ci_var *) (ra_ptr_dest->datap + num_items * sizeof( ci_var )), out_str, false );
	
						startp = ptr + len2;
	
						ptr += len2 - bytes_per_char;
						
						num_items++;
					}
				}
	
				if (startp < endp || memcmp( endp - len2, delimiter, len2 ) == 0)
				{
					if (num_items >= array_len_out)
						ci_runtime_error( 62, "The number of items exceeds the number of items in the output array" );

					memcpy( out_str + sizeof( int_64 ), startp, ptr - startp );

					*((int_64 *) out_str) = ptr - startp; 
							
					ci_var_set_s_u32( (ci_var *) (ra_ptr_dest->datap + num_items * sizeof( ci_var )), out_str, false );
		
					num_items++;
				}
			}
						
			return ( num_items );
		}		

			// sexplode_whitespace( string s, array string [int variable] receiving_array );

		long int _ci_calc_sexplode_whitespace( ci_var *arg1, ci_var *arg2 )
		{
			int_64 num_items, j; 
			int_64 len1;
			char *sp2;
			int_64 array_len_out;
			char *ptr;
			char *ptr2;
			char out_str[MEDIUM_STRING_BUFFER_SIZE];
			ci_var *vptr;
			rarray *ra_ptr_dest;

			ci_var_check_s( arg1 );

			if (arg2->var_type != VAR_RESIZABLE_ARRAY)
				ci_runtime_error( 63, "Variable type is not a resizable array in sexplode_whitespace(). Call setsize." );
			 
			ra_ptr_dest = (rarray *) arg2->data.pvalue;
			
			array_len_out = ra_ptr_dest->index_size[0];
			
			ptr = arg1->data.svalue + sizeof( int_64 );

			ptr2 = out_str + sizeof( int_64 );
			num_items = 0;

			
			len1 = *((int_64 *) arg1->data.svalue);

			if (len1 == 0)
				ci_var_set_s( (ci_var *) ra_ptr_dest->datap, "" );
			else
			{
				while ((*ptr == ' ' || *ptr == '\t' || *ptr == '\r' || *ptr == '\n') &&
						(ptr - arg1->data.svalue) < len1 + sizeof( int_64 )) 
					ptr += bytes_per_char;
	
				for (; (ptr - arg1->data.svalue) < len1 + sizeof( int_64 );)
				{
					if (*ptr == ' ' || *ptr == '\t' || *ptr == '\r' || *ptr == '\n')
					{
						if (num_items >= array_len_out)
							ci_runtime_error( 64, "The number of items exceeds the number of items in the output array" );
						
						*((int_64 *) out_str) = ptr2 - out_str - sizeof( int_64 ); 
						
						ci_var_set_s_u32( (ci_var *) (ra_ptr_dest->datap + num_items * sizeof( ci_var )), out_str, false );
	
						ptr2 = out_str + sizeof( int_64 );
						num_items++;
						
						while ((*ptr == ' ' || *ptr == '\t' || *ptr == '\r' || *ptr == '\n') &&
								(ptr - arg1->data.svalue) < len1 + sizeof( int_64 )) 
							ptr += bytes_per_char;
					}
					else
					{
						memcpy( ptr2, ptr, bytes_per_char );
						ptr2 += bytes_per_char;
						ptr += bytes_per_char;
					}
				}
	
				if (ptr2 > out_str)
				{
					if (num_items >= array_len_out)
						ci_runtime_error( 65, "The number of items exceeds the number of items in the output array" );
	
					*((int_64 *) out_str) = ptr2 - out_str - sizeof( int_64 ); 
							
					ci_var_set_s_u32( (ci_var *) (ra_ptr_dest->datap + num_items * sizeof( ci_var )), out_str, false );
		
					num_items++;
				}
				
				ptr -= bytes_per_char;
							
				if (num_items > 0 && (*ptr == ' ' || *ptr == '\t' || *ptr == '\r' || *ptr == '\n'))
					num_items--;
			}
						
			return ( num_items );
		}		
		
			// sexplode( string s, string delimiter, array string [int variable] receiving_array );

		long int _ci_calc_sexplode_csv( ci_var *arg1, ci_var *arg2, ci_var *arg3 )
		{
			int_64 num_items, j; 
			int_64 len1, len2;
			int in_quote_string;
			int next_item;
			int lst_is_quoted_string;
			char *sp2;
			char *delimiter;
			int_64 array_len_out;
			char *ptr;
			char *ptr2;
			char out_str[MEDIUM_STRING_BUFFER_SIZE];
			ci_var *vptr;
			rarray *ra_ptr_dest;

			ci_var_check_s( arg1 );
			ci_var_check_s( arg2 );

			if (arg3->var_type != VAR_RESIZABLE_ARRAY)
				ci_runtime_error( 66, "Variable type is not a resizable array in sexplode_csv(). Call setsize." );
			 
			ra_ptr_dest = (rarray *) arg3->data.pvalue;
			
			array_len_out = ra_ptr_dest->index_size[0];
			
			delimiter = arg2->data.svalue + sizeof( int_64 );
			
			ptr = arg1->data.svalue + sizeof( int_64 );

			ptr2 = out_str + sizeof( int_64 );
			num_items = 0;
			
			lst_is_quoted_string = false;
			
			len1 = *((int_64 *) arg1->data.svalue);
			len2 = *((int_64 *) arg2->data.svalue);

			in_quote_string = false;

			if (len1 == 0)
				ci_var_set_s( (ci_var *) ra_ptr_dest->datap, "" );
			else
			{
				if (*ptr == '"')
				{
					in_quote_string = true;
					ptr += bytes_per_char;
				}

				next_item = false;
			
				for (; (ptr - arg1->data.svalue) < len1 + sizeof( int_64 ); ptr += bytes_per_char)
				{
					if (in_quote_string && *ptr == '"')
						next_item = true;
				
					if ((! in_quote_string) && memcmp( ptr, delimiter, len2 ) == 0)
						next_item = true;
					
					if (next_item)
					{
						if (num_items >= array_len_out)
							ci_runtime_error( 67, "The number of items exceeds the number of items in the output array" );
						
						*((int_64 *) out_str) = ptr2 - out_str - sizeof( int_64 ); 
						
						ci_var_set_s_u32( (ci_var *) (ra_ptr_dest->datap + num_items * sizeof( ci_var )), out_str, false );
	
						ptr2 = out_str + sizeof( int_64 );
						num_items++;
						
						next_item = false;
						
						ptr += len2 - bytes_per_char;

						if (in_quote_string)
							ptr += bytes_per_char;

						if ((ptr - arg1->data.svalue) >= len1 + sizeof( int_64 ))
							lst_is_quoted_string = true;
						else
						{
							in_quote_string = false;
							
							if ((ptr - arg1->data.svalue) < len1 + sizeof( int_64 ))
							{
								if (*(ptr+bytes_per_char) == '"')
								{
									in_quote_string = true;
									
									ptr += bytes_per_char;
								}
							}
						}						
					}
					else
					{
						memcpy( ptr2, ptr, bytes_per_char );
						ptr2 += bytes_per_char;
					}
				}
	
				if ((! lst_is_quoted_string) && ptr2 > out_str)
				{
					if (num_items >= array_len_out)
						ci_runtime_error( 68, "The number of items exceeds the number of items in the output array" );
	
					if (in_quote_string)
						ptr2 -= bytes_per_char;
					
					*((int_64 *) out_str) = ptr2 - out_str - sizeof( int_64 ); 
							
					ci_var_set_s_u32( (ci_var *) (ra_ptr_dest->datap + num_items * sizeof( ci_var )), out_str, false );
		
					num_items++;
				}
			}
						
			return ( num_items );
		}		
		

		long int _ci_calc_schar_to_int( ci_var *arg1 )
		{
			int_32 ch;

			ci_var_check_s( arg1 );
			
			if (arg1->data.svalue == NULL)
				ci_runtime_error( 69, "NULL string in scalc_char_to_int()" );
			
			ch = *((int_32 *) (arg1->data.svalue + sizeof( int_64 )));
		
			return ( ch );
		}

 
		char *_ci_calc_sint_to_char( ci_var *result, long int arg1 ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			char *ptr;
			
			ptr = str;
			
			*((int_64 *) ptr) = 4;

			*((int_64 *) (ptr + sizeof( int_64 ))) = arg1;
			
			ci_var_set_s_u32( result, str, false );
			
			return ((char *) result);			
		}

	//--------------------------------------------------------------------------
	// Mathematics
	//--------------------------------------------------------------------------
	
		
				
		double _ci_calc_mrand()
		{
			return ( ((double) rand()) / ((double) RAND_MAX) );
		}
			
			
		void _ci_calc_mseed_rand( long int seed )
		{
			srand( seed );
		}
			
				
		long int _ci_calc_mtrunc( double arg1 )
		{
			return ( (long int) arg1 );
		}
			
				
		double _ci_calc_msqrt( double arg1 )
		{
			if (arg1 == 0)
				ci_runtime_error( 70, "Square root of zero" );

			if (arg1 < 0)
				ci_runtime_error( 71, "Square root of a negative number" );
		
			return ( sqrt(arg1) );
		}
			
				
		double _ci_calc_mfabs( double arg1 )
		{
			if (arg1 >= 0)
				return ( arg1 );
			else
				return ( -arg1 );
		}
			
				
		long int _ci_calc_miabs( long int arg1 )
		{
			if (arg1 >= 0)
				return ( arg1 );
			else
				return ( -arg1 );
		}
			
				
		double _ci_calc_mfmax( double arg1, double arg2 )
		{
			if (arg1 >= arg2)
				return ( arg1 );
			else
				return ( arg2 );
		}
					
				
		double _ci_calc_mfmin( double arg1, double arg2 )
		{
			if (arg1 <= arg2)
				return ( arg1 );
			else
				return ( arg2 );
		}
			
				
		long int _ci_calc_mimax( long int arg1, long int arg2 )
		{
			if (arg1 >= arg2)
				return ( arg1 );
			else
				return ( arg2 );
		}
			
				
		long int _ci_calc_mimin( long int arg1, long int arg2 )
		{
			if (arg1 <= arg2)
				return ( arg1 );
			else
				return ( arg2 );
		}
			
				
		double _ci_calc_mlog( double arg1 )
		{
			return ( log( arg1 ) );
		}
	
				
		double _ci_calc_mlog10( double arg1 )
		{
			return ( log10( arg1 ) );
		}
					
				
		double _ci_calc_mexp( double arg1 )
		{
			return ( pow( 2.71828182845904, arg1 ) );
		}
			
				
		double _ci_calc_mround( double arg1, long int arg2 )
		{
			double x;
		
			x = arg1 * pow( 10, arg2 );
			
			x += 0.5;
			
			x = (long int) x;
			
			x = x / pow( 10, arg2 );

			return ( x );
		}

		char *_ci_calc_mformat( ci_var *result, double arg1, long int arg2, long int arg3 )
		{
			char s[MEDIUM_STRING_BUFFER_SIZE];
			char s2[MEDIUM_STRING_BUFFER_SIZE];
			char s3[MEDIUM_STRING_BUFFER_SIZE];
			char fmt[SMALL_STRING_BUFFER_SIZE];
			int i, dec;
			char *pos;
			
			sprintf( s2, "%%.%df", arg3 );
				
			sprintf( s, s2, arg1 );

			ci_trim_trailing_zeros( s );

			s2[0] = '\0';
			
			
			if ((arg2 & NUM_FORMAT_FLOATING) != 0)
			{
				sprintf( s2, "%lf", arg1 );
				
				if ((arg2 & NUM_FORMAT_NO_COMMAS) == 0)
					commarise( s3, s2 );
				else
					strcpy( s3, s2 );
					
				ci_trim_trailing_zeros( s3 );					
			}
			else
			if ((arg2 & NUM_FMT_SCI_NOTATION) != 0)
			{
				sprintf( s2, "%%.%de", arg3 );
				
				sprintf( s3, s2, arg1 );
			}
			else
			if ((arg2 & NUM_FORMAT_NEEDED) != 0)
			{
				pos = strchr( s, (int) '.' );

				strcpy( s2, s );
				
				if (pos != NULL)
				{
					dec = strlen( s ) - (pos - s) - 1;

					if (dec < arg2)
					{
						for (i=0; i < (arg3 - dec); i++)
							strcat( s2, "0" );
					}
				}
				
				if ((arg2 & NUM_FORMAT_NO_COMMAS) == 0)
					commarise( s3, s2 );
				else
					strcpy( s3, s2 );
			}	
			else
			if ((arg2 & NUM_FORMAT_FIXED) != 0 || (arg2 & NUM_FORMAT_CURRENCY) != 0)
			{
				pos = strchr( s, (int) '.' );

				strcpy( s2, s );
				
				if (pos == NULL)
				{
					if (arg3 > 0)
					{
						strcat( s2, "." );
						
						for (i=0; i < arg3; i++)
							strcat( s2, "0" );
					}
				}
				else
				{
					dec = strlen( s ) - (pos - s) - 1;

					if (dec > arg3)
					{
						sleft( s2, s2, strlen( s2 ) - (dec - arg3) );
						
						sright( s3, s2, 1 );
						
						if (strcmp( s3, "." ) == 0)
							sleft( s2, s2, strlen( s2 ) - 1 );
					}
					else
					if (dec < arg3)
					{
						for (i=0; i < arg3 - dec; i++)
							strcat( s2, "0" );
					}
				}
				
				if ((arg2 & NUM_FORMAT_NO_COMMAS) == 0)
					commarise( s3, s2 );
				else
					strcpy( s3, s2 );
			}	

			if ((arg2 & NUM_FORMAT_CURRENCY) != 0)
			{
				pos = strchr( s3, (int) '.' );
				
				if (pos != NULL)
				{
					dec = strlen( s3 ) - (pos - s3) - 1;

					if (dec == 1)
						strcat( s3, "0" );
				}
				
				sleft( s2, s3, 1 );
				
				if (strcmp( s2, "-" ) == 0)
				{
					strcpy( s2, "-$" );
					strcat( s2, s3+1 );
					strcpy( s3, s2 );
				}
				else
				{
					strcpy( s2, "$" );
					strcat( s2, s3 );
					strcpy( s3, s2 );
				}
			}
							
			ci_var_set_s( result, s3 );
			
			return ((char *) result);			
		}

		char *_ci_calc_miformat( ci_var *result, long int arg1, long int arg2 )
		{
			char s2[MEDIUM_STRING_BUFFER_SIZE];
			char s3[MEDIUM_STRING_BUFFER_SIZE];
				
			sprintf( s3, "%ld", arg1 );

			if ((arg2 & NUM_IFORMAT_NO_COMMAS) == 0)
			{
				commarise( s2, s3 );
				strcpy( s3, s2 );
			}

			if ((arg2 & NUM_IFORMAT_CURRENCY) != 0)
			{
				if (arg1 < 0)
				{
					strcpy( s2, "-$" );
					strcat( s2, s3+1 );
					strcpy( s3, s2 );
				}
				else
				{
					strcpy( s2, "$" );
					strcat( s2, s3 );
					strcpy( s3, s2 );
				}
			}
							
			ci_var_set_s( result, s3 );
			
			return ((char *) result);			
		}

		
		double _ci_calc_msin( double arg1 )
		{
			return ( sin( arg1 ) );
		}

				
		double _ci_calc_mcos( double arg1 )
		{
			return ( cos( arg1 ) );
		}

				
		double _ci_calc_mtan( double arg1 )
		{
			return ( tan( arg1 ) );
		}

				
		double _ci_calc_marcsin( double arg1 )
		{
			return ( asin( arg1 ) );
		}

				
		double _ci_calc_marccos( double arg1 )
		{
			return ( acos( arg1 ) );
		}

				
		double _ci_calc_marctan( double arg1 )
		{
			return ( atan( arg1 ) );
		}
		
		
	//--------------------------------------------------------------------------
	//--------------------------------------------------------------------------

		float _ci_calc_mrandf()
		{
			return ( ((float) rand()) / ((float) RAND_MAX) );
		}

		long int _ci_calc_mtruncf( float arg1 )
		{
			return ( (long int) arg1 );
		}
				
		float _ci_calc_msqrtf( float arg1 )
		{
			if (arg1 == 0)
				ci_runtime_error( 72, "Square root of zero" );

			if (arg1 < 0)
				ci_runtime_error( 73, "Square root of a negative number" );
		
			return ( sqrtf(arg1) );
		}
			
				
		float _ci_calc_mfabsf( float arg1 )
		{
			if (arg1 >= 0)
				return ( arg1 );
			else
				return ( -arg1 );
		}
			
				
		float _ci_calc_mfmaxf( float arg1, float arg2 )
		{
			if (arg1 >= arg2)
				return ( arg1 );
			else
				return ( arg2 );
		}
					
				
		float _ci_calc_mfminf( float arg1, float arg2 )
		{
			if (arg1 <= arg2)
				return ( arg1 );
			else
				return ( arg2 );
		}
				
		float _ci_calc_mlogf( float arg1 )
		{
			return ( logf( arg1 ) );
		}
	
				
		float _ci_calc_mlog10f( float arg1 )
		{
			return ( log10f( arg1 ) );
		}
					
				
		float _ci_calc_mexpf( float arg1 )
		{
			return ( powf( 2.71828182845904523536L, arg1 ) );
		}
			
				
		float _ci_calc_mroundf( float arg1, long int arg2 )
		{
			float x;
		
			x = arg1 * pow( 10, arg2 );
			
			x += 0.5;
			
			x = (long int) x;
			
			x = x / pow( 10, arg2 );

			return ( x );
		}

		char *_ci_calc_mformatf( ci_var *result, float arg1, long int arg2, long int arg3 )
		{
			char s[MEDIUM_STRING_BUFFER_SIZE];
			char s2[MEDIUM_STRING_BUFFER_SIZE];
			char s3[MEDIUM_STRING_BUFFER_SIZE];
			char fmt[SMALL_STRING_BUFFER_SIZE];
			int i, dec;
			char *pos;
			
			sprintf( s2, "%%.%ldf", arg3 );
				
			sprintf( s, s2, arg1 );

			ci_trim_trailing_zeros( s );

			s2[0] = '\0';
			
			
			if ((arg2 & NUM_FORMAT_FLOATING) != 0)
			{
				sprintf( s2, "%f", arg1 );
				
				if ((arg2 & NUM_FORMAT_NO_COMMAS) == 0)
					commarise( s3, s2 );
				else
					strcpy( s3, s2 );
					
				ci_trim_trailing_zeros( s3 );					
			}
			else
			if ((arg2 & NUM_FMT_SCI_NOTATION) != 0)
			{
				sprintf( s2, "%%.%de", arg3 );
				
				sprintf( s3, s2, arg1 );
			}
			else
			if ((arg2 & NUM_FORMAT_NEEDED) != 0)
			{
				pos = strchr( s, (int) '.' );

				strcpy( s2, s );
				
				if (pos != NULL)
				{
					dec = strlen( s ) - (pos - s) - 1;

					if (dec < arg2)
					{
						for (i=0; i < (arg3 - dec); i++)
							strcat( s2, "0" );
					}
				}
				
				if ((arg2 & NUM_FORMAT_NO_COMMAS) == 0)
					commarise( s3, s2 );
				else
					strcpy( s3, s2 );
			}	
			else
			if ((arg2 & NUM_FORMAT_FIXED) != 0 || (arg2 & NUM_FORMAT_CURRENCY) != 0)
			{
				pos = strchr( s, (int) '.' );

				strcpy( s2, s );
				
				if (pos == NULL)
				{
					if (arg3 > 0)
					{
						strcat( s2, "." );
						
						for (i=0; i < arg3; i++)
							strcat( s2, "0" );
					}
				}
				else
				{
					dec = strlen( s ) - (pos - s) - 1;

					if (dec > arg3)
					{
						sleft( s2, s2, strlen( s2 ) - (dec - arg3) );
						
						sright( s3, s2, 1 );
						
						if (strcmp( s3, "." ) == 0)
							sleft( s2, s2, strlen( s2 ) - 1 );
					}
					else
					if (dec < arg3)
					{
						for (i=0; i < arg3 - dec; i++)
							strcat( s2, "0" );
					}
				}
				
				if ((arg2 & NUM_FORMAT_NO_COMMAS) == 0)
					commarise( s3, s2 );
				else
					strcpy( s3, s2 );
			}	

			if ((arg2 & NUM_FORMAT_CURRENCY) != 0)
			{
				pos = strchr( s3, (int) '.' );
				
				if (pos != NULL)
				{
					dec = strlen( s3 ) - (pos - s3) - 1;

					if (dec == 1)
						strcat( s3, "0" );
				}
				
				sleft( s2, s3, 1 );
				
				if (strcmp( s2, "-" ) == 0)
				{
					strcpy( s2, "-$" );
					strcat( s2, s3+1 );
					strcpy( s3, s2 );
				}
				else
				{
					strcpy( s2, "$" );
					strcat( s2, s3 );
					strcpy( s3, s2 );
				}
			}
							
			ci_var_set_s( result, s3 );
			
			return ((char *) result);			
		}


		float _ci_calc_msinf( float arg1 )
		{
			return ( sinf( arg1 ) );
		}

				
		float _ci_calc_mcosf( float arg1 )
		{
			return ( cosf( arg1 ) );
		}

				
		float _ci_calc_mtanf( float arg1 )
		{
			return ( tanf( arg1 ) );
		}

				
		float _ci_calc_marcsinf( float arg1 )
		{
			return ( asinf( arg1 ) );
		}

				
		float _ci_calc_marccosf( float arg1 )
		{
			return ( acosf( arg1 ) );
		}

				
		float _ci_calc_marctanf( float arg1 )
		{
			return ( atanl( arg1 ) );
		}
		
		
	//--------------------------------------------------------------------------
	//--------------------------------------------------------------------------

		long double _ci_calc_mrandl()
		{
			return ( ((long double) rand()) / ((long double) RAND_MAX) );
		}

		long int _ci_calc_mtruncl( long double arg1 )
		{
			return ( (long int) arg1 );
		}
				
		long double _ci_calc_msqrtl( long double arg1 )
		{
			if (arg1 == 0)
				ci_runtime_error( 74, "Square root of zero" );

			if (arg1 < 0)
				ci_runtime_error( 75, "Square root of a negative number" );
		
			return ( sqrtl(arg1) );
		}
			
				
		long double _ci_calc_mfabsl( long double arg1 )
		{
			if (arg1 >= 0)
				return ( arg1 );
			else
				return ( -arg1 );
		}
			
				
		long double _ci_calc_mfmaxl( long double arg1, long double arg2 )
		{
			if (arg1 >= arg2)
				return ( arg1 );
			else
				return ( arg2 );
		}
					
				
		long double _ci_calc_mfminl( long double arg1, long double arg2 )
		{
			if (arg1 <= arg2)
				return ( arg1 );
			else
				return ( arg2 );
		}
				
		long double _ci_calc_mlogl( long double arg1 )
		{
			return ( logl( arg1 ) );
		}
	
				
		long double _ci_calc_mlog10l( long double arg1 )
		{
			return ( log10l( arg1 ) );
		}
					
				
		long double _ci_calc_mexpl( long double arg1 )
		{
			return ( powl( 2.71828182845904523536L, arg1 ) );
		}
			
				
		long double _ci_calc_mroundl( long double arg1, long int arg2 )
		{
			long double x;
		
			x = arg1 * pow( 10, arg2 );
			
			x += 0.5;
			
			x = (long int) x;
			
			x = x / pow( 10, arg2 );

			return ( x );
		}

		char *_ci_calc_mformatl( ci_var *result, long double arg1, long int arg2, long int arg3 )
		{
			char s[MEDIUM_STRING_BUFFER_SIZE];
			char s2[MEDIUM_STRING_BUFFER_SIZE];
			char s3[MEDIUM_STRING_BUFFER_SIZE];
			char fmt[SMALL_STRING_BUFFER_SIZE];
			int i, dec;
			char *pos;
			
			sprintf( s2, "%%.%dLf", arg3 );
				
			sprintf( s, s2, arg1 );

			ci_trim_trailing_zeros( s );

			s2[0] = '\0';
			
			
			if ((arg2 & NUM_FORMAT_FLOATING) != 0)
			{
				sprintf( s2, "%Lf", arg1 );
				
				if ((arg2 & NUM_FORMAT_NO_COMMAS) == 0)
					commarise( s3, s2 );
				else
					strcpy( s3, s2 );
					
				ci_trim_trailing_zeros( s3 );					
			}
			else
			if ((arg2 & NUM_FMT_SCI_NOTATION) != 0)
			{
				sprintf( s2, "%%.%de", arg3 );
				
				sprintf( s3, s2, arg1 );
			}
			else
			if ((arg2 & NUM_FORMAT_NEEDED) != 0)
			{
				pos = strchr( s, (int) '.' );

				strcpy( s2, s );
				
				if (pos != NULL)
				{
					dec = strlen( s ) - (pos - s) - 1;

					if (dec < arg2)
					{
						for (i=0; i < (arg3 - dec); i++)
							strcat( s2, "0" );
					}
				}
				
				if ((arg2 & NUM_FORMAT_NO_COMMAS) == 0)
					commarise( s3, s2 );
				else
					strcpy( s3, s2 );
			}	
			else
			if ((arg2 & NUM_FORMAT_FIXED) != 0 || (arg2 & NUM_FORMAT_CURRENCY) != 0)
			{
				pos = strchr( s, (int) '.' );

				strcpy( s2, s );
				
				if (pos == NULL)
				{
					if (arg3 > 0)
					{
						strcat( s2, "." );
						
						for (i=0; i < arg3; i++)
							strcat( s2, "0" );
					}
				}
				else
				{
					dec = strlen( s ) - (pos - s) - 1;

					if (dec > arg3)
					{
						sleft( s2, s2, strlen( s2 ) - (dec - arg3) );
						
						sright( s3, s2, 1 );
						
						if (strcmp( s3, "." ) == 0)
							sleft( s2, s2, strlen( s2 ) - 1 );
					}
					else
					if (dec < arg3)
					{
						for (i=0; i < arg3 - dec; i++)
							strcat( s2, "0" );
					}
				}
				
				if ((arg2 & NUM_FORMAT_NO_COMMAS) == 0)
					commarise( s3, s2 );
				else
					strcpy( s3, s2 );
			}	

			if ((arg2 & NUM_FORMAT_CURRENCY) != 0)
			{
				pos = strchr( s3, (int) '.' );
				
				if (pos != NULL)
				{
					dec = strlen( s3 ) - (pos - s3) - 1;

					if (dec == 1)
						strcat( s3, "0" );
				}
				
				sleft( s2, s3, 1 );
				
				if (strcmp( s2, "-" ) == 0)
				{
					strcpy( s2, "-$" );
					strcat( s2, s3+1 );
					strcpy( s3, s2 );
				}
				else
				{
					strcpy( s2, "$" );
					strcat( s2, s3 );
					strcpy( s3, s2 );
				}
			}
							
			ci_var_set_s( result, s3 );
			
			return ((char *) result);			
		}


		long double _ci_calc_msinl( long double arg1 )
		{
			return ( sinl( arg1 ) );
		}

				
		long double _ci_calc_mcosl( long double arg1 )
		{
			return ( cosl( arg1 ) );
		}

				
		long double _ci_calc_mtanl( long double arg1 )
		{
			return ( tanl( arg1 ) );
		}

				
		long double _ci_calc_marcsinl( long double arg1 )
		{
			return ( asinl( arg1 ) );
		}

				
		long double _ci_calc_marccosl( long double arg1 )
		{
			return ( acosl( arg1 ) );
		}

				
		long double _ci_calc_marctanl( long double arg1 )
		{
			return ( atanl( arg1 ) );
		}
		

		void commarise( char *str2, char *str1 )
		{
			char *ptr, *ptr2;
			int main_length;
			
			ptr = str1;
			ptr2 = str2;
			
			if (str1[0] == '-')
				*ptr2++ = *ptr++;
			
			if (index( ptr, '.' ) != NULL)
				main_length = index( ptr, '.' ) - ptr;
			else
				main_length = strlen( ptr );
			
			*ptr2++ = *ptr++;
			main_length--;
			
			while (main_length > 0)
			{
				if (main_length % 3 == 0)
					*ptr2++ = ',';
				
				*ptr2++ = *ptr++;
				main_length--;
			}

			*ptr2 = '\0';
			
			strcpy( ptr2, ptr );
		}
		



	//--------------------------------------------------------------------------
	// Forms
	//--------------------------------------------------------------------------
		
/*
		void _ci_calc_form_start( ci_var *result, ci_var *arg1, ci_var *arg2 )
		{
			write_yellow_input_boxes();
			
			echo "<form id='".$arg1."' name='".$arg1."' action='".url_encode( $arg2 )."' method='POST'><table style='border: 1px solid #bbbbbb; background: linear-gradient(#fcfcfc, #e1e1e1)'>";

			ci_var_set_n( result, 31 );
		}
		
		void _ci_calc_form_text( ci_var *result, ci_var *arg1, ci_var *arg2 )
		{
			form_text( "", $arg1, $arg2, $arg3, $arg4, $arg5, $arg6 );

			ci_var_set_n( result, 31 );
		}
		
		void _ci_calc_form_dropdown( ci_var *result, ci_var *arg1, ci_var *arg2 )
		{
			form_dropdown( "", $arg1, $arg2, $arg3, $arg4, $arg5, $arg6 );

			ci_var_set_n( result, 31 );
		}
		
		void _ci_calc_form_radio( ci_var *result, ci_var *arg1, ci_var *arg2 )
		{
			form_radio( "", $arg1, $arg2, $arg3, $arg4, $arg5, $arg6, $arg7 );

			ci_var_set_n( result, 31 );
		}
		
		void _ci_calc_form_checkbox( ci_var *result, ci_var *arg1, ci_var *arg2 )
		{
			form_checkbox( "", $arg1, $arg2, $arg3, $arg4, $arg5 );

			ci_var_set_n( result, 31 );
		}
		
		void _ci_calc_form_textarea( ci_var *result, ci_var *arg1, ci_var *arg2 )
		{
			form_textarea( "", $arg1, $arg2, $arg3, $arg4, $arg5, $arg6 );

			ci_var_set_n( result, 31 );
		}
		
		void _ci_calc_form_password( ci_var *result, ci_var *arg1, ci_var *arg2 )
		{
			form_password( "", $arg1, $arg2, $arg3, $arg4, $arg5 );

			ci_var_set_n( result, 31 );
		}
		
		void _ci_calc_form_submit_new( ci_var *result, ci_var *arg1, ci_var *arg2 )
		{
			show_green_button_submit( "", $arg2, (double) $arg3, $arg1 );

			ci_var_set_n( result, 31 );
		}
		
		void _ci_calc_form_end( ci_var *result, ci_var *arg1, ci_var *arg2 )
		{
			form_end();

			ci_var_set_n( result, 31 );
		}	
		
		void _ci_calc_show_link( ci_var *result, ci_var *arg1, ci_var *arg2 )
		{
			$result = "<a class='glink' href='" & $arg2 & "'>" & $arg1 & "</a>";

			ci_var_set_n( result, 31 );
		}
*/	
	
	
	//--------------------------------------------------------------------------
	// Dates & times
	//--------------------------------------------------------------------------
	
				
		char *_ci_calc_dtoday( ci_var *result )
		{
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			time_t t;
			struct tm *t2;
			
			time( &t );
			
			t2 = localtime( &t );
			
			strftime( str4, SMALL_STRING_BUFFER_SIZE, "%Y-%m-%d", t2 );
			
			ci_var_set_s( result, str4 );
			
			return ((char *) result);			
		}
			
				
		char *_ci_calc_tnow( ci_var *result )
		{
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			time_t t;
			struct tm *t2;
			
			time( &t );
			
			t2 = localtime( &t );
			
			strftime( str4, SMALL_STRING_BUFFER_SIZE, "%H:%M:%S", t2 );
			
			ci_var_set_s( result, str4 );
			
			return ((char *) result);			
		}
			
				
		char *_ci_calc_dtnow( ci_var *result )
		{
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			time_t t;
			struct tm *t2;
			
			time( &t );
			
			t2 = localtime( &t );
			
			strftime( str4, SMALL_STRING_BUFFER_SIZE, "%Y-%m-%d %H:%M:%S", t2 );
			
			ci_var_set_s( result, str4 );
			
			return ((char *) result);			
		}


char *strptime(const char* s, const char *format, struct tm *tm);


		char *_ci_calc_dformat( ci_var *result, ci_var *arg1, ci_var *arg2 )
		{
			char str5[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			char str3[MEDIUM_STRING_BUFFER_SIZE];
			char str2[MEDIUM_STRING_BUFFER_SIZE];
			char str[MEDIUM_STRING_BUFFER_SIZE];
			struct tm t2;
			int day;
			int hour;
			char hour_text[10];
			char day_text[10];
			
			ci_var_check_s( arg1 );
			ci_var_check_s( arg2 );
			
			ci_str_u32_to_u8( str5, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			if (! ci_check_date_valid( str5, "yyyy-mm-dd" ))
				ci_runtime_error( 76, "Invalid date text" );
					
			ci_str_u32_to_u8( str2, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			if (strcmp( str2, "%Y-%m-%d" ) == 0)
				ci_var_set_s_u32( result, arg1->data.svalue, false );
			else
			{
				day = atoi( sright( str, str5, 2 ) );

				hour = atoi( smid( str, str5, 11, 2 ) );
	
				if (hour > 12)
					hour -= 12;
					
				if (hour == 0)
					hour = 12;
					
				sprintf( hour_text, "%d", hour );

				sprintf( day_text, "%d", day );
	
				strcpy( str3, str2 );
				
				if (day == 1)				str_replace( str3, str2, "%i", "st" );	else
				if (day == 2)				str_replace( str3, str2, "%i", "nd" );	else
				if (day == 3)				str_replace( str3, str2, "%i", "rd" );	else
				if (day == 4)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 5)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 6)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 7)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 8)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 9)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 10)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 11)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 12)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 13)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 14)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 15)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 16)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 17)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 18)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 19)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 20)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 21)				str_replace( str3, str2, "%i", "st" );	else
				if (day == 22)				str_replace( str3, str2, "%i", "nd" );	else
				if (day == 23)				str_replace( str3, str2, "%i", "rd" );	else
				if (day == 24)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 25)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 26)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 27)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 28)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 29)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 30)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 31)				str_replace( str3, str2, "%i", "st" );

				strcpy( str2, str3 );

				str_replace( str3, str2, "%e", hour_text );


				strcpy( str2, str3 );

				str_replace( str3, str2, "%f", day_text );

			
				strptime( str5, "%Y-%m-%d", &t2 ); 
	
				strftime( str4, SMALL_STRING_BUFFER_SIZE, str3, &t2 );
				
				ci_var_set_s( result, str4 );
			}
			
			return ((char *) result);			
		}
			
				
		char *_ci_calc_tformat( ci_var *result, ci_var *arg1, ci_var *arg2 )
		{
			char str5[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			char str6[MEDIUM_STRING_BUFFER_SIZE];
			struct tm t2;
			
			ci_var_check_s( arg1 );
			ci_var_check_s( arg2 );

			ci_str_u32_to_u8( str5, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			ci_str_u32_to_u8( str6, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
						
			if (! ci_check_time_valid( str5 ))
				ci_runtime_error( 77, "Invalid time text" );
				
			if (str6[0] == '%' && str6[1] == 'e')
				str6[1] = 'l';
				
			strptime( str5, "%H:%M:%S", &t2 ); 
			
			strftime( str4, SMALL_STRING_BUFFER_SIZE, str6, &t2 );
			
			ci_var_set_s( result, str4 );
			
			return ((char *) result);			
		}
			
				
		char *_ci_calc_dtformat( ci_var *result, ci_var *arg1, ci_var *arg2 )
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			char str2[MEDIUM_STRING_BUFFER_SIZE];
			char str3[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			char str5[MEDIUM_STRING_BUFFER_SIZE];
			struct tm t2;
			int day;
			int hour;
			char hour_text[10];
			char day_text[10];
			
			ci_var_check_s( arg1 );
			ci_var_check_s( arg2 );

			ci_str_u32_to_u8( str5, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! ci_check_datetime_valid( str5 ))
				ci_runtime_error( 78, "Invalid datetime text" );
				
			strptime( str5, "%Y-%m-%d %H:%M:%S", &t2 ); 

			ci_str_u32_to_u8( str2, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			day = atoi( smid( str, str5, 8, 2 ) );

			hour = atoi( smid( str, str5, 11, 2 ) );

			if (hour > 12)
				hour -= 12;

			if (hour == 0)
				hour = 12;
				
			sprintf( hour_text, "%d", hour );

			sprintf( day_text, "%d", day );
			
			strcpy( str3, str2 );
			
			if (day == 1)				str_replace( str3, str2, "%i", "st" );	else
			if (day == 2)				str_replace( str3, str2, "%i", "nd" );	else
			if (day == 3)				str_replace( str3, str2, "%i", "rd" );	else
			if (day == 4)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 5)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 6)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 7)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 8)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 9)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 10)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 11)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 12)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 13)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 14)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 15)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 16)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 17)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 18)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 19)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 20)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 21)				str_replace( str3, str2, "%i", "st" );	else
			if (day == 22)				str_replace( str3, str2, "%i", "nd" );	else
			if (day == 23)				str_replace( str3, str2, "%i", "rd" );	else
			if (day == 24)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 25)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 26)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 27)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 28)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 29)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 30)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 31)				str_replace( str3, str2, "%i", "st" );
			
			strcpy( str2, str3 );

			str_replace( str3, str2, "%e", hour_text );


			strcpy( str2, str3 );

			str_replace( str3, str2, "%f", day_text );
			
			
			strftime( str4, SMALL_STRING_BUFFER_SIZE, str3, &t2 );
			
			ci_var_set_s( result, str4 );
			
			return ((char *) result);			
		}


		char _ci_calc_dlast_day_of_the_month( long int arg1, long int arg2 )
		{
			int month, year;

			month = arg1;
			year = arg2;

			return ( last_day_of_the_month( year, month ) );
		}


		long int _ci_calc_dis_last_day_of_the_month( ci_var *arg1 )
		{
			int day, month, year;
			char text[MEDIUM_STRING_BUFFER_SIZE];
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			ci_str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			if (! ci_check_date_valid( str, "yyyy-mm-dd" ))
				ci_runtime_error( 79, "Invalid date text" );

			day = atoi( sright( text, str, 2 ) );
			month = atoi( smid( text, str, 5, 2 ) );
			year = atoi( sleft( text, str, 4 ) );

			return ( day == last_day_of_the_month( year, month ) );
		}


		char *_ci_calc_dadd( ci_var *result, ci_var *arg1, ci_var *arg2, long int arg3 )
		{
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			char str5[MEDIUM_STRING_BUFFER_SIZE];
			char str6[MEDIUM_STRING_BUFFER_SIZE];
			char text[SMALL_STRING_BUFFER_SIZE];
			int day, month, year;
			int days_to_add;
			int x;
			
			ci_var_check_s( arg1 );
			ci_var_check_s( arg2 );

			ci_str_u32_to_u8( str5, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			ci_str_u32_to_u8( str6, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! ci_check_date_valid( str5, "yyyy-mm-dd" ))
				ci_runtime_error( 80, "Invalid date text" );

			day = atoi( sright( text, str5, 2 ) );
			month = atoi( smid( text, str5, 5, 2 ) );
			year = atoi( sleft( text, str5, 4 ) );

			days_to_add = arg3;

			if (strcmp( str6, "week" ) == 0 || strcmp( str6, "weeks" ) == 0)
			{
				days_to_add *= 7;
			
				strcpy( str6, "day" );
			}
			
			if (strcmp( str6, "day" ) == 0 || strcmp( str6, "days" ) == 0)
			{
				while (day + days_to_add > last_day_of_the_month( year, month ))
				{
					days_to_add -= last_day_of_the_month( year, month ) - day + 1;
					
					day = 1;
					
					month++;

					if (month > 12)
					{
						year++;
						month = 1;
					}
				}
				
				day += days_to_add;

				date_from_parts( str4, day, month, year );

				ci_var_set_s( result, str4 );
			}
			else 
			{
				if (strcmp( str6, "month" ) == 0 ||
					strcmp( str6, "months" ) == 0)
				{
					month += arg3;
					
					while (month > 12)
					{
						month -= 12;
						year++;
					}
					
					if (day == 31 && (month == 9 || month == 4 || month == 6 || month == 11))
						day = 30;
				}
				else
				if (strcmp( str6, "year" ) == 0 ||
					strcmp( str6, "years" ) == 0)
				{
					year += arg3;
				}
				else
					ci_runtime_error( 81, "Invalid date format" );

				if (month == 2 && day > 29)
					day = 29;
				
				if (month == 2 && day >= 29 && (! is_leap_year( year )))
					day = 28;

				date_from_parts( text, day, month, year );

				ci_var_set_s( result, text );
			}
			
			return ((char *) result);			
		}
			
		char *_ci_calc_dtadd( ci_var *result, ci_var *arg1, ci_var *arg2, long int arg3 )
		{
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			char str5[MEDIUM_STRING_BUFFER_SIZE];
			char str6[MEDIUM_STRING_BUFFER_SIZE];
			char text[SMALL_STRING_BUFFER_SIZE];
			int hour, minute, second;
			int interval, curr_time;
			
			ci_var_check_s( arg1 );
			ci_var_check_s( arg2 );

			ci_str_u32_to_u8( str5, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			ci_str_u32_to_u8( str6, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! ci_check_time_valid( str5 ))
				ci_runtime_error( 82, "Invalid time text" );
			else
			{
				hour = atoi( sleft( text, str5, 2 ) );
				minute = atoi( smid( text, str5, 3, 2 ) );
				second = atoi( sright( text, str5, 2 ) );

				curr_time = hour * 60 * 60 + minute * 60 + second;
							
				if (strcmp( str6, "hour" ) == 0 ||
					strcmp( str6, "hours" ) == 0)
				{
					interval = arg3 * 60 * 60;
				}
				else
				if (strcmp( str6, "minute" ) == 0 ||
					strcmp( str6, "minutes" ) == 0)
				{
					interval = arg3 * 60;
				}
				else
				if (strcmp( str6, "second" ) == 0 ||
					strcmp( str6, "seconds" ) == 0)
				{
					interval = arg3;
				}
				else
					ci_runtime_error( 83, "Invalid interval in dtadd()" );
				
				curr_time += interval;
				
				curr_time = (int) (curr_time % (24*60*60));
				
				hour = (int) (curr_time / (60*60));

				minute = (int) ((curr_time - hour * (60*60)) / 60);
				 
				second = (int) (curr_time - hour * (60*60) - minute * 60);

				time_from_parts( text, hour, minute, second );

				ci_var_set_s( result, text );
			}
			
			return ((char *) result);			
		}

				
		char *_ci_calc_dsub( ci_var *result, ci_var *arg1, ci_var *arg2, long int arg3 )
		{
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			char str5[MEDIUM_STRING_BUFFER_SIZE];
			char str6[MEDIUM_STRING_BUFFER_SIZE];
			char text[SMALL_STRING_BUFFER_SIZE];
			int day, month, year;
			int days_to_subtract;
			
			ci_var_check_s( arg1 );
			ci_var_check_s( arg2 );

			ci_str_u32_to_u8( str5, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			ci_str_u32_to_u8( str6, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! ci_check_date_valid( str5, "yyyy-mm-dd" ))
				ci_runtime_error( 84, "Invalid date text" );

			day = atoi( sright( text, str5, 2 ) );
			month = atoi( smid( text, str5, 5, 2 ) );
			year = atoi( sleft( text, str5, 4 ) );

			days_to_subtract = arg3;

			if (strcmp( str6, "week" ) == 0 || strcmp( str6, "weeks" ) == 0)
			{
				days_to_subtract *= 7;
			
				strcpy( str6, "day" );
			}
			
			if (strcmp( str6, "day" ) == 0 || strcmp( str6, "days" ) == 0)
			{
				while (day - days_to_subtract < 1)
				{
					days_to_subtract -= day;
					
					month--;
					
					if (month < 1)
					{
						year--;
						month = 12;
					}
					
					day = last_day_of_the_month( year, month );						
				}
				
				day -= days_to_subtract;

				date_from_parts( str4, day, month, year );

				ci_var_set_s( result, str4 );
			}
			else
			{
				if (strcmp( str6, "month" ) == 0 ||
					strcmp( str6, "months" ) == 0)
				{
					month -= arg3;
					
					while (month < 1)
					{
						month += 12;
						year--;
					}
					
					if (day == 31 && (month == 9 || month == 4 || month == 6 || month == 11))
						day = 30;
				}
				else
				if (strcmp( str6, "year" ) == 0 ||
					strcmp( str6, "years" ) == 0)
				{
					year -= arg3;
				}
				else
					ci_runtime_error( 85, "Invalid date format" );
				
				if (month == 2 && day > 29)
					day = 29;
				
				if (month == 2 && day >= 29 && (! is_leap_year( year )))
					day = 28;
			
				date_from_parts( text, day, month, year );

				ci_var_set_s( result, text );
			}
			
			return ((char *) result);			
		}
			
		char *_ci_calc_dtsub( ci_var *result, ci_var *arg1, ci_var *arg2, long int arg3 )
		{
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			char str5[MEDIUM_STRING_BUFFER_SIZE];
			char str6[MEDIUM_STRING_BUFFER_SIZE];
			char text[SMALL_STRING_BUFFER_SIZE];
			int hour, minute, second;
			int interval, curr_time;
			
			ci_var_check_s( arg1 );
			ci_var_check_s( arg2 );

			ci_str_u32_to_u8( str5, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			ci_str_u32_to_u8( str6, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! ci_check_time_valid( str5 ))
				ci_runtime_error( 86, "Invalid time text" );
			else
			{
				hour = atoi( sleft( text, str5, 2 ) );
				minute = atoi( smid( text, str5, 3, 2 ) );
				second = atoi( sright( text, str5, 2 ) );

				curr_time = hour * 60 * 60 + minute * 60 + second;
							
				if (strcmp( str6, "hour" ) == 0 ||
					strcmp( str6, "hours" ) == 0)
				{
					interval = arg3 * 60 * 60;
				}
				else
				if (strcmp( str6, "minute" ) == 0 ||
					strcmp( str6, "minutes" ) == 0)
				{
					interval = arg3 * 60;
				}
				else
				if (strcmp( str6, "second" ) == 0 ||
					strcmp( str6, "seconds" ) == 0)
				{
					interval = arg3;
				}
				else
					ci_runtime_error( 87, "Invalid interval in dtadd()" );
				
				curr_time -= interval;
				
				while (curr_time < 0)
					curr_time += 24*60*60;
				
				hour = curr_time / (60*60);

				minute = (curr_time - hour * (60*60)) / 60;
				 
				second = (curr_time - hour * (60*60) - minute * 60);

				time_from_parts( text, hour, minute, second );

				ci_var_set_s( result, text );
			}
			
			return ((char *) result);			
		}
		
		
		char *_ci_calc_ddtadd( ci_var *result, ci_var *arg1, ci_var *arg2, long int arg3 )
		{
			char str5[MEDIUM_STRING_BUFFER_SIZE];
			char str6[MEDIUM_STRING_BUFFER_SIZE];
			char text[SMALL_STRING_BUFFER_SIZE];
			char text2[SMALL_STRING_BUFFER_SIZE];
			int day, month, year;
			int hour, minute, second;
			int days_to_add;
			int seconds_per_day;
			int interval, curr_time;
			
			ci_var_check_s( arg1 );
			ci_var_check_s( arg2 );

			ci_str_u32_to_u8( str5, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			ci_str_u32_to_u8( str6, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! ci_check_datetime_valid( str5 ))
				ci_runtime_error( 205, "Invalid datetime text" );

			day = atoi( smid( text, str5, 8, 2 ) );
			month = atoi( smid( text, str5, 5, 2 ) );
			year = atoi( sleft( text, str5, 4 ) );

			hour = atoi( smid( text, str5, 11, 2 ) );
			minute = atoi( smid( text, str5, 14, 2 ) );
			second = atoi( sright( text, str5, 2 ) );

			curr_time = hour * 60 * 60 + minute * 60 + second;

			if (strcmp( str6, "hour" ) == 0 ||
				strcmp( str6, "hours" ) == 0)
			{
				interval = arg3 * 60 * 60;
			}
			else
			if (strcmp( str6, "minute" ) == 0 ||
				strcmp( str6, "minutes" ) == 0)
			{
				interval = arg3 * 60;
			}
			else
			if (strcmp( str6, "second" ) == 0 ||
				strcmp( str6, "seconds" ) == 0)
			{
				interval = arg3;
			}
			else
				ci_runtime_error( 206, "Invalid interval in ddtadd()" );

			curr_time += interval;
			
			seconds_per_day = 24*60*60;
			
			days_to_add = 0;
			
			while (curr_time > seconds_per_day)
			{
				days_to_add++;
				curr_time -= seconds_per_day;
			}

			hour = curr_time / (60*60);

			minute = (curr_time - hour * (60*60)) / 60;
			 
			second = (curr_time - hour * (60*60) - minute * 60);

			time_from_parts( text, hour, minute, second );

			while (day + days_to_add > last_day_of_the_month( year, month ))
			{
				days_to_add -= last_day_of_the_month( year, month ) - day + 1;
				
				day = 1;
				
				month++;

				if (month > 12)
				{
					year++;
					month = 1;
				}
			}

			day += days_to_add;
			
			date_from_parts( text2, day, month, year );
			
			strcat( text2, " " );
			strcat( text2, text );

			ci_var_set_s( result, text2 );
			
			return ((char *) result);			
		}



		char *_ci_calc_ddtsub( ci_var *result, ci_var *arg1, ci_var *arg2, long int arg3 )
		{
			char str5[MEDIUM_STRING_BUFFER_SIZE];
			char str6[MEDIUM_STRING_BUFFER_SIZE];
			char text[SMALL_STRING_BUFFER_SIZE];
			char text2[SMALL_STRING_BUFFER_SIZE];
			int day, month, year;
			int hour, minute, second;
			int days_to_subtract;
			int seconds_per_day;
			int interval, curr_time;
			int days_to_add;
			int x;
			
			ci_var_check_s( arg1 );
			ci_var_check_s( arg2 );

			ci_str_u32_to_u8( str5, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			ci_str_u32_to_u8( str6, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! ci_check_datetime_valid( str5 ))
				ci_runtime_error( 207, "Invalid datetime text" );

			day = atoi( smid( text, str5, 8, 2 ) );
			month = atoi( smid( text, str5, 5, 2 ) );
			year = atoi( sleft( text, str5, 4 ) );

			hour = atoi( smid( text, str5, 11, 2 ) );
			minute = atoi( smid( text, str5, 14, 2 ) );
			second = atoi( sright( text, str5, 2 ) );

			curr_time = hour * 60 * 60 + minute * 60 + second;

			if (strcmp( str6, "hour" ) == 0 ||
				strcmp( str6, "hours" ) == 0)
			{
				interval = arg3 * 60 * 60;
			}
			else
			if (strcmp( str6, "minute" ) == 0 ||
				strcmp( str6, "minutes" ) == 0)
			{
				interval = arg3 * 60;
			}
			else
			if (strcmp( str6, "second" ) == 0 ||
				strcmp( str6, "seconds" ) == 0)
			{
				interval = arg3;
			}
			else
				ci_runtime_error( 208, "Invalid interval in ddtsub()" );

			curr_time -= interval;
			
			seconds_per_day = 24*60*60;
			
			days_to_subtract = 0;
			
			while (curr_time < 0)
			{
				days_to_subtract++;
				curr_time += seconds_per_day;
			}

			hour = curr_time / (60*60);

			minute = (curr_time - hour * (60*60)) / 60;
			 
			second = (curr_time - hour * (60*60) - minute * 60);

			time_from_parts( text, hour, minute, second );

			while (day - days_to_subtract < 1)
			{
				days_to_subtract -= day;
				
				month--;
				
				if (month < 1)
				{
					year--;
					month = 12;
				}
				
				day = last_day_of_the_month( year, month );						
			}
			
			day -= days_to_subtract;
			
			date_from_parts( text2, day, month, year );
			
			strcat( text2, " " );
			strcat( text2, text );

			ci_var_set_s( result, text2 );
			
			return ((char *) result);			
		}
	
				
		long int _ci_calc_ddiff( ci_var *arg1, ci_var *arg2 )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str2[MEDIUM_STRING_BUFFER_SIZE];
			
			ci_var_check_s( arg1 );
			ci_var_check_s( arg2 );

			ci_str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			ci_str_u32_to_u8( str2, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
						
			if (! ci_check_date_valid( str1, "yyyy-mm-dd" ))
				ci_runtime_error( 88, "Invalid date text" );

			if (! ci_check_date_valid( str2, "yyyy-mm-dd" ))
				ci_runtime_error( 89, "Invalid date text" );
				
			return ( convert_date_to_julian( str2 ) - convert_date_to_julian( str1 ) ); 
		}
			

		long int _ci_calc_ddt_to_utime( ci_var *arg1, ci_var *arg2 )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str2[MEDIUM_STRING_BUFFER_SIZE];
			
			ci_var_check_s( arg1 );
			ci_var_check_s( arg2 );

			ci_str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			ci_str_u32_to_u8( str2, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
						
			if (! ci_check_datetime_valid( str1 ))
				ci_runtime_error( 213, "Invalid datetime text in ddt_to_utime()" );


			struct tm tm = {0};
		    long int ts;
		    char oldtz[128] = {0};
		
		    // save previous TZ
		    const char *p = getenv("TZ");
		    if (p) strncpy(oldtz, p, sizeof(oldtz) - 1);
		
		    // set new TZ
		    setenv("TZ", str2, 1);
		    tzset();  // IMPORTANT: load zoneinfo
		
		    // parse input
		    sscanf(str1, "%4d-%2d-%2d %2d:%2d:%2d",
		           &tm.tm_year, &tm.tm_mon, &tm.tm_mday,
		           &tm.tm_hour, &tm.tm_min, &tm.tm_sec);
		
		    tm.tm_year -= 1900;
		    tm.tm_mon -= 1;
		    tm.tm_isdst = -1;  // let system decide daylight saving
		
		    // convert to timestamp
		    ts = (long int)mktime(&tm);
		
		    tzset();  // ensure DST finalized for mktime
		
		    // restore previous TZ
		    if (oldtz[0])
		        setenv("TZ", oldtz, 1);
		    else
		        unsetenv("TZ");
		
		    tzset();  // reload old zoneinfo
		
		    return ts;
		}


		char *_ci_calc_dutime_to_dt( ci_var *result, long int arg1, ci_var *arg2 )
		{
			char str2[MEDIUM_STRING_BUFFER_SIZE];
			char str3[MEDIUM_STRING_BUFFER_SIZE];
		
			ci_var_check_s( arg2 );

			ci_str_u32_to_u8( str2, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

		
		// Save current TZ to restore later
		    char *old_tz = getenv("TZ");
		    char *old_tz_copy = NULL;
		
		    if (old_tz)
		        old_tz_copy = strdup(old_tz);
		
		    // Set requested timezone
		    if (setenv("TZ", str2, 1) != 0)
				ci_runtime_error( 214, "Error 1 in dutime_to_dt()" );
		
		    tzset();
		
		    // Convert to broken-down time for this zone
		    struct tm loc;
		    if (localtime_r(&arg1, &loc) == NULL)
				ci_runtime_error( 215, "Error 2 in dutime_to_dt()" );
		
		    // Format date/time including numeric UTC offset
		    // %z gives offset like +1100
		    if (strftime(str3, MEDIUM_STRING_BUFFER_SIZE-1, "%Y-%m-%d %H:%M:%S", &loc) == 0)
				ci_runtime_error( 216, "Error 3 in dutime_to_dt()" );
		
		    // Restore original TZ
		    if (old_tz_copy)
		        setenv("TZ", old_tz_copy, 1);
		    else
		        unsetenv("TZ");
		
		    tzset();
		    free(old_tz_copy);
		

			ci_var_set_s( result, str3 );
			
			return ((char *) result);			
		}
	
			
		char _ci_calc_ddatestr_is_valid( ci_var *arg1, ci_var *arg2 )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str2[MEDIUM_STRING_BUFFER_SIZE];
			int stat;
		
			ci_var_check_s( arg1 );

			ci_str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			ci_str_u32_to_u8( str2, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (ci_check_date_valid( str1, str2 ))
				stat = true;
			else
				stat = false;

			return ( stat );
		}

				
		char _ci_calc_dtimestr_is_valid( ci_var *arg1 )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			int stat;
		
			ci_var_check_s( arg1 );

			ci_str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (ci_check_time_valid( str1 ))
				stat = true;
			else
				stat = false;

			return ( stat );
		}

				
		char _ci_calc_ddatetimestr_is_valid( ci_var *arg1 )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			int stat;
		
			ci_var_check_s( arg1 );

			ci_str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (ci_check_datetime_valid( str1 ))
				stat = true;
			else
				stat = false;

			return ( stat );
		}
	
				
		long int _ci_calc_dleap_year( long int arg1 )
		{
			int stat;
		
			if (is_leap_year( arg1 ))		
				stat = true;
			else
				stat = false;

			return ( stat );
		}
			
				
		long int _ci_calc_dweekday( ci_var *arg1 )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			
			ci_var_check_s( arg1 );
		
			ci_str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! ci_check_date_valid( str1, "yyyy-mm-dd" ))
				ci_runtime_error( 90, "Invalid date text" );
		
			return ( jweekday( convert_date_to_julian( str1 ) ) );
		}
		
				
		long int _ci_calc_dday( ci_var *arg1 )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];

			ci_var_check_s( arg1 );

			ci_str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! ci_check_date_valid( str1, "yyyy-mm-dd" ))
				ci_runtime_error( 91, "Invalid date text" );
		
			sright( str4, str1, 2 );
			
			return ( atoi( str4 ) );
		}
		
				
		long int _ci_calc_dmonth( ci_var *arg1 )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];

			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! ci_check_date_valid( str1, "yyyy-mm-dd" ))
				ci_runtime_error( 92, "Invalid date text" );
		
			smid( str4, str1, 5, 2 );
			
			return ( atoi( str4 ) );
		}

				
		long int _ci_calc_dyear( ci_var *arg1 )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];

			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! ci_check_date_valid( str1, "yyyy-mm-dd" ))
				ci_runtime_error( 93, "Invalid date text" );
		
			sleft( str4, str1, 4 );
			
			return ( atoi( str4 ) );
		}


		long int _ci_calc_dhour( ci_var *arg1 )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];

			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! ci_check_time_valid( str1 ))
				ci_runtime_error( 94, "Invalid time text" );
		
			sleft( str4, str1, 2 );
			
			return ( atoi( str4 ) );
		}

		long int _ci_calc_dminute( ci_var *arg1 )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];

			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! ci_check_time_valid( str1 ))
				ci_runtime_error( 95, "Invalid time text" );
		
			smid( str4, str1, 3, 2 );
			
			return ( atoi( str4 ) );
		}

		long int _ci_calc_dsecond( ci_var *arg1 )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];

			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! ci_check_time_valid( str1 ))
				ci_runtime_error( 96, "Invalid time text" );
		
			sright( str4, str1, 2 );
			
			return ( atoi( str4 ) );
		}
				
		long int _ci_calc_ddate_to_julian( ci_var *arg1 )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];

			ci_var_check_s( arg1 );

			ci_str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! ci_check_date_valid( str1, "yyyy-mm-dd" ))
				ci_runtime_error( 97, "Invalid date text" );
		
			return ( convert_date_to_julian( str1 ) );
		}

				
		char *_ci_calc_djulian_to_date( ci_var *result, long int arg1 )
		{
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			
			convert_julian_to_date( str4, (long) arg1 );

			ci_var_set_s( result, str4 );
			
			return ((char *) result);			
		}

				
		char *_ci_calc_ddate_part( ci_var *result, ci_var *arg1 )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str[SMALL_STRING_BUFFER_SIZE];
			
			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! ci_check_datetime_valid( str1 ))
				ci_runtime_error( 98, "Invalid datetime text" );
				
			ci_var_set_s( result, sleft( str, str1, 10 ) );
			
			return ((char *) result);			
		}

				
		char *_ci_calc_dtime_part( ci_var *result, ci_var *arg1 )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str[SMALL_STRING_BUFFER_SIZE];
		
			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! ci_check_datetime_valid( str1 ))
				ci_runtime_error( 99, "Invalid datetime text" );
				
			ci_var_set_s( result, sright( str, str1, 8 ) );
			
			return ((char *) result);			
		}
		
				
		char *_ci_calc_lnull( ci_var *result, ci_var *arg1, ci_var *arg2 )
		{
			*((char **) result) = NULL;
			
			return ((char *) result);			
		}


		char *_ci_calc_ddate_from_parts( ci_var *result, long int arg1, long int arg2, long int arg3 )
		{
			char text[SMALL_STRING_BUFFER_SIZE];
			
			date_from_parts( text, arg1, arg2, arg3 );
			
			ci_var_set_s( result, text );
			
			return ((char *) result);			
		}
			
		char *_ci_calc_dtime_from_parts( ci_var *result, long int arg1, long int arg2, long int arg3 )
		{
			char text[SMALL_STRING_BUFFER_SIZE];
			
			time_from_parts( text, arg1, arg2, arg3 );
			
			ci_var_set_s( result, text );

			return ((char *) result);			
		}


		char *_ci_calc_ddatetime_from_vars( ci_var *result, ci_var *arg1, ci_var *arg2 )
		{
			char text[SMALL_STRING_BUFFER_SIZE];
			
			strcpy( text, arg1->data.svalue );

			strcat( text, " " );

			strcat( text, arg2->data.svalue );
			
			ci_var_set_s( result, text );

			return ((char *) result);			
		}


		char *_ci_calc_ddatetime_from_parts( ci_var *result, long int arg1, long int arg2, long int arg3, long int arg4, long int arg5, long int arg6 )
		{
			char text[SMALL_STRING_BUFFER_SIZE];
			
			date_from_parts( text, arg1, arg2, arg3 );

			text[10] = ' ';
			
			time_from_parts( &text[11], arg4, arg5, arg6 );
			
			ci_var_set_s( result, text );

			return ((char *) result);			
		}
		
		
		void date_from_parts( char *text, int day, int month, int year )
		{
			if (year < 50)
				year += 2000;
			else
			if (year < 100)
				year += 1900;
			
			sprintf( text, "%04d-%02d-%02d", year, month, day );
			
			if (! ci_check_date_valid( text, "yyyy-mm-dd" ))
				ci_runtime_error( 100, "Invalid date text:" );
		}
	

		void time_from_parts( char *text, int hour, int minute, int second )
		{
			sprintf( text, "%02d:%02d:%02d", hour, minute, second );
			
			if (! ci_check_time_valid( text ))
				ci_runtime_error( 101, "Invalid time text:" );
		}
			

//--------------------------------------------------------------------------
// Binary
//--------------------------------------------------------------------------

/*
		void _ci_calc_binit( ci_var *arg1 )
		{
			ci_free_curr_mem_1( (ci_var *) arg1 );
		
			arg1->data.bvalue = NULL;
			arg1->var_type = VAR_BINARY;
		}
*/

		long int _ci_calc_bsize( ci_var *arg1 )
		{
			if (arg1->var_type != VAR_BINARY)
				ci_runtime_error( 102, "Variable is not a binary variable" );

			return (*((int_64 *) (arg1->data.bvalue)));
		}

		long int _ci_calc_bget_byte( ci_var *arg1, long int arg2 )
		{
			int_64 len1;
			unsigned char ch;

			if (arg1->var_type != VAR_BINARY)
				ci_runtime_error( 103, "Variable is not a binary variable" );
		
			len1 = *((int_64 *) (arg1->data.bvalue));

			if (arg2 < 0 || arg2 >= len1)
				ci_runtime_error( 104, "Attempt to get a byte beyond the size of the data variable." );

			return (arg1->data.bvalue[arg2 + sizeof( int_64 )]);
		}

				
		void _ci_calc_bset_byte( ci_var *arg1, long int arg2, long int arg3 )
		{
			int_64 len1;
			
			if (arg1->var_type != VAR_BINARY)
				ci_runtime_error( 105, "Variable is not a binary variable" );
			
			len1 = *((int_64 *) (arg1->data.bvalue));

			if (arg2 < 0 || arg2 >= len1)
				ci_runtime_error( 106, "Attempt to set a byte beyond the size of the data variable." );

			arg1->data.bvalue[arg2 + sizeof( int_64 )] = (unsigned char) arg3;
		}			 

/*
		long int _ci_calc_bget_bit( ci_var *arg1, long int arg2 )
		{
			char num_text[SMALL_STRING_BUFFER_SIZE];
			int num;
			int byte_val;
			int_64 pos1, bit_pos;
			int_64 len1;
			
			if (arg1->var_type != VAR_BINARY)
				ci_runtime_error( 107, "Variable is not a binary variable" );
		
			pos1 = (int) ((arg2) / 8);
			
			bit_pos = arg2 % 8;

			len1 = *((int_64 *) (arg1->data.bvalue));
			 		
			if (pos1 >= len1)
				num = 0;
			else
			{
				if (bit_pos == 0) {if ((arg1->data.bvalue[pos1 + sizeof( int_64 )] & 0x80) != 0)				num = 1;		}	else
				if (bit_pos == 1) {if ((arg1->data.bvalue[pos1 + sizeof( int_64 )] & 0x40) != 0)				num = 1;		}	else
				if (bit_pos == 2) {if ((arg1->data.bvalue[pos1 + sizeof( int_64 )] & 0x20) != 0)				num = 1;		}	else
				if (bit_pos == 3) {if ((arg1->data.bvalue[pos1 + sizeof( int_64 )] & 0x10) != 0)				num = 1;		}	else
				if (bit_pos == 4) {if ((arg1->data.bvalue[pos1 + sizeof( int_64 )] & 0x08) != 0)				num = 1;		}	else
				if (bit_pos == 5) {if ((arg1->data.bvalue[pos1 + sizeof( int_64 )] & 0x04) != 0)				num = 1;		}	else
				if (bit_pos == 6) {if ((arg1->data.bvalue[pos1 + sizeof( int_64 )] & 0x02) != 0)				num = 1;		}	else
				if (bit_pos == 7) {if ((arg1->data.bvalue[pos1 + sizeof( int_64 )] & 0x01) != 0)				num = 1;		}

			}				
			
			return ( num );
		}
*/

/*
		void _ci_calc_bset_bit( ci_var *arg1, long int arg2, long int arg3 )
		{
			int_64 len1, len2;
			int_64 bit_pos;
			int_64 pos1;
			int bit_value;
			char *ptr;
			
			if (arg1->var_type != VAR_BINARY)
				ci_runtime_error( 108, "Variable is not a binary variable" );
			
			pos1 = (int) ((arg2) / 8);
			
			bit_pos = arg2 - (pos1 * 8);
			
			bit_value = arg3;

			len2 = *((int_64 *) (arg1->data.bvalue));
			
			if (pos1 >= len2)
				ci_runtime_error( 109, "Attempt to set a bit beyond the size of the data.", "" );

			if (bit_pos == 0 && bit_value == 1)			arg1->data.bvalue[pos1 + sizeof( int_64 )] |= 0x80;		else
			if (bit_pos == 1 && bit_value == 1)			arg1->data.bvalue[pos1 + sizeof( int_64 )] |= 0x40;		else
			if (bit_pos == 2 && bit_value == 1)			arg1->data.bvalue[pos1 + sizeof( int_64 )] |= 0x20;		else
			if (bit_pos == 3 && bit_value == 1)			arg1->data.bvalue[pos1 + sizeof( int_64 )] |= 0x10;		else
			if (bit_pos == 4 && bit_value == 1)			arg1->data.bvalue[pos1 + sizeof( int_64 )] |= 0x08;		else
			if (bit_pos == 5 && bit_value == 1)			arg1->data.bvalue[pos1 + sizeof( int_64 )] |= 0x04;		else
			if (bit_pos == 6 && bit_value == 1)			arg1->data.bvalue[pos1 + sizeof( int_64 )] |= 0x02;		else
			if (bit_pos == 7 && bit_value == 1)			arg1->data.bvalue[pos1 + sizeof( int_64 )] |= 0x01;		else
				
			if (bit_pos == 0 && bit_value == 0)			arg1->data.bvalue[pos1 + sizeof( int_64 )] &= 0x7F;		else
			if (bit_pos == 1 && bit_value == 0)			arg1->data.bvalue[pos1 + sizeof( int_64 )] &= 0xBF;		else
			if (bit_pos == 2 && bit_value == 0)			arg1->data.bvalue[pos1 + sizeof( int_64 )] &= 0xDF;		else
			if (bit_pos == 3 && bit_value == 0)			arg1->data.bvalue[pos1 + sizeof( int_64 )] &= 0xEF;		else
			if (bit_pos == 4 && bit_value == 0)			arg1->data.bvalue[pos1 + sizeof( int_64 )] &= 0xF7;		else
			if (bit_pos == 5 && bit_value == 0)			arg1->data.bvalue[pos1 + sizeof( int_64 )] &= 0xFB;		else
			if (bit_pos == 6 && bit_value == 0)			arg1->data.bvalue[pos1 + sizeof( int_64 )] &= 0xFD;		else
			if (bit_pos == 7 && bit_value == 0)			arg1->data.bvalue[pos1 + sizeof( int_64 )] &= 0xFE;
		}			 
*/

		void _ci_calc_bset_size( ci_var *arg1, long int arg2 )
		{
			int_64 len, len2;
			int_64 len_to_copy;
			char *ptr;
			
			if (arg1->var_type != VAR_EMPTY && arg1->var_type != VAR_BINARY)
				ci_runtime_error( 110, "Variable is not empty or a binary variable" );
			
			len = arg2;
			
			if (arg1->var_type == VAR_BINARY)
			{
				len2 = *((int_64 *) (arg1->data.bvalue));
			
				if (len > len2)
				{
					ptr = (char *) _ci_malloc( len + sizeof( int_64 ) );
					
					memcpy( ptr + sizeof( int_64 ), arg1->data.bvalue + sizeof( int_64 ), len2 );
				
					_ci_free( arg1->data.bvalue );

					arg1->data.bvalue = (unsigned char *) ptr;
				}
								
				*((int_64 *) (arg1->data.bvalue)) = len;
			}
			else
			{
				ptr = (char *) _ci_malloc( len + sizeof( int_64 ) );

				arg1->data.bvalue = (unsigned char *) ptr;

				*((int_64 *) (arg1->data.bvalue)) = len;
			
				arg1->var_type = VAR_BINARY;
			}
		}			 
	

		void _ci_calc_bclear( ci_var *arg1, long int arg2 )
		{
			int_64 pos, len;
			int_64 bit_pos, bit_value;
			int_64 pos1;
			char *ptr;
			
			if (arg1->var_type != VAR_BINARY)
				ci_runtime_error( 111, "Variable is not a binary variable" );

			if (arg1->data.bvalue != NULL)
			{
				len = *((int_64 *) (arg1->data.bvalue));
			
				memset( arg1->data.bvalue + sizeof( int_64 ), arg2, len );
			}
		} 

		
		char *_ci_calc_bint_to_hex( ci_var *result, long int arg1, char arg2 )
		{
			char dest[SMALL_STRING_BUFFER_SIZE];
			
			ci_dec_to_hex( dest, (unsigned char *) &(arg1), sizeof( int_64 ), false, arg2 );
			
			ci_var_set_s( result, dest );
			
			return ((char *) result);			
		}


		long int _ci_calc_bhex_to_int( ci_var *arg1 )
		{
			char str[MEDIUM_STRING_BUFFER_SIZE];
			int_64 dest;
			
			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			dest = hex_to_int( str );

			return ( dest );
		}



//--------------------------------------------------------------------------
// Internet
//--------------------------------------------------------------------------

/*
	void _ci_calc_isend_email( ci_var *result, ci_var *arg1, ci_var *arg2 )
	{
		$result =
		
*/
				
		char *_ci_calc_iconvert_to_html( ci_var *result, ci_var *arg1 )
		{
			char *ptr, *ptr2;
			char *str, str2[MEDIUM_STRING_BUFFER_SIZE];
			char *str1; 
			int_64 i, len;
			int_64 len2, len3;
			char ch;
			
			ci_var_check_s( arg1 );

			str1 = (char *) _ci_malloc( *((int_64 *) (arg1->data.svalue)) * 4 + 1 );
			
			ci_str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			len2 = strlen( str1 );
			
			len = 2 * len2;
			
			if (len < 1000)
				len = 1000;
							
			str = (char *) _ci_malloc( len + 1 );
			
			str[0] = '\0';
           	str2[1] = '\0';
			
			for (i=0; i < len2; i++)
			{
				if (strlen( str ) > len - 50)
				{
					len3 = len;
					
					len = len * 1.3;
					
					ptr2 = (char *) _ci_malloc( len + 1 );
					
					strcpy( ptr2, str );
					
					_ci_free( str );
					
					str = ptr2;
				}
				
				ch = str1[i];
				
				if (ch == '\n')
					strcat( str, "<br>" );
				else
				if (ch == '&')
					strcat( str, "&amp;" );
				else
				if (ch == '"')
					strcat( str, "&quot;" );
				else
				if (ch == '\'')
					strcat( str, "&#039;" );
				else
				if (ch == '<')
					strcat( str, "&lt;" );
				else
				if (ch == '>')
					strcat( str, "&gt;" );
				else
				if (ch == '+')
					strcat( str, "&#43;" );
	            else
	            {
	            	str2[0]= ch;
					strcat( str, str2 );
				}
			}

			ci_var_set_s( result, str );
			
			_ci_free( str1 );
			_ci_free( str );
			
			return ((char *) result);			
		}
	
				
		char *_ci_calc_iurlencode( ci_var *result, ci_var *arg1 )
		{
			char *ptr, *ptr2;
			char str[MEDIUM_STRING_BUFFER_SIZE], str2[MEDIUM_STRING_BUFFER_SIZE];
			char str3[MEDIUM_STRING_BUFFER_SIZE];
			int i;
			
			ci_var_check_s( arg1 );

			*str = '\0';
           	str2[1] = '\0';
			
			ci_str_u32_to_u8( str3, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			for (i=0; i < strlen( str3 ); i++)
			{
				ptr = &str3[i];

				if (*ptr == '=')
					strcat( str, "%3D" );
	            else
				if (*ptr == '&')
					strcat( str, "%26" );
	            else
				if (*ptr == '\'')
					strcat( str, "%27" );
	            else
				if (*ptr == ' ')
					strcat( str, "%20" );
	            else
				if (*ptr == '!')
					strcat( str, "%21" );
	            else
				if (*ptr == '"')
					strcat( str, "%22" );
	            else
				if (*ptr == '#')
					strcat( str, "%23" );
	            else
				if (*ptr == '$')
					strcat( str, "%24" );
	            else
				if (*ptr == '%')
					strcat( str, "%25" );
	            else
				if (*ptr == '(')
					strcat( str, "%28" );
	            else
				if (*ptr == ')')
					strcat( str, "%29" );
	            else
				if (*ptr == '*')
					strcat( str, "%2A" );
	            else
				if (*ptr == '+')
					strcat( str, "%2B" );
	            else
				if (*ptr == ',')
					strcat( str, "%2C" );
	            else
				if (*ptr == '-')
					strcat( str, "%2D" );
	            else
				if (*ptr == '.')
					strcat( str, "%2E" );
	            else
				if (*ptr == '?')
					strcat( str, "%3F" );
	            else
				if (*ptr == '@')
					strcat( str, "%40" );
	            else
	            {
	            	str2[0]= *ptr;
					strcat( str, str2 );
				}
			}

			ci_var_set_s( result, str );
			
			return ((char *) result);			
		}
		
				
		char *_ci_calc_iurldecode( ci_var *result, ci_var *arg1 )
		{
			char *ptr, *ptr2;
			char str3[MEDIUM_STRING_BUFFER_SIZE];
			int_64 len2;
			char str[MEDIUM_STRING_BUFFER_SIZE], str2[MEDIUM_STRING_BUFFER_SIZE]; 
			int i;
			
			ci_var_check_s( arg1 );

			ci_str_u32_to_u8( str3, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			*str = '\0';
           	str2[1] = '\0';
			
			len2 = strlen( str3 );
			
			for (i=0; i < len2; i++)
			{
				ptr = &str3[i];
				
				if (strncmp( ptr, "%3D", 3 ) == 0)
				{
					strcat( str, "=" );		i += 2;
				}
				else
				if (strncmp( ptr, "%26", 3 ) == 0)
				{
					strcat( str, "&" );		i += 2;
				}
				else
				if (strncmp( ptr, "%27", 3 ) == 0)
				{
					strcat( str, "'" );		i += 2;
				}
				else
				if (strncmp( ptr, "%20", 3 ) == 0)
				{
					strcat( str, " " );		i += 2;
				}
				else
				if (strncmp( ptr, "%21", 3 ) == 0)
				{
					strcat( str, "!" );		i += 2;
				}
				else
				if (strncmp( ptr, "%22", 3 ) == 0)
				{
					strcat( str, "\"" );	i += 2;
				}
				else
				if (strncmp( ptr, "%23", 3 ) == 0)
				{
					strcat( str, "#" );		i += 2;
				}
				else
				if (strncmp( ptr, "%24", 3 ) == 0)
				{
					strcat( str, "$" );		i += 2;
				}
				else
				if (strncmp( ptr, "%25", 3 ) == 0)
				{
					strcat( str, "%" );		i += 2;
				}
				else
				if (strncmp( ptr, "%28", 3 ) == 0)
				{
					strcat( str, "(" );		i += 2;
				}
				else
				if (strncmp( ptr, "%29", 3 ) == 0)
				{
					strcat( str, ")" );		i += 2;
				}
				else
				if (strncmp( ptr, "%2A", 3 ) == 0)
				{
					strcat( str, "*" );		i += 2;
				}
				else
				if (strncmp( ptr, "%2B", 3 ) == 0)
				{
					strcat( str, "+" );		i += 2;
				}
				else
				if (strncmp( ptr, "%2C", 3 ) == 0)
				{
					strcat( str, "," );		i += 2;
				}
				else
				if (strncmp( ptr, "%2D", 3 ) == 0)
				{
					strcat( str, "-" );		i += 2;
				}
				else
				if (strncmp( ptr, "%2E", 3 ) == 0)
				{
					strcat( str, "." );		i += 2;
				}
				else
				if (strncmp( ptr, "%3F", 3 ) == 0)
				{
					strcat( str, "?" );		i += 2;
				}
				else
				if (strncmp( ptr, "%40", 3 ) == 0)
				{
					strcat( str, "@" );		i += 2;
				}
	            else
	            {
	            	str2[0]= *ptr;
					strcat( str, str2 );
				}
			}

			ci_var_set_s( result, str );

			return ((char *) result);			
		}

				
		void _ci_calc_ijump_to_page( ci_var *arg1 )
		{
			FILE *fp;
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			ci_var_check_s( arg1 );
		
			if (ci_redirect_filename == NULL)
		    {
	    		printf( "\nAttempted redirection on NULL redirect file." );
				exit(1);
		    }
			
			fp = fopen( ci_redirect_filename, "w" );
			
		    if (fp == NULL)
		    {
	    		printf( "\nCan't open file for redirect: %s\n\n", ci_redirect_filename );
				exit(1);
		    }
			
			ci_str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			fputs( str, fp );
			
			fclose( fp );
			
			ci_calc_stdlib_exit( ci_get_and_post_filename );
			
			exit( 2 );
		}
						
				
		void _ci_calc_iexit_if_search_bot( ci_var *result )
		{
			; // not implemented yet
		}
						
				
		void _ci_calc_iread_web_page( ci_var *result, ci_var *arg1, ci_var *arg2 )
		{
			; // not implemented yet
		}
						
						
						
//--------------------------------------------------------------------------
// Data type conversion
//--------------------------------------------------------------------------

		
		short int _ci_calc_cint_to_short_int( long int arg1 )
		{
			return ( (short int) arg1 );
		}

		int _ci_calc_cint_to_medium_int( long int arg1 )
		{
			return ( (int) arg1 );
		}

		char _ci_calc_cint_to_byte( long int arg1 )
		{
			return ( (char) arg1 );
		}
		
		long int _ci_calc_cint_to_decimal( long int arg1 )
		{
			return ( (long int) ((long int) arg1 * (long int) VAR_DECIMAL_SCALE) );
		}
		
		float _ci_calc_cint_to_float( long int arg1 )
		{
			return ( (float) arg1 );
		}

		double _ci_calc_cint_to_double( long int arg1 )
		{
			return ( (double) arg1 );
		}

		long double _ci_calc_cint_to_long_double( long int arg1 )
		{
			return ( (long double) arg1 );
		}
		
//--

		long int _ci_calc_cshort_int_to_int( short int arg1 )
		{
			return ( (long int) arg1 );
		}

		int _ci_calc_cshort_int_to_medium_int( short int arg1 )
		{
			return ( (int) arg1 );
		}

		char _ci_calc_cshort_int_to_byte( short int arg1 )
		{
			return ( (char) arg1 );
		}
		
		long int _ci_calc_cshort_int_to_decimal( short int arg1 )
		{
			return ( (long int) ((long int) arg1 * (long int) VAR_DECIMAL_SCALE) );
		}
		
		float _ci_calc_cshort_int_to_float( short int arg1 )
		{
			return ( (float) arg1 );
		}

		double _ci_calc_cshort_int_to_double( short int arg1 )
		{
			return ( (double) arg1 );
		}

		long double _ci_calc_cshort_int_to_long_double( short int arg1 )
		{
			return ( (long double) arg1 );
		}
		
//--

		long int _ci_calc_cmedium_int_to_int( int arg1 )
		{
			return ( (long int) arg1 );
		}
		
		short int _ci_calc_cmedium_int_to_short_int( int arg1 )
		{
			return ( (short int) arg1 );
		}

		char _ci_calc_cmedium_int_to_byte( int arg1 )
		{
			return ( (char) arg1 );
		}
		
		long int _ci_calc_cmedium_int_to_decimal( int arg1 )
		{
			return ( (long int) ((long int) arg1 * (long int) VAR_DECIMAL_SCALE) );
		}
		
		float _ci_calc_cmedium_int_to_float( int arg1 )
		{
			return ( (float) arg1 );
		}

		double _ci_calc_cmedium_int_to_double( int arg1 )
		{
			return ( (double) arg1 );
		}

		long double _ci_calc_cmedium_int_to_long_double( int arg1 )
		{
			return ( (long double) arg1 );
		}
		
//--

		long int _ci_calc_cbyte_to_int( char arg1 )
		{
			return ( (long int) arg1 );
		}
		
		short int _ci_calc_cbyte_to_short_int( char arg1 )
		{
			return ( (short int) arg1 );
		}

		int _ci_calc_cbyte_to_medium_int( char arg1 )
		{
			return ( (int) arg1 );
		}
		
		long int _ci_calc_cbyte_to_decimal( char arg1 )
		{
			return ( (long int) ((long int) arg1 * (long int) VAR_DECIMAL_SCALE) );
		}
		
		float _ci_calc_cbyte_to_float( char arg1 )
		{
			return ( (float) arg1 );
		}

		double _ci_calc_cbyte_to_double( char arg1 )
		{
			return ( (double) arg1 );
		}

		long double _ci_calc_cbyte_to_long_double( char arg1 )
		{
			return ( (long double) arg1 );
		}

//--

		long int _ci_calc_cdecimal_to_int( long int arg1 )
		{
			return ( (long int) roundl( (long double) arg1 / (long double) VAR_DECIMAL_SCALE ) );
		}
		
		short int _ci_calc_cdecimal_to_short_int( long int arg1 )
		{
			return ( (short int) roundl( (long double) arg1 / (long double) VAR_DECIMAL_SCALE ) );
		}

		int _ci_calc_cdecimal_to_medium_int( long int arg1 )
		{
			return ( (int) roundl( (long double) arg1 / (long double) VAR_DECIMAL_SCALE ) );
		}

		char _ci_calc_cdecimal_to_byte( long int arg1 )
		{
			return ( (char) roundl( (long double) arg1 / (long double) VAR_DECIMAL_SCALE ) );
		}
		
		float _ci_calc_cdecimal_to_float( long int arg1 )
		{
			return ( (float) ((long double) arg1 / (long double) VAR_DECIMAL_SCALE) );
		}

		double _ci_calc_cdecimal_to_double( long int arg1 )
		{
			return ( (double) ((long double) arg1 / (long double) VAR_DECIMAL_SCALE) );
		}

		long double _ci_calc_cdecimal_to_long_double( long int arg1 )
		{
			return ( (long double) ((long double) arg1 / (long double) VAR_DECIMAL_SCALE) );
		}
		
//--

		long int _ci_calc_cfloat_to_int( float arg1 )
		{
			return ( (long int) arg1 );
		}
		
		short int _ci_calc_cfloat_to_short_int( float arg1 )
		{
			return ( (short int) arg1 );
		}

		int _ci_calc_cfloat_to_medium_int( float arg1 )
		{
			return ( (int) arg1 );
		}

		char _ci_calc_cfloat_to_byte( float arg1 )
		{
			return ( (char) arg1 );
		}
		
		long int _ci_calc_cfloat_to_decimal( float arg1 )
		{
			return ( (long int) ((long int) arg1 * (long int) VAR_DECIMAL_SCALE) );
		}

		double _ci_calc_cfloat_to_double( float arg1 )
		{
			return ( (double) arg1 );
		}

		long double _ci_calc_cfloat_to_long_double( float arg1 )
		{
			return ( (long double) arg1 );
		}
//--

		long int _ci_calc_cdouble_to_int( double arg1 )
		{
			return ( (long int) arg1 );
		}
		
		short int _ci_calc_cdouble_to_short_int( double arg1 )
		{
			return ( (short int) arg1 );
		}

		int _ci_calc_cdouble_to_medium_int( double arg1 )
		{
			return ( (int) arg1 );
		}

		char _ci_calc_cdouble_to_byte( double arg1 )
		{
			return ( (char) arg1 );
		}
		
		long int _ci_calc_cdouble_to_decimal( double arg1 )
		{
			return ( (long int) ((long int) arg1 * (long int) VAR_DECIMAL_SCALE) );
		}
		
		float _ci_calc_cdouble_to_float( double arg1 )
		{
			return ( (float) arg1 );
		}

		long double _ci_calc_cdouble_to_long_double( double arg1 )
		{
			return ( (long double) arg1 );
		}
		
//--

		long int _ci_calc_clong_double_to_int( long double arg1 )
		{
			return ( (long int) arg1 );
		}
		
		short int _ci_calc_clong_double_to_short_int( long double arg1 )
		{
			return ( (short int) arg1 );
		}

		int _ci_calc_clong_double_to_medium_int( long double arg1 )
		{
			return ( (int) arg1 );
		}

		char _ci_calc_clong_double_to_byte( long double arg1 )
		{
			return ( (char) arg1 );
		}
		
		long int _ci_calc_clong_double_to_decimal( long double arg1 )
		{
			return ( (long int) ((long int) arg1 * (long int) VAR_DECIMAL_SCALE) );
		}
		
		float _ci_calc_clong_double_to_float( long double arg1 )
		{
			return ( (float) arg1 );
		}

		double _ci_calc_clong_double_to_double( long double arg1 )
		{
			return ( (double) arg1 );
		}
		
		
//-------------------------------------		
		

		char *_ci_calc_cdate_to_datetime( ci_var *result, ci_var *arg1 )
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			
			ci_var_check_s( arg1 );

			if (ci_check_date_valid( arg1->data.svalue, "yyyy-mm-dd" ))
			{
				strcpy( str, arg1->data.svalue );
				strcat( str, " 99:99:99" );
				
				ci_var_set_s( result, str );
			}

			return ((char *) result);			
		}

		char *_ci_calc_cint_to_string( ci_var *result, long int arg1 )
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			
			sprintf( str, "%ld", arg1 );
			
			ci_trim_trailing_zeros( str );
			
			ci_var_set_s( result, str );

			return ((char *) result);			
		}
			
		char *_ci_calc_cshort_int_to_string( ci_var *result, long int arg1 )
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			
			sprintf( str, "%ld", arg1 );
			
			ci_trim_trailing_zeros( str );
			
			ci_var_set_s( result, str );

			return ((char *) result);			
		}

		char *_ci_calc_cmedium_int_to_string( ci_var *result, long int arg1 )
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			
			sprintf( str, "%ld", arg1 );
			
			ci_trim_trailing_zeros( str );
			
			ci_var_set_s( result, str );

			return ((char *) result);			
		}

		char *_ci_calc_cbyte_to_string( ci_var *result, long int arg1 )
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			
			sprintf( str, "%ld", arg1 );
			
			ci_trim_trailing_zeros( str );
			
			ci_var_set_s( result, str );

			return ((char *) result);			
		}

		char *_ci_calc_cdecimal_to_string( ci_var *result, long int arg1 )
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			
			sprintf( str, "%.2lf", (double) arg1 / (double) VAR_DECIMAL_SCALE );
			
			ci_trim_trailing_zeros( str );
			
			ci_var_set_s( result, str );

			return ((char *) result);			
		}


		char *_ci_calc_cfloat_to_string( ci_var *result, double arg1 )
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			
			if (arg1 != 0 && (arg1 > 1000000000000 || arg1 < -1000000000000 || fabs( arg1 ) < 0.000000000001))
				sprintf( str, "%e", arg1 );
			else
				sprintf( str, "%13.13lf", arg1 );
			
			ci_trim_trailing_zeros( str );
			
			ci_var_set_s( result, str );

			return ((char *) result);			
		}

		char *_ci_calc_cdouble_to_string( ci_var *result, double arg1 )
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			
			if (arg1 != 0 && (arg1 > 1000000000000 || arg1 < -1000000000000 || fabs( arg1 ) < 0.000000000001))
				sprintf( str, "%e", arg1 );
			else
				sprintf( str, "%13.13lf", arg1 );
			
			ci_trim_trailing_zeros( str );
			
			ci_var_set_s( result, str );

			return ((char *) result);			
		}

		char *_ci_calc_clong_double_to_string( ci_var *result, long double arg1 )
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			
			if (arg1 != 0 && (arg1 > 1000000000000000000 || arg1 < -1000000000000000000 || fabsl( arg1 ) < 0.000000000000000001))
				sprintf( str, "%Le", arg1 );
			else
				sprintf( str, "%18.18Lf", arg1 );
			
			ci_trim_trailing_zeros( str );
			
			ci_var_set_s( result, str );

			return ((char *) result);			
		}

		char *_ci_calc_cbool_to_string( ci_var *result, char arg1 )
		{
			if (arg1 != 0)
				ci_var_set_s( result, "true" );
			else
				ci_var_set_s( result, "false" );

			return ((char *) result);			
		}

		char *_ci_calc_cdate_to_string( ci_var *result, ci_var *arg1, ci_var *arg2 ) 
		{
			_ci_calc_dformat( result, arg1, arg2 );

			return ((char *) result);			
		} 
			
		char *_ci_calc_ctime_to_string( ci_var *result, ci_var *arg1, ci_var *arg2 ) 
		{
			_ci_calc_tformat( result, arg1, arg2 );			

			return ((char *) result);			
		} 

		char *_ci_calc_cdatetime_to_string( ci_var *result, ci_var *arg1, ci_var *arg2 ) 
		{
			_ci_calc_dtformat( result, arg1, arg2 );

			return ((char *) result);			
		} 

		char *_ci_calc_cbinary_to_string( ci_var *result, ci_var *arg1, char arg2 )
		{
			int_64 len;
			int_64 len2;
			char *ptr;
			char *ptr2;
			int_64 i;
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			if (arg1->var_type != VAR_BINARY)
				ci_runtime_error( 112, "Variable is not a binary variable" );
			
			len2 = *((int_64 *) (arg1->data.bvalue));
			
			len = 2 * len2 + 1;

			if (len >= MEDIUM_STRING_BUFFER_SIZE-1)
				ptr = (char *) _ci_malloc( len + sizeof( int_64 ) );
			else
				ptr = str;
				
			if (arg2)
			{
				ci_dec_to_hex( ptr, (unsigned char *) (arg1->data.svalue + sizeof( int_64 )), len2, true, false );
				ci_var_set_s( result, ptr );
			}
			else
			{
				memcpy( ptr + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ), len2 );

				*((int_64 *) ptr) = len2;
									
				ci_var_set_s_u32( result, ptr, false );
			}
			
			if (len >= MEDIUM_STRING_BUFFER_SIZE-1)
				_ci_free( ptr );

			return ((char *) result);			
		}

		short int _ci_calc_cstring_to_short_int( ci_var *arg1 ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			short int num;
			
			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( str, arg1->data.svalue, SMALL_STRING_BUFFER_SIZE );
			
			num = (short int) atoi( str );
			
			return ( num );
		} 

		int _ci_calc_cstring_to_medium_int( ci_var *arg1 ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			int num;
			
			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( str, arg1->data.svalue, SMALL_STRING_BUFFER_SIZE );
			
			num = atoi( str );
			
			return ( num );
		} 

		char _ci_calc_cstring_to_byte( ci_var *arg1 ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			char num;
			
			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( str, arg1->data.svalue, SMALL_STRING_BUFFER_SIZE );
			
			num = (char) atoi( str );
			
			return ( num );
		} 

		long int _ci_calc_cstring_to_int( ci_var *arg1 ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			long int num;
			
			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( str, arg1->data.svalue, SMALL_STRING_BUFFER_SIZE );
			
			num = atol( str );
			
			return ( num );
		} 

		long int _ci_calc_cstring_to_decimal( ci_var *arg1 ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			double num;
			
			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( str, arg1->data.svalue, SMALL_STRING_BUFFER_SIZE );
			
			num = atof( str );
			
			return ( (long int) round( num * (double) VAR_DECIMAL_SCALE ) );
		} 

		float _ci_calc_cstring_to_float( ci_var *arg1 ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			double num;
			
			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( str, arg1->data.svalue, SMALL_STRING_BUFFER_SIZE );
			
			num = (float) atof( str );
			
			return ( num );
		} 

		double _ci_calc_cstring_to_double( ci_var *arg1 ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			double num;
			
			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( str, arg1->data.svalue, SMALL_STRING_BUFFER_SIZE );
			
			num = atof( str );
			
			return ( num );
		} 

		long double _ci_calc_cstring_to_long_double( ci_var *arg1 ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			long double num;
			
			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( str, arg1->data.svalue, SMALL_STRING_BUFFER_SIZE );
			
			num = strtold( str, NULL );
			
			return ( num );
		} 

		char _ci_calc_cstring_to_bool( ci_var *arg1 ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			int stat;
			
			ci_var_check_s( arg1 );
			
			ci_str_u32_to_u8( str, arg1->data.svalue, SMALL_STRING_BUFFER_SIZE );
			
			if (strcmp( str, "true" ) == 0 || strcmp( str, "TRUE" ) == 0)
				stat = 1;
			else
				stat = 0;
				
			return ( (long int) stat );
		} 

		char *_ci_calc_cstring_to_time( ci_var *result, ci_var *arg1 )
		{ 
			ci_var_check_s( arg1 );
			
			ci_var_set_s_u32( result, arg1->data.svalue, false );

			return ((char *) result);			
		}
		
		char *_ci_calc_cstring_to_date( ci_var *result, ci_var *arg1, ci_var *arg2 ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str2[MEDIUM_STRING_BUFFER_SIZE];
		
			ci_var_check_s( arg1 );
			ci_var_check_s( arg2 );
			
			ci_str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			ci_str_u32_to_u8( str2, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (strcmp( str2, "dd/mm/yyyy" ) != 00 &&
				strcmp( str2, "mm/dd/yyyy" ) != 00 &&
				strcmp( str2, "yyyy/mm/dd" ) != 00 &&
				strcmp( str2, "yyyy-mm-dd" ))
			{
//				sysfunc_error( $ic, $ic_ptr, "Date conversion error: type must be one of 'dd/mm/yyyy', 'mm/dd/yyyy', 'yyyy/mm/dd', 'yyyy-mm-dd'" );

				ci_var_set_s( result, "0000-00-00" );
			}
			else
			if (strcmp( str2, "yyyy-mm-dd" ) == 0)
			{
				if (! ci_check_date_valid( str1, "yyyy-mm-dd" ))
					ci_runtime_error( 113, "Invalid date input" );
				else
					ci_var_set_s( result, str1 );
			}
			else
			{
				convert_date_to_yyyymmdd( str, str1, str2 );

				if (! ci_check_date_valid( str, "yyyy-mm-dd" ))
					ci_runtime_error( 114, "Invalid date input" );
//				else
//					ci_var_set_s( result, str1 );

				ci_var_set_s( result, str );
			}			

			return ((char *) result);			
		} 
		
		char *_ci_calc_cstring_to_datetime( ci_var *result, ci_var *arg1 )
		{ 
			ci_var_check_s( arg1 );
			
			ci_var_set_s_u32( result, arg1->data.svalue, false );

			return ((char *) result);			
		}

		char *_ci_calc_cstring_to_binary( ci_var *result, ci_var *arg1, char arg2 )
		{
			int_64 len2;
			char *ptr;
			int_64 i;
			char *bptr;
			char *ptr2;
		
			ci_var_check_s( arg1 );

			len2 = *((int_64 *) (arg1->data.svalue));

			if (arg2 == true)
			{
				bptr = (char *) _ci_malloc( len2 / 2 + sizeof( int_64 ) );
				ptr2 = (char *) _ci_malloc( len2 + 1 );
				
				ci_str_u32_to_u8( ptr2, arg1->data.svalue, len2 + 1 );
				
				hex_to_binary( (unsigned char *) (bptr + sizeof( int_64 )), ptr2 );
				
				_ci_free( ptr2 );
			}
			else
			{
				bptr = (char *) _ci_malloc( len2 + sizeof( int_64 ) );
				
				memcpy( bptr + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ), len2 );
			}
									
			ci_free_curr_mem_1( (ci_var *) result );

			if (arg2 == true)
			{
				if (ascii_only)
					*((int_64 *) (bptr)) = len2 / 2;
				else
					*((int_64 *) (bptr)) = len2 / 8;
			}
			else
				*((int_64 *) (bptr)) = len2;
										
			result->data.bvalue = (unsigned char *) bptr;

			result->var_type = VAR_BINARY;

			return ((char *) result);			
		}

/*
		long int _ci_calc_cstring_to_byte( ci_var *arg1 ) 
		{
			int_64 num;
			
			ci_var_check_s( arg1 );

			if (*(arg1->data.svalue) == '\0')
				ci_runtime_error( 115, "Empty string in cstring_to_byte()" );
			
			num = *(arg1->data.svalue) - '0';
			
			return ( num );
		} 
*/
/*
		char *_ci_calc_cbyte_to_string( ci_var *result, long int arg1 ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			
			if (arg1 < 0)
				ci_runtime_error( 116, "Negative value in cbyte_to_string()" );
			
			if (arg1 > 255)
				ci_runtime_error( 117, "Overflow in cbyte_to_string()" );
			
			str[0] = (char) (arg1 + '0');
			str[1] = '\0';
			
			ci_var_set_s( result, str );

			return ((char *) result);			
		} 
*/

		char *_ci_calc_cdate_to_binary( ci_var *result, ci_var *arg1 )
		{
			int_64 len2;
			char *bptr;
		
			ci_var_check_s( arg1 );

			len2 = *((int_64 *) (arg1->data.svalue));

			bptr = (char *) _ci_malloc( len2 + sizeof( int_64 ) );
				
			memcpy( bptr + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ), len2 );
									
			ci_free_curr_mem_1( (ci_var *) result );

			*((int_64 *) (bptr)) = len2;
										
			result->data.bvalue = (unsigned char *) bptr;

			result->var_type = VAR_BINARY;

			return ((char *) result);			
		}

		char *_ci_calc_ctime_to_binary( ci_var *result, ci_var *arg1 )
		{
			int_64 len2;
			char *bptr;
		
			ci_var_check_s( arg1 );

			len2 = *((int_64 *) (arg1->data.svalue));

			bptr = (char *) _ci_malloc( len2 + sizeof( int_64 ) );
				
			memcpy( bptr + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ), len2 );
									
			ci_free_curr_mem_1( (ci_var *) result );

			*((int_64 *) (bptr)) = len2;
										
			result->data.bvalue = (unsigned char *) bptr;

			result->var_type = VAR_BINARY;

			return ((char *) result);			
		}

		char *_ci_calc_cdatetime_to_binary( ci_var *result, ci_var *arg1 )
		{
			int_64 len2;
			char *bptr;
		
			ci_var_check_s( arg1 );

			len2 = *((int_64 *) (arg1->data.svalue));

			bptr = (char *) _ci_malloc( len2 + sizeof( int_64 ) );
				
			memcpy( bptr + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ), len2 );
									
			ci_free_curr_mem_1( (ci_var *) result );

			*((int_64 *) (bptr)) = len2;
										
			result->data.bvalue = (unsigned char *) bptr;

			result->var_type = VAR_BINARY;
			
			return ((char *) result);			
		}


		char *_ci_calc_cint_to_binary( ci_var *result, long int arg1 )
		{ 
			char *bptr;
			int i;
 
			bptr = (char *) _ci_malloc( 2 * sizeof( int_64 ) );

			ci_free_curr_mem_1( (ci_var *) result );

			i = 1;

			if (*((char *) &i) == 1)			// little endian
			{
				for (i=0; i < sizeof( int_64 ); i++)
					*(bptr + sizeof( int_64 ) + i) = *(((char *) &(arg1)) + (sizeof( int_64 ) - 1 - i) );
			}
			else
			{
				for (i=0; i < sizeof( int_64 ); i++)
					*(bptr + sizeof( int_64 ) + i) = *(((char *) &(arg1)) + i);
			}			
			
			*((int_64 *) (bptr)) = sizeof( int_64 );
										
			result->data.bvalue = (unsigned char *) bptr;

			result->var_type = VAR_BINARY;

			return ((char *) result);			
		}

		char *_ci_calc_cdecimal_to_binary( ci_var *result, long int arg1 )
		{ 
			char *bptr;
			
			bptr = (char *) _ci_malloc( 2 * sizeof( int_64 ) );
										
			ci_free_curr_mem_1( (ci_var *) result );
												
//			if (result->var_type == VAR_STRING && result->data.svalue != NULL)
//				free( result->data.svalue );

//			if (result->var_type == VAR_BINARY && result->data.bvalue != NULL)
//				free( result->data.bvalue );

			memcpy( bptr + sizeof( int_64 ), &arg1, sizeof( int_64 ) );
			
			*((int_64 *) (bptr)) = sizeof( int_64 );
										
			result->data.bvalue = (unsigned char *) bptr;

			result->var_type = VAR_BINARY;

			return ((char *) result);			
		}

		char *_ci_calc_cdouble_to_binary( ci_var *result, double arg1 )
		{ 
			char *bptr;
			
			bptr = (char *) _ci_malloc( sizeof( int_64 ) + sizeof( double ) );
							
			ci_free_curr_mem_1( (ci_var *) result );
												
//			if (result->var_type == VAR_STRING && result->data.svalue != NULL)
//				free( result->data.svalue );

//			if (result->var_type == VAR_BINARY && result->data.bvalue != NULL)
//				free( result->data.bvalue );

			memcpy( bptr + sizeof( int_64 ), &(arg1), sizeof( double ) );
			
			*((int_64 *) (bptr)) = sizeof( double );
										
			result->data.bvalue = (unsigned char *) bptr;

			result->var_type = VAR_BINARY;

			return ((char *) result);			
		}


		char *_ci_calc_cbinary_to_date( ci_var *result, ci_var *arg1 )
		{
			int_64 len;
			char str[MEDIUM_STRING_BUFFER_SIZE];
			char *ptr;
			
			if (arg1->var_type != VAR_BINARY)
				ci_runtime_error( 118, "Variable is not a binary variable" );
			
			ptr = str;
			
			len = *((int_64 *) (arg1->data.bvalue));
				
			memcpy( ptr + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ), len );

			*((int_64 *) ptr) = len;
									
			ci_var_set_s_u32( result, ptr, false );

			return ((char *) result);			
		}


		char *_ci_calc_cbinary_to_time( ci_var *result, ci_var *arg1 )
		{
			int_64 len;
			char str[MEDIUM_STRING_BUFFER_SIZE];
			char *ptr;
			
			if (arg1->var_type != VAR_BINARY)
				ci_runtime_error( 119, "Variable is not a binary variable" );
			
			ptr = str;
			
			len = *((int_64 *) (arg1->data.bvalue));
				
			memcpy( ptr + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ), len );

			*((int_64 *) ptr) = len;
									
			ci_var_set_s_u32( result, ptr, false );

			return ((char *) result);			
		}


		char *_ci_calc_cbinary_to_datetime( ci_var *result, ci_var *arg1 )
		{
			int_64 len;
			char str[MEDIUM_STRING_BUFFER_SIZE];
			char *ptr;
			
			if (arg1->var_type != VAR_BINARY)
				ci_runtime_error( 120, "Variable is not a binary variable" );
			
			ptr = str;
			
			len = *((int_64 *) (arg1->data.bvalue));
				
			memcpy( ptr + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ), len );

			*((int_64 *) ptr) = len;
									
			ci_var_set_s_u32( result, ptr, false );

			return ((char *) result);			
		}


		long int _ci_calc_cbinary_to_int( ci_var *arg1 )
		{
			char istr[20];
			int i;
			
			 if (arg1->var_type != VAR_BINARY)
				ci_runtime_error( 121, "Variable is not a binary variable" );
			 
			i = 1;

			if (*((char *) &i) == 1)		// little endian
			{			 
				for (i=0; i < sizeof( int_64 ); i++)
					istr[i] = *(arg1->data.bvalue + sizeof( int_64 ) + (sizeof( int_64 ) - 1 - i));
			}
			else
			{
				for (i=0; i < sizeof( int_64 ); i++)
					istr[i] = *(arg1->data.bvalue + sizeof( int_64 ) + i);
			}
			
			return ( *((int_64 *) &istr) );
		}


		long int _ci_calc_cbinary_to_decimal( ci_var *arg1 )
		{
			 if (arg1->var_type != VAR_BINARY)
				ci_runtime_error( 122, "Variable is not a binary variable" );
			 
			return ( *((int_64 *) (arg1->data.bvalue + sizeof( int_64 ))) );
		}


		double _ci_calc_cbinary_to_double( ci_var *arg1 )
		{
			 if (arg1->var_type != VAR_BINARY)
				ci_runtime_error( 123, "Variable is not a binary variable" );
			 
			return ( *((double *) (arg1->data.bvalue + sizeof( int_64 ))) );
		}



//--------------------------------------------------------------------------
// Bit functions
//--------------------------------------------------------------------------

		long int _ci_calc_bit_and( long int arg1, long int arg2 )
		{
			return ( arg1 & arg2 );
		}
				
		long int _ci_calc_bit_or( long int arg1, long int arg2 )
		{
			return ( arg1 | arg2 );
		}
				
		long int _ci_calc_bit_xor( long int arg1, long int arg2 )
		{
			return ( arg1 ^ arg2 );
		}
				
		long int _ci_calc_bit_not( long int arg1 )
		{
			return ( ~ arg1 );
		}
				
		long int _ci_calc_bit_shift_left( long int arg1, long int arg2 )
		{
			return ( arg1 << arg2 );
		}
				
		long int _ci_calc_bit_shift_right( long int arg1, long int arg2 )
		{
			return ( arg1 >> arg2 );
		}
		
		char _ci_calc_bit_is_set( long int arg1, long int arg2 )
		{
			int st;
			
			if ((arg1 & arg2) != 0)
				st = 1;
			else
				st = 0;
				
			return ( st );
		}
		

//ipost								// Make a POST request to a web page
//send SMS							// sends an SMS message

//--------------------------------------------------------------------------
// Misc
//--------------------------------------------------------------------------

		long int _ci_calc_array_index_size( ci_var *arg1, long int arg2 )
		{
			rarray *rarray_ptr;
			
			if (arg1->var_type != VAR_RESIZABLE_ARRAY)
					ci_runtime_error( 124, "Parameter 1 to array_index_size must be a resizable array" );
			
			rarray_ptr = (rarray *) arg1->data.pvalue;

			if (arg2 < 1)
					ci_runtime_error( 125, "Invalid index number in array_index_size" );

			if (arg2 > rarray_ptr->number_of_dimensions)
					ci_runtime_error( 126, "Invalid index number in array_index_size" );

			return ( rarray_ptr->index_size[rarray_ptr->number_of_dimensions - arg2] );
		}


		long int _ci_calc_array_number_of_dimensions( ci_var *arg1 )
		{
			rarray *rarray_ptr;
			
			if (arg1->var_type != VAR_RESIZABLE_ARRAY)
					ci_runtime_error( 127, "Parameter 1 to array_number_of_dimensions must be a resizable array" );
			
			rarray_ptr = (rarray *) arg1->data.pvalue;

			return ( rarray_ptr->number_of_dimensions );
		}
		
		
		int sort_compare_n_asc( const void *item1, const void *item2 )
		{
			int stat;
			
			if (((sort_item_n *) item1)->nvalue < ((sort_item_n *) item2)->nvalue)
				stat = -1;
			else
			if (((sort_item_n *) item1)->nvalue > ((sort_item_n *) item2)->nvalue)
				stat = 1;
			else
				stat = 0;
		
			return (stat);
		}

		int sort_compare_n_desc( const void *item1, const void *item2 )
		{
			int stat;
			
			if (((sort_item_n *) item1)->nvalue < ((sort_item_n *) item2)->nvalue)
				stat = 1;
			else
			if (((sort_item_n *) item1)->nvalue > ((sort_item_n *) item2)->nvalue)
				stat = -1;
			else
				stat = 0;
		
			return (stat);
		}

		int sort_compare_s_asc( const void *item1, const void *item2 )
		{
			int stat;
			
			if (item1 == NULL || item2 == NULL)
				stat = 0;
			else
				stat = strcmp( ((sort_item_s *) item1)->svalue, ((sort_item_s *) item2)->svalue );
		
			return (stat);
		}

		int sort_compare_s_desc( const void *item1, const void *item2 )
		{
			int stat;
			
			if (item1 == NULL || item2 == NULL)
				stat = 0;
			else
				stat = - strcmp( ((sort_item_s *) item1)->svalue, ((sort_item_s *) item2)->svalue );
		
			return (stat);
		}

		int sort_compare_g_asc( const void *item1, const void *item2 )
		{
			int stat;
			
			if (item1 == NULL || item2 == NULL)
				stat = 0;
			else
			{
				ci_var_set_p( (ci_var *) gruntime_data->sp, (void *) ((sort_item_p *) item1)->pvalue );
				
				gruntime_data->sp += sizeof( ci_var );

				ci_var_set_p( (ci_var *) gruntime_data->sp, (void *) ((sort_item_p *) item2)->pvalue );
				
				gruntime_data->sp += sizeof( ci_var );
				
				(*_calcsys_function_table_ptr[sort_function_number])();
				
				gruntime_data->sp -= sizeof( ci_var );
				
				stat = ((ci_var *) gruntime_data->sp)->data.ivalue;
			}
			
			return (stat);
		}

		int sort_compare_g_desc( const void *item1, const void *item2 )
		{
			int stat;
			
			if (item1 == NULL || item2 == NULL)
				stat = 0;
			else
			{
				ci_var_set_p( (ci_var *) gruntime_data->sp, (void *) ((sort_item_p *) item1)->pvalue );
				
				gruntime_data->sp += sizeof( ci_var );

				ci_var_set_p( (ci_var *) gruntime_data->sp, (void *) ((sort_item_p *) item2)->pvalue );
				
				gruntime_data->sp += sizeof( ci_var );
				
				(*_calcsys_function_table_ptr[sort_function_number])();
				
				gruntime_data->sp -= sizeof( ci_var );
				
				stat = ((ci_var *) gruntime_data->sp)->data.ivalue;
			}
	
			if (stat > 0)
				stat = -1;
			else
			if (stat < 0)
				stat = 1;
				
			return (stat);
		}
				
				// versions of the sort functions using 'var' elements in the resizable arrays
	
		void _ci_calc_msort_v_3_3( ci_var *var_arg1, ci_var *var_arg2, long int var_arg3, long int var_arg4 )
		{
			int_64 i;
			int_64 num_items;
			int_64 array_len_in;
			int_64 array_len_out;
			rarray *ra_ptr_src;
			rarray *ra_ptr_dest;
			char *sp2;

			num_items = var_arg3;

			ra_ptr_src = (rarray *) var_arg1->data.pvalue;
			ra_ptr_dest = (rarray *) var_arg2->data.pvalue;
			
			if (var_arg1->var_type != VAR_RESIZABLE_ARRAY)
				ci_runtime_error( 128, "Variable type is not a resizable array. Call setsize." );

			if (var_arg2->var_type != VAR_RESIZABLE_ARRAY)
				ci_runtime_error( 129, "Variable type is not a resizable array. Call setsize." );
			
			array_len_in = ra_ptr_src->index_size[0];
			array_len_out = ra_ptr_dest->index_size[0];
	
			if (num_items < 0)
				ci_runtime_error( 130, "The requested sort number of items is a negative number" );

			if (num_items > array_len_in)
				ci_runtime_error( 131, "The requested sort exceeds the number of items in the input array" );

			if (num_items > array_len_out)
				ci_runtime_error( 132, "The requested sort exceeds the number of items in the output array" );

		
			sort_items_n = (sort_item_n *) _ci_malloc( sizeof( sort_item_n ) * num_items );

		
			for (i=0; i < num_items; i++)
			{
				sort_items_n[i].input_array_key = i;
				sort_items_n[i].nvalue = ((ci_var *) (ra_ptr_src->datap + i * sizeof( ci_var )))->data.nvalue;
			}
			
			
			if (var_arg4 == 1)
				qsort( sort_items_n, num_items, sizeof( sort_item_n ), sort_compare_n_asc );
			else
				qsort( sort_items_n, num_items, sizeof( sort_item_n ), sort_compare_n_desc );
			
			
			for (i=0; i < num_items; i++)
				ci_var_set_i( (ci_var *) (ra_ptr_dest->datap + i * sizeof( ci_var )), sort_items_n[i].input_array_key ); 
						
			_ci_free( sort_items_n );
		}


				// versions of the sort functions using 'var' elements in the resizable arrays
				
		void _ci_calc_ssort_v_3_3( ci_var *var_arg1, ci_var *var_arg2, long int var_arg3, long int var_arg4 )
		{
			char str[MEDIUM_STRING_BUFFER_SIZE];
			int_64 i;
			int_64 num_items;
			int_64 array_len_in;
			int_64 array_len_out;
			rarray *ra_ptr_src;
			rarray *ra_ptr_dest;
			char *sp2;

			num_items = var_arg3;

			ra_ptr_src = (rarray *) var_arg1->data.pvalue;
			ra_ptr_dest = (rarray *) var_arg2->data.pvalue;

			if (var_arg1->var_type != VAR_RESIZABLE_ARRAY)
				ci_runtime_error( 133, "Variable type is not a resizable array. Call setsize." );

			if (var_arg2->var_type != VAR_RESIZABLE_ARRAY)
				ci_runtime_error( 134, "Variable type is not a resizable array. Call setsize." );
			
			array_len_in = ra_ptr_src->index_size[0];
			array_len_out = ra_ptr_dest->index_size[0];

			if (num_items < 0)
				ci_runtime_error( 135, "The requested sort number of items is a negative number" );

			if (num_items > array_len_in)
				ci_runtime_error( 136, "The requested sort exceeds the number of items in the input array" );

			if (num_items > array_len_out)
				ci_runtime_error( 137, "The requested sort exceeds the number of items in the output array" );

			sort_items_s = (sort_item_s *) _ci_malloc( sizeof( sort_item_s ) * num_items );
		
			for (i=0; i < num_items; i++)
			{
				sort_items_s[i].input_array_key = i;

				ci_str_u32_to_u8( str, ((ci_var *) (ra_ptr_src->datap + i * sizeof( ci_var )))->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

				strncpy( sort_items_s[i].svalue, str, MAX_STR_SORT_SIGNIFICANT_CHARS );

				sort_items_s[i].svalue[MAX_STR_SORT_SIGNIFICANT_CHARS-1] = '\0';
			}
			
			if (var_arg4 == 1)
				qsort( sort_items_s, num_items, sizeof( sort_item_s ), sort_compare_s_asc );
			else
				qsort( sort_items_s, num_items, sizeof( sort_item_s ), sort_compare_s_desc );
			

			for (i=0; i < num_items; i++)
				ci_var_set_i( (ci_var *) (ra_ptr_dest->datap + i * sizeof( ci_var )), sort_items_s[i].input_array_key ); 
				
			_ci_free( sort_items_s );
		}

/*
		void _ci_calc_gsort( ci_var *arg1, ci_var *arg2, long int arg3, ci_var *arg4, char arg5 )
		{
			char compare_function_name[MEDIUM_STRING_BUFFER_SIZE];
			int_64 i;
			int_64 num_items;
			int_64 array_len_in;
			int_64 array_len_out;
			rarray *ra_ptr_src;
			rarray *ra_ptr_dest;
			char *sp2;

			ci_var_check_s( arg4 );

			strcpy( compare_function_name, "_calc_" );

			ci_str_u32_to_u8( &compare_function_name[6], arg4->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			sort_function_number = -1;

			for (i=0; i < _calcsys_num_function_table_items; i++)
			{
				if (strcmp( _calcsys_function_table_name[i], compare_function_name ) == 0)
					sort_function_number = 0;
			}
	
			if (sort_function_number == -1)
				ci_runtime_error( 138, "sort compare function not found" );

			num_items = arg3;

			ra_ptr_src = (rarray *) arg1->data.pvalue;
			ra_ptr_dest = (rarray *) arg2->data.pvalue;
			
			if (arg1->var_type != VAR_RESIZABLE_ARRAY)
				ci_runtime_error( 139, "Variable type is not a resizable array. Call setsize." );

			if (arg2->var_type != VAR_RESIZABLE_ARRAY)
				ci_runtime_error( 140, "Variable type is not a resizable array. Call setsize." );
			
			array_len_in = ra_ptr_src->index_size[0];
			array_len_out = ra_ptr_dest->index_size[0];
	
			if (num_items < 0)
				ci_runtime_error( 141, "The requested sort number of items is a negative number" );

			if (num_items > array_len_in)
				ci_runtime_error( 142, "The requested sort exceeds the number of items in the input array" );

			if (num_items > array_len_out)
				ci_runtime_error( 143, "The requested sort exceeds the number of items in the output array" );

		
			sort_items_p = (sort_item_p *) _ci_malloc( sizeof( sort_item_p ) * num_items );

		
			for (i=0; i < num_items; i++)
			{
				sort_items_p[i].input_array_key = i;
				sort_items_p[i].pvalue = ((ci_var *) (ra_ptr_src->datap + i * sizeof( ci_var )))->data.pvalue;
			}
			
			
			if (arg5 == 1)
				qsort( sort_items_p, num_items, sizeof( sort_item_p ), sort_compare_g_asc );
			else
				qsort( sort_items_p, num_items, sizeof( sort_item_p ), sort_compare_g_desc );
			
			
			for (i=0; i < num_items; i++)
				*((long int *) (ra_ptr_dest->datap + i * sizeof( long int ))) = sort_items_p[i].input_array_key; 
						
			_ci_free( sort_items_p );
		}
*/





//--------------------------------------------------------------------------
// System
//--------------------------------------------------------------------------

				
		char *_ci_calc_syget_get_parameter( ci_var *result, ci_var *arg1 )
		{
			char str[MEDIUM_STRING_BUFFER_SIZE];
			int i;
			int found;

			if (! is_web_page)
				ci_runtime_error( 144, "Program must be compiled with the :is_web_page option to use syget_get_parameter()" );
			
			ci_var_check_s( arg1 );
			
			found = false;
			
			ci_str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			for (i=0; i < ci_num_get_items; i++)
			{
				if (strcmp( ci_get_item_key[i], str ) == 0)
				{
					found = true;
					ci_var_set_s( result, ci_get_item_value[i] );
				}
			}
			
			if (! found)
				ci_var_set_s( result, "" );

			return ((char *) result);			
		}
	
	
		long int _ci_calc_syget_get_parameter_count()
		{
			return ((long int) ci_num_get_items);			
		}
	
	
		char *_ci_calc_syget_get_parameter_key( ci_var *result, long int arg1 )
		{
			if (! is_web_page)
				ci_runtime_error( 144, "Program must be compiled with the :is_web_page option to use syget_get_parameter_key()" );

			if (arg1 < 0 || arg1 >= ci_num_get_items)
			{
				ci_runtime_error( 209, "Get number out of range" );
				ci_var_set_s( result, "" );
			}
			else
				ci_var_set_s( result, ci_get_item_key[arg1] );

			return ((char *) result);			
		}


		char *_ci_calc_syget_get_parameter_value( ci_var *result, long int arg1 )
		{
			if (! is_web_page)
				ci_runtime_error( 144, "Program must be compiled with the :is_web_page option to use syget_get_parameter_value()" );

			if (arg1 < 0 || arg1 >= ci_num_get_items)
			{
				ci_runtime_error( 210, "Get number out of range" );
				ci_var_set_s( result, "" );
			}
			else
				ci_var_set_s( result, ci_get_item_value[arg1] );

			return ((char *) result);			
		}

				
		char *_ci_calc_syget_post_parameter( ci_var *result, ci_var *arg1 )
		{
			int i;
			int found;
			char str[MEDIUM_STRING_BUFFER_SIZE];

			if (! is_web_page)
				ci_runtime_error( 145, "Program must be compiled with the :is_web_page option to use syget_post_parameter()" );

			ci_var_check_s( arg1 );
			
			found = false;
			
			ci_str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			for (i=0; i < ci_num_post_items; i++)
			{
				if (strcmp( ci_post_item_key[i], str ) == 0)
				{
					found = true;
					ci_var_set_s( result, ci_post_item_value[i] );
				}
			}
			
			if (! found)
				ci_var_set_s( result, "" );
			
/* unchecked check boxes do not appear in the list
 			
			if (! found)
			{
				strcpy( str, arg1->data.svalue );
				strcat( str, ": get_and_post_filename: " );
				strcat( str, get_and_post_filename );
			
				ci_runtime_error( 146, "POST parameter not found:" );
			}
*/ 

			return ((char *) result);			
		}

		long int _ci_calc_syget_post_parameter_count()
		{
			return ((long int) ci_num_post_items);			
		}
	
	
		char *_ci_calc_syget_post_parameter_key( ci_var *result, long int arg1 )
		{
			if (! is_web_page)
				ci_runtime_error( 144, "Program must be compiled with the :is_web_page option to use syget_post_parameter_key()" );

			if (arg1 < 0 || arg1 >= ci_num_post_items)
			{
				ci_runtime_error( 209, "Post number out of range" );
				ci_var_set_s( result, "" );
			}
			else
				ci_var_set_s( result, ci_post_item_key[arg1] );

			return ((char *) result);			
		}


		char *_ci_calc_syget_post_parameter_value( ci_var *result, long int arg1 )
		{
			if (! is_web_page)
				ci_runtime_error( 144, "Program must be compiled with the :is_web_page option to use syget_post_parameter_value()" );

			if (arg1 < 0 || arg1 >= ci_num_post_items)
			{
				ci_runtime_error( 210, "Post number out of range" );
				ci_var_set_s( result, "" );
			}
			else
				ci_var_set_s( result, ci_post_item_value[arg1] );

			return ((char *) result);			
		}


				
		char *_ci_calc_syget_session_variable( ci_var *result, ci_var *arg1, ci_var *arg2 )
		{
			char str[MEDIUM_STRING_BUFFER_SIZE];
			int i;
			int found;

			if (! is_web_page)
				ci_runtime_error( 147, "Program must be compiled with the :is_web_page option to use syget_session_variable()" );

			ci_var_check_s( arg1 );
			
			found = false;

			ci_str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			for (i=0; i < ci_num_session_items; i++)
			{
				if (strcmp( ci_session_item_key[i], str ) == 0)
				{
					found = true;
					ci_var_set_s( result, ci_session_item_value[i] );
				}
			}
			
			if (! found)
				ci_var_set_s( result, "" );

			return ((char *) result);			
		}

		void _ci_calc_syset_session_variable( ci_var *varg1, ci_var *varg2, ci_var *arg3 )
		{
			int i;
			int found;
			char arg1[MEDIUM_STRING_BUFFER_SIZE];
			char arg2[MEDIUM_STRING_BUFFER_SIZE];

			if (! is_web_page)
				ci_runtime_error( 148, "Program must be compiled with the :is_web_page option to use syget_set_session_variable()" );

			ci_var_check_s( varg1 );
			ci_var_check_s( varg2 );
			
			ci_str_u32_to_u8( arg1, varg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			ci_str_u32_to_u8( arg2, varg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			found = false;
			
			for (i=0; i < ci_num_session_items; i++)
			{
				if (strcmp( ci_session_item_key[i], arg1 ) == 0)
				{
					found = true;
					
					_ci_free( ci_session_item_value[i] );
					
					ci_session_item_value[i] = (char *) _ci_malloc( strlen( arg2 ) + 1 );
					
					strcpy( ci_session_item_value[i], arg2 );
				}
			}
			
			if (ci_num_session_items >= MAX_SESSION_ITEMS)
			{
				printf( "Too many session items\n" );
				exit(1);
			}
			
			if (! found)
			{
				ci_session_item_key[ci_num_session_items] = (char *) _ci_malloc( strlen( arg1 ) + 1 );
			
				if (ci_session_item_key[ci_num_session_items][strlen(ci_session_item_key[ci_num_session_items])-1] == '\n')
					ci_session_item_key[ci_num_session_items][strlen(ci_session_item_key[ci_num_session_items])-1] = '\0';
					
				strcpy( ci_session_item_key[ci_num_session_items], arg1 );
				
				
				ci_session_item_value[ci_num_session_items] = (char *) _ci_malloc( strlen( arg2 ) + 1 );

				if (ci_session_item_value[ci_num_session_items][strlen(ci_session_item_value[ci_num_session_items])-1] == '\n')
					ci_session_item_value[ci_num_session_items][strlen(ci_session_item_value[ci_num_session_items])-1] = '\0';
					
				strcpy( ci_session_item_value[ci_num_session_items], arg2 );

				ci_num_session_items++;
			}
		}
		
				
		char *_ci_calc_syget_ip_address( ci_var *result )
		{
			ci_var_set_s( result, ip_address );

			return ((char *) result);			
		}

				
		char _ci_calc_sylow_res_screen()
		{
			if (low_res_screen)
				return ( 1 );
			else
				return ( 0 );
		}

		void _ci_calc_syset_process_background_priority()
		{
			nice( 8 );
		}
				
				
		void _ci_calc_syexit( long int arg1 )
		{
			ci_calc_stdlib_exit( ci_get_and_post_filename );
					
			gruntime_data->ic_ptr = gruntime_data->ic_end;
		
			if (memory_report)
			{
				printf( "Stack size (bytes): %ld\n", stack_size );
				
				printf( "Peak stack usage (bytes): %ld\n", peak_stack_usage );
				
				printf( "Peak bytes dynamic memory allocated: %ld\n", peak_bytes_malloced );
			}
			
			ci_calcsys_exit_code = arg1;
		}

				
		void _ci_calc_init_acv_sessions( ci_var *result, ci_var *arg1 )
		{
			; // not implemented yet
		}

				
		void _ci_calc_acv_session_set( ci_var *result, ci_var *arg1, ci_var *arg2, ci_var *arg3 )
		{
			; // not implemented yet
		}

				
		void _ci_calc_acv_session_get( ci_var *result, ci_var *arg1, ci_var *arg2 )
		{
			; // not implemented yet
		}

				
		void _ci_calc_acv_session_id( ci_var *result )
		{
			; // not implemented yet
		}

				
		void _ci_calc_process_external_entry_point( ci_var *result, ci_var *arg1 )
		{
			; // not implemented yet
		}

				
		void _ci_calc_exit_if_session_expired( ci_var *result, ci_var *arg1 )
		{
			; // not implemented yet
		}
		

	char *sleft( char *dest, char const *src, int_64 len )
	{
		if (len <= 0)
			*dest = '\0';
		else
		{
			strncpy( dest, src, len );
		
			dest[len] = '\0';
		}
		
		return (dest);
	}
	
				
	char *sright( char *dest, char const *src, int_64 len )
	{			
		if (len <= 0)
			*dest = '\0';
		else
		{		
			if (len >= strlen( src ))
				strcpy( dest, src );
			else
				strcpy( dest, &src[strlen( src ) - len] );
		}
		
		return (dest);
	}
				
	char *smid( char *dest, char const *src, int_64 start, int_64 len )
	{
		if (start < 0 || len <= 0 || start >= strlen( src ))
			*dest = '\0';
		else
		{ 
			strncpy( dest, &(src[start]), len ); 

			dest[len] = '\0';
		}
		
		return (dest);
	}	

	void ci_dec_to_hex( char *dest, unsigned char *src, int_64 num_bytes, int asc, int pad_with_leading_zeros )
	{
		int i, j;
		unsigned char ch;
		unsigned char high_nibble;
		unsigned char low_nibble;
		char *ptr;
		
		j=0;
		
		if (asc)
		{
			for (i=0; i < num_bytes; i++)
			{
				ch = src[i];
				
				high_nibble = ch / 16;
				
				low_nibble = ch - high_nibble * 16;
				 
				dest[j++] = dec_to_hex_1_nibble( high_nibble ); 
				
				dest[j++] = dec_to_hex_1_nibble( low_nibble );
			}
		}
		else
		{
			for (i=num_bytes-1;  i >= 0; i--)
			{
				ch = src[i];
				
				high_nibble = ch / 16;
				
				low_nibble = ch - high_nibble * 16;
				 
				dest[j++] = dec_to_hex_1_nibble( high_nibble ); 
				
				dest[j++] = dec_to_hex_1_nibble( low_nibble );
			}
		}
		
		dest[j] = '\0';
		
			// trunc leading 0's
			
		if (! pad_with_leading_zeros)
		{
			for (ptr=dest; *ptr == '0'; ptr++) ;
			
			if (*ptr == '\0')
				strcpy( dest, "0" );
			else
				strcpy( dest, ptr );
		}			
	}
	
	
	void hex_to_binary( unsigned char *dest, char *src )
	{
		int_64 i, j;
		
		if (strlen( src ) % 2 == 1)
			ci_runtime_error( 149, "Text string must be a multiple of 2 in length" );
		
		j=0;
		
		for (i=0; i < strlen( src ); i += 2)
			dest[j++] = ci_hex_to_dec_1_char(src[i]) * 16 + ci_hex_to_dec_1_char(src[i+1]);
	}
	

	int_64 hex_to_int( char *src )
	{
		int_64 i;
		int_64 result;
		int_64 multiplier;
		
		result = 0;
		multiplier = 1;
		
		for (i = strlen( src )-1; i >= 0; i--)
		{
			result += multiplier * ci_hex_to_dec_1_char( src[i] );
			multiplier *= 16;
		}
		
		return (result);
	}


	unsigned char dec_to_hex_1_nibble( unsigned char i )
	{
		unsigned char dest;
		
		dest = 0;
		
		if (i == 0)				dest = '0';		else		
		if (i == 1)				dest = '1';		else		
		if (i == 2)				dest = '2';		else		
		if (i == 3)				dest = '3';		else		
		if (i == 4)				dest = '4';		else		
		if (i == 5)				dest = '5';		else		
		if (i == 6)				dest = '6';		else		
		if (i == 7)				dest = '7';		else		
		if (i == 8)				dest = '8';		else		
		if (i == 9)				dest = '9';		else		
		if (i == 10)			dest = 'A';		else
		if (i == 11)			dest = 'B';		else
		if (i == 12)			dest = 'C';		else
		if (i == 13)			dest = 'D';		else
		if (i == 14)			dest = 'E';		else
		if (i == 15)			dest = 'F';
	
		return (dest);
	}


	unsigned char ci_hex_to_dec_1_char( char ch )
	{
		unsigned char dest;
	
		dest = 0;
		
		ch = toupper( ch );
		
		if (ch == '0')			dest = 0;		else
		if (ch == '1')			dest = 1;		else
		if (ch == '2')			dest = 2;		else
		if (ch == '3')			dest = 3;		else
		if (ch == '4')			dest = 4;		else
		if (ch == '5')			dest = 5;		else
		if (ch == '6')			dest = 6;		else
		if (ch == '7')			dest = 7;		else
		if (ch == '8')			dest = 8;		else
		if (ch == '9')			dest = 9;		else
		if (ch == 'A')			dest = 10;		else
		if (ch == 'B')			dest = 11;		else
		if (ch == 'C')			dest = 12;		else
		if (ch == 'D')			dest = 13;		else
		if (ch == 'E')			dest = 14;		else
		if (ch == 'F')			dest = 15;
			
		return (dest);
	}
	
	
	void convert_date_to_yyyymmdd( char *dt, char *this_date, char *date_format )
	{
		int i, j;
		char *day, *month, *year;
		char parts[3][SMALL_STRING_BUFFER_SIZE];
		char str[SMALL_STRING_BUFFER_SIZE];

		if (*this_date == '\0')
			ci_runtime_error( 150, "Blank date." );
		else
		{
			j = 0;
	
			parts[0][0] = '\0';
			parts[1][0] = '\0';
			parts[2][0] = '\0';
	
			for (i=0; i < strlen(this_date) && j <= 2; i++)
			{
				if (is_digit( this_date[i] ))
				{
					str[0] = this_date[i];
					str[1] = '\0';
					
					strcat( &parts[j][0], str );
				}
				else
					j = j + 1;
			}
	
	        if (*date_format == '\0')
	        {
	            strcpy( dt, "0000-00-00" );
	        }
	        else
			if (strcmp( date_format, "dd/mm/yyyy" ) == 0)
			{
				day = &parts[0][0];
				month = &parts[1][0];
				year = &parts[2][0];
			}
			else
			if (strcmp( date_format, "mm/dd/yyyy" ) == 0)
			{
				month = &parts[0][0];
				day = &parts[1][0];
				year = &parts[2][0];
			}
			else
			if (strcmp( date_format, "yyyy/mm/dd" ) == 0)
			{
				year = &parts[0][0];
				month = &parts[1][0];
				day = &parts[2][0];
			}
			else
				ci_runtime_error( 151, "Invalid date format" );
	
			if (strlen( day ) == 1)
			{
				str[0] = '0';
				str[1] = '\0';
				
				strcat( str, day );
				strcpy( day, str );
			}
			
			if (strlen( month ) == 1)
			{
				str[0] = '0';
				str[1] = '\0';
				
				strcat( str, month );
				strcpy( month, str );
			}
	
			
			if (strlen( year) == 2)
			{
				if (atoi( year ) < 50)
				{
					str[0] = '2';
					str[1] = '0';
					str[2] = '\0';
				}
				else
				{
					str[0] = '1';
					str[1] = '9';
					str[2] = '\0';
				}
				
				strcat( str, year );
				strcpy( year, str );
			}
		
	
	//        if ((! is_numeric( $day )) || (! is_numeric( $month )) || (! is_numeric( $year )))
	//            return ("0000-00-00");
	//        else
	
			strcpy( dt, year );
			strcat( dt, "-" );
			strcat( dt, month );
			strcat( dt, "-" );
			strcat( dt, day );
			
			if (! ci_check_date_valid( dt, "yyyy-mm-dd" ))
				ci_runtime_error( 152, "Invalid date." );
		}
	}


	int last_day_of_the_month( int year, int month )
	{
		int result;
		
		if (month == 2)
		{
			if (is_leap_year( year ))
				result = 29;
			else
				result = 28;
		}
		else
		if (month == 4 ||
			month == 6 ||
			month == 9 ||
			month == 11)
				result = 30;
		else
			result = 31;
			
		return (result);
	}

	
		// returns true for date ok and false if a date is invalid.
		
	int ci_check_date_valid( char const *date_text2, char const *format )
	{
        char day_text[SMALL_STRING_BUFFER_SIZE];
        char month_text[SMALL_STRING_BUFFER_SIZE];
        char year_text[SMALL_STRING_BUFFER_SIZE];
		int iday;
		int imonth;
		int iyear;
		int ok;
	
	    if (strlen( date_text2 ) != 10 || strcmp( date_text2, "0000-00-00" ) == 0)
			ok =  false;
        else
        {
			if (strcmp( format, "yyyy-mm-dd" ) == 0 || strcmp( format, "yyyy/mm/dd" ) == 0)
			{
	            smid( day_text, date_text2, 8, 2 );
	            smid( month_text, date_text2, 5, 2 );
	            smid( year_text, date_text2, 0, 4 );
			}
			else
			if (strcmp( format, "dd/mm/yyyy" ) == 0)
			{
	            smid( day_text, date_text2, 0, 2 );
	            smid( month_text, date_text2, 3, 2 );
	            smid( year_text, date_text2, 6, 4 );
			}
			else
			if (strcmp( format, "mm/dd/yyyy" ) == 0)
			{
	            smid( day_text, date_text2, 3, 2 );
	            smid( month_text, date_text2, 0, 2 );
	            smid( year_text, date_text2, 6, 4 );
			}
			else
				ci_runtime_error( 153, "Invalid date format in ci_check_date_valid()" );
			
			ok = true;
		
            if ((! is_digit( day_text[0] ))   ||
                (! is_digit( day_text[1] ))   ||
                (! is_digit( month_text[0] )) ||
                (! is_digit( month_text[1] )) ||
                (! is_digit( year_text[0] ))  ||
                (! is_digit( year_text[1] ))  ||
                (! is_digit( year_text[2] ))  ||
                (! is_digit( year_text[3] )))
    			ok =  false;
            else
            {
				iday = atoi( day_text );
				imonth = atoi( month_text );
				iyear = atoi( year_text );
                        
	            if (imonth == 0 || imonth > 12 || iday == 0)
	    			ok =  false;
	            else
	            {
	            	switch (imonth)
	            	{
	            		case 1:
	            		
	                		if (iday > 31)
	        					ok =  false;
	        				break;

	            		case 2:
	        				
			                if (is_leap_year( iyear ) && iday > 29 )
			        			ok =  false;
			        		else
			                if ((! is_leap_year( iyear )) && iday > 28 )
			        			ok =  false;
							break;
							
	            		case 3:

	                		if (iday > 31)
	        					ok =  false;
	        				break;

	            		case 4:

	                		if (iday > 30)
	        					ok =  false;
	        				break;
	        		
	            		case 5:

	                		if (iday > 31)
	        					ok =  false;
	        				break;
	        		
	            		case 6:

	                		if (iday > 30)
	        					ok =  false;
	        				break;
	        		
	            		case 7:

	                		if (iday > 31)
	        					ok =  false;
	        				break;
	        		
	            		case 8:

	                		if (iday > 31)
	        					ok =  false;
	        				break;
	        		
	            		case 9:

	                		if (iday > 30)
	        					ok =  false;
	        				break;
	        		
	            		case 10:

	                		if (iday > 31)
	        					ok =  false;
	        				break;
	        		
	            		case 11:

	                		if (iday > 30)
	        					ok =  false;
	        				break;
	        		
	            		case 12:

	                		if (iday > 31)
	        					ok =  false;
	        				break;
			    	}			    		
	        	}
	    	}
        }

		return (ok);
	}

		// returns true for time ok and false if a date is invalid. HH:MM:SS format.
		
	int ci_check_time_valid( char const *time_text )
	{
		char str4[SMALL_STRING_BUFFER_SIZE];
		int ok;
		int hour, minute, seconds;
		
		ok = true;
		
	    if ((! is_digit( time_text[0] ))   ||
            (! is_digit( time_text[1] ))   ||
            (! is_digit( time_text[3] )) ||
            (! is_digit( time_text[4] )) ||
            (! is_digit( time_text[6] ))  ||
            (! is_digit( time_text[7] )))
				ok = false;

	    if (time_text[2] != ':')
			ok = false;

	    if (time_text[5] != ':')
			ok = false;
				
		if (ok)
		{
			hour = atoi( sleft( str4, time_text, 2 ) );
			minute = atoi( smid( str4, time_text, 3, 2 ) );
			seconds = atoi( sright( str4, time_text, 2 ) );
			 
			if (hour > 23 || minute > 59 || seconds > 59)
				ok = false;
		}
		
		return (ok);
	}


	int ci_check_datetime_valid( char const *datetime_text )
	{
		int ok;
		char date_txt[SMALL_STRING_BUFFER_SIZE];
		char time_txt[SMALL_STRING_BUFFER_SIZE];
		
		ok = true;
		
		if (strlen( datetime_text ) != 19)
			ok = false;
		else
		{
			if (datetime_text[10] != ' ')
				ok = false;
			else
			{
				sleft( date_txt, datetime_text, 10 );
				sright( time_txt, datetime_text, 8 );
				
				if ((! ci_check_date_valid( date_txt, "yyyy-mm-dd" )) || (! ci_check_time_valid( time_txt )))
					ok = false;
			}
		}
		
		return (ok);
	}
					

	int is_digit( char ch )
	{
	    int stat;
	    
	    if (ch >= '0' && ch <= '9')
	        stat = true;
	    else
	        stat = false;
	        
		return (stat);
	}
	
	
    int is_leap_year( int year )
    {
    	int leap_year;
    	
        leap_year = false;
        
        if ((year / 4) == ((double) year / 4))
            leap_year = true;

        if ((year / 100) == ((double) year / 100))
            leap_year = false;
            
        if ((year / 400)  == ((double) year / 400))
            leap_year = true;
    
        return (leap_year);
    }


	
		// input date YYYY-MM-DD
		
		// Days since January 1 4713 BC
		
	long convert_date_to_julian( char *this_date )
	{
		char day_text[SMALL_STRING_BUFFER_SIZE];
		char month_text[SMALL_STRING_BUFFER_SIZE];
		char year_text[SMALL_STRING_BUFFER_SIZE];
		double day, month, year;
		long julian_date;
		
		if (ci_check_date_valid( this_date, "yyyy-mm-dd" ))
		{
			sright( day_text, this_date, 2 );
			smid( month_text, this_date, 5, 2 );
			sleft( year_text, this_date, 4 );
			
			day = atoi( day_text );
			month = atoi( month_text );
			year = atoi( year_text );
			
			julian_date = jtrunc(1461 * (year + 4800 + jtrunc((month - 14)/12))/4) + jtrunc((367 * (jtrunc((month - 2 - 12 * jtrunc((month - 14)/12)))/12)) ) - jtrunc((3 * ((year + 4900 + jtrunc((month - 14)/12))/100))/4) + day - 32075;
		}
		else
			ci_runtime_error( 154, "Invalid date text in convert_date_to_julian()" );
				
		return (julian_date);
	}

		// output date YYYY-MM-DD
		
	void convert_julian_to_date( char *str, long J )
	{
		double y, j, r, v, u, w, B, C, f, g;
		int h, s, n, m, e, p;
		
		int day;
		int month;
		int year;
	
		y = (double) 4716;	
		j = (double) 1401;	
		m = (double) 2;
		n = (double) 12;	
		r = (double) 4;	
		p = (double) 1461;	
		v = (double) 3;
		u = (double) 5;
		s = (double) 153;
		w = (double) 2;
		B = (double) 274277;
		C = (double) -38;

		f = J + j + jtrunc((jtrunc((4 * J + B) / 146097) * 3) / 4) + C;
		e = r * f + v;
		g = jtrunc( (e % p) / r );
		h = u * g + w;
		
		day = jtrunc((h % s) / u) + 1;
		month = ((int) (jtrunc(h / s) + m) % n) + 1;
		year = jtrunc(e / p) - y + jtrunc((n + m - month) / n);
		
		sprintf( str, "%04d-%02d-%02d", year, month, day );
	}
	
			// 0 = Sunday
			
	int jweekday( long julian_date )
	{
		return ((julian_date + 1) % 7);	
	}
	
		// truncate towards 0
		
	double jtrunc( double num )
	{
		double num2;
		
		if (num >= 0)
			num2 = floor( num );
		else
			num2 = ceil( num );
		
		return (num2);	
	}


	double max( double num1, double num2 )
	{
		double num3;
		
		if (num1 > num2)
			num3 = num1;
		else
			num3 = num2;
			
		return (num3);
	}	


	void ci_setup_get_and_post_arrays( char const *get_and_post_filename )
	{
	    char str[MAX_POST_ITEM_SIZE];
	    char str2[MAX_POST_ITEM_SIZE];
	    char base[MEDIUM_STRING_BUFFER_SIZE];
	    char filename[MEDIUM_STRING_BUFFER_SIZE];
	    FILE *fp;
	    char *ptr;

		ci_num_get_items = 0;
		
		ci_num_post_items = 0;
	    
	    ci_num_session_items = 0;
	    
	    fp = fopen( get_and_post_filename, "r" );
	    
	    if (fp == NULL)
	    {
	    	printf( "\nCan't open get_and_post file: %s\n\n", get_and_post_filename );
			exit(1);
	    }

	    while (! feof( fp ))
	    {
	    	fgets( str, MAX_POST_ITEM_SIZE, fp );
	    	
	    	str[strlen(str)-1] = '\0';

	    	if (strcmp( str, "IP_ADDRESS" ) == 0)
	    	{
		    	fgets( ip_address, MAX_POST_KEY_SIZE, fp );
		    	
		    	ip_address[strlen(ip_address)-1] = '\0';
	    	}
	    	else
	    	if (strcmp( str, "LOW_RES_SCREEN" ) == 0)
	    	{
		    	fgets( str, MAX_POST_KEY_SIZE, fp );
		    	str[strlen(str)-1] = '\0';
		    	
		    	if (strcmp( str, "1" ) == 0)
		    		low_res_screen = true;
		    	else
		    		low_res_screen = false;
	    	}
	    	else
	    	if (strcmp( str, "POST" ) == 0)
			{	    	
		    	fgets( str, MAX_POST_KEY_SIZE, fp );
		    	str[strlen(str)-1] = '\0';
	    		strncpy( ci_post_item_key[ci_num_post_items], str, MAX_POST_KEY_SIZE );
	    		ci_post_item_key[ci_num_post_items][MAX_POST_KEY_SIZE] = '\0';

		    	fgets( str, MAX_POST_ITEM_SIZE, fp );
		    	str[strlen(str)-1] = '\0';
		    	
		    	str_replace( str2, str, "\\n", "\n" );
		    	
		    	ci_post_item_value[ci_num_post_items] = (char *) _ci_malloc( strlen(str2) + 1 ); 

	    		strcpy( ci_post_item_value[ci_num_post_items], str2 );
	    		
	    		ci_num_post_items++;
	    	}
	    	else
	    	if (strcmp( str, "SESSION" ) == 0)
			{	    	
		    	fgets( str, MAX_SESSION_KEY_SIZE, fp );
		    	
				ci_session_item_key[ci_num_session_items] = (char *) _ci_malloc( strlen( str ) + 1 );
		    	
	    		strcpy( ci_session_item_key[ci_num_session_items], str );

		    	fgets( str, MAX_SESSION_ITEM_SIZE, fp );
		    	
		    	str_replace( str2, str, "\\n", "\n" );
		    	
		    	ci_session_item_value[ci_num_session_items] = (char *) _ci_malloc( strlen(str2) + 1 ); 

	    		strcpy( ci_session_item_value[ci_num_session_items], str2 );
	    		
				if (ci_session_item_key[ci_num_session_items][strlen(ci_session_item_key[ci_num_session_items])-1] == '\n')
					ci_session_item_key[ci_num_session_items][strlen(ci_session_item_key[ci_num_session_items])-1] = '\0';
					
				if (ci_session_item_value[ci_num_session_items][strlen(ci_session_item_value[ci_num_session_items])-1] == '\n')
					ci_session_item_value[ci_num_session_items][strlen(ci_session_item_value[ci_num_session_items])-1] = '\0';
	    		
	    		ci_num_session_items++;
	    	}
	    	else
	    	if (strcmp( str, "GET" ) == 0)
			{	    	
		    	fgets( str, MAX_GET_KEY_SIZE, fp );
		    	str[strlen(str)-1] = '\0';
	    		strncpy( ci_get_item_key[ci_num_get_items], str, MAX_GET_KEY_SIZE );
	    		ci_get_item_key[ci_num_get_items][MAX_GET_KEY_SIZE] = '\0';

		    	fgets( str, MAX_GET_ITEM_SIZE, fp );
		    	str[strlen(str)-1] = '\0';
	    		strncpy( ci_get_item_value[ci_num_get_items], str, MAX_GET_ITEM_SIZE );
	    		ci_get_item_value[ci_num_get_items][MAX_GET_ITEM_SIZE] = '\0';
	    		
	    		ci_num_get_items++;
	    	}
	    }
	    
	    fclose( fp );
	}		


	void str_replace( char *dest, char *src, string str_search, string str_replace )
	{
		char *ptr1;
		char *ptr2;
		int_64 len;
		char const *search; 
		char const *replace;

		search = str_search.c_str(); 
		replace = str_replace.c_str();
		
		ptr1 = src;
		ptr2 = dest;
		len = strlen( search );
		
		*ptr2 = '\0';
		
		while (*ptr1 != '\0')
		{
			if (strncmp( ptr1, search, len ) == 0)
			{
				strcat( ptr2, replace );
				
				ptr2 += strlen( replace );
				
				ptr1 += strlen( search );
			}
			else
			{
				*ptr2++ = *ptr1++;
			}
			
			*ptr2 = '\0';
		}
		
		*ptr2 = '\0';		
	}


	int_64 str_search( char *src, char *search )
	{
		char *ptr1;
		int_64 len;
		int_64 pos;
		
		pos = -1;
		
		ptr1 = src;
		
		len = strlen( search );
		
		while (*ptr1 != '\0' && pos == -1)
		{
			if (strncmp( ptr1, search, len ) == 0)
				pos = ptr1 - src;
			else
				ptr1++;
		}
		
		return (pos);		
	}

	int_64 str_rsearch( char *src, char *search )
	{
		char *ptr1;
		int len;
		int pos;
		
		pos = -1;
		
		len = strlen( search );
		
		if (len > 0)
		{ 
			ptr1 = src + strlen( src ) - 1;
			
			while (ptr1 >= src && pos == -1)
			{
				if (strncmp( ptr1, search, len ) == 0)
					pos = ptr1 - src;
				else
					ptr1--;
			}
		}
				
		return (pos);		
	}


//	function sysfunc_error( $ic, $ic_ptr, $text )
//	{
//		echo "Runtime error system functions: Line ".$ic[$ic_ptr]['line_number'].": ".$ic[$ic_ptr]['input_filename'].": ".$text."<br>";
//
//			var_set_n( result, 31 );
//	}


