//<?
			// (c) Copyright Mark McIlroy 2022

#include "ci_external.h"


#define true			1
#define false			0


#define VAR_DECIMAL_SCALE 				100
#define VAR_DECIMAL_ROUNDING_OFFSET		0.5


#define MAX_NESTED_FUNCTION_CALLS 		 100000

#define STRING_BUFFER_SIZE				1000000


#define CHECK_NUMERIC_DISALLOW_NEGATIVES				0x1
#define CHECK_NUMERIC_DISALLOW_DECIMALS					0x2
#define CHECK_NUMERIC_ALLOW_SCIENTIFIC_NOTATION			0x4


#define PUSH_FLAGS_PRE_INC 		1
#define PUSH_FLAGS_PRE_DEC 		2
#define PUSH_FLAGS_POST_INC 	4
#define PUSH_FLAGS_POST_DEC 	8

#define MAX_INDIRECTION_LEVELS  1000

#define MAX_ARGC				100

#define MAX_INPUT_FILES  		1000

#define MAX_RARRAY_DIMENSIONS 	15

#define MAX_QUERIES 			10000

#define MAX_OPS					300

#define MAX_USER_FUNCTIONS		100000


// Size of the VAR structure. If updating this also update it in config.php and library_calc.calch

//#define SIZEOF_VAR 			16
//#define SIZEOF_VAR_x_2		32



#define MEDIUM_STRING_BUFFER_SIZE 	20000
#define SMALL_STRING_BUFFER_SIZE 	200



// Data types for the generated code. int_64 is intended to be a 64 bit integer however this is not actually required,
//     it can be defined as a type that results in a 32 bit integer for smaller systems.


typedef struct rarray 
{
	char *datap;
	int number_of_dimensions;
	int sizeof_array_element;			// number of bytes
	int_64 total_size;					// number of bytes
	int_64 index_size[15];				// number of elements
} rarray;


typedef struct
{
	char status;						// 1 = active, 2 = has been freed
	string type_map;
	int_64 block_size;
	char *data_ptr;
} dyn_block;


void *_ci_malloc( int_64 size );
void _ci_free( void *ptr );


//void var_clear( ci_var *vptr );
//void var_clear_b( ci_var *vptr );
void ci_copy_var( ci_var *vptr_dest, ci_var *vptr_src );
void ci_copy_var_no_debug( ci_var *vptr_dest, ci_var *vptr_src );
//int get_var_type( char *vptr );
//void set_var_type( char *vptr, int var_type );


//int isset( ci_var *vptr );
void ci_trim_trailing_zeros( char *s );
//void pre_inc( char *vptr, int push_flags );
//void post_inc( char *vptr, int push_flags );


// interface to C code calling Calc

/*
void calc_init( int argc, char *argv[] );
void push_function_arg_int( int value );
void push_function_arg_decimal( int value );
void push_function_arg_double( double value );
void push_function_arg_string( char *str );
void push_function_arg_byreference( ci_var *value );
void pop_function_return_value( ci_var *ret_value );
*/

string ci_text_is_valid_number( string text, int options, bool& is_numeric );

string ci_make_type_map( string type1 );
void ci_make_type_map_1( string type1, string& type_map );

void init_data_type( ci_var *vptr, string type1 );

void ci_calc_stdlib_init( char const *get_and_post_filename );
void ci_var_copy_rarray_p( ci_var *vptr_dest, ci_var *vptr_src, int sizeof_ci_var );
//void var_clear_b( ci_var *vptr );
void ci_var_check_s( ci_var *vptr );
int ci_str_u32_eq( char *str1, char *str2 );
int ci_str_u32_cmp( char *str1, char *str2 );
void ci_free_curr_mem( ci_var *vptr, int sizeof_var, int_64 len );
void ci_free_curr_mem_1( ci_var *vptr );
void ci_op_setsize( int_64 element_size, string element_type );
void ci_op_array_dereference_rtc();
void ci_op_array_dereference();
//void _ci_op_push_rel_variable_addr( int sizeof_var	 );
//void _ci_op_push_var( int push_flags );
void _ci_op_strconcat();
void _ci_op_strconcat_n_items( int num_items );
void _ci_op_strconcat_n_items_no_debug( int num_items );
