			
#define VAR_EMPTY			0
#define VAR_STRING			1		// string, date, time, datetime data types
#define VAR_INT				2		// int and bool data types
#define VAR_DECIMAL			3
#define VAR_DOUBLE			4
#define VAR_BINARY			5
#define VAR_RESIZABLE_ARRAY 6
#define VAR_POINTER			7

const int MAX_INCLUDE_PATHS 	= 100;
const int MAX_CI_ERROR_MESSAGES = 100;

extern char *ci_error_messages[MAX_CI_ERROR_MESSAGES];
extern int num_ci_error_messages;




typedef long int 	int_64;
typedef int 		int_32;
typedef short int 	int_16;
typedef char 		int_8;


typedef struct ci_var
{
	union
	{
		int_64 ivalue;					// int and bool data types
		double nvalue;					// double data type
		int_64 dvalue;					// decimal data type, scaled by 100
		char *svalue;					// string, date, time, datetime data types
		unsigned char *bvalue;			// binary data type
		char *pvalue;					// ptr
	} data;
	
	int_8 var_type;
	int_8 is_constant_string;
	
} ci_var;




void ci_var_set_i( ci_var *vptr, int_64 n ); 
void ci_var_set_d( ci_var *vptr, int_64 n );
void ci_var_set_n( ci_var *vptr, double n );
void ci_var_set_s( ci_var *vptr, const char *s );
void ci_var_set_s_u32( ci_var *vptr, char *s, int is_constant_string );
void ci_var_set_as_empty( ci_var *vptr );
void ci_var_set_b( ci_var *vptr, ci_var *vptr_src );
void ci_var_set_b_2( ci_var *vptr, char *bits, int num_bytes );
void ci_var_set_p( ci_var *vptr, void *ptr );


int ci_str_u8_to_u32( char *dest, const char *src );
void ci_str_u32_to_u8( char *dest, const char *src, int dest_size );

void ci_runtime_error( int error_number, string text );



extern "C" int c_calc_run_program( char const *c_program, char const *c_input_filename, int c_show_scan_trace, int c_run_code, int c_array_bounds_checks, int c_runtime_checks, int c_show_warnings, int c_command_line_mode, char const *c_include_paths[MAX_INCLUDE_PATHS], char const *c_source_code_language_file, int c_show_additional_warnings, int c_show_large_strings_warnings ); 
extern "C" void c_create_global_variables_segment();
extern "C" ci_var *c_add_global_variable( char *c_var_name, char *c_type1, int c_has_been_accessed, int c_initialise_variable, int c_overwrite_with_initial_value, long int init_ivalue, long int init_dvalue, double init_nvalue, char *c_init_svalue );
extern "C" void ci_free_all_system_memory_allocations();



