<?php


			// (c) Copyright Mark McIlroy 2022
		
	function call_sys_function( &$ic, &$ic_ptr, &$stack_value, $sp, &$stack_value_is_pointer, $function_name, $arg1, $arg2, $arg3, $arg4, $arg5, $arg6, $arg7, $arg8, $arg9, $arg10 )
	{
		$result = 0;

	//--------------------------------------------------------------------------
	// Input/Output
	//--------------------------------------------------------------------------
	
		switch ($function_name)
		{
			
		case "fopen":
		{
			$result = fopen( $arg1, $arg2 );
		}
		break;
		case "fgets":
		{
			$result = fgets( $arg1 );
		}
		break;
		case "fputs":
		{
			fputs( $arg2, $arg1 );
			
			$result = "";
		}
		break;
		case "feof":
		{
			if (feof( $arg1 ))
				$result = 1;
			else
				$result = 0;
		}
		break;
		case "fexists":
		{
			clearstatcache();
			
			if (file_exists( $arg1 ))
				$result = 1;
			else
				$result = 0;
		}
		break;
		case "fsize":
		{
			clearstatcache();
			
			$result = filesize( $arg1 );
		}
		break;
		case "fdelete":
		{
			unlink( $arg1 );
			
			$result = "";
		}
		break;
		case "fclose":
		{
			fclose( $arg1 );
		}
		break;
		case "fread":
		{
			$result = fread( $arg2, $arg1 );
		}
		break;
		case "fwrite":
		{
			fwrite( $arg3, $arg1, $arg2 );
			
			$result = "";
		}
		break;
		case "mkdir":
		{
			mkdir( $arg2 );
			
			$result = "";
		}
		break;	
		case "print":
		{
			echo $arg1."<br>";
		}

		break;
		case "output":
		{
			echo $arg1;
		}
	
	//--------------------------------------------------------------------------
	// Strings
	//--------------------------------------------------------------------------

		break;		
		case "slength":
		{
			$result = strlen( $arg1 );
		}
		
		break;		
		case "sleft":
		{
			$result = sleft( $arg1, $arg2 );
		}
			
		break;		
		case "sright":
		{
			$result = sright( $arg1, $arg2 );
		}
			
		break;		
		case "smid":
		{
			$result = substr( $arg1, $arg2, $arg3 );
		}
			
		break;		
		case "stoupper":
		{
			$result = strtoupper( $arg1 );
		}
			
		break;		
		case "stolower":
		{
			$result = strtolower( $arg1 );
		}
			
		break;		
		case "scaseieq":
		{
			if (strcasecmp( $arg1, $arg2 ) == 0)
				$result = 1;
			else
				$result = 0;
		}
			
		break;		
		case "ssearch":
		{
			$stat = strpos( $arg1, $arg2 );
			
			if ($stat === false)
				$result = -1;
			else
				$result = $stat;
		}
			
		break;		
		case "srsearch":
		{
			$stat = strrpos( $arg1, $arg2 );
			
			if ($stat === false)
				$result = -1;
			else
				$result = $stat;
		}
			
		break;		
		case "strim":
		{
			$result = trim( $arg1 );
		}
			
		break;		
		case "sreplace":
		{
			$result = str_replace( $arg3, $arg2, $arg1 );
		}
			
		break;		
		case "sexplode":
		{
			if (! $stack_value_is_pointer[$sp-2])
				sysfunc_error( $ic, $ic_ptr, "The third argument to sexplode() must be passed by reference, use &" );			
			
			$s = explode( $stack_value[$sp-3], $stack_value[$sp-4] );
			
			$i = 0;
			
			$sp2 = $sp-2;
			$indirection_levels = 0;
			
			
			while ($indirection_levels < MAX_INDIRECTION_LEVELS && $stack_value_is_pointer[$sp2])
			{
				$sp2 = $stack_value[$sp2];

				$indirection_levels++;
			}
						
			$j = $sp2;
			
			foreach ($s as $key => $value)
			{
				if ($i < $arg4)
				{
					$stack_value[$j++] = $value;
					$i++;
				}
			}
			
			$result = count( $s );
		}		

		break;		
		case "sjson_decode":
		{
			if ((! $stack_value_is_pointer[$sp-2]) ||
				(! $stack_value_is_pointer[$sp-3]))
					sysfunc_error( $ic, $ic_ptr, "The first two arguments to sjson_decode() must be passed by reference, use &" );			

			$returned_data = json_decode( $arg1, true );
	
			$separator = $arg3;
			
			$num_items = 0;
			 		
	//		echo "<table>";
	
			foreach( $returned_data as $key1 => $value1)
			{
				$key_oupt1 = $key1;
				
	//--			
				if (gettype( $returned_data[$key1] ) == "array")
				{
					foreach( $returned_data[$key1] as $key2 => $value2)
					{
						$key_oupt2 = $key_oupt1.$separator.$key2;
	//--			
						if (gettype( $returned_data[$key1][$key2] ) == "array")
						{
							foreach( $returned_data[$key1][$key2] as $key3 => $value3)
							{
								$key_oupt3 = $key_oupt2.$separator.$key3;
						
	//--			
								if (gettype( $returned_data[$key1][$key2][$key3] ) == "array")
								{
									foreach( $returned_data[$key1][$key2][$key3] as $key4 => $value4)
									{
										$key_oupt4 = $key_oupt3.$separator.$key4;
									
	//--			
										if (gettype( $returned_data[$key1][$key2][$key3][$key4] ) == "array")
										{
											foreach( $returned_data[$key1][$key2][$key3][$key4] as $key5 => $value5)
											{
												$key_oupt5 = $key_oupt4.$separator.$key5;
	
	
	//--			
												if (gettype( $returned_data[$key1][$key2][$key3][$key4][$key5] ) == "array")
												{
													foreach( $returned_data[$key1][$key2][$key3][$key4][$key5] as $key6 => $value6)
													{
														$key_oupt6 = $key_oupt5.$separator.$key6;
	
	
	//--			
														if (gettype( $returned_data[$key1][$key2][$key3][$key4][$key5][$key6] ) == "array")
														{
															foreach( $returned_data[$key1][$key2][$key3][$key4][$key5][$key6] as $key7 => $value7)
															{
																$key_oupt7 = $key_oupt6.$separator.$key7;
	
	
	//--			
																if (gettype( $returned_data[$key1][$key2][$key3][$key4][$key5][$key6][$key7] ) == "array")
																{
																	foreach( $returned_data[$key1][$key2][$key3][$key4][$key5][$key6][$key7] as $key8 => $value8)
																	{
																		$key_oupt8 = $key_oupt7.$separator.$key8;
	
	
	//--			
																		if (gettype( $returned_data[$key1][$key2][$key3][$key4][$key5][$key6][$key7][$key8] ) == "array")
																		{
																			foreach( $returned_data[$key1][$key2][$key3][$key4][$key5][$key6][$key7][$key8] as $key9 => $value9)
																			{
																				$key_oupt9 = $key_oupt8.$separator.$key9;
	
	//																			echo "<tr><td>".$key_oupt9."</td><td>".$value9."</td></tr>";
																				
																		 		$output_data_key[$num_items] = $key_oupt9;
																				$output_data_value[$num_items] = $value9;
																				$num_items++;
																			}
																		}
																		else
																		{
	//																		echo "<tr><td>".$key_oupt8."</td><td>".$value8."</td></tr>";
																	 		$output_data_key[$num_items] = $key_oupt8;
																			$output_data_value[$num_items] = $value8;
																			$num_items++;
																		}
																	} 
																}
																else
																{
	//																echo "<tr><td>".$key_oupt7."</td><td>".$value7."</td></tr>"; 
															 		$output_data_key[$num_items] = $key_oupt7;
																	$output_data_value[$num_items] = $value7;
																	$num_items++;
																}
															}
														}
														else
														{
	//														echo "<tr><td>".$key_oupt6."</td><td>".$value6."</td></tr>"; 
													 		$output_data_key[$num_items] = $key_oupt6;
															$output_data_value[$num_items] = $value6;
															$num_items++;
														}
													}
												}
												else
												{
	//												echo "<tr><td>".$key_oupt5."</td><td>".$value5."</td></tr>"; 
											 		$output_data_key[$num_items] = $key_oupt5;
													$output_data_value[$num_items] = $value5;
													$num_items++;
												}
											}
										}
										else
										{
	//										echo "<tr><td>".$key_oupt4."</td><td>".$value4."</td></tr>"; 
									 		$output_data_key[$num_items] = $key_oupt4;
											$output_data_value[$num_items] = $value4;
											$num_items++;
										}
									}
								}
								else
								{
	//								echo "<tr><td>".$key_oupt3."</td><td>".$value3."</td></tr>"; 
							 		$output_data_key[$num_items] = $key_oupt3;
									$output_data_value[$num_items] = $value3;
									$num_items++;
								}
							}
						}
						else
						{
	//						echo "<tr><td>".$key_oupt2."</td><td>".$value2."</td></tr>"; 
					 		$output_data_key[$num_items] = $key_oupt2;
							$output_data_value[$num_items] = $value2;
							$num_items++;
						}
					}
				}
				else
				{
	//				echo "<tr><td>".$key_oupt1."</td><td>".$value1."</td></tr>"; 
			 		$output_data_key[$num_items] = $key_oupt1;
					$output_data_value[$num_items] = $value1;
					$num_items++;
				}
			}
	
			$result = $num_items;
				
			$sp2 = $sp-2;
			$indirection_levels = 0;
			
			while ($indirection_levels < MAX_INDIRECTION_LEVELS && $stack_value_is_pointer[$sp2])
			{
				$sp2 = $stack_value[$sp2];
				$indirection_levels++;
			}
			
			$stack_value[$sp2] = $output_data_value;
			
			
			$sp2 = $sp-3;
			$indirection_levels = 0;
			
			while ($indirection_levels < MAX_INDIRECTION_LEVELS && $stack_value_is_pointer[$sp2])
			{
				$sp2 = $stack_value[$sp2];
				$indirection_levels++;
			}
			
			$stack_value[$sp2] = $output_data_key;
			
		}
	
	//--------------------------------------------------------------------------
	// Mathematics
	//--------------------------------------------------------------------------
	
		
		break;		
		case "mrand":
		{
			$max = (double) getrandmax();
			
			$result = ((double) rand( 0, $max )) / $max;
		}
			
		break;		
		case "mtrunc":
		{
			$result = (string) ((int) $arg1);
		}
			
		break;		
		case "msqrt":
		{
			$result = sqrt( $arg1 );
		}
			
		break;		
		case "mfabs":
		{
			$result = abs( $arg1, $arg2 );
		}
			
		break;		
		case "miabs":
		{
			$result = abs( $arg1, $arg2 );
		}
			
		break;		
		case "mfmax":
		{
			$result = max( $arg1, $arg2 );
		}
					
		break;		
		case "mfmin":
		{
			$result = min( $arg1, $arg2 );
		}
			
		break;		
		case "mimax":
		{
			$result = max( $arg1, $arg2 );
		}
			
		break;		
		case "mimin":
		{
			$result = min( $arg1, $arg2 );
		}
			
		break;		
		case "mlog":
		{
			$result = log( $arg1 );
		}
	
		break;		
		case "mlog10":
		{
			$result = log10( $arg1 );
		}
					
		break;		
		case "mexp":
		{
			$result = pow( 2.71828182845904, $arg1 ); 
		}
			
		break;		
		case "mround":
		{
			$result = round( (double) $arg1, (int) $arg2 );
		}

		break;		
		case "mformat":
		{
			if ($arg2 == 2)
				$result = number_format_needed( $arg1 );
			else
			if ($arg2 == 1)
				$result = number_format_fxd_decimals( $arg1, $arg3 );
		}
	
		break;		
		case "msin":
		{
			$result = sin( $arg1 );
		}

		break;		
		case "mcos":
		{
			$result = cos( $arg1 );
		}

		break;		
		case "mtan":
		{
			$result = tan( $arg1 );
		}

		break;		
		case "marcsin":
		{
			$result = asin( $arg1 );
		}

		break;		
		case "marccos":
		{
			$result = acos( $arg1 );
		}

		break;		
		case "marctan":
		{
			$result = atan( $arg1 );
		}
		

	//--------------------------------------------------------------------------
	// Forms
	//--------------------------------------------------------------------------
		
		break;
		case "form_start":
		{
			write_yellow_input_boxes();
			
			echo "<form id='".$arg1."' name='".$arg1."' action='".url_encode( $arg2 )."' method='POST'><table style='border: 1px solid #bbbbbb; background: linear-gradient(#fcfcfc, #e1e1e1)'>";
		}
		break;
		case "form_text":
		{
			form_text( "", $arg1, $arg2, $arg3, $arg4, $arg5, $arg6 );
		}
		break;
		case "form_dropdown":
		{
			form_dropdown( "", $arg1, $arg2, $arg3, $arg4, $arg5, $arg6 );
		}
		break;
		case "form_radio":
		{
			form_radio( "", $arg1, $arg2, $arg3, $arg4, $arg5, $arg6, $arg7 );
		}
		break;
		case "form_checkbox":
		{
			form_checkbox( "", $arg1, $arg2, $arg3, $arg4, $arg5 );
		}
		break;
		case "form_textarea":
		{
			form_textarea( "", $arg1, $arg2, $arg3, $arg4, $arg5, $arg6 );
		}
		break;
		case "form_password":
		{
			form_password( "", $arg1, $arg2, $arg3, $arg4, $arg5 );
		}
		break;
		case "form_submit_new":
		{
			show_green_button_submit( "", $arg2, (double) $arg3, $arg1 );
		}
		break;
		case "form_end":
		{
			form_end();
		}	
		break;
		case "show_link":
		{
			$result = "<a class='glink' href='" & $arg2 & "'>" & $arg1 & "</a>";
		}
	
	
	
	//--------------------------------------------------------------------------
	// Dates & times
	//--------------------------------------------------------------------------
	
		break;		
		case "dnow":
		{
			$result = date( "Y-m-d" );
		}
			
		break;		
		case "tnow":
		{
			$result = date( "H:i:s" );
		}
			
		break;		
		case "dtnow":
		{
			$result = date( "Y-m-d H:i:s" );
		}
			
		break;		
		case "dformat":
		{
			if (! check_date_valid( $arg1 ))
			{
				sysfunc_error( $ic, $ic_ptr, "Invalid date in dformat(): ".$arg1 );
				$result = "";
			}
			else
			{	
				$dt = date_create( $arg1 );
			
				$result = $dt->format( $arg2 );
			}
		}
			
		break;		
		case "tformat":
		{
			$dt = date_create( $arg1 );
			
			$result = $dt->format( $arg2 );
		}
			
		break;		
		case "dtformat":
		{
			$dt = date_create( $arg1 );
			
			$result = $dt->format( $arg2 );
		}

		break;		
		case "dadd":
		{
			if (! check_date_valid( $arg1 ))
				sysfunc_error( $ic, $ic_ptr, "Invalid date in dadd(): ".$arg1 );
			
			if ($arg2 == "day" || $arg2 == "days")
			{
				$result = convert_julian_to_date( convert_date_to_julian( $arg1 ) + $arg3 ); 
			}
			else 
			{
				date_parts( $arg1, $day, $month, $year );

				if ($arg2 == "month" || $arg2 == "months")
				{
					$month += $arg3;
					
					while ($month > 12)
					{
						$month -= 12;
						$year++;
					}
				}
				else
				if ($arg2 == "year" || $arg2 == "years")
				{
					$year += $arg3;
				}
				else
					sysfunc_error( $ic, $ic_ptr, "Invalid date type: ".$arg2 );
				
				if ($month == 2 && $day == 29 && (! is_leap_year( $year )))
					$day = 28;

				$result = date_from_parts( $day, $month, $year );
			}
					
/*	
			$dt = date_create( $arg3 );
	
			date_add( $dt, date_interval_create_from_date_string( $arg1." ".$arg2 ));
			
			$result = $dt->format( "Y-m-d" );
*/ 
		}
			
		break;		
		case "dsub":
		{
			if (! check_date_valid( $arg1 ))
				sysfunc_error( $ic, $ic_ptr, "Invalid date in dsub(): ".$arg1 );
			
			if ($arg2 == "day" || $arg2 == "days")
			{
				$result = convert_julian_to_date( convert_date_to_julian( $arg1 ) - $arg3 ); 
			}
			else 
			{
				date_parts( $arg1, $day, $month, $year );

				if ($arg2 == "month" || $arg2 == "months")
				{
					$month -= $arg3;
					
					while ($month < 1)
					{
						$month += 12;
						$year--;
					}
				}
				else
				if ($arg2 == "year" || $arg2 == "years")
				{
					$year -= $arg3;
				}
				else
					sysfunc_error( $ic, $ic_ptr, "Invalid date type: ".$arg1 );
				
				if ($month == 2 && $day == 29 && (! is_leap_year( $year )))
					$day = 28;
			
				$result = date_from_parts( $day, $month, $year );
			}
/*			
			$dt = date_create( $arg3 );
	
			date_sub( $dt, date_interval_create_from_date_string( $arg1." ".$arg2 ));
			
			$result = $dt->format( "Y-m-d" );
*/ 
		}
			
		break;		
		case "ddiff":
		{
			if (! check_date_valid( $arg1 ))
				sysfunc_error( $ic, $ic_ptr, "Invalid date in ddiff(): ".$arg1 );

			if (! check_date_valid( $arg2 ))
				sysfunc_error( $ic, $ic_ptr, "Invalid date in ddiff(): ".$arg1 );
			
		    $result = date_diff( date_create( $arg1 ), date_create( $arg2 ) )->format( "%a" );
		}
			
		break;		
		case "ddatestr_is_valid":
		{
			$dt_str = convert_date_to_yyyymmdd( $arg1, $arg2, "" );
			
			if (check_date_valid( $dt_str ))
				$result = 1;
			else
				$result = 0;
		}

		break;		
		case "dtimestr_is_valid":
		{
			if (time_is_valid( $arg1 ))
				$result = 1;
			else
				$result = 0;
		}

		break;		
		case "ddatetimestr_is_valid":
		{
			if (datetime_is_valid( $arg1 ))
				$result = 1;
			else
				$result = 0;
		}
	
		break;		
		case "dleap_year":
		{
			if (is_leap_year( $arg1 ))		
				$result = 1;
			else
				$result = 0;
		}
			
		break;		
		case "dweekday":
		{
			if (! check_date_valid( $arg1 ))
				sysfunc_error( $ic, $ic_ptr, "Invalid date in dweekday(): ".$arg1 );
			
			$dt = date_create( $arg1 );
			
			$result = date( "w", $dt->format( "U" ) );		
		}
		
		break;		
		case "dday":
		{
			if (! check_date_valid( $arg1 ))
				sysfunc_error( $ic, $ic_ptr, "Invalid date in dday(): ".$arg1 );
			
			$result = (string) ((int) smid( $arg1, 8, 2 ));
		}
		
		break;		
		case "dmonth":
		{
			if (! check_date_valid( $arg1 ))
				sysfunc_error( $ic, $ic_ptr, "Invalid date in dmonth(): ".$arg1 );
			
			$result = (string) ((int) smid( $arg1, 5, 2 ));
		}

		break;		
		case "dyear":
		{
			if (! check_date_valid( $arg1 ))
				sysfunc_error( $ic, $ic_ptr, "Invalid date in dyear(): ".$arg1 );
			
			$result = sleft( $arg1, 4 );
		}

		break;		
		case "ddate_to_julian":
		{
			if (! check_date_valid( $arg1 ))
				sysfunc_error( $ic, $ic_ptr, "Invalid date in ddate_to_julian(): ".$arg1 );
			
			$result = convert_date_to_julian( $arg1 );
		}

		break;		
		case "djulian_to_date":
		{
			$result = convert_julian_to_date( $arg1 );
		}

		break;		
		case "ddate_part":
		{
			$result = sleft( $arg1, 10 );
		}

		break;		
		case "dtime_part":
		{
			$result = sright( $arg1, 8 );
		}
	
		break;		
		case "dnull":
		{
			$result = '0000-00-00';
		}

		break;		
		case "tnull":
		{
			$result = '99":99';
		}

		break;		
		case "dtnull":
		{
			$result = '0000-00-00 99":99":99';
		}

		break;		
		case "lnull":
		{
			$result = (int) 0;
		}

		break;		
		case "ddate_from_parts":
		{
			$day = $arg1;
			$month = $arg2;
			$year = $arg3;
			
			if ($day < 10)
				$day = '0'.$day;

			if ($month < 10)
				$month = '0'.$month;

			if ($year < 50)
				$year = '20'.$year;
			else
			if ($year < 100)
				$year = '19'.$year;
				
			
			$result = $year."-".$month."-".$day;
		}
	
	
//--------------------------------------------------------------------------
// Database
//--------------------------------------------------------------------------


		break;		
		case "db_login":
		{
			$host = "localhost";
			$user = "aitkencv_mlm1";
			$password = "IndieLogin12%$";
	
	        $cxn = new mysqli( $host, $user, $password, $arg1 );
	
			if ($cxn->connect_errno)
			{
				echo "<br>";
				echo "<br>";
				
				echo "Database login error: ".$cxn->connect_error."<br>";
	
				exit();
			}
			
			$cxn2['read'] = $cxn;
			$cxn2['write'] = $cxn;
			 
			$result = $cxn2;
		}
			
		break;		
		case "db_prep_string":
		{
			$result = prep_for_sql( $arg1 );
		}
			
		break;		
		case "db_run_query":
		{
			$result = run_query( $arg1, $arg2 );
		}
		
		break;		
		case "db_query_num_rows":
		{
			$result = query_num_rows( $arg1 );
		}
		
		break;		
		case "db_get_row":
		{
			$result = get_row( $arg1 );
		}

		break;		
		case "db_get_field_string":
		{
			if (! isset( $arg2[$arg1] ) || is_null( $arg2[$arg1] ))
				$result = "";
			else
				$result = $arg2[$arg1];
		}

		break;		
		case "db_get_field_bool":
		{
			if (! isset( $arg2[$arg1] ) || is_null( $arg2[$arg1] ))
				$result = "0";
			else
				$result = $arg2[$arg1];
		}

		break;		
		case "db_get_field_int":
		case "db_get_field_double":
		{
			if (! isset( $arg2[$arg1] ) || is_null( $arg2[$arg1] ))
				$result = "0";
			else
				$result = $arg2[$arg1];
		}

		break;		
		case "db_get_field_decimal":
		{
			if (! isset( $arg2[$arg1] ) || is_null( $arg2[$arg1] ))
				$result = "0";
			else
				$result = (double) ((double) $arg2[$arg1] * (double) DECIMAL_SCALE);
		}

		break;		
		case "db_get_field_date":
		{
			if (! isset( $arg2[$arg1] ) || is_null( $arg2[$arg1] ))
				$result = "";
			else
				$result = $arg2[$arg1];
			
			if ($result == "")
				$result = '0000-00-00';
		}

		break;		
		case "db_get_field_time":
		{
			if (! isset( $arg2[$arg1] ) || is_null( $arg2[$arg1] ))
				$result = "";
			else
				$result = $arg2[$arg1];
			
			if ($result == "")
				$result = '99":99":99';
		}

		break;		
		case "db_get_field_datetime":
		{
			if (! isset( $arg2[$arg1] ) || is_null( $arg2[$arg1] ))
				$result = "";
			else
				$result = $arg2[$arg1];
			
			if ($result == "")
				$result = '0000-00-00 99":99":99';
		}
		

//--------------------------------------------------------------------------
// Binary
//--------------------------------------------------------------------------

		break;		
		case "bget_byte":
		{
			if (2 * $arg2 > strlen( $arg1 )-2)
				$result = (int) 0;
			else
			{
				$text = substr( $arg1, 2 * $arg2, 2 );
			
				$result = hexdec( $text );
			}
		}

		break;		
		case "bset_byte":
		{
			$text3 = sright( dechex( $arg3 ), 2 );
				
			if (strlen( $text3 ) == 1)
				$text3 = '0'.$text3;
			
			$pos = 2 * (int) $arg2;
			
			if ($pos == 0)
			{
				$result = $text3.sright( $arg1, strlen( $arg1 ) - 2 );				
			}
			else
			{			
				$text1 = sleft( $arg1, $pos );
	
				$text2 = sright( $arg1, strlen( $arg1 ) - $pos - 2 );
	
				if (strlen( $text1 ) < $pos)
				{
					while (strlen( $text1 ) < $pos)
						$text1 .= "00";
					
					$result = $text1.$text3;				
				}
				else
				{
					$result = $text1.$text3.$text2;
					
				}
			}
		}

		break;		
		case "bsize":
		{
			$result = strlen( $arg1 ) / 2;
		}

		break;		
		case "btohex":
		{
			$result = $arg1;
		}

		break;		
		case "bfromhex":
		{
			$result = $arg1;
		}

		break;		

//--------------------------------------------------------------------------
// Internet
//--------------------------------------------------------------------------

/*
	case "isend_email":
	{
		$result =
		
*/
		break;		
		case "iconvert_to_html":
		{
			$result = convert_to_html( $arg1 );
		}
	
		break;		
		case "iurlencode":
		{
			$result = urlencode( $arg1 );
		}
		
		break;		
		case "iurldecode":
		{
			$result = urldecode( $arg1 );
		}

		break;		
		case "iread":
		{
			$result = file_get_contents( $arg1 );
		}

		break;		
		case "ijump_to_page":
		{
			$result = jump_to_page( $arg1 );
		}
						
		break;		
		case "iexit_if_search_bot":
		{
			exit_if_search_bot();
		}
						
		break;		
		case "iread_web_page":
		{
			$result = file_get_contents( $arg1 );
		}
						
						
						
//--------------------------------------------------------------------------
// Data type conversion
//--------------------------------------------------------------------------

		break;
		case "cint_to_decimal": {$result = (double) ($arg1 * DECIMAL_SCALE); } break;
		case "cint_to_double": {$result = $arg1; } break;
		case "cdecimal_to_int": {$result = (int) round( ((double) $arg1 / (double) DECIMAL_SCALE), 0 );} break;
		case "cdecimal_to_double": {$result = (double) round( ((double) $arg1 / (double) DECIMAL_SCALE), 2 );} break;
		case "cdouble_to_int": {$result = $arg1; } break;
		case "double_to_decimal": {$result = (double) (round( (double) $arg1 * (double) DECIMAL_SCALE, 0 )); } break;
			
		case "cdate_to_datetime": {$result = $arg1." 00:00:00"; } break;

		case "cint_to_string": { $result = $arg1; } break;
		case "cdecimal_to_string": {$result = (string) round( ((double) $arg1 / (double) DECIMAL_SCALE), 2 );  } break;
		case "cdouble_to_string": {$result = $arg1; } break;
		case "cbool_to_string": { if ($arg1 != 0) $result = 'true'; else $result = 'false'; } break;
		case "cdate_to_string": 
		{
			if (! check_date_valid( $arg1 ))
			{
				sysfunc_error( $ic, $ic_ptr, "Invalid date in cdate_to_string(): ".$arg1 );
				$result = "";
			}
			else
			{
				$dt = date_create( $arg1 );
			
				$result = $dt->format( $arg2 );
			}
		} break;
			
		case "ctime_to_string": {$result = $arg1; } break;
			
		case "cdatetime_to_string":
		{
			if (! check_datetime_valid( $arg1 ))
			{
				sysfunc_error( $ic, $ic_ptr, "Invalid datetime in dtformat(): ".$arg1 );

				$result = "";
			}
			else
			{
				$dt = date_create( $arg1 );
			
				$result = $dt->format( $arg2 );
			}
		} break;

		case "cstring_to_int": { if ($arg1 == "") $result = 0; else $result = (int) $arg1; } break;
		case "cstring_to_decimal": { if ($arg1 == "") $result = (double) 0; else $result = (double) (round( (double) $arg1 * (double) DECIMAL_SCALE, 0 )); } break;
		case "cstring_to_double": { if ($arg1 == "") $result = 0.0; else $result = (double) $arg1; } break;
		case "cstring_to_bool": { if (strcasecmp( $arg1, 'true') == 0) $result = 1; else $result = 0; } break;
		case "cstring_to_time": { $result = $arg1; } break;
		case "cstring_to_date": 
		{
			if ($arg2 != "dd/mm/yyyy" &&
				$arg2 != "mm/dd/yyyy" &&
				$arg2 != "yyyy/mm/dd" &&
				$arg2 != "yyyy-mm-dd")
			{
				sysfunc_error( $ic, $ic_ptr, "Date conversion error: type must be one of 'dd/mm/yyyy', 'mm/dd/yyyy', 'yyyy/mm/dd', 'yyyy-mm-dd'" );
				
				$result = "";
			}
			else
			if ($arg2 == "yyyy-mm-dd")
			{
				if (! check_date_valid( $arg1 ))
					$result = "0000-00-00";
				else
					$result = $arg1;
			}
			else
				$result = convert_date_to_yyyymmdd( $arg1, $arg2, "" ); 
		} 
		break;
		case "cstring_to_datetime": {$result = $arg1; }

		break;		
		case "bit_and":
		{
			$result = (int) ((int) $arg1 & (int) $arg2);
		}
		break;		
		case "bit_or":
		{
			$result = (int) ((int) $arg1 | (int) $arg2);
		}
		break;		
		case "bit_xor":
		{
			$result = (int) ((int) $arg1 ^ (int) $arg2);
		}
		break;		
		case "bit_not":
		{
			$result = (int) (~ (int) $arg1);
		}
		break;		
		case "bit_shift_left":
		{
			$result = (int) ((int) $arg1 << 1);
		}
		break;		
		case "bit_shift_right":
		{
			$result = (int) ((int) $arg1 >> 1);
		}
		break;		
		case "opt_set":
		{
			if (((int) $arg1 & (int) $arg2) != 0)
				$stat = 1;
			else
				$stat = 0;	
			
			return ($stat);
		}
		
		

//ipost								// Make a POST request to a web page
//send SMS							// sends an SMS message

//--------------------------------------------------------------------------
// Misc
//--------------------------------------------------------------------------

		break;		
		case "msort":
		{
			if (isset( $data ))
				unset( $data );


			$array_len_in = $stack_value[$sp-5];
			$array_len_out = $stack_value[$sp-3];

			if ($arg3 > $array_len_in)
				sysfunc_error( $ic, $ic_ptr, "The input data is ".$array_len_in." items but the requested sort is ".$arg3." items." );			
			
			if ($arg3 > $array_len_out)
				sysfunc_error( $ic, $ic_ptr, "The receiving array only holds ".$array_len_out." items but the requested sort is ".$arg3." items." );			
			
			for ($i=0; $i < $arg3; $i++)
				$data[$i] = $stack_value[$stack_value[$sp-6] + $i];
				
			if ((! $stack_value_is_pointer[$sp-4]) ||
				(! $stack_value_is_pointer[$sp-6]))
					sysfunc_error( $ic, $ic_ptr, "The first two arguments to msort() must be passed by reference, use &" );			

			if ($arg4 == 1)
				asort( $data );
			else
				arsort( $data );
			
			$i = 0;
			
	        foreach ($data as $key => $value)
				$stack_value[$stack_value[$sp-4] + $i++ ] = $key; 
			
			
			
//			$result = $keys;
				
//			$sp2 = $sp-3;
//			$indirection_levels = 0;
			
//			while ($indirection_levels < MAX_INDIRECTION_LEVELS && $stack_value_is_pointer[$sp2])
//			{
//				$sp2 = $stack_value[$sp2];
//				$indirection_levels++;
//			}
			
//			$stack_value[$sp2] = $keys;
		}


		break;		
		case "ssort":
		{
			if (isset( $data ))
				unset( $data );

			$array_len_in = $stack_value[$sp-5];
			$array_len_out = $stack_value[$sp-3];
				
			if ($arg3 > $array_len_in)
				sysfunc_error( $ic, $ic_ptr, "The input data is ".$array_len_in." items but the requested sort is ".$arg3." items." );			
			
			if ($arg3 > $array_len_out)
				sysfunc_error( $ic, $ic_ptr, "The receiving array only holds ".$array_len_out." items but the requested sort is ".$arg3." items." );			

											
			for ($i=0; $i < $arg3; $i++)
				$data[$i] = $stack_value[$stack_value[$sp-6] + $i];
			
			if ((! $stack_value_is_pointer[$sp-4]) ||
				(! $stack_value_is_pointer[$sp-6]))
					sysfunc_error( $ic, $ic_ptr, "The first two arguments to ssort() must be passed by reference, use &" );			

			
			if ($arg4 == 1)
				asort( $data );
			else
				arsort( $data );
			
			$i = 0;

	        foreach ($data as $key => $value)
				$stack_value[$stack_value[$sp-4] + $i++] = $key; 
	
		
//			{
//				$keys[$i] = $key;
//				$i++;
//			} 
			
//			$result = $keys;
			
//			$sp2 = $sp-3;
//			$indirection_levels = 0;
			
//			while ($indirection_levels < MAX_INDIRECTION_LEVELS && $stack_value_is_pointer[$sp2])
//			{
//				$sp2 = $stack_value[$sp2];
//				$indirection_levels++;
//			}
			
//			$stack_value[$sp2] = $keys;
		}

//--------------------------------------------------------------------------
// System
//--------------------------------------------------------------------------

		break;		
		case "syget_get_parameter":
		{
			$result = val( $_GET, $arg1 );
		}
	
		break;		
		case "syget_post_parameter":
		{
			$result = val( $_POST, $arg1 );
		}

		break;		
		case "syget_session_variable":
		{
			$result = acv_session_get( $arg1, $arg2 );
		}

		break;		
		case "syset_session_variable":
		{
			acv_session_set( $arg1, $arg2, $arg3 );
		}
		
		break;		
		case "syget_ip_address":
		{
			$result = get_ip_address();
		}

		break;		
		case "sylow_res_screen":
		{
			 if ((strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "Android" ) !== false) ||
                 (strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "Opera Mini" ) !== false) ||
                 (strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "Windows Phone" ) !== false) ||
                 (strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "Phone" ) !== false) ||
                 (strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "Mobile" ) !== false) ||
                 (strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "AdsBot-Google-Mobile" ) !== false) ||
                 (strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "iPhone" ) !== false))
    			$low_res = 1;
    		else
    			$low_res = 0;
				
			$result = $low_res;			
		}

		break;		
		case "syexit":
		{
			exit();
		}

		break;		
		case "init_acv_sessions":
		{
			init_acv_sessions( $arg1 );
		}

		break;		
		case "acv_session_set":
		{
			acv_session_set( $arg1, $arg2, $arg3 );
		}

		break;		
		case "acv_session_get":
		{
			$result = acv_session_get( $arg1, $arg2 );
		}

		break;		
		case "acv_session_id":
		{
			$session_id = acv_session_id();
		
			$result = $session_id;
		}

		break;		
		case "process_external_entry_point":
		{
			acv_session_set( "session_active", "yes", $arg1 );
		}

		break;		
		case "exit_if_session_expired":
		{
			exit_if_session_expired( $arg1 );
		}
		
		break;
				
		case "syphp_ini_set":
		{
			ini_set( $arg1, $arg2 );
		}
		break;
				
		default:
		{
			sysfunc_error( $ic, $ic_ptr, "Builtin function ".$function_name." not found" );			
		}		
		}
		
		return ($result);
	}

	
	function sysfunc_error( $ic, $ic_ptr, $text )
	{
		echo "Runtime error system functions: Line ".$ic[$ic_ptr]['line_number'].": ".$ic[$ic_ptr]['input_filename'].": ".$text."<br>";
	}
	