<?php
			// (c) Copyright Mark McIlroy 2021

	include "library.php";


	$cxn = start_code( true );

    page_header( "Calc dashboard", $cxn );
	
	echo "<br>";

	$file_to_run = initialise_parameter( "file_to_run", "https://calc.aitkencv.com/test_program.calc" );
	
	$script = initialise_parameter( "script", "include \"https://calc.aitkencv.com/stdlib.calc\";\n\nfunction int main( int argc, array string [variable] argv )\n{\n\n\n\n\n\n\n\n\n\n\n\n}" );

	$item_to_run = initialise_parameter( "item_to_run", "filename" );
	
	echo "<table width='100%'><tr><td width='100%' style='padding-left: 15px'>";
	
	echo black( "Enter a Calc filename to run below or enter code onto the scratchpad." );
	
	echo "<br>";
	
	echo "<form id='form' name='form' action='".url_encode( "/scripts/run_program_from_input_screen.php" )."' method='POST'><table width='95%' style='border: 1px solid #dddddd; border-radius: 10px; background: #eeeeee;'>\n";
	
//	form_start( $cxn, "/scripts/run_script_go.php" );

	write_yellow_input_boxes();

    $flags = OPT_FORM_FIELD_MOBILE_NEXT_LINE;
	
	if (! low_res_screen( $cxn ))
		form_text( $cxn, "Input filename", "file_to_run", 50, $file_to_run, OPT_FORM_FIELD_AUTOFOCUS | OPT_FORM_FIELD_MOBILE_NEXT_LINE );
	else
		form_text( $cxn, "Input filename", "file_to_run", 35, $file_to_run, OPT_FORM_FIELD_AUTOFOCUS | OPT_FORM_FIELD_MOBILE_NEXT_LINE );
	
	if (! low_res_screen( $cxn ))
		form_textarea( $cxn, "Scratchpad", "script", 20, 80, $script, OPT_FORM_FIELD_MOBILE_NEXT_LINE | OPT_FORM_FIELD_AUTOFOCUS );
	else
		form_textarea( $cxn, "Scratchpad", "script", 20, 80, $script, OPT_FORM_FIELD_AUTOFOCUS );

    echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";
		
	form_radio( $cxn, "Item to run/compile", "item_to_run", "filename", "Run/compile file from filename above", $item_to_run, 0 );

	form_radio( $cxn, "", "item_to_run", "scratchpad", "Scratchpad code", $item_to_run, 0 );

	form_radio( $cxn, "Run mode", "run_mode", "compile", "Compile", "compile", 0 );

	form_radio( $cxn, "", "run_mode", "run", "Run (PHP)", "compile", 0 );


	echo "<tr><td>&nbsp;</td></tr>";

    echo "<tr><td colspan='3'>".black( "To run and test small sections of code, enter the code into the scrathpad above." )."</td></tr>";

    echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";
    
    echo "<tr><td colspan='3'>".black( "To run a complete program open the internet address https://calc.aitkencv.com/run_program_external.php?file_to_run=FILENAME-TO-RUN" )."</td></tr>";

    echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";

    echo "<tr><td colspan='3'>".black( "e.g. https://calc.aitkencv.com/scripts/run_program_external.php?file_to_run=http://aitkencv.com/scripts/reports_p_and_l.calc" )."</td></tr>";

	echo "<tr><td>&nbsp;</td></tr>";


	form_checkbox( $cxn, "Show scan trace", "show_scan_trace", "" );
	
	form_checkbox( $cxn, "Show parse trace", "show_parse_trace", "" );
	
	form_checkbox( $cxn, "Show icode", "show_icode", "" );
	
	form_checkbox( $cxn, "Show execution trace", "show_execution_trace", "" );

	form_checkbox( $cxn, "Show warnings", "show_warnings", "on" );
	
	form_checkbox( $cxn, "Run code", "run_code", "on" );

	form_checkbox( $cxn, "Initialise variables", "initialise_variables", "" );

	form_checkbox( $cxn, "Array bounds checks", "array_bounds_checks", "on" );

	form_checkbox( $cxn, "Include comments in output", "include_output_comments", "on" );

	form_checkbox( $cxn, "Runtime checks", "runtime_checks", "on" );

	echo "<br>";

    if (! low_res_screen( $cxn ))
		echo "<tr><td align='center'><br><br>";
	else
	    echo "<tr><td align='center'><br>";
	    
	
	show_green_button_submit( $cxn, lookup( "Run", $cxn ), 75 );

	echo "<tr><td>&nbsp;</td></tr>";

	echo "</td></tr>";

 
	form_end();

	echo "</td></tr></table>";

    echo "<br>";
    echo "<br>";
    echo "<br>";

	echo "&nbsp;&nbsp;";

	echo black( "Sample code<br>" );

    echo "<br>";

	echo "&nbsp;&nbsp;";

	echo black( "https://calc.aitkencv.com/sample_code.calc<br>" );

    echo "<br>";
    echo "<br>";
    echo "<br>";

	echo "&nbsp;&nbsp;";

	echo black( "Example Calc application: (Pension calculator)<br>" );

    echo "<br>";
    echo "<br>";

	echo "&nbsp;&nbsp;";
	
    echo "<a href='https://calc.aitkencv.com/run_program_external.php?file_to_run=https://calcpension.aitkencv.com/scripts/index.calc' class='glink'>https://calc.aitkencv.com/run_program_external.php?file_to_run=https://calcpension.aitkencv.com/scripts/index.calc</a>";

    echo "<br>";
    echo "<br>";

	echo "&nbsp;&nbsp;";

	echo black( "Source code<br>" );

    echo "<br>";

	echo "&nbsp;&nbsp;";

	echo black( "https://calc.aitkencv.com/stdlib.calc<br>" );

	echo "&nbsp;&nbsp;";

	echo black( "https://calc.aitkencv.com/forms_library.calc<br>" );

	echo "&nbsp;&nbsp;";

	echo black( "https://calcpension.aitkencv.com/scripts/index.calc<br>" );

	echo "&nbsp;&nbsp;";
	
	echo black( "https://calcpension.aitkencv.com/scripts/library.calc<br>" );

	echo "&nbsp;&nbsp;";
	
	echo black( "https://calcpension.aitkencv.com/scripts/calc_pension.calc<br>" );
	
    echo "<br>";
    echo "<br>";
    echo "<br>";

	echo "&nbsp;&nbsp;";

    echo black( "File to compile the output program" )."<a style='padding-left: 10px' href='/mk.sh' class='glink'>download</a>";

    echo "<br>";
    echo "<br>";
    echo "<br>";

	echo "&nbsp;&nbsp;";

    echo black( "C header file" )."<a style='padding-left: 10px' href='/calc.h' class='glink'>download</a>";

    echo "<br>";
    echo "<br>";
    echo "<br>";

	echo "&nbsp;&nbsp;";

    echo black( "Standard library" )."<a style='padding-left: 10px' href='/stdlib.calc' class='glink'>Header file and description</a>"."<a style='padding-left: 10px' href='/calc_stdlib.c' class='glink'>C source file</a>";
        
    echo "<br>";
    echo "<br>";
    echo "<br>";

	echo "&nbsp;&nbsp;";

    echo black( "Language documentation" )."<a style='padding-left: 10px' href='/language_documentation.php' class='glink'>view</a>";

    echo "<br>";
    echo "<br>";
    echo "<br>";

	echo "&nbsp;&nbsp;";

    echo black( "Catalogue of libraries" )."<a style='padding-left: 10px' href='/library_catalogue.php' class='glink'>view</a>";

    echo "<br>";
    echo "<br>";
    echo "<br>";
        	
	echo "&nbsp;&nbsp;";
		
    echo "<a href='https://acvcalculator.aitkencv.com' class='glink'>Back to ACV Calculator</a>";

    echo "<br>";
    echo "<br>";
    echo "<br>";

	echo "</td></tr></table>";

?>