<?php
			// (c) Copyright Mark McIlroy 2022

	include "/home/aitkencv/public_html/calc/scripts/library.php";

	define( "MAX_STACK_SEGMENT", 75000000 );

	define( "GLOBALS_AND_HEAP_SIZE", 25000000);
	
	define( "MAX_INDIRECTION_LEVELS", 10000 );

	define( "MAX_RUN_ITERATIONS", 10000000 );			// to pause incorrect scripts

	define( "SIZEOF_VAR", 16 );

	//			reference call is 	addr, lst index size
	
/*
  
   Notes
  
 		The binary data type is stored as a string of hex digits. 
   */
   	
	/*
	 * Current programs converted to calc 
	 *
	 * 	Accounts P & L report
	 * 
	 * 	Calc option values
	 *
	 * 	Input screen test program 
	 */

	include "/home/aitkencv/public_html/calc/scripts/builtin_functions.php";

	include "/home/aitkencv/public_html/calc/scripts/runtime.php";

	include "/home/aitkencv/public_html/calc/scripts/scanner.php";

	include "/home/aitkencv/public_html/calc/scripts/calc_optimise.php";

	include "/home/aitkencv/public_html/calc/scripts/gen_c.php";
	
	ini_set( "memory_limit", "128M" );

	
//---------------------------------------
// NEXT AVAILABLE ERROR NUMBER:   236
//
// NEXT AVAILABLE WARNING NUMBER:   10
//
// Includes 'runtime.php'
//---------------------------------------
// https://calc.aitkencv.com/test_program.calc

// include "https://calcs.aitkencv.com/stdlib.calc";

/*
 * f1()[]
 * 
 * if (x in {expr1, expr2, ...})
 * 
 * passing structures to external C programs
 * 
 * l1 = y.link1		// copy of link address
 *  x = y.link1		// structure copy of link1 destination
 * 
 * free of dynamic objects
 * 
 * links to ints
 * 
 * a = &b
 * 
 * move parse_right_side to parse_stat
 * 
 * session variables
 */
  
	define( "exit_on_first_error", false );
//	define( "exit_on_first_error", true );
	

	$cxn = start_code();

 
 /* st frame
 
    local variables
   	return ptr
   	function arguments
  	global vars 
*/


	function calc_run_program( $program, $input_filename, $show_scan_trace, $show_parse_trace, $show_icode, $show_execution_trace, $run_code, $initialise_variables, $array_bounds_checks, $runtime_checks, $run_mode, $show_warnings, $include_output_comments, $command_line_mode ) 
	{
		$i = 0;

		$parse_param = new parse_parameters;

		$parse_param->array_bounds_checks = $array_bounds_checks;
		
		$parse_param->show_parse_trace = $show_parse_trace;

		$parse_param->show_scan_trace = $show_scan_trace; 
						
		$parse_param->show_warnings = $show_warnings;
	
		$parse_param->command_line_mode = $command_line_mode;
						
		$parse_param->include_output_comments = $include_output_comments;	
						
		$parse_param->main_input_filename = $input_filename;

		$parse_param->output_filename = "";
						
		$parse_param->output_file_type = "main";
								
		$show_execution_trace = $show_execution_trace;
		
		$parse_param->last_error_line = 0;
		
		$ic_pos = 0;
	
		$parse_param->label_num = 1;

		$parse_param->num_user_defined_types = 0;
			
		$parse_param->vars['number_of_global_variables'] = 0;
		$parse_param->vars['number_of_user_functions'] = 0;
	
	
		if ($run_mode == "compile")
			$parse_param->c_output = true;
		else
			$parse_param->c_output = false;
	
		$parse_param->error_occured = false;
	
		$parse_param->for_control_variables = ":";
	
		scan_file( $parse_param, $input_filename, $program );
		
		parse_file( $parse_param, $ic, $ic_pos );

		if (! $parse_param->error_occured)
		{	
			post_parse_processing( $parse_param, $ic, $ic_pos );

			$ic = ic_optimise( $parse_param, $ic, $ic_pos, $vars );
		}
				
		if ($show_icode)
		{
			$line_number = 0;
			
			echo "<table width='100%'>";
			
			$op_descriptions = set_op_descriptions( $op_number_of_operands );

			
			for ($i=0; $i < $ic_pos; $i++)
			{
				if ($line_number != $ic[$i]['line_number'])
				{
					echo "<tr><td colspan=10>; Line: ".$ic[$i]['line_number'].": ".convert_to_html( $parse_param->input_text[$ic[$i]['input_filenumber']][$ic[$i]['line_number']] )."</td></tr>";
					$line_number = $ic[$i]['line_number'];
				}
			
				if ($ic[$i]['text'] != "")
					echo "<tr><td>".$i."</td><td>".$op_descriptions[$ic[$i]['op']]."</td><td>".convert_to_html( $ic[$i]['value'] )."</td><td>".convert_to_html( $ic[$i]['text'] )."</td><td>".gettype( $ic[$i]['value'] )."</td></tr>";
				else		
					echo "<tr><td>".$i."</td><td>".$op_descriptions[$ic[$i]['op']]."</td><td>".convert_to_html( $ic[$i]['value'] )."</td><td></td><td>".gettype( $ic[$i]['value'] )."</td></tr>";
			}
			
			echo "</table>";
		}

		if (! $parse_param->error_occured)
		{
			if ($initialise_variables)
				gen_init_all( $parse_param );

			if ($run_mode == "compile")
			{
				gen_c_code( $parse_param, $ic, $ic_pos, $parse_param->vars, $show_execution_trace, $initialise_variables, $runtime_checks, $include_output_comments );
				
				if ($command_line_mode)
					echo "Finished compile of ".$input_filename."\n";
				else
				{
					echo "<br>";
					echo "<br>";
					echo "<br>";
					
	
					echo black( "Finished compile.");
					
					echo "<br>";
					echo "<br>";
					echo "<br>";
					echo "<br>";
													
					echo "<a class='glink' href='https://calc.aitkencv.com/output_program.c'>Download output program</a>";
				}
			}
			else			
			if ($run_code)
				run_ic_code( $parse_param, $ic, $ic_pos, $parse_param->vars, $show_execution_trace, $initialise_variables, $runtime_checks );
		}
		
		if ($parse_param->error_occured)
			exit( 1 );
		else
			exit( 0 );
	}


	function show_variable_name( &$ic, &$ic_ptr, $current_function_number, $offset )
	{
		for ($k=0; $k < $parse_param->vars['number_of_local_variables'][$current_function_number]; $k++)
		{
			if ($parse_param->vars['local_variables'][$current_function_number][$k]['offset'] == $offset)
				$name = $parse_param->vars['local_variables'][$current_function_number][$k]['name'];
		}
		
		return ($name);
	}
	

	function parse_file( &$parse_param, &$ic, &$ic_pos )
	{
		$current_line_number = 1;
		$current_function_number = 0;
		
		$parse_param->in_function = false;
		
		if ($parse_param->show_parse_trace)
			echo "called parse_file<br>"; 				
	
        while ($parse_param->curr_tok != TOK_EOF)
		{
			$builtin_function = false;

			if ($parse_param->curr_tok == TOK_BUILTIN)
			{
				$builtin_function = true;

				next_token( $parse_param );
				
				$parse_param->in_function = true;

				parse_function_definition( $parse_param, $ic, $ic_pos, $current_function_number, $builtin_function );

				$parse_param->in_function = false;
			}
			else
			if ($parse_param->curr_tok == TOK_FUNCTION)
			{
				$parse_param->in_function = true;

				parse_function_definition( $parse_param, $ic, $ic_pos, $current_function_number, $builtin_function );
				
				$parse_param->in_function = false;
			}				
			else
			if ($parse_param->curr_tok == TOK_TYPE)
			{
				parse_type_definition( $parse_param, $ic, $ic_pos, false, $current_function_number );

				next_token( $parse_param );
			}
			else
			if ($parse_param->curr_tok == TOK_CONST)
			{
				parse_const_declaration( $parse_param, $ic, $ic_pos, $num_dimensions, false );
			}
			else
			if ($parse_param->curr_tok == TOK_MODULE_NAME)
			{
				next_token( $parse_param );
				
				check_for_expected_token( $parse_param, TOK_STRING_CONSTANT, 221, "Expected a text string after 'module_name'." );
				
				gen_code( $parse_param, $ic, $ic_pos, OP_MODULE_NAME, $parse_param->curr_token_text );
				
				next_token( $parse_param );
				
				check_for_expected_token( $parse_param, TOK_SEMICOLON, 222, "Expected a ';'." );
					
				next_token( $parse_param );
			}
			else
			if ($parse_param->curr_tok == TOK_OUTPUT_FILENAME)
			{
				next_token( $parse_param );
				
				check_for_expected_token( $parse_param, TOK_STRING_CONSTANT, 230, "Expected a text string after 'output_filename'." );
				
				$parse_param->output_filename = $parse_param->curr_token_text;
				
				next_token( $parse_param );
				
				check_for_expected_token( $parse_param, TOK_SEMICOLON, 231, "Expected a ';'." );
					
				next_token( $parse_param );
			}
			else	
			if ($parse_param->curr_tok == TOK_MODULE_TYPE)
			{
				next_token( $parse_param );
				
				check_for_expected_token( $parse_param, TOK_STRING_CONSTANT, 226, "Expected a text string after 'module_type'." );
				
				if ($parse_param->curr_token_text != "main" && $parse_param->curr_token_text != "secondary")
					semantic_error( 228, $parse_param, "Expected 'main' or 'secondary'." );
				
				$parse_param->output_file_type = $parse_param->curr_token_text;
				
				next_token( $parse_param );
	
				check_for_expected_token( $parse_param, TOK_SEMICOLON, 227, "Expected a ';'." );
					
				next_token( $parse_param );
			}
			else	
			if ($parse_param->curr_tok == TOK_LINK_MODULE)
			{
				next_token( $parse_param );
				
				check_for_expected_token( $parse_param, TOK_STRING_CONSTANT, 223, "Expected a text string after 'link_module'." );
				
				gen_code( $parse_param, $ic, $ic_pos, OP_LINK_MODULE, $parse_param->curr_token_text );
				
				next_token( $parse_param );
	
				check_for_expected_token( $parse_param, TOK_SEMICOLON, 224, "Expected a ';'." );
					
				next_token( $parse_param );
			}
			else
			{
				if ($parse_param->curr_tok != TOK_VAR)
					semantic_error( 225, $parse_param, "Code cannot be outside functions in an input file: ".$parse_param->curr_token_text );

				parse_stat( $parse_param, $ic, $ic_pos, $current_function_number, false );
			}
		}
	}


	function parse_type_definition( &$parse_param, &$ic, &$ic_pos, $current_function_number )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_type_definition<br>"; 				
	
		next_token( $parse_param );
		
		check_for_expected_token( $parse_param, TOK_NAME, 125, "Expected a name after 'type': ".$parse_param->curr_token_text );
	
		if (is_reserved_word( $parse_param->curr_token_text ))
			semantic_error( 182, $parse_param, "Cannot use a reserved word as a type name" );
	
		for ($i=0; $i < $parse_param->num_user_defined_types; $i++)
		{
			if ($parse_param->user_defined_types[$i]['type_name'] == $parse_param->curr_token_text)
				semantic_error( 181, $parse_param, "Type ".$parse_param->curr_token_text." is already defined" );
		}
		
		$parse_param->user_defined_types[$parse_param->num_user_defined_types]['type_name'] = $parse_param->curr_token_text;
		
		next_token( $parse_param );
	
		if (is_simple_data_type( $parse_param, $parse_param->curr_token_text ))
		{
			$parse_param->user_defined_types[$parse_param->num_user_defined_types]['item_type'][0] = $parse_param->curr_token_text;
					
			$parse_param->user_defined_types[$parse_param->num_user_defined_types]['num_items'] = 0;
		
			if ($parse_param->c_output)
				$parse_param->user_defined_types[$parse_param->num_user_defined_types]['type_size'] = SIZEOF_VAR;
			else
				$parse_param->user_defined_types[$parse_param->num_user_defined_types]['type_size'] = 1;
			
			$parse_param->num_user_defined_types++;
			
			next_token( $parse_param );
			
			check_for_expected_token( $parse_param, TOK_SEMICOLON, 212, "Expected ';' after a type declaration" );
		}
		else
		{
			check_for_expected_token( $parse_param, TOK_STRUCT, 126, "Expected 'struct' after a type name: ".$parse_param->curr_token_text );
			
			next_token( $parse_param );

			check_for_expected_token( $parse_param, TOK_LBRACE, 127, "Expected '{' after 'struct': ".$parse_param->curr_token_text );
		
			next_token( $parse_param );
			
				
			$num_items = 0;
			
			$offset = 0;
			
			$total_size = 0;
			
			while ($parse_param->curr_tok != TOK_EOF && $parse_param->curr_tok != TOK_RBRACE)
			{
				$item_type = parse_data_type( $parse_param, $ic, $ic_pos, $number_of_dimensions, false, false, $size, false, $is_variable_size );
		
				$size = get_type_total_size( $parse_param, $item_type );
				
				while ($parse_param->curr_tok != TOK_EOF && $parse_param->curr_tok != TOK_SEMICOLON)
				{
					$parse_param->user_defined_types[$parse_param->num_user_defined_types]['item_type'][$num_items] = $item_type;
								
					$parse_param->user_defined_types[$parse_param->num_user_defined_types]['item_name'][$num_items] = $parse_param->curr_token_text;
		
					$parse_param->user_defined_types[$parse_param->num_user_defined_types]['item_size'][$num_items] = $size;
		
					$parse_param->user_defined_types[$parse_param->num_user_defined_types]['offset'][$num_items] = $offset;
				
					$offset += $size;
					
					$total_size += $size;
					
					$num_items++;
				
					next_token( $parse_param );
		
					if ($parse_param->curr_tok != TOK_COMMA && $parse_param->curr_tok != TOK_SEMICOLON)
						syntax_error( 128, $parse_param, "Expected ',' or ';' after a struct item declaration: ".$parse_param->curr_token_text );
		
					if ($parse_param->curr_tok == TOK_COMMA)
						next_token( $parse_param );
				}
				
				if ($parse_param->curr_tok == TOK_SEMICOLON)
					next_token( $parse_param );
			}
		
			$parse_param->user_defined_types[$parse_param->num_user_defined_types]['num_items'] = $num_items;
			
			$parse_param->user_defined_types[$parse_param->num_user_defined_types]['type_size'] = $total_size;
				
			$parse_param->num_user_defined_types++;
		}
	}
	
	
	
	function parse_function_definition( &$parse_param, &$ic, &$ic_pos, &$current_function_number, &$builtin_function )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_function_definition<br>"; 				
		
		$parse_param->in_function = true;
	
		$in_void_function = false;
		
		next_token( $parse_param );
		
		$type = parse_data_type( $parse_param, $ic, $ic_pos, $number_of_dimensions, true, true, $size, false, $is_variable_size );
		
		$return_variable_type = $type;
		
		if ($type == "void")
			$in_void_function = true;
		
		$function_name = $parse_param->curr_token_text;
		
		$current_function_number = check_or_add_new_function( $parse_param, $function_name, $type, $already_defined, $number_of_dimensions );
		
		if (is_global_variable( $parse_param, $current_function_number, $function_name ))
			semantic_error( 218, $parse_param, "'".$function_name."' cannot be defined as a function name as there is already a global variable with that name." );
		
		for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
		{
			if ($parse_param->vars['function_name'][$j] == $function_name)
			{
				$parse_param->vars['builtin_function'][$j] = $builtin_function;
			}
		}						
	
		if (is_reserved_word( $function_name ) )
			syntax_error( 10, $parse_param, "'".$function_name."' cannot be defined as a function name it is a reserved word." );
		
		next_token( $parse_param );
		
		check_for_expected_token( $parse_param, TOK_LPARENTHESIS, 11, "Expected '(' after a function name." );
	
		next_token( $parse_param );
	
	    $number_of_arguments = 0;
		
		while ($parse_param->curr_tok != TOK_RPARENTHESIS && $parse_param->curr_tok != TOK_EOF)
		{
			$type = parse_data_type( $parse_param, $ic, $ic_pos, $number_of_dimensions, false, true, $size, true, $is_variable_size );
			
			$argument_names[$number_of_arguments++] = $parse_param->curr_token_text;
	 
			if ($already_defined)
			{
				for ($j=0; $j < $parse_param->vars['number_of_function_arguments'][$current_function_number]; $j++)
				{
					if ($parse_param->vars['function_arguments'][$current_function_number][$j]['name'] == $parse_param->curr_token_text)
					{
						if ($parse_param->vars['function_arguments'][$current_function_number][$j]['type'] != $type)
							semantic_error( 165, $parse_param, "Type mismatch in function definition/declaration: the type of argument '".$parse_param->vars['function_arguments'][$current_function_number][$j]['name']."' in the function declaration does not match the type in the function definition." );
					}
				}
			}			 
	
			if (! $already_defined)
			{
				$size = get_type_total_size( $parse_param, $type );
				
				for ($j=0; $j < $parse_param->vars['number_of_function_arguments'][$current_function_number]; $j++)
				{
					if ($parse_param->vars['function_arguments'][$current_function_number][ $j ]['name'] == $parse_param->curr_token_text)
						syntax_error( 150, $parse_param, "Cannot declare a function argument with the name ".$parse_param->curr_token_text." as there is already a function argument with this name." );
				}
				
				$parse_param->vars['function_arguments'][$current_function_number][$parse_param->vars['number_of_function_arguments'][$current_function_number]]['name'] = $parse_param->curr_token_text; 
				$parse_param->vars['function_arguments'][$current_function_number][$parse_param->vars['number_of_function_arguments'][$current_function_number]]['type'] = $type; 
				$parse_param->vars['function_arguments'][$current_function_number][$parse_param->vars['number_of_function_arguments'][$current_function_number]]['number_of_indexes'] = $number_of_dimensions; 
				$parse_param->vars['function_arguments'][$current_function_number][$parse_param->vars['number_of_function_arguments'][$current_function_number]]['is_variable_size'] = $is_variable_size; 
	
				$parse_param->vars['function_arguments'][$current_function_number][$parse_param->vars['number_of_function_arguments'][$current_function_number]]['size'] = $size; 
	
				$parse_param->vars['number_of_function_arguments'][$current_function_number]++;
			}
						
			next_token( $parse_param );
	
			if ($parse_param->curr_tok != TOK_COMMA && $parse_param->curr_tok != TOK_RPARENTHESIS)
				syntax_error( 12, $parse_param, "Expected a ',' or ')' after function arguments." );
			
			if ($parse_param->curr_tok == TOK_COMMA)
				next_token( $parse_param );
		}
		
		calc_function_parameter_offsets( $parse_param, $current_function_number );
		
		check_for_expected_token( $parse_param, TOK_RPARENTHESIS, 13, "Expected a ')' after function parameters." );
	
		next_token( $parse_param );
	
		if ($parse_param->curr_tok == TOK_SEMICOLON)
		{
			$parse_param->vars['number_of_declarations'][$current_function_number]++;
			
			if ($parse_param->vars['number_of_declarations'][$current_function_number] > 1)
				semantic_error( 163, $parse_param, "Cannot declare a function with the name '".$function_name."' as there is already a function defined with this name" );
			
			next_token( $parse_param );
		}
		else
		{
			for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
			{
				if ($parse_param->vars['function_name'][$j] == $function_name)
				{
					if ($parse_param->vars['number_of_function_arguments'][$j] != $number_of_arguments)
						semantic_error( 171, $parse_param, "Mismatch in function '".$function_name."' argument count: declaration has ".$parse_param->vars['number_of_function_arguments'][$j]." parameters but function definition has ".$number_of_arguments." parameters" );
				}
			} 
			
			$parse_param->vars['number_of_definitions'][$current_function_number]++;
	
			if ($parse_param->vars['number_of_definitions'][$current_function_number] > 1)
				semantic_error( 164, $parse_param, "Cannot define a function with the name '".$function_name."' as there is already a function defined with this name" );
			
				// function declaration names may not match the function definition names
				
			for ($j=0; $j < $number_of_arguments; $j++)
				$parse_param->vars['function_arguments'][$current_function_number][$j]['name'] = $argument_names[$j];
			
			
			$label_num2 = $parse_param->label_num;
		
			$parse_param->label_num++;
	
			for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
			{
				if ($parse_param->vars['function_name'][$j] == $function_name)
					$parse_param->vars['function_has_been_defined'][$j] = true;
			}
	
//			gen_code( $parse_param, $ic, $ic_pos, OP_JMP, $label_num2 );
			
			gen_code( $parse_param, $ic, $ic_pos, OP_START_FUNCTION, $current_function_number );
			
			$ic[$ic_pos-1]['text'] = $function_name;

			check_for_expected_token( $parse_param, TOK_LBRACE, 14, "Expected '{' after a function name." );
	
			next_token( $parse_param );
			
			parse_statlist( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );
		
		
			if ($function_name == "main")	
				gen_code( $parse_param, $ic, $ic_pos, OP_SYS_EXIT, 0 );
			else
				gen_code( $parse_param, $ic, $ic_pos, OP_RETURN, $current_function_number, $return_variable_type );
	
			$ic[$ic_pos-1]['return_variable_size'] = $parse_param->vars['return_variable_size'][$current_function_number]; 
	
	
//			gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num2 );

			check_for_expected_token( $parse_param, TOK_RBRACE, 15, "Expected '}' after a function statements." );
	
			next_token( $parse_param );
		}
	}

	
	function parse_statlist( &$parse_param, &$ic, &$ic_pos, &$current_function_number, $in_void_function )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_statlist<br>"; 				

		while ($parse_param->curr_tok != TOK_EOF && $parse_param->curr_tok != TOK_RBRACE)
			parse_stat( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );

		if ($parse_param->show_parse_trace)
			echo "parse_statlist returned<br>"; 				
	}

	
		// exit function with next token after ';' as current token
		
	function parse_stat( &$parse_param, &$ic, &$ic_pos, &$current_function_number, $in_void_function )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_stat<br>"; 	
		
		$allow_void = false;			

		$push_flags = 0;
						
		if ($parse_param->curr_tok == TOK_LBRACE)
		{
			next_token( $parse_param );
			
			parse_statlist( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );
		
			check_for_expected_token( $parse_param, TOK_RBRACE, 172, "Expected '}' after a statement list." );

			next_token( $parse_param );
		}
		else
        if ($parse_param->curr_tok == TOK_SEMICOLON)
		{
			next_token( $parse_param );
		}
		else
        if ($parse_param->curr_tok == TOK_IF)
		{
			parse_if_statment( $parse_param, $ic, $ic_pos, $num_dimensions, $allow_void, $current_function_number, $in_void_function );			
		}
		else
        if ($parse_param->curr_tok == TOK_FOR)
		{
			parse_for_statement( $parse_param, $ic, $ic_pos, $num_dimensions, $allow_void, $current_function_number, $in_void_function );			
		}
		else
        if ($parse_param->curr_tok == TOK_WHILE)
		{
			parse_while_statment( $parse_param, $ic, $ic_pos, $num_dimensions, $allow_void, $current_function_number, $in_void_function );			
		}
		else
		if ($parse_param->curr_tok == TOK_NAME && $parse_param->lookahead_tok == TOK_LPARENTHESIS)
		{			
			$name = $parse_param->curr_token_text;
			
			$function_name = $parse_param->curr_token_text;
				
			for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
			{
				if ($parse_param->vars['function_name'][$j] == $function_name)
					$parse_param->vars['has_been_called'][$j] = true;
			}
							
			next_token( $parse_param );

			$type = parse_function_call( $parse_param, $ic, $ic_pos, $current_function_number, $function_name );				

			$size = get_type_total_size( $parse_param, $type );

			if ($size > 0)		// void
			{
				gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, $size, "int" );

				gen_code( $parse_param, $ic, $ic_pos, OP_POP_DISCARD );
			}
							
			next_token( $parse_param );
		}
		else			
		if ($parse_param->curr_tok == TOK_INC || $parse_param->curr_tok == TOK_DEC)
		{
			if ($parse_param->curr_tok == TOK_INC)
			{
				$push_flags = PUSH_FLAGS_PRE_INC;
				next_token( $parse_param );
			}						
			else
			if ($parse_param->curr_tok == TOK_DEC)
			{
				$push_flags = PUSH_FLAGS_PRE_DEC;
				next_token( $parse_param );
			}			
			
			$name = $parse_param->curr_token_text;
			
			$array_name = $name;
			
			check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes, $is_global );
				
			$left_side_type = $type;
			
			next_token( $parse_param );
		
			if (strpos( $parse_param->for_control_variables, ":".$name.":" ) !== false)
				semantic_error( 174, $parse_param, "Loop control variable '".$name."' cannot have a value assigned to it by an assignment statement within its loop." );

			$left_side_dereference = true;
				
			$left_side_type = parse_aggregate_expression( $parse_param, $ic, $ic_pos, $num_dimensions, $allow_void, $type, $current_function_number, $array_name );
							
			if ($push_flags != 0)
			{
				if ($push_flags == PUSH_FLAGS_PRE_INC)
				{
					if (! is_numeric_type( $left_side_type ))
						semantic_error( 151, $parse_param, "Data type of a variable that has ++ applied to it must be numeric." );
				}						
				else
				if ($push_flags == PUSH_FLAGS_PRE_DEC)
				{
					if (! is_numeric_type( $left_side_type ))
						semantic_error( 152, $parse_param, "Data type of a variable that has -- applied to it must be numeric." );
				}			

				if ($push_flags == PUSH_FLAGS_PRE_INC)
					gen_code( $parse_param, $ic, $ic_pos, OP_VAR_INC, "" );
				else				
					gen_code( $parse_param, $ic, $ic_pos, OP_VAR_DEC, "" );
			}
			
			check_for_expected_token( $parse_param, TOK_SEMICOLON, 47, "Expected ';' after a statement." );
		
			next_token( $parse_param );
		}
		else
		if ($parse_param->curr_tok == TOK_NAME)
		{
			$name = $parse_param->curr_token_text;
			
			$array_name = $name;
			
			check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes, $is_global );
				
			$left_side_type = $type;
			
			next_token( $parse_param );
		
				// check for bulk copy on 'variable' arrays
				 
			if ($parse_param->curr_tok == TOK_ASSIGN && 
				$parse_param->lookahead_tok == TOK_NAME &&
				(! is_simple_data_type( $parse_param, $left_side_type )))
			{
					
				$is_function_name = false;
					
				for ($i=0; $i < $parse_param->vars['number_of_user_functions']; $i++)
				{
					if ($parse_param->vars['function_name'][$i] == $parse_param->lookahead_token_text)
						$is_function_name = true;
				}
				
				if (! $is_function_name)
				{
					check_var_declaration( $parse_param, $current_function_number, $type5, $parse_param->lookahead_token_text, $number_of_indexes, $is_global );
										
					if (strpos( $type5, "variable" ) !== false)
						semantic_error( 229, $parse_param, "Whole array copy is not supported on 'variable' array parameters." );
				}
			}				
			
			if (strpos( $parse_param->for_control_variables, ":".$name.":" ) !== false)
				semantic_error( 174, $parse_param, "Loop control variable '".$name."' cannot have a value assigned to it by an assignment statement within its loop." );
							
			$left_side_dereference = true;
				
			$left_side_type = parse_aggregate_expression( $parse_param, $ic, $ic_pos, $num_dimensions, $allow_void, $type, $current_function_number, $array_name );
							
			if ($parse_param->curr_tok == TOK_INC || $parse_param->curr_tok == TOK_DEC)
			{
				if ($parse_param->curr_tok == TOK_INC)
				{
					if (! is_numeric_type( $left_side_type ))
						semantic_error( 151, $parse_param, "Data type of a variable that has ++ applied to it must be numeric." );
					
					$push_flags = PUSH_FLAGS_POST_INC;
					next_token( $parse_param );
				}						
				else
				if ($parse_param->curr_tok == TOK_DEC)
				{
					if (! is_numeric_type( $left_side_type ))
						semantic_error( 152, $parse_param, "Data type of a variable that has -- applied to it must be numeric." );
					
					$push_flags = PUSH_FLAGS_POST_DEC;
					next_token( $parse_param );
				}

				if ($push_flags == PUSH_FLAGS_POST_INC)
					gen_code( $parse_param, $ic, $ic_pos, OP_VAR_INC, "" );
				else				
					gen_code( $parse_param, $ic, $ic_pos, OP_VAR_DEC, "" );
			}							
			else
			{
				if ($parse_param->curr_tok == TOK_ASSIGN_INC ||
					$parse_param->curr_tok == TOK_ASSIGN_DEC ||
					$parse_param->curr_tok == TOK_ASSIGN_MULT ||
					$parse_param->curr_tok == TOK_ASSIGN_DIV )
				{
					if (! is_numeric_type( $left_side_type ))
						semantic_error( 153, $parse_param, "Data type on the left side of a ".$parse_param->curr_token_text." operation must be numeric." );
				}
	
				if ($parse_param->curr_tok == TOK_ASSIGN_STRCONCAT)
				{
					if ($left_side_type != "string")
						semantic_error( 157, $parse_param, "Data type on the left side of an &= operation must be a string." );
				}

				parse_assignment_right_side( $parse_param, $ic, $ic_pos, $num_dimensions, false, $current_function_number, $name, $left_side_type, $left_side_dereference, $in_void_function );
	
				check_for_expected_token( $parse_param, TOK_SEMICOLON, 47, "Expected ';' after a statement." );
			
				next_token( $parse_param );
			}
		}
		else	
		if ($parse_param->curr_tok == TOK_INCLUDE_C)
		{
			next_token( $parse_param );
			
			check_for_expected_token( $parse_param, TOK_STRING_CONSTANT, 219, "Expected a text string after 'include_c'." );
			
			gen_code( $parse_param, $ic, $ic_pos, OP_INCLUDE_C, $parse_param->curr_token_text );
			
			next_token( $parse_param );
			
			check_for_expected_token( $parse_param, TOK_SEMICOLON, 220, "Expected a ';'." );
				
			next_token( $parse_param );
		}
		else	
		if ($parse_param->curr_tok == TOK_VAR)
		{
			parse_variable_declaration( $parse_param, $ic, $ic_pos, $num_dimensions, false, $current_function_number );			
		}
		else		
		{
			if ($parse_param->curr_tok == TOK_TYPE)
			{
				semantic_error( 234, $parse_param, "Types cannot be declared inside a function." );
				next_token( $parse_param );
			}
			else
			if ($parse_param->curr_tok == TOK_FUNCTION)
			{
				semantic_error( 235, $parse_param, "Functions cannot be declared inside another function." );
				next_token( $parse_param );
			}
			else
				syntax_error( 64, $parse_param, "Expected 'var', 'if', 'while' or a function or variable name" );
		}
		
		if ($parse_param->show_parse_trace)
			echo "parse_stat returned<br>"; 				
	}

	
		//------------------------------------------------------------------------------------------------
		// Parse a variable name with possibly an array and/or struct and/or link dereferences after it
		//
		// leave this function with a single pointer address on the stack
		//------------------------------------------------------------------------------------------------
	
	function parse_aggregate_expression( &$parse_param, &$ic, &$ic_pos, &$num_dimensions, $allow_void, $expression_type, &$current_function_number, $name )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_aggregate_expression<br>"; 				
					
		$first_item = true;
	
		if (is_global_variable( $parse_param, $current_function_number, $name ))
			$is_global = true;
		else
			$is_global = false;

			// push an absolute or relative address

		gen_code_push_var_address( $parse_param, $ic, $ic_pos, $current_function_number, $name );
			
		
		while ($parse_param->curr_tok == TOK_LBRACKET || $parse_param->curr_tok == TOK_DOT)
		{
			$prev_is_array = false;
			
			if ($parse_param->curr_tok == TOK_LBRACKET)
			{
				if ($prev_is_array)
					semantic_error( 131, $parse_param, "An array cannot contain another array, only simple data types or struct types. To specify an array with multiple dimensions use the syntax [index1, index2, index3 etc]." );
				
				$prev_is_array = true;
	
				check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes, $is_global );
		
				$array_type = $expression_type;
		
				$index_types = explode( " ", $expression_type );
		
				$start_of_indicies = 2;
				
				if ($index_types[1] == 'link')
					$start_of_indicies++;
				
				$number_of_indexes = (count( $index_types ) - $start_of_indicies)/2;		// 'array' <datatype> index1_type index1_count index2_type index2_count
//echo "x: ".$number_of_indexes."<br>";
		
				for ($j=0; $j < $number_of_indexes; $j++)
					$index_types[$j] = $index_types[ $start_of_indicies + ($j*2) ];
				
				$array_name = $name;
												
				$this_number_of_indexes = $number_of_indexes;
				
				next_token( $parse_param );
				
				$type = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number, $is_function_call );
		
				$index_number = 0;
		
				if (isset( $index_types[$start_of_indicies + ($index_number*2)] ))
				{
					if ($index_types[$start_of_indicies + ($index_number*2)] != $type)
						semantic_error( 39, $parse_param, "Expected a type '".$index_types[$start_of_indicies + ($index_number*2)]."' for index number ".$index_number." but type supplied is '".$type."'." );	
				}
				else
					semantic_error( 123, $parse_param, "Incorrect array index count: '".$array_name."'." );	
	
		
					// Array bounds check 
	  
	  			if ($parse_param->array_bounds_checks)
				{
					array_bounds_check( $parse_param, $ic, $ic_pos, $index_types, $start_of_indicies, $index_number, $current_function_number, $array_name, $number_of_indexes );
				}
					
				while ($parse_param->curr_tok == TOK_COMMA)
				{
					$index_number++;
					
					next_token( $parse_param );
		
					$type = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number, $is_function_call );
		
					if (isset( $index_types[$start_of_indicies + ($index_number*2)] ))
					{
						if ($index_types[$start_of_indicies + ($index_number*2)] != $type)
							semantic_error( 40, $parse_param, "Expected a type '".$index_types[$start_of_indicies + ($index_number*2)]."' for index number ".$index_number." but type supplied is '".$type."'." );
					}
					
					$subarray_size = 1;
					
					for ($k=0; $k < $index_number; $k++)
					{
						if ($index_types[$start_of_indicies + ($k*2)+1] != "variable")
							$subarray_size *= $index_types[$start_of_indicies + ($k*2)+1];
					}
	
					
	 					// Array bounds check 
	  
	  				if ($parse_param->array_bounds_checks)
						array_bounds_check( $parse_param, $ic, $ic_pos, $index_types, $start_of_indicies, $index_number, $current_function_number, $array_name, $number_of_indexes );
									
					if ($subarray_size > 1)
					{
						gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, $subarray_size, "int" );
	
						gen_code( $parse_param, $ic, $ic_pos, OP_MULT_INT );
	
						gen_code( $parse_param, $ic, $ic_pos, OP_ADD_INT );
					}
				}				
	
	
				$element_size = get_array_element_size( $parse_param, $array_type );
				
				gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, $element_size, "int" );
	
				gen_code( $parse_param, $ic, $ic_pos, OP_MULT_INT, 0 );
	
				if ($parse_param->c_output && (! $first_item))
					gen_code( $parse_param, $ic, $ic_pos, OP_ADD_INT, 0 );
	
	
//				gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, 1, "int" );
	
//				gen_code( $parse_param, $ic, $ic_pos, OP_ADD, 0 );
				
				$index_number++;
				
				if ($index_number != $number_of_indexes)
				{
					if ($index_number == 1)
						semantic_error( 41, $parse_param, "Expected ".$this_number_of_indexes." indexes for variable '".$array_name."' but received ".$index_number." index." );
					else
					if ($number_of_indexes == 1)
						semantic_error( 41, $parse_param, "Expected ".$this_number_of_indexes." index for variable '".$array_name."' but received ".$index_number." indexes." );
					else 
						semantic_error( 41, $parse_param, "Expected ".$this_number_of_indexes." indexes for variable '".$array_name."' but received ".$index_number." indexes." );
				}
				
				if ($parse_param->curr_tok != TOK_RBRACKET)
					syntax_error( 42, $parse_param, "Expected ']'." );
		
				next_token( $parse_param );
	
				$expression_type = array_element_type( $parse_param, $expression_type );

				$first_item = false;
			}
			else
			if ($parse_param->curr_tok == TOK_DOT)
			{
				if (sleft( $expression_type, 5 ) == 'link ')
				{
					$push_flags = 0;
	
					$s2 = explode( " ", $expression_type );
			
					$stat = true;
	
					$found = false;
	
					$expression_type = $s2[1];
	
					if ($first_item)
						gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, 0, "int" );
				
					if (! $is_global)
					{
						gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_REL_VARIABLE_ADDR, 0 );
						gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, 0, "int" );
					}
	
					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_DEREFERENCE, 0 );
	
					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, 0, "int" );
					
					$first_item = false;
					
					$is_global = true;
				}
				
				next_token( $parse_param );
		
				$item_name = $parse_param->curr_token_text;
				 
				check_for_expected_token( $parse_param, TOK_NAME, 130, "Expected a name after '.': ".$parse_param->curr_token_text );
	
				get_struct_item_details( $parse_param, $expression_type, $item_name, $item_type, $offset );
	 
				gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, $offset, "int" );
	
				if (! $first_item)
					gen_code( $parse_param, $ic, $ic_pos, OP_ADD_INT, 0 );
	
				$expression_type = $item_type;
				
				next_token( $parse_param );
			}
		
			$first_item = false;
		}

	
		if ($parse_param->c_output)
		{
			if (! $first_item)
				gen_code( $parse_param, $ic, $ic_pos, OP_ADD_TO_POINTER, 0 );
		}
		else
		{
			if ($is_global)
			{
				if (! $first_item)
					gen_code( $parse_param, $ic, $ic_pos, OP_ADD_INT, 0 );
			}
			else
			{
				if ($first_item)
					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, 0, "int" );
				
				gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_REL_VARIABLE_ADDR, 0 );
			}
		}
				
		if ($parse_param->show_parse_trace)
			echo "parse_aggregate_expression returned<br>"; 				
	
		return ($expression_type);
	}
	
	
	function array_bounds_check( &$parse_param, &$ic, &$ic_pos, $index_types, $start_of_indicies, $index_number, $current_function_number, $name, $number_of_indexes )
	{
		if (isset( $index_types[$start_of_indicies + (($index_number)*2)+1] ))
		{
			if ($index_types[$start_of_indicies + (($index_number)*2)+1] == "variable")
			{
				if ($parse_param->c_output)
					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_REL_ADDR_BASE, get_variable_offset( $parse_param, $current_function_number, $name ) + SIZEOF_VAR );
				else
					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_REL_ADDR_BASE, get_variable_offset( $parse_param, $current_function_number, $name ) + 1 );
	
				gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, 0, "int" );
	
				gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_VAR, $name, "int" );
			}
			else
				gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, $index_types[$start_of_indicies + (($index_number)*2)+1], "int" );
	
			$label_num6 = $parse_param->label_num;
	
			$parse_param->label_num++;
	
			gen_code( $parse_param, $ic, $ic_pos, OP_POP_JMP_LT, $label_num6 );
	
			
			gen_code( $parse_param, $ic, $ic_pos, OP_ERROR, 167, "", "Array bounds overflow index ".($index_number+1) );
	
			gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num6 );
	
			
			gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, "0", "int" );
	
			$label_num6 = $parse_param->label_num;
	
			$parse_param->label_num++;
	
			gen_code( $parse_param, $ic, $ic_pos, OP_POP_JMP_GE, $label_num6 );
			
			gen_code( $parse_param, $ic, $ic_pos, OP_ERROR, 167, "", "Array bounds negative index, index ".($index_number+1) );
	
			gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num6 );
		}
	}	
	
	
	
	function parse_assignment_right_side( &$parse_param, &$ic, &$ic_pos, &$num_dimensions, $allow_void, &$current_function_number, $name, $left_side_type, $left_side_dereference )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_assignment_right_side<br>"; 				
	
		if ($parse_param->curr_tok == TOK_ASSIGN)
		{
			check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes, $is_global );
			
			$array_type = $type;
			
			next_token( $parse_param );
			
			if ($parse_param->curr_tok == TOK_NEW)
			{
				if (sleft( $left_side_type, 5 ) != 'link ')
					syntax_error( 185, $parse_param, "'new' can only be applied to a link." );
	
				if (! $left_side_dereference )
					gen_code_push_var_address( $parse_param, $ic, $ic_pos, $current_function_number, $name );
				
				$destination_size = get_link_destination_size( $parse_param, $left_side_type );
	
				gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, $destination_size, "int" );
				
				gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_NEW_ALLOC, 0 );

				gen_code( $parse_param, $ic, $ic_pos, OP_POP_VAR, $name, "int" );
	
				next_token( $parse_param );
	
				check_for_expected_token( $parse_param, TOK_SEMICOLON, 180, "Expected a name after 'type': ".$parse_param->curr_token_text );
			}
			else
			{
				$right_side_name = $parse_param->curr_token_text;
				
				if (is_global_variable( $parse_param, $current_function_number, $right_side_name ))
					$is_global_right_side = true;
				else
					$is_global_right_side = false;
				
				
				if (! $left_side_dereference )
				{
					gen_code_push_var_address( $parse_param, $ic, $ic_pos, $current_function_number, $name );
				}
				
				$right_side_type = parse_expr( $parse_param, $ic, $ic_pos, $current_function_number );
		
			//	if (! ($is_function_call && type_matches_array_reference_function_call( $left_side_type, $right_side_type )))
				{
					if (! check_types( $parse_param, $ic, $ic_pos, $left_side_type, $right_side_type, true, 0 ))
					{
						if (! ($left_side_type == 'binary' && $right_side_type == 'string' ) &&
						    ! (sleft( $left_side_type, 5 ) == 'link ' && $right_side_type == 'link general'))
								semantic_error( 35, $parse_param, "Data types in an assignment expression must match, both be numeric, or be to type string: '".$left_side_type."' and '".$right_side_type."'." );
					}

				}

				generate_type_conversion_if_necessary( $parse_param, $ic, $ic_pos, $right_side_type, $left_side_type, 1 );
				
		//		if (! ($right_side_type == $left_side_type || (is_numeric_type( $right_side_type ) && is_numeric_type( $left_side_type ))))
		//			semantic_error( 35, $parse_param, "Data types in assignment expression must match or both be numeric: '".$left_side_type."' and '".$right_side_type."'." );
		
				check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes, $is_global_left_side );
			
				$size = get_type_total_size( $parse_param, $left_side_type );
				
				if ($parse_param->show_warnings && $size >= 200)
					syntax_warning( 8, $parse_param, "Large copy of ".$size." bytes, will slow program performance" );

				gen_code( $parse_param, $ic, $ic_pos, OP_POP_VAR, $name, $left_side_type );
			}
		}
		else
		if ($parse_param->curr_tok == TOK_ASSIGN_INC ||
			$parse_param->curr_tok == TOK_ASSIGN_DEC ||
			$parse_param->curr_tok == TOK_ASSIGN_MULT ||
			$parse_param->curr_tok == TOK_ASSIGN_DIV ||
			$parse_param->curr_tok == TOK_ASSIGN_STRCONCAT)
		{
			$operat = $parse_param->curr_tok;
			$operat_text = $parse_param->curr_token_text;

			check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes, $is_global );
			
			next_token( $parse_param );
	
			gen_code( $parse_param, $ic, $ic_pos, OP_DUPLICATE, 0 );
				
			gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, 0, "int" );
			
			gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_VAR, $name, $left_side_type );
	
			$right_side_type = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number, $is_function_call );
	
			if ($operat != TOK_ASSIGN_STRCONCAT && (! is_numeric_type( $right_side_type ) ))
				semantic_error( 155, $parse_param, "Data type of the expression on the right side of an ".$operat_text." must be numeric." );

			generate_type_conversion_if_necessary( $parse_param, $ic, $ic_pos, $right_side_type, $left_side_type, 1 );
	
			if ($operat == TOK_ASSIGN_STRCONCAT)
				gen_code( $parse_param, $ic, $ic_pos, OP_STRCONCAT, $name );
			else
			if ($left_side_type == "int")
			{
				if ($operat == TOK_ASSIGN_INC)				gen_code( $parse_param, $ic, $ic_pos, OP_ADD_INT, $name );			else
				if ($operat == TOK_ASSIGN_DEC)				gen_code( $parse_param, $ic, $ic_pos, OP_SUBTRACT_INT, $name );		else
				if ($operat == TOK_ASSIGN_MULT)				gen_code( $parse_param, $ic, $ic_pos, OP_MULT_INT, $name );			else
				if ($operat == TOK_ASSIGN_DIV)
				{
					if ($parse_param->show_warnings)
						syntax_warning( 0, $parse_param, "Integer division, fractional component truncated" );
					
					gen_code( $parse_param, $ic, $ic_pos, OP_DIV_INT, $name );
				}					
			}
			else
			if ($left_side_type == "decimal")
			{
				if ($operat == TOK_ASSIGN_INC)				gen_code( $parse_param, $ic, $ic_pos, OP_ADD_DECIMAL, $name );			else
				if ($operat == TOK_ASSIGN_DEC)				gen_code( $parse_param, $ic, $ic_pos, OP_SUBTRACT_DECIMAL, $name );		else
				if ($operat == TOK_ASSIGN_MULT)				gen_code( $parse_param, $ic, $ic_pos, OP_MULT_DECIMAL, $name );			else
				if ($operat == TOK_ASSIGN_DIV)				gen_code( $parse_param, $ic, $ic_pos, OP_DIV_DECIMAL, $name );
			}
			else
			if ($left_side_type == "double")
			{
				if ($operat == TOK_ASSIGN_INC)				gen_code( $parse_param, $ic, $ic_pos, OP_ADD_DOUBLE, $name );			else
				if ($operat == TOK_ASSIGN_DEC)				gen_code( $parse_param, $ic, $ic_pos, OP_SUBTRACT_DOUBLE, $name );		else
				if ($operat == TOK_ASSIGN_MULT)				gen_code( $parse_param, $ic, $ic_pos, OP_MULT_DOUBLE, $name );			else
				if ($operat == TOK_ASSIGN_DIV)				gen_code( $parse_param, $ic, $ic_pos, OP_DIV_DOUBLE, $name );
			}
											
			check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes, $is_global );
	
			gen_code( $parse_param, $ic, $ic_pos, OP_POP_VAR, $name, $left_side_type );
		}

		if ($parse_param->show_parse_trace)
			echo " returned<br>"; 				
	}
	
	function parse_const_declaration( &$parse_param, &$ic, &$ic_pos, &$num_dimensions, $allow_void )
	{
		next_token( $parse_param );
		
		$type = $parse_param->curr_token_text;
		
		if (! is_data_type( $parse_param, $parse_param->curr_tok, $parse_param->curr_token_text, $size ))
			syntax_error( 59, $parse_param, "Expected a data type: ".$parse_param->curr_token_text );
	
		next_token( $parse_param );
		
		check_for_expected_token( $parse_param, TOK_NAME, 60, "Expected a name after a 'const'" );
		
		if (is_reserved_word( $parse_param->curr_token_text ) )
			syntax_error( 61, $parse_param, "'".$parse_param->curr_token_text."' cannot be defined as a variable name it is a reserved word" );
		
		$const_name = $parse_param->curr_token_text;
	
		next_token( $parse_param );

		check_for_expected_token( $parse_param, TOK_ASSIGN, 62, "Expected a '=' after a 'const' name" );
		
		next_token( $parse_param );
	
		$minus = "";
	
		if ($parse_param->curr_tok == TOK_SUBTRACT_MINUS)
		{
			$minus = "-";
			next_token( $parse_param );
			
			check_for_expected_token( $parse_param, TOK_NUMBER, 169, "Expected a number after 'const' '-'" );
		}
					
		if (isset( $parse_param->constants[$const_name]['value'] ))
			syntax_error( 149, $parse_param, "Cannot define a constant with the name '".$const_name."' because there is already a constant defined with that name." );
		else
		{
			$parse_param->constants[$const_name]['value'] = $minus.$parse_param->curr_token_text;
			$parse_param->constants[$const_name]['type'] = $type; 
		}
		
		next_token( $parse_param );
	
		check_for_expected_token( $parse_param, TOK_SEMICOLON, 63, "Expected a ';' after a 'const'" );
	
		next_token( $parse_param );
	}
	
	
				
	function parse_variable_declaration( &$parse_param, &$ic, &$ic_pos, &$num_dimensions, $allow_void, $current_function_number )
	{
		next_token( $parse_param );
	
		$type = parse_data_type( $parse_param, $ic, $ic_pos, $number_of_dimensions, false, false, $size, false, $is_variable_size );
		
		while ($parse_param->curr_tok != TOK_SEMICOLON && $parse_param->curr_tok != TOK_EOF)
		{
			check_for_expected_token( $parse_param, TOK_NAME, 54, "Expected the word 'array' or a name after a 'var'." );
			
			if (is_reserved_word( $parse_param->curr_token_text ) )
				syntax_error( 55, $parse_param, "'".$parse_param->curr_token_text."' cannot be defined as a variable name it is a reserved word." );
			
			if ($parse_param->in_function)
			{
				for ($j=0; $j < $parse_param->vars['number_of_function_arguments'][$current_function_number]; $j++)
				{
					if ($parse_param->vars['function_arguments'][$current_function_number][$j]['name'] == $parse_param->curr_token_text)
						semantic_error( 56, $parse_param, "Cannot declare a local variable with the name '".$parse_param->curr_token_text."' in this function because there is a function parameter with the same name." );
				}
	
				for ($j=0; $j < $parse_param->vars['number_of_local_variables'][$current_function_number]; $j++)
				{
					if ($parse_param->vars['local_variables'][$current_function_number][$j]['name'] == $parse_param->curr_token_text)
						semantic_error( 134, $parse_param, "Cannot declare a local variable with the name '".$parse_param->curr_token_text."' there is already a local variable with this name." );
				}
	
				$parse_param->vars['local_variables'][$current_function_number][$parse_param->vars['number_of_local_variables'][$current_function_number]]['name'] = $parse_param->curr_token_text;
				$parse_param->vars['local_variables'][$current_function_number][$parse_param->vars['number_of_local_variables'][$current_function_number]]['type'] = $type;
				$parse_param->vars['local_variables'][$current_function_number][$parse_param->vars['number_of_local_variables'][$current_function_number]]['number_of_indexes'] = $number_of_dimensions;
				$parse_param->vars['local_variables'][$current_function_number][$parse_param->vars['number_of_local_variables'][$current_function_number]]['size'] = $size;
	
				if ($parse_param->c_output)
					$offset = SIZEOF_VAR;
				else
					$offset = 1;
			
				for ($i=0; $i < $parse_param->vars['number_of_local_variables'][$current_function_number]; $i++)
					$offset += $parse_param->vars['local_variables'][$current_function_number][$i]['size'];

				$parse_param->vars['local_variables'][$current_function_number][$parse_param->vars['number_of_local_variables'][$current_function_number]]['offset'] = $offset;
				
				$parse_param->vars['number_of_local_variables'][$current_function_number]++;
			}
			else
			{
				for ($j=0; $j < $parse_param->vars['number_of_global_variables']; $j++)
				{
					if ($parse_param->vars['global_variables'][$j]['name'] == $parse_param->curr_token_text)
						semantic_error( 135, $parse_param, "Cannot declare a global variable with the name '".$parse_param->curr_token_text."' there is already a global variable with this name." );
				}

				$parse_param->vars['global_variables'][$parse_param->vars['number_of_global_variables']]['name'] = $parse_param->curr_token_text;
				$parse_param->vars['global_variables'][$parse_param->vars['number_of_global_variables']]['type'] = $type;
				$parse_param->vars['global_variables'][$parse_param->vars['number_of_global_variables']]['number_of_indexes'] = $number_of_dimensions;
				$parse_param->vars['global_variables'][$parse_param->vars['number_of_global_variables']]['size'] = $size;
				 
	
				 			// don't point links to location 0

				if ($parse_param->c_output)
					$offset = 0;
				else
				{					
//					if ($parse_param->c_output)
//						$offset = SIZEOF_VAR;
//					else

					$offset = 1;

					for ($i=0; $i < $parse_param->vars['number_of_global_variables']; $i++)
					{
						if (sleft( $type, 6 ) == "array ")	
							$offset++;						// size of the array
							
						$offset += $parse_param->vars['global_variables'][$i]['size'];
					}
				}
	
				$parse_param->vars['global_variables'][$parse_param->vars['number_of_global_variables']]['offset'] = $offset;
				 
				$parse_param->vars['number_of_global_variables']++;
			}
	
			for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
			{
				if ($parse_param->vars['function_name'][$j] == $parse_param->curr_token_text)
					semantic_error( 1337, $parse_param, "Cannot declare a variable with the name '".$parse_param->curr_token_text."' there is already a function with this name." );
			}			
	
			
			next_token( $parse_param );
	
			if ($parse_param->curr_tok != TOK_COMMA && $parse_param->curr_tok != TOK_SEMICOLON)
				syntax_error( 57, $parse_param, "Expected a ',' or ';' after a 'var' name" );
			
			if ($parse_param->curr_tok == TOK_COMMA)
				next_token( $parse_param );
		}
		
		check_for_expected_token( $parse_param, TOK_SEMICOLON, 58, "Expected ';' after a var statement" );
	
		next_token( $parse_param );
	}	
	
	
	function parse_while_statment( &$parse_param, &$ic, &$ic_pos, &$num_dimensions, $allow_void, &$current_function_number, $in_void_function )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_while_statment<br>"; 				
		
		next_token( $parse_param );
		
		check_for_expected_token( $parse_param, TOK_LPARENTHESIS, 31, "Expected '(' after 'while'." );
	
		next_token( $parse_param );
		
		$label_num4 = $parse_param->label_num;
			
		gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num4 );
			
		$parse_param->label_num++;
		
		$type = parse_expr( $parse_param, $ic, $ic_pos, $current_function_number );
	
		if ($type != "bool")
			semantic_error( 32, $parse_param, "Expected a boolean expression as the control condition of a 'while'." );
	
		$label_num5 = $parse_param->label_num;
	
		$parse_param->label_num++;
	
		gen_code( $parse_param, $ic, $ic_pos, OP_JMP_FALSE, $label_num5 );
	
		check_for_expected_token( $parse_param, TOK_RPARENTHESIS, 33, "Expected ')' after boolean expression." );
	
		next_token( $parse_param );
	
		if ($parse_param->curr_tok != TOK_LBRACE)
		{
			parse_stat( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );
		} 					
		else
		{
			next_token( $parse_param );
			
			parse_statlist( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );
			
			check_for_expected_token( $parse_param, TOK_RBRACE, 34, "Expected '}' after a statement list." );
			
			next_token( $parse_param );
		}
	
		gen_code( $parse_param, $ic, $ic_pos, OP_JMP, $label_num4 );
		
		gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num5 );
		
		if ($parse_param->show_parse_trace)
			echo "parse_while_statment returned<br>"; 				
	}


	function parse_for_statement( &$parse_param, &$ic, &$ic_pos, &$num_dimensions, $allow_void, &$current_function_number, $in_void_function )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_for_statement<br>"; 				
	
		$step = "1";
		
		next_token( $parse_param );
		
		check_for_expected_token( $parse_param, TOK_LPARENTHESIS, 23, "Expected '(' after 'for'." );
	
		next_token( $parse_param );
		
		check_for_expected_token( $parse_param, TOK_NAME, 24, "Expected a variable name after 'for'." );
			
		$ctrl_variable_name = $parse_param->curr_token_text;
		
		if (strpos( $parse_param->for_control_variables, ":".$ctrl_variable_name.":" ) !== false)
			semantic_error( 173, $parse_param, "Loop control variable '".$ctrl_variable_name."' cannot be reused as a loop variable in an inner loop of the main loop" );
			
		$parse_param->for_control_variables .= $ctrl_variable_name.":";
		 
		check_var_declaration( $parse_param, $current_function_number, $type, $ctrl_variable_name, $number_of_indexes, $is_global );
		
		if ($type != "int")
			semantic_error( 175, $parse_param, "Loop control variable '".$ctrl_variable_name."' must be of type 'int'." );
		
		next_token( $parse_param );
		
		check_for_expected_token( $parse_param, TOK_ASSIGN, 25, "Expected a '=' after the 'for' variable name." );
	
		next_token( $parse_param );
	
		$is_function_call = false;

			// pop the initial control variable value from the stack

		$control_variable_is_global = is_global_variable( $parse_param, $current_function_number, $ctrl_variable_name );
							
		gen_code_push_var_address( $parse_param, $ic, $ic_pos, $current_function_number, $ctrl_variable_name );
							
	
		$type = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number, $is_function_call );		// initial control variable value
	
		if (! is_numeric_type( $type ))
			syntax_error( 26, $parse_param, "Expected a numeric expression for 'from'." );
	
		gen_code( $parse_param, $ic, $ic_pos, OP_POP_VAR, $ctrl_variable_name, "int" );
		
		check_for_expected_token( $parse_param, TOK_TO, 27, "Expected a 'to' after the 'for' variable name: ".$parse_param->curr_token_text."." );
		
		next_token( $parse_param );
	
		$type = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number, $is_function_call );		// final control variable value
	
		if (! is_numeric_type( $type ))
			syntax_error( 28, $parse_param, "Expected a numeric expression for 'to'." );
	
		$label_num7 = $parse_param->label_num;
			
		gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num7 );		// label to jump to
	
		if ($parse_param->curr_tok == TOK_STEP)
		{
			next_token( $parse_param );
			
			$step = $parse_param->curr_token_text;
			
			if ($step == "-")
			{
				next_token( $parse_param );
				
				$step = "-".$parse_param->curr_token_text;
			}
			
			next_token( $parse_param );
		}
	
		$parse_param->label_num++;
	
		$label_num8 = $parse_param->label_num;
	
		$parse_param->label_num++;
	
	//	gen_code( $parse_param, $ic, $ic_pos, OP_DUPLICATE, $ctrl_variable_name );
	
			// push the control variable onto the stack
			
		gen_code_push_var_address( $parse_param, $ic, $ic_pos, $current_function_number, $ctrl_variable_name );
						

		gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, 0, "int" );

		gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_VAR, $ctrl_variable_name, "int" );
		
		if ($step == 0)
			semantic_error( 168, $parse_param, "A 'for' loop cannot have a zero step size." );
		
		if ($step > 0)
			gen_code( $parse_param, $ic, $ic_pos, OP_POP_JMP_LT, $label_num8 );		  
		else
			gen_code( $parse_param, $ic, $ic_pos, OP_POP_JMP_GT, $label_num8 );
		
		check_for_expected_token( $parse_param, TOK_RPARENTHESIS, 29, "Expected a ')' after the 'for' statement." );
	
		next_token( $parse_param );
	
		if ($parse_param->curr_tok != TOK_LBRACE)
		{
			parse_stat( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );
		} 					
		else
		{
			next_token( $parse_param );
			
			parse_statlist( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );
			
			check_for_expected_token( $parse_param, TOK_RBRACE, 30, "Expected '}' after a statement list." );
			
			next_token( $parse_param );
		}
	
		if ($parse_param->for_control_variables == "")
			$parse_param->for_control_variables = ":" . $ctrl_variable_name . ":";
		else
	
		$parse_param->for_control_variables = str_replace( ":" . $ctrl_variable_name . ":", ":", $parse_param->for_control_variables );
	
		
		gen_code_push_var_address( $parse_param, $ic, $ic_pos, $current_function_number, $ctrl_variable_name );
		
		gen_code_push_var_address( $parse_param, $ic, $ic_pos, $current_function_number, $ctrl_variable_name );

		gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, 0, "int" );
		
		gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_VAR, $ctrl_variable_name, "int" );
		
		gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, $step, "int" );
			
		gen_code( $parse_param, $ic, $ic_pos, OP_ADD_INT );
	
		
		gen_code( $parse_param, $ic, $ic_pos, OP_POP_VAR, $ctrl_variable_name, "int" );
	
		gen_code( $parse_param, $ic, $ic_pos, OP_JMP, $label_num7 );
		
		gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num8 );
		
		gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, get_simple_type_size( $parse_param, "int" ), "int" );
		
		gen_code( $parse_param, $ic, $ic_pos, OP_POP_DISCARD );
	
		if ($parse_param->show_parse_trace)
			echo "parse_for_statement returned<br>"; 				
	}
	

	function parse_if_statment( &$parse_param, &$ic, &$ic_pos, &$num_dimensions, $allow_void, &$current_function_number, $in_void_function )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_if_statment<br>"; 				
		
		next_token( $parse_param );
	
		check_for_expected_token( $parse_param, TOK_LPARENTHESIS, 18, "Expected '(' after an if." );
	
		next_token( $parse_param );
		
		$type = parse_expr( $parse_param, $ic, $ic_pos, $current_function_number );
	
		if ($type != "bool")
			semantic_error( 19, $parse_param, "Expected a boolean expression as the control condition of an 'if'." );
	
		$label_num1 = $parse_param->label_num;
		
		gen_code( $parse_param, $ic, $ic_pos, OP_JMP_FALSE, $label_num1 );
	
		$parse_param->label_num++;
	
		check_for_expected_token( $parse_param, TOK_RPARENTHESIS, 20, "Expected ')' after an if expression." );
	
		next_token( $parse_param );
	
								
		if ($parse_param->curr_tok != TOK_LBRACE)
		{
			parse_stat( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );
		}					
		else
		{
			next_token( $parse_param );
			
			parse_statlist( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );
								
			check_for_expected_token( $parse_param, TOK_RBRACE, 21, "Expected '}' after a statement list." );
			
			next_token( $parse_param );
		}
	
		if ($parse_param->curr_tok == TOK_ELSE)
		{
			$label_num2 = $parse_param->label_num;
	
			gen_code( $parse_param, $ic, $ic_pos, OP_JMP, $label_num2 );
			
			gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num1 );
			
			$parse_param->label_num++;
						
			next_token( $parse_param );
	
			if ($parse_param->curr_tok != TOK_LBRACE)
			{
				parse_stat( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );
			}					
			else
			{
				next_token( $parse_param );
				
				parse_statlist( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );
	
				check_for_expected_token( $parse_param, TOK_RBRACE, 22, "Expected '}' after a statement list." );
	
				next_token( $parse_param );
			}
			
			gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num2 );
		}
		else	
			gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num1 );
	
		if ($parse_param->show_parse_trace)
			echo "parse_if_statment returned<br>"; 				
	}



	function parse_data_type( &$parse_param, &$ic, &$ic_pos, &$num_dimensions, $allow_void, $in_function_declaration, &$size, $allow_variable_arrays, &$is_variable_size )
	{
		$num_dimensions = 0;

		$is_variable_size = false;
				
		if ($parse_param->c_output)
			$size = SIZEOF_VAR;
		else
			$size = 1;
				
		if ($allow_void && $parse_param->curr_tok == TOK_VOID)
		{
			$type = "void";

			next_token( $parse_param );
		}
		else
		{
			if ($parse_param->curr_tok == TOK_LINK)
			{
				$type = "link ";

				next_token( $parse_param );

				if ($parse_param->curr_token_text == 'void' && $parse_param->lookahead_token_text != 'lnull')
					semantic_error( 186, $parse_param, "Can't declare a link as pointing to void." );

				$type .= $parse_param->curr_token_text;
				
				next_token( $parse_param );
			}
			else				
			if ($parse_param->curr_tok == TOK_ARRAY)
			{
					// types for arrays:		array <type> index1_type index1_count index2_type index2_count
				$type = "array ";
				
				$total_elements = 0;
				
				next_token( $parse_param );
	
				$type .= $parse_param->curr_token_text;
				
				if ($parse_param->curr_token_text == 'link')
				{
					next_token( $parse_param );
					
					$type .= " ".$parse_param->curr_token_text;
				}					

				if (! is_data_type( $parse_param, $parse_param->curr_tok, $parse_param->curr_token_text, $size ))
					syntax_error( 65, $parse_param, "Expected a data type: ".$parse_param->curr_token_text );
	
				next_token( $parse_param );
				
	//			$array_name = $parse_param->curr_token_text;
				
	//			$num_dimensions = 0;

				check_for_expected_token( $parse_param, TOK_LBRACKET, 66, "Expected a '['" );
	
				$num_dimensions = 0;
				
				$missing_number_elements = 0;
	
				$variable_dimension = -1;
	
				do
				{								
//					next_token( $parse_param );
	
					$type .= " int";
//					$type .= " ".$parse_param->curr_token_text;

//					if ($parse_param->curr_tok != TOK_INT)
//						syntax_error( 68, $parse_param, "Expected 'int'" );
							
/*					
						$parse_param->curr_tok != TOK_STRING && 
						$parse_param->curr_tok != TOK_DATE &&
						$parse_param->curr_tok != TOK_TIME &&
						$parse_param->curr_tok != TOK_DATETIME)
 
							syntax_error( 68, $parse_param, "Expected 'int' or 'string' or 'date' or 'time' or 'datetime'" );
*/
	
//					if ($parse_param->curr_tok == TOK_INT)
//						syntax_error( 68, $parse_param, "Expected 'int num' after '['" );
					
					next_token( $parse_param );

					$last_was_missing = false;
						
										// number of elements
										
 
					if ($parse_param->curr_tok == TOK_NAME)
					{
						if (isset( $parse_param->constants[$parse_param->curr_token_text]['value'] ))
						{
							if (! is_numeric( $parse_param->constants[$parse_param->curr_token_text]['value'] ))
								syntax_error( 211, $parse_param, "Expected a numeric constant" );
							
							$type .= " ".$parse_param->constants[$parse_param->curr_token_text]['value'];
		
							if ($total_elements == 0)
								$total_elements = (int) $parse_param->constants[$parse_param->curr_token_text]['value'];
							else
								$total_elements = $total_elements * (int) $parse_param->constants[$parse_param->curr_token_text]['value'];
							
							next_token( $parse_param );
						}
						else
							syntax_error( 189, $parse_param, "Expected a number or the word 'variable'" );
					}
					else										
					if ($parse_param->curr_tok == TOK_NUMBER)
					{							
						$type .= " ".$parse_param->curr_token_text;
	
						if ($total_elements == 0)
							$total_elements = (int) $parse_param->curr_token_text;
						else
							$total_elements = $total_elements * (int) $parse_param->curr_token_text;
						
						next_token( $parse_param );
					}
					else
					if ($parse_param->curr_tok != TOK_VARIABLE)
						syntax_error( 189, $parse_param, "Expected a number or the word 'variable'" );
					else
					{
						$type .= " variable";

						if (! $allow_variable_arrays)
							syntax_error( 191, $parse_param, "Variable length arrays can only be used in function arguments." );
		
						if ($variable_dimension != -1)
							syntax_error( 190, $parse_param, "Only the last dimension of an array can be 'variable'" );

						$is_variable_size = true;

						$missing_number_elements++;
				
						$last_was_missing = true;
						
						next_token( $parse_param );
						
						$variable_dimension = $num_dimensions + 1; 
					}
					
					$num_dimensions++;
				}
				while ($parse_param->curr_tok == TOK_COMMA);

				if ($variable_dimension != -1 && $variable_dimension != $num_dimensions)
					syntax_error( 190, $parse_param, "Only the last dimension of an array can be 'variable'" );

				$size = $size * $total_elements;
				
				if ($missing_number_elements > 1 || ($missing_number_elements == 1 && (! $last_was_missing)))
					syntax_error( 67, $parse_param, "Expected a number after '[ datatype'" );

				if ($parse_param->curr_tok != TOK_RBRACKET)
					syntax_error( 69, $parse_param, "Expected ']'" );

				next_token( $parse_param );
				
// xx	
// if array, size++	
				
			}
			else
			{
				$type = $parse_param->curr_token_text;
				
				if (! is_data_type( $parse_param, $parse_param->curr_tok, $parse_param->curr_token_text, $size ))
					syntax_error( 70, $parse_param, "Expected a data type: ".$parse_param->curr_token_text );
				
				next_token( $parse_param );
			}
		}
		
		return ($type);
	}



	function parse_expr( &$parse_param, &$ic, &$ic_pos, $current_function_number )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_expr<br>"; 				

		$type = parse_comp_expr( $parse_param, $ic, $ic_pos, $current_function_number );
			
		$op = $parse_param->curr_tok;
			 		
		while ($op == TOK_AND || $op == TOK_OR)
		{
			next_token( $parse_param );			

			$label_num1 = $parse_param->label_num;
	
			$parse_param->label_num++;

			
			if ($op == TOK_AND)
				gen_code( $parse_param, $ic, $ic_pos, OP_JMP_FALSE_DONT_POP, $label_num1 );
			else
			if ($op == TOK_OR)
				gen_code( $parse_param, $ic, $ic_pos, OP_JMP_TRUE_DONT_POP, $label_num1 );

//	        if ($parse_param->curr_tok == TOK_LPARENTHESIS)
//				$type = parse_expr( $parse_param, $ic, $ic_pos, $current_function_number );
//			else

				$type = parse_comp_expr( $parse_param, $ic, $ic_pos, $current_function_number );
								
			if ($type != "bool")
				semantic_error( 74, $parse_param, "Expected a boolean expression as an argument to an 'and' or 'or'" );

	        if ($op == TOK_OR)
			{
				gen_code( $parse_param, $ic, $ic_pos, OP_OR );
			}
			else
	        if ($op == TOK_AND)
			{
				gen_code( $parse_param, $ic, $ic_pos, OP_AND );
			}

			gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num1 );

			$op = $parse_param->curr_tok;
		}
		
		if ($parse_param->show_parse_trace)
			echo "parse_expr returned<br>";
		
		return ($type);
	}


	function parse_comp_expr( &$parse_param, &$ic, &$ic_pos, $current_function_number )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_comp_expr<br>"; 				

//		$not = false;
				
        if ($parse_param->curr_tok == TOK_NOT)
		{
//			$not = true;
			next_token( $parse_param );
			
	        if ($parse_param->curr_tok == TOK_LPARENTHESIS)
			{
				next_token( $parse_param );
				
				$type = parse_expr( $parse_param, $ic, $ic_pos, $current_function_number );
				
				if ($type != "bool")
					semantic_error( 75, $parse_param, "Expected a boolean expression as an argument to a 'not'" );
								
				check_for_expected_token( $parse_param, TOK_RPARENTHESIS, 76, "Expected ')' after boolean expression" );
													
				next_token( $parse_param );
			}
			else
				$type = parse_item_expr( $parse_param, $ic, $ic_pos, $current_function_number, $is_function_call );

			if ($type != "bool")
				semantic_error( 75, $parse_param, "Expected a boolean expression as an argument to a 'not'" );
											
			gen_code( $parse_param, $ic, $ic_pos, OP_NOT );
			
//			$type = 'bool';
		}			
		else
		{
			$type1 = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number, $is_function_call );

			$type = $type1;
			
			if ($parse_param->curr_tok == TOK_EQ || 
				$parse_param->curr_tok == TOK_NE ||
				$parse_param->curr_tok == TOK_GE ||
				$parse_param->curr_tok == TOK_GT ||
				$parse_param->curr_tok == TOK_LE ||
				$parse_param->curr_tok == TOK_LT)
			{
				$operator = $parse_param->curr_tok;
				$operator_text = $parse_param->curr_token_text;
								
				next_token( $parse_param );
		
				$type2 = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number, $is_function_call );
	
				if (! ($type1 == $type2 || sleft( $type1, 5 ) == 'link ' || (is_numeric_type( $type1 ) && is_numeric_type( $type2 ))))
					semantic_error( 77, $parse_param, "Data types must match or both be numeric: '".$type1."' and '".$type2."'" );
				
				if (is_numeric_type( $type1 ))
					$type1 = promote_numeric_type( $parse_param, $ic, $ic_pos, $type1, $type2 );

				if ($operator == TOK_GE ||
					$operator == TOK_GT ||
					$operator == TOK_LE ||
					$operator == TOK_LT)
				{
					if ($type1 != "int" &&
						$type1 != "decimal" &&					
						$type1 != "double" &&					
						$type1 != "date" &&					
						$type1 != "time" &&					
						$type1 != "datetime" &&					
						$type1 != "string")					
							semantic_error( 198, $parse_param, "Data type '".$type1."' does not have a '".$operator_text."' operator." );
				}
				
				if ($type1 == "int")
				{
					if ($operator == TOK_EQ)	gen_code( $parse_param, $ic, $ic_pos, OP_EQ_INT );
					if ($operator == TOK_NE)	gen_code( $parse_param, $ic, $ic_pos, OP_NE_INT );
					if ($operator == TOK_GE)	gen_code( $parse_param, $ic, $ic_pos, OP_GE_INT );
					if ($operator == TOK_GT)	gen_code( $parse_param, $ic, $ic_pos, OP_GT_INT );
					if ($operator == TOK_LE)	gen_code( $parse_param, $ic, $ic_pos, OP_LE_INT );
					if ($operator == TOK_LT)	gen_code( $parse_param, $ic, $ic_pos, OP_LT_INT );
				}
				else
				if ($type1 == "decimal")
				{
					if ($operator == TOK_EQ)	gen_code( $parse_param, $ic, $ic_pos, OP_EQ_DECIMAL );
					if ($operator == TOK_NE)	gen_code( $parse_param, $ic, $ic_pos, OP_NE_DECIMAL );
					if ($operator == TOK_GE)	gen_code( $parse_param, $ic, $ic_pos, OP_GE_DECIMAL );
					if ($operator == TOK_GT)	gen_code( $parse_param, $ic, $ic_pos, OP_GT_DECIMAL );
					if ($operator == TOK_LE)	gen_code( $parse_param, $ic, $ic_pos, OP_LE_DECIMAL );
					if ($operator == TOK_LT)	gen_code( $parse_param, $ic, $ic_pos, OP_LT_DECIMAL );
				}
				else
				if ($type1 == "double")
				{
					if ($operator == TOK_EQ)	gen_code( $parse_param, $ic, $ic_pos, OP_EQ_DOUBLE );
					if ($operator == TOK_NE)	gen_code( $parse_param, $ic, $ic_pos, OP_NE_DOUBLE );
					if ($operator == TOK_GE)	gen_code( $parse_param, $ic, $ic_pos, OP_GE_DOUBLE );
					if ($operator == TOK_GT)	gen_code( $parse_param, $ic, $ic_pos, OP_GT_DOUBLE );
					if ($operator == TOK_LE)	gen_code( $parse_param, $ic, $ic_pos, OP_LE_DOUBLE );
					if ($operator == TOK_LT)	gen_code( $parse_param, $ic, $ic_pos, OP_LT_DOUBLE );
				}
				else
				if ($type1 == "date" || $type1 == "time" || $type1 == "datetime")
				{
					if ($operator == TOK_EQ)	gen_code( $parse_param, $ic, $ic_pos, OP_EQ_DATE_AND_TIME );
					if ($operator == TOK_NE)	gen_code( $parse_param, $ic, $ic_pos, OP_NE_DATE_AND_TIME );
					if ($operator == TOK_GE)	gen_code( $parse_param, $ic, $ic_pos, OP_GE_DATE_AND_TIME );
					if ($operator == TOK_GT)	gen_code( $parse_param, $ic, $ic_pos, OP_GT_DATE_AND_TIME );
					if ($operator == TOK_LE)	gen_code( $parse_param, $ic, $ic_pos, OP_LE_DATE_AND_TIME );
					if ($operator == TOK_LT)	gen_code( $parse_param, $ic, $ic_pos, OP_LT_DATE_AND_TIME );
				}
				else
				if ($type1 == "string")
				{
					if ($operator == TOK_EQ)	gen_code( $parse_param, $ic, $ic_pos, OP_EQ_STRING );
					if ($operator == TOK_NE)	gen_code( $parse_param, $ic, $ic_pos, OP_NE_STRING );
					if ($operator == TOK_GE)	gen_code( $parse_param, $ic, $ic_pos, OP_GE_STRING );
					if ($operator == TOK_GT)	gen_code( $parse_param, $ic, $ic_pos, OP_GT_STRING );
					if ($operator == TOK_LE)	gen_code( $parse_param, $ic, $ic_pos, OP_LE_STRING );
					if ($operator == TOK_LT)	gen_code( $parse_param, $ic, $ic_pos, OP_LT_STRING );
				}
				else
				if ($type1 == "bool")
				{
					if ($operator == TOK_EQ)	gen_code( $parse_param, $ic, $ic_pos, OP_EQ_BOOL );
					if ($operator == TOK_NE)	gen_code( $parse_param, $ic, $ic_pos, OP_NE_BOOL );
				}					
				else
				if ($type1 == "binary")
				{
					if ($operator == TOK_EQ)	gen_code( $parse_param, $ic, $ic_pos, OP_EQ_BINARY );
					if ($operator == TOK_NE)	gen_code( $parse_param, $ic, $ic_pos, OP_NE_BINARY );
				}					
				else
				if (sleft( $type1, 5 ) == 'link ')
				{
					if ($operator == TOK_EQ)	gen_code( $parse_param, $ic, $ic_pos, OP_EQ_LINK );
					if ($operator == TOK_NE)	gen_code( $parse_param, $ic, $ic_pos, OP_NE_LINK );
				}					

				$type = 'bool';
			}
		}

		if ($parse_param->show_parse_trace)
			echo "parse_comp_expr returned<br>";
		
		return ($type); 				
	}
	
	function parse_num_expr( &$parse_param, &$ic, &$ic_pos, &$current_function_number, &$is_function_call )
	{
		$i = 0;
		
		if ($parse_param->show_parse_trace)
			echo "called parse_num_expr<br>";
		
		$type1 = parse_add_expr( $parse_param, $ic, $ic_pos, $current_function_number, $is_function_call );
		
		$type = $type1;
		
		$op = $parse_param->curr_tok;

		if ($op == TOK_ADDR_STRCONCAT)
		{
			generate_type_conversion_if_necessary( $parse_param, $ic, $ic_pos, $type1, "string", 1 );
			
			if (! check_types( $parse_param, $ic, $ic_pos, "string", $type1, true, 0 ))
				semantic_error( 159, $parse_param, "The data type of an & operand must be convertable to string: ".$type1 );
		}
				
		while ($op == TOK_ADDR_STRCONCAT)
		{
			next_token( $parse_param );
	
//			if ($i == 0)
//			{
//				if (! check_types( $parse_param, $ic, $ic_pos, "string", $type1, true, 0 ))
//					semantic_error( 159, $parse_param, "The data type of an & operand must be convertable to string: ".$type1 );
//			}
			
			$type2 = parse_add_expr( $parse_param, $ic, $ic_pos, $current_function_number, $is_function_call );

			generate_type_conversion_if_necessary( $parse_param, $ic, $ic_pos, $type2, "string", 1 );
			
			if (! check_types( $parse_param, $ic, $ic_pos, "string", $type2, true, 0 ))
				semantic_error( 160, $parse_param, "The data type of an & operand must be convertable to string: ".$type2 );

			$type = "string";
			
			gen_code( $parse_param, $ic, $ic_pos, OP_STRCONCAT );
			
			$op = $parse_param->curr_tok;
			
			$i++;
		}
	
		if ($parse_param->show_parse_trace)
			echo "parse_num_expr returned<br>";
		
		return ($type); 				
	}

	
	function parse_add_expr( &$parse_param, &$ic, &$ic_pos, &$current_function_number, &$is_function_call )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_add_expr<br>";
		
		$type1 = parse_mult_expr( $parse_param, $ic, $ic_pos, $current_function_number, $is_function_call );
		
		$type = $type1;
		
		$op = $parse_param->curr_tok;

		$op_text = $parse_param->curr_token_text;
				
		while ($op == TOK_PLUS || $op == TOK_SUBTRACT_MINUS)
		{
			next_token( $parse_param );
	
			$type2 = parse_mult_expr( $parse_param, $ic, $ic_pos, $current_function_number, $is_function_call );

	        if ($op == TOK_PLUS || $op == TOK_SUBTRACT_MINUS)
			{
				if (! (is_numeric_type( $type1 ) && is_numeric_type( $type2 )))
					semantic_error( 78, $parse_param, "Data types to a ".$op_text." operator must be numeric" );
			}
			
			$type = promote_numeric_type( $parse_param, $ic, $ic_pos, $type1, $type2 );
			
			if ($type == "int")
			{
		        if ($op == TOK_PLUS)				gen_code( $parse_param, $ic, $ic_pos, OP_ADD_INT ); else
		        if ($op == TOK_SUBTRACT_MINUS)		gen_code( $parse_param, $ic, $ic_pos, OP_SUBTRACT_INT );
			}
			else
			if ($type == "decimal")
			{
		        if ($op == TOK_PLUS)				gen_code( $parse_param, $ic, $ic_pos, OP_ADD_DECIMAL ); else
		        if ($op == TOK_SUBTRACT_MINUS)		gen_code( $parse_param, $ic, $ic_pos, OP_SUBTRACT_DECIMAL );
			}
			else
			if ($type == "double")
			{
		        if ($op == TOK_PLUS)				gen_code( $parse_param, $ic, $ic_pos, OP_ADD_DOUBLE ); else
		        if ($op == TOK_SUBTRACT_MINUS)		gen_code( $parse_param, $ic, $ic_pos, OP_SUBTRACT_DOUBLE );
			}
				
			$op = $parse_param->curr_tok;
		}
	
	
		if ($parse_param->show_parse_trace)
			echo "parse_add_expr returned<br>";
		
		return ($type); 				
	}


	function parse_mult_expr( &$parse_param, &$ic, &$ic_pos, &$current_function_number, &$is_function_call )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_mult_expr<br>";
		
		$type1 = parse_exp_expr( $parse_param, $ic, $ic_pos, $current_function_number, $is_function_call );
		
		$type = $type1;
		
		$op = $parse_param->curr_tok;

		$op_text = $parse_param->curr_token_text;

		if ($op == TOK_MULT || $op == TOK_DIV || $op == TOK_MOD)
		{
			next_token( $parse_param );
	
			$type2 = parse_mult_expr( $parse_param, $ic, $ic_pos, $current_function_number, $is_function_call );
			
			if (! (is_numeric_type( $type1 ) && is_numeric_type( $type2 )))
				semantic_error( 79, $parse_param, "Data types to a ".$op_text." operator must be numeric" );
			
			$type = promote_numeric_type( $parse_param, $ic, $ic_pos, $type1, $type2 );

			if ($type == "int")
			{			
		        if ($op == TOK_MULT)			gen_code( $parse_param, $ic, $ic_pos, OP_MULT_INT ); else
		        if ($op == TOK_DIV)				
		        {
					if ($parse_param->show_warnings)
						syntax_warning( 0, $parse_param, "Integer division, fractional component truncated" );

		        	gen_code( $parse_param, $ic, $ic_pos, OP_DIV_INT ); 
		        }
		       	else
		        if ($op == TOK_MOD)				gen_code( $parse_param, $ic, $ic_pos, OP_MOD_INT );
			}
			else
			if ($type == "decimal")
			{			
		        if ($op == TOK_MULT)			gen_code( $parse_param, $ic, $ic_pos, OP_MULT_DECIMAL ); else
		        if ($op == TOK_DIV)				gen_code( $parse_param, $ic, $ic_pos, OP_DIV_DECIMAL ); else
		        if ($op == TOK_MOD)				gen_code( $parse_param, $ic, $ic_pos, OP_MOD_DECIMAL );
			}
			else
			if ($type == "double")
			{			
		        if ($op == TOK_MULT)			gen_code( $parse_param, $ic, $ic_pos, OP_MULT_DOUBLE ); else
		        if ($op == TOK_DIV)				gen_code( $parse_param, $ic, $ic_pos, OP_DIV_DOUBLE ); else
		        if ($op == TOK_MOD)				gen_code( $parse_param, $ic, $ic_pos, OP_MOD_DOUBLE );
			}
							
			$op = $parse_param->curr_tok;
		}

/*		
		while ($op == TOK_MULT || $op == TOK_DIV)
		{
			next_token( $parse_param );
	
			$type2 = parse_exp_expr( $parse_param, $ic, $ic_pos, $current_function_number );
			
			if (! (is_numeric_type( $type1 ) && is_numeric_type( $type2 )))
				semantic_error( 79, $parse_param, "Data types must be numeric" );
			
	        if ($op == TOK_MULT)
				gen_code( $parse_param, $ic, $ic_pos, OP_MULT );
			
	        if ($op == TOK_DIV)
				gen_code( $parse_param, $ic, $ic_pos, OP_DIV );
			
			$op = $parse_param->curr_tok;
		
			if (is_numeric_type( $type1 ) && is_numeric_type( $type2 ))
				$type = promote_numeric_type( $type1, $type2 ); 
		}
*/		
		if ($parse_param->show_parse_trace)
			echo "parse_mult_expr returned<br>";
		
		return ($type); 				
	}


	function parse_exp_expr( &$parse_param, &$ic, &$ic_pos, &$current_function_number, &$is_function_call )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_exp_expr<br>";
		
		$type1 = parse_item_expr( $parse_param, $ic, $ic_pos, $current_function_number, $is_function_call );
		
		$type = $type1;
		
		$op = $parse_param->curr_tok;

		$op_text = $parse_param->curr_token_text;
		
		while ($op == TOK_POW)
		{
			next_token( $parse_param );
	
			$type2 = parse_item_expr( $parse_param, $ic, $ic_pos, $current_function_number, $is_function_call );
	
			if (! (is_numeric_type( $type1 ) && is_numeric_type( $type2 )))
				semantic_error( 80, $parse_param, "Data types to a ".$op_text." operator must be numeric" );
			
			$type = promote_numeric_type( $parse_param, $ic, $ic_pos, $type1, $type2 );
			
			if ($type == "int")
			{
	        	if ($op == TOK_POW)				gen_code( $parse_param, $ic, $ic_pos, OP_POW_INT );
			}
			else
			if ($type == "decimal")
			{
	        	if ($op == TOK_POW)				gen_code( $parse_param, $ic, $ic_pos, OP_POW_DECIMAL );
			}
			else
			if ($type == "double")
			{
	        	if ($op == TOK_POW)				gen_code( $parse_param, $ic, $ic_pos, OP_POW_DOUBLE );
			}
					
			$op = $parse_param->curr_tok;
		}
		
		if ($parse_param->show_parse_trace)
			echo "parse_exp_expr returned<br>";
		
		return ($type);
	}


	function parse_item_expr( &$parse_param, &$ic, &$ic_pos, &$current_function_number, &$is_function_call )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_item_expr<br>";

		$push_flags = 0;
		
		$is_num_constant = false;

		$allow_void = false;
		
		$is_function_call = false;
		
		$s2 = "";

		$type = "";
		
		if ($parse_param->curr_tok != TOK_EOF)
		{
			if ($parse_param->curr_tok == TOK_SUBTRACT_MINUS)
			{
				$s2 = '-';
				next_token( $parse_param );
			}
			
						// first item in sequence
							
			if ($parse_param->curr_tok == TOK_LPARENTHESIS)
			{
				next_token( $parse_param );
	
				$type = parse_expr( $parse_param, $ic, $ic_pos, $current_function_number, $is_function_call );

				next_token( $parse_param );
			}

			else
			if ($parse_param->curr_tok == TOK_NAME || $parse_param->curr_tok == TOK_INC || $parse_param->curr_tok == TOK_DEC)
			{
				$push_flags = 0;
				
				if ($parse_param->curr_tok == TOK_INC)
				{
					$push_flags = PUSH_FLAGS_PRE_INC;
					next_token( $parse_param );
				}						
				else
				if ($parse_param->curr_tok == TOK_DEC)
				{
					$push_flags = PUSH_FLAGS_PRE_DEC;
					next_token( $parse_param );
				}			
				
				$name = $parse_param->curr_token_text;
				
				$varname = $parse_param->curr_token_text;
				 
				if (isset( $parse_param->constants[$varname]['value'] ))
				{
					$type = $parse_param->constants[$varname]['type'];
					
						// OP_PUSH_CONST
						
					gen_code( $parse_param, $ic, $ic_pos, get_const_push_op( $parse_param->constants[$varname]['type'] ), $parse_param->constants[$varname]['value'], $parse_param->constants[$varname]['type'] );
				
					next_token( $parse_param );			
				}
				else
				{
					$array_name = $name;

					next_token( $parse_param );

					if ($parse_param->curr_tok == TOK_LPARENTHESIS)
					{
						$is_function_call = true;
						
						$type = parse_function_call( $parse_param, $ic, $ic_pos, $current_function_number, $name );
					}
					else
//					if ($parse_param->curr_tok == TOK_LBRACKET || $parse_param->curr_tok == TOK_DOT)
					{
						check_var_declaration( $parse_param, $current_function_number, $type, $array_name, $number_of_indexes, $is_global );

						$array_type = $type;

						$type = parse_aggregate_expression( $parse_param, $ic, $ic_pos, $num_dimensions, $allow_void, $type, $current_function_number, $array_name );

						if ($parse_param->curr_tok == TOK_INC)
						{
							$push_flags = PUSH_FLAGS_POST_INC;
							next_token( $parse_param );
						}						
						else
						if ($parse_param->curr_tok == TOK_DEC)
						{
							$push_flags = PUSH_FLAGS_POST_DEC;
							next_token( $parse_param );
						}			

						check_var_declaration( $parse_param, $current_function_number, $type1, $name, $number_of_indexes, $is_global );
						
						if ($push_flags == PUSH_FLAGS_POST_INC)
						{
							if (! is_numeric_type( $type ))
								semantic_error( 151, $parse_param, "Data type of a variable that has ++ applied to it must be numeric." );
						}						
						else
						if ($push_flags == PUSH_FLAGS_POST_DEC)
						{
							if (! is_numeric_type( $type ))
								semantic_error( 152, $parse_param, "Data type of a variable that has -- applied to it must be numeric." );
						}			

						gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, $push_flags, "int" );

						$size = get_type_total_size( $parse_param, $type );
					
						if ($parse_param->show_warnings && $size >= 200)
							syntax_warning( 9, $parse_param, "Large copy of ".$size." bytes, will slow program performance. If passing a parameter to a function consider passing by reference using '&' to improve performance" );

					
						gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_VAR, $name, $type );
					}
				}
			}
			else
			if ($parse_param->curr_tok == TOK_NUMBER)
			{
				$is_num_constant = true;
				
				if (strpos( $parse_param->curr_token_text, "." ) == false)
					$type = "int";
				else
				if (strpos( $parse_param->curr_token_text, "e" ) == false && strpos( $parse_param->curr_token_text, "E" ) == false)
					$type = "decimal";
				else
					$type = "double";
				
					// OP_PUSH_CONST
					
				if ($s2 == "-")
					gen_code( $parse_param, $ic, $ic_pos, get_const_push_op( $type ), "-".$parse_param->curr_token_text, $type );
				else
					gen_code( $parse_param, $ic, $ic_pos, get_const_push_op( $type ), $parse_param->curr_token_text, $type );
									
				next_token( $parse_param );			
			}
			else
			if ($parse_param->curr_tok == TOK_STRING_CONSTANT ||
				$parse_param->curr_tok == TOK_DATE_CONSTANT ||
				$parse_param->curr_tok == TOK_TIME_CONSTANT ||
				$parse_param->curr_tok == TOK_DATETIME_CONSTANT ||
				$parse_param->curr_tok == TOK_BOOLEAN_CONSTANT)
			{
				$text = $parse_param->curr_token_text;
				
				if ($parse_param->curr_tok == TOK_STRING_CONSTANT) 		$type = "string"; 
				if ($parse_param->curr_tok == TOK_DATE_CONSTANT) 		$type = "date";
				if ($parse_param->curr_tok == TOK_TIME_CONSTANT) 		$type = "time";
				if ($parse_param->curr_tok == TOK_DATETIME_CONSTANT) 	$type = "datetime";
				if ($parse_param->curr_tok == TOK_BOOLEAN_CONSTANT) 	$type = "bool";

				if ($parse_param->curr_tok == TOK_BOOLEAN_CONSTANT)
				{
					if ($parse_param->curr_token_text == "true" || $parse_param->curr_token_text == "TRUE")
						$text = "1";
					else
						$text = "0";
				}
					
				if ($parse_param->curr_tok == TOK_BOOLEAN_CONSTANT)
					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, $text, "int" );
				else
					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_STRING, $text, "string" );
				
				next_token( $parse_param );			
			}
			else
			{
				syntax_error( 90, $parse_param, "Expected '(', a variable name or a number" );
				
				next_token( $parse_param );			
			}
								
			if ($s2 == '-' && (! $is_num_constant))
			{
				if ($type == "int")
				{
					gen_code( $parse_param, $ic, $ic_pos, OP_NEGATE_INT );
				}
				else
				if ($type == "decimal")
				{
					gen_code( $parse_param, $ic, $ic_pos, OP_NEGATE_DECIMAL );
				}
				else
				if ($type == "double")
				{
					gen_code( $parse_param, $ic, $ic_pos, OP_NEGATE_DOUBLE );
				}
				else
					semantic_error( 215, $parse_param, "Expected a numeric type as the operand to a '-'" );
			}
		}
				
		if ($parse_param->show_parse_trace)
			echo "parse_item_expr returned<br>";
		
		return ($type); 				
	}

				
	function parse_function_call( &$parse_param, &$ic, &$ic_pos, $current_function_number, &$function_name )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_function_call<br>";
		
		next_token( $parse_param );
		
		$argument_count = 0;

		$text = "";
		
		while ($parse_param->curr_tok != TOK_RPARENTHESIS && $parse_param->curr_tok != TOK_EOF)
		{
			if ($parse_param->curr_tok == TOK_ADDR_STRCONCAT)
			{
				next_token( $parse_param );
			
				$name = $parse_param->curr_token_text;
			
				check_for_expected_token( $parse_param, TOK_NAME, 91, "Expected a name after &" );

				check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes, $is_global );

//				if ($parse_param->lookahead_tok == TOK_LBRACKET || $parse_param->lookahead_tok == TOK_DOT)
					next_token( $parse_param );

				$type2 = parse_aggregate_expression( $parse_param, $ic, $ic_pos, $num_dimensions, false, $type, $current_function_number, $name );

				if ($parse_param->c_output)
					gen_code( $parse_param, $ic, $ic_pos, OP_SET_INDIRECTION_FLAG, 0 );

				$type3 = explode( " ", $type2 );

				$argument_type = check_function_parameter_type( $parse_param, $ic, $ic_pos, $type2, $function_name, $argument_count, false, true, $is_variable_size );

				$lst_index_size = 0;
				
				$size = get_type_total_size( $parse_param, $argument_type );

				if ($parse_param->c_output && sleft( $argument_type, 6 ) == 'array ')
				{
//					if ($type3[count($type3) - 1] == "variable")
//						gen_code( $parse_param, $ic, $ic_pos, OP_INC_SP, SIZEOF_VAR, "int" );
//					else

					$lst_index_size = $type3[count($type3) - 1];

					if ($type3[count($type3) - 1] != "variable")
					{
						if ($size > SIZEOF_VAR)
							gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, $lst_index_size, "int" );
					
						if ($size > 2 * SIZEOF_VAR)
							gen_code( $parse_param, $ic, $ic_pos, OP_INC_SP, $size - 2 * SIZEOF_VAR, "int" );
					}
				}

				if (! $parse_param->c_output)
					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, $size, "int" );


				if ($type3[count($type3) - 1] == "variable")
				{
					if ($parse_param->c_output)
						gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_REL_ADDR_BASE, get_variable_offset( $parse_param, $current_function_number, $name ) + SIZEOF_VAR );
					else
						gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_REL_ADDR_BASE, get_variable_offset( $parse_param, $current_function_number, $name ) + 1 );

					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, 0, "int" );
		
					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_VAR, $name, $type2 );
				}
				else
				{
					$lst_index_size = $type3[count($type3) - 1];

					if (! $parse_param->c_output)
						gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, $lst_index_size, "int" );
				}
				
				if (! $parse_param->c_output)
					gen_code( $parse_param, $ic, $ic_pos, OP_SET_INDIRECTION_FLAG, 0 );
				
				if ($parse_param->curr_tok != TOK_COMMA && $parse_param->curr_tok != TOK_RPARENTHESIS)
					syntax_error( 92, $parse_param, "Expected a ',' or ')'" );

				if ($parse_param->curr_tok == TOK_COMMA)
					next_token( $parse_param );
			}
			else 
			{
				$type = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number, $is_function_call );

				check_function_parameter_type( $parse_param, $ic, $ic_pos, $type, $function_name, $argument_count, true, false, $is_variable_size );

				if ($is_variable_size)
					semantic_error( 192, $parse_param, "A variable length array must be passed by reference. Use '&'" );
									
				if ($parse_param->curr_tok != TOK_COMMA && $parse_param->curr_tok != TOK_RPARENTHESIS)
					syntax_error( 93, $parse_param, "Expected a , or ) after function arguments" );
				
				if ($parse_param->curr_tok == TOK_COMMA)
					next_token( $parse_param );
			}
			
			$argument_count++;
		}


		for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
		{
			if ($parse_param->vars['function_name'][$j] == $function_name)
			{
				if ($parse_param->vars['number_of_function_arguments'][$j] != $argument_count)
					semantic_error( 170, $parse_param, "Mismatch in function '".$function_name."' argument count: declaration has ".$parse_param->vars['number_of_function_arguments'][$j]." parameters but function call has ".$argument_count." parameters" );
			}
		} 
		
		$ic[$ic_pos]['argument_count'] = $argument_count;
		
		if (is_system_function( $parse_param, $function_name ))
		{
			gen_code( $parse_param, $ic, $ic_pos, OP_CALL_SYSTEM_FUNCTION, $function_name );

			for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
			{
				if ($parse_param->vars['function_name'][$j] == $function_name)
				{
					$ic[$ic_pos-1]['return_variable_size'] = $parse_param->vars['return_variable_size'][$j];
				}
			}
		}
		else
		{
//			$function_number = check_or_add_new_function( $function_name, $already_defined );
		
			if (! function_has_been_defined( $parse_param, $function_name ))
				semantic_error( 94, $parse_param, "Function ".$function_name." must be declared or defined before being called." );
			
			gen_code( $parse_param, $ic, $ic_pos, OP_CALL_USER_FUNCTION, $function_name );
		}	

		$type = check_function_usage( $parse_param, $function_name, $argument_count );
		
		next_token( $parse_param );

		if ($parse_param->show_parse_trace)
			echo "parse_function_call returned<br>";
		
		return ($type);
	}


			//---------------------------------------------------------------------------------------------------------------------
			// Check that a function is being called with the correct data types for each parameter
			//---------------------------------------------------------------------------------------------------------------------
			
	function check_function_parameter_type( &$parse_param, &$ic, &$ic_pos, &$type, $function_name, $argument_count, $add_conversion, $is_reference_call, &$is_variable_size )
	{
		$current_function_number = -1;
		
		$argument_type = "";
		
		for ($i=0; $i < $parse_param->vars['number_of_user_functions']; $i++)
		{
			if ($parse_param->vars['function_name'][$i] == $function_name)
			{
				$found = true;
				
				$current_function_number = $i;
			}
		}
		
		if ($current_function_number == -1)
			semantic_error( 95, $parse_param, "Function ".$function_name." not found" );
		else
		{
			if (isset( $parse_param->vars['function_arguments'][$current_function_number][$argument_count]['type'] ))
			{
				$argument_type = $parse_param->vars['function_arguments'][$current_function_number][$argument_count]['type'];

				$is_variable_size = $parse_param->vars['function_arguments'][$current_function_number][$argument_count]['is_variable_size'];
				
				if (! ($is_reference_call && type_matches_array_reference_function_call( $type, $argument_type )))
				{
					if (! check_types( $parse_param, $ic, $ic_pos, $argument_type, $type, $add_conversion, 0, $is_variable_size ))
						semantic_error( 96, $parse_param, "Type error in function ".$function_name." function call argument number ".($argument_count+1).", expected '".$argument_type."' but variable is of type '".$type."'" );
				}
				
				$ok = false;

				if ($argument_type == $type)
					$ok = true;
				else
				{
//					if ($add_conversion && is_numeric_type( $argument_type ) && is_numeric_type( $type ))
					
					if ($add_conversion)
						generate_type_conversion_if_necessary( $parse_param, $ic, $ic_pos, $type, $argument_type, 1 );
						
					$ok = true;
						
//					else
//					if ($add_conversion && $argument_type == "string")
//					{
//						$ok = true;
//						
//						generate_type_conversion( $parse_param, $ic, $ic_pos, $type, "string", "0" );					
//					}
				} 
//				if ($parse_param->vars['function_arguments'][$current_function_number][$argument_count]['type'] != $type &&
//					(! (is_numeric_type( $parse_param->vars['function_arguments'][$current_function_number][$argument_count]['type'] ) && is_numeric_type( $type ))))
			}
			else
				semantic_error( 96, $parse_param, "Error in function ".$function_name." function call argument number ".($argument_count+1)." is not defined" );
		}
		
		return ($argument_type);
	}
	
	
	
		//---------------------------------------------------------------------------------------------------------------------
		// Check that a conversion is available between a data type supplied and a data type required and generate a conversion if necessary
		//---------------------------------------------------------------------------------------------------------------------
		
	function check_types( &$parse_param, &$ic, &$ic_pos, $type_required, $type_supplied, $add_conversion, $level )
	{
		$ok = false;

		if (sleft( $type_required, 6 ) == "array " && sleft( $type_supplied, 6 ) == "array ")
		{
			$s2 = explode( " ", $type_required );	
			$s3 = explode( " ", $type_supplied );
			
			if (count( $s2 ) != count( $s3 ))	
				$ok = false;
			else
			{
				$ok = true;
				
				for ($i=0; $i < count( $s2 )-1; $i++)
				{
					if ($s2[$i] != $s3[$i])
						$ok = false;
				}
				
				if (! ($s2[count($s2)-1] == $s3[count($s2)-1] || $s2[count($s2)-1] == "variable"))
					$ok = false;
			}
		}  
		
		if ($type_required == $type_supplied)
			$ok = true;
		else
		if ($type_required == "string" ||
			($type_required == "binary" && $type_supplied == "string") ||  
			($type_required == "link general" && sleft( $type_supplied, 5 ) == 'link ') ||  
			(is_numeric_type( $type_required ) && is_numeric_type( $type_supplied )))
		{
			$ok = true;
			
			if ($add_conversion)
	//		if ($add_conversion && $type_required == "string")
			{
				$ok = true;
				
//				generate_type_conversion_if_necessary( $parse_param, $ic, $ic_pos, $type_supplied, $type_required, $level );					
			} 
		}
		
		return ($ok);
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Generate type conversions
		//---------------------------------------------------------------------------------------------------------------------
	
	function generate_type_conversion_if_necessary( &$parse_param, &$ic, &$ic_pos, $type_from, $type_to, $level )
	{
		$op = "";
		
		if ($type_from != $type_to)
		{
			if (! (($type_from == 'link general' && sleft( $type_to, 5 ) == 'link ') ||
				  (sleft( $type_from, 5 ) == 'link ' && $type_to == 'link general')))
			{
				if ($type_to == "binary" && $type_from == "string")
					$op = OP_CONV_STRING_TO_BINARY;
				else
				if ($type_to == "string")
				{
					if ($type_from == "int")				$op = OP_CONV_INT_TO_STRING; else
					if ($type_from == "double")				$op = OP_CONV_DOUBLE_TO_STRING; else
					if ($type_from == "decimal")			$op = OP_CONV_DECIMAL_TO_STRING; else
					if ($type_from == "bool")				$op = OP_CONV_BOOL_TO_STRING; else
					if (sleft( $type_from, 5 ) == "link ")	$op = OP_CONV_LINK_TO_STRING; else
					if ($type_from == "date")				$op = OP_CONV_DATE_TO_STRING; else
					if ($type_from == "time")				$op = OP_CONV_TIME_TO_STRING; else
					if ($type_from == "datetime")			$op = OP_CONV_DATETIME_TO_STRING; else
					if ($type_from == "binary")				$op = OP_CONV_BINARY_TO_STRING;
		 			else
						semantic_error( 214, $parse_param, "type not recognised: ".$type_from );
				}
				else
				if ($type_to == "int")
				{
					if ($type_from == "double")
					{
						$op = OP_CONV_DOUBLE_TO_INT; 
						
						if ($parse_param->show_warnings)
							syntax_warning( 6, $parse_param, "Conversion of a double to an int, fractional part truncated" );
					}					
					else
					if ($type_from == "decimal")
					{
						$op = OP_CONV_DECIMAL_TO_INT;
						
						if ($parse_param->show_warnings)
							syntax_warning( 5, $parse_param, "Conversion of a decimal to an int, fractional part truncated" );
					}
					else			
						semantic_error( 210, $parse_param, "No type conversion from ".$type_from." to ".$type_to." available, use a type conversion function." );
				}
				else
				if ($type_to == "decimal")
				{
					if ($type_from == "int")				$op = OP_CONV_INT_TO_DECIMAL; else
					if ($type_from == "double")				$op = OP_CONV_DOUBLE_TO_DECIMAL;
					else			
						semantic_error( 214, $parse_param, "No type conversion from ".$type_from." to ".$type_to." available, use a type conversion function." );
				}
				else
				if ($type_to == "double")
				{
					if ($type_from == "int")				$op = OP_CONV_INT_TO_DOUBLE; else
					if ($type_from == "decimal")			$op = OP_CONV_DECIMAL_TO_DOUBLE;
					else			
						semantic_error( 214, $parse_param, "No type conversion from ".$type_from." to ".$type_to." available, use a type conversion function." );
				}
				else
					semantic_error( 214, $parse_param, "No type conversion from ".$type_from." to ".$type_to." available, use a type conversion function." );
			
				if ($op != "")
				{
					if ($parse_param->c_output)
						gen_code( $parse_param, $ic, $ic_pos, $op, $level * SIZEOF_VAR );
					else
						gen_code( $parse_param, $ic, $ic_pos, $op, $level );
				}
			}
		}
	}	
	
			//---------------------------------------------------------------------------------------------------------------------
			// Retrieve information about a variable
			//---------------------------------------------------------------------------------------------------------------------

	function check_var_declaration( &$parse_param, $current_function_number, &$type, $name, &$number_of_indexes, &$is_global )
	{
		$found = false;
		
		$is_global = false;
		
		$number_of_indexes = 0;

		if ($parse_param->in_function)
		{
			for ($j=0; $j < $parse_param->vars['number_of_function_arguments'][$current_function_number]; $j++)
			{
				if ($parse_param->vars['function_arguments'][$current_function_number][$j]['name'] == $name)
				{
					$found = true;
					$type = $parse_param->vars['function_arguments'][$current_function_number][$j]['type'];
					
					if (sleft( $type, 6 ) == "array ")
						$number_of_indexes = $parse_param->vars['function_arguments'][$current_function_number][$j]['number_of_indexes'];
				}
			}
		
			for ($j=0; $j < $parse_param->vars['number_of_local_variables'][$current_function_number]; $j++)
			{
				if ($parse_param->vars['local_variables'][$current_function_number][$j]['name'] == $name)
				{
					$found = true;
					$type = $parse_param->vars['local_variables'][$current_function_number][$j]['type'];
					
					if (sleft( $type, 6 ) == "array ")
						$number_of_indexes = $parse_param->vars['local_variables'][$current_function_number][$j]['number_of_indexes'];
				}
			}
		}
		
		if (! $found)
		{
			for ($j=0; $j < $parse_param->vars['number_of_global_variables']; $j++)
			{
				if ($parse_param->vars['global_variables'][$j]['name'] == $name)
				{
					$found = true;
					
					$is_global = true;
					 
					$type = $parse_param->vars['global_variables'][$j]['type'];
					
					if (sleft( $type, 6 ) == "array ")
						$number_of_indexes = $parse_param->vars['global_variables'][$j]['number_of_indexes'];
				}
			}
		}
		
		if (! $found)
		{
			$parse_param->error_occured = true;
			semantic_error( 97, $parse_param, "Variable or function '".$name."' has not been declared" );
		}
	}
	

		//---------------------------------------------------------------------------------------------------------------------
		// Generate a table of initial values for variables
		//---------------------------------------------------------------------------------------------------------------------
			
	function gen_init_all( &$parse_param )
	{
		$global_init_num_items = 0;
		
		for ($i=0; $i < $parse_param->vars['number_of_global_variables']; $i++)
			gen_init( $parse_param, $parse_param->vars['global_variables'][$i]['type'], $global_init, $global_init_num_items );
		
		if ($global_init_num_items > 0)
			$parse_param->vars['global_variables']['init'] = $global_init;

		$parse_param->vars['global_variables']['init_num_items'] = $global_init_num_items;
	
		for ($i=0; $i < $parse_param->vars['number_of_user_functions']; $i++)
		{
			$loc_init_num_items = 0;
		
			if (isset( $loc_init ))
				unset( $loc_init );
				
			if (! $parse_param->vars['builtin_function'][$i])
			{
				for ($j=0; $j < $parse_param->vars['number_of_local_variables'][$i]; $j++)
					gen_init( $parse_param, $parse_param->vars['local_variables'][$i][$j]['type'], $loc_init, $loc_init_num_items );
		
				$parse_param->vars['local_variables'][$i]['init'] = $loc_init;
				$parse_param->vars['local_variables'][$i]['init_num_items'] = $loc_init_num_items;
				
				if ($parse_param->c_output)
					$loc_size = $loc_init_num_items * SIZEOF_VAR;
				else
					$loc_size = $loc_init_num_items;
				
				if ($loc_size != $parse_param->vars['local_variables_stackframe_size'][$i])
				{
					echo $parse_param->vars['number_of_local_variables'][$i].": ";
					echo $parse_param->vars['local_variables'][$i][0]['type'].": ";
					echo $parse_param->vars['local_variables'][$i][1]['type'].": ";

					echo "Internal error ".$parse_param->vars['function_name'][$i].", stackframe size: ".$parse_param->vars['local_variables_stackframe_size'][$i].", init variables: ".$loc_init_num_items."<br>";
				}
			}			
		}
	}
	
	
	
	function gen_init( &$parse_param, $type, &$init, &$num_init_items )
	{
		if ($type != 'void')
		{
			if (sleft( $type, 6 ) == 'array ')
			{
				$s2 = explode( " ", $type );
				
				$i = 3;
				
				if ($s2[1] == 'link')
					$i++;
				
				$num_elements = array_type_number_of_elements( $type );

// xx
//				$init[$num_init_items]['type'] = "int"; 		
//				$init[$num_init_items++]['value'] = $num_elements; 
					
				for ($i=0; $i < $num_elements; $i++)
				{
					if ($s2[1] == 'link')
						gen_init( $parse_param, 'link '.$s2[2], $init, $num_init_items );
					else 
						gen_init( $parse_param, $s2[1], $init, $num_init_items );
				}	
				
// xx
// --size;
									
			}
			else 
			if ($type == "int")					{ $init[$num_init_items]['type'] = "int"; 		$init[$num_init_items++]['value']  = (int) 0;					}		else
			if ($type == "double")				{ $init[$num_init_items]['type'] = "double"; 	$init[$num_init_items++]['value']  = (double) 0;					}		else
			if ($type == "string")				{ $init[$num_init_items]['type'] = "string"; 	$init[$num_init_items++]['value']  = (string) "";				}		else
			if (sleft( $type, 5 ) == "link " )	{ $init[$num_init_items]['type'] = "link"; 		$init[$num_init_items++]['value']  = (int) 0;					}		else
			if ($type == "bool")				{ $init[$num_init_items]['type'] = "bool"; 		$init[$num_init_items++]['value']  = (int) 1;					}		else
			if ($type == "binary")				{ $init[$num_init_items]['type'] = "binary"; 	$init[$num_init_items++]['value']  = (string) "";				}		else
			if ($type == "decimal")				{ $init[$num_init_items]['type'] = "decimal"; 	$init[$num_init_items++]['value']  = (string) "0";				}		else
			if ($type == "date")				{ $init[$num_init_items]['type'] = "date"; 		$init[$num_init_items++]['value']  = (string) "0000-00-00";		}		else
			if ($type == "time")				{ $init[$num_init_items]['type'] = "time"; 		$init[$num_init_items++]['value']  = (string) "99:99";			}		else
			if ($type == "datetime")			{ $init[$num_init_items]['type'] = "datetime"; 	$init[$num_init_items++]['value']  = (string) "0000-00-000 99:99";	}	else
			{
				$found = false;
				
				for ($i=0; $i < $parse_param->num_user_defined_types; $i++)
				{			
					if ($parse_param->user_defined_types[$i]['type_name'] == $type) 
					{
						$found = true;
						
						if ($parse_param->user_defined_types[$i]['num_items'] == 0)
							gen_init( $parse_param, $parse_param->user_defined_types[$i]['item_type'][0], $init, $num_init_items );
						else 
						{
							for ($j=0; $j < $parse_param->user_defined_types[$i]['num_items']; $j++)
								gen_init( $parse_param, $parse_param->user_defined_types[$i]['item_type'][$j], $init, $num_init_items );
						}
					}
				}
				
				if (! $found)
					echo "Internal error gen_init(), type ".$type." not found.";
			}
		}		
	}	


		//---------------------------------------------------------------------------------------------------------------------
		// Returns the number of elements in an array. Not applicable to arrays with a 'variable' dimension.
		//---------------------------------------------------------------------------------------------------------------------
		
	function array_type_number_of_elements( $type )
	{
		$s2 = explode( " ", $type );
		
		$i = 3;
		
		if ($s2[1] == 'link')
			$i++;
		
		$num_elements = 1;
		
		for (; $i < count( $s2 ); $i += 2)
			$num_elements *= (int) $s2[$i];
		
		return ($num_elements);
	}
		
					
		//---------------------------------------------------------------------------------------------------------------------
		// Returns true if variable 'name' is a global variable
		//---------------------------------------------------------------------------------------------------------------------
	
	function is_global_variable( &$parse_param, $current_function_number, $name )
	{
		$found = false;
		
		$loc_version = false;
		
		if ($parse_param->in_function)
		{
			for ($j=0; $j < $parse_param->vars['number_of_function_arguments'][$current_function_number]; $j++)
			{
				if ($parse_param->vars['function_arguments'][$current_function_number][$j]['name'] == $name)
				{
					$loc_version = true;
				}
			}
		
			for ($j=0; $j < $parse_param->vars['number_of_local_variables'][$current_function_number]; $j++)
			{
				if ($parse_param->vars['local_variables'][$current_function_number][$j]['name'] == $name)
				{
					$loc_version = true;
				}
			}
		}

		if (! $loc_version)
		{
			for ($j=0; $j < $parse_param->vars['number_of_global_variables']; $j++)
			{
				if ($parse_param->vars['global_variables'][$j]['name'] == $name)
				{
					$found = true;
				}					
			}
		}

		return ($found);
	}



			//---------------------------------------------------------------------------------------------------------------------
			// Check that functions that are called have been defined and are being called with the correct number of arguments
			//---------------------------------------------------------------------------------------------------------------------
	
	function check_function_usage( &$parse_param, &$function_name, $number_of_arguments )
	{
		$found = false;

		$return_type = "";

		for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
		{
			if ($parse_param->vars['function_name'][$j] == $function_name)
			{
				$found = true;

				$return_type = $parse_param->vars['function_return_type'][$j];
				
				if (($parse_param->vars['function_has_been_defined'][$j] || $parse_param->vars['builtin_function'][$j]) && 
						$parse_param->vars['number_of_function_arguments'][$j] != $number_of_arguments)

					semantic_error( 98, $parse_param, "Incorrect function usage, ".$function_name.", ".$parse_param->vars['number_of_function_arguments'][$j]." arguments expected but ".$number_of_arguments." supplied" );
			}
		}

		return ($return_type);
	
//		if (! $found)
//			semantic_error( $parse_param, "Function ".$function_name." has not been declared" );
	}


			//---------------------------------------------------------------------------------------------------------------------
			// Processing of the icode after parsing has finished 
			//---------------------------------------------------------------------------------------------------------------------
	
	function post_parse_processing( &$parse_param, &$ic, &$ic_pos )
	{
		if (! $parse_param->c_output)
		{
			for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
			{
				if ((! is_system_function( $parse_param, $parse_param->vars['function_name'][$j] )) && 
	  				($parse_param->vars['has_been_called'][$j]) &&
	  				(! $parse_param->vars['function_has_been_defined'][$j]))
					semantic_error( 99, $parse_param, "Function ".$parse_param->vars['function_name'][$j]." has been called but has not been defined" );			
			}
		}			
			
		if (! $parse_param->error_occured)
		{
			assign_label_addresses( $ic, $ic_pos );

			set_call_addresses( $parse_param, $ic, $ic_pos );
			
			calc_stackframe_sizes( $parse_param );
		}
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Convert label numbers to addresses
		//---------------------------------------------------------------------------------------------------------------------

	function assign_label_addresses( &$ic, &$ic_pos )
	{
		for ($j=0; $j < $ic_pos; $j++)
		{
			if ($ic[$j]['op'] == OP_JMP || 
				$ic[$j]['op'] == OP_JMP_FALSE ||
				$ic[$j]['op'] == OP_JMP_TRUE ||
				$ic[$j]['op'] == OP_JMP_FALSE_DONT_POP ||
				$ic[$j]['op'] == OP_JMP_TRUE_DONT_POP ||
				$ic[$j]['op'] == OP_POP_JMP_GE ||
				$ic[$j]['op'] == OP_POP_JMP_LE ||
				$ic[$j]['op'] == OP_POP_JMP_LT ||
				$ic[$j]['op'] == OP_POP_JMP_GT)
			{
				$label = $ic[$j]['value'];
				
				$found = false;
				
				for ($k=0; $k < $ic_pos && (!$found); $k++)
				{
					if ($ic[$k]['op'] == OP_LABEL && $ic[$k]['value'] == $label)
					{
						$found = true;
					
						$ic[$j]['value'] = $k;
					}
				}
				
				if (! $found)
				{
					echo "Label ".$label." not found";
					exit();
				}
			}
		}
	}	
	
	

		//---------------------------------------------------------------------------------------------------------------------
		// Calculate the sizes of the local variable and function parameter stackframes
		//---------------------------------------------------------------------------------------------------------------------
		
	function calc_stackframe_sizes( &$parse_param )
	{	
		for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
		{
			$size = 0;
			
			for ($k=0; $k < $parse_param->vars['number_of_local_variables'][$j]; $k++)
				$size += $parse_param->vars['local_variables'][$j][$k]['size'];
			
			$parse_param->vars['local_variables_stackframe_size'][$j] = $size;


			$size = 0;
			
			for ($k=$parse_param->vars['number_of_function_arguments'][$j]-1; $k >= 0; $k--)
				$size += $parse_param->vars['function_arguments'][$j][$k]['size'];
			
			$parse_param->vars['function_arguments_stackframe_size'][$j] = $size;
		}
	}
	
		//---------------------------------------------------------------------------------------------------------------------
		// Calculate the offsets of function parameters. Called immediately after the x(...) list so that the offsets are
		// available within the function code
		//---------------------------------------------------------------------------------------------------------------------
		
	function calc_function_parameter_offsets( &$parse_param, $current_function_number )
	{	
		$offset = 0; 

		$size = 0;
		
		for ($k=$parse_param->vars['number_of_function_arguments'][$current_function_number]-1; $k >= 0; $k--)
		{
			$offset -= $parse_param->vars['function_arguments'][$current_function_number][$k]['size'];

// xx
// if array, + 1
			
			$parse_param->vars['function_arguments'][$current_function_number][$k]['offset'] = $offset;
			
			$size += $parse_param->vars['function_arguments'][$current_function_number][$k]['size'];
		}
		
		$parse_param->vars['function_arguments_stackframe_size'][$current_function_number] = $size;
	}
	


		//---------------------------------------------------------------------------------------------------------------------
		// Translate function name calls to addresses 
		//---------------------------------------------------------------------------------------------------------------------
		
	function set_call_addresses( &$parse_param, &$ic, &$ic_pos )
	{
		for ($i=0; $i < $parse_param->vars['number_of_user_functions']; $i++)
		{
			for ($j=0; $j < $ic_pos; $j++)
			{
				if (($ic[$j]['op'] == OP_CALL_USER_FUNCTION || $ic[$j]['op'] == OP_CALL_SYSTEM_FUNCTION) 
				
							&& $ic[$j]['value'] == $parse_param->vars['function_name'][$i])
				
					$ic[$j]['function_number'] = $i;
					

				if ($ic[$j]['op'] == OP_START_FUNCTION) 
					$ic[$j]['function_number'] = $ic[$j]['value'];

				if ($ic[$j]['op'] == OP_RETURN) 
					$ic[$j]['function_number'] = $ic[$j]['value'];
				
				if ($ic[$j]['op'] == OP_CALL_USER_FUNCTION && $ic[$j]['value'] == $parse_param->vars['function_name'][$i])
					$ic[$j]['value'] = $i;
			}
		}

		for ($j=0; $j < $ic_pos; $j++)
		{
			if ($ic[$j]['op'] == OP_CALL_USER_FUNCTION ||
				$ic[$j]['op'] == OP_CALL_SYSTEM_FUNCTION ||
				$ic[$j]['op'] == OP_START_FUNCTION ||
				$ic[$j]['op'] == OP_RETURN)
			{
				$ic[$j]['function_name'] = $parse_param->vars['function_name'][$ic[$j]['function_number']];
			} 
		}
		
		if (! $parse_param->c_output)
		{
			for ($j=0; $j < $ic_pos; $j++)
			{
				if ($ic[$j]['op'] == OP_CALL_USER_FUNCTION)
				{
					$function_number = $ic[$j]['value'];
					
					$found = false;
					
					for ($k=0; $k < $ic_pos && (!$found); $k++)
					{
						if ($ic[$k]['op'] == OP_START_FUNCTION && $ic[$k]['value'] == $function_number)
						{
							$found = true;
						
							$ic[$j]['call_address'] = $k;
						}
					}
					
					if (! $found)
						semantic_error( 146, $parse_param, "User function ".$ic[$j]['text']." not found"  );
				}
			}
		}
	}
	
				
		//---------------------------------------------------------------------------------------------------------------------
		// Check whether a function has been defined and if not add it to the list
		//---------------------------------------------------------------------------------------------------------------------
						
	function check_or_add_new_function( &$parse_param, &$function_name, $return_type, &$already_defined, $number_of_dimensions )
	{
		$found = false;
		
		for ($i=0; $i < $parse_param->vars['number_of_user_functions']; $i++)
		{
			if ($parse_param->vars['function_name'][$i] == $function_name)
			{
				$found = true;
				
				$current_function_number = $i;
			}
		}
		
		if (! $found)
		{
			$current_function_number = $parse_param->vars['number_of_user_functions'];

			$parse_param->vars['number_of_user_functions']++;

			$parse_param->vars['function_name'][$current_function_number] = $function_name;
			
			$parse_param->vars['function_return_type'][$current_function_number] = $return_type;
 
			$parse_param->vars['builtin_function'][$current_function_number] = false;

			$parse_param->vars['number_of_function_arguments'][$current_function_number] = 0;

			$size = get_type_total_size( $parse_param, $return_type );
			
			$parse_param->vars['local_variables'][$current_function_number][0]['name'] = 'result';
			$parse_param->vars['local_variables'][$current_function_number][0]['type'] = $return_type;
			
			if ($parse_param->c_output)
				$parse_param->vars['local_variables'][$current_function_number][0]['offset'] = SIZEOF_VAR;
			else
				$parse_param->vars['local_variables'][$current_function_number][0]['offset'] = 1;
			
			$parse_param->vars['local_variables'][$current_function_number][0]['size'] = $size;
			$parse_param->vars['local_variables'][$current_function_number][0]['number_of_indexes'] = $number_of_dimensions;
			
			$parse_param->vars['return_variable_size'][$current_function_number] = $size; 
			
			 
		 	$parse_param->vars['function_has_been_defined'][$current_function_number] = false;
			 
		 	$parse_param->vars['has_been_called'][$current_function_number] = false;
			
			$parse_param->vars['number_of_declarations'][$current_function_number] = 0;
			
			$parse_param->vars['number_of_definitions'][$current_function_number] = 0;
			 
			$parse_param->vars['number_of_local_variables'][$current_function_number] = 1;
		}
	
		if ($found)
			$already_defined = true;
		else
			$already_defined = false;
		
		return ($current_function_number);
	}
	
	
	
		//---------------------------------------------------------------------------------------------------------------------
		// Returns true if a function has already been defined	
		//---------------------------------------------------------------------------------------------------------------------

	function function_has_been_defined( &$parse_param, $function_name )
	{
		$found = false;
		
		for ($i=0; $i < $parse_param->vars['number_of_user_functions']; $i++)
		{
			if ($parse_param->vars['function_name'][$i] == $function_name)
				$found = true;
		}
		
		return ($found);
	}

		//---------------------------------------------------------------------------------------------------------------------
		// Push a variable's address onto the stack
		//---------------------------------------------------------------------------------------------------------------------

	function gen_code_push_var_address( &$parse_param, &$ic, &$ic_pos, $current_function_number, $var_name )
	{
		check_var_declaration( $parse_param, $current_function_number, $var_type, $var_name, $number_of_indexes, $is_global );

		if ($is_global)
		{
			if ($parse_param->c_output)
			{
				gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_ABS_ADDR_BASE, $var_name, $var_type );

				if (sleft( $var_type, 6 ) == "array ")
				{
					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST_INT, SIZEOF_VAR );	// first bytes are the size of the array	
					
					gen_code( $parse_param, $ic, $ic_pos, OP_ADD_TO_POINTER, 0 );			
				}
			}
			else
			{
						// first bytes are the size of the array
						
				if (sleft( $var_type, 6 ) == "array ")
					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_ABS_ADDR_BASE, get_variable_offset( $parse_param, $current_function_number, $var_name ) + 1, $var_type );
				else
					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_ABS_ADDR_BASE, get_variable_offset( $parse_param, $current_function_number, $var_name ), $var_type );
			}
		}
		else
			gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_REL_ADDR_BASE, get_variable_offset( $parse_param, $current_function_number, $var_name ), $var_type );
	}
	

		//---------------------------------------------------------------------------------------------------------------------
		// Generate an icode entry
		//---------------------------------------------------------------------------------------------------------------------
			
	function gen_code( &$parse_param, &$ic, &$ic_pos, $op, $value="", $type="", $error_text="" )
	{
		if ($parse_param->show_parse_trace)
			echo "gen code: ".$op.": ".$value."<br>"; 
		
		$ic[$ic_pos]['op'] = $op;
		
		if ($op == OP_PUSH_ABS_ADDR_BASE)
			$ic[$ic_pos]['value'] = (int) $value;
		else		
		if ($op == OP_PUSH_CONST_INT)
			$ic[$ic_pos]['value'] = (int) $value;
		else
		if ($op == OP_PUSH_CONST_DECIMAL)
			$ic[$ic_pos]['value'] = (string) $value;
		else
		if ($op == OP_PUSH_CONST_DOUBLE)
			$ic[$ic_pos]['value'] = (double) $value;
		else
		if ($op == OP_PUSH_CONST_STRING)
			$ic[$ic_pos]['value'] = (string) $value;
		else
		if ($op == OP_PUSH_CONST_BOOL)
			$ic[$ic_pos]['value'] = (string) $value;
		else
		if ($op == OP_PUSH_CONST_BINARY)
			$ic[$ic_pos]['value'] = (string) $value;
		else
		if ($op == OP_PUSH_CONST_DATE)
			$ic[$ic_pos]['value'] = (string) $value;
		else
		if ($op == OP_PUSH_CONST_TIME)
			$ic[$ic_pos]['value'] = (string) $value;
		else
		if ($op == OP_PUSH_CONST_DATETIME)
			$ic[$ic_pos]['value'] = (string) $value;
		else
			$ic[$ic_pos]['value'] = $value;

		$ic[$ic_pos]['type'] = $type;

		$ic[$ic_pos]['error_text'] = $error_text;

		if ($op == OP_JMP || 
			$op == OP_JMP_FALSE ||
			$op == OP_JMP_TRUE ||
			$op == OP_JMP_FALSE_DONT_POP ||
			$op == OP_JMP_TRUE_DONT_POP ||
			$op == OP_POP_JMP_GE ||
			$op == OP_POP_JMP_LE ||
			$op == OP_POP_JMP_GT ||
			$op == OP_POP_JMP_LT)
			$ic[$ic_pos]['text'] = "";
		else
			$ic[$ic_pos]['text'] = $value;

		$ic[$ic_pos]['input_filename'] = $parse_param->current_filename[$parse_param->curr_token_number];

		$ic[$ic_pos]['input_filenumber'] = $parse_param->current_filenumber[$parse_param->curr_token_number];

		$ic[$ic_pos]['line_number'] = $parse_param->current_line_number[$parse_param->curr_token_number];
		
		$ic_pos++;
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Print a semantic error
		//---------------------------------------------------------------------------------------------------------------------
		
	function semantic_error( $error_number, &$parse_param, $text )
	{
		$parse_param->error_occured = true;
		
		if ($parse_param->current_line_number[$parse_param->curr_token_number] != $parse_param->last_error_line)
		{
			echo "Error number: ".$error_number.": Line ".$parse_param->current_line_number[$parse_param->curr_token_number].": ".$parse_param->current_filename[$parse_param->curr_token_number].": ".$text;

			if ($parse_param->command_line_mode)
				echo "\n";
			else
				echo "<br>";
		
			$parse_param->last_error_line = $parse_param->current_line_number[$parse_param->curr_token_number];
		}
		
		if (exit_on_first_error)
			exit();
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Print a syntax error
		//---------------------------------------------------------------------------------------------------------------------
		
	function syntax_error( $error_number, &$parse_param, $text )
	{
		$parse_param->error_occured = true;
		
		if ($parse_param->current_line_number[$parse_param->curr_token_number] != $parse_param->last_error_line)
		{
			echo "Error number: ".$error_number.": Line ".$parse_param->current_line_number[$parse_param->curr_token_number].": ".$parse_param->current_filename[$parse_param->curr_token_number].": ".$text.": ".$parse_param->curr_token_text;

			if ($parse_param->command_line_mode)
				echo "\n";
			else
				echo "<br>";
			
			$parse_param->last_error_line = $parse_param->current_line_number[$parse_param->curr_token_number];
		}
		
		if (exit_on_first_error)
			exit();
		
		next_token( $parse_param );		
	}


	function syntax_warning( $error_number, &$parse_param, $text )
	{
		if ($parse_param->current_line_number[$parse_param->curr_token_number] != $parse_param->last_error_line)
		{
			echo "Warning number: ".$error_number.": Line ".$parse_param->current_line_number[$parse_param->curr_token_number].": ".$parse_param->current_filename[$parse_param->curr_token_number].": ".$text.": ".$parse_param->curr_token_text;

			if ($parse_param->command_line_mode)
				echo "\n";
			else
				echo "<br>";
			
			$parse_param->last_error_line = $parse_param->current_line_number[$parse_param->curr_token_number];
		}
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Returns true if 'text' is a reserved word
		//--------------------------------------------------------------------------------------------------------------------
		
	function is_reserved_word( $text )
	{
		if ($text == "result" ||
			$text == "if" ||
			$text == "while" ||
			$text == "function" ||
			$text == "declare" ||
			$text == "var" ||
			$text == "and" ||
			$text == "mod" ||
			$text == "or" ||
			$text == "mod" ||
			$text == "not" ||
			$text == "else" ||
			$text == "int" ||
			$text == "double" ||
			$text == "string" ||
			$text == "bool" ||
			$text == "decimal" ||
			$text == "binary" ||
			$text == "date" ||
			$text == "time" ||
			$text == "datetime" ||
			$text == "true" ||
			$text == "false" ||
			$text == "const" ||
			$text == "include" ||
			$text == "array" ||
			$text == "builtin" ||
			$text == "type" ||
			$text == "struct" ||
			$text == "for" ||
			$text == "to" ||
			$text == "step" ||
			$text == "link" ||
			$text == "new" ||
			$text == "void" ||
			$text == "variable")
				$stat = true;
		else
			$stat = false;
		
		return ($stat);
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Returns true if the function 'function_name' is a builtin function
		//---------------------------------------------------------------------------------------------------------------------
		
	function is_system_function( &$parse_param, $function_name )
	{
		$builtin_function = false;
		
		for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
		{
			if ($parse_param->vars['function_name'][$j] == $function_name)
				$builtin_function = $parse_param->vars['builtin_function'][$j];
		}						
		
		return ($builtin_function);
	}
	
	
		//---------------------------------------------------------------------------------------------------------------------
		// Functions for returning variable sizes 
		//---------------------------------------------------------------------------------------------------------------------

	function get_type_total_size( &$parse_param, $type )
	{
		if (sleft( $type, 5 ) == 'link ')
		{
			if ($parse_param->c_output)
				$size = SIZEOF_VAR;
			else
				$size = 1;
		}
		else
		if (sleft( $type, 6 ) == 'array ')
		{
			if (strpos( $type, "variable" ) !== false)
			{
				if ($parse_param->c_output)
					$size = 2 * SIZEOF_VAR;
				else
					$size = 2;
			}				
			else
			{
				$s2 = explode( " ", $type );
				
				if ($s2[1] == 'link')
				{
					if ($parse_param->c_output)
						$size = SIZEOF_VAR;
					else
						$size = 1;
				}				
				else
					$size = get_simple_type_size( $parse_param, $s2[1] );
	
				$num_elements = array_type_number_of_elements( $type );

				$size *= $num_elements;

// xx
//				$size++;			// first element, array size
			}
		}
		else
			$size = get_simple_type_size( $parse_param, $type );

//		echo $type.": ".$size."<br>";
		
		return ($size);
	}
	
	
		//---------------------------------------------------------------------------------------------------------------------
		// Returns the size of an array element
		//---------------------------------------------------------------------------------------------------------------------
		
	function get_array_element_size( &$parse_param, $type )
	{
		$stat = false;
		
		if (sleft( $type, 6 ) != 'array ')
			echo "Internal error, type ".$type." is not an array.<br>";
		
		$s2 = explode( " ", $type );
		
		if ($s2[1] == 'link')
		{
			if ($parse_param->c_output)
				$size = SIZEOF_VAR;
			else
				$size = 1;
		}
		else
			$size = get_simple_type_size( $parse_param, $s2[1] );
				
		return ($size);
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Returns the size of the struct type that a link points to
		//---------------------------------------------------------------------------------------------------------------------
		
	function get_link_destination_size( &$parse_param, $type )
	{
		$stat = false;
		
		if (sleft( $type, 5 ) != 'link ')
			echo "Internal error, type ".$type." is not an link type.<br>";
		
		$s2 = explode( " ", $type );
		
		$size = get_simple_type_size( $parse_param, $s2[1] );
				
		return ($size);
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Returns true if 'type' is a simple type 
		//---------------------------------------------------------------------------------------------------------------------
		
	function is_simple_data_type( &$parse_param, $type )
	{
		if ($type == "int" ||
			$type == "decimal" ||
			$type == "double" ||
			$type == "string" ||
			$type == "bool" ||
			$type == "binary" ||
			$type == "date" ||
			$type == "time" ||
			$type == "datetime")
				$stat = true;
		else
				$stat  = false;
			
		return ($stat);
	}
	
			
		//---------------------------------------------------------------------------------------------------------------------
		// Returns the size of a data type or struct type
		//---------------------------------------------------------------------------------------------------------------------
						
	function get_simple_type_size( &$parse_param, $type )
	{
		$size = 0;
		
		if ($type == 'void')
			$size = 0;
		else
		if ($type == "int" ||
			$type == "decimal" ||
			$type == "double" ||
			$type == "string" ||
			$type == "bool" ||
			$type == "binary" ||
			$type == "date" ||
			$type == "time" ||
			$type == "datetime")
		{
			if ($parse_param->c_output)
				$size = SIZEOF_VAR;
			else
				$size = 1;
		}
		else
		{
			$found = false;
			
			for ($j=0; $j < $parse_param->num_user_defined_types; $j++)
			{
				if ($parse_param->user_defined_types[$j]['type_name'] == $type)
				{
					$size = (int) $parse_param->user_defined_types[$j]['type_size'];
					
					$found = true;
				}
			}
			
			if (! $found)
				echo semantic_error( 233, $parse_param, "Type ".$type." has not been declared." );
		}
				
		return ($size);
	}


		//---------------------------------------------------------------------------------------------------------------------
		// Returns details of a structure item
		//---------------------------------------------------------------------------------------------------------------------
			
	function get_struct_item_details( &$parse_param, $type, $item_name, &$item_type, &$offset )
	{
		$type_found = false;
		
		$found = false;
		
		for ($i=0; $i < $parse_param->num_user_defined_types; $i++)
		{
			if ($parse_param->user_defined_types[$i]['type_name'] == $type)
			{
				$type_found = true;
				
				if ($parse_param->user_defined_types[$i]['num_items'] == 0)
					semantic_error( 213, $parse_param, "Type ".$type." is not a struct type" );
				else
				{
					for ($j=0; $j < $parse_param->user_defined_types[$i]['num_items']; $j++)
					{
						if ($parse_param->user_defined_types[$i]['item_name'][$j] == $item_name)
						{
							$offset = $parse_param->user_defined_types[$i]['offset'][$j];
	
							$item_type = $parse_param->user_defined_types[$i]['item_type'][$j];
							
							$found = true;
						}
					}
				}
			}
		}

		if (! $type_found)
			echo semantic_error( 233, $parse_param, "Type ".$type." has not been declared." );
		else
		if (! $found)
			echo semantic_error( 232, $parse_param, "Type ".$type." does not contain an item ".$item_name );
	}

		
		//---------------------------------------------------------------------------------------------------------------------
		// Returns true if the token is a data type, including the type size 
		//---------------------------------------------------------------------------------------------------------------------
	
	function is_data_type( &$parse_param, $tok, $type, &$size )
	{
		$stat = false;
		
		$size = 0;
		
		if ($tok == TOK_INT ||
			$tok == TOK_DOUBLE ||
			$tok == TOK_STRING ||
			$tok == TOK_BOOL ||
			$tok == TOK_DECIMAL ||
			$tok == TOK_BINARY ||
			$tok == TOK_DATE ||
			$tok == TOK_TIME ||
			$tok == TOK_DATETIME)
		{
			$stat = true;
		}
		else
		{
			for ($j=0; $j < $parse_param->num_user_defined_types; $j++)
			{
				if ($parse_param->user_defined_types[$j]['type_name'] == $type)
					$stat = true;
			}
		}
		
		if ($stat)
			$size = get_simple_type_size( $parse_param, $type );
		
		return ($stat);
	}
	
	
		//---------------------------------------------------------------------------------------------------------------------
		// Returns the offset of a global, local or function parameter variable
		//---------------------------------------------------------------------------------------------------------------------
 	
	function get_variable_offset( &$parse_param, $current_function_number, $var_name )
	{
		$offset = 0;
		
		$found = false;
		
		if ($parse_param->in_function)
		{
			for ($i=0; $i < $parse_param->vars['number_of_function_arguments'][$current_function_number]; $i++)
			{
	    		if ($parse_param->vars['function_arguments'][$current_function_number][$i]['name'] == $var_name)
				{
					$offset = $parse_param->vars['function_arguments'][$current_function_number][$i]['offset'];
				
					$found = true;
				}
			}
			
			if (! $found)
			{
				for ($i=0; $i < $parse_param->vars['number_of_local_variables'][$current_function_number]; $i++)
				{
					if ($parse_param->vars['local_variables'][$current_function_number][$i]['name'] == $var_name)
					{
						$offset = $parse_param->vars['local_variables'][$current_function_number][$i]['offset'];
						
						$found = true;
					}
				}
			}
		}

		if (! $found)
		{
			for ($i=0; $i < $parse_param->vars['number_of_global_variables']; $i++)
			{
				if ($parse_param->vars['global_variables'][$i]['name'] == $var_name)
				{
					$offset = $parse_param->vars['global_variables'][$i]['offset'];
				}
			}
		}
		
		return ($offset);
	}



	function get_const_push_op( $type )
	{
		$op = "";
		
		if ($type == "int")			$op = OP_PUSH_CONST_INT;			else
		if ($type == "decimal")		$op = OP_PUSH_CONST_DECIMAL;		else
		if ($type == "double")		$op = OP_PUSH_CONST_DOUBLE;			else
		if ($type == "string")		$op = OP_PUSH_CONST_STRING;			else
		if ($type == "bool")		$op = OP_PUSH_CONST_BOOL;			else
		if ($type == "binary")		$op = OP_PUSH_CONST_BINARY;			else
		if ($type == "date")		$op = OP_PUSH_CONST_DATE;			else
		if ($type == "time")		$op = OP_PUSH_CONST_TIME;			else
		if ($type == "datetime")	$op = OP_PUSH_CONST_DATETIME;
		
		return ($op);
	}	

	
	function check_for_expected_token( $parse_param, $exp_tok, $error_number, $text )
	{
		if ($parse_param->curr_tok != $exp_tok)
			syntax_error( $error_number, $parse_param, $text );
	}
		
		//---------------------------------------------------------------------------------------------------------------------
		// Generate code to promote numeric values to equal levels
		//---------------------------------------------------------------------------------------------------------------------
			
	function promote_numeric_type( &$parse_param, &$ic, &$ic_pos, $type1, $type2 )
	{
		if ($parse_param->c_output)
			$mult = SIZEOF_VAR;
		else
			$mult = 1;
		
		if ($type1 == "double" && $type2 == "double")
			$type = "double";
		else
		if ($type1 == "decimal" && $type2 == "decimal")
			$type = "decimal";
		else
			$type = "int";
			
		if ($type1 == "double" && $type2 != "double")
		{
			if ($type2 == 'decimal')
				gen_code( $parse_param, $ic, $ic_pos, OP_CONV_DECIMAL_TO_DOUBLE, 1 * $mult );
			else
				gen_code( $parse_param, $ic, $ic_pos, OP_CONV_INT_TO_DOUBLE, 1 * $mult );
				
			$type = "double";
		}
		else
		if ($type2 == "double" && $type1 != "double")
		{
			if ($type1 == 'decimal')
				gen_code( $parse_param, $ic, $ic_pos, OP_CONV_DECIMAL_TO_DOUBLE, 2 * $mult );
			else
				gen_code( $parse_param, $ic, $ic_pos, OP_CONV_INT_TO_DOUBLE, 2 * $mult );
			
			$type = "double";
		}

		else		
		if ($type1 == "decimal" && $type2 != "decimal")
		{
			gen_code( $parse_param, $ic, $ic_pos, OP_CONV_INT_TO_DECIMAL, 1 * $mult );
				
			$type = "decimal";
		}
		else
		if ($type2 == "decimal" && $type1 != "decimal")
		{
			gen_code( $parse_param, $ic, $ic_pos, OP_CONV_INT_TO_DECIMAL, 2 * $mult );
			
			$type = "decimal";
		}
		
		return ($type);
	}



	function type_matches_array_reference_function_call( $type1, $type2 )
	{
		$stat = false;
		
		if (sleft( $type1, 6 ) == "array " && sleft( $type2, 6 ) == "array ")
		{
			$stype1 = explode( $type1, " " );
			$stype2 = explode( $type2, " " );
			
			$num_items1 = count( $stype1 );
			$num_items2 = count( $stype2 );
			
			if (is_numeric( $stype1[$num_items1-1] ))
				$num_items1--;
			
			if (is_numeric( $stype2[$num_items2-1] ))
				$num_items2--;
			
			$s1 = "array ";
			
			for ($i=1; $i < $num_items1; $i++)
				$s1 .= $stype1[$i];

			$s2 = "array ";
			
			for ($i=1; $i < $num_items2; $i++)
				$s2 .= $stype2[$i];
			
			if ($s1 == $s2)
				$stat = true;
		}
		else
		if ($type1 == $type2)
			$stat = true;

		return ($stat);			
	}

		//---------------------------------------------------------------------------------------------------------------------
		// Returns the type of an array's elements, a one-word type or 'link <struct-type>'
		//---------------------------------------------------------------------------------------------------------------------
			
	function array_element_type( &$parse_param, $type )
	{
		$element_type = "";
		
		if (sleft( $type, 6 ) == 'array ')
		{
			$type2 = explode( " ", $type );
		
			if ($type2[1] == 'link')
				$element_type = 'link '.$type2[2];
			else
				$element_type = $type2[1];
		}
		else
			semantic_error( 217, $parse_param, "Not an array type: ".$type );
			
		return ($element_type);
	}
	
	
	function is_numeric_type( $type )
	{
		if ($type 				== "double" || 
			sleft( $type, 7 ) 	== "double_" ||
			$type 				== "decimal" || 
			sleft( $type, 8 ) 	== "decimal_" || 
			$type 				== "int" ||
			sleft( $type, 4 )	== "int_")
				$stat = true;
		else
			$stat = false;
			
		return ($stat);
	}

?>